// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Agent.java 3.4 99/03/12 SMI"

import java.util.*;
import java.net.*;

import	com.sun.jaw.reference.agent.cmf.*;
import	com.sun.jaw.reference.common.*;
import	com.sun.jaw.reference.agent.services.*;

/**
 * The Agent class provides an implementation of a simple Java Dynamic Management
 * agent using IIOP adaptor. It provides a single framework for
 * the management of applications and system resources on a host machine.
 *
 * An agent implemented by the Agent class initializes
 * the services that a Java Dynamic Management agent must provide:
 *      - M-bean repository service
 *      - Metadata service
 *
 * In addition, the agent starts these managed object adaptor servers:
 *      - HTML adaptor
 *      - IIOP adaptor
 * 
 * The default IIOP URL of the adaptor is
 * iiop://[hostname]:8085/com.sun.jaw.impl.adaptor.iiop.AdaptorServerImpl
 *
 * You have to extend an agent implemented by the Agent class to
 * enable the agent to restart the non persistent services that can be
 * dynamically added to it. To extend an agent in this way, you use a
 * configuration file.
 *
 * @version     3.4     03/12/99
 * @author      Sun Microsystems, Inc
 */

public class Agent {
  
    static Framework cmf;
    static String	 domain;
    MetaDataSrvIf    mtdSrv;
    String           mtdName;
    String           adpNameIiop;
    String           adpNameHtml;
  
    /**
     * The main method does not allow you to specify command-line
     * parameters. However, it does allow you to specify the trace level
     * by using the DEBUG properties.
     * For more information on trace levels, refer to Debug object.
     */
    public static void main(String args[]) {
        
        Debug.parseDebugProperties();

        // ------------
        // Create the Agent object
        // ------------
        Agent f = new Agent();
    }
  
    /**
     * Returns the Framework.
     */
    static public Framework getFramework() {
        return cmf;
    }
  
    /**
     * Constructor: Just start a thread
     */
    public Agent() {
        run();
    }
  
    /**
     * Start a thread
     */
    private void run() {
        
        // ------------
        // Debugging option
        // ------------
        Debug.setOn(Debug.ADP_DEBUG);
        Debug.setOn(Debug.EXCPT_DEBUG);

        // ------------
        // Get properties
        // ------------
        Properties p= System.getProperties();
      
        // ------------
        // Host configuration
        // ------------
        String host;
        if ((host= System.getProperty("HOST")) == null) {
            try {
                host= InetAddress.getLocalHost().getHostName();
            }
            catch(Exception e) {
                Debug.printException(e);
                usage();
                System.exit(1);
            }
        }

        // ------------
        // Port configuration
        // ------------
        String portName;
        int port = 8085 ;
        if ((portName= System.getProperty("PORT")) != null) {
            try {
                port= Integer.parseInt(portName);
            }
            catch(Exception e) {
                Debug.printException(e);
                usage();
                System.exit(1);
            }
        }

        // ------------
        // IIOP name configuration
        // ------------
        String logicalName;
        if ((logicalName= System.getProperty("NAME")) == null) {
            logicalName= defaultName;
        }

        // ------------
        // default service name
        // ------------
        mtdName     = "com.sun.jaw.impl.agent.services.light.MetaDataSrv";
        adpNameIiop = "com.sun.jaw.impl.adaptor.iiop.AdaptorServerImpl";
        adpNameHtml = "com.sun.jaw.impl.adaptor.html.AdaptorServerImpl";
    
        // ------------
        // Add repository service
        // ------------
        try {
            cmf    = new Framework();

            Debug.println("Repository configuration done");

            // ------------
            // Get domain
            // ------------
            domain = cmf.getDomain();
            Debug.println("Got domain = " + domain);
      
            // ------------
            // See if we already have a MetaDataService in case of
            // persistent repository.
            // ------------
            try {
                mtdSrv = cmf.getMetaDataSrvIf();
                if (mtdSrv == null) {
                    Debug.println("Metadata service not found, " + "adding " + mtdName);
                    cmf.newObject(mtdName, domain + ":" + ServiceName.META, null);
                }
                else {
                    Debug.println("Found a metadata service.");
                    cmf.setMetaDataSrvIf(mtdSrv);
                }
            }
            catch (IllegalAccessException e) {
                System.err.println("Cannot check for metadata service");
                e.printStackTrace();
            }
            catch (ServiceNotFoundException e) {
                System.err.println("Cannot check for metadata service");
                e.printStackTrace();
            }
      
            // ------------
            // Add the IIOP adaptor service.
            // ------------
            String iiopName = new String(	domain + ":" +
                                            "com.sun.jaw.impl.adaptor.iiop.AdaptorServerImpl" +
                                            ".protocol=" +"iiop"+
                                            ",port="     + port +
                                            ",host="     + host +
                                            ",service="  + logicalName);
            Debug.println("Adding " + adpNameIiop + " to CMF with name \n\t" + iiopName);
            cmf.newObject(adpNameIiop, iiopName, null);
      
            // ------------
            // Add the HTML adaptor service.
            // ------------
            String htmlName = new String(	domain + ":" +
                                            "com.sun.jaw.impl.adaptor.html.AdaptorServerImpl" +
                                            ".protocol=" +"html"+
                                            ",port=8082") ;
            Debug.println("Adding " + adpNameHtml + " to CMF with name \n\t" + htmlName);
            cmf.newObject(adpNameHtml, htmlName, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }


    // PRIVATE METHODS
    //----------------
    private static void usage() {
        System.out.println("\nUsage: java -DHOST=<hostname> -DPORT=<port> -NAME=<name> Agent");
        System.out.println("\t<hostname> is name of the server");
        System.out.println("\t<port> is port number to use");
        System.out.println("\t<name> is logical name of server to use");
    }

    // ------------
    // Default IIOP server name
    // ------------
    private static String defaultName="com.sun.jaw.impl.adaptor.iiop.AdaptorServerImpl";
}

