// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)TextSample.java 3.3 99/03/12 SMI"

// The two following import are used to register this bean
// the the framework of Java Dynamic Management.
//
import	com.sun.jaw.reference.agent.cmf.*;
import	com.sun.jaw.reference.common.*;

/** 
 * The TextSample shows how the BeanBox can be used to generate an agent.
 * This class is an element of the final agent.
 * And Every bean can be integrated by including the two import lines
 * 
 * import	com.sun.jaw.reference.agent.cmf.*;
 * import	com.sun.jaw.reference.common.*;
 *
 * and this part of java code in their contructor
 * 
 * try {
 *  ((Framework)AgentMain.getFramework()).addObject((Object)this, 
 *              new ObjectName(((Framework)AgentMain.getFramework()).getDomain()+":TextSample"));
 * } catch (Exception e) {
 *   e.printStackTrace();
 * }
 *
 * @version     1.5     12/08/97
 * @author      Sun Microsystems, Inc
 */

public class TextSample implements java.io.Serializable {
  
    String theText;
  
    /**
     * Initialize the string to manage and register the class to the agent framework.
     */
    public TextSample() {
        
        theText = new String("");
	
        // Register this to the framework of Java Dynamic Management
        try {
            ((Framework)AgentMain.getFramework()).addObject((Object)this, new ObjectName(((Framework)AgentMain.getFramework()).getDomain()+":TextSample"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        // end of regitration
    }
  
    /**
     * Returns the value of String.
     */
    public String getText() { 
        return theText;
    }
  
    /**
     * Enables the value of String to be set.
     */
    public void setText(String value) { 
        theText = value;
    }
}
