// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)AgentMain.java 3.5 99/03/12 SMI"

import java.util.*;

import	com.sun.jaw.reference.agent.cmf.*;
import	com.sun.jaw.reference.common.*;
import	com.sun.jaw.reference.agent.services.*;

/**
 * The AgentMain class provides a sample agent designed to
 * be put in a jar file and then loaded into the BeanBox application.
 * This agent will be able to serve every bean instantiated in the BeanBox 
 * which contain the following registration lines in their constructor:
 * 
 * try {
 *  ((Framework)AgentMain.getFramework()).addObject((Object)this, 
 *              new ObjectName(((Framework)AgentMain.getFramework()).getDomain()+":TextSample"));
 * } catch (Exception e) {
 *   e.printStackTrace();
 * }
 * 
 * An example of a such bean is provided in TextSample.java source file.
 * The AgentMain must be the first element added in the BeanBox. Then, the other elements
 * can register themself to the AgentMain. 
 * In addition, the agent starts these managed object adaptor servers: 
 *      - RMI adaptor
 *      - HTML adaptor
 * 
 * To manage the agent through a Web browser, point the Web browser at
 *      http://hostname:8082
 *
 * @version     3.5     03/12/99
 * @author      Sun Microsystems, Inc
 */

public class AgentMain implements java.io.Serializable {
  
    static Framework cmf;
    static String	 domain;
    MetaDataSrvIf    mtdSrv;
    String           mtdName;
    String           adpNameHtml;
    String           adpNameRmi;
  
    /**
     * The main method does not allow you to specify command-line
     * parameters. However, it does allow you to specify the trace level
     * by using the DEBUG properties.
     * For more information on trace levels, refer to Debug object.
     */
  
    public static void main(String args[]) {
        Debug.parseDebugProperties();
        Debug.println("Default debug is on");
        AgentMain f = new AgentMain();
    }
  
    /**
     * Returns the Framework.
     */
    static public Framework getFramework() {
        return cmf;
    }
  
    public AgentMain() {
        run();
    }
  
    private void run() {
    
        mtdName     = "com.sun.jaw.impl.agent.services.light.MetaDataSrv";
        adpNameRmi  = "com.sun.jaw.impl.adaptor.rmi.AdaptorServerImpl";
        adpNameHtml = "com.sun.jaw.impl.adaptor.html.AdaptorServerImpl";

        try {
            Debug.println("Repository configuration done");
	    
            cmf    = new Framework();
            domain = cmf.getDomain();
	        
            Debug.println("Got domain = " + domain);
      
            // See if we already have a MetaDataService in case of
            // persistent repository.
            //
            try {
                mtdSrv = cmf.getMetaDataSrvIf();
                if (mtdSrv == null) {
                    Debug.println("Metadata service not found, " +
                                  "adding " + mtdName);
	  
                    cmf.newObject(mtdName, domain + ":" + ServiceName.META, null);
                }
                else {
                    Debug.println("Found a metadata service.");
                    cmf.setMetaDataSrvIf(mtdSrv);
                }
            } catch (IllegalAccessException e) {
                System.err.println("Cannot check for metadata service");
                e.printStackTrace();
            } catch (ServiceNotFoundException e) {
                System.err.println("Cannot check for metadata service");
                e.printStackTrace();
            }
      
            // Add the RMI adaptor service
            //
            String rmiName= new String(domain + ":" + ServiceName.ADAPTOR + ".protocol=rmi,port=1099");
            Debug.println("Adding " + adpNameRmi + " to CMF with name \n\t" + rmiName);
            cmf.newObject(adpNameRmi, rmiName, null);
	  
            // Add the HTML adaptor service.
            //
            String htmlName = new String(domain + ":" + ServiceName.ADAPTOR + ".protocol=html,port=8082");
            Debug.println("Adding " + adpNameHtml + " to CMF with name \n\t" + htmlName);
            cmf.newObject(adpNameHtml, htmlName, null);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}

