// Copyright (c) 03/12/99, by Sun Microsystems, Inc.
// All rights reserved.

// "@(#)Agent.java 3.4 99/03/12 SMI"

import java.util.*;
import java.lang.reflect.*;

// jaw import
//
import com.sun.jaw.reference.agent.cmf.*;
import com.sun.jaw.reference.common.*;
import com.sun.jaw.reference.agent.services.*;

import com.sun.jaw.impl.agent.services.light.*;

/**
 * This class provides a simple example on how to use the framework.
 *
 * @version     3.4     03/12/99
 * @author      Sun Microsystems, Inc
 *
 */


public class Agent {

    /**
     * In order to initialize the agent, implementation names of the
     * different services required by the Common Management Framework
     * must be provided.
     *
     * @param <VAR>repImplName</VAR> name of the repository implementation
     * @param <VAR>filImplName</VAR> name of the filtering implementation
     * @param <VAR>metImplName</VAR> name of the metadata implementation
     * @exception ClassNotFoundException The specified class could not be found.
     * @exception IllegalAccessException The method has tried to access a class that is not public and in another package.
     * @exception InstanceAlreadyExistException The m-bean is already registered in the repository.
     * @exception InvocationTargetException It is a checked exception that wraps an exception thrown by an invoked method or constructor.
     * @exception InstantiationException A new instance of the specified class could not be created.
     * @exception ServiceNotFoundException The requested service is not supported.
     */
    public Agent(String filImplName, String metImplName) 
        throws ClassNotFoundException, IllegalAccessException, 
               InstanceAlreadyExistException, InvocationTargetException,
               InstantiationException, ServiceNotFoundException {

        // Create the core management framework and 
        // enable its initialization.
        //
        trace("Create and initialize the framework. \nEnabling m-beans to obtain information on \nand control other m-beans in this framework.\n");
        framework = new Framework();

        // Get the domain name of the framework.
        // The domain name is going to be used for naming the objects.
        //
        String domain= framework.getDomain();

        // Initialize a metadata and filtering service
        //
        trace("Add a metadata service under control of the framework. \nThis enables the framework and m-beans to obtain \nmeta information on other m-beans.\n");
        framework.newObject(metImplName, domain + ":" + ServiceName.META, null);
        trace("Add a filter service under control of the framework. \nEnabling the framework and m-beans to evaluate \nqueries applied to a set of m-beans.\n");
        framework.newObject(filImplName,  domain + ":" + ServiceName.FILTER, null);
    }	


    /**
     * The method performs a number of local tests on the agents.
     * @exception Exception No comment.
     */
    public void localTest() throws Exception {
	
        Vector		result = null;
        Object		value = null;

        trace("\nStart internal testing of the agent");
        trace("-----------------------------------\n");

        // Query the framework in order to retrieve the objects
        //
        trace("\tTest 1: Get all the objects known by the agent");
        result = framework.getObject(null,null) ;
        trace("\t\tGot " + result.size() + " elements");
       
        ObjectName name = new ObjectName(framework.getDomain(),ServiceName.FRAME);
        trace("\tTest 2: Get objects with name " + name.toString());
        result = framework.getObject(name,null) ;
        trace("\t\tGot " + result.size() + " element");

        trace("\tTest 3: Retrieve framework and query NbElements and Domain");
        Object obj = ((NamedObject) result.firstElement()).getObject();
        value = framework.getValue(obj, "NbElements"); 
        trace("\t\tNbElements = " + value.toString());
        value = framework.getValue(obj, "Domain"); 
        trace("\t\tDomain     = " + value.toString());

        trace("\nEnd internal testing of the agent");
        trace("---------------------------------\n");
    }
    

    public static void main(String args[]) {

        if (args.length != 0) {
            usage();
            System.exit(1);
        }

        Debug.parseDebugProperties();

        // Create the agent !
        //
        Agent agent= null;
        try {
            agent= new Agent(defFil, defMet);
        } catch (Exception e) {
            trace("An exception occurs:" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }

        // Perform some local testing
        //
        try {
            agent.localTest();
        } catch (Exception e) {
            Agent.trace("An exception occurs:" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }

        // Initialize an adaptor server to make the agent reachable !
        // We could initialize any number of adaptor servers, each of them
        // could "talk" a different protocol.
        // An adaptor server could also be loaded dynamically in the 
        // agent.
        //
        Agent.trace("Add a RMI adaptor server under control of the framework, \nmaking the agent reachable.\n");
        try {
            agent.framework.newObject("com.sun.jaw.impl.adaptor.rmi.AdaptorServerImpl",  
                                      agent.framework.getDomain() + ":" + ServiceName.APT_RMI, null);
        } catch (Exception e) {
            Agent.trace("An exception occurs:" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }
    }
    

    public static void usage() {
        trace("java Agent");
        trace("If you want debug traces, add the following: ");
        trace("\t-DDEBUG=\"DEBUG_ALL\"");
    }

    // GETTERS AND SETTERS
    //--------------------

    /**
     * Returns the version of this class.
     */
    public String getClassVersion() {
        return (sccs_id);
    }

    // PRIVATE METHODS
    //----------------

    /**
     * Display trace messages.
     */
    private static void trace(String msg) {
        System.out.println(msg);
    }

    // PRIVATE VARIABLES
    //------------------

    /**
     * Framework 
     */
    private Framework framework;

    /**
     * Version of the implementation
     */
    private static final String sccs_id = "@(#)Agent.java 3.4 03/12/99 SMI";

    /**
     * Default implementation name for the basic services required by the
     * framework.
     */
    private static final String defMet="com.sun.jaw.impl.agent.services.light.MetaDataSrv";
    private static final String defFil="com.sun.jaw.impl.agent.services.light.FilterSrv";
}
