/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sims.admin.cli;

import COM.Sun.sunsoft.sims.avm.base.Sort;
import com.sun.sims.admin.cli.InvalidOptionException;
import com.sun.sims.admin.cli.NullObject;
import java.util.Hashtable;
import java.util.Vector;

public class GetOpts {
    static final String sccs_id = "@(#)GetOpts.java\t1.6\t10/27/98 SMI";
    public static final String DEF_OPT_PREFIX = "-";
    private static final String ARG_INDICATOR = ":";
    private static final byte notOptType = -1;
    private static final byte argType = 0;
    private static final byte noArgType = 1;
    private static final byte illegalOptType = 2;
    private static final byte separateType = 3;
    private boolean ignoreUnknownOpts;
    private String optPrefix;
    private Hashtable optTable;
    private Hashtable pushBack;
    private String[] optList;
    private String[] split;

    public String getClassVersion() {
        return sccs_id;
    }

    public GetOpts(String[] opts, boolean ignore) {
        this.ignoreUnknownOpts = ignore;
        this.optList = opts;
        Sort.quickSort((Object[])this.optList);
        this.optPrefix = DEF_OPT_PREFIX;
        this.optTable = new Hashtable();
        this.pushBack = new Hashtable();
        this.split = new String[2];
    }

    public GetOpts(String[] opts) {
        this(opts, false);
    }

    public String[] parseOpts(String[] argv) throws InvalidOptionException {
        int sz;
        Vector<String> pushBack = new Vector<String>();
        int lopt = -1;
        boolean argOk = false;
        if (argv != null) {
            int i = 0;
            while (i < argv.length) {
                switch (this.getType(argv[i])) {
                    case 3: {
                        String[] nargs = new String[argv.length - i + 1];
                        nargs[0] = this.split[0];
                        nargs[1] = this.split[1];
                        int k = 2;
                        int j = i + 1;
                        while (j < argv.length) {
                            nargs[k++] = argv[j];
                            ++j;
                        }
                        return this.parseOpts(nargs);
                    }
                    case 0: {
                        lopt = i;
                        argOk = true;
                        this.setSwitch(this.stripPrefix(argv[i]));
                        break;
                    }
                    case 1: {
                        this.setSwitch(this.stripPrefix(argv[i]));
                        if (!argOk) break;
                        argOk = false;
                        break;
                    }
                    case 2: {
                        if (this.ignoreUnknownOpts) {
                            pushBack.addElement(argv[i]);
                            break;
                        }
                        throw new InvalidOptionException(argv[i]);
                    }
                    default: {
                        if (argOk) {
                            this.setOpt(this.stripPrefix(argv[lopt]), argv[i]);
                            argOk = false;
                            break;
                        }
                        pushBack.addElement(argv[i]);
                        break;
                    }
                }
                ++i;
            }
        }
        if ((sz = pushBack.size()) > 0) {
            Object[] rejects = new String[sz];
            pushBack.copyInto(rejects);
            return rejects;
        }
        return null;
    }

    public String getArg(String opt) {
        Object o = this.optTable.get(opt);
        if (o != null && !(o instanceof NullObject)) {
            return (String)o;
        }
        return null;
    }

    public boolean isOpt(String opt) {
        return this.optTable.containsKey(opt);
    }

    public void setOpt(String opt, String val) {
        this.optTable.put(opt, val);
    }

    public void setSwitch(String opt) {
        this.optTable.put(opt, new NullObject());
    }

    public String getOptPrefix() {
        return this.optPrefix;
    }

    public void setOptPrefix(String pre) {
        this.optPrefix = pre;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.optList.length) {
            String oName = this.getOptName(this.optList[i]);
            buf.append(oName);
            buf.append(": ");
            if (this.isOpt(oName)) {
                String arg = this.getArg(oName);
                if (arg == null) {
                    buf.append("<true>");
                } else {
                    buf.append(arg);
                }
            } else {
                buf.append("<false>");
            }
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    private boolean takesArg(String optListEntry) {
        return optListEntry.endsWith(ARG_INDICATOR);
    }

    private String getOptName(String optListEntry) {
        if (this.takesArg(optListEntry)) {
            return optListEntry.substring(0, optListEntry.indexOf(ARG_INDICATOR));
        }
        return optListEntry;
    }

    private String stripPrefix(String opt) {
        return opt.substring(this.optPrefix.length());
    }

    private byte getType(String opt) {
        if (opt.startsWith(this.optPrefix)) {
            String oName = this.stripPrefix(opt);
            if (oName.equals("")) {
                return -1;
            }
            int i = this.optList.length - 1;
            while (i >= 0) {
                String optName = this.getOptName(this.optList[i]);
                if (optName.equals(oName)) {
                    if (this.takesArg(this.optList[i])) {
                        return 0;
                    }
                    return 1;
                }
                if (oName.startsWith(optName)) {
                    if (this.takesArg(this.optList[i])) {
                        this.split[0] = String.valueOf(this.optPrefix) + optName;
                        this.split[1] = oName.substring(optName.length());
                        return 3;
                    }
                    this.split[0] = String.valueOf(this.optPrefix) + oName.charAt(0);
                    this.split[1] = String.valueOf(this.optPrefix) + oName.substring(1);
                    return 3;
                }
                --i;
            }
            return 2;
        }
        return -1;
    }
}

