/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sims.admin.cli;

import COM.Sun.sunsoft.sims.admin.ds.AddOrganizationalUnitDialog;
import COM.Sun.sunsoft.sims.admin.ds.DSAttr;
import COM.Sun.sunsoft.sims.admin.ds.DSContentManager;
import COM.Sun.sunsoft.sims.admin.ds.DSEntry;
import COM.Sun.sunsoft.sims.admin.ds.DSRequest;
import COM.Sun.sunsoft.sims.admin.ds.DSResult;
import COM.Sun.sunsoft.sims.admin.ds.StatusPanel;
import com.sun.sims.admin.cli.CLIDSContentManagerImpl;
import com.sun.sims.admin.cli.CLIDSSearchException;
import com.sun.sims.admin.cli.CLIDescAttrMap;
import com.sun.sims.admin.cli.CLIInteractive;
import com.sun.sims.admin.cli.CLIObject;
import com.sun.sims.admin.cli.CLIValidOptions;
import com.sun.sims.admin.cli.ImAdmin;
import com.sun.sims.admin.cli.InvalidOptionException;
import com.sun.sims.admin.cli.MissingOptionException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class CLIOrg
extends CLIObject {
    static final String sccs_id = "@(#)CLIOrg.java\t1.12\t11/02/98 SMI";
    private String[][] validAddOptionsArray;
    private String[][] validDeleteOptionsArray;
    private String[][] validModifyOptionsArray;
    private String[][] validSearchOptionsArray;
    private boolean printBlankLine;

    public String getClassVersion() {
        return sccs_id;
    }

    public CLIOrg() {
        block2: {
            this.validAddOptionsArray = new String[][]{{"D", "true", "", "true", "true", "OrgOptDesc_D"}, {"X", "true", "localhost", "false", "true", "GroupOptDesc_alternatehost"}, {"maildomain", "true", "", "true", "true", "OrgOptDesc_maildomain"}, {"orgname", "true", "", "true", "true", "OrgOptDesc_orgname"}, {"p", "true", "389", "false", "true", "ObjectOptDesc_ldapport"}, {"w", "true", "", "true", "false", "OrgOptDesc_w"}};
            this.validDeleteOptionsArray = new String[][]{{"D", "true", "", "true", "true", "OrgOptDesc_D"}, {"X", "true", "localhost", "false", "true", "GroupOptDesc_alternatehost"}, {"orgname", "true", "", "true", "true", "OrgOptDesc_orgname"}, {"p", "true", "389", "false", "true", "ObjectOptDesc_ldapport"}, {"w", "true", "", "true", "false", "OrgOptDesc_w"}};
            this.validModifyOptionsArray = new String[0][];
            this.validSearchOptionsArray = new String[][]{{"D", "true", "", "false", "true", "OrgOptDesc_D"}, {"X", "true", "localhost", "false", "true", "GroupOptDesc_alternatehost"}, {"maildomain", "true", null, "false", "true", "OrgOptDesc_maildomain"}, {"orgname", "true", null, "false", "true", "OrgOptDesc_orgname"}, {"p", "true", "389", "false", "true", "ObjectOptDesc_ldapport"}, {"w", "true", "", "false", "false", "OrgOptDesc_w"}};
            this.printBlankLine = false;
            this.daMap = new CLIDescAttrMap();
            if (ImAdmin.getDebugLevel() >= 512) break block2;
            try {
                this.ds = new CLIDSContentManagerImpl();
            }
            catch (RemoteException remoteException) {}
        }
    }

    private String ouSearch(String orgname) throws CLIDSSearchException {
        String filter = "(&(ou=" + orgname + ")(!(objectStatus=deleted)))";
        if (this.ds != null) {
            int handle = 0;
            handle = this.ds.search(2, filter, null);
            if (handle == -1) {
                throw new CLIDSSearchException();
            }
            DSResult result = null;
            result = this.ds.getResult(handle);
            if (result == null) {
                return "";
            }
            this.ds.abandon(handle);
            return ((DSEntry)result.elements().nextElement()).getName();
        }
        return "";
    }

    private void ouPrint(DSEntry ouEntry) {
        if (this.printBlankLine) {
            CLIInteractive.printResult((String)"");
        } else {
            this.printBlankLine = true;
        }
        CLIInteractive.printResult((String)("dn: " + ouEntry.getName()));
        DSAttr[] attrs = ouEntry.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                String[] values = attrs[i].getValues();
                if (values != null) {
                    int j = 0;
                    while (j < values.length) {
                        CLIInteractive.printResult((String)(String.valueOf(attrs[i].getName()) + ": " + values[j]));
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void printNode(DSEntry[] ou, String[] attr) throws CLIDSSearchException {
        if (ou == null) {
            return;
        }
        Object[] subnodes = null;
        int i = 0;
        while (i < ou.length) {
            this.ouPrint(ou[i]);
            int handle = 0;
            handle = this.ds.search(ou[i].getName(), 1, "(objectclass=organizationalunit)", attr);
            if (handle == -1) {
                throw new CLIDSSearchException();
            }
            DSResult result = null;
            Vector<DSEntry> resultVector = new Vector<DSEntry>();
            while ((result = this.ds.getResult(handle)) != null) {
                Enumeration en = result.elements();
                while (en.hasMoreElements()) {
                    DSEntry entry = (DSEntry)en.nextElement();
                    if (ou[i].getName().equals(entry.getName().trim().toLowerCase())) continue;
                    resultVector.addElement(entry);
                }
            }
            if (resultVector.size() != 0) {
                subnodes = new DSEntry[resultVector.size()];
                resultVector.copyInto(subnodes);
                this.printNode((DSEntry[])subnodes, attr);
            }
            ++i;
        }
    }

    private String getDC(String domainStr) {
        String subString = domainStr;
        int begIndex = 0;
        int endIndex = 0;
        String dcStr = "dc=";
        while ((endIndex = subString.indexOf(46, begIndex)) != -1) {
            dcStr = String.valueOf(dcStr) + subString.substring(begIndex, endIndex) + ", dc=";
            begIndex = endIndex + 1;
        }
        dcStr = String.valueOf(dcStr) + subString.substring(begIndex, subString.length());
        return dcStr;
    }

    private int deleteNode(String[] dn) {
        int status = 0;
        if (dn == null) {
            return 0;
        }
        Object[] subnodes = null;
        int i = 0;
        while (i < dn.length) {
            String[] currentDN;
            Enumeration en;
            DSEntry entry;
            DSAttr attr;
            DSResult dcResult;
            int handle = 0;
            handle = this.ds.search(dn[i], 1, "(objectclass=*)", null);
            if (handle == -1) {
                return handle;
            }
            DSResult result = null;
            Vector<String> resultVector = new Vector<String>();
            while ((result = this.ds.getResult(handle)) != null) {
                Enumeration en2 = result.elements();
                while (en2.hasMoreElements()) {
                    DSEntry entry2 = (DSEntry)en2.nextElement();
                    if (dn[i].equals(entry2.getName().trim().toLowerCase())) continue;
                    resultVector.addElement(entry2.getName().trim().toLowerCase());
                }
            }
            if (resultVector.size() != 0) {
                subnodes = new String[resultVector.size()];
                resultVector.copyInto(subnodes);
                status = this.deleteNode((String[])subnodes);
                if (status != 0) {
                    return status;
                }
            }
            if ((handle = this.ds.search(dn[i], 0, "(objectclass=*)", null)) != -1 && (dcResult = this.ds.getResult(handle)) != null && (attr = (entry = (DSEntry)(en = dcResult.elements()).nextElement()).getAttribute("associatedDomain")) != null) {
                String[] dc = attr.getValues();
                dc[0] = this.getDC(dc[0]);
                status = this.ds.delete(dc);
                if (status != 0) {
                    return status;
                }
            }
            if ((status = this.ds.delete(currentDN = new String[]{dn[i]})) != 0) {
                return status;
            }
            ++i;
        }
        return status;
    }

    public int add(String[] argv) throws InvalidOptionException, MissingOptionException {
        this.validOptions = new CLIValidOptions(this.validAddOptionsArray);
        if (ImAdmin.getPrintUsage()) {
            return 0;
        }
        AddOrganizationalUnitDialog od = null;
        od = this.ds != null ? new AddOrganizationalUnitDialog((DSContentManager)this.ds, this.ds.getSession(), new StatusPanel()) : new AddOrganizationalUnitDialog(null, null, new StatusPanel());
        this.optionValues = this.validOptions.getDefaultValues();
        this.parseOptionValues(argv);
        this.missingRequired = true;
        while (this.missingRequired) {
            this.missingRequired = false;
            this.promptMissingValues();
            int index = 0;
            index = this.validOptions.indexOf("maildomain");
            od.setMailDomain(this.optionValues[index]);
            if (!od.checkMailDomain(this.optionValues[index])) {
                this.invalidValue(index);
            }
            index = this.validOptions.indexOf("orgname");
            od.setOrgUnit(this.optionValues[index]);
        }
        if (this.ds != null) {
            this.ds.setUser(this.optionValues[this.validOptions.indexOf("D")]);
            this.ds.setPassword(this.optionValues[this.validOptions.indexOf("w")]);
            this.ds.setHostName(this.optionValues[this.validOptions.indexOf("X")]);
            this.ds.setHostPort(Integer.valueOf(this.optionValues[this.validOptions.indexOf("p")]).intValue());
        }
        String dcStr = od.getDCStr();
        String contextStr = od.getContextStr();
        DSEntry entry = od.buildDCEntry(dcStr, contextStr);
        DSRequest request = new DSRequest();
        request.addEntry(entry);
        if (this.ds != null && this.ds.add(entry.getName(), request) != 0) {
            CLIInteractive.printError((String)this.res.getString("OrgAddFailed"));
            return 8;
        }
        entry = od.buildOUEntry(contextStr);
        request = new DSRequest();
        request.addEntry(entry);
        if (this.ds != null && this.ds.add(entry.getName(), request) != 0) {
            CLIInteractive.printError((String)this.res.getString("OrgAddFailed"));
            return 8;
        }
        entry = od.buildPeopleEntry(contextStr);
        request = new DSRequest();
        request.addEntry(entry);
        if (this.ds != null && this.ds.add(entry.getName(), request) != 0) {
            CLIInteractive.printError((String)this.res.getString("OrgAddFailed"));
            return 8;
        }
        entry = od.buildGroupsEntry(contextStr);
        request = new DSRequest();
        request.addEntry(entry);
        if (this.ds != null && this.ds.add(entry.getName(), request) != 0) {
            CLIInteractive.printError((String)this.res.getString("OrgAddFailed"));
            return 8;
        }
        entry = od.buildServicesEntry(contextStr);
        request = new DSRequest();
        request.addEntry(entry);
        if (this.ds != null && this.ds.add(entry.getName(), request) != 0) {
            CLIInteractive.printError((String)this.res.getString("OrgAddFailed"));
            return 8;
        }
        return 0;
    }

    public int delete(String[] argv) throws InvalidOptionException, MissingOptionException {
        this.validOptions = new CLIValidOptions(this.validDeleteOptionsArray);
        if (ImAdmin.getPrintUsage()) {
            return 0;
        }
        this.optionValues = this.validOptions.getDefaultValues();
        this.parseOptionValues(argv);
        this.missingRequired = true;
        while (this.missingRequired) {
            this.missingRequired = false;
            this.promptMissingValues();
        }
        if (this.ds != null) {
            this.ds.setUser(this.optionValues[this.validOptions.indexOf("D")]);
            this.ds.setPassword(this.optionValues[this.validOptions.indexOf("w")]);
            this.ds.setHostName(this.optionValues[this.validOptions.indexOf("X")]);
            this.ds.setHostPort(Integer.valueOf(this.optionValues[this.validOptions.indexOf("p")]).intValue());
        }
        if (this.ds != null) {
            String[] dn = new String[1];
            try {
                dn[0] = this.ouSearch(this.optionValues[this.validOptions.indexOf("orgname")]);
            }
            catch (CLIDSSearchException cLIDSSearchException) {
                CLIInteractive.printError((String)this.res.getString("OrgDeleteFailed"));
                return 13;
            }
            if (dn[0].equals("")) {
                CLIInteractive.printError((String)this.res.getString("OrgDeleteNotFound"));
                return 11;
            }
            if (this.deleteNode(dn) != 0) {
                CLIInteractive.printError((String)this.res.getString("OrgDeleteFailed"));
                return 10;
            }
        }
        return 0;
    }

    public int search(String[] argv) throws InvalidOptionException, MissingOptionException {
        this.validOptions = new CLIValidOptions(this.validSearchOptionsArray);
        if (ImAdmin.getPrintUsage()) {
            return 0;
        }
        this.optionValues = this.validOptions.getDefaultValues();
        String[] displayAttr = this.parseOptionValues(argv);
        if (this.ds != null) {
            this.ds.setUser(this.optionValues[this.validOptions.indexOf("D")]);
            this.ds.setPassword(this.optionValues[this.validOptions.indexOf("w")]);
            this.ds.setHostName(this.optionValues[this.validOptions.indexOf("X")]);
            this.ds.setHostPort(Integer.valueOf(this.optionValues[this.validOptions.indexOf("p")]).intValue());
        }
        this.optionValues[this.validOptions.indexOf((String)"D")] = null;
        this.optionValues[this.validOptions.indexOf((String)"w")] = null;
        this.optionValues[this.validOptions.indexOf((String)"X")] = null;
        this.optionValues[this.validOptions.indexOf((String)"p")] = null;
        String filter = this.buildSearchFilter();
        if (this.ds != null) {
            int handle = 0;
            handle = this.ds.search(2, filter, displayAttr);
            if (handle == -1) {
                CLIInteractive.printError((String)this.res.getString("OrgSearchFailed"));
                return 13;
            }
            Vector<DSEntry> matchVector = new Vector<DSEntry>();
            DSResult result = null;
            while ((result = this.ds.getResult(handle)) != null) {
                matchVector.addElement((DSEntry)result.elements().nextElement());
            }
            Object[] match = new DSEntry[matchVector.size()];
            matchVector.copyInto(match);
            try {
                this.printNode((DSEntry[])match, displayAttr);
            }
            catch (CLIDSSearchException cLIDSSearchException) {
                CLIInteractive.printError((String)this.res.getString("OrgSearchFailed"));
                return 13;
            }
        }
        return 0;
    }
}

