(
	:setup_version (300) 
	:has_iiicom (true)
	:groupsobj (groupsobj)
	:templateobj (templateobj)
	:userauthdefault (UserAuthDefault
		:type (auth_user)
		:color ("Navy Blue")
		:action (accept)
		:icon-name ("icon-uauth")
		:src_options ("Intersect with User Database")
		:dst_options ("Intersect with User Database")
		:options (
			:rule_auth_http_allow ("Allow Predefined Servers Only")
		)
	)
	:clntauthdefault (ClntAuthDefault
		:type (auth_client)
		:color ("Navy Blue")
		:macro (PASS_CLNTAUTH)
		:action (accept)
		:icon-name ("icon-cauth")
		:src_options ("Intersect with User Database")
		:accept_track Auth
		:clauth_to_hours (0)
		:clauth_to_minutes (30)
		:clauth_to_infinite (false)
		:sessions (5)
		:sessions_infinite (false)
		:ruletype ("Standard Sign-on")
		:clauth_track Auth
	)
	:sessionauthdefault (SessionAuthDefault
		:type (auth_session)
		:color ("Navy Blue")
		:macro (PASS_SESSION_AUTH)
		:action (accept)
		:icon-name ("icon-sauth")
		:src_options ("Intersect with User Database")
		:dst_options ("Intersect with User Database")
		:snauth.agent (Src
			:type (src)
			:color (FireBrick)
			:icon-name ("icon-source")
		)
		:accept_track Auth
		:sessions (1)
		:sessions_infinite (false)
		:ruletype ("Specific Sign-on")
	) 
	:userencryptdefault (UserEncryptDefault
		:type (userc)
		:color (Blue)
		:macro (USER_CLIENT_ENCRYPTION)
		:action (drop)
		:icon-name ("icon-encr")
		:src_options ("Intersect with User Database")
		:dst_options ("Intersect with User Database")
		:accept_track Auth
		:clauth_to_hours (0)
		:clauth_to_minutes (15)
		:clauth_to_infinite (false)
		:sessions (5)
		:sessions_infinite (true)
		:ruletype ("Standard Sign-on")
		:clauth_track Auth
		:expire (60)
	)
	:unix_actobj (
		:menu_sort (none)
		: (accept
			:type (accept)
			:color ("Dark green")
			:macro (RECORD_CONN)
			:icon-name ("icon-accept")
			:text-rid ("61463")
			:windows-color (green)
		)
		: (drop
			:type (drop)
			:color (Firebrick)
			:icon-name ("icon-drop")
			:text-rid ("61465")
			:windows-color (green)
		)
		: (reject
			:type (reject)
			:color (red)
			:icon-name ("icon-reject")
			:text-rid ("61464")
			:windows-color (green)
		)
		: (authenticate
			:nested_menu (true)
			:type (auth_user)
			:color ("Navy Blue")
			:party (t)
			:menu (true)
			:menu_sort (none)
			: ("User Auth"
				:menu (true)
				:menu_sort (none)
				:type (auth_user)
				:color ("Navy Blue")
				:icon-name ("icon-uauth")
				: (Default
					:fwcall (user_auth_default)
					:type (auth_user)
					:color ("Navy Blue")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:options (
						:rule_auth_http_allow ("Allow Predefined Servers Only")
					)
					:default UserAuthDefault
				)
				: (Props...
					:fwcall (user_auth_props)
					:type (auth_user)
					:color ("Navy Blue")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:options (
						:rule_auth_http_allow ("Allow Predefined Servers Only")
					)
					:default UserAuthDefault
				)
				: ("Encryption Props..."
					:fwcall (enc_ua_props)
					:type (enc_ua)
					:color ("Navy Blue")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:options (
						:rule_auth_http_allow ("Allow Predefined Servers Only")
					)
					:macro (ENCRYPTION)
					:action (drop)
					:diagnostics-track ()
					:skip.ipsec_options (
						: (ESP)
						: (AH)
					)
					:gateway Any
					:skip.gateway Any
					:manual.gateway Any
					:datam ()
					:keym ()
					:mdm (MD5)
					:skip.kijalg ()
					:skip.cryptalg ()
					:skip.macalg ()
					:scheme (FWZ)
					:skip.compalg ()
					:skip.nsid (None)
					:manual.SPI ()
				)
			)
			: ("Client Auth"
				:menu (true)
				:menu_sort (none)
				:type (auth_client)
				:color ("Navy Blue")
				:icon-name ("icon-cauth")
				: (Default
					:fwcall (client_auth_default)
					:type (auth_client)
					:color ("Navy Blue")
					:src_options ("Intersect with User Database")
					:accept_track Auth
					:clauth_to_hours (0)
					:clauth_to_minutes (30)
					:clauth_to_infinite (false)
					:sessions (5)
					:sessions_infinite (false)
					:ruletype ("Standard Sign-on")
					:clauth_track Auth
					:default ClntAuthDefault
				)
				: (Props...
					:fwcall (client_auth_props)
					:type (auth_client)
					:color ("Navy Blue")
					:src_options ("Intersect with User Database")
					:accept_track Auth
					:clauth_to_hours (0)
					:clauth_to_minutes (30)
					:clauth_to_infinite (false)
					:sessions (5)
					:sessions_infinite (false)
					:ruletype ("Standard Sign-on")
					:clauth_track Auth
					:default ClntAuthDefault
				)
				: ("Encryption Props..."
					:fwcall (enc_clauth_props)
					:type (enc_clauth)
					:color ("Navy Blue")
					:src_options ("Intersect with User Database")
					:accept_track Auth
					:clauth_to_hours (0)
					:clauth_to_minutes (30)
					:clauth_to_infinite (false)
					:sessions (5)
					:sessions_infinite (false)
					:ruletype ("Standard Sign-on")
					:clauth_track Auth
					:macro (ENCRYPTION)
					:action (drop)
					:diagnostics-track ()
					:skip.ipsec_options (
						: (ESP)
						: (AH)
					)
					:gateway Any
					:skip.gateway Any
					:manual.gateway Any
					:datam ()
					:keym ()
					:mdm ()
					:skip.kijalg ()
					:skip.cryptalg ()
					:skip.macalg ()
					:scheme (FWZ)
					:skip.compalg ()
					:skip.nsid (None)
					:manual.SPI ()
				)
			)
			: ("Session Auth"
				:menu (true)
				:menu_sort (none)
				:type (auth_session)
				:color ("Navy Blue")
				: (Default
					:fwcall (session_auth_default)
					:type (auth_session)
					:color ("Navy Blue")
					:action (accept)
					:icon-name ("icon-sauth")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:snauth.agent (Src
						:type (src)
						:color (FireBrick)
						:icon-name ("icon-source")
					)
					:accept_track Auth
					:sessions (1)
					:sessions_infinite (false)
					:ruletype ("Specific Sign-on")
					:default SessionAuthDefault
				)
				: (Props...
					:fwcall (session_auth_props)
					:type (auth_session)
					:color ("Navy Blue")
					:action (accept)
					:icon-name ("icon-sauth")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:snauth.agent (Src
						:type (src)
						:color (FireBrick)
						:icon-name ("icon-source")
					)
					:accept_track Auth
					:sessions (1)
					:sessions_infinite (false)
					:ruletype ("Specific Sign-on")
					:default SessionAuthDefault
				)
				: ("Encryption Props..."
					:fwcall (enc_snauth_props)
					:type (enc_snauth)
					:color ("Navy Blue")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:snauth.agent (Src
						:type (src)
						:color (FireBrick)
						:icon-name ("icon-source")
					)
					:accept_track Auth
					:sessions (1)
					:sessions_infinite (false)
					:ruletype ("Specific Sign-on")
					:macro (ENCRYPTION)
					:action (drop)
					:diagnostics-track ()
					:skip.ipsec_options (
						: (ESP)
						: (AH)
					)
					:gateway Any
					:skip.gateway Any
					:manual.gateway Any
					:datam ()
					:keym ()
					:mdm ()
					:skip.kijalg ()
					:skip.cryptalg ()
					:skip.macalg ()
					:scheme (FWZ)
					:skip.compalg ()
					:skip.nsid (None)
					:manual.SPI ()
				)
			)
		)
		: (encrypt
			:nested_menu (true)
			:type (encrypt)
			:color (Blue)
			:party (t)
			:menu (true)
			:menu_sort (none)
			: (encrypt
				:menu (true)
				:menu_sort (none)
				:type (encrypt)
				:color (Blue)
				:icon-name ("icon-encr")
				: (Default
					:fwcall (encryption_default)
					:type (encrypt)
					:color (Blue)
					:macro (ENCRYPTION)
					:icon-name ("icon-encr")
					:action (drop)
					:diagnostics-track ()
					:skip.ipsec_options (
						: (ESP)
						: (AH)
					)
					:gateway Any
					:skip.gateway Any
					:manual.gateway Any
					:datam ()
					:keym ()
					:mdm ()
					:skip.kijalg ()
					:skip.cryptalg ()
					:skip.macalg ()
					:scheme (FWZ)
					:skip.compalg ()
					:skip.nsid (None)
					:manual.SPI ()
				)
				: (Props...
					:fwcall (encryption_props)
					:type (encrypt)
					:color (Blue)
					:macro (ENCRYPTION)
					:action (drop)
					:diagnostics-track ()
					:skip.ipsec_options (
						: (ESP)
						: (AH)
					)
					:gateway Any
					:skip.gateway Any
					:manual.gateway Any
					:datam ()
					:keym ()
					:mdm ()
					:skip.kijalg ()
					:skip.cryptalg ()
					:skip.macalg ()
					:scheme (FWZ)
					:skip.compalg ()
					:skip.nsid (None)
					:manual.SPI ()
				)
			)
			: ("Client Encrypt"
				:menu (true)
				:menu_sort (none)
				:type (userc)
				:color (Blue)
				:icon-name ("icon-encr")
				: (Default
					:fwcall (userc_default)
					:type (userc)
					:color (Blue)
					:default UserEncryptDefault
				)
				: (Props...
					:fwcall (userc_props)
					:type (userc)
					:color (Blue)
					:default UserEncryptDefault
				)
			)
		)
		:default drop
	)
	:actobj (
		:menu_sort (none)
		: (accept
			:type (accept)
			:color ("Dark green")
			:macro (RECORD_CONN)
			:icon-name ("icon-accept")
			:text-rid ("61463")
			:windows-color (green)
		)
		: (drop
			:type (drop)
			:color (Firebrick)
			:icon-name ("icon-drop")
			:text-rid ("61465")
			:windows-color (green)
		)
		: (reject
			:type (reject)
			:color (red)
			:icon-name ("icon-reject")
			:text-rid ("61464")
			:windows-color (green)
		)
		: (authenticate
			:nested_menu (true)
			:type (auth_user)
			:color ("Navy Blue")
			:party (t)
			:menu (true)
			:menu_sort (none)
			: ("User Auth"
				:menu (true)
				:menu_sort (none)
				:type (auth_user)
				:color ("Navy Blue")
				:icon-name ("icon-uauth")
				: (Default
					:fwcall (user_auth_default)
					:type (auth_user)
					:color ("Navy Blue")
					:default UserAuthDefault
				)
				: (Props...
					:fwcall (user_auth_props)
					:type (auth_user)
					:color ("Navy Blue")
					:default UserAuthDefault
				)
			)
			: ("Client Auth"
				:menu (true)
				:menu_sort (none)
				:type (auth_client)
				:color ("Navy Blue")
				:icon-name ("icon-cauth")
				: (Default
					:fwcall (user_auth_default)
					:type (auth_client)
					:color ("Navy Blue")
					:default ClntAuthDefault
				)
				: (Props...
					:fwcall (user_auth_props)
					:type (auth_client)
					:color ("Navy Blue")
					:default ClntAuthDefault
				)
			)
			: ("Session Auth"
				:menu (true)
				:menu_sort (none)
				:type (auth_session)
				:color ("Navy Blue")
				: (Default
					:fwcall (session_auth_default)
					:type (auth_session)
					:color ("Navy Blue")
					:action (accept)
					:icon-name ("icon-sauth")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:snauth.agent (Src
						:type (src)
						:color (FireBrick)
						:icon-name ("icon-source")
					)
					:accept_track Auth
					:sessions (1)
					:sessions_infinite (false)
					:ruletype ("Specific Sign-on")
					:default SessionAuthDefault
				)
				: (Props...
					:fwcall (session_auth_props)
					:type (auth_session)
					:color ("Navy Blue")
					:action (accept)
					:icon-name ("icon-sauth")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:snauth.agent (Src
						:type (src)
						:color (FireBrick)
						:icon-name ("icon-source")
					)
					:accept_track Auth
					:sessions (1)
					:sessions_infinite (false)
					:ruletype ("Specific Sign-on")
					:default SessionAuthDefault
				)
				: ("Encryption Props..."
					:fwcall (enc_snauth_props)
					:type (enc_snauth)
					:color ("Navy Blue")
					:src_options ("Intersect with User Database")
					:dst_options ("Intersect with User Database")
					:snauth.agent (Src
						:type (src)
						:color (FireBrick)
						:icon-name ("icon-source")
					)
					:accept_track Auth
					:sessions (1)
					:sessions_infinite (false)
					:ruletype ("Specific Sign-on")
					:macro (ENCRYPTION)
					:action (drop)
					:diagnostics-track ()
					:skip.ipsec_options (
						: (ESP)
						: (AH)
					)
					:gateway Any
					:skip.gateway Any
					:manual.gateway Any
					:datam ()
					:keym ()
					:mdm ()
					:skip.kijalg ()
					:skip.cryptalg ()
					:skip.macalg ()
					:scheme (FWZ)
					:skip.compalg ()
					:skip.nsid (None)
					:manual.SPI ()
				)
			)
		)
		: (encrypt
			:nested_menu (true)
			:type (encrypt)
			:color (Blue)
			:party (t)
			:menu (true)
			:menu_sort (none)
			: (encrypt
				:menu (true)
				:menu_sort (none)
				:type (encrypt)
				:color (Blue)
				:icon-name ("icon-encr")
				: (Default
					:fwcall (encryption_default)
					:type (encrypt)
					:color (Blue)
					:macro (ENCRYPTION)
					:icon-name ("icon-encr")
					:action (drop)
					:diagnostics-track ()
					:skip.ipsec_options (
						: (ESP)
						: (AH)
					)
					:gateway Any
					:skip.gateway Any
					:manual.gateway Any
					:datam ()
					:keym ()
					:mdm (MD5)
					:skip.kijalg ()
					:skip.cryptalg ()
					:skip.macalg ()
					:scheme (FWZ)
					:skip.compalg ()
					:skip.nsid (None)
					:manual.SPI ()
				)
				: (Props...
					:fwcall (encryption_props)
					:type (encrypt)
					:color (Blue)
					:macro (ENCRYPTION)
					:action (drop)
					:diagnostics-track ()
					:skip.ipsec_options (
						: (ESP)
						: (AH)
					)
					:gateway Any
					:skip.gateway Any
					:manual.gateway Any
					:datam ()
					:keym ()
					:mdm (MD5)
					:skip.kijalg ()
					:skip.cryptalg ()
					:skip.macalg ()
					:scheme (FWZ)
					:skip.compalg ()
					:skip.nsid (None)
					:manual.SPI ()
				)
			)
			: ("Client Encrypt"
				:menu (true)
				:menu_sort (none)
				:type (userc)
				:color (Blue)
				:icon-name ("icon-encr")
				: (Default
					:fwcall (userc_default)
					:type (userc)
					:color (Blue)
					:default UserEncryptDefault
				)
				: (Props...
					:fwcall (userc_props)
					:type (userc)
					:color (Blue)
					:default UserEncryptDefault
				)
			)
		)
		:default drop
	)
	:targobj (InstOn
		:menu_sort (none)
		: (Gateways
			:type (gateways)
			:color ("Navy Blue")
			:icon-name ("icon-gateways")
		)
		: (Dst
			:type (dst)
			:color ("Dark Green")
			:icon-name ("icon-dst")
		)
		: (Src
			:type (src)
			:color (FireBrick)
			:icon-name ("icon-source")
		)
		: (Routers
			:type (routers)
			:color (Blue)
			:icon-name ("icon-router")
		)
		: (Targets
			:menu (true)
			:menu_selection (targets)
			: (All
				:icon (any)
				:color (Blue)
			)
			:include netobj
			:icon-name ("icon-targets")
		)
		:default Gateways
	)
	:fwobj (
		:menu (true)
		:menu_selection (firewalled)
		:include netobj
	)
	:compmenu (
		:menu (true)
		:menu_selection (computers)
		:include netobj
	)
	:hgmenu (
		:menu (true)
		:menu_selection (host-or-gateway)
		:include netobj
	)
	:hgnmenu (
		:menu (true)
		:menu_selection (host-or-gateway-or-none)
		: ()
		:include netobj
	)
	:collectionsmenu (
		:menu (true)
		:menu_selection (collections)
		:include netobj
	)
	:tcpmenu (
		:menu (true)
		:menu_selection (tcp-services)
		:include servobj
	)
	:tcpudpmenu (
		:menu (true)
		:menu_selection (tcpudp-services)
		:include servobj
	)
	:ufpmenu (
		:menu (true)
		:menu_selection (ufp)
		: ()
		:include servers
	)
	:cvpmenu (
		:menu (true)
		:menu_selection (cvp)
		: ()
		:include servers
	)
	:radius_servers_menu (
		:menu (true)
		:menu_selection (radius-host-or-group)
		:include servers
		: Any
	)
	:tacacs_servers_menu (
		:menu (true)
		:menu_selection (tacacs-host)
		: ()
		:include servers
	)
	:cdomainmenu (
		:menu (true)
		:menu_sort (none)
		:menu_selection (collections)
		: ("Valid Addresses"
			:type (group)
			:color ("Dark Green")
			:icon (inbound)
		)
		: (
			:icon (empty)
		)
		:include netobj
	)
	:gwmenu (
		:menu (true)
		: Any
		:menu_selection (all-firewalled)
		:include netobj
	)
	:trackobj (
		:menu_sort (none)
		: (
			:icon-name ("icon-empty")
			:color (white)
		)
		: Short
		: Long
		: Account
		: Alert
		: Mail
		: SnmpTrap
		: UserDefined
#		: Duplicate		# need PROMISC for this
	)
	:routersmenu (
		:menu (true)
		:menu_sort (none)
		: ("Verify ..."
			:type (verify)
		)
		: ("View"
			:type (view)
			:menu (true)
			: ("All Bay Networks")
			: ("All Ciscos")
			: ("All 3Coms")
			: ("All Cisco PIXes")
			:default "All Bay Networks"
			:menu_selection (acls)
			:include netobj
		)
	)
	:netobjmenu (
		:menu (true)
		:menu_sort (none)
		: (Default :type (default))
		: (Workstation :type (host))
		: (Router :type (router))
		: (Switch :type (switch))
		: ("Integrated FireWall" :type (blackbox))
		: (Network :type (network))
		: (Domain :type (domain))
		: (Logical :type (logical))
		: (Group :type (group))
	)
	:servicesmenu (
		:menu (true)
		:menu_sort (none)
		: (Default :type (default))
		: (Tcp :type (tcp))
		: (Udp :type (udp))
		: (Rpc :type (rpc))
		: (Icmp :type (icmp))
		: (Other :type (other))
		: (Group :type (group))
	)
	:usersmenu (
		:menu (true)
		:menu_sort (none)
		: (Default :type (default))
		: (User
			:type (user)
			:menu (true)
			:include templateobj
		)
		: (Group :type (usrgroup))
		: (Template :type (template))
	)
	:timemenu (
		:menu (true)
		:menu_sort (none)
		: (Default :type (default))
		: (Time :type (time))
		: (Group :type (group))
	)
	:serversmenu (
		:menu (true)
		:menu_sort (none)
		: (UFP :type (ufp))
		: (CVP :type (cvp))
		: (RADIUS :type (radius))
		: (Group :type (group))
	)
	:radius_versions (
		:menu (true)
		:menu_sort (none)
		: ("RADIUS 1.0 Compatible")
	)
	:groupmenu (
		:menu (true)
		:menu_sort (none)
		: ("All Users"
			:type (usrgroup)
		)
		:include groupsobj
	)
	:services_rb_menu (
		:default Any
		:menu (true)
		:include servobj
		:menu_join (
			:menu_filter ("all_serv_filter")
			:menu_filter_item ("one_serv_join")
			:include resourcesobj
		)
	)
	:resources_types (resources_types
		: ("URI spec" :type (uri) )
		: ("SMTP spec" :type (smtp) )
		: ("FTP spec" :type (ftp) )
	)
	:resourcesmenu (
		:menu (true)
		:menu_sort (none)
		: ("URI spec" :type (uri) )
		: ("SMTP spec" :type (smtp) )
		: ("FTP spec" :type (ftp) )
		: (Group :type (group))
	)
	:embedded_licmenu (
		:menu (true)
		:menu_sort (none)
		: (25 :num (25))
		: (50 :num (50))
		: (100 :num (100))
		: (250 :num (250))
		: (Unlimited :num (0))
		:default_method 50
	)
	:fwlv_filtermenu (
		:menu (true)
		:menu_sort (none)
		: ("Num ..."
			:action (num)
			:icon (num)
			:color (Blue)
		)
		: ("Date ..."
			:action (date)
			:icon (date)
			:color ("Forest Green")
		)
		: ("Time ..."
			:action (time)
			:icon (time)
			:color ("Sea Green")
		)
		: ("I/F ..."
			:action (I/F)
			:icon (inbound)
			:color ("Dark Orchid")
		)
		: ("Orig ..."
			:action (orig)
			:icon (orig)
			:color (Firebrick)
		)
		: ("Type ..."
			:action (type)
			:icon (control)
			:color (Coral)
		)
		: ("Action ..."
			:action (action)
			:icon (accept.pr)
			:color ("Dark Green")
		)
		: ("Conn_Id ..."
			:action (conn_id)
			:icon (num)
			:color ("Orchid")
		)
		: ("Service ..."
			:action (service)
			:icon (service)
			:color (Sienna)
		)
		: ("Src ..."
			:action (src)
			:icon (src.pr)
			:color (Navy)
		)
		: ("Dst ..."
			:action (dst)
			:icon (dst.pr)
			:color (Navy)
		)
		: ("Proto ..."
			:action (proto)
			:icon (proto)
			:color ("Red")
		)
		: ("Rule ..."
			:action (rule)
			:icon (rule)
			:color ("Dark Slate Blue")
		)
		: ("S_Port ..."
			:action (s_port)
			:icon (sport)
			:icon (service)
			:color ("Orange Red")
		)
		: ("User ..."
			:action (user)
			:icon (user)
			:color ("Magenta")
		)
		: ("SrcKeyId ..."
			:action (srckeyid)
			:icon (key.pr)
			:color ("Violet Red")
		)
		: ("DstKeyId ..."
			:action (dstkeyid)
			:icon (key.pr)
			:color ("Blue Violet")
		)
		: ("Elapsed ..."
			:action (elapsed)
			:icon (time)
			:color (maroon)
		)
		: ("Bytes ..."
			:action (bytes)
			:icon (bytes)
			:color (maroon)
		)
		: ("XlateSrc ..."
			:action (xlatesrc)
			:icon (translate-src)
			:color ("Indian Red")
		)
		: ("XlateDst ..."
			:action (xlatedst)
			:icon (translate-dest)
			:color ("Indian Red")
		)
		: ("XlateSPort ..."
			:action (xlatesport)
			:icon (translate-port)
			:color ("Dark Olive Green")
		)
		: ("XlateDPort ..."
			:action (xlatedport)
			:icon (translate-port)
			:color ("Dark Olive Green")
		)
		: ("Info ..."
			:action (info)
			:icon (info)
			:color (Black)
		)
	)
	:title	(
		:vendor (sunsoft)
		:title ("	Solstice FireWall-1")
		:email ("Email:   support@SunSoft.COM")
		:phone ("Phone:  1-800 SunSoft or +1-512-345-2412")
		:fax   ("Fax:      +1-512-345-2436")
	)
	:ifmenu (
		:menu (true)
		:menu_sort (none)
		: Any
		: ("Open !!!"
			:access (open)
			:icon (open)
			:color (red)
			:fwcall (open_interface)
		)
		: ("Others + ..."
			:menu	(true)
			:access (default)
			:icon (cloud)
			:color (yellow)
			: (
				:icon (empty)
			)
			:include netobj
		)
		:include netobj
		:default "Others + ..."
		: ("This Net"
			:access (this)
			:icon (net)
			:color ("Dark green")
		)
	)
	:iflogmenu (
		:menu (true)
		:menu_sort (none)
		: (
			:icon (empty)
		)
		: spoof
		: spoofalert
	)
	:cryptlogmenu (
		:menu (true)
		:menu_sort (none)
		: (
			:icon (empty)
		)
		: (CryptLog
			:icon (log.pr)
			:format (crypt)
			:color ("Navy Blue")
		)
		: (CryptAlert
			:icon (alert.pr)
			:format (crypt)
			:color (red)
			:alert (alert)
		)
	)
	:agent_menu (
		:nested_menu (true)
		:menu (true)
		:menu_sort (none)
		: (Src
			:type (src)
			:color (FireBrick)
			:icon-name ("icon-source")
		)
		: (Dst
			:type (dst)
			:color ("Dark Green")
			:icon-name ("icon-dst")
		)
		: (Targets 
			:menu (true)
			:menu_sort (none)
			:menu_selection (host-or-gateway)
			:include netobj
		)
	)
	:AU_alertmenu (
		:menu (true)
		:menu_sort (none)
		: (
			:icon (empty)
		)
		: Auth
		: AuthAlert
	)
       :smtp_alertmenu (
                :menu (true)
                :menu_sort (none)
                : (
                        :icon (empty)
                )
                : "Exception Log"
                : "Exception Alert"
        )
        :uri_alertmenu (
                :menu (true)
                :menu_sort (none)
                : (
                        :icon (empty)
                )
                : "Exception Log"
                : "Exception Alert"
        )
        :ftp_alertmenu (
                :menu (true)
                :menu_sort (none)
                : (
                        :icon (empty)
                )
                : "Exception Log"
                : "Exception Alert"
        )
	:ipoptsmenu (
		:menu (true)
		:menu_sort (none)
		: (
			:icon (empty)
		)
		: "IP Options"
		: "IP Options Alert"
	)
	:userdefaults (Default
		:name (Default)
		:type (template)
		:auth_method (Undefined)
		:fromhour ("00:00")
		:tohour ("23:59")
		:expiration_date ("31-dec-1997")
		:groups ()
		:SKEY_number (100)
		:days (127)
		:destinations (
			: Any
		)
		:sources (
			: Any
		)
	)
 	:queries2 (
		:netobj (
			: (Hosts
				:type (query)
				:query ("type = 'host'")
			)
			: (Networks
				:type (query)
				:query ("type = 'network'")
			)
			: (Domains
				:type (query)
				:query ("type = 'domain'")
			)
			: (Groups
				:type (query)
				:query ("type = 'group'")
			)
			: (Gateways
				:type (query)
				:query ("type = 'gateway'")
			)
			: (Routers
				:type (query)
				:query ("type = 'router'")
			)
			: (Switches
				:type (query)
				:query ("type = 'switch'")
			)
			: ("Address Ranges"
				:type (query)
				:query ("type = 'machines_range'")
			)
			: ("Firewall-1 installed"
				:type (query)
				:query ("firewall = 'installed'")
			)
			: ("All"
				:type (query)
				:query ("type = 'host' | type = 'network' | type = 'domain' | type = 'Router' | type = 'group' | type = 'gateway' | type = 'machines_range' | type = 'logical' | type = 'switch' | type = 'blackbox'")
			)
		)
		:services (
			: ("TCP services"
				:type (query)
				:query ("type = 'tcp'")
			)
			: ("UDP services"
				:type (query)
				:query ("type = 'udp'")
			)
			: ("RPC services"
				:type (query)
				:query ("type = 'rpc'")
			)
			: ("ICMP services"
				:type (query)
				:query ("type = 'icmp'")
			)
			: ("User defined services"
				:type (query)
				:query ("type = 'other'")
			)
			: (Groups
				:type (query)
				:query ("type = 'group'")
			)
			: ("TCP or UDP"
				:type (query)
				:query ("type = 'udp' | type = 'tcp'")
			)
			: ("All"
				:type (query)
				:query ("type = 'tcp' | type = 'udp' | type = 'other' | type = 'rpc' | type = 'icmp' | type = 'group' | type = 'ports_range'")
			)
		)
		:users (
			: (Groups
				:type (query)
				:query ("type = 'usrgroup'")
			)
			: (Users
				:type (query)
				:query ("type = 'user'")
			)
			: (Templates
				:type (query)
				:query ("type = 'template'")
			)
			: ("All"
				:type (query)
				:query ("type = 'usrgroup' | type = 'user' | type = 'template'")
			)
		)
		:resources (
			: (Groups
				:type (query)
				:query ("type = 'group'")
			)
			: ("URI resources"
				:type (query)
				:query ("type = 'uri'")
			)
			: ("SMTP resources"
				:type (query)
				:query ("type = 'smtp'")
			)
			: ("FTP resources"
				:type (query)
				:query ("type = 'ftp'")
			)    
			: ("All"
				:type (query)
				:query ("type = 'group' | type = 'uri'  |  type = 'smtp'")
			)
		)
		:netobjadtrsrcorg (
			: (Hosts
				:type (query)
				:query ("type = 'host'")
			)
			: (Networks
				:type (query)
				:query ("type = 'network'")
			)
			: (Groups
				:type (query)
				:query ("type = 'group'")
			)
			: (Gateways
				:type (query)
				:query ("type = 'gateway'")
			)
			: (Routers
				:type (query)
				:query ("type = 'router'")
			)
			: (Switches
				:type (query)
				:query ("type = 'switch'")
			)
			: ("Address Range"
				:type (query)
				:query ("type = 'machines_range'")
			)
			: ("All"
				:type (query)
				:query ("type = 'host' | type = 'network' | type = 'group' | type = 'gateway' | type = 'machines_range' | type = 'Router' | type = 'switch' | type = 'blackbox'")
			)
		)
		:netobjadtrhideto (
			: (Hosts
				:type (query)
				:query ("type = 'host'")
			)
			: (Gateways
				:type (query)
				:query ("type = 'gateway'")
			)
			: ("Address Range"
				:type (query)
				:query ("type = 'machines_range'")
			)
			: (Routers
				:type (query)
				:query ("type = 'router'")
			)
			: (Switches
				:type (query)
				:query ("type = 'switch'")
			)
			: ("All"
				:type (query)
				:query ("type = 'host' | type = 'gateway' | type = 'Router' | type = 'machines_range' | type = 'switch' | type = 'blackbox'")
			)
		)
		:netobjadtr (
			: (Hosts
				:type (query)
				:query ("type = 'host'")
			)
			: (Networks
				:type (query)
				:query ("type = 'network'")
			)
			: (Gateways
				:type (query)
				:query ("type = 'gateway'")
			)
			: ("Address Range"
				:type (query)
				:query ("type = 'machines_range'")
			)
			: (Routers
				:type (query)
				:query ("type = 'router'")
			)
			: (Switches
				:type (query)
				:query ("type = 'switch'")
			)
			: ("All"
				:type (query)
				:query ("type = 'host' | type = 'network' | type = 'gateway' | type = 'machines_range' | type = 'Router' | type = 'switch' | type = 'blackbox'")
			)
		)
		:servicesadtr (
			: ("TCP services"
				:type (query)
				:query ("type = 'tcp'")
			)
			: ("UDP services"
				:type (query)
				:query ("type = 'udp'")
			)
			: ("TCP or UDP"
				:type (query)
				:query ("type = 'udp' | type = 'tcp'")
			)
			: ("Ports Range"
				:type (query)
				:query ("type = 'ports_range'")
			)
			: ("All"
				:type (query)
				:query ("type = 'udp' | type = 'tcp' | type = 'ports_range'")
			)
		)
		:servicesadtrorg (
			: ("TCP services"
				:type (query)
				:query ("type = 'tcp'")
			)
			: ("UDP services"
				:type (query)
				:query ("type = 'udp'")
			)
			: ("TCP or UDP"
				:type (query)
				:query ("type = 'udp' | type = 'tcp'")
			)
			: ("Ports Range"
				:type (query)
				:query ("type = 'ports_range'")
			)
			: ("All"
				:type (query)
				:query ("type = 'udp' | type = 'tcp' | type = 'ports_range' | type = 'group'")
			)
		)
		:keys (
			: ("All"
				:type (query)
				:query ("type = 'spi'")
			)
		)
        :servers (
			: ("UFP"
				:type (query)
				:query ("type = 'ufp'")
			)
			: ("RADIUS"
                                :type (query)
                                :query ("type = 'radius'")
                        )
			: ("CVP"
                                :type (query)
                                :query ("type = 'cvp'")
                        )
			: ("Groups"
				:type (query)
				:query ("type = 'group'")
			)
			: ("All"
				:type (query)
				:query ("type = 'ufp' |  type = 'cvp' | type = 'radius' | type = 'group'")
			)
		)					   				   	   
		:not_allowed_in_group (
			: ("All"
				:type (query)
				:query ("type = 'ports_range' | type = 'machines_range'")
			)
		)
    )
	:queries (
		:netobj (
			: (Hosts
				:type (query)
				:query ("type = 'host'")
			)
			: (Networks
				:type (query)
				:query ("type = 'net'")
			)
			: (Domains
				:type (query)
				:query ("type = 'domain'")
			)
			: (Groups
				:type (query)
				:query ("type = 'group'")
			)
			: (Gateways
				:type (query)
				:query ("type = 'gateway'")
			)
			: ("Firewall-1 installed"
				:type (query)
				:query ("firewall = 'installed'")
			)
			: ("Can install Firewall-1"
				:type (query)
				:query ("type = 'host' | type = 'gateway'")
			)
			: ("Firewall-1 not installed"
				:type (query)
				:query ("(type = 'host' | type = 'gateway') & !(firewall = 'installed')")
			)
		)
		:services (
			: ("TCP services"
				:type (query)
				:query ("type = 'tcp'")
			)
			: ("UDP services"
				:type (query)
				:query ("type = 'udp'")
			)
			: ("RPC services"
				:type (query)
				:query ("type = 'rpc'")
			)
			: ("ICMP services"
				:type (query)
				:query ("type = 'icmp'")
			)
			: ("User defined services"
				:type (query)
				:query ("type = 'other'")
			)
			: (Groups
				:type (query)
				:query ("type = 'group'")
			)
			: ("TCP or UDP"
				:type (query)
				:query ("type = 'udp' | type = 'tcp'")
			)
		)
		:users (
			: (Groups
				:type (query)
				:query ("type = 'usrgroup'")
			)
			: (Users
				:type (query)
				:query ("type = 'user'")
			)
			: (Templates
				:type (query)
				:query ("type = 'template'")
			)
		)
	)
	:dhparams (
		:mod (
			:value (9f57f60c98ba4f11468dfb4c2ecfd15b8861f48a88bd32cb2cb954c06cc01e25578102905691631266306444b1ef31de0c0091f468ecbccd70170b2d84fa637f)
		)
		:root (
			:value (0a552ee379202b40e79dca100dfb6501346307533c3ebef5e3ee0727e260489377981ae7c8b6124128437d4892fd632aafde6df3744f0351ec05f83130f74cfb)
		)
	)
	:dhparams_list (
		: ("skip1024"
			:mod (
				:value (f488fd584e49dbcd20b49de49107366b336c380d451d0f7c88b31c7c5b2d8ef6f3c923c043f0a55b188d8ebb558cb85d38d334fd7c175743a31d186cde33212cb52aff3ce1b1294018118d7c84a70a72d686c40319c807297aca950cd9969fabd00a509b0246d3083d66a45d419f9c7cbd894b221926baaba25ec355e92f78c7)
			)
			:root (
				:value (02)
			)
		)
		: ("skip2048"
			:mod (
				:value (f64257b7087f081772a2bad6a942f305e8f95311394fb6f16eb94b3820da01a756a314e98f4055f3d007c6cb43a994adf74c648649f80c83bd65e917d4a1d350f8f5595fdc76524f3d3d8ddbce99e1579259cdfdb8ae744fc5fc76bc83c5473061ce7cc966ff15f9bbfd915ec701aad35b9e8da0a5723ad41af0bf4600582be5f488fd584e49dbcd20b49de49107366b336c380d451d0f7c88b31c7c5b2d8ef6f3c923c043f0a55b188d8ebb558cb85d38d334fd7c175743a31d186cde33212cb52aff3ce1b1294018118d7c84a70a72d686c40319c807297aca950cd9969fabd00a509b0246d3083d66a45d419f9c7cbd894b221926baaba25ec355e9320b3b)
			)
			:root (
				:value (02)
			)
		)
	)
	:prop2pseudo (
	    :fw1enable ( :order (fw1_enable_p)
		:text ("Enable FW1 control connections [essential]") )
	    :outgoing ( :order (outgoing_p)
		:text ("Enable outgoing packets [common]") )
	    :icmpenable ( :order (icmpenable_p)
		:text (" Enable ICMP [Common]") )
	    :rip ( :order (rip_p) 
		:text ("Enable RIP (Common)") )
	    :domain_udp ( :order (domain_udp_p)
		:text ("Enable Domain Name Queries (UDP)  [Essential]") )
	    :domain_tcp ( :order (domain_tcp_p) 
		:text ("Enable Domain Name Download (TCP)") )
	    :ftppasv ( 
		:text ("Enable ftppasv connections") )
	    :rshstderr (
		:text ("Enable RSH/REXEC Reverse stderr Connections") )
	    :rpcenable ( 
		:text ("Enable RPC Control") )
	    :ftpdata (
		:text ("Enable Response of FTP Data Connection") )
	    :raudioenable ( :order (raudioenable_p)
		:text ("Enable Real Audio Reverse Connection") )
	    :vdolivenable ( :order (vdolivenable_p)
		:text ("Enable VDOLive Reverse Connection") )
	    :cooltalkenable ( 
		:text ("Enable CoolTalk Data Connection (UDP)") )
	    :iphoneenable (
		:text ("Enable Intel Phone Control and Data Connections") )
	)
)
