#pragma ident "@(#)pfsmt.h	1.2 11/27/01 SMI"
/*
 * Copyright (c) 1993-1997 by Network Peripherals Inc. All rights reserved.
 */
/*
 * Common .h between pf driver and smt daemon/stat programs
 */


/* IOCTL COMMANDS */
#define SMTIOC			(u_int) (('S' + 'M' + 'T') << 8)
#define SMT_IOCTL_R_MYFDDIADDR	(SMTIOC | 1)
#define SMT_IOCTL_R_MYENETADDR 	(SMTIOC | 2)
#define SMT_IOCTL_P_Basic_HPC	(SMTIOC | 4)
#define SMT_IOCTL_R_HPC		(SMTIOC | 5)
#define SMT_IOCTL_W_HPC		(SMTIOC | 6)
#define SMT_IOCTL_R_SMT_TIMESTAM (SMTIOC | 7)
#define SMT_LCC_AVAIL		(SMTIOC | 12)
#define SMT_LLC_NOT_AVAIL	(SMTIOC | 13)
#define SMT_GET			(SMTIOC | 21)
#define SMT_SET			(SMTIOC | 22)
#define SMT_ACT			(SMTIOC | 23)

/* HPC DATA SIZE DEFINITIONS */
#define HPC_SIZE_MASK		0x1800
#define HPC_NO_DATA		0x0000
#define HPC_SIZE_LONG		0x0800
#define HPC_SIZE_WORD		0x1000
#define HPC_SIZE_BYTE		0x1800

/* HPC MAILBOX COMMANDS */
#define HPC_SIGNAL		0x0000
#define HPC_WRITE		0x2000
#define HPC_OR			0x4000
#define HPC_AND			0x6000
#define HPC_READ		0x8000
#define HPC_XCHG		0xA000
#define HPC_TEST_AND_SET	0xC000
#define HPC_TEST_AND_CLR	0xE000

/* HPC - Misc stuff */
#define	HPC_NOT_WRITE_READY	((char)0x01)
#define	HPC_NOT_READ_READY	((char)0x02)

/* Memory map of HPC controlled data space */
 
#define HPC_MAC1_REGS		0x0280
#define HPC_MAC2_REGS		0x02C0
#define HPC_RMT1_REGS		HPC_MAC1_REGS
#define HPC_RMT2_REGS		HPC_MAC2_REGS
 
#define HPC_PORT1_REGS		0x0300
#define HPC_PORT2_REGS		0x0340
#define HPC_PORT3_REGS		0x0380
#define HPC_PORT4_REGS		0x03C0
#define HPC_CMT1_REGS		HPC_PORT1_REGS
#define HPC_CMT2_REGS		HPC_PORT2_REGS
#define HPC_CMT3_REGS		HPC_PORT3_REGS
#define HPC_CMT4_REGS		HPC_PORT4_REGS
 
#define HPC_PLAYER1_REGS	0x0500
#define HPC_PLAYER2_REGS	0x0540
#define HPC_PLAYER3_REGS	0x0580
#define HPC_PLAYER4_REGS	0x05C0
 
#define HPC_BMAC1_REGS		0x0600
#define HPC_BMAC2_REGS		0x0700
#define	HPC_PORTP_ENBP		0x0100/* Optical Bypass Control Bit */
#define	HPC_PORTP		(0x0152 | HPC_SIZE_WORD)

 
/* HPC DEVICES */
#define HPC_SMT_REGS		0x200
#define HPC_RMT_REGS		0x280
#define HPC_BMAC_REGS		0x600   /* <<<<<<<<<check>>>>>>>>> */

/* COMPOSITE AND BIT DEFINITIONS */
#define HPC_SIGNAL_RESET 	((unsigned short)(0x001a))
#define HPC_SIGNAL_EC_CONNECT 	((unsigned short)(0x0003 | HPC_SMT_REGS))
#define HPC_SIGNAL_EC_DISCONNECT ((unsigned short)(0x0002 | HPC_SMT_REGS))
#define HPC_SIGNAL_EC_PTPASS 	((unsigned short)(0x0006 | HPC_SMT_REGS))
#define HPC_SIGNAL_RMT1_ISOLATE	((unsigned short)(0x0032 | HPC_RMT1_REGS))
#define CLEAR_HPC_INT_COND	0x000f
 
#define HPC_SIGNAL_DAD_FAIL  	0x0034
#define HPC_SIGNAL_DAD_PASS  	0x0035
 
#define HPC_BMAC1_ADDR_REG 	(0x0040 | HPC_BMAC1_REGS | HPC_WRITE | \
					HPC_SIZE_BYTE)
#define HPC_RMT1_TREQ_REG 	(0x000c | HPC_RMT1_REGS | HPC_WRITE | \
					 HPC_SIZE_WORD)
 
#define HPC_BMAC1_MCAST_REG 	(0x0048 | HPC_BMAC1_REGS | HPC_SIZE_BYTE)
#define HPC_BMAC1_PGM0_REG     	(0x0070 | HPC_BMAC1_REGS | HPC_SIZE_BYTE)
#define HPC_BMAC1_PGM10_REG    	(0x0060 | HPC_BMAC1_REGS | HPC_SIZE_BYTE)
#define HPC_RMT1_STATE_REG 	(0x0000 | HPC_RMT1_REGS | HPC_SIZE_WORD)
 
 
/* RMT STATE/STATUS REGISTER */
#if (SMT7_2 != CFG_YES)
#define RMT_ST_MASK		0x07
#define RMT_ST_ISOLATED		0x00
#define RMT_ST_NON_OP		0x01
#define RMT_ST_RIGN_OP		0x02
#define RMT_ST_DETECT		0x03
#define RMT_ST_NON_OP_DUP	0x04
#define RMT_ST_RING_OP_DUP	0x05
#define RMT_ST_DIRECTED		0x06
#define RMT_ST_TRACE		0x07
#endif
 
 
/* HPC REGISTERS */
#define HPC_CBUS_DEVICES	(0x07 | HPC_SMT_REGS | HPC_SIZE_BYTE)
 
/* INTERRUPT SUMMARY */
#define HPC_INT_SUMMARY 	(0x0A | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_INT_SUMMARY_MASK 	(0x0B | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_INT_SUMMARY_TMR_EVENT 	BIT_0
#define HPC_INT_SUMMARY_SMT_EVENT 	BIT_1
#define HPC_INT_SUMMARY_RMT_EVENT 	BIT_2
#define HPC_INT_SUMMARY_PORT_EVENT 	BIT_4
#define HPC_INT_SUMMARY_PORT1_EVENT 	BIT_4
#define HPC_INT_SUMMARY_PORT2_EVENT 	BIT_5
#define HPC_SMT_EVENT_SUMMARY   (0x0c | HPC_SMT_REGS | HPC_SIZE_WORD)
#define HPC_SMT_EVENT_MASK	(0x0e | HPC_SMT_REGS | HPC_SIZE_WORD)
#define HPC_RMT_EVENT_SUMMARY	(0x04 | HPC_RMT1_REGS | HPC_SIZE_WORD)
#define HPC_RMT_EVENT_MASK	(0x06 | HPC_RMT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT_EVENT_SUMMARY	(0x34 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT_EVENT_MASK	(0x36 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT1_EVENT_SUMMARY	(0x34 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT1_EVENT_MASK	(0x36 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT2_EVENT_SUMMARY	(0x34 | HPC_PORT2_REGS | HPC_SIZE_WORD)
#define HPC_PORT2_EVENT_MASK	(0x36 | HPC_PORT2_REGS | HPC_SIZE_WORD)
#define HPC_TMR_EVENT_SUMMARY	(0x16 | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_TMR_EVENT_MASK	(0x17 | HPC_SMT_REGS | HPC_SIZE_BYTE)


/* USED INT BITS */
#define SMT_INT_TSTAMP 		BIT_7
#define RMT_INT_CHGMAV 		BIT_1
#define RMT_INT_DETECT 		BIT_3
#define RMT_INT_DIRECT 		BIT_4
#define RMT_INT_DAD    		BIT_6
#define RMT_INT_JAM		BIT_7
#define SMT_INT_PATHTEST	BIT_8
#define PORT_INT_LER_CUTOFF 	BIT_15
#define PORT_INT_PCM_ACTIVE 	BIT_9

 
/* REGISTERS INSIDE MAC */
#define HPC_MAC1_ADDR_RD 	(HPC_READ | HPC_SIZE_LONG | \
				 HPC_MAC1_REGS )
#define HPC_LATE_COUNT  	0x0E
#define HPC_TO_COUNT 		0x10
#define HPC_TX_COUNT 		0x14
#define HPC_NC_COUNT 		0x18
#define HPC__C_COUNT 		0x1c
#define HPC_RX_COUNT 		0x28
#define HPC_LO_COUNT 		0x20
#define HPC_ER_COUNT 		0x24
 
/* REGISTERS INSIDE PLAYER */
#define PLYR_UDR		0x17
#define PLYR_REV		0x18
#define PLYR_CRD		0x38
#define PLYR_CGM1		0x3b
#define PLYR_CGM2		0x3c
#define PLYR_UDR_NOSCRAM	0x10

#define HPC_SMT_TIME_STAMP_READ (0x10|HPC_SIZE_LONG|HPC_SMT_REGS|HPC_READ)

 
/*
 * SMT standard definitions
 */
#define SMT_MIN_PACKET_LENGTH 	sizeof(Npi_smt_header)
 
/* Frame Classes & types page 273 of 5.1 */
#define SMT_FRAME_CLASS_NIF 	0x01
#define SMT_FRAME_CLASS_C_SIF 	0x02
#define SMT_FRAME_CLASS_O_SIF 	0x03
#define SMT_FRAME_CLASS_ECF 	0x04
#define SMT_FRAME_CLASS_RAF 	0x05
#define SMT_FRAME_CLASS_RDF 	0x06
#define SMT_FRAME_CLASS_SRF 	0x07
#define SMT_FRAME_CLASS_G_PMF 	0x08
#define SMT_FRAME_CLASS_C_PMF 	0x09
#define SMT_FRAME_CLASS_A_PMF 	0x0A
#define SMT_FRAME_CLASS_R_PMF 	0x0B
#define SMT_FRAME_CLASS_ESF 	0xFF
#define SMT_FRAME_TYPE_ANNOUNCE	0x01
#define SMT_FRAME_TYPE_REQUEST 	0x02
#define SMT_FRAME_TYPE_RESPONSE	0x03


/* SMT stuff needed in drivers */
#define FRAME_CLASS_NIF 	SMT_FRAME_CLASS_NIF
#define FRAME_TYPE_NIF_REQUEST 	SMT_FRAME_TYPE_REQUEST
#define FRAME_TYPE_NIF_RESPONSE	SMT_FRAME_TYPE_RESPONSE
#define FRAME_TYPE_NIF_ANNOUNCE	SMT_FRAME_TYPE_ANNOUNCE
#define SMT_VERSION_ID_51 	1
#define SMT_VERSION_ID_61 	1
#define FC_NSA 			0x4F
#define FC_SMT_INFO 		0x41
#define SMT52_NIF_LEN_old 	0x3D
#define NIF_INFO_LEN_old 	0x1C
#define NIF_INFO_LEN 		0x28
#define SMT52_NIF_LEN 		(0x3D+36-0x1C+4)


typedef struct { 
	u_short		a[3];
} Integer48;



#define MAXMACS			3
#define MAXPHYS			20
#define SUN_STATION_NPHYS	2

/* Byte clock should actually come from the board, not a defined parameter. */
#define BCLK			80

/*
 * DELIMITER[1] FC[1] DA[6] SA[6] SMTHDR[20] DATA[4464] CKSUM[4]
 */
#define FDDIMAXFRAME		4500
#define FDDISMTMTU		FDDIMAXFRAME-36

/*
 * 15  14  13  12  11  10  9   8   7   6   5   4   3   2   1   0
 * +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+ 
 * | 1 | 1 | 1 | 1 | E | A | C |   |              FC               |
 * +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
 * 
 */

/* Station Type */
#define STATION			0x00
#define CONCENTRATOR		0x01


/* Topology */
#define STATIONWRAPPED		0x01
#define UNROOTEDCONCENTRATOR	0x02
#define TWISTEDRING		0x04
#define TWISTEDRING_AA		0x04
#define TWISTEDRING_BB		0x08
#define ROOTEDSTATION		0x10
#define SRFREPORTING		0x20

/* DuplAddress */
#define	MYDUPLADDRESSBIT	0x01
#define UNDUPLADDRESSBIT	0x02

/* Connect State */
#define DISABLED		0x00
#define CONNECTING		0x01
#define STANDBY			0x02
#define ACTIVE			0x03

#define CYCLESPERTICK		125000	/* 10ms/80ns */


#define PS_LER_CUTOFF_ZZ	0x07
#define PS_LER_ALARM_ZZ		0x08

#define Clear			0
#define Set			1

typedef void    (*fptrv_t) ();	/* pointer to function returning void */

typedef enum {
	PhyT_A,			/* The PHY in a dual attach station that
				 * attaches to the primary in and the
				 * secondary out when attaching to the dual
				 * ring shall be designated by 'A'. */
	PhyT_B,			/* The PHY in a dual attach station that
				 * attaches to the secondary in and the
				 * primary out when attaching to the dual
				 * ring shall be designated by 'B'. */
	PhyT_S,			/* A PHY in a single attach station shall be
				 * designated by 'S'. */
	PhyT_M,			/* A PHY in a concentrator that serves as a
				 * Master to a connected station shall be
				 * designated by 'M'. */
	PhyT_I,			/* Invalid PHY
				 * 
				 */
}               phytype_t;

#ifndef True
#define	True		1	
#endif
#ifndef False
#define	False		0
#endif
#ifndef Error
#define Error		0xff
#endif

/*
 * MAC (Media Access Controller) address - 6 octets
 */
typedef struct {
	u_char          octet[6];
}               mac_addr_t;

typedef struct {
	u_char          octet[2];	/* Short network address */
}               short_mac_addr_t;

/* ECM state machine state names indicating station connection status: */
typedef enum {
	ECS_Out,		/* EC0 */
	ECS_In,			/* EC1 */
	ECS_Trace,		/* EC2 */
	ECS_Leave,		/* EC3 */
	ECS_Path_Test,		/* EC4 */
	ECS_Insert,		/* EC5 */
	ECS_Check,		/* EC6 */
	ECS_Deinsert		/* EC7 */
} ec_state_t;

typedef enum {
	ECStatus_Clear,
	ECStatus_ConnectSuccessful,
	ECStatus_ConnectFailed,
	ECStatus_DisconnectRequestedBeforeConnectCompleted,
	ECStatus_DisconnectSuccessful,
	ECStatus_SelfDisconnected,
	ECStatus_StuckBypass
} ec_status_t;

/* PCM state machine state names indicating PHY connection status */
typedef enum {
	PCS_Off,		/* PC0 */
	PCS_Break,		/* PC1 */
	PCS_Trace,		/* PC2 */
	PCS_Reject = PCS_Trace,	/* PC2 */
	PCS_Connect,		/* PC3 */
	PCS_Next,		/* PC4 */
	PCS_Signal,		/* PC5 */
	PCS_Join,		/* PC6 */
	PCS_Verify,		/* PC7 */
	PCS_Active,		/* PC8 */
	PCS_Maint,		/* PC9 */
} pc_state_t;

/* CFM state machine state names indicating station configuration: */
typedef enum {
	CFS_Isolated,		/* SC0 */
	CFS_WrapS,		/* SC1 */
	CFS_WrapA,		/* SC2 */
	CFS_WrapB,		/* SC3 */
	CFS_WrapAB,		/* SC4 */
	CFS_Thru,		/* SC5 */
} cf_state_t;

/* RMT state machine state names indicating ring management: */
typedef enum {
	RMS_Isolated,		/* RM0 */
	RMS_Non_Op,		/* RM1 */
	RMS_Ring_Op,		/* RM2 */
	RMS_Detect,		/* RM3 */
	RMS_Non_Op_Dup,		/* RM4 */
	RMS_Ring_Op_Dup,	/* RM5 */
	RMS_Directed,		/* RM6 */
	RMS_Rm_Trace,		/* RM7 */
} rm_state_t;

/* Optical Bypass switch state */
typedef enum {
	OBP_None,
	OBP_ExistsOut,
	OBP_ExistsIn,
} obp_state_t;

/* Path Descriptor PHY */
typedef struct {
	u_short         reserved;
	u_char          phytype;
	u_char          connectstate;
	u_char          remotephytype;
	u_char          remotemac;
	u_short         conresourceindex;
} pd_phy_t;


/* Link Error Rate Monitor Status PHY */
typedef struct {
	u_char          reserved;
	u_char          ler_cutoff;
	u_char          ler_alarm;
	u_char          ler_estimate;
	u_int           lem_reject_ct;
	u_int           lem_ct;
} lem_phy_t;

typedef struct {
	mac_addr_t      mya;	/* address of this station */
	u_char          topology;
	double          timestamp;
	u_int           ticks;
	u_int           nmacs;
	u_int           nphys;
	u_int           station_type;
	pd_phy_t        phy[SUN_STATION_NPHYS];
	lem_phy_t       lem[SUN_STATION_NPHYS];
	u_int           t_req,	/* requested trt */
	                tneg,	/* negotiated trt */
	                tmax,	/* my tmax value */
	                tmin,	/* my t_min value */
	                tvx,	/* my tvx value */
	                sba,	/* count of 80 ms ticks */
	                f_ct,	/* Frame count */
	                e_ct,	/* Error count */
	                l_ct,	/* Lost packet count */
	                receive_ct, transmit_ct, notcopied_ct;

	int             ring_operational;
	ec_state_t      ecm_state;
	ec_status_t     ecm_status;
	obp_state_t     obp_state;
	rm_state_t      rmt_state;
	cf_state_t      cfm_state;
	pc_state_t      pcm_state[SUN_STATION_NPHYS];
	u_int           ring_toggles;
	u_int           receive_full;
	u_int           receive_error;
	u_int           transmit_abort;
	u_int           bytes_xmit;
	u_int           bytes_recv;

	/* The following fields must not be touched by the firmware */
	u_int           transaction_id;
	mac_addr_t      una;	/* address of upstream neighbor */
	mac_addr_t      dna;	/* address of downstream neighbor */
	u_char          untopology;
	u_char          dntopology;
	mac_addr_t      olduna;	/* old address of upstream neighbor */
	mac_addr_t      olddna;	/* old address of downstream neighbor */
	u_int           smt_revision;
	u_char          dupladdress;

	/* Private data */
	int             tvucount;
	int             tvdcount;
} smt_t;

#ifndef ETHERADDRL
#define	ETHERADDRL		6
#endif

/* ioctl state information, use in processing TRANSPARENT IOCTL */
struct iocstate {
	int		state;
	struct {
		caddr_t		addr;
		int		len;
		} udata;	/* user data area: address and length */
	char		*mp;	/* data block containing data to be COPYOUT
				 * into udata.addr */
};

#define GETSTRUCT	0	/* get SMTCB structure */
#define PUTSTRUCT	1	/* write back SMTCB structure */
#define PUTOUTDATA	2	/* put data into user specified buffer */

typedef struct {
	int		command;		/* command or index of regs*/
	int		sub_command;
	int		param1;
	int		param2;
	int		param3;
	u_char		buf[256];
#ifdef _LP64
	u_int		where;  		/* where the I/O string is */
#else
	char		*where;  		/* where the I/O string is */
#endif
	int		length; 		/* length of the string */
} SMTCB;

/* SUB COMMAND NUMBER FOR SMT_GET */
#define GET_COUNTER_GROUP	0x1
#define GET_PORT_GROUP		0x2
#define GET_NEIGHBOR_ADDR	0x3
#define GET_DUP_ADDR_TEST	0x4

/* SUB COMMAND NUMBER FOR SMT_SET */
#define SET_UNA			0x1
#define SET_DNA			0x2
#define XCHG_DUP_ADDR_TEST	0x3

/* SUB COMMAND NUMBER FOR SMTT_ACT */
#define SMT_CTL			0x1

/* SUB COMMAND NUMBER FOR SMT_ACT */
#define SMT_CLOSE		0x1
#define SMT_ACCEPT_FRAME	0x2

typedef struct {
	u_int		late_ct;
	u_int		token_ct;
	u_int		xmit_ct;
	u_int		notcopy_ct;
	u_int		copy_ct;
	u_int		lost_ct;
	u_int		err_ct;
	u_int		frame_ct;
	u_int		ring_ct;
	u_int		tvx_ct;
	u_int		latency_ct;
	u_int		bogus_ct;
} COUNTER_GROUP;

typedef struct {
	u_char		pcm_state;		/* 0x00 */
	u_char		pcm_idx;		/* 0x01 */
	u_short		pcm_policy;		/* 0x10 */
	u_short		r_val;			/* 0x12 */
	u_short		t_val;			/* 0x14 */
	u_char		psc_status;		/* 0x16 */
	u_char		lct_fail;		/* 0x17 */
	u_short		cem_policy;		/* 0x18 */
	u_char		cem_state;		/* 0x1A */
	u_char		lem_reject_ct;		/* 0x1C */
	u_char		ler_average;		/* 0x1D */
	u_char		ler_alarm;		/* 0x1E */
	u_char		ler_cutoff;		/* 0x1F */
	u_char		lem_ct;			/* 0x20 */
	u_char		ebe_ct;			/* 0x24 */
	u_char		ecm_state;		/* 0x30 */
} FDDI_PORT_GROUP;	/* rename to avoid name conflict with SMT 7.2 */

typedef struct {
	u_short		packet_count;
	u_short		control;
	u_short		pad0;
	u_short		FC;
	union {
		u_short 	w[3];
		u_char		b[6];
	} DA;
	union {
		u_short		w[3];
		u_char		b[6];
	} SA;
	u_char		Frame_Class;
	u_char		Frame_Type;
	u_short		Version_ID;
	u_int		Transaction_ID;
	struct {
		u_char		yy[2];
		u_char		xx[6];
	} Station_ID;
	u_short		Pad;
	u_short		InfoField_Length;
} Npi_smt_header;

/* Duplicate address test values */
#define DAT_UNKNOWN		0
#define DAT_PASS		1
#define DAT_FAIL		2
 
#define CLEAR			0
#define SET			1
#define NN_SEND			0
#define NN_WAIT			1

#define A_MASK			(BIT_18 | BIT_19)
#define C_MASK			(BIT_16 | BIT_17)
#define VDL			BIT_23
#define VFCS			BIT_22
#define E_MASK			(BIT_20 | BIT_21)
#define TC_MASK			(BIT_24 | BIT_25)

#define msgblen(bp)		((bp)->b_wptr - (bp)->b_rptr)

#define SMT_BUF_LEN		(4500+8+8)

/*
 *  Mailbox Command Status bits 
 */
#define  HPC_HASNT_READ       (0x01)      /*  HPC has not read command reg yet*/
#define  HPC_HAS_READ         (~HPC_HASNT_READ)
#define  HPC_WRITE_READY      (HPC_HAS_READ)

#define  HPC_HASNT_WRITTEN    (0x02)      /*  HPC has not written yet */
#define  HPC_HAS_WRITTEN      (~HPC_HASNT_WRITTEN)
#define  HPC_READ_READY       (HPC_HAS_WRITTEN)

#define BCOPY(src, dst, len)		bcopy((caddr_t)src, (caddr_t)dst, len)
#define BCLCK   		80			/* 80 ns byte clock */
#define T_MAX   		165*1000000/BCLCK	/* 165 ms */
#define T_MIN   		4*1000000/BCLCK		/* 4 ms */
#define T_TVX   		2500000/BCLCK/255	/* 2.5 ms */
#define T_REQ   		8*1000000/BCLCK		/* 8 ms */

/*
 * Following are the variables and definitions related to the
 * Connection Management (CMT).
 */
#define NMACS   		1
#define NPHYS   		1
#define PHY_S			0
#define NF_SYNCXMIT		0x02

typedef struct {
	int		cmd;
	int		reserved[4];
} fdghdr_t;


typedef struct {
	fdghdr_t	fdghdr;
	smt_t		smt;
} smtcmd_t;

#define	FDDI_SMTINFO		0xF041
#define	FDDI_NSA		0xF04F

#define DL_IOC_FDG			0x8020693B
#define	FDDI_GET_MACID			0x200
#define	FDDI_GET_MYFDDIADDR		0x201
#define	FDDI_GET_MYENETADDR		0x202

#define FDDI_SMT_INFO_RW		0x0100
#define FDDI_SMT_INFO_R			0x0101

typedef struct {
	fdghdr_t	fdghdr;
	mac_addr_t  	macid;
} macidcmd_t;
