h23414
s 00013/00003/01441
d D 4.5.1.1 98/08/28 09:47:57 dcubed 32 31
m 4089720
c Unallocated inodes shouldn't have references to ACLs.  If we get one
c clear it up and complain on the console.  This is a robustness fix
c that prevents the kernel from panicing in acl_rw().
e
s 00001/00001/01443
d D 4.5 94/10/07 21:18:22 dcubed 31 30
m tsmerge
c Add IFACL to vttoif_tab array that was missed in previous merge.
e
s 00003/00003/01441
d D 4.4 94/10/03 14:33:34 dcubed 30 29
m tsmerge
c Fixed complaints from updated chk_ifdef.
e
s 00296/00001/01149
d D 4.3 94/09/13 18:05:00 dcubed 29 27
m tsmerge
c Merging with revision 3.10 from previous release.
e
s 00001/00001/01149
d D 4.2.1.1 94/09/13 18:02:53 dcubed 28 27
m tsmerge
c Format change to make TS1.1 changes clearer.
e
s 00003/00000/01147
d D 4.2 94/08/03 09:37:35 dcubed 27 26
m 
c Alaska id string.
e
s 00049/00376/01098
d D 4.1 94/08/03 09:37:32 dcubed 26 25
m 
c Created from revision 2.84 in base source.
e
s 00030/00000/01444
d D 3.10 94/04/04 17:33:20 rdurbin 25 24
m 1151497
c changes to flush blocks on synchronus updates to inodes
e
s 00145/00063/01299
d D 3.9 93/06/07 14:53:27 alanh 24 23
m 
c Changes to iupdat() and iget() to new ACL implementation.
e
s 00033/00002/01329
d D 3.8 92/11/17 16:07:25 barnhart 23 22
m 
c SunOS_CMW_ACL port to FOXBAT
e
s 00028/00022/01303
d D 3.7 92/10/06 11:36:20 rohy 22 21
m 
c Paste_413
e
s 00019/00008/01306
d D 3.6 92/06/17 13:52:29 codd 21 20
m 
c Changes for Centaurus.B4 (reflect B11 vs B13 mods)
e
s 00038/00000/01276
d D 3.5 92/04/01 18:58:54 codd 20 19
m 
c Changes for CMW101-B1.3 (correct superblock & inode updates)
e
s 00005/00005/01271
d D 3.4 92/03/23 13:00:59 armstron 19 18
m 
c CMW101-B0 changes based upon B10 vs B11
e
s 00178/00031/01098
d D 3.3 92/03/11 19:48:55 codd 18 17
m 
c Changes for CMW1.0.1-B0
e
s 00001/00000/01128
d D 3.2 92/09/12 19:42:43 dorsey 17 16
m 
c Foxbat id string.
e
s 00189/00274/00939
d D 3.1 92/09/12 19:42:43 dorsey 16 15
m 
c Getting in sync with base source revision.
e
s 00003/00002/01210
d D 2.10 92/09/12 19:42:43 dorsey 15 14
m 1097594
c Apply patch 100424-01.
e
s 00016/00005/01196
d D 2.9 92/03/01 19:14:26 dujihara 14 13
m B1080372
c Fixed defect where more DAC privs were needed than necessary.
e
s 00000/00001/01201
d D 2.8 92/01/27 20:56:31 dujihara 13 12
m gm0147
c Fixed typo introduced by Gary's de-wonging.
e
s 00007/00005/01195
d D 2.7 92/01/25 16:53:52 gww 12 11
m 1064590
c Fix privilege testing to set errno when appropriate.
e
s 00004/00002/01196
d D 2.6 91/08/01 17:50:55 dujihara 11 10
m gm0147
c Rearranged inode translation table.
e
s 00014/00003/01184
d D 2.5 91/06/20 16:34:37 dujihara 10 9
m gm0147
c Added MLD tolerance.
e
s 00002/00001/01185
d D 2.4 91/05/09 07:37:07 dujihara 9 8
m gm0134
c Added support for split attribute and data policies.
e
s 00139/00005/01047
d D 2.3 91/03/01 19:56:25 dujihara 8 7
m merge
c Merge with 4.1.1 FCS.
e
s 00001/00000/01051
d D 2.2 91/02/06 11:24:11 marlon 7 6
m 
c Griffon id string.
e
s 00059/00171/00992
d D 2.1 91/02/06 11:24:03 marlon 6 5
m 
c 4.1.1 FCS version.
e
s 00097/00000/01066
d D 1.5 90/12/03 21:12:32 dujihara 5 4
m gm0119
c IL set to system_low on file truncation to zero bytes.  Added privileges to
c iaccess(k).  Added function version of IMARK macro.
e
s 00002/00002/01064
d D 1.4 90/11/20 10:51:15 dujihara 4 3
m gm0119
c Changed cv_uldi_di() to cl_uldi_ic() and cv_di_uldi() to cv_ic_uldi().
e
s 00045/00005/01021
d D 1.3 90/11/08 09:56:57 dujihara 3 2
m gm0119
c Updated iget() to work with labeled and unlabeled disk inodes.  Updated
c iupdat() to work with labeled and unlabeled disk inodes.
e
s 00002/00001/01024
d D 1.2 90/10/31 10:43:13 dujihara 2 1
m 
c Griffon id string.
e
s 01025/00000/00000
d D 1.1 90/10/31 10:43:07 dujihara 1 0
c date and time created 90/10/31 10:43:07 by dujihara
e
u
U
f b
f e 0
f v /usr/local/fswdist/bin/mr_verify
t
T
I 27
#ifdef SunOS_CMW
#ident "%Z%%M% %I% %E% SMI; Trusted Solaris 1.X"
#endif /* SunOS_CMW */
E 27
I 17
D 18
#ident  "%Z%%M% %I% %E% SMI; SunOS CMW"
E 17
I 7
D 15
#ident  "%Z%%M% %I% %E% SMI; SunOS CMW"
E 15
I 15
D 16
#ident  "@(#)ufs_inode.c 2.9 92/03/01 SMI; SunOS CMW"
E 15
E 7
I 1
D 2
/*	@(#)ufs_inode.c 2.72 90/03/30 SMI; from UCB 7.1 6/5/86	*/
E 2
I 2
D 6
/*	%Z%%M% %I% %E% SMI; SunOS CMW
  	@(#)ufs_inode.c 2.72 90/03/30 SMI; from UCB 7.1 6/5/86	*/
E 6
I 6
#ident  "@(#)ufs_inode.c 2.73 90/07/05 SMI" /* from UCB 7.1 6/5/86 */
E 16
I 16
#ident  "@(#)ufs_inode.c 2.83 92/07/16 SMI" /* from UCB 7.1 6/5/86 */
E 18
I 18
D 26
#ident  "%Z%%M% %I% %E% SMI; SunOS CMW-MP"
/* #ident  "@(#)ufs_inode.c 2.77 91/08/23 SMI" from UCB 7.1 6/5/86 */
D 19
/* #ident  "@(#)ufs_inode.c 2.6 91/08/01 SMI; SunOS CMW" */
E 19
I 19
D 21
/* #ident  "@(#)ufs_inode.c 2.8 92/01/27 SMI; SunOS CMW" */
E 21
I 21
/* #ident  "@(#)ufs_inode.c 2.9 92/03/01 SMI; SunOS CMW" */
E 21
E 19
/* #ident  "@(#)ufs_inode.c 2.73 90/07/05 SMI" from UCB 7.1 6/5/86 */
E 26
I 26
#ident  "@(#)ufs_inode.c 2.84 93/02/05 SMI" /* from UCB 7.1 6/5/86 */
E 26
E 18
E 16
E 6
E 2

I 18
D 26

E 26
E 18
I 16
/*LINTLIBRARY*/
E 16

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

/*
D 6
 * Copyright (c) 1988 by Sun Microsystem, Inc.
E 6
I 6
 * Copyright (c) 1988, 1990 by Sun Microsystem, Inc.
E 6
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/user.h>
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <sys/buf.h>
#include <sys/kernel.h>
#include <sys/proc.h>
#include <sys/trace.h>
#include <sys/dnlc.h>
I 16
#include <sys/vaccess.h>	/* ULOCKFS */
#include <sys/lockfs.h>		/* ULOCKFS */
E 16

#include <ufs/mount.h>
#include <ufs/inode.h>
#include <ufs/fs.h>
D 6
#ifdef QUOTA
E 6
I 6
#ifdef	QUOTA
E 6
#include <ufs/quota.h>
#endif
I 16
#include <ufs/lockfs.h>		/* ULOCKFS */
E 16
#include <vm/hat.h>
#include <vm/as.h>
#include <vm/pvn.h>
#include <vm/seg.h>
#include <vm/swap.h>
#include <vm/page.h>
I 29
#ifdef SunOS_CMW
#include <cmw/priv.h>
#include <sys/acl.h>
#include <sys/uio.h>
E 29
I 18
D 26
#ifdef SunOS_CMW
#include <cmw/priv.h>
I 23
D 24
/* SunOS_CMW_ACL { */
E 24
#include <sys/acl.h>
D 24
/* } SunOS_CMW_ACL */
E 24
I 24
#include <sys/uio.h>
E 26
I 25

I 29
extern int SUNW_CMW_flush_buffers;
#endif /* SunOS_CMW */

E 29
D 26
extern int SUNW_CMW_flush_buffers;
E 25
E 24
E 23
#endif /* SunOS_CMW */
E 18
I 8
D 16
#ifdef SunOS_CMW
#include <cmw/priv.h>
#endif /* SunOS_CMW */
E 16
E 8
I 5
D 6
#ifdef SunOS_CMW
#include <cmw/priv.h>
#endif /* SunOS_CMW */
E 6
E 5

E 26
I 16
extern int freemem, lotsfree, pages_before_pager;

E 16
D 6
struct instats ins;
E 6
I 6
struct	instats ins;
E 6

int ino_new;			/* Current # of inodes kmem_allocated */
int ino_free_at_front;		/* # inodes freed at front of free list */
I 18
D 22
int ino_free_at_front_lim = 3;  /* kmem_free when hit this many on front */
E 22
E 18
D 16
int ino_free_at_front_lim = 3;  /* kmem_free when hit this many on front */
E 16

D 6
struct inode *ifreeh, **ifreet;
E 6
I 6
struct	inode *ifreeh, **ifreet;
E 6

union ihead ihead[INOHSZ];

/*
I 22
 * Variables for maintaining the free list of inode structures.
 */
static struct inode *in_free;
D 26
 
E 26
I 26

E 26
#if !(PAGESIZE - 4096)
static u_int nin_incr = (2*PAGESIZE / (sizeof(struct inode)));
#else
static u_int nin_incr = (PAGESIZE / (sizeof(struct inode)));
#endif

/*
E 22
I 16
D 18
 * Variables for maintaining the free list of inode structures.
 */
static struct inode *in_free;

#if !(PAGESIZE - 4096)
static u_int nin_incr = (2*PAGESIZE / (sizeof(struct inode)));
#else
static u_int nin_incr = (PAGESIZE / (sizeof(struct inode)));
#endif

/*
E 18
E 16
 * Convert inode formats to vnode types
 */
D 6
enum vtype iftovt_tab[] = {
E 6
I 6
enum	vtype iftovt_tab[] = {
I 29
#ifdef SunOS_CMW
	VBAD, VFIFO, VCHR, VBAD, VDIR, VMLD, VBLK, VACL, VREG, VBAD, VLNK,
	VBAD, VSOCK, VBAD, VBAD
D 30
#else /* SunOS_CMW */
E 30
I 30
#else /* !SunOS_CMW */
E 30
E 29
I 18
D 26
#ifdef SunOS_CMW
D 23
	VBAD, VFIFO, VCHR, VBAD, VDIR, VMLD, VBLK, VBAD, VREG, VBAD, VLNK,
E 23
I 23
D 24
/* SunOS_CMW_ACL { */
E 24
	VBAD, VFIFO, VCHR, VBAD, VDIR, VMLD, VBLK, VACL, VREG, VBAD, VLNK,
D 24
	/* } SunOS_CMW_ACL */
E 24
E 23
	VBAD, VSOCK, VBAD, VBAD
#else /* SunOS_CMW */
E 26
E 18
E 6
D 10
	VFIFO, VCHR, VDIR, VBLK, VREG, VLNK, VSOCK, VBAD
E 10
I 10
D 11
	VFIFO, VCHR, VDIR, VBLK, VREG, VLNK, VSOCK, VBAD,
E 11
D 16
#ifdef SunOS_CMW
D 11
	VMLD
E 11
I 11
	VBAD, VFIFO, VCHR, VBAD, VDIR, VMLD, VBLK, VBAD, VREG, VBAD, VLNK,
	VBAD, VSOCK, VBAD, VBAD
#else /* SunOS_CMW */
E 16
	VFIFO, VCHR, VDIR, VBLK, VREG, VLNK, VSOCK, VBAD
I 29
#endif /* SunOS_CMW */
E 29
I 18
D 26
#endif /* SunOS_CMW */
E 26
E 18
E 11
D 16
#endif /* SunOS_CMW */
E 16
E 10
};

int vttoif_tab[] = {
I 18
D 26
#ifdef SunOS_CMW
	0, IFREG, IFDIR, IFBLK, IFCHR, IFLNK, IFSOCK, IFMT, IFIFO, IFMLD
I 23
D 24
	/* SunOS_CMW_ACL { */
E 24
	, IFACL
D 24
	/* } SunOS_CMW_ACL */
E 24
E 23
D 21
#else	/* SunOS_CMW */
E 21
I 21
#else /* SunOS_CMW */
E 26
E 21
E 18
D 10
	0, IFREG, IFDIR, IFBLK, IFCHR, IFLNK, IFSOCK, IFMT, IFIFO
E 10
I 10
D 13
	0, IFREG, IFDIR, IFBLK, IFCHR, IFLNK, IFSOCK, IFMT, IFIFO,
E 13
D 16
#ifdef SunOS_CMW
D 12
	IFMLD
E 12
I 12
	0, IFREG, IFDIR, IFBLK, IFCHR, IFLNK, IFSOCK, IFMT, IFIFO, IFMLD
#else /* SunOS_CMW */
E 16
D 28
D 29
	0, IFREG, IFDIR, IFBLK, IFCHR, IFLNK, IFSOCK, IFMT, IFIFO
E 29
I 29
	0, IFREG, IFDIR, IFBLK, IFCHR, IFLNK, IFSOCK, IFMT, IFIFO,
#ifdef SunOS_CMW
D 31
	IFMLD,
E 31
I 31
	IFMLD, IFACL,
E 31
#endif /* SunOS_CMW */
E 29
E 28
I 28
	0, IFREG, IFDIR, IFBLK, IFCHR, IFLNK, IFSOCK, IFMT, IFIFO,
E 28
I 18
D 21
#endif	/* SunOS_CMW */
E 21
I 21
D 26
#endif /* SunOS_CMW */
E 26
E 21
E 18
E 12
D 16
#endif /* SunOS_CMW */
E 16
E 10
};

/*
 * Initialize hash links for inodes
 * and build inode free list.
 */
ihinit()
{
	register int i;
	register union  ihead *ih = ihead;

	for (i = INOHSZ; --i >= 0; ih++) {
		ih->ih_head[0] = ih;
		ih->ih_head[1] = ih;
	}
	ifreeh = NULL;
	ifreet = NULL;
}

I 16
zeroperms()
{
}

#if defined(DEBUG_INODES)
printinode(s, i)
	char *s;
	struct inode *i;
{
    printf("%s inode %d/%d:%d m=%o u=%d g=%d\n",
	   s, major(i->i_dev), minor(i->i_dev), i->i_number,
	   i->i_ic.ic_mode, i->i_ic.ic_uid, i->i_ic.ic_gid);
    if (i->i_ic.ic_mode == 0) {
	printf("strange, perm of zero .. complete contents:\n");

	printf("\tchain: %x %x\n", i->i_chain[0], i->i_chain[1]);
	printf("\tvnode: %x devvp: %x\n", i->i_vnode, i->i_devvp);
	printf("\tflag: %x dev: %d/%d number: %x\n", i->i_flag, major(i->i_dev), minor(i->i_dev), i->i_number);
	printf("\tdiroff: %x fs: %x\n", i->i_diroff, i->i_fs);
	printf("\tdquot: %x owner: %x count: %x\n", i->i_dquot, i->i_owner, i->i_count);
	printf("\tfreef: %x freeb: %x\n", i->i_fr.if_freef, i->i_fr.if_freeb);

	printf("\tmode: %x\tnlink: %x\n", i->i_ic.ic_mode, i->i_ic.ic_nlink);
	printf("\tuid: %x\tgid: %x\n", i->i_ic.ic_uid, i->i_ic.ic_gid);
	printf("\tsize: %x\n", i->i_ic.ic_size);
	printf("\tatime: %x\tmtime: %x\tctime: %x\n", i->i_ic.ic_atime.tv_sec, i->i_ic.ic_mtime.tv_sec, i->i_ic.ic_ctime.tv_sec);
	printf("\tflags: %x\tblocks: %x\tgen: %x\n", i->i_ic.ic_flags, i->i_ic.ic_blocks, i->i_ic.ic_gen);
I 20
D 26
	
#ifdef	NEED4CMWMP
	/*
	 * Print-out the CMW label, privileges, audit_flags, il_gen, etc.
	 * The routine, cmw_print_CL, can be used for printing the label;
	 * however, will need to expand this debugging routine for others.
	 * This issue is deferred until the kernel changes for the initial
	 * port are completed and the system operates correctly.
	 * JJC 4/1/92
	 */
	cmw_print_CL (&i->i_ic.ic_label);
#endif	NEED4CMWMP

E 26
E 20
	zeroperms();
    }
}
#endif

E 16
/*
 * Look up an inode by device, inumber.  If it is in core (in the
 * inode structure), honor the locking protocol.  If it is not in
 * core, read it in from the specified device after freeing any pages.
 * In all cases, a pointer to a locked inode structure is returned.
 */
iget(dev, fs, ino, ipp)
	dev_t dev;
	register struct fs *fs;
	ino_t ino;
	struct inode **ipp;
{
	register struct inode *ip;
	register union  ihead *ih;
	register struct buf *bp;
	register struct dinode *dp;
	register struct inode *iq;
	struct mount *mp;
I 29
#ifdef SunOS_CMW
	union ul_dinode		*ul_dp;		/* unlabeled disk inode ptr */
	int			acl_err;	/* return val from acl_rw() */
#endif /* SunOS_CMW */
E 29
I 18
D 26
#ifdef SunOS_CMW
	union ul_dinode		*ul_dp;		/* unlabeled disk inode ptr */
I 24
	int			acl_err;	/* return val from acl_rw() */
E 24
#endif /* SunOS_CMW */
E 26
E 18
I 8
D 16
#ifdef SunOS_CMW
	union ul_dinode		*ul_dp;		/* unlabeled disk inode ptr */
#endif /* SunOS_CMW */
E 16
E 8
I 3
D 6
#ifdef SunOS_CMW
	union ul_dinode		*ul_dp;		/* unlabeled disk inode ptr */
#endif /* SunOS_CMW */
E 6
E 3
	int inode_dnlc_purge();

	/*
	 * Lookup inode in cache.
	 */
loop:
	mp = getmp(dev);
D 16
	if (mp == NULL) {
		panic("iget: bad dev");
	}
E 16
I 16
	if (mp == NULL)
		return (ENOENT);
E 16
	if (mp->m_bufp->b_un.b_fs != fs)
D 16
		panic("iget: bad fs");
E 16
I 16
		return (ENOENT);
E 16
	ih = &ihead[INOHASH(dev, ino)];
	for (ip = ih->ih_chain[0]; ip != (struct inode *)ih; ip = ip->i_forw) {
		if (ino == ip->i_number && dev == ip->i_dev) {
			/*
			 * Found it - check for locks.
			 */
			if (((ip->i_flag & ILOCKED) != 0) &&
			    ip->i_owner != uniqpid()) {
				ip->i_flag |= IWANT;
				(void) sleep((caddr_t)ip, PINOD);
				goto loop;
			}
			/*
			 * If inode is on free list, remove it.
			 */
			if ((ip->i_flag & IREF) == 0) {
				if (iq = ip->i_freef)
					iq->i_freeb = ip->i_freeb;
				else
					ifreet = ip->i_freeb;
				*ip->i_freeb = iq;
				ip->i_freef = NULL;
				ip->i_freeb = NULL;
			}
			/*
			 * Lock the inode and mark it referenced and return it.
			 */
			ip->i_flag |= IREF;
			ilock(ip);
			VN_HOLD(ITOV(ip));
			*ipp = ip;
			ins.in_hits++;
			trace6(TR_UFS_INSTATS, ip, ip->i_dev, ip->i_number,
				TRC_INSTATS_HIT, ins.in_misses, ins.in_hits);
I 16
#if defined(DEBUG_INODES)
			printinode("iget: cached", ip);
#endif
E 16
			return (0);
		}
	}

	/*
	 * Inode was not in cache.
	 */

	/*
	 * If over high-water mark, and no inodes available on freelist
	 * without attached pages, try to free one up from dnlc.
	 */
	if (ino_new >= ninode)  {
		while (ifreeh == NULL || ITOV(ifreeh)->v_pages) {
			if (dnlc_iter(inode_dnlc_purge, 0) == NULL)
				break;
		}
	}

	/*
	 * If there's a free one available and it has no pages attached
	 * take it. If we're over the high water mark, take it even if
	 * it has attached pages. Otherwise, make a new one.
	 */
	if (ifreeh && (ITOV(ifreeh)->v_pages == NULL || ino_new >= ninode))  {
		ip = ifreeh;
		if (iq = ip->i_freef)
			iq->i_freeb = &ifreeh;
		ifreeh = iq;
		ip->i_freef = NULL;
		ip->i_freeb = NULL;
		/*
		 * When the inode was put on the free list in iinactive,
		 * we did an async syncip() there.  Here we call syncip()
		 * to synchronously wait for any pages that are still
		 * in transit and to invalidate all the pages on the vp
		 * and finally to write back the inode to disk.
		 */
		if (ip->i_flag & IFASTSYMLNK) {
			/* clean up the symbolic link cache content first */
			int i;
			for (i = 1; i < NDADDR && ip->i_db[i]; i++)
				ip->i_db[i] = 0;
			for (i = 0; i < NIADDR && ip->i_ib[i]; i++)
				ip->i_ib[i]=0;
		}
I 29
#ifdef SunOS_CMW
		/*
		 * If this inode had ACL data, (and this inode
		 * is not itself an ACL inode), free the memory
		 * (which also reinitializes the pointer to NULL).
		 * (If this was an ACL inode, it shouldn't have a
		 * reference to a disk acl inode anyway.  This is
		 * just a bit of paranoia to keep us from freeing
		 * data at a bogus pointer.)
		 */

		if (INODE_ACL(ip) && (ip->i_mode & IFMT) != IFACL) {
			kacl_free(&ip->i_icacl);
			ip->i_acl = 0;
			ip->i_aclcnt = 0;
		}
#endif /* SunOS_CMW */
E 29
I 24
D 26
#ifdef	SunOS_CMW
		/*
		 * If this inode had ACL data, (and this inode
		 * is not itself an ACL inode), free the memory
		 * (which also reinitializes the pointer to NULL).
		 * (If this was an ACL inode, it shouldn't have a
		 * reference to a disk acl inode anyway.  This is
		 * just a bit of paranoia to keep us from freeing
		 * data at a bogus pointer.)
		 */

		if (INODE_ACL(ip) && (ip->i_mode & IFMT) != IFACL) {
			kacl_free(&ip->i_icacl);
			ip->i_acl = 0;
			ip->i_aclcnt = 0;
		}
#endif	/* SunOS_CMW */
E 24
I 18
D 22
		ip->i_flag = (ip->i_flag & IMODTIME) | IREF;
E 22
E 18
D 16
		ip->i_flag = IREF;
E 16
		ILOCK(ip);
I 22
                ip->i_flag = (ip->i_flag & (IMODTIME|ILOCKED|IWANT)) | IREF;
E 26
I 26
		ip->i_flag = (ip->i_flag & (IMODTIME|ILOCKED|IWANT)) | IREF;
                VN_HOLD(ITOV(ip)); /* bug 1102884 */
		ILOCK(ip);         /* bug 1102884 */
E 26
E 22
I 16
D 18
		ip->i_flag = (ip->i_flag & (IMODTIME|ILOCKED|IWANT)) | IREF;
E 18
E 16
D 6
#ifdef TRACE
E 6
I 6
#ifdef	TRACE
E 6
		trace_vn_reuse(ITOV(ip));
D 6
#endif TRACE
E 6
I 6
#endif	TRACE
E 6
		if (ITOV(ip)->v_pages == NULL) {
			if (ino_free_at_front > 0)
				ino_free_at_front--;
		}
D 16
		if (syncip(ip, B_INVAL) != 0 || (ip->i_flag & IWANT) != 0) {
E 16
I 16
D 26
		if (syncip(ip, B_INVAL, 1) != 0 || (ip->i_flag & IWANT) != 0) {
E 16
			VN_HOLD(ITOV(ip));
E 26
I 26
		if ((syncip(ip, B_INVAL, 1) != 0) || 
		    ((ip->i_flag & IWANT) != 0) ||
                     (ITOV(ip)->v_count != 1)) {
E 26
			idrop(ip);
			goto loop;
		}
I 16
		ip->i_flag &= ~IMODTIME;
E 16
	} else {
D 16
		ip = (struct inode *)new_kmem_zalloc(sizeof (*ip), KMEM_SLEEP);
E 16
I 16
D 18
		ip = (struct inode *)new_kmem_fast_zalloc((caddr_t *)
			&in_free, sizeof(*in_free), (int)nin_incr, KMEM_SLEEP);
E 18
I 18
D 22
		ip = (struct inode *)new_kmem_zalloc(sizeof (*ip), KMEM_SLEEP);
E 22
I 22
D 26
                ip = (struct inode *)new_kmem_fast_zalloc((caddr_t *)
                        &in_free, sizeof(*in_free), (int)nin_incr, KMEM_SLEEP);
E 26
I 26
		ip = (struct inode *)new_kmem_fast_zalloc((caddr_t *)
			&in_free, sizeof(*in_free), (int)nin_incr, KMEM_SLEEP);
E 26
E 22
E 18
E 16
		ip->i_forw = ip;
		ip->i_back = ip;
		ip->i_vnode.v_data = (caddr_t)ip;
		ip->i_vnode.v_op = &ufs_vnodeops;
		ip->i_flag = IREF;
I 26
		VN_HOLD(ITOV(ip));
E 26
		ILOCK(ip);
		ins.in_malloc++;
		ino_new++;
		ins.in_maxsize = MAX(ins.in_maxsize, ino_new);
	}

	/*
	 * We have to check the inode table again to make sure no
	 * inode with the same (dev, ino) has been created since last
	 * time we checked the inode table. This case can happen
	 * because there are a few places where we can go to sleep.
	 * If another process comes by also trying to iget the same
	 * (dev, ino) while we are sleeping, failing to find one, it
	 * will create an in-core inode with the same (dev, ino). Then
	 * we'll end up with two in-core inodes representing the same
	 * disk inode. This bug has caused a lot of panics due to file
	 * system corruption of various kinds.
	 */
	for (iq = ih->ih_chain[0]; iq != (struct inode *)ih; iq = iq->i_forw) {
		if (ino == iq->i_number && dev == iq->i_dev) {
D 26
			VN_HOLD(ITOV(ip));
E 26
			idrop(ip);
			goto loop;
		}
	}

D 26
	if (ITOV(ip)->v_count != 0)
		panic("free inode isn't");
E 26

	/*
	 * Move the inode on the chain for its new (ino, dev) pair
	 */
	remque(ip);
	insque(ip, ih);
D 6
#ifdef QUOTA
	dqrele(ip->i_dquot);
	ip->i_dquot = NULL;
#endif
E 6
	ip->i_dev = dev;
	ip->i_devvp = mp->m_devvp;
	ip->i_number = ino;
	trace3(TR_MP_INODE, ITOV(ip), dev, ino);
	ip->i_diroff = 0;
	ip->i_fs = fs;
	ip->i_nextr = 0;
I 6
#ifdef	QUOTA
	dqrele(ip->i_dquot);
	ip->i_dquot = NULL;
#endif
E 6
	bp = bread(ip->i_devvp, (daddr_t)fsbtodb(fs, itod(fs, ino)),
	    (int)fs->fs_bsize);
	/*
	 * Check I/O errors
	 */
	if ((bp->b_flags & B_ERROR) != 0) {
		brelse(bp);
		/*
		 * The inode doesn't contain anything useful, so it
		 * would be misleading to leave it on its hash chain.
		 */
		remque(ip);
		ip->i_forw = ip;
		ip->i_back = ip;
		/*
		 * We also loose its inumber, just in case (as iput
		 * doesn't do that any more) - but as it isn't on its
		 * hash chain, I doubt if this is really necessary .. kre
		 * (probably the two methods are interchangable)
		 */
		ip->i_number = 0;
I 26
                ITOV(ip)->v_count = 0;
E 26
		iunlock(ip);
		ip->i_flag = 0;
		/*
		 * Put the inode on the end of the free list.
		 * Maybe we should put it on the beginning of
		 * the free list.
		 */
		if (ifreeh) {
			*ifreet = ip;
			ip->i_freeb = ifreet;
		} else {
			ifreeh = ip;
			ip->i_freeb = &ifreeh;
		}
		ip->i_freef = NULL;
I 26
		ifreet = &ip->i_freef; /* bug 1102884 */

E 26
I 16
#if defined(DEBUG_INODES)
		printf("iget: I/O error reading inode %d/%d:%d\n",
		       major(dev), minor(dev), ino);
#endif
E 16
		return (EIO);
	}
I 29
#ifdef SunOS_CMW
	/*
	 *	Non-CFS gets the CMW label from the mount table.
	 */
	if (fs->fs_magic != CFS_MAGIC) {
		ul_dp = bp->b_un.b_ul_dino;
		ul_dp += itoo(fs, ino);
		cv_uldi_ic(ul_dp, &ip->i_ic);
		ip->i_label = mp->m_label;
	}
	else {
#endif /* SunOS_CMW */
E 29
D 3
	dp = bp->b_un.b_dino;
	dp += itoo(fs, ino);
	ip->i_ic = dp->di_ic;			/* structure assignment */
E 3
I 3
D 6
#ifdef SunOS_CMW
E 6
I 6
D 8
	dp = bp->b_un.b_dino;
	dp += itoo(fs, ino);
	ip->i_ic = dp->di_ic;			/* structure assignment */
E 8
I 8
D 16
#ifdef SunOS_CMW
E 16
I 16
D 18
	dp = bp->b_un.b_dino;
	dp += itoo(fs, ino);
	ip->i_ic = dp->di_ic;			/* structure assignment */
E 18
I 18
D 26
#ifdef SunOS_CMW
E 26
I 26
	dp = bp->b_un.b_dino;
	dp += itoo(fs, ino);
	ip->i_ic = dp->di_ic;			/* structure assignment */
I 29
#ifdef SunOS_CMW
	}
E 29
E 26
E 18
E 16
E 8
E 6
	/*
I 29
	 *	Set the IL generation number because a float operation
	 *	may be necessary for the process requesting this inode.
	 */
	ip->i_il_gen = 0;
#endif /* SunOS_CMW */
	/*
E 29
I 18
D 26
	 *	Non-CFS gets the CMW label from the mount table.
	 */
	if (fs->fs_magic != CFS_MAGIC) {
		ul_dp = bp->b_un.b_ul_dino;
		ul_dp += itoo(fs, ino);
		cv_uldi_ic(ul_dp, &ip->i_ic);
		ip->i_label = mp->m_label;
	}
	else {
#endif /* SunOS_CMW */
		dp = bp->b_un.b_dino;
		dp += itoo(fs, ino);
		ip->i_ic = dp->di_ic;		/* structure assignment */
#ifdef SunOS_CMW
	}
	/*
	 *	Set the IL generation number because a float operation
	 *	may be necessary for the process requesting this inode.
	 */
	ip->i_il_gen = 0;
#endif /* SunOS_CMW */
	/*
E 26
E 18
I 8
D 16
	 *	Non-CFS gets the CMW label from the mount table.
	 */
	if (fs->fs_magic != CFS_MAGIC) {
		ul_dp = bp->b_un.b_ul_dino;
		ul_dp += itoo(fs, ino);
		cv_uldi_ic(ul_dp, &ip->i_ic);
		ip->i_label = mp->m_label;
	}
	else {
#endif /* SunOS_CMW */
		dp = bp->b_un.b_dino;
		dp += itoo(fs, ino);
		ip->i_ic = dp->di_ic;		/* structure assignment */
#ifdef SunOS_CMW
	}
	/*
	 *	Set the IL generation number because a float operation
	 *	may be necessary for the process requesting this inode.
	 */
	ip->i_il_gen = 0;
#endif /* SunOS_CMW */
	/*
E 16
E 8
D 6
	 *	Non-CFS gets the CMW label from the mount table.
E 6
I 6
	 * These are unneeded when we go to the next major release and
	 * get these fields out of icommon.
E 6
	 */
D 6
	if (fs->fs_magic != CFS_MAGIC) {
		ul_dp = bp->b_un.b_ul_dino;
		ul_dp += itoo(fs, ino);
D 4
		cv_uldi_di(ul_dp, &ip->i_ic);
E 4
I 4
		cv_uldi_ic(ul_dp, &ip->i_ic);
E 4
		ip->i_label = mp->m_label;
	}
	else {
#endif /* SunOS_CMW */
		dp = bp->b_un.b_dino;
		dp += itoo(fs, ino);
		ip->i_ic = dp->di_ic;		/* structure assignment */
#ifdef SunOS_CMW
	}
	/*
	 *	Set the IL generation number because a float operation
	 *	may be necessary for the process requesting this inode.
	 */
	ip->i_il_gen = 0;
#endif /* SunOS_CMW */

E 6
I 6
	ip->i_ic.ic_delayoff = 0;		/* XXX */
	ip->i_ic.ic_delaylen = 0;		/* XXX */
	ip->i_ic.ic_nextrio = 0;		/* XXX */
	ip->i_ic.ic_writes = 0;			/* XXX */
E 6
E 3
	VN_INIT(ITOV(ip), mp->m_vfsp, IFTOVT(ip->i_mode), ip->i_rdev);
	if (ino == (ino_t)ROOTINO) {
		ITOV(ip)->v_flag |= VROOT;
	}
	brelse(bp);
I 29
#ifdef SunOS_CMW
	/*
	 * If there is an ACL associated with this inode,
	 * and the ACL data is not yet hanging off the
	 * in-core inode, and (just to be safe) this inode 
	 * is NOT itself an ACL inode, then call acl_rw() 
	 * to get the ACL inode and read in the ACL data.
	 * This will hang the ACL data off of the in-core
	 * inode.
	 *
	 * NOTE: acl_rw() does all the setup and work.  It
	 * also calls iget() again using the ACL inode #.
	 * The if statement below will (should) prevent us
	 * from recursing more than once.
	 */
D 32
	if (INODE_ACL(ip) && !INODE_ICACL(ip) && (ip->i_mode & IFMT) != IFACL) {
		if ((acl_err = acl_rw(UIO_READ, ip, &ip->i_icacl)) != 0) {
E 32
I 32
	if (INODE_ACL(ip)) {
		/*
		 * We are getting a free inode and it has an ACL reference.
		 * This shouldn't happen, but if it does we don't want an
		 * unrelated ACL to be attached to the new object.
		 */
		if (ip->i_mode == 0) {
			printf("iget: free inode %s/%d had acl=%d\n",
			    fs->fs_fsmnt, ino, ip->i_acl);
			ip->i_acl = 0;
		}
		else if (!INODE_ICACL(ip) && (ip->i_mode & IFMT) != IFACL &&
		    (acl_err = acl_rw(UIO_READ, ip, &ip->i_icacl)) != 0) {
E 32
			return(acl_err);
		}
D 32

E 32
	}
#endif /* SunOS_CMW */

E 29
I 24
D 26
#ifdef SunOS_CMW
	/*
	 * If there is an ACL associated with this inode,
	 * and the ACL data is not yet hanging off the
	 * in-core inode, and (just to be safe) this inode 
	 * is NOT itself an ACL inode, then call acl_rw() 
	 * to get the ACL inode and read in the ACL data.
	 * This will hang the ACL data off of the in-core
	 * inode.
	 *
	 * NOTE: acl_rw() does all the setup and work.  It
	 * also calls iget() again using the ACL inode #.
	 * The if statement below will (should) prevent us
	 * from recursing more than once.
	 */
	if (INODE_ACL(ip) && !INODE_ICACL(ip) && (ip->i_mode & IFMT) != IFACL) {
		if ((acl_err = acl_rw(UIO_READ, ip, &ip->i_icacl)) != 0) {
			return(acl_err);
		}

	}
#endif	/* SunOS_CMW */

E 26
E 24
D 6
#ifdef QUOTA
E 6
I 6
#ifdef	QUOTA
E 6
	if (ip->i_mode != 0)
		ip->i_dquot = getinoquota(ip);
#endif
	*ipp = ip;
	ins.in_misses++;
	trace6(TR_UFS_INSTATS, ip, ip->i_dev, ip->i_number, TRC_INSTATS_MISS,
		ins.in_misses, ins.in_hits);
I 16
#if defined(DEBUG_INODES)
	printinode("iget: read", ip);
#endif
E 16
	return (0);
}

/*
 * Unlock inode and vrele associated vnode
 */
iput(ip)
	register struct inode *ip;
{

	if ((ip->i_flag & ILOCKED) == 0)
		panic("iput");
	iunlock(ip);
	ITIMES(ip);
	VN_RELE(ITOV(ip));
}

/*
 * Check that inode is not locked and release associated vnode.
 */
irele(ip)
	register struct inode *ip;
{

	if (ip->i_flag & ILOCKED)
		panic("irele");
	ITIMES(ip);
	VN_RELE(ITOV(ip));
}

/*
 * Drop inode without going through the normal
 * chain of unlocking and releasing.
 */
idrop(ip)
	register struct inode *ip;
{
	register struct vnode *vp = &ip->i_vnode;

	if ((ip->i_flag & ILOCKED) == 0)
		panic("idrop");
	iunlock(ip);
	if (--vp->v_count == 0) {
I 26
		if (ip->i_freeb || ip->i_freef)
                        panic("idrop: inactivating inactive inode");
E 26
D 16
		/* retain the fast symlnk flag */
		if (ip->i_flag & IFASTSYMLNK) ip->i_flag = IFASTSYMLNK;
		else ip->i_flag = 0;
E 16
I 16
		/* retain the fast symlnk flag and mtime-okay flag */
		ip->i_flag &= (IFASTSYMLNK|IMODTIME);
E 16
		/*
		 * Put the inode back on the end of the free list.
		 */
		if (ifreeh) {
			*ifreet = ip;
			ip->i_freeb = ifreet;
		} else {
			ifreeh = ip;
			ip->i_freeb = &ifreeh;
		}
		ip->i_freef = NULL;
		ifreet = &ip->i_freef;
	}
}

I 26
static int i_genrand = 1234;
E 26
/*
 * Vnode is no longer referenced, write the inode out
 * and if necessary, truncate and deallocate the file.
 */
iinactive(ip)
	register struct inode *ip;
{
	int mode;

	if ((ip->i_flag & (IREF|ILOCKED)) != IREF || ip->i_freeb || ip->i_freef)
		panic("iinactive");
D 16
	if (ip->i_fs->fs_ronly == 0) {
E 16
I 16
	if (ip->i_fs && ip->i_mode && ip->i_fs->fs_ronly == 0) {
E 16
		ilock(ip);
		if (ip->i_nlink <= 0) {
D 15
			ip->i_gen++;
E 15
I 15
D 16
			ip->i_gen += (time.tv_sec & 0x000000ff) +
			    (time.tv_usec >> 8) + 1;
E 16
I 16
			if (ULOCKFS_IS_NOIDEL(ITOU(ip))) {
				iunlock(ip);
				return;
			}
D 26
			ip->i_gen++;
E 26
I 26
			i_genrand *= 16843009;  /* turns into shift and adds */
			i_genrand++;
			ip->i_gen += ((i_genrand + lbolt) & 0xffff) + 1;
E 26
E 16
E 15
			(void) itrunc(ip, (u_long)0);
			mode = ip->i_mode;
			ip->i_mode = 0;
			ip->i_rdev = 0;
			ip->i_flag |= IUPD|ICHG;
			ifree(ip, ip->i_number, mode);
D 6
#ifdef QUOTA
E 6
I 6
#ifdef	QUOTA
E 6
			(void) chkiq(VFSTOM(ip->i_vnode.v_vfsp),
			    ip, (int)ip->i_uid, 0);
			dqrele(ip->i_dquot);
			ip->i_dquot = NULL;
#endif
			IUPDAT(ip, 0)
		} else if (!IS_SWAPVP(ITOV(ip))) {
			/*
			 * Do an async write (B_ASYNC) of the pages
			 * on the vnode and put the pages on the free
			 * list when we are done (B_FREE).  This action
			 * will cause all the pages to be written back
			 * for the file now and will allow update() to
			 * skip over inodes that are on the free list.
I 16
			 *
			 * NOTE:  The pages associated with this vnode are
			 * freed only if the system is low on memory.
E 16
			 */
D 16
			(void) syncip(ip, B_FREE | B_ASYNC);
E 16
I 16
			if (freemem < lotsfree + pages_before_pager)
				(void) syncip(ip, B_FREE | B_ASYNC, 0);
			else {
				IUPDAT(ip, 0);
			}
D 22
				
D 18
		} else {
			IUPDAT(ip, 0);
E 18
E 16
		}
		iunlock(ip);
E 22
I 22
D 26

                } else {
                        IUPDAT(ip, 0);
                }
                iunlock(ip);
E 26
I 26
				
		} else {
			IUPDAT(ip, 0);
		}
		iunlock(ip);
E 26
E 22
	}
I 26
 	if (ip->i_freeb || ip->i_freef)
                panic("iinactive: inactivating inactive inode");
E 26

	/* retain the fast symlnk flag */
D 16
	if (ip->i_flag & IFASTSYMLNK) ip->i_flag = IFASTSYMLNK;
	else ip->i_flag = 0;
E 16
I 16
	ip->i_flag &= (IFASTSYMLNK|IMODTIME);
	ITOV(ip)->v_op = &ufs_vnodeops;
E 16
	/*
	 * If the inode has associated pages put it on the back of the
D 16
	 * free list. If it has none, put it on the front, unless we
	 * we've already got a bunch of them on the front, in which case
	 * remove it completely from the inode pool.
E 16
I 16
D 18
	 * free list. If it has none, put it on the front.
E 18
I 18
D 22
	 * free list. If it has none, put it on the front, unless we
	 * we've already got a bunch of them on the front, in which case
	 * remove it completely from the inode pool.
E 22
I 22
D 26
         * free list. If it has none, put it on the front.
E 26
I 26
	 * free list. If it has none, put it on the front.
E 26
E 22
E 18
E 16
	 * Also, fast symbolic inode always put at end of free list
	 */
	if (ITOV(ip)->v_pages || ip->i_flag & IFASTSYMLNK) {
		if (ifreeh) {
			*ifreet = ip;
			ip->i_freeb = ifreet;
		} else {
			ifreeh = ip;
			ip->i_freeb = &ifreeh;
		}
		ip->i_freef = NULL;
		ifreet = &ip->i_freef;
		ins.in_frback++;
D 16
	} else if (ino_free_at_front < ino_free_at_front_lim) {
E 16
I 16
D 18
	} else {
E 18
I 18
D 22
	} else if (ino_free_at_front < ino_free_at_front_lim) {
E 22
I 22
D 26
        } else {
E 26
I 26
	} else {
E 26
E 22
E 18
E 16
		if (ifreeh) {
			ip->i_freef = ifreeh;
			ifreeh->i_freeb = &ip->i_freef;
		} else {
			ip->i_freef = NULL;
			ifreet = &ip->i_freef;
		}
		ifreeh = ip;
		ip->i_freeb = &ifreeh;
		ino_free_at_front++;
		ins.in_frfront++;
I 18
D 22
	} else {
		remque(ip);
#ifdef	QUOTA
		dqrele(ip->i_dquot);
		ip->i_dquot = NULL;
#endif
		IUPDAT(ip, 0);
		kmem_free((caddr_t) ip, sizeof (*ip));
		ins.in_mfree++;
		ino_new--;
E 22
E 18
D 16
	} else {
		remque(ip);
D 6
#ifdef QUOTA
E 6
I 6
#ifdef	QUOTA
E 6
		dqrele(ip->i_dquot);
		ip->i_dquot = NULL;
#endif
		IUPDAT(ip, 0);
		kmem_free((caddr_t) ip, sizeof (*ip));
		ins.in_mfree++;
		ino_new--;
E 16
	}
}

/*
 * Check accessed and update flags on an inode structure.
 * If any is on, update the inode with the (unique) current time.
 * If waitfor is given insure i/o order so wait for write to complete.
 */
iupdat(ip, waitfor)
	register struct inode *ip;
	int waitfor;
{
	register struct buf *bp;
	register struct fs *fp;
	struct dinode *dp;
	int fastsymflag;		/* fast symbolic link is active */
	long fastsymlnk[FSL_SIZE / sizeof (long)]; /* for sun4 alignment */
I 29
#ifdef SunOS_CMW
	union ul_dinode		*ul_dp;		/* unlabeled disk inode ptr */
	int	err;
E 29
I 18
D 26
#ifdef SunOS_CMW
	union ul_dinode		*ul_dp;		/* unlabeled disk inode ptr */
I 25
	int	err;
E 26

I 29
	/*
	 * The following was added to fix a theoretical problem at the
	 * request of the NCS team. Nobody has been able to provide a test
	 * case that proves the need for this code change. The theoretical
	 * problem is that blocks can be associated with a file before the
	 * users data is written to the blocks. To ensure that the data
	 * blocks are always updated before the inode, the dirty pages are
	 * always flushed synchronusly before any synchronus inode writes.
	 *
	 * If FLUSH_DISK_BUFFERS is true, we are doing a synchronus write and
	 * DONT_SYNCIP is not true we want to flush any dirty pages associated
	 * with the inode.
	 *
	 * waitfor will only be 1 if we are doing a synchronous write and we
	 * were not called from syncip;
	 *
	 * The DONT_SYNCIP bit is cleared from waitfor if we were called from
	 * syncip.
	 */
	if (FLUSH_DISK_BUFFERS && (waitfor == 1)) {
		err = syncip(ip, 0, 1);         /* do synchronous writes */
		if (!err)
			(void) sync_indir(ip);  /* flush indirect block ptrs */
		return;
	} else
		waitfor &= ~DONT_SYNCIP;
#endif /* SunOS_CMW */

E 29
D 26
	/*
	 * The following was added to fix a theoretical problem at the
	 * request of the NCS team. Nobody has been able to provide a test
	 * case that proves the need for this code change. The theoretical
	 * problem is that blocks can be associated with a file before the
	 * users data is written to the blocks. To ensure that the data
	 * blocks are always updated before the inode, the dirty pages are
	 * always flushed synchronusly before any synchronus inode writes.
	 *
	 * If FLUSH_DISK_BUFFERS is true, we are doing a synchronus write and
	 * DONT_SYNCIP is not true we want to flush any dirty pages associated
	 * with the inode.
	 *
	 * waitfor will only be 1 if we are doing a synchronous write and we
	 * were not called from syncip;
	 *
	 * The DONT_SYNCIP bit is cleared from waitfor if we were called from
	 * syncip.
	 */
	if (FLUSH_DISK_BUFFERS && (waitfor == 1)) {
		err = syncip(ip, 0, 1);         /* do synchronous writes */
		if (!err)
			(void) sync_indir(ip);  /* flush indirect block ptrs */
		return;
	} else
		waitfor &= ~DONT_SYNCIP;
E 25
#endif /* SunOS_CMW */
E 18
I 8
D 16
#ifdef SunOS_CMW
	union ul_dinode		*ul_dp;		/* unlabeled disk inode ptr */
#endif /* SunOS_CMW */
E 16
E 8
I 3
D 6
#ifdef SunOS_CMW
	union ul_dinode		*ul_dp;		/* unlabeled disk inode ptr */
#endif /* SunOS_CMW */
E 6
E 3

E 26
	fp = ip->i_fs;
I 29

#ifdef SunOS_CMW
	/*
	 * Check to see if we modified the ACL data, and
	 * (just as a precaution, this inode is not itself
	 * and ACL inode.  If so, write the new ACL data
	 * back to the ACL inode.
	 *
	 * NOTE: acl_rw() will call iput() which eventually
	 * gets us back here again.  The if statement below
	 * will (should) keep us from recursing more than once.
	 */
	if ((ip->i_flag & IMODACL) && (ip->i_mode & IFMT) != IFACL) {
		(void) acl_rw(UIO_WRITE, ip, &ip->i_icacl);

		ip->i_flag &= ~IMODACL;
	}
#endif /* SunOS_CMW */

E 29
I 24
D 26

#ifdef SunOS_CMW
	/*
	 * Check to see if we modified the ACL data, and
	 * (just as a precaution, this inode is not itself
	 * and ACL inode.  If so, write the new ACL data
	 * back to the ACL inode.
	 *
	 * NOTE: acl_rw() will call iput() which eventually
	 * gets us back here again.  The if statement below
	 * will (should) keep us from recursing more than once.
	 */
	if ((ip->i_flag & IMODACL) && (ip->i_mode & IFMT) != IFACL) {
		(void) acl_rw(UIO_WRITE, ip, &ip->i_icacl);

		ip->i_flag &= ~IMODACL;
	}
#endif /* SunOS_CMW */

#ifdef SunOS_CMW_NEVER
	if ((ip->i_flag & (IUPD|IACC|ICHG|IMOD|IMODACC|IMODACL)) != 0) {
#else
E 26
E 24
D 16
	if ((ip->i_flag & (IUPD|IACC|ICHG|IMOD)) != 0) {
D 6
		if (fp->fs_ronly)
E 6
I 6
		if (fp->fs_ronly) {
E 16
I 16
	if ((ip->i_flag & (IUPD|IACC|ICHG|IMOD|IMODACC)) != 0) {
I 24
D 26
#endif /* SunOS_CMW */
E 26
E 24
		if (fp == NULL || fp->fs_ronly)
E 16
E 6
			return;
I 6
D 16
		}
E 16
I 16
		ufs_notclean(ITOM(ip), fp);
E 16
E 6
		fastsymflag = (ip->i_flag & IFASTSYMLNK);
		if (fastsymflag) {
			/* save fast sym link */
			int i;

			(void) bcopy((caddr_t) &ip->i_db[1],
				(caddr_t) fastsymlnk, (u_int)ip->i_size);
			ip->i_flag &= ~IFASTSYMLNK;
			for (i = 1; i < NDADDR && ip->i_db[i]; i++)
				ip->i_db[i] = 0;
			for (i = 0; i < NIADDR && ip->i_ib[i]; i++)
				ip->i_ib[i] = 0;
		}
		bp = bread(ip->i_devvp,
		    (daddr_t)fsbtodb(fp, itod(fp, ip->i_number)),
		    (int)fp->fs_bsize);
		if (bp->b_flags & B_ERROR) {
			brelse(bp);
			return;
		}
		if (ip->i_flag & (IUPD|IACC|ICHG))
			IMARK(ip);
D 16
		ip->i_flag &= ~(IUPD|IACC|ICHG|IMOD);
D 3
		dp = bp->b_un.b_dino + itoo(fp, ip->i_number);
		dp->di_ic = ip->i_ic;	/* structure assignment */
E 3
I 3
D 6
#ifdef SunOS_CMW
E 6
I 6
D 8
		dp = bp->b_un.b_dino + itoo(fp, ip->i_number);
		dp->di_ic = ip->i_ic;	/* structure assignment */
E 8
I 8
#ifdef SunOS_CMW
E 16
I 16
		ip->i_flag &= ~(IUPD|IACC|ICHG|IMOD|IMODACC);
I 29
#ifdef SunOS_CMW
		/*
		 *	Non-CFS ignores the CMW label.
		 */
		if (fp->fs_magic != CFS_MAGIC) {
			ul_dp = bp->b_un.b_ul_dino + itoo(fp, ip->i_number);
			cv_ic_uldi(&ip->i_ic, ul_dp);
			dp = (struct dinode *) ul_dp;
		}
		else {
#endif /* SunOS_CMW */
E 29
D 18
		dp = bp->b_un.b_dino + itoo(fp, ip->i_number);
		dp->di_ic = ip->i_ic;	/* structure assignment */
E 18
I 18
D 26
#ifdef SunOS_CMW
E 26
I 26
		dp = bp->b_un.b_dino + itoo(fp, ip->i_number);
		dp->di_ic = ip->i_ic;	/* structure assignment */
I 29
#ifdef SunOS_CMW
		}
#endif /* SunOS_CMW */
E 29
E 26
I 23
D 24
		/* SunOS_CMW_ACL { */
		if (ip->i_icacl != NULL) {		/* free in-core ACL */
			(void)dacl_free(ip->i_icacl);
			ip->i_icacl = NULL;
		}
		/* } SunOS_CMW_ACL */
E 24
E 23
E 18
E 16
E 8
E 6
		/*
I 18
D 26
		 *	Non-CFS ignores the CMW label.
		 */
		if (fp->fs_magic != CFS_MAGIC) {
			ul_dp = bp->b_un.b_ul_dino + itoo(fp, ip->i_number);
			cv_ic_uldi(&ip->i_ic, ul_dp);
I 20
			
#ifdef	NEED4CMWMP
			/*
D 24
			 * This statement corrects a bug which may crash the system
			 * or lead to odd system behavior when non-CFS filesystems
			 * are being updated under SunOS CMW.
			 * JJC 4/1/92
E 24
I 24
			 * This statement corrects a bug which may crash 
			 * the system or lead to odd system behavior when 
			 * non-CFS filesystems are being updated under 
			 * SunOS CMW.   JJC 4/1/92
E 24
			 */
#endif	NEED4CMWMP
			dp = (struct dinode *) ul_dp;
E 20
		}
		else {
#endif /* SunOS_CMW */
			dp = bp->b_un.b_dino + itoo(fp, ip->i_number);
			dp->di_ic = ip->i_ic;	/* structure assignment */
#ifdef SunOS_CMW
		}
#endif /* SunOS_CMW */
		/*
E 26
E 18
I 8
D 16
		 *	Non-CFS ignores the CMW label.
		 */
		if (fp->fs_magic != CFS_MAGIC) {
			ul_dp = bp->b_un.b_ul_dino + itoo(fp, ip->i_number);
			cv_ic_uldi(&ip->i_ic, ul_dp);
		}
		else {
#endif /* SunOS_CMW */
			dp = bp->b_un.b_dino + itoo(fp, ip->i_number);
			dp->di_ic = ip->i_ic;	/* structure assignment */
#ifdef SunOS_CMW
		}
#endif /* SunOS_CMW */
		/*
E 16
E 8
D 6
		 *	Non-CFS ignores the CMW label.
E 6
I 6
		 * These are unneeded when we go to the next major release and
		 * get these fields out of icoomon.
E 6
		 */
D 6
		if (fp->fs_magic != CFS_MAGIC) {
			ul_dp = bp->b_un.b_ul_dino + itoo(fp, ip->i_number);
D 4
			cv_di_uldi(&ip->i_ic, ul_dp);
E 4
I 4
			cv_ic_uldi(&ip->i_ic, ul_dp);
E 4
		}
		else {
#endif /* SunOS_CMW */
			dp = bp->b_un.b_dino + itoo(fp, ip->i_number);
			dp->di_ic = ip->i_ic;	/* structure assignment */
#ifdef SunOS_CMW
	}
#endif /* SunOS_CMW */
E 6
I 6
		dp->di_un.di_icom.ic_delayoff = 0;	/* XXX */
		dp->di_un.di_icom.ic_delaylen = 0;	/* XXX */
		dp->di_un.di_icom.ic_nextrio = 0;	/* XXX */
		dp->di_un.di_icom.ic_writes = 0;		/* XXX */
E 6
E 3
D 16
		if (waitfor)
E 16
I 16
		if (waitfor && ((ITOM(ip)->m_dio & MDIO_ON) == 0))
E 16
			bwrite(bp);
		else
			bdwrite(bp);

		/* restore inode */
		if (fastsymflag) {
			bcopy((caddr_t) fastsymlnk, (caddr_t) &ip->i_db[1],
				(u_int)ip->i_size);
			ip->i_flag |= IFASTSYMLNK;
		}
	}
}

#define	SINGLE	0	/* index of single indirect block */
#define	DOUBLE	1	/* index of double indirect block */
#define	TRIPLE	2	/* index of triple indirect block */

/*
 * Release blocks associated with the inode ip and
 * stored in the indirect block bn.  Blocks are free'd
 * in LIFO order up to (but not including) lastbn.  If
 * level is greater than SINGLE, the block is an indirect
 * block and recursive calls to indirtrunc must be used to
 * cleanse other indirect blocks.
 *
 * N.B.: triple indirect blocks are untested.
 */
static long
indirtrunc(ip, bn, lastbn, level)
	register struct inode *ip;
	daddr_t bn, lastbn;
	int level;
{
	register int i;
	struct buf *bp, *copy;
	register daddr_t *bap;
	register struct fs *fs = ip->i_fs;
	daddr_t nb, last;
	long factor;
	int blocksreleased = 0, nblocks;

	/*
	 * Calculate index in current block of last
	 * block to be kept.  -1 indicates the entire
	 * block so we need not calculate the index.
	 */
	factor = 1;
	for (i = SINGLE; i < level; i++)
		factor *= NINDIR(fs);
	last = lastbn;
	if (lastbn > 0)
		last /= factor;
	nblocks = btodb(fs->fs_bsize);
	/*
	 * Get buffer of block pointers, zero those
	 * entries corresponding to blocks to be free'd,
	 * and update on disk copy first.
	 */
	copy = geteblk((int)fs->fs_bsize);
	bp = bread(ip->i_devvp, (daddr_t)fsbtodb(fs, bn), (int)fs->fs_bsize);
	if (bp->b_flags & B_ERROR) {
		brelse(copy);
		brelse(bp);
		return (0);
	}
	bap = bp->b_un.b_daddr;
	bcopy((caddr_t)bap, (caddr_t)copy->b_un.b_daddr, (u_int)fs->fs_bsize);
	bzero((caddr_t)&bap[last + 1],
		(u_int)(NINDIR(fs) - (last + 1)) * sizeof (daddr_t));
	bwrite(bp);
	bp = copy, bap = bp->b_un.b_daddr;

	/*
	 * Recursively free totally unused blocks.
	 */
	for (i = NINDIR(fs) - 1; i > last; i--) {
		nb = bap[i];
		if (nb == 0)
			continue;
		if (level > SINGLE)
			blocksreleased +=
			    indirtrunc(ip, nb, (daddr_t)-1, level - 1);
		free(ip, nb, (off_t)fs->fs_bsize);
		blocksreleased += nblocks;
	}

	/*
	 * Recursively free last partial block.
	 */
	if (level > SINGLE && lastbn >= 0) {
		last = lastbn % factor;
		nb = bap[i];
		if (nb != 0)
			blocksreleased += indirtrunc(ip, nb, last, level - 1);
	}
	brelse(bp);
	return (blocksreleased);
}

/*
 * Truncate the inode ip to at most length size.
 * Free affected disk blocks -- the blocks of the
 * file are removed in reverse order.
 *
 * N.B.: triple indirect blocks are untested.
 */
itrunc(oip, length)
	register struct inode *oip;
	u_long length;
{
	register struct fs *fs = oip->i_fs;
	register struct inode *ip;
	register daddr_t lastblock;
	register off_t bsize;
	register int offset;
	daddr_t bn, lastiblock[NIADDR];
	int level;
	long nblocks, blocksreleased = 0;
	register int i;
	struct inode tip;
	daddr_t llbn;

	/*
	 * We only allow truncation of regular files and directories
	 * to arbritary lengths here.  In addition, we allow symbolic
	 * links to be truncated only to zero length.  Other inode
	 * types cannot have their length set here since disk blocks
	 * are being dealt with - especially device inodes where
	 * ip->i_rdev is actually being stored in ip->i_db[0]!
	 */
	i = oip->i_mode & IFMT;
I 29
#ifdef SunOS_CMW
	/* allow truncation of ACLs too!!! */
	if (i != IFREG && i != IFDIR && i != IFMLD && i != IFLNK && i != IFACL)
D 30
#else /* SunOS_CMW */
E 30
I 30
#else /* !SunOS_CMW */
E 30
E 29
I 18
D 26
#ifdef SunOS_CMW
D 23
	if (i != IFREG && i != IFDIR && i != IFMLD && i != IFLNK)
E 23
I 23
	/* SunOS_CMW_ACL { - allow truncation of ACLs too!!! */
	if (i != IFREG && i != IFDIR && i != IFMLD && i != IFLNK && i != IFACL)
	/* } SunOS_CMW_ACL */
E 23
#else /* SunOS_CMW */
E 26
E 18
I 10
D 16
#ifdef SunOS_CMW
	if (i != IFREG && i != IFDIR && i != IFMLD && i != IFLNK)
#else /* SunOS_CMW */
E 16
E 10
	if (i != IFREG && i != IFDIR && i != IFLNK)
I 29
#endif /* SunOS_CMW */
E 29
I 18
D 26
#endif /* SunOS_CMW */
E 26
E 18
I 10
D 16
#endif /* SunOS_CMW */
E 16
E 10
		return (0);
	else if (i == IFLNK && length != 0)
		return (EINVAL);
D 16

	if (length == oip->i_size)
E 16
I 16
D 18
/*
 * POSIX requires modification time be updated on truncation
 */
	if (length == oip->i_size) {
		oip->i_flag |= ICHG|IUPD;
E 18
I 18

D 22
	if (length == oip->i_size)
E 18
E 16
		return (0);
E 22
I 22
D 26
/*
 * POSIX requires modification time be updated on truncation
 */
        if (length == oip->i_size) {
                oip->i_flag |= ICHG|IUPD;
                return (0);
        }
E 26
I 26
        /*
         * POSIX requires modification time be updated on truncation
        */
        /*
        ** Certain vendors NFS clients either allows file sizes over 2G
        ** or they are buggy and just don't check for bogus offsets so
        ** we need to check for that here.
        */
       if ((long)length < 0)
                return (EFBIG);
E 26
E 22
I 16
D 18
	}
E 18
E 16

I 26
	if (length == oip->i_size) {
		oip->i_flag |= ICHG|IUPD;
		return (0);
	}

E 26
	if (oip->i_flag & IFASTSYMLNK) {
		int j;
		oip->i_flag &= ~IFASTSYMLNK;
		for (j = 1; j < NDADDR && oip->i_db[j]; j++)
			oip->i_db[j] = 0;
		for (j = 0; j < NIADDR && oip->i_ib[j]; j++)
			oip->i_ib[j] = 0;
	}
I 6

E 6
	offset = blkoff(fs, length);
	llbn = lblkno(fs, length - 1);
D 6

E 6
	if (length > oip->i_size) {
		int err;

		/*
D 6
		 * Trunc up case.  BMAPALLOC will insure that the right blocks
		 * are allocated.  This includes extending the old frag to a
		 * full block (if needed) in addition to doing any work
		 * needed for allocating the last block.
E 6
I 6
		 * Trunc up case.  We need to call bmap_write() because of
		 * frags since the number of frags is calculated from the size.
E 6
		 */
		if (offset == 0)
			err = BMAPALLOC(oip, llbn, (int)fs->fs_bsize);
		else
			err = BMAPALLOC(oip, llbn, offset);
D 6

E 6
		if (err == 0) {
			oip->i_size = length;
			oip->i_flag |= ICHG;
			ITIMES(oip);
		}
D 6

E 6
		return (err);
	}

	/*
I 6
	 * Forget about delayed pages that will be past the end of the file.
	 */
	if (oip->i_delaylen && oip->i_delayoff + oip->i_delaylen > length) {
		oip->i_delaylen -= oip->i_delayoff + oip->i_delaylen - length;
		if (oip->i_delaylen <= 0)
			oip->i_delaylen = oip->i_delayoff = 0;
	}

	/*
E 6
	 * Update the pages of the file.  If the file is not being
	 * truncated to a block boundary, the contents of the
	 * pages following the end of the file must be zero'ed
	 * in case it ever become accessable again because
	 * of subsequent file growth.
	 */
	trace3(TR_MP_TRUNC, ITOV(oip), length, oip->i_size);
	if (offset == 0) {
		pvn_vptrunc(ITOV(oip), (u_int)length, (u_int)0);
	} else {
		int err;

		/*
I 6
		 * Trunc down case.
E 6
		 * Make sure that the last block is properly allocated.
		 * We only really have to do this if the last block is
		 * actually allocated since bmap will now handle the case
D 6
		 * of an fragment which is has no block allocated.  Just to
E 6
I 6
		 * of a fragment which is has no block allocated.  Just to
E 6
		 * be sure, we do it now independent of current allocation.
		 */
D 6
		err = BMAPALLOC(oip, llbn, offset);
		if (err)
E 6
I 6
		if (err = BMAPALLOC(oip, llbn, offset))
E 6
			return (err);
I 6

		/*
		 * Caclulate how much to zero past EOF.
		 */
E 6
		bsize = llbn >= NDADDR? fs->fs_bsize : fragroundup(fs, offset);
		pvn_vptrunc(ITOV(oip), (u_int)length, (u_int)(bsize - offset));
	}

	/*
	 * Calculate index into inode's block list of
	 * last direct and indirect blocks (if any)
	 * which we want to keep.  Lastblock is -1 when
	 * the file is truncated to 0.
	 */
	lastblock = lblkno(fs, length + fs->fs_bsize - 1) - 1;
	lastiblock[SINGLE] = lastblock - NDADDR;
	lastiblock[DOUBLE] = lastiblock[SINGLE] - NINDIR(fs);
	lastiblock[TRIPLE] = lastiblock[DOUBLE] - NINDIR(fs) * NINDIR(fs);
	nblocks = btodb(fs->fs_bsize);

	/*
	 * Update file and block pointers
	 * on disk before we start freeing blocks.
	 * If we crash before free'ing blocks below,
	 * the blocks will be returned to the free list.
	 * lastiblock values are also normalized to -1
	 * for calls to indirtrunc below.
	 */
	tip = *oip;			/* structure copy */
	ip = &tip;

	for (level = TRIPLE; level >= SINGLE; level--)
		if (lastiblock[level] < 0) {
			oip->i_ib[level] = 0;
			lastiblock[level] = -1;
		}
	for (i = NDADDR - 1; i > lastblock; i--)
		oip->i_db[i] = 0;

	oip->i_size = length;
I 29

#ifdef SunOS_CMW
	/*
	 *	Set IL to system_low for zero length files.  It is okay to
	 *	reset the label here because if the system crashes the
	 *	freed blocks will go to the free list.
	 */
	if ((oip->i_mode & IFMT) == IFREG && length == 0)
		billow(bcltoil(&oip->i_label));
#endif /* SunOS_CMW */

E 29
I 18
D 26

#ifdef SunOS_CMW
	/*
	 *	Set IL to system_low for zero length files.  It is okay to
	 *	reset the label here because if the system crashes the
	 *	freed blocks will go to the free list.
	 */
	if ((oip->i_mode & IFMT) == IFREG && length == 0)
		billow(bcltoil(&oip->i_label));
#endif /* SunOS_CMW */

E 26
E 18
I 8
D 16

#ifdef SunOS_CMW
	/*
	 *	Set IL to system_low for zero length files.  It is okay to
	 *	reset the label here because if the system crashes the
	 *	freed blocks will go to the free list.
	 */
	if ((oip->i_mode & IFMT) == IFREG && length == 0)
		billow(bcltoil(&oip->i_label));
#endif /* SunOS_CMW */

E 16
E 8
I 5
D 6

#ifdef SunOS_CMW
	/*
	 *	Set IL to system_low for zero length files.  It is okay to
	 *	reset the label here because if the system crashes the
	 *	freed blocks will go to the free list.
	 */
	if ((oip->i_mode & IFMT) == IFREG && length == 0)
		billow(bcltoil(&oip->i_label));
#endif /* SunOS_CMW */

E 6
E 5
	oip->i_flag |= ICHG|IUPD;
	iupdat(oip, 1);			/* do sync inode update */

	/*
	 * Indirect blocks first.
	 */
	for (level = TRIPLE; level >= SINGLE; level--) {
		bn = ip->i_ib[level];
		if (bn != 0) {
			blocksreleased +=
			    indirtrunc(ip, bn, lastiblock[level], level);
			if (lastiblock[level] < 0) {
				ip->i_ib[level] = 0;
				free(ip, bn, (off_t)fs->fs_bsize);
				blocksreleased += nblocks;
			}
		}
		if (lastiblock[level] >= 0)
			goto done;
	}

	/*
	 * All whole direct blocks or frags.
	 */
	for (i = NDADDR - 1; i > lastblock; i--) {
		bn = ip->i_db[i];
		if (bn == 0)
			continue;
		ip->i_db[i] = 0;
		bsize = (off_t)blksize(fs, ip, i);
		free(ip, bn, bsize);
		blocksreleased += btodb(bsize);
	}
	if (lastblock < 0)
		goto done;

	/*
	 * Finally, look for a change in size of the
	 * last direct block; release any frags.
	 */
	bn = ip->i_db[lastblock];
	if (bn != 0) {
		off_t oldspace, newspace;

		/*
		 * Calculate amount of space we're giving
		 * back as old block size minus new block size.
		 */
		oldspace = blksize(fs, ip, lastblock);
		ip->i_size = length;
		newspace = blksize(fs, ip, lastblock);
		if (newspace == 0)
			panic("itrunc: newspace");
		if (oldspace - newspace > 0) {
			/*
			 * Block number of space to be free'd is
			 * the old block # plus the number of frags
			 * required for the storage we're keeping.
			 */
			bn += numfrags(fs, newspace);
			free(ip, bn, oldspace - newspace);
			blocksreleased += btodb(oldspace - newspace);
		}
	}
done:
/* BEGIN PARANOIA */
	for (level = SINGLE; level <= TRIPLE; level++)
		if (ip->i_ib[level] != oip->i_ib[level])
			panic("itrunc1");
	for (i = 0; i < NDADDR; i++)
		if (ip->i_db[i] != oip->i_db[i])
			panic("itrunc2");
/* END PARANOIA */
	oip->i_blocks -= blocksreleased;
	if (length == 0 && oip->i_blocks != 0) {	/* sanity */
		printf("itrunc: %s/%d new size = %d, blocks = %d\n",
		    fs->fs_fsmnt, oip->i_number, oip->i_size, oip->i_blocks);
		oip->i_blocks = 0;
	}
	oip->i_flag |= ICHG;
D 6
#ifdef QUOTA
E 6
I 6
#ifdef	QUOTA
E 6
	(void) chkdq(oip, -blocksreleased, 0);
#endif
	return (0);
}

D 16
/*
 * Remove any inodes in the inode cache belonging to dev
 *
 * There should not be any active ones, return error if any are found but
 * still invalidate others (N.B.: this is a user error, not a system error).
 *
 * Also, count the references to dev by block devices - this really
 * has nothing to do with the object of the procedure, but as we have
 * to scan the inode table here anyway, we might as well get the
 * extra benefit.
 *
 * This is called from umount1()/ufs_vfsops.c when dev is being unmounted.
 */
D 6
#ifdef QUOTA
E 6
I 6
#ifdef	QUOTA
E 6
iflush(dev, iq)
	dev_t dev;
	struct inode *iq;
#else
iflush(dev)
	dev_t dev;
#endif
{
	register struct inode *ip;
	register open = 0;
	register union  ihead *ih;
E 16

D 16
	for (ih = ihead; ih < &ihead[INOHSZ]; ih++) {
loop:		for (ip = ih->ih_chain[0];
			ip != (struct inode *)ih; ip = ip->i_forw) {
D 6
#ifdef QUOTA
E 6
I 6
#ifdef	QUOTA
E 6
			if (ip != iq && ip->i_dev == dev) {
#else
			if (ip->i_dev == dev) {
#endif
				if (ip->i_flag & IREF) {
					/*
					 * Set error indicator for return value,
					 * but invalidate other inodes.
					 */
					open = -1;
				} else {
					remque(ip);
					ip->i_forw = ip;
					ip->i_back = ip;
					/*
					 * as IREF == 0, the inode was on the
					 * free list already, just leave it
					 * there, it will fall off the bottom
					 * eventually. We could perhaps move it
					 * to the head of the free list, but as
					 * umounts are done so infrequently, we
					 * would gain very little, while making
					 * the code bigger.
					 */
D 6
#ifdef QUOTA
E 6
I 6
#ifdef	QUOTA
E 6
					dqrele(ip->i_dquot);
					ip->i_dquot = NULL;
#endif
					(void) syncip(ip, B_INVAL);
					goto loop;
				}
			} else if ((ip->i_flag & IREF) &&
					(ip->i_mode & IFMT) == IFBLK &&
					ip->i_rdev == dev && open >= 0)
				open++;
		}
	}
	return (open);
}

E 16
/*
 * Check mode permission on inode.  Mode is READ, WRITE or EXEC.
 * In the case of WRITE, the read-only status of the file system
 * is checked.  The mode is shifted to select the owner/group/other
 * fields.  The super user is granted all permissions except
 * writing to read-only file systems.
 */
iaccess(ip, m)
	register struct inode *ip;
	register int m;
{
	register int *gp;
I 29
#ifdef SunOS_CMW
	register int	shift = 0;		/* # shifts to undo */
#endif /* SunOS_CMW */
E 29
I 18
D 26
#ifdef SunOS_CMW
D 21
	register int	saved_m;		/* saved copy of 'm' */
E 21
I 21
	register int	shift = 0;		/* # shifts to undo */
E 21
#endif /* SunOS_CMW */
E 26
E 18
I 8
D 16
#ifdef SunOS_CMW
D 14
	register int	saved_m;		/* saved copy of 'm' */
E 14
I 14
	register int	shift = 0;		/* # shifts to undo */
E 14
#endif /* SunOS_CMW */
E 16
E 8
I 5
D 6
#ifdef SunOS_CMW
	register int	saved_m;		/* saved copy of 'm' */
#endif /* SunOS_CMW */
E 6
E 5

	if (m & IWRITE) {
		/*
		 * Disallow write attempts on read-only
		 * file systems; unless the file is a block
		 * or character device resident on the
		 * file system, or a fifo.
		 */
		if (ip->i_fs->fs_ronly != 0) {
			if ((ip->i_mode & IFMT) != IFCHR &&
			    (ip->i_mode & IFMT) != IFBLK &&
			    (ip->i_mode & IFMT) != IFIFO) {
				return (EROFS);
			}
		}
	}
I 29

#ifdef SunOS_CMW
E 29
I 23
D 24
	/* SunOS_CMW_ACL { */
E 24
I 24
D 26

E 24
#ifdef SunOS_CMW
E 26
	/*
I 29
	 * If this file has an ACL, use it.  Otherwise, do the
	 * traditional check of the perm bits. If acl_access()
	 * returns non-zero, the value returned indicates
	 * what type of access was denied.
	 *
	 * NOTE:  The "else" condition which follows this is
	 * identical the the non-CMW version, except that we 
	 * keep track of how many bit shifts were done so
	 * we can restore the mode and do a privilege check
	 * if needed. In CMW 1.0 we just #ifdef'd the shifts,
	 * but that doesn't work now that we have ACLs.  Yanking
	 * and #ifdef'ing blocks of code is much cleaner.
	 */
	if (INODE_ICACL(ip)) {

		if ((m = acl_access(ip->i_icacl,u.u_uid, u.u_gid,
				  ip->i_uid, ip->i_gid, m)) == 0)
			return(0);
	} else {

		/*
	 	 * Access check is based on only
	 	 * one of owner, group, public.
	 	 * If not owner, then check group.
	 	 * If not a member of the group, then
	 	 * check public access.
	 	 */
		if (u.u_uid != ip->i_uid) {
			m >>= 3;
			shift++;
			if (u.u_gid == ip->i_gid)
				goto found;
			gp = u.u_groups;
			for (; gp < &u.u_groups[NGROUPS] && 
			      *gp != NOGROUP; gp++)
				if (ip->i_gid == *gp)
					goto found;
			m >>= 3;
			shift++;
		}

found:
		if ((ip->i_mode & m) == m)
			return (0);

		/*
	 	 * Determine what the object does not grant the caller.
	 	 * Shift it back to the original position and see if
	 	 * the caller has the right privilege.
	 	 */
		m &= ~ip->i_mode;
		m <<= (shift * 3);

	} /* else */

	if ((m & IREAD) && !PRIV_TEST(PRIV_FILE_DAC_READ, 0))
		return(EACCES);

	if ((m & IWRITE) && !PRIV_TEST(PRIV_FILE_DAC_WRITE, 0))
		return(EACCES);

	if (m & IEXEC) {
		/*
		 *	Directories use SEARCH priv.
		 */
		if ((ip->i_mode & IFMT) == IFDIR ||
		    (ip->i_mode & IFMT) == IFMLD) {
			if (!PRIV_TEST(PRIV_FILE_DAC_SEARCH, 0))
				return(EACCES);
		}
		else if (!PRIV_TEST(PRIV_FILE_DAC_EXECUTE, 0))
			return(EACCES);
	}
	return(0);

D 30
#else /* SunOS_CMW */
E 30
I 30
#else /* !SunOS_CMW */
E 30

	/*
E 29
D 24
	 * If this file has an ACL, use it
E 24
I 24
D 26
	 * If this file has an ACL, use it.  Otherwise, do the
	 * traditional check of the perm bits. If acl_access()
	 * returns non-zero, the value returned indicates
	 * what type of access was denied.
	 *
	 * NOTE:  The "else" condition which follows this is
	 * identical the the non-CMW version, except that we 
	 * keep track of how many bit shifts were done so
	 * we can restore the mode and do a privilege check
	 * if needed. In CMW 1.0 we just #ifdef'd the shifts,
	 * but that doesn't work now that we have ACLs.  Yanking
	 * and #ifdef'ing blocks of code is much cleaner.
E 24
	 */
D 24
	if (INODE_ACL(ip)) {
		struct	vnode	*vp = ITOV(ip);
				int		t 	= DACL_FS_TYPE;
E 24
I 24
	if (INODE_ICACL(ip)) {
E 24

D 24
		if ((vp->v_type == VDIR) || (vp->v_type == VMLD))
			t = DACL_FS_DIR_TYPE;
		return(acl_access(t,vp,m,u.u_cred));
E 24
I 24
		if ((m = acl_access(ip->i_icacl,u.u_uid, u.u_gid,
				  ip->i_uid, ip->i_gid, m)) == 0)
			return(0);
	} else {

		/*
	 	 * Access check is based on only
	 	 * one of owner, group, public.
	 	 * If not owner, then check group.
	 	 * If not a member of the group, then
	 	 * check public access.
	 	 */
		if (u.u_uid != ip->i_uid) {
			m >>= 3;
			shift++;
			if (u.u_gid == ip->i_gid)
				goto found;
			gp = u.u_groups;
			for (; gp < &u.u_groups[NGROUPS] && 
			      *gp != NOGROUP; gp++)
				if (ip->i_gid == *gp)
					goto found;
			m >>= 3;
			shift++;
		}

found:
		if ((ip->i_mode & m) == m)
			return (0);

		/*
	 	 * Determine what the object does not grant the caller.
	 	 * Shift it back to the original position and see if
	 	 * the caller has the right privilege.
	 	 */
		m &= ~ip->i_mode;
		m <<= (shift * 3);

	} /* else */

	if ((m & IREAD) && !PRIV_TEST(PRIV_FILE_DAC_READ, 0))
		return(EACCES);

	if ((m & IWRITE) && !PRIV_TEST(PRIV_FILE_DAC_WRITE, 0))
		return(EACCES);

	if (m & IEXEC) {
		/*
		 *	Directories use SEARCH priv.
		 */
		if ((ip->i_mode & IFMT) == IFDIR ||
		    (ip->i_mode & IFMT) == IFMLD) {
			if (!PRIV_TEST(PRIV_FILE_DAC_SEARCH, 0))
				return(EACCES);
		}
		else if (!PRIV_TEST(PRIV_FILE_DAC_EXECUTE, 0))
			return(EACCES);
E 24
	}
D 24
#endif
	/* } SunOS_CMW_ACL */
E 24
I 24
	return(0);
E 24
E 23
I 18
D 21
#ifdef SunOS_CMW
	saved_m = m;
#else /* SunOS_CMW */
E 21
I 21

D 24
#ifndef SunOS_CMW
E 24
I 24
#else /* SunOS_CMW */

E 24
E 21
E 18
I 8
D 14
#ifdef SunOS_CMW
	saved_m = m;
#else /* SunOS_CMW */
E 14
I 14
D 16

#ifndef SunOS_CMW
E 16
E 14
E 8
I 5
D 6

#ifdef SunOS_CMW
	saved_m = m;
#else /* SunOS_CMW */
E 6
E 5
	/*
E 26
	 * If you're the super-user,
	 * you always get access.
	 */
	if (u.u_uid == 0)
		return (0);
I 18
D 24
#endif /* SunOS_CMW */
E 24
I 24
D 26

E 26
E 24
E 18
I 8
D 16
#endif /* SunOS_CMW */
E 16
E 8
I 5
D 6
#endif /* SunOS_CMW */

E 6
E 5
	/*
	 * Access check is based on only
	 * one of owner, group, public.
	 * If not owner, then check group.
	 * If not a member of the group, then
	 * check public access.
	 */
	if (u.u_uid != ip->i_uid) {
		m >>= 3;
I 21
D 24
#ifdef SunOS_CMW
		shift++;
#endif /* SunOS_CMW */
E 24
E 21
I 14
D 16
#ifdef SunOS_CMW
		shift++;
#endif /* SunOS_CMW */
E 16
E 14
		if (u.u_gid == ip->i_gid)
			goto found;
		gp = u.u_groups;
		for (; gp < &u.u_groups[NGROUPS] && *gp != NOGROUP; gp++)
			if (ip->i_gid == *gp)
				goto found;
		m >>= 3;
I 21
D 24
#ifdef SunOS_CMW
		shift++;
#endif /* SunOS_CMW */
E 24
E 21
I 14
D 16
#ifdef SunOS_CMW
		shift++;
#endif /* SunOS_CMW */
E 16
E 14
	}
I 24
D 26

E 26
E 24
found:
	if ((ip->i_mode & m) == m)
		return (0);
I 18
D 26

E 26
D 24
#ifdef SunOS_CMW
D 21
	m = saved_m;
E 21
I 21
	/*
	 *	Determine what the object does not grant the caller.
	 *	Shift it back to the original position and see if
	 *	the caller has the right privilege.
	 */
	m &= ~ip->i_mode;
	m <<= (shift * 3);
E 21

D 19
	if ((m & IREAD) && !PRIV_TEST(PRIV_FILE_DAC_READ))
E 19
I 19
	if ((m & IREAD) && !PRIV_TEST(PRIV_FILE_DAC_READ, 0))
E 19
		return(EACCES);

D 19
	if ((m & IWRITE) && !PRIV_TEST(PRIV_FILE_DAC_WRITE))
E 19
I 19
	if ((m & IWRITE) && !PRIV_TEST(PRIV_FILE_DAC_WRITE, 0))
E 19
		return(EACCES);

	if (m & IEXEC) {
		/*
		 *	Directories use SEARCH priv.
		 */
		if ((ip->i_mode & IFMT) == IFDIR ||
		    (ip->i_mode & IFMT) == IFMLD) {
D 19
			if (!PRIV_TEST(PRIV_FILE_DAC_SEARCH))
E 19
I 19
			if (!PRIV_TEST(PRIV_FILE_DAC_SEARCH, 0))
E 19
				return(EACCES);
		}
D 19
		else if (!PRIV_TEST(PRIV_FILE_DAC_EXECUTE))
E 19
I 19
		else if (!PRIV_TEST(PRIV_FILE_DAC_EXECUTE, 0))
E 19
			return(EACCES);
	}
	return(0);
#else /* SunOS_CMW */
E 24
E 18
I 8
D 16

#ifdef SunOS_CMW
D 14
	m = saved_m;
E 14
I 14
	/*
	 *	Determine what the object does not grant the caller.
	 *	Shift it back to the original position and see if
	 *	the caller has the right privilege.
	 */
	m &= ~ip->i_mode;
	m <<= (shift * 3);
E 14

D 12
	if ((m & IREAD) && !PRIV_TEST(PRIV_FILE_DAC_READ))
E 12
I 12
	if ((m & IREAD) && !PRIV_TEST(PRIV_FILE_DAC_READ, 0))
E 12
		return(EACCES);

D 12
	if ((m & IWRITE) && !PRIV_TEST(PRIV_FILE_DAC_WRITE))
E 12
I 12
	if ((m & IWRITE) && !PRIV_TEST(PRIV_FILE_DAC_WRITE, 0))
E 12
		return(EACCES);

	if (m & IEXEC) {
		/*
		 *	Directories use SEARCH priv.
		 */
D 10
		if ((ip->i_mode & IFMT) == IFDIR) {
E 10
I 10
		if ((ip->i_mode & IFMT) == IFDIR ||
		    (ip->i_mode & IFMT) == IFMLD) {
E 10
D 12
			if (!PRIV_TEST(PRIV_FILE_DAC_SEARCH))
E 12
I 12
			if (!PRIV_TEST(PRIV_FILE_DAC_SEARCH, 0))
E 12
				return(EACCES);
		}
D 12
		else if (!PRIV_TEST(PRIV_FILE_DAC_EXECUTE))
E 12
I 12
		else if (!PRIV_TEST(PRIV_FILE_DAC_EXECUTE, 0))
E 12
			return(EACCES);
	}
	return(0);
#else /* SunOS_CMW */
E 16
E 8
I 5
D 6

#ifdef SunOS_CMW
	m = saved_m;

	if ((m & IREAD) && !PRIV_TEST(PRIV_FILE_DAC_READ))
		return(EACCES);

	if ((m & IWRITE) && !PRIV_TEST(PRIV_FILE_DAC_WRITE))
		return(EACCES);

	if (m & IEXEC) {
		/*
		 *	Directories use SEARCH priv.
		 */
		if ((ip->i_mode & IFMT) == IFDIR) {
			if (!PRIV_TEST(PRIV_FILE_DAC_SEARCH))
				return(EACCES);
		}
		else if (!PRIV_TEST(PRIV_FILE_DAC_EXECUTE))
			return(EACCES);
	}
	return(0);
#else /* SunOS_CMW */
E 6
E 5
	return (EACCES);
I 29
#endif /* SunOS_CMW */
E 29
I 18
D 26
#endif /* SunOS_CMW */
E 26
E 18
I 8
D 16
#endif /* SunOS_CMW */
E 16
E 8
I 5
D 6
#endif /* SunOS_CMW */
E 6
E 5
}

ilock(ip)
	register struct inode *ip;
{

	ILOCK(ip);
}

iunlock(ip)
	register struct inode *ip;
{

	IUNLOCK(ip);
}

/*
 *	Check a dnlc entry to see if it's suitable for purging from the
 *	dnlc and if so purge it. Suitable is: must be type ufs,
 *	and if pages_ok == 0, have no associated pages. Returns 1 if
 *	purged an entry, else 0. This function is intended to be called by
 *	the dnlc_iter() function to search the cache and purge a qualified
 *	entry.
 */
static int
inode_dnlc_purge(ncp, pages_ok)
	register struct ncache *ncp;
	register int pages_ok;
{
	register struct vnode *vp = dnlc_vp(ncp);

	ins.in_dnlclook++;

	if ((vp->v_op == &ufs_vnodeops) &&
	    (pages_ok || (!pages_ok && !vp->v_pages))) {
		ins.in_dnlcpurge++;
		dnlc_rm(ncp);
		return (1);
	} else
		return (0);
}
I 16
/*
 * Remove any inodes in the inode cache belonging to dev
 *
 * If not forced unmount:
 * 	There should not be any active ones, return error if any are
 *	found but still invalidate others (N.B.: this is a user error,
 *	not a system error).
 * If forced unmount
 *	unhash relevant inodes, and NULL ip->i_fs and vp->v_vfsp because
 *	fs and vfs will be freed even while the inode remains.
 *	vp->v_ops is set to ufs_forcedops, which returns EIO to every
 *	access except close and inactive.
 */
E 16

I 16
extern struct vnodeops	ufs_forcedops;
extern struct vfsops	ufs_vfsops;

struct vfs		forcedvfs;

iflush(dev, forced, iq)
	dev_t dev;
	int forced;
	struct inode *iq;
{
	struct inode *ip;
	union  ihead *ih;

loop:
	for (ih = ihead; ih < &ihead[INOHSZ]; ih++) {
		for (ip = ih->ih_chain[0];
			ip != (struct inode *)ih; ip = ip->i_forw) {

			if (ip->i_dev != dev)
				continue;
			/*
			 * quota inode will be handled in a later iflush call
			 */
			if (ip == iq)
				continue;
			/*
			 * stop the flush if an inode is referenced
			 */
			if ((!forced) && (ip->i_flag & IREF))
				return (1);
			/*
			 * flush the inode
			 */
			if (iget(ip->i_dev, ip->i_fs, ip->i_number, &ip))
				return (1);
			(void) syncip(ip, B_INVAL, 1);

			/*
			 * unhash
			 */
			remque(ip);
			ip->i_forw = ip;
			ip->i_back = ip;
#ifdef	QUOTA
			dqrele(ip->i_dquot);
			ip->i_dquot = NULL;
#endif
			/*
			 * if forced:
			 *	new vnodeops vector (returns EIO)
			 *	new vfs struct (prevent data fault panics)
			 *	NULL i_fs
			 *	call iinactive on hidden, deleted files
			 */
I 20
D 26

#ifdef	NEED4CMWMP
			/*
			 * When a filesystem is unmounted as 'forced', there may be
			 * a need to instantiate multiple 'forcedvfs' data structures
			 * at different sensitivity levels and enforce MAC policy
			 * decisions on subsequent accesses to the previously mounted
			 * filesystem.  The error returned by the system may need to be
			 * reviewed in this situation as well as new audit events. 
			 * This issue is deferred until the kernel changes for the initial
	 		 * port are completed and the system operates correctly.
	 		 * JJC 4/1/92
			 */
#endif	NEED4CMWMP

E 26
E 20
			if (forced) {
				forcedvfs.vfs_flag = VFS_RDONLY;
				forcedvfs.vfs_op = &ufs_vfsops;
				ITOV(ip)->v_op = &ufs_forcedops;
				ITOV(ip)->v_vfsp = &forcedvfs;
				ITOV(ip)->v_flag &= ~VROOT;
				ip->i_fs = NULL;
			}
			iput(ip);
			goto loop;
		}
	}
	return (0);
}

E 16
D 6
#ifdef TRACE
E 6
I 6
#ifdef	TRACE
E 6
/*
 * Dump the contents of the inode cache.
 */
trace_inode()
{
	register struct inode *ip;
	register union  ihead *ih;

	/*
	 * Purge the cache so we can find out who's REALLY in use
	 */
	dnlc_purge();

	for (ih = ihead; ih < &ihead[INOHSZ]; ih++) {
		for (ip = ih->ih_chain[0];
		    ip != (struct inode *)ih; ip = ip->i_forw) {
			trace6(TR_UFS_INODE, ip,
				ip->i_flag, ip->i_dev, ip->i_number,
				(ip->i_mode << 16) | (ip->i_rdev & 0xffff), 0);
		}
	}
	trace6(TR_UFS_INODE, 0, 0, 0, 0, 0, 1);  /* Signals last entry */
}

/*
 * Dump the inode statistics counters.
 */
trace_instats()
{
	trace6(TR_UFS_INSTATS, 0, 0, 0, 0, ins.in_misses, ins.in_hits);
}

/*
 * Reset the inode statistics counters.
 */
trace_instats_reset()
{
	bzero((caddr_t) &ins, sizeof (ins));
}
D 6
#endif TRACE
I 5

#ifdef SunOS_CMW
/*
 *	This is a function version of the IMARK macro from ufs/inode.h.
 *	The alternative is to have multiple calls to vn_mac_policy()
 *	or to introduce another global variable like iuniqtime that
 *	keeps the result of the vn_mac_policy() check.
 */
void
IMARK(ip)
	struct inode	*ip;
{
	int		ret_code;		/* result of MAC check */


	/*
	 *	Must have MAC write to update the times otherwise it would
	 *	be a covert channel.  Uses a temporary variable because the
	 *	result is needed in several places.
	 */
	ret_code = vn_mac_policy(VWRITE, ITOV(ip), bcltosl(&ip->i_label));

	if (time.tv_sec > iuniqtime.tv_sec || time.tv_usec > iuniqtime.tv_usec)
		iuniqtime = time;
	else
		iuniqtime.tv_usec++;

	if (ret_code == 0 && ip->i_flag & IACC)
		ip->i_atime = iuniqtime;

	/*
	 *	Do not set IMODTIME flag since it did not really happen.
	 */
	if (ret_code == 0 && ip->i_flag & IUPD) {
		ip->i_mtime = iuniqtime;
		ip->i_flag |= IMODTIME;
	}
	if (ip->i_flag & ICHG) {
		/*
		 *	This field must always be updated or the system
		 *	will panic in strange places.  Since the field
		 *	is not accessible by the user, it is not a covert
		 *	channel.
		 */
		ip->i_diroff = 0;
		if (ret_code == 0)
			ip->i_ctime = iuniqtime;
	}
} /* end IMARK() */
#endif /* SunOS_CMW */
E 6
I 6
#endif	TRACE
I 29

#ifdef SunOS_CMW
/*
 *	This is a function version of the IMARK macro from ufs/inode.h.
 *	The alternative is to have multiple calls to vn_mac_policy()
 *	or to introduce another global variable like iuniqtime that
 *	keeps the result of the vn_mac_policy() check.
 */
void
IMARK(ip)
	struct inode	*ip;
{
	int		ret_code;		/* result of MAC check */


	/*
	 *	Must have MAC write to update the times otherwise it would
	 *	be a covert channel.  Uses a temporary variable because the
	 *	result is needed in several places.
	 */
	ret_code = vn_mac_policy((VPATTR | VWRITE), ITOV(ip),
				 bcltosl(&ip->i_label));

	if (time.tv_sec > iuniqtime.tv_sec || time.tv_usec > iuniqtime.tv_usec)
		iuniqtime = time;
	else
		iuniqtime.tv_usec++;

	if (ret_code == 0 && ip->i_flag & IACC)
		ip->i_atime = iuniqtime;

	/*
	 *	Do not set IMODTIME flag since it did not really happen.
	 */
	if (ret_code == 0 && ip->i_flag & IUPD) {
		ip->i_mtime = iuniqtime;
		ip->i_flag |= IMODTIME;
	}
	if (ip->i_flag & ICHG) {
		/*
		 *	This field must always be updated or the system
		 *	will panic in strange places.  Since the field
		 *	is not accessible by the user, it is not a covert
		 *	channel.
		 */
		ip->i_diroff = 0;
		if (ret_code == 0)
			ip->i_ctime = iuniqtime;
	}
} /* end IMARK() */
#endif /* SunOS_CMW */
E 29
I 18
D 26

#ifdef SunOS_CMW
/*
 *	This is a function version of the IMARK macro from ufs/inode.h.
 *	The alternative is to have multiple calls to vn_mac_policy()
 *	or to introduce another global variable like iuniqtime that
 *	keeps the result of the vn_mac_policy() check.
 */
void
IMARK(ip)
	struct inode	*ip;
{
	int		ret_code;		/* result of MAC check */


	/*
	 *	Must have MAC write to update the times otherwise it would
	 *	be a covert channel.  Uses a temporary variable because the
	 *	result is needed in several places.
	 */
	ret_code = vn_mac_policy((VPATTR | VWRITE), ITOV(ip),
				 bcltosl(&ip->i_label));

	if (time.tv_sec > iuniqtime.tv_sec || time.tv_usec > iuniqtime.tv_usec)
		iuniqtime = time;
	else
		iuniqtime.tv_usec++;

	if (ret_code == 0 && ip->i_flag & IACC)
		ip->i_atime = iuniqtime;

	/*
	 *	Do not set IMODTIME flag since it did not really happen.
	 */
	if (ret_code == 0 && ip->i_flag & IUPD) {
		ip->i_mtime = iuniqtime;
		ip->i_flag |= IMODTIME;
	}
	if (ip->i_flag & ICHG) {
		/*
		 *	This field must always be updated or the system
		 *	will panic in strange places.  Since the field
		 *	is not accessible by the user, it is not a covert
		 *	channel.
		 */
		ip->i_diroff = 0;
		if (ret_code == 0)
			ip->i_ctime = iuniqtime;
	}
} /* end IMARK() */
#endif /* SunOS_CMW */
E 26
E 18
I 8
D 16

#ifdef SunOS_CMW
/*
 *	This is a function version of the IMARK macro from ufs/inode.h.
 *	The alternative is to have multiple calls to vn_mac_policy()
 *	or to introduce another global variable like iuniqtime that
 *	keeps the result of the vn_mac_policy() check.
 */
void
IMARK(ip)
	struct inode	*ip;
{
	int		ret_code;		/* result of MAC check */


	/*
	 *	Must have MAC write to update the times otherwise it would
	 *	be a covert channel.  Uses a temporary variable because the
	 *	result is needed in several places.
	 */
D 9
	ret_code = vn_mac_policy(VWRITE, ITOV(ip), bcltosl(&ip->i_label));
E 9
I 9
	ret_code = vn_mac_policy((VPATTR | VWRITE), ITOV(ip),
				 bcltosl(&ip->i_label));
E 9

	if (time.tv_sec > iuniqtime.tv_sec || time.tv_usec > iuniqtime.tv_usec)
		iuniqtime = time;
	else
		iuniqtime.tv_usec++;

	if (ret_code == 0 && ip->i_flag & IACC)
		ip->i_atime = iuniqtime;

	/*
	 *	Do not set IMODTIME flag since it did not really happen.
	 */
	if (ret_code == 0 && ip->i_flag & IUPD) {
		ip->i_mtime = iuniqtime;
		ip->i_flag |= IMODTIME;
	}
	if (ip->i_flag & ICHG) {
		/*
		 *	This field must always be updated or the system
		 *	will panic in strange places.  Since the field
		 *	is not accessible by the user, it is not a covert
		 *	channel.
		 */
		ip->i_diroff = 0;
		if (ret_code == 0)
			ip->i_ctime = iuniqtime;
	}
} /* end IMARK() */
#endif /* SunOS_CMW */
E 16
E 8
E 6
E 5
E 1
