h14493
s 00017/00000/00319
d D 4.4.1.1 98/08/28 09:46:37 dcubed 18 17
m 4089720
c Unallocated inodes shouldn't have references to ACLs.
e
s 00003/00003/00316
d D 4.4 94/10/03 14:28:30 dcubed 17 16
m tsmerge
c Fixed complaints from updated chk_ifdef.
e
s 00063/00000/00256
d D 4.3 94/09/01 09:42:55 paulf 16 15
m tsmerge
c Merging with revision 3.8 from previous release.
e
s 00003/00000/00253
d D 4.2 94/08/02 17:38:59 dcubed 15 14
m 
c Alaska id string.
e
s 00000/00064/00253
d D 4.1 94/08/02 17:38:57 dcubed 14 13
m 
c Created from revision 1.6 in base source.
e
s 00048/00000/00269
d D 3.8 93/06/07 18:29:27 rdurbin 13 12
m 
c support for ACLs on CMW
e
s 00015/00000/00254
d D 3.7 93/06/07 18:28:28 rdurbin 12 11
m 
c CMW 1.0 functionality merged
e
s 00002/00098/00252
d D 3.6 93/06/07 18:09:51 rdurbin 11 10
m 
c go back to 4.1.3 version so we know what we do and don't have
e
s 00001/00001/00349
d D 3.5 92/11/19 08:53:13 thuleen 10 9
m 
c changed DINODE to struct dinode.
e
s 00081/00001/00269
d D 3.4 92/11/18 11:28:41 thuleen 9 8
m 
c SunOS_CMW_ACL port to FOXBAT
e
s 00018/00002/00252
d D 3.3 92/03/27 10:46:57 roseboom 8 7
m 
c CMW 1.0.1 Build 1.  Applied CMW changes to 4.1.2 base.
e
s 00001/00000/00253
d D 3.2 91/08/02 14:26:21 rdurbin 7 6
m 
c Foxbat id string.
e
s 00069/00042/00184
d D 3.1 91/08/02 14:26:21 rdurbin 6 5
m 
c Getting in sync with base source revision.
e
s 00005/00000/00221
d D 2.3 91/08/02 14:26:21 rdurbin 5 4
m gm0107
c added MLD support
e
s 00001/00000/00220
d D 2.2 91/06/19 10:49:37 rdurbin 4 3
m 
c Griffon id string.
e
s 00000/00001/00220
d D 2.1 91/06/19 10:49:34 rdurbin 3 2
m 
c Getting in sync with base source revision.
e
s 00001/00000/00220
d D 1.2 91/06/19 10:49:31 rdurbin 2 1
m 
c Griffon id string.
e
s 00220/00000/00000
d D 1.1 91/06/19 10:49:27 rdurbin 1 0
c date and time created 91/06/19 10:49:27 by rdurbin
e
u
U
f b 
f e 0
f v /usr/local/fswdist/bin/mr_verify
t
T
I 15
#ifdef SunOS_CMW
#ident "%Z%%M% %I% %E% SMI; Trusted Solaris 1.X"
#endif /* SunOS_CMW */
E 15
I 1
/*
D 6
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
E 6
I 6
 * Copyright (c) 1980, 1986, 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
E 6
 */

I 7
D 8
#ident	"%Z%%M% %I% %E% SMI; SunOS CMW"
E 7
D 6
#ifndef lint
I 4
static  char cmw_sccsid[] = "%Z%%M% %I% %E% SMI; SunOS CMW";
E 4
I 2
D 3
static  char cmw_sccsid[] = "%Z%%M% %I% %E% SMI; SunOS CMW";
E 3
E 2
static  char sccsid[] = "@(#)pass1.c 1.5 88/11/19 SMI"; /* from UCB 5.3 5/13/86 */
#endif not lint
E 6
I 6
#ident	"@(#)pass1.c 1.6 91/06/18 SMI"	/* from UCB 5.13 4/29/90 */
E 8
I 8
D 9
#ident	"%Z%%M% %I% %E% SMI; SunOS CMW-MP"
E 9
I 9
D 11
#ident	"%Z%%M% %I% %E% SMI; SunOS CMW-MP ACL"
E 9
/* #ident "@(#)pass1.c 1.6 91/06/18 SMI" /* from UCB 5.13 4/29/90 */
/* #ident "@(#)pass1.c 2.3 91/08/02 SMI; SunOS CMW" */
E 11
I 11
D 14
#ident	"%Z%%M% %I% %E% SMI; SunOS CMW"
E 14
#ident	"@(#)pass1.c 1.6 91/06/18 SMI"	/* from UCB 5.13 4/29/90 */
E 11
E 8
E 6

D 6
#include <stdio.h>
E 6
#include <sys/param.h>
D 6
#include <ufs/fs.h>
E 6
#include <sys/time.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
D 6
#define KERNEL
#include <ufs/fsdir.h>
#undef KERNEL
#include <mntent.h>
E 6
I 6
#include <ufs/fs.h>
E 6
#include "fsck.h"

static daddr_t badblk;
static daddr_t dupblk;
int pass1check();
I 6
struct dinode *getnextinode();
E 6

pass1()
{
D 6
	register int c, i, j;
	register DINODE *dp;
E 6
I 6
	register unsigned int c, i, j;
	register struct dinode *dp;
E 6
	struct zlncnt *zlnp;
D 6
	int ndb, partial, cgd;
E 6
I 6
	int ndb, cgd;
E 6
	struct inodesc idesc;
	ino_t inumber;

	/*
	 * Set file system reserved blocks in used block map.
	 */
	for (c = 0; c < sblock.fs_ncg; c++) {
		cgd = cgdmin(&sblock, c);
		if (c == 0) {
			i = cgbase(&sblock, c);
			cgd += howmany(sblock.fs_cssize, sblock.fs_fsize);
		} else
			i = cgsblock(&sblock, c);
		for (; i < cgd; i++)
			setbmap(i);
	}
	/*
	 * Find all allocated blocks.
	 */
D 6
	bzero((char *)&idesc, sizeof(struct inodesc));
E 6
I 6
	bzero((char *)&idesc, sizeof (struct inodesc));
E 6
	idesc.id_type = ADDR;
	idesc.id_func = pass1check;
	inumber = 0;
	n_files = n_blks = 0;
I 6
	resetinodebuf();
E 6
	for (c = 0; c < sblock.fs_ncg; c++) {
		for (i = 0; i < sblock.fs_ipg; i++, inumber++) {
			if (inumber < ROOTINO)
				continue;
D 6
			dp = ginode(inumber);
			if (!ALLOC(dp)) {
E 6
I 6
			dp = getnextinode(inumber);
I 9
D 11
#ifdef SunOS_CMW
/* SunOS_CMW_ACL { */
            /*
             * Increment the link count for the ACL inode
             */
            if ((sblock.fs_magic == CFS_MAGIC) && (dp->di_ic.ic_acl != NULL)) {
                lncntp[dp->di_ic.ic_acl]++;
            }  

            /*   
             * Clear the in-core inode pointer purely as a precaution
             */
            if ((sblock.fs_magic == CFS_MAGIC) && (dp->di_ic.ic_icacl != NULL)) {
                printf("Inode I=%u points to in-core ACL:%u (cleared)\n", inumber,dp->di_ic.ic_icacl);
                dp->di_ic.ic_icacl = NULL;
                inodirty();
            }  
/* } SunOS_CMW_ACL */
#endif SunOS_CMW
E 11
E 9
			if ((dp->di_mode & IFMT) == 0) {
E 6
				if (bcmp((char *)dp->di_db, (char *)zino.di_db,
D 6
					NDADDR * sizeof(daddr_t)) ||
E 6
I 6
					NDADDR * sizeof (daddr_t)) ||
E 6
				    bcmp((char *)dp->di_ib, (char *)zino.di_ib,
D 6
					NIADDR * sizeof(daddr_t)) ||
E 6
I 6
					NIADDR * sizeof (daddr_t)) ||
E 6
				    dp->di_mode || dp->di_size) {
					pfatal("PARTIALLY ALLOCATED INODE I=%u",
						inumber);
					if (reply("CLEAR") == 1) {
D 6
						zapino(dp);
E 6
I 6
						dp = ginode(inumber);
						clearinode(dp);
E 6
						inodirty();
					}
				}
I 18
#ifdef SunOS_CMW
				/*
				 * Unallocated inodes shouldn't have
				 * references to ACLs so fix it.
				 */
				if (dp->di_ic.ic_acl) {
					pwarn("NON-ZERO ACL REFERENCE IN UNALLOCATED INODE I=%ld", inumber);
					if (preen)
						printf(" (CORRECTED)\n");

					if (preen || reply("CORRECT") == 1) {
						dp = ginode(inumber);
						dp->di_ic.ic_acl = 0;
						inodirty();
					}
				}
#endif /* SunOS_CMW */
E 18
				statemap[inumber] = USTATE;
				continue;
			}
			lastino = inumber;
D 6
			if (dp->di_size < 0 ||
			    (u_long)dp->di_size + sblock.fs_bsize - 1 < 0) {
		/* have to guard against possible arithmetic overflow later. (sigh!) */
E 6
I 6
			if (dp->di_size < 0) {
E 6
				if (debug)
					printf("bad size %d:", dp->di_size);
				goto unknown;
			}
			if (!preen && (dp->di_mode & IFMT) == IFMT &&
			    reply("BAD MODE: MAKE IT A FILE") == 1) {
I 6
				dp = ginode(inumber);
E 6
				dp->di_size = sblock.fs_fsize;
				dp->di_mode = IFREG|0600;
				inodirty();
			}
			ndb = howmany((u_long)dp->di_size, sblock.fs_bsize);
D 6
			if (SPECIAL(dp))
				ndb++;
E 6
I 6
			if (ndb < 0) {
				if (debug)
					printf("bad size %d ndb %d:",
						dp->di_size, ndb);
				goto unknown;
			}
			if ((dp->di_mode & IFMT) == IFBLK ||
			    (dp->di_mode & IFMT) == IFCHR)
				ndb = 1;
E 6
			for (j = ndb; j < NDADDR; j++)
				if (dp->di_db[j] != 0) {
					if (debug)
						printf("bad direct addr: %d\n",
							dp->di_db[j]);
					goto unknown;
				}
			for (j = 0, ndb -= NDADDR; ndb > 0; j++)
				ndb /= NINDIR(&sblock);
			for (; j < NIADDR; j++)
				if (dp->di_ib[j] != 0) {
					if (debug)
						printf("bad indirect addr: %d\n",
							dp->di_ib[j]);
					goto unknown;
				}
			if (ftypeok(dp) == 0)
				goto unknown;
I 9
D 11
#ifdef SunOS_CMW
/* SunOS_CMW_ACL { */
            /*
             * Link counts to ACL inodes are incremented above
             * Pass4 verifies that the link counts are correct
             */
            if ((dp->di_mode & IFMT) != IFACL) {
/* } SunOS_CMW_ACL */
#endif SunOS_CMW
E 11
E 9
			n_files++;
			lncntp[inumber] = dp->di_nlink;
I 9
D 11
#ifdef SunOS_CMW
/* SunOS_CMW_ACL { */
            }
/* } SunOS_CMW_ACL */
#endif SunOS_CMW
E 11
E 9
			if (dp->di_nlink <= 0) {
				zlnp = (struct zlncnt *)malloc(sizeof *zlnp);
				if (zlnp == NULL) {
					pfatal("LINK COUNT TABLE OVERFLOW");
					if (reply("CONTINUE") == 0)
						errexit("");
				} else {
					zlnp->zlncnt = inumber;
					zlnp->next = zlnhead;
					zlnhead = zlnp;
				}
			}
I 16
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) ||
				((dp->di_mode & IFMT) == IFMLD)) {
D 17
#else /* SunOS_CMW */
E 17
I 17
#else /* !SunOS_CMW */
E 17
E 16
I 12
D 14
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) ||
				((dp->di_mode & IFMT) == IFMLD)) {
#else /* SunOS_CMW */
E 14
E 12
I 8
D 11
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) |
			   ((dp->di_mode & IFMT) == IFMLD)) {
#else /* SunOS_CMW */
E 11
E 8
I 5
D 6
#ifdef SunOS_CMW
			statemap[inumber] = DIRCT(dp) ? DSTATE :
					MLDIRCT(dp) ? DSTATE : FSTATE;
#else /* SunOS_CMW */
E 5
			statemap[inumber] = DIRCT(dp) ? DSTATE : FSTATE;
I 5
#endif /* SunOS_CMW */
E 5
			badblk = dupblk = 0; maxblk = 0;
E 6
I 6
			if ((dp->di_mode & IFMT) == IFDIR) {
I 16
#endif /* SunOS_CMW */
E 16
I 12
D 14
#endif /* SunOS_CMW */
E 14
E 12
I 8
D 11
#endif /* SunOS_CMW */
E 11
E 8
				if (dp->di_size == 0)
					statemap[inumber] = DCLEAR;
				else
					statemap[inumber] = DSTATE;
				cacheino(dp, inumber);
I 16
#ifdef SunOS_CMW
			} else if ((dp->di_mode & IFMT) == IFACL) {
				if (dp->di_size == 0)
					statemap[inumber] = ACLEAR;
				else
					statemap[inumber] = ASTATE;
				cacheacl(dp, inumber);
#endif /* SunOS_CMW */
E 16
I 13
D 14
#ifdef SunOS_CMW
			} else if ((dp->di_mode & IFMT) == IFACL) {
				if (dp->di_size == 0)
					statemap[inumber] = ACLEAR;
				else
					statemap[inumber] = ASTATE;
				cacheacl(dp, inumber);
#endif /* SunOS_CMW */
E 14
E 13
			} else
				statemap[inumber] = FSTATE;
			badblk = dupblk = 0;
E 6
			idesc.id_number = inumber;
I 6
			idesc.id_fix = DONTKNOW;
E 6
			(void)ckinode(dp, &idesc);
			idesc.id_entryno *= btodb(sblock.fs_fsize);
			if (dp->di_blocks != idesc.id_entryno) {
				pwarn("INCORRECT BLOCK COUNT I=%u (%ld should be %ld)",
				    inumber, dp->di_blocks, idesc.id_entryno);
				if (preen)
					printf(" (CORRECTED)\n");
				else if (reply("CORRECT") == 0)
					continue;
I 6
				dp = ginode(inumber);
E 6
				dp->di_blocks = idesc.id_entryno;
				inodirty();
			}
I 16
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) ||
				((dp->di_mode & IFMT) == IFMLD)) {
D 17
#else /* SunOS_CMW */
E 17
I 17
#else /* !SunOS_CMW */
E 17
E 16
I 12
D 14
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) ||
				((dp->di_mode & IFMT) == IFMLD)) {
#else /* SunOS_CMW */
E 14
E 12
I 8
D 11
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) |
			   ((dp->di_mode & IFMT) == IFMLD))
#else /* SunOS_CMW */
E 11
E 8
I 6
			if ((dp->di_mode & IFMT) == IFDIR)
I 16
#endif /* SunOS_CMW */
E 16
I 12
D 14
#endif /* SunOS_CMW */
E 14
E 12
I 8
D 11
#endif /* SunOS_CMW */
E 11
E 8
				if (dp->di_blocks == 0)
					statemap[inumber] = DCLEAR;
I 16
#ifdef SunOS_CMW
			} else if ((dp->di_mode & IFMT) == IFACL) {
				if (dp->di_size == 0)
					statemap[inumber] = ACLEAR;
				else
					statemap[inumber] = ASTATE;
				cacheacl(dp, inumber);
			}
			/* ACL inodes can't have ACL inodes */
			aclinop[inumber] = dp->di_ic.ic_acl;
			if (dp->di_ic.ic_acl && (dp->di_mode & IFMT) == IFACL) {
				pwarn("NON-ZERO ACL REFERENCE IN ACL I=%ld", inumber);
				if (preen)
					printf(" (CORRECTED)\n");
				else if (reply("CORRECT") == 0)
					continue;
				dp = ginode(inumber);
				dp->di_ic.ic_acl = 0;
				aclinop[inumber] = 0;
				inodirty();
			}
			/*
			 * The ACL inode # must be realistic -
			 * either 0 or a real inode number.
			 */
			if (aclinop[inumber] &&
				(aclinop[inumber] <= ROOTINO ||
					aclinop[inumber] > maxino)) {
				pwarn("BAD ACL REFERENCE I=%ld", inumber);
				if (preen)
					printf(" (CORRECTED)\n");
				else if (reply("CORRECT") == 0)
					continue;
				dp = ginode(inumber);
				dp->di_ic.ic_acl = 0;
				aclinop[inumber] = 0;
				dp->di_mode &= ~0777;
				inodirty();
			}
#endif /* SunOS_CMW */
E 16
I 13
D 14
#ifdef SunOS_CMW
			} else if ((dp->di_mode & IFMT) == IFACL) {
				if (dp->di_size == 0)
					statemap[inumber] = ACLEAR;
				else
					statemap[inumber] = ASTATE;
				cacheacl(dp, inumber);
			}
			/* ACL inodes can't have ACL inodes */
			aclinop[inumber] = dp->di_ic.ic_acl;
			if (dp->di_ic.ic_acl && (dp->di_mode & IFMT) == IFACL) {
				pwarn("NON-ZERO ACL REFERENCE IN ACL I=%ld", inumber);
				if (preen)
					printf(" (CORRECTED)\n");
				else if (reply("CORRECT") == 0)
					continue;
				dp = ginode(inumber);
				dp->di_ic.ic_acl = 0;
				aclinop[inumber] = 0;
				inodirty();
			}
			/*
			 * The ACL inode # must be realistic -
			 * either 0 or a real inode number.
			 */
			if (aclinop[inumber] &&
				(aclinop[inumber] <= ROOTINO ||
					aclinop[inumber] > maxino)) {
				pwarn("BAD ACL REFERENCE I=%ld", inumber);
				if (preen)
					printf(" (CORRECTED)\n");
				else if (reply("CORRECT") == 0)
					continue;
				dp = ginode(inumber);
				dp->di_ic.ic_acl = 0;
				aclinop[inumber] = 0;
				dp->di_mode &= ~0777;
				inodirty();
			}
#endif /* SunOS_CMW */
E 14
E 13
E 6
			continue;
	unknown:
			pfatal("UNKNOWN FILE TYPE I=%u", inumber);
I 16
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) ||
				((dp->di_mode & IFMT) == IFMLD)) {
D 17
#else /* SunOS_CMW */
E 17
I 17
#else /* !SunOS_CMW */
E 17
E 16
I 12
D 14
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) ||
				((dp->di_mode & IFMT) == IFMLD)) {
#else /* SunOS_CMW */
E 14
E 12
I 8
D 11
#ifdef SunOS_CMW
			if (((dp->di_mode & IFMT) == IFDIR) |
			   ((dp->di_mode & IFMT) == IFMLD)) {
#else /* SunOS_CMW */
E 11
E 8
D 6
			statemap[inumber] = FCLEAR;
E 6
I 6
			if ((dp->di_mode & IFMT) == IFDIR) {
I 16
#endif /* SunOS_CMW */
E 16
I 12
D 14
#endif /* SunOS_CMW */
E 14
E 12
I 8
D 11
#endif /* SunOS_CMW */
E 11
E 8
				statemap[inumber] = DCLEAR;
				cacheino(dp, inumber);
			} else
				statemap[inumber] = FCLEAR;
E 6
			if (reply("CLEAR") == 1) {
				statemap[inumber] = USTATE;
D 6
				zapino(dp);
E 6
I 6
				dp = ginode(inumber);
				clearinode(dp);
E 6
				inodirty();
			}
		}
	}
I 9
D 11
#ifdef SunOS_CMW
/* SunOS_CMW_ACL { */
    /*   
     * Check that referenced ACL inodes are valid for CFS filesystems
     */  
    if (sblock.fs_magic == CFS_MAGIC) {
        inumber = 0;
        for (c = 0; c < sblock.fs_ncg; c++) {
            for (i = 0; i < sblock.fs_ipg; i++, inumber++) {
                if (inumber < ROOTINO)
                    continue;
                dp = ginode(inumber);
                if ((dp->di_ic.ic_acl != NULL) && badaclinode(dp->di_ic.ic_acl)) {
                    printf("Inode I:%u references bad ACL (cleared)\n",inumber);
                    dp->di_ic.ic_acl = NULL;
					dp->di_ic.ic_aclcnt = 0;
                    inodirty();
                }
            }    
        }
    }
/* } SunOS_CMW_ACL */
#endif SunOS_CMW
E 11
E 9
I 6
	freeinodebuf();
E 6
}
I 9
D 11

#ifdef SunOS_CMW
/* SunOS_CMW_ACL { */

/*
 * Should check more info about ACL inode
 */

badaclinode(inum)
    long inum;
{
D 10
    DINODE *dp;
E 10
I 10
    struct dinode  *dp;
E 10

    if (inum != NULL)
        return(0);
    if (statemap[inum] != FSTATE)
        return(1);
    dp = ginode(inum);
    if ((dp->di_mode & IFMT) != IFACL)
        return(1);
    return(0);
}
/* } SunOS_CMW_ACL */
#endif SunOS_CMW
E 11
E 9

pass1check(idesc)
	register struct inodesc *idesc;
{
	int res = KEEPON;
	int anyout, nfrags;
	daddr_t blkno = idesc->id_blkno;
	register struct dups *dlp;
	struct dups *new;

D 6
	if ((anyout = outrange(blkno, idesc->id_numfrags)) != 0) {
		blkerr(idesc->id_number, "BAD", blkno);
E 6
I 6
	if ((anyout = chkrange(blkno, idesc->id_numfrags)) != 0) {
		blkerror(idesc->id_number, "BAD", blkno);
E 6
		if (++badblk >= MAXBAD) {
			pwarn("EXCESSIVE BAD BLKS I=%u",
				idesc->id_number);
			if (preen)
				printf(" (SKIPPING)\n");
			else if (reply("CONTINUE") == 0)
				errexit("");
			return (STOP);
		}
	}
	for (nfrags = idesc->id_numfrags; nfrags > 0; blkno++, nfrags--) {
D 6
		if (anyout && outrange(blkno, 1)) {
E 6
I 6
		if (anyout && chkrange(blkno, 1)) {
E 6
			res = SKIP;
D 6
		} else if (!getbmap(blkno)) {
E 6
I 6
		} else if (!testbmap(blkno)) {
E 6
			n_blks++;
			setbmap(blkno);
		} else {
D 6
			blkerr(idesc->id_number, "DUP", blkno);
E 6
I 6
			blkerror(idesc->id_number, "DUP", blkno);
E 6
			if (++dupblk >= MAXDUP) {
				pwarn("EXCESSIVE DUP BLKS I=%u",
					idesc->id_number);
				if (preen)
					printf(" (SKIPPING)\n");
				else if (reply("CONTINUE") == 0)
					errexit("");
				return (STOP);
			}
D 6
			new = (struct dups *)malloc(sizeof(struct dups));
E 6
I 6
			new = (struct dups *)malloc(sizeof (struct dups));
E 6
			if (new == NULL) {
				pfatal("DUP TABLE OVERFLOW.");
				if (reply("CONTINUE") == 0)
					errexit("");
				return (STOP);
			}
			new->dup = blkno;
			if (muldup == 0) {
				duplist = muldup = new;
				new->next = 0;
			} else {
				new->next = muldup->next;
				muldup->next = new;
			}
			for (dlp = duplist; dlp != muldup; dlp = dlp->next)
				if (dlp->dup == blkno)
					break;
			if (dlp == muldup && dlp->dup != blkno)
				muldup = new;
		}
		/*
		 * count the number of blocks found in id_entryno
		 */
		idesc->id_entryno++;
	}
	return (res);
}
E 1
