/*
 * Copyright (c) 1992-1995, by Sun Microsystems, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided this notice is preserved and that due credit is given
 * to Sun Microsystems, Inc.  The name of Sun Microsystems, Inc. may
 * not be used to endorse or promote products derived from this
 * software without specific prior written permission.  This software
 * is provided ``as is'' without express or implied warranty.
 */

#ifndef _SAMPLE_UTILS_H
#define	_SAMPLE_UTILS_H

#pragma	ident	"@(#)sample_utils.h	1.2	96/04/09 SMI"	/* PAM 2.6 */

#ifdef __cplusplus
extern "C" {
#endif

void
__free_msg(int num_msg, struct pam_message *msg);

void
__free_resp(int num_msg, struct pam_response *resp);

int
__display_errmsg(
	int (*conv_funp)(),
	int num_msg,
	char messages[PAM_MAX_NUM_MSG][PAM_MAX_MSG_SIZE],
	void *conv_apdp
);

int
__get_authtok(
	int (*conv_funp)(),
	int num_msg,
	char messages[PAM_MAX_NUM_MSG][PAM_MAX_MSG_SIZE],
	void *conv_apdp,
	struct pam_response	**ret_respp
);

/*
 * PAM_MSG macro for return of internationalized text
 */

#define	PAM_MSG(pamh, number, string)\
	(char *) __pam_get_i18n_msg(pamh, "pam_unix", 3, number, string)

#ifdef __cplusplus
}
#endif

#endif /* _SAMPLE_UTILS_H */
