/*
 * Copyright (c) 1995, by Sun Microsystems, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided this notice is preserved and that due credit is given
 * to Sun Microsystems, Inc.  The name of Sun Microsystems, Inc. may
 * not be used to endorse or promote products derived from this
 * software without specific prior written permission.  This software
 * is provided ``as is'' without express or implied warranty.
 */

#pragma	ident	"@(#)sample_open_session.c	1.2	96/04/09 SMI"	/* PAM 2.6 */

#include <security/pam_appl.h>
#include <security/pam_modules.h>
#include <syslog.h>
#include <sys/types.h>
#include "radius_pam.h"

int
pam_sm_open_session(
	pam_handle_t *pamh,
	int	flags,
	int	argc,
	const char **argv)
{
	AUTH_REQ			*authreq;
	VALUE_PAIR		*item;

	authreq = get_authreq(pamh);
	item = get_attribute(authreq->request, PW_USER_NAME);
	syslog(LOG_ERR, "user-name for accounting: %s", item->strvalue);

	return (PAM_SUCCESS);
}

