#ident "@(#)radius_pam.h	1.1 04/29/99 SMI"
/*
 *
 * Portions Copyright 04/29/99 Sun Microsystems, Inc. All Rights Reserved
 *
 */

/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	4464 Willow Road
 *	Pleasanton, CA   94588
 *
 *	Copyright 1992-1996 Livingston Enterprises, Inc. All Rights Reserved.
 *
 *	This software is provided under license from Livingston
 *	Enterprises, Inc., the terms and conditions of which are set
 *	forth in a Software License Agreement that is contained in an
 *	End User Agreement contained in the product packaging, and
 *	electronically on the Livingston ftp site. This software may
 *	only be used in conjunction with Livingston (or Livingston
 *	authorized) products.  Livingston makes no warranties to any
 *	licensee concerning the applicability of the software to
 *	licensee's specific requirements or the suitability of the
 *	software for any intended use.  Licensee shall not remove,
 *	modify or alter any copyright and/or other proprietary rights
 *	notice and must faithfully reproduce all such notices on any
 *	copies or modifications to this software that it makes.
 *
 *	Livingston Enterprises, Inc. makes no representations about the
 *	suitability of this software for any purpose.  It is provided
 *	"as is" without express or implied warranty.
 *
 */

/*
 * These functions can be used within a PAM module which was called
 * from the SunDS RADIUS server to gain access to the data in the
 * RADIUS request.
 * 
 * Please note that the interface to retrieve attributes from the
 * request defined in this file will change in a future release.  This
 * interface is only temporary until PAM support is defined to pass
 * data from the application to the PAM module.  This is currently
 * being worked on as of April 1999.  Use this interface with caution.
 */

#ifndef _RADIUS_H

/* some constant lengths */
#define AUTH_VECTOR_LEN		16
#define AUTH_PASS_LEN		16
#define AUTH_MAXPASS_LEN	48
#define AUTH_STRING_LEN		254	/* maximum of 254 */
#define AUTH_NAME_LEN		32

/* attribute types */
#define PW_TYPE_STRING			0
#define PW_TYPE_INTEGER			1
#define PW_TYPE_IPADDR			2
#define PW_TYPE_DATE			3
#define PW_TYPE_HIDDEN			4

/* radius attributes */
#define	PW_AUTHENTICATION_REQUEST	1
#define	PW_AUTHENTICATION_ACK		2
#define	PW_AUTHENTICATION_REJECT	3
#define	PW_ACCOUNTING_REQUEST		4
#define	PW_ACCOUNTING_RESPONSE		5
#ifdef PASSCHANGE
#define PW_PASSWORD_REQUEST		7
#define PW_PASSWORD_ACK			8
#define PW_PASSWORD_REJECT		9
#endif /* PASSCHANGE */
#define PW_ACCESS_CHALLENGE		11

#define	PW_USER_NAME			1
#define	PW_PASSWORD			2
#define	PW_CHAP_PASSWORD		3
#define	PW_CLIENT_ID			4
#define	PW_CLIENT_PORT_ID		5
#define	PW_USER_SERVICE_TYPE		6
#define	PW_FRAMED_PROTOCOL		7
#define	PW_FRAMED_ADDRESS		8
#define	PW_FRAMED_NETMASK		9
#define	PW_FRAMED_ROUTING		10
#define	PW_FRAMED_FILTER_ID		11
#define	PW_FRAMED_MTU			12
#define	PW_FRAMED_COMPRESSION		13
#define	PW_LOGIN_HOST			14
#define	PW_LOGIN_SERVICE		15
#define	PW_LOGIN_TCP_PORT		16
#ifdef PASSCHANGE
#define PW_OLD_PASSWORD			17
#endif
#define PW_PORT_MESSAGE			18
#define PW_DIALBACK_NO			19
#define PW_DIALBACK_NAME		20
#define PW_FRAMED_ROUTE			22
#define PW_FRAMED_IPXNET		23
#define PW_STATE			24
#define PW_TERMINATION			29

#define PW_ACCT_STATUS_TYPE		40
#define PW_ACCT_DELAY_TIME		41
#define PW_ACCT_INPUT_OCTETS		42
#define PW_ACCT_OUTPUT_OCTETS		43
#define PW_ACCT_SESSION_ID		44
#define PW_ACCT_AUTHENTIC		45
#define PW_ACCT_SESSION_TIME		46

#define PW_CONNECT_INFO			65
#define PW_SIGNATURE			66
#define PW_EAP_MESSAGE			67

typedef unsigned long	UINT4;

typedef struct value_pair {
	char			name[AUTH_NAME_LEN];  /* the textual name from the dictionary file */
	int			attribute;            /* the numeric ID from the dictionary file */
	int			type;                 /* the numeric type (PW_TYPE_* above) */
	UINT4			lvalue;	              /* length of strvalue if present OR integer or IPaddr value */
	char			strvalue[AUTH_STRING_LEN];   /* the string (not necessarily null terminated) */
	struct value_pair	*next;                /* pointer to next pair in list */
} VALUE_PAIR;

typedef struct auth_req {
	UINT4			ipaddr;	              /* IP address of NAS */
	u_short			udp_port;             /* remote port number */
	u_char			id;                   /* 8-bit request id */
	u_char			code;                 /* RADIUS request code */
	u_char			vector[16];           /* 16-bit request authenticator */
	u_char			secret[20];	      /* shared secret (max length supported is 16) */
	VALUE_PAIR		*request;             /* list of value-pairs of attrs which arrived in request */
	int		       	child_pid;            /* Process ID of child (not used) */
	UINT4			timestamp;            /* timestamp of request used internally */
	u_short			eap;                  /* eap == 1 --> Auth Request requires EAP (not used) */
	struct auth_req		*next;	              /* Next active request (don't mess with other requests) */
} AUTH_REQ;

#endif

/*
 * The functions which return pointers to data, the data
 * must be copied if it is to be saved.  The pointers are
 * volatile and what it points to may change at any time.
 */

/* return pointer to authreq structure, i.e. the radius request */
AUTH_REQ *get_authreq(pam_handle_t *pamh);

/* return the IP address of the host which sent request */
UINT4 radius_req_ipaddr(pam_handle_t *pamh);

/* return remote udp port number where request originated */
u_short radius_req_udp_port(pam_handle_t *pamh);

/* return the 8-bit request id from the radius request */
u_char radius_req_id(pam_handle_t *pamh);

/* return RADIUS request code from radius request */
u_char radius_req_code(pam_handle_t *pamh);

/* returns pointer to 16-byte request authenticator */
u_char *radius_req_vector(pam_handle_t *pamh);

/* returns pointer to 20-byte shared secret */
u_char *radius_req_secret(pam_handle_t *pamh);

/* return a pointer to head of radius attribute list */
VALUE_PAIR *radius_req_request_list(pam_handle_t *pamh);

/* return a pointer to head of grpCheckInfo attribute list in LDAP.
 * these have already been checked before entering pam_authenticate().
 */
VALUE_PAIR *get_user_check(pam_handle_t *pamh);

/* return a pointer to head of grpReplyInfo attribute list in LDAP.
 * if you modify this list, it affects what is returned in the RADIUS accept.
 * if you add items to this list, you must malloc a new VALUE_PAIR.  if you
 * remove a pair, you must call free on it.
 */
VALUE_PAIR *get_user_reply(pam_handle_t *pamh);

/*
 * Return attribute as VALUE_PAIR of first attribute found with the
 * attribute nuber matching attribute.  First the grpCheckInfo is
 * searched, then grpRelpyInfo, then lastly, the original request.
 * The grpCheckInfo and grpReplyInfo are translated based on the
 * mapping table.
 */
VALUE_PAIR *radius_req_request_attr(pam_handle_t *pamh, const int attrnum);

/*
 * Retrieve a specific value-pair from a list of value-pairs.
 *
 */
VALUE_PAIR *
get_attribute(VALUE_PAIR *value_list, int attribute);
