/*
 * Decompiled with CFR 0.152.
 */
package COM.Sun.sunsoft.sims.avm.base;

import COM.Sun.sunsoft.sims.avm.base.ALIGNMENT;
import COM.Sun.sunsoft.sims.avm.base.ColumnData;
import COM.Sun.sunsoft.sims.avm.base.Context;
import COM.Sun.sunsoft.sims.avm.base.Scroller;
import COM.Sun.sunsoft.sims.avm.base.Util;
import COM.Sun.sunsoft.sims.avm.base.ViewPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;

public class Table
extends Scroller {
    private static final String sccs_id = "@(#)Table.java 1.21 98/08/13 SMI";
    ViewPanel header;
    ViewPanel pinArea;
    boolean showHorzScrollbar = true;
    boolean showVertScrollbar = true;
    int numRows;
    int numVisibleRows = 1;
    Vector[] rows;
    int numColumns;
    ColumnData[] colInfo = new ColumnData[9];
    int firstrow;
    int firstcol;
    int scrollx;
    int rowh;
    int baseline;
    int hmargin = 10;
    int vmargin;
    int hgap = 3;
    int vgap = 1;
    Vector pinned;
    Image viewBuffer;
    Image headerBuffer;
    Image pinBuffer;
    boolean showColDivs = false;
    boolean showRowDivs = false;
    Font font = Context.getFontProperty((String)"plainFont");
    Font headerFont = Context.getFontProperty((String)"labelFont");
    Color divColor = Color.lightGray;
    boolean multipleSelections = false;
    int[] selected = new int[0];
    boolean columnsResizable = true;
    boolean resizing = false;
    int resizeColumn;
    int startx;
    int endx;
    int z;
    TextField[] textField = new TextField[20];
    StringBuffer searchPattern = new StringBuffer();
    private long _lastTime;
    private long _lastIndex;
    private char refChar = (char)65;

    public Table() {
        this(0);
    }

    public Table(int n) {
        this.header = new ViewPanel();
        this.add("Header", (Component)this.header);
        this.header.hide();
        this.rows = new Vector[40];
        this.numVisibleRows = n;
        this.vmargin = this.showRowDivs ? 1 : 0;
        this.pinned = new Vector();
        this.header.setForeground(Color.white);
        this.header.setBackground(new Color(70, 70, 170));
        this.viewport.setForeground(Color.black);
        this.viewport.setBackground(Color.white);
        Color color = Context.getColorProperty((String)"Table.viewportBackground");
        if (color != null) {
            this.viewport.setBackground(color);
        }
        if ((color = Context.getColorProperty((String)"Table.viewportForeground")) != null) {
            this.viewport.setForeground(color);
        }
        if ((color = Context.getColorProperty((String)"Table.headerBackground")) != null) {
            this.header.setBackground(color);
        }
        if ((color = Context.getColorProperty((String)"Table.headerForeground")) != null) {
            this.header.setForeground(color);
        }
    }

    public void addNotify() {
        super.addNotify();
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        if (fontMetrics != null) {
            this.baseline = fontMetrics.getAscent();
            this.rowh = fontMetrics.getHeight() + 2 * this.vmargin;
        }
        if ((fontMetrics = this.getFontMetrics(this.headerFont)) != null) {
            this.header.resize(100, fontMetrics.getHeight());
        }
    }

    public Component viewportArea() {
        return this.viewport;
    }

    public Component headerArea() {
        return this.header;
    }

    public void scrollTo(int n, int n2) {
        int n3 = this.getVisibleColumns();
        if (n < this.firstcol || n > this.firstcol + n3) {
            this.firstcol = Math.max(n - n3 / 2, 0);
            this.firstcol = Math.min(this.numColumns - n3, this.firstcol);
            this.hbar.setValue(this.firstcol);
            this.repaint();
        }
        n3 = this.getVisibleRows();
        if (n2 < this.firstrow || n2 > this.firstrow + n3) {
            this.firstrow = Math.max(n2 - n3 / 2, 0);
            this.firstrow = Math.min(this.numRows - n3, this.firstrow);
            this.vbar.setValue(this.firstrow);
            this.repaint();
        }
    }

    public Dimension getScrollAreaSize() {
        int n = this.hmargin;
        int n2 = 0;
        while (n2 < this.numColumns) {
            n += this.colInfo[n2].width + this.hmargin;
            ++n2;
        }
        int n3 = this.numRows * (this.rowh + this.vmargin);
        return new Dimension(n, n3);
    }

    private void manageScrollbarsInternal() {
        this.manageScrollbars();
        this.validate();
    }

    public void manageScrollbars() {
        this.manageVbar();
        boolean bl = this.manageHbar();
        if (bl) {
            this.manageVbar();
        }
    }

    private boolean manageHbar() {
        int n = 0;
        boolean bl = false;
        if (this.showHorzScrollbar) {
            int n2 = this.getNumColumns();
            int n3 = this.getVisibleColumns();
            if (n2 > 1 && n2 - n3 > 0) {
                Dimension dimension;
                if (!this.hbar.isVisible()) {
                    this.hbar.show();
                    bl = true;
                }
                Dimension dimension2 = this.size();
                if (this.vbar != null && this.vbar.isVisible()) {
                    dimension = this.vbar.preferredSize();
                    dimension2.width -= dimension.width;
                }
                if (this.pinArea != null && this.pinArea.isVisible()) {
                    dimension = this.pinArea.preferredSize();
                    dimension2.width -= dimension.width;
                }
                dimension = this.getScrollAreaSize();
                int n4 = this.hmargin;
                int n5 = 0;
                while (n5 < this.numColumns && n4 < dimension.width - dimension2.width) {
                    n4 += this.colInfo[n5].width + this.hmargin;
                    ++n5;
                }
                int n6 = Math.min(this.hbar.getValue(), n5);
                int n7 = Math.max(n3, 1);
                this.hbar.setValues(n6, n7, n, this.numColumns);
                this.hbar.setLineIncrement(1);
                this.hbar.setPageIncrement(n7);
                this.setLeftColumn(n6);
            } else if (this.hbar.isVisible()) {
                this.hbar.hide();
                this.hbar.setValue(0);
                this.setLeftColumn(0);
                bl = true;
            }
        }
        return bl;
    }

    private boolean manageVbar() {
        int n = 0;
        boolean bl = false;
        if (this.showVertScrollbar) {
            int n2;
            int n3 = this.getNumRows();
            if (n3 - (n2 = this.getVisibleRows()) > 0) {
                if (!this.vbar.isVisible()) {
                    this.vbar.show();
                    bl = true;
                }
                int n4 = n3 - n2;
                int n5 = Math.min(this.vbar.getValue(), n4);
                int n6 = Math.max(n2, 1);
                this.vbar.setValues(n5, n6, n, n3);
                this.vbar.setLineIncrement(1);
                this.vbar.setPageIncrement(n6);
                this.setTopRow(n5);
            } else if (this.vbar.isVisible()) {
                this.vbar.hide();
                this.vbar.setValue(0);
                this.setTopRow(0);
                bl = true;
            }
        }
        return bl;
    }

    public Dimension preferredSize(int n) {
        Dimension dimension = this.getScrollAreaSize();
        dimension.height = n * (this.rowh + this.vmargin);
        if (this.header != null) {
            Dimension dimension2 = this.header.size();
            dimension.height += dimension2.height;
        }
        return dimension;
    }

    public Dimension preferredSize() {
        if (this.numVisibleRows > 0) {
            return this.preferredSize(this.numVisibleRows);
        }
        return super.preferredSize();
    }

    public synchronized void addRow(Vector vector) {
        this.addRow(vector, -1);
    }

    public synchronized void addRow(Vector vector, int n) {
        Object object;
        int n2 = 0;
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof String) && object instanceof Image) {
                this.rowh = Math.max(this.rowh, ((Image)object).getHeight((ImageObserver)this));
            }
            vector2.addElement(object);
            ++n2;
        }
        if (this.numColumns == 0) {
            this.numColumns = n2;
        }
        if (this.numRows == this.rows.length) {
            object = new Vector[this.rows.length + 100];
            System.arraycopy(this.rows, 0, object, 0, this.rows.length);
            this.rows = object;
        }
        if (n < -1 || n >= this.numRows) {
            n = -1;
        }
        if (n == -1) {
            this.rows[this.numRows++] = vector2;
        } else {
            n2 = this.numRows;
            while (n2 > n) {
                this.rows[n2] = this.rows[n2 - 1];
                --n2;
            }
            this.rows[n] = vector2;
            ++this.numRows;
        }
        this.manageScrollbarsInternal();
        this.repaint();
    }

    public synchronized void setRows(Vector[] vectorArray) {
        this.rows = vectorArray;
        this.numRows = vectorArray.length;
        this.selected = new int[0];
        this.manageScrollbarsInternal();
        this.repaint();
    }

    public synchronized void setVisibleRows(int n) {
        this.numVisibleRows = n;
        this.invalidate();
    }

    public synchronized void replaceRow(Vector vector, int n) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        this.rows[n] = vector;
        this.repaint();
    }

    public synchronized void deleteRow(int n) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        int n2 = n;
        while (n2 < this.numRows - 1) {
            this.rows[n2] = this.rows[n2 + 1];
            ++n2;
        }
        --this.numRows;
        if (this.isSelected(n)) {
            int[] nArray = new int[this.selected.length - 1];
            if (nArray.length > 0) {
                System.arraycopy(this.selected, 0, nArray, 0, n);
                System.arraycopy(this.selected, n + 1, nArray, n, this.selected.length - (n + 1));
            }
            this.selected = nArray;
        }
        int n3 = 0;
        while (n3 < this.selected.length) {
            if (n < this.selected[n3]) {
                int n4 = n3;
                this.selected[n4] = this.selected[n4] - 1;
            }
            ++n3;
        }
        this.manageScrollbarsInternal();
        this.repaint();
    }

    public synchronized void clear() {
        this.rows = new Vector[100];
        this.numRows = 0;
        this.selected = new int[0];
        this.manageScrollbarsInternal();
        this.repaint();
    }

    public Object getItem(int n, int n2) {
        return this.rows[n].elementAt(n2);
    }

    public Font getFont() {
        return this.font;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public Vector getRow(int n) {
        return this.rows[n];
    }

    public Vector[] getRows() {
        return this.rows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getColumnWidth(int n) {
        return this.colInfo[n].width;
    }

    public int getColumnWidthInChars(int n) {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.font);
        return this.colInfo[n].width / fontMetrics.charWidth(this.refChar);
    }

    public String getColumnLabel(int n) {
        return this.colInfo[n].label;
    }

    public boolean getColumnsResizable() {
        return this.columnsResizable;
    }

    public int getVisibleRows() {
        Dimension dimension;
        Dimension dimension2 = this.size();
        if (this.header != null && this.header.isVisible()) {
            dimension = this.header.preferredSize();
            dimension2.height -= dimension.height;
        }
        if (this.hbar != null && this.hbar.isVisible()) {
            dimension = this.hbar.preferredSize();
            dimension2.height -= dimension.height;
        }
        int n = 0;
        if (this.rowh > 0) {
            n = (dimension2.height - 4) / (this.rowh + this.vmargin);
        }
        return Math.max(n, 0);
    }

    public synchronized void setFont(Font font) {
        this.font = font;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics != null) {
            this.baseline = fontMetrics.getAscent();
            this.rowh = fontMetrics.getHeight() + 2 * this.vmargin;
        }
        this.repaint();
    }

    public synchronized void setHeaderFont(Font font) {
        this.headerFont = font;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics != null) {
            this.header.resize(100, fontMetrics.getHeight());
        }
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    public synchronized void setItem(int n, int n2, Object object) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        this.rows[n].setElementAt(object, n2);
        this.repaint();
    }

    public synchronized void setColumnLabel(int n, String string) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range: " + n);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.headerFont);
        this.colInfo[n].label = string;
        this.colInfo[n].width = fontMetrics.stringWidth(string) + 5;
        this.colInfo[n].align = ALIGNMENT.LEFT;
        this.header.show();
    }

    public synchronized void setColumnLabels(Vector vector) {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.headerFont);
        this.setNumColumns(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string;
            this.colInfo[n].label = string = (String)vector.elementAt(n);
            this.colInfo[n].width = fontMetrics.stringWidth(string) + 5;
            this.colInfo[n].align = ALIGNMENT.LEFT;
            ++n;
        }
        this.header.show();
    }

    public synchronized void setNumColumns(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of columns less than one");
        }
        ColumnData[] columnDataArray = new ColumnData[n];
        int n2 = Math.min(n, this.numColumns);
        int n3 = 0;
        while (n3 < n2) {
            columnDataArray[n3] = this.colInfo[n3];
            ++n3;
        }
        int n4 = this.numColumns;
        while (n4 < n) {
            columnDataArray[n4] = new ColumnData();
            ++n4;
        }
        this.numColumns = n;
        this.colInfo = columnDataArray;
    }

    public synchronized void setColumnWidth(int n, int n2) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range: " + n);
        }
        this.colInfo[n].width = n2;
    }

    public synchronized void setColumnWidth(int n, int n2, ALIGNMENT aLIGNMENT) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range: " + n);
        }
        this.colInfo[n].width = n2;
        this.colInfo[n].align = aLIGNMENT;
    }

    public synchronized void setColumnWidthInChars(int n, int n2) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range: " + n);
        }
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.font);
        this.colInfo[n].width = n2 * fontMetrics.charWidth(this.refChar);
    }

    public synchronized void setColumnWidthInChars(int n, int n2, ALIGNMENT aLIGNMENT) {
        this.setColumnWidthInChars(n, n2);
        this.colInfo[n].align = aLIGNMENT;
    }

    public synchronized void setColumnsResizable(boolean bl) {
        Frame frame;
        this.columnsResizable = bl;
        if (!this.columnsResizable && (frame = Util.findFrame((Component)this)) != null) {
            frame.setCursor(0);
        }
    }

    public void showColumnDividers(boolean bl) {
        if (bl != this.showColDivs) {
            this.showColDivs = bl;
            this.repaint();
        }
    }

    public void showRowDividers(boolean bl) {
        if (bl != this.showRowDivs) {
            this.showRowDivs = bl;
            this.vmargin = this.showRowDivs ? 1 : 0;
            this.repaint();
        }
    }

    public void showHorizontalScrollbar(boolean bl) {
        this.showHorzScrollbar = bl;
        if (bl) {
            this.hbar.show();
            return;
        }
        this.hbar.hide();
    }

    public void showVerticalScrollbar(boolean bl) {
        this.showVertScrollbar = bl;
        if (bl) {
            this.vbar.show();
            return;
        }
        this.vbar.hide();
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public synchronized int[] getSelectedIndexes() {
        return this.selected;
    }

    public synchronized Vector[] getSelectedRows() {
        int[] nArray = this.getSelectedIndexes();
        Vector[] vectorArray = new Vector[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            vectorArray[n] = this.rows[nArray[n]];
            ++n;
        }
        return vectorArray;
    }

    public synchronized void select(int n) {
        this.select(n, true);
    }

    public void select(int n, boolean bl) {
        Object object;
        Graphics graphics = this.viewport.getGraphics();
        Graphics graphics2 = null;
        if (n < 0 || n >= this.numRows) {
            return;
        }
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                return;
            }
            ++n2;
        }
        if (this.pinArea != null) {
            graphics2 = this.pinArea.getGraphics();
        }
        if (!this.multipleSelections) {
            if (this.selected.length > 0) {
                this.highlight(this.selected[0], false, graphics, graphics2);
            }
            this.selected = new int[1];
            this.selected[0] = n;
        } else {
            object = new int[this.selected.length + 1];
            System.arraycopy(this.selected, 0, object, 0, this.selected.length);
            object[this.selected.length] = n;
            this.selected = object;
        }
        this.highlight(n, true, graphics, graphics2);
        this.drawDividers(graphics);
        if (bl) {
            object = new Event(this, System.currentTimeMillis(), 701, 0, 0, 0, 0, new Integer(n));
            this.deliverEvent((Event)object);
        }
    }

    public synchronized void deselect(int n) {
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                Graphics graphics = this.viewport.getGraphics();
                Graphics graphics2 = null;
                if (this.pinArea != null) {
                    graphics2 = this.pinArea.getGraphics();
                }
                this.highlight(n, false, graphics, graphics2);
                this.drawDividers(graphics);
                int[] nArray = new int[this.selected.length - 1];
                System.arraycopy(this.selected, 0, nArray, 0, n2);
                System.arraycopy(this.selected, n2 + 1, nArray, n2, this.selected.length - (n2 + 1));
                this.selected = nArray;
                Event event = new Event(this, System.currentTimeMillis(), 702, 0, 0, 0, 0, new Integer(n));
                this.deliverEvent(event);
                return;
            }
            ++n2;
        }
    }

    public synchronized void deselectAll() {
        this.selected = new int[0];
        this.repaint();
    }

    public synchronized boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean allowsMultipleSelections() {
        return this.multipleSelections;
    }

    public synchronized void setMultipleSelections(boolean bl) {
        if (bl != this.multipleSelections) {
            this.multipleSelections = bl;
            this.selected = new int[0];
            this.repaint();
        }
    }

    public void makeRowVisible(int n) {
        this.scrollTo(this.firstcol, n);
    }

    public void pinColumn(int n) {
        if (n < 0 || n >= this.numColumns || this.isPinned(n)) {
            return;
        }
        this.pinned.addElement(new Integer(n));
        if (this.pinArea == null) {
            this.pinArea = new ViewPanel();
            this.add("Pin", (Component)this.pinArea);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.pinned.size()) {
            int n4 = (Integer)this.pinned.elementAt(n3);
            n2 += this.colInfo[n4].width + this.hmargin;
            ++n3;
        }
        this.pinArea.resize(n2 + this.hmargin, 100);
        this.pinArea.show();
        this.validate();
        Dimension dimension = this.size();
        Graphics graphics = this.getGraphics();
        graphics.clearRect(0, 0, dimension.width, dimension.height);
        this.pinBuffer = null;
    }

    public void unpinColumn(int n) {
        if (n < 0 || n >= this.numColumns || !this.isPinned(n)) {
            return;
        }
        this.pinned.removeElement(new Integer(n));
        if (this.pinned.isEmpty()) {
            this.remove((Component)this.pinArea);
            this.pinArea = null;
            this.pinBuffer = null;
        } else {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.pinned.size()) {
                int n4 = (Integer)this.pinned.elementAt(n3);
                n2 += this.colInfo[n4].width + this.hmargin;
                ++n3;
            }
            this.pinArea.resize(n2 + this.hmargin, 100);
        }
        this.validate();
    }

    public synchronized boolean isPinned(int n) {
        return this.pinned.contains(new Integer(n));
    }

    public void paint(Graphics graphics) {
        Dimension dimension;
        Graphics graphics2 = null;
        Rectangle rectangle = this.viewport.bounds();
        graphics.setColor(this.getBackground());
        this.drawBevelRect(graphics, rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4, 2, false);
        if (this.viewBuffer == null) {
            dimension = this.viewport.size();
            if (dimension.width <= 0 || dimension.height <= 0) {
                return;
            }
            this.viewBuffer = this.createImage(dimension.width, dimension.height);
            this.headerBuffer = this.createImage(dimension.width, this.rowh + this.vmargin);
        }
        if (this.pinArea != null && this.pinBuffer == null) {
            dimension = this.pinArea.size();
            this.pinBuffer = this.createImage(dimension.width, dimension.height);
        }
        this.drawHeader(this.headerBuffer.getGraphics());
        dimension = this.viewport.size();
        Graphics graphics3 = this.viewBuffer.getGraphics();
        graphics3.setColor(this.viewport.getBackground());
        graphics3.fillRect(0, 0, dimension.width, dimension.height);
        graphics3.translate(this.scrollx, 0);
        if (this.pinArea != null) {
            dimension = this.pinArea.size();
            graphics2 = this.pinBuffer.getGraphics();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
        }
        this.drawList(graphics3, graphics2);
        int n = 0;
        while (n < this.selected.length) {
            this.highlight(this.selected[n], true, graphics3, graphics2);
            ++n;
        }
        this.drawDividers(graphics3);
        Graphics graphics4 = this.header.getGraphics();
        graphics4.drawImage(this.headerBuffer, 0, 0, (ImageObserver)this);
        if (this.pinArea != null) {
            graphics2 = this.pinArea.getGraphics();
            graphics2.drawImage(this.pinBuffer, 0, 0, (ImageObserver)this);
        }
        graphics3 = this.viewport.getGraphics();
        graphics3.drawImage(this.viewBuffer, 0, 0, (ImageObserver)this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.headerBuffer = null;
        this.viewBuffer = null;
        this.pinBuffer = null;
    }

    public boolean handleEvent(Event event) {
        this.viewport.location();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (event.id == 601 || event.id == 602 || event.id == 603 || event.id == 604 || event.id == 605) {
            n = ((Scrollbar)event.target).getOrientation();
            n5 = ((Scrollbar)event.target).getMinimum();
            n6 = ((Scrollbar)event.target).getMaximum();
            n2 = ((Scrollbar)event.target).getVisible();
            n3 = ((Scrollbar)event.target).getLineIncrement();
            n4 = ((Scrollbar)event.target).getPageIncrement();
        }
        switch (event.id) {
            case 505: {
                return this.pointerExit(event, event.x, event.y);
            }
            case 503: {
                return this.pointerMove(event, event.x, event.y);
            }
            case 501: {
                return this.pointerDown(event, event.x, event.y);
            }
            case 506: {
                return this.pointerDrag(event, event.x, event.y);
            }
            case 502: {
                return this.pointerUp(event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyPress(event, event.key);
            }
            case 601: {
                if (n == 1) {
                    if (this.firstrow <= 0) break;
                    this.firstrow -= n3;
                    this.scrollRows(-n3);
                    break;
                }
                if (this.firstcol <= 0) break;
                this.firstcol -= n3;
                while (this.isPinned(this.firstcol)) {
                    --this.firstcol;
                }
                this.repaint();
                break;
            }
            case 602: {
                if (n == 1) {
                    if (this.firstrow >= this.numRows) break;
                    this.firstrow += n3;
                    this.scrollRows(n3);
                    break;
                }
                if (this.firstcol >= this.numColumns) break;
                this.firstcol += n3;
                while (this.isPinned(this.firstcol)) {
                    ++this.firstcol;
                }
                this.repaint();
                break;
            }
            case 603: {
                if (n == 1) {
                    this.firstrow = Math.max(this.firstrow - n4, n5);
                } else {
                    this.firstcol = Math.max(this.firstcol - n4, n5);
                    while (this.isPinned(this.firstcol)) {
                        --this.firstcol;
                    }
                }
                this.repaint();
                break;
            }
            case 604: {
                if (n == 1) {
                    this.firstrow = Math.min(this.firstrow + n4, n6);
                } else {
                    this.firstcol = Math.min(this.firstcol + n4, n6);
                    while (this.isPinned(this.firstcol)) {
                        ++this.firstcol;
                    }
                }
                this.repaint();
                break;
            }
            case 605: {
                int n7 = (Integer)event.arg;
                if (n == 1) {
                    int n8 = n7 - this.firstrow;
                    this.firstrow = n7;
                    if (Math.abs(n8) < this.getVisibleRows()) {
                        this.scrollRows(n8);
                        break;
                    }
                    this.repaint();
                    break;
                }
                int n9 = 0;
                this.firstcol = -1;
                while (n9 <= n7) {
                    ++this.firstcol;
                    if (this.isPinned(this.firstcol)) continue;
                    ++n9;
                }
                this.repaint();
                break;
            }
            default: {
                return super.handleEvent(event);
            }
        }
        return false;
    }

    private void scrollRows(int n) {
        int n2;
        int n3;
        Dimension dimension = this.viewport.size();
        Graphics graphics = this.viewport.getGraphics();
        Dimension dimension2 = null;
        Graphics graphics2 = null;
        int n4 = this.getVisibleRows();
        if (this.pinArea != null) {
            dimension2 = this.pinArea.size();
            graphics2 = this.pinArea.getGraphics();
        }
        int n5 = -n * (this.rowh + this.vmargin);
        int n6 = (n4 - Math.abs(n)) * (this.rowh + this.vmargin);
        if (n < 0) {
            n3 = Math.max(this.firstrow, 0);
            n2 = 0;
            graphics.copyArea(0, 0, dimension.width, n6, 0, n5);
            if (graphics2 != null) {
                graphics2.copyArea(0, 0, dimension2.width, n6, 0, n5);
            }
        } else {
            n3 = Math.min(this.firstrow - n + n4, this.numRows - 1);
            n2 = n4 - n;
            graphics.copyArea(0, -n5, dimension.width, n6, 0, n5);
            if (graphics2 != null) {
                graphics2.copyArea(0, -n5, dimension2.width, n6, 0, n5);
            }
        }
        if (this.viewBuffer != null) {
            Graphics graphics3 = this.viewBuffer.getGraphics();
            graphics3.setColor(this.viewport.getBackground());
            graphics3.fillRect(0, n2 * (this.rowh + this.vmargin), dimension.width, Math.abs(n) * (this.rowh + this.vmargin));
            Graphics graphics4 = null;
            if (graphics2 != null) {
                graphics4 = this.pinBuffer.getGraphics();
                graphics4.setColor(this.getBackground());
                graphics4.fillRect(0, n2 * (this.rowh + this.vmargin), dimension2.width, Math.abs(n) * (this.rowh + this.vmargin));
            }
            graphics3.setFont(this.font);
            graphics3.setColor(this.viewport.getForeground());
            if (graphics4 != null) {
                graphics4.setFont(this.font);
                graphics4.setColor(this.viewport.getForeground());
            }
            int n7 = n2;
            int n8 = Math.min(n3 + Math.abs(n), this.numRows);
            int n9 = n3;
            while (n9 < n8) {
                this.drawRow(this.rows[n9], (this.rowh + this.vmargin) * n7++, graphics3, graphics4);
                ++n9;
            }
            int n10 = 0;
            while (n10 < this.selected.length) {
                if (this.selected[n10] >= n3 && this.selected[n10] < n8) {
                    this.highlight(this.selected[n10], true, graphics3, graphics4);
                }
                ++n10;
            }
            this.drawDividers(graphics3);
            graphics.clipRect(0, n2 * (this.rowh + this.vmargin), dimension.width, Math.abs(n) * (this.rowh + this.vmargin));
            graphics.drawImage(this.viewBuffer, 0, 0, (ImageObserver)this);
            if (graphics2 != null) {
                graphics2.clipRect(0, n2 * (this.rowh + this.vmargin), dimension2.width, Math.abs(n) * (this.rowh + this.vmargin));
                graphics2.drawImage(this.pinBuffer, 0, 0, (ImageObserver)this);
            }
        }
    }

    private boolean pointerExit(Event event, int n, int n2) {
        if (event.target == this.viewport && this.resizing) {
            Frame frame = Util.findFrame((Component)this);
            if (frame != null) {
                frame.setCursor(0);
            }
            this.resizing = false;
        }
        return true;
    }

    private boolean pointerMove(Event event, int n, int n2) {
        if (!this.columnsResizable) {
            return true;
        }
        if (this.inResizeArea(n, n2)) {
            if (!this.resizing) {
                Frame frame = Util.findFrame((Component)this);
                if (frame != null) {
                    frame.setCursor(11);
                }
                this.resizing = true;
            }
        } else if (this.resizing) {
            Frame frame = Util.findFrame((Component)this);
            if (frame != null) {
                frame.setCursor(0);
            }
            this.resizing = false;
        }
        return true;
    }

    private boolean pointerDrag(Event event, int n, int n2) {
        if (this.resizing && n > this.startx) {
            Graphics graphics = this.viewport.getGraphics();
            Rectangle rectangle = this.viewport.bounds();
            graphics.setXORMode(Color.blue);
            graphics.drawLine(this.endx, 0, this.endx, rectangle.height);
            this.endx = n - rectangle.x;
            graphics.drawLine(this.endx, 0, this.endx, rectangle.height);
        }
        return true;
    }

    private boolean pointerDown(Event event, int n, int n2) {
        Rectangle rectangle = this.viewport.bounds();
        Rectangle rectangle2 = new Rectangle();
        Graphics graphics = this.viewport.getGraphics();
        if (this.pinArea != null) {
            rectangle2 = this.pinArea.bounds();
        }
        if (!rectangle.inside(n, n2) && !rectangle2.inside(n, n2) || this.firstrow + (n2 - rectangle.y) / (this.rowh + this.vmargin) > this.numRows - 1) {
            return true;
        }
        if (this.columnsResizable && this.inResizeArea(n, n2)) {
            this.resizing = true;
            graphics.setXORMode(Color.blue);
            graphics.drawLine(this.endx, 0, this.endx, rectangle.height);
        } else {
            int n3 = this.firstrow + (n2 - rectangle.y) / (this.rowh + this.vmargin);
            this.select(n3, false);
            Event event2 = new Event(this, event.when, 701, event.x, event.y, event.key, event.modifiers, new Integer(n3));
            event2.clickCount = event.clickCount;
            if (event.when - this._lastTime < 500L && (long)n3 == this._lastIndex) {
                event2.clickCount = 2;
            }
            this._lastTime = event.when;
            this._lastIndex = n3;
            this.deliverEvent(event2);
        }
        return true;
    }

    private boolean pointerUp(Event event, int n, int n2) {
        if (this.resizing) {
            Frame frame;
            Graphics graphics = this.viewport.getGraphics();
            Dimension dimension = this.viewport.size();
            graphics.setXORMode(Color.blue);
            graphics.drawLine(this.endx, 0, this.endx, dimension.height);
            this.setColumnWidth(this.resizeColumn, this.endx - this.startx - this.hmargin / 2);
            if (!this.inResizeArea(n, n2) && (frame = Util.findFrame((Component)this)) != null) {
                frame.setCursor(0);
            }
            this.resizing = false;
            this.manageScrollbarsInternal();
            this.repaint();
        }
        return true;
    }

    private boolean keyPress(Event event, int n) {
        return false;
    }

    private synchronized void setTopRow(int n) {
        if (n >= 0 && n < this.numRows) {
            this.firstrow = n;
            this.vbar.setValue(n);
            this.repaint();
        }
    }

    private synchronized void setLeftColumn(int n) {
        if (n >= 0 && n < this.numColumns) {
            this.firstcol = n;
            this.hbar.setValue(n);
            this.repaint();
        }
    }

    private int getVisibleColumns() {
        Dimension dimension;
        Dimension dimension2 = this.size();
        if (this.vbar != null && this.vbar.isVisible()) {
            dimension = this.vbar.preferredSize();
            dimension2.width -= dimension.width;
        }
        if (this.pinArea != null && this.pinArea.isVisible()) {
            dimension = this.pinArea.preferredSize();
            dimension2.width -= dimension.width;
        }
        int n = -1;
        int n2 = 0;
        while (n < this.numColumns - 1 && n2 < dimension2.width - 4) {
            if (this.isPinned(++n)) continue;
            n2 += this.hmargin + this.colInfo[n].width;
        }
        return Math.max(n, 0);
    }

    private void highlight(int n, boolean bl, Graphics graphics, Graphics graphics2) {
        Color color;
        Color color2;
        Dimension dimension = this.viewport.size();
        if (n < 0 || n > this.firstrow + this.getVisibleRows()) {
            return;
        }
        if (bl) {
            color2 = this.viewport.getForeground();
            color = this.viewport.getBackground();
        } else {
            color2 = this.viewport.getBackground();
            color = this.viewport.getForeground();
        }
        graphics.translate(0, 0);
        Rectangle rectangle = new Rectangle(0, (n - this.firstrow) * (this.rowh + this.vmargin), dimension.width, this.rowh);
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        graphics.translate(this.scrollx, 0);
        graphics.setFont(this.font);
        if (graphics2 != null) {
            dimension = this.pinArea.size();
            graphics2.setColor(color2);
            graphics2.fillRect(rectangle.x, rectangle.y, dimension.width, rectangle.height);
            graphics2.setColor(color);
            graphics2.setFont(this.font);
        }
        this.drawRow(this.rows[n], rectangle.y, graphics, graphics2);
    }

    private void drawRow(Vector vector, int n, Graphics graphics, Graphics graphics2) {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.font);
        Graphics graphics3 = null;
        int n2 = fontMetrics.getHeight();
        int n3 = this.hmargin;
        int n4 = this.hmargin;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.numColumns) {
            block23: {
                int n7;
                Object e;
                block22: {
                    block21: {
                        try {
                            e = vector.elementAt(n6);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            return;
                        }
                        if (!this.isPinned(n6)) break block21;
                        graphics3 = graphics2.create();
                        graphics3.translate(n4, n);
                        break block22;
                    }
                    if (n6 < this.firstcol) break block23;
                    graphics3 = graphics.create();
                    graphics3.translate(n3, n);
                }
                graphics3.clipRect(0, 0, this.colInfo[n6].width, this.rowh);
                if (e instanceof String || e instanceof Integer) {
                    String string = e instanceof String ? (String)e : e.toString();
                    n7 = fontMetrics.stringWidth(string);
                    if (this.colInfo[n6].align == ALIGNMENT.LEFT) {
                        n5 = 0;
                    } else if (this.colInfo[n6].align == ALIGNMENT.CENTER) {
                        n5 = (this.colInfo[n6].width - n7) / 2;
                    } else if (this.colInfo[n6].align == ALIGNMENT.RIGHT) {
                        n5 = this.colInfo[n6].width - n7;
                    }
                    graphics3.drawString(string, n5, (this.rowh - n2) / 2 + this.baseline);
                } else if (e instanceof Image) {
                    n7 = ((Image)e).getWidth((ImageObserver)this);
                    int n8 = ((Image)e).getHeight((ImageObserver)this);
                    if (this.colInfo[n6].align == ALIGNMENT.LEFT) {
                        n5 = 0;
                    } else if (this.colInfo[n6].align == ALIGNMENT.CENTER) {
                        n5 = (this.colInfo[n6].width - n7) / 2;
                    } else if (this.colInfo[n6].align == ALIGNMENT.RIGHT) {
                        n5 = this.colInfo[n6].width - n7;
                    }
                    graphics3.drawImage((Image)e, n5, (this.rowh - n8) / 2, (ImageObserver)this);
                }
                if (this.isPinned(n6)) {
                    n4 += this.colInfo[n6].width + this.hmargin;
                } else {
                    n3 += this.colInfo[n6].width + this.hmargin;
                }
            }
            ++n6;
        }
    }

    private void drawList(Graphics graphics, Graphics graphics2) {
        graphics.setFont(this.font);
        graphics.setColor(this.viewport.getForeground());
        if (graphics2 != null) {
            graphics2.setFont(this.font);
            graphics2.setColor(this.viewport.getForeground());
        }
        int n = 0;
        int n2 = Math.min(this.firstrow + this.getVisibleRows(), this.numRows);
        int n3 = this.firstrow;
        while (n3 < n2) {
            this.drawRow(this.rows[n3], (this.rowh + this.vmargin) * n++, graphics, graphics2);
            ++n3;
        }
    }

    private void drawHeader(Graphics graphics) {
        block12: {
            FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.headerFont);
            int n = 0;
            int n2 = this.hmargin + 2;
            int n3 = this.hmargin + 2;
            if (this.header == null || !this.header.isVisible()) break block12;
            Rectangle rectangle = this.viewport.bounds();
            Rectangle rectangle2 = this.header.bounds();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(0, 0, rectangle2.width, rectangle2.height);
            graphics.setFont(this.headerFont);
            int n4 = fontMetrics.getAscent();
            int n5 = 0;
            while (n5 < this.numColumns) {
                block15: {
                    Graphics graphics2;
                    block14: {
                        block13: {
                            int n6 = fontMetrics.stringWidth(this.colInfo[n5].label);
                            if (this.colInfo[n5].align == ALIGNMENT.LEFT) {
                                n = 0;
                            } else if (this.colInfo[n5].align == ALIGNMENT.CENTER) {
                                n = (this.colInfo[n5].width - n6) / 2;
                            } else if (this.colInfo[n5].align == ALIGNMENT.RIGHT) {
                                n = this.colInfo[n5].width - n6;
                            }
                            graphics.setColor(this.header.getForeground());
                            graphics2 = graphics.create();
                            if (!this.isPinned(n5)) break block13;
                            graphics2.translate(n3, 0);
                            break block14;
                        }
                        if (n5 < this.firstcol) break block15;
                        graphics2.translate(rectangle.x + this.scrollx + n2, 0);
                    }
                    graphics2.clipRect(0, 0, this.colInfo[n5].width, this.rowh);
                    graphics2.drawString(this.colInfo[n5].label, n, n4);
                    if (this.isPinned(n5)) {
                        n3 += this.colInfo[n5].width + this.hmargin;
                    } else {
                        if (this.showColDivs) {
                            int n7 = n2 + this.colInfo[n5].width + this.hmargin / 2;
                            graphics.setColor(this.divColor);
                            graphics.drawLine(n7, 0, n7, rectangle2.height);
                        }
                        n2 += this.colInfo[n5].width + this.hmargin;
                    }
                }
                ++n5;
            }
        }
    }

    private void drawBevelRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        graphics.setColor(bl ? color2 : color3);
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawLine(n + n6, n2 + n6, n + n6, n2 + n4 - n6);
            graphics.drawLine(n + n6 + 1, n2 + n6, n + n3 - n6 - 1, n2 + n6);
            ++n6;
        }
        graphics.setColor(bl ? color3 : color2);
        int n7 = 0;
        while (n7 < n5) {
            graphics.drawLine(n + n7 + 1, n2 + n4 - n7, n + n3 - n7, n2 + n4 - n7);
            graphics.drawLine(n + n3 - n7, n2 + n7, n + n3 - n7, n2 + n4 - n7 - 1);
            ++n7;
        }
        graphics.setColor(color);
    }

    private void drawDividers(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension = this.viewport.size();
        graphics.setColor(this.divColor);
        if (this.showRowDivs) {
            int n3 = 0;
            int n4 = this.getVisibleRows();
            n2 = 0;
            while (n2 < n4) {
                n = (n3 += this.rowh) + this.vmargin / 2;
                graphics.drawLine(0, n, dimension.width, n);
                n3 += this.vmargin;
                ++n2;
            }
        }
        if (this.showColDivs) {
            int n5 = this.hmargin;
            n2 = this.firstcol;
            while (n2 < Math.min(this.firstcol + this.numColumns - 1, this.numColumns - 1)) {
                if (!this.isPinned(n2)) {
                    n = (n5 += this.colInfo[n2].width) + this.hmargin / 2;
                    graphics.drawLine(n, 0, n, dimension.height);
                    n5 += this.hmargin;
                }
                ++n2;
            }
        }
    }

    private boolean inResizeArea(int n, int n2) {
        Rectangle rectangle = this.viewport.bounds();
        if (!rectangle.inside(n, n2)) {
            return false;
        }
        n -= rectangle.x;
        int n3 = this.hmargin;
        int n4 = 0;
        while (n4 < this.numColumns) {
            if (!this.isPinned(n4) && n4 >= this.firstcol) {
                if (n > (n3 += this.colInfo[n4].width) && n < n3 + this.hmargin) {
                    this.resizeColumn = n4;
                    this.startx = n3 - this.colInfo[n4].width;
                    this.endx = n3 + this.hmargin / 2;
                    return true;
                }
                n3 += this.hmargin;
            }
            ++n4;
        }
        return false;
    }

    public String getClassVersion() {
        return sccs_id;
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",numRows=" + this.numRows + ",numColumns=" + this.numColumns;
    }
}

