/*
 * Decompiled with CFR 0.152.
 */
package COM.Sun.sunsoft.sims.admin.console;

import COM.Sun.sunsoft.ldaps.sims.client.LDAClientUtil;
import COM.Sun.sunsoft.ldaps.sims.client.LDADirectoryApplet;
import COM.Sun.sunsoft.ldaps.sims.client.Login;
import COM.Sun.sunsoft.ldaps.sims.common.LDADebug;
import COM.Sun.sunsoft.sims.admin.AdminComponent;
import COM.Sun.sunsoft.sims.admin.AdminException;
import COM.Sun.sunsoft.sims.admin.AdminServer;
import COM.Sun.sunsoft.sims.admin.BadLoginException;
import COM.Sun.sunsoft.sims.admin.Console;
import COM.Sun.sunsoft.sims.admin.ConsoleSession;
import COM.Sun.sunsoft.sims.admin.PluggableSection;
import COM.Sun.sunsoft.sims.admin.SessionKey;
import COM.Sun.sunsoft.sims.admin.SessionKeyCreateException;
import COM.Sun.sunsoft.sims.admin.console.LDAAppliLoginSubWin;
import COM.Sun.sunsoft.sims.admin.console.LDAFrame;
import COM.Sun.sunsoft.sims.avm.base.Context;
import COM.Sun.sunsoft.sims.avm.base.InformationDialog;
import COM.Sun.sunsoft.sims.avm.base.InsetPanel;
import COM.Sun.sunsoft.sims.avm.base.MESSAGE_TYPE;
import COM.Sun.sunsoft.sims.avm.base.Util;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class SDSAdmin
extends Applet
implements Console,
Runnable {
    private static final String sccsid = "@(#)SDSAdmin.java\t1.35 08/10/98";
    private static SDSAdmin consoleInstance;
    private Hashtable compobjs;
    private Hashtable compprop;
    private Hashtable ref2prop;
    private Hashtable pluggablesect;
    private Locale defaultlocale;
    private AdminServer admserver;
    private ConsoleSession session;
    private Properties consoleprop;
    private String userid;
    private String passwd;
    private SessionKey sessionkey;
    private boolean started;
    private boolean runstate;
    private boolean done;
    private boolean debug;
    private TextField namefield;
    private TextField passwdfield;
    private Button loginButton;
    private Button logoutButton;
    private boolean application;
    public String applihost;
    private String appliport;
    private Frame appliFrame;
    static String portValue;
    public ResourceBundle res;
    private Locale locale;

    public SDSAdmin() {
        this.defaultlocale = Locale.getDefault();
        this.started = false;
        this.runstate = true;
        this.done = false;
        this.debug = false;
        this.application = false;
        this.locale = Locale.getDefault();
        try {
            this.sessionkey = new SessionKey();
        }
        catch (SessionKeyCreateException sessionKeyCreateException) {}
        this.setLayout(new BorderLayout());
        try {
            this.res = ResourceBundle.getBundle("COM.Sun.sunsoft.sims.admin.console.SDSAdminResourceBundle", this.locale);
            return;
        }
        catch (Exception exception) {
            this.res = ResourceBundle.getBundle("COM.Sun.sunsoft.sims.admin.console.SDSAdminResourceBundle", Locale.US);
            return;
        }
    }

    public void setFrame(Frame frame) {
        this.appliFrame = frame;
    }

    public SDSAdmin(boolean bl) {
        block8: {
            this();
            this.application = bl;
            if (this.application) {
                String string;
                String string2;
                String string3 = this.getParameter("sunds.debug");
                if (string3 != null && string3.equals("true")) {
                    this.debug = true;
                }
                if ((string2 = this.getParameter("sunds.host")) != null) {
                    if (this.debug) {
                        System.out.println("Host is " + string2);
                    }
                    this.applihost = string2;
                }
                if ((string = this.getParameter("sunds.port")) != null) {
                    try {
                        if (this.debug) {
                            System.out.println("Port is " + string);
                        }
                        Integer.parseInt(string);
                        this.appliport = string;
                        return;
                    }
                    catch (Exception exception) {
                        if (!this.debug) break block8;
                        System.out.println("Invalid port number.");
                        return;
                    }
                }
            }
        }
    }

    public String getParameter(String string) {
        try {
            this.sessionkey = new SessionKey();
        }
        catch (SessionKeyCreateException sessionKeyCreateException) {}
        if (this.application) {
            return System.getProperty(string);
        }
        String string2 = null;
        Locale locale = Locale.getDefault();
        String string3 = locale.toString();
        string2 = super.getParameter(String.valueOf(string3) + "-" + string);
        if (string2 == null) {
            string3 = String.valueOf(locale.getLanguage()) + "_" + locale.getCountry();
            string2 = super.getParameter(String.valueOf(string3) + "-" + string);
        }
        if (string2 == null) {
            string3 = locale.getLanguage();
            string2 = super.getParameter(String.valueOf(string3) + "-" + string);
        }
        return string2;
    }

    private void ErrorDialog(String string) {
        if (this.application) {
            this.showStatus(string, true);
            return;
        }
        Frame frame = new Frame();
        InformationDialog informationDialog = new InformationDialog(frame, string, this.res.getString("error"));
        informationDialog.setType(MESSAGE_TYPE.ERROR);
        informationDialog.validate();
        informationDialog.pack();
        informationDialog.show();
    }

    public URL getDocumentBase() {
        if (this.application) {
            return this.getCodeBase();
        }
        return super.getDocumentBase();
    }

    public URL getCodeBase() {
        if (this.application) {
            String string = System.getProperty("basedir");
            if (string == null) {
                string = "/opt";
            }
            URL uRL = null;
            try {
                uRL = new URL("file:" + string + "/SUNWconn/ldap/html/lib/");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return uRL;
        }
        return super.getCodeBase();
    }

    private int connectAdminServer() {
        int n = 0;
        if (this.admserver != null) {
            this.disconnectConsoleSession();
        }
        URL uRL = null;
        try {
            String string = "localhost";
            if (this.application && this.applihost != null) {
                string = this.applihost;
            } else {
                string = this.getCodeBase().getHost();
                if (string == null) {
                    string = "localhost";
                }
            }
            if (this.application && this.appliport != null) {
                portValue = this.appliport;
            } else if (!this.application || this.applihost == null) {
                try {
                    uRL = new URL(this.getCodeBase(), "sunds_port.html");
                    InputStream inputStream = (InputStream)uRL.getContent();
                    byte[] byArray = new byte[100];
                    inputStream.read(byArray, 0, 100);
                    String string2 = new String(byArray, 0);
                    portValue = new StringTokenizer(string2).nextToken();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.debug) {
                if (!this.application) {
                    System.out.println("Getting registry port from " + uRL.toString());
                }
                System.out.println("Registry port is " + portValue);
            }
            this.admserver = (AdminServer)Naming.lookup("//" + string + ":" + portValue + "/" + "SimsAdminServer");
            Context.setProperty((Object)"LDAP_ADMSERVER", (Object)this.admserver);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
                System.out.println("Failed to lookup the SDS administrative server");
                if (!this.application) {
                    System.out.println("Getting registry port from " + uRL.toString());
                }
                System.out.println("Registry port is " + portValue);
            }
            n = -1;
        }
        return n;
    }

    public void showStatus(String string) {
        this.showStatus(string, false);
    }

    public void showStatus(String string, boolean bl) {
        if (this.application) {
            if (bl) {
                InformationDialog informationDialog = new InformationDialog(this.appliFrame, string, this.res.getString("error"), false);
                informationDialog.setType(MESSAGE_TYPE.ERROR);
                informationDialog.validate();
                informationDialog.pack();
                LDAClientUtil.positionDialog((Component)this.appliFrame, (Component)informationDialog);
                informationDialog.setVisible(true);
            }
            if (this.debug) {
                System.out.println("showStatus():" + string);
                return;
            }
        } else {
            super.showStatus(string);
        }
    }

    private ConsoleSession getAuthenticatedSession() {
        this.session = null;
        try {
            this.session = this.admserver.simsLogin(this.sessionkey, this.userid, this.passwd);
            Context.setProperty((Object)"LDAP_CONSOLESESSION", (Object)this.session);
            this.showStatus(this.res.getString("auth_ok"));
            if (this.debug) {
                System.out.println("Authentication is successful");
            }
        }
        catch (BadLoginException badLoginException) {
            if (this.debug) {
                System.out.println("Bad Login Exception" + badLoginException.getMessage());
            }
            this.ErrorDialog(badLoginException.getMessage());
            return null;
        }
        catch (RemoteException remoteException) {
            if (this.debug) {
                System.out.println("Lost connection to the SDS Admin Server" + remoteException.getMessage());
            }
            return null;
        }
        catch (AdminException adminException) {
            if (this.debug) {
                System.out.println("AdminException caught in getAuthenticatedSession(): " + adminException.getMessage());
            }
            this.ErrorDialog(adminException.getMessage());
        }
        if (this.debug) {
            System.out.println("Returning from Login Dialog...");
        }
        return this.session;
    }

    private void disconnectConsoleSession() {
        try {
            this.admserver.simsLogout(this.session);
        }
        catch (RemoteException remoteException) {}
        try {
            Enumeration<?> enumeration = this.consoleprop.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Context.setProperty((Object)string, (Object)"_no_property");
            }
        }
        catch (Exception exception) {}
        Context.setProperty((Object)"console.url", (Object)"_no_property");
        Context.setProperty((Object)"console.codebase", (Object)"_no_property");
        Context.setProperty((Object)"console.root", (Object)"_no_property");
        Context.setProperty((Object)"_console", (Object)"_no_property");
        this.userid = null;
        this.passwd = null;
        try {
            ((TextComponent)this.namefield).setText("");
            ((TextComponent)this.passwdfield).setText("");
        }
        catch (Exception exception) {}
        this.session = null;
        this.admserver = null;
        this.compobjs = null;
        this.compprop = null;
        this.consoleprop = null;
        this.started = false;
    }

    private boolean isStarted() {
        return this.started;
    }

    private void setStartFlag() {
        this.started = true;
    }

    public void init() {
        super.init();
        consoleInstance = this;
        String string = super.getParameter("debug");
        if (string != null && string.equals("true")) {
            this.debug = true;
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        InsetPanel insetPanel = new InsetPanel();
        insetPanel.setLayout(new GridLayout(3, 2));
        Label label = Util.Label((String)this.res.getString("namelabel"));
        Label label2 = Util.Label((String)this.res.getString("passwdlabel"));
        Label label3 = Util.Label((String)this.res.getString("serverlabel"));
        String string2 = "localhost";
        try {
            string2 = this.getDocumentBase().getHost();
            if (string2.trim().equals("")) {
                string2 = "localhost";
                string2 = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.namefield = new TextField();
        this.namefield.setEditable(true);
        this.passwdfield = new TextField();
        this.passwdfield.setEditable(true);
        this.passwdfield.setEchoCharacter('*');
        insetPanel.add("ServerLabel", label3);
        insetPanel.add("ServerField", Util.Label((String)string2));
        insetPanel.add("NameLabel", label);
        insetPanel.add("NameField", this.namefield);
        insetPanel.add("PasswdLabel", label2);
        insetPanel.add("PasswdField", this.passwdfield);
        panel.add("Center", (Component)insetPanel);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        this.loginButton = new Button(this.res.getString("loginbutton"));
        this.loginButton.setEnabled(!this.isStarted());
        this.logoutButton = new Button(this.res.getString("logoutbutton"));
        this.logoutButton.setEnabled(this.isStarted());
        panel2.add(this.loginButton);
        panel2.add(this.logoutButton);
        this.add("Center", panel);
        this.add("South", panel2);
        if (this.debug) {
            System.out.println("Add domain panel");
        }
    }

    public void start() {
        LDADebug.debug((Object)"SDSAdmin start");
        String string = (String)Context.getProperty((Object)"LDAP_GOHOME");
        if (string != null && string.equals("yes")) {
            this.started = true;
            this.admserver = (AdminServer)Context.getProperty((Object)"LDAP_ADMSERVER");
            this.session = (ConsoleSession)Context.getProperty((Object)"LDAP_CONSOLESESSION");
        }
        if (!this.isStarted()) {
            this.loginButton.setEnabled(true);
            this.logoutButton.setEnabled(false);
            this.resize(576, 600);
            this.namefield.requestFocus();
        } else {
            this.loginButton.setEnabled(false);
            this.logoutButton.setEnabled(true);
            if (!this.application) {
                try {
                    Login login = (Login)Context.getProperty((Object)"LDAP_LOGIN");
                    LDADirectoryApplet lDADirectoryApplet = (LDADirectoryApplet)Context.getProperty((Object)"LDAP_TOP_APPLET");
                    LDADebug.debug((Object)"get applet");
                    if (lDADirectoryApplet != null && !lDADirectoryApplet.equals("_no_property")) {
                        LDADebug.debug((Object)"applet OK");
                        if (lDADirectoryApplet.isModified()) {
                            this.show();
                            LDADebug.debug((Object)"applet modified");
                            LDAClientUtil.displayWarningMessage((Login)login, (Frame)Util.findFrame((Component)this), (Component)this, (String)login.cat.gets("SDS Configuration Warning"), (String)login.cat.gets("Some modifications have not been saved.\nPlease go back to the previous applet and apply the changes or log out."));
                        }
                    }
                }
                catch (Exception exception) {
                    LDADebug.printStackTrace((Exception)exception);
                }
            }
        }
        if (!this.application) {
            this.show();
        }
        this.namefield.requestFocus();
        Context.removeProperty((Object)"LDAP_GOHOME");
    }

    public void stop() {
    }

    public void destroy() {
        this.disconnectConsoleSession();
    }

    public int Authenticate(String string, String string2) {
        this.userid = string;
        this.passwd = string2;
        return this.Authenticate();
    }

    private int Authenticate() {
        block16: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.debug) {
                System.out.println("Connecting admin server...");
            }
            if (this.connectAdminServer() != 0) {
                this.showStatus(this.res.getString("err_conn"), true);
                if (this.debug) {
                    System.out.println("Cannot Connect admin server...");
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.stop();
                return 0;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.session = this.getAuthenticatedSession();
            if (this.session == null) {
                this.showStatus(this.res.getString("auth_nok"), true);
                this.admserver = null;
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.stop();
                return 0;
            }
            if (this.debug) {
                System.out.println("Authentication is successful");
            }
            try {
                this.session.setSessionLocale(this.locale);
            }
            catch (RemoteException remoteException) {
                if (!this.debug) break block16;
                System.out.println(remoteException.getMessage());
            }
        }
        this.consoleprop = this.getConsoleProperties();
        if (this.consoleprop == null) {
            this.done = true;
            return 0;
        }
        if (this.loadAdminComponents() != 0) {
            this.done = true;
            return 0;
        }
        if (this.debug) {
            System.out.println("Get directory admin comp");
        }
        AdminComponent[] adminComponentArray = this.getAdminComponents("LDAP_DIRECTORY");
        Properties properties = (Properties)this.ref2prop.get(adminComponentArray[0]);
        if (!this.application) {
            URL uRL = (URL)Context.getProperty((Object)"console.url");
            String string = uRL.toExternalForm();
            int n = string.lastIndexOf("/");
            String string2 = null;
            try {
                string2 = string.substring(0, n + 1);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                string2 = "";
            }
            string2 = String.valueOf(string2) + properties.getProperty("AppletURL");
            try {
                Util.showPage((String)string2, (Component)this);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("Can't load Directory Applet <" + string2 + ">");
                }
                return 0;
            }
        }
        return 1;
    }

    public void run() {
    }

    protected Properties getConsoleProperties() {
        Properties properties = null;
        try {
            properties = this.session.getConsoleProperties();
        }
        catch (RemoteException remoteException) {
            if (this.debug) {
                System.out.println(remoteException.getMessage());
                System.out.println("Failed retrieving console properties");
            }
            return null;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Context.setProperty((Object)string, (Object)properties.getProperty(string));
            if (!this.debug) continue;
            System.out.println(String.valueOf(string) + "=" + properties.getProperty(string));
        }
        Context.setProperty((Object)"console.url", (Object)this.getDocumentBase());
        Context.setProperty((Object)"console.codebase", (Object)this.getCodeBase());
        Context.setProperty((Object)"_console", (Object)this);
        if (!this.application && this.getDocumentBase().getProtocol().equals("http")) {
            Context.setProperty((Object)"console.root", (Object)"root");
        }
        return properties;
    }

    protected int loadAdminComponents() {
        int n = 0;
        try {
            this.compobjs = this.session.getComponentReferences();
            this.compprop = this.session.getComponentProperties();
            this.ref2prop = new Hashtable();
            Enumeration enumeration = this.compobjs.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                AdminComponent adminComponent = (AdminComponent)this.compobjs.get(string);
                Properties properties = (Properties)this.compprop.get(string);
                try {
                    if (adminComponent == null || properties == null) continue;
                    this.ref2prop.put(adminComponent, properties);
                }
                catch (NullPointerException nullPointerException) {
                    if (!this.debug) continue;
                    System.out.println("Cannot match " + string + " properties");
                    System.out.println(((Throwable)nullPointerException).getMessage());
                }
            }
        }
        catch (RemoteException remoteException) {
            if (this.debug) {
                System.out.println("Failed to load admin components");
                System.out.println(remoteException.getMessage());
            }
            n = -1;
        }
        return n;
    }

    public void startAllServices() {
    }

    public void stopAllServices() {
    }

    public AdminComponent getAdminComponent(String string) {
        return (AdminComponent)this.compobjs.get(string);
    }

    public AdminComponent[] getAdminComponents(String string) {
        Object object;
        Vector<AdminComponent> vector = new Vector<AdminComponent>();
        Enumeration enumeration = this.compobjs.keys();
        while (enumeration.hasMoreElements()) {
            AdminComponent adminComponent;
            Properties properties;
            object = (String)enumeration.nextElement();
            Object v = this.compobjs.get(object);
            if (v == null || (properties = (Properties)this.ref2prop.get(adminComponent = (AdminComponent)v)) == null || !string.equals(properties.getProperty("Type"))) continue;
            vector.addElement(adminComponent);
        }
        object = new AdminComponent[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Properties getAdminComponentProperties(AdminComponent adminComponent) {
        if (adminComponent == null) {
            return null;
        }
        return (Properties)this.ref2prop.get(adminComponent);
    }

    public PluggableSection[] getPluggableSections(String string) {
        Object[] objectArray;
        block14: {
            Vector vector = null;
            objectArray = null;
            if (this.pluggablesect == null) {
                this.pluggablesect = new Hashtable();
            } else if (this.pluggablesect.contains(string)) {
                vector = (Vector)this.pluggablesect.get(string);
                objectArray = new PluggableSection[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            vector = new Vector();
            Enumeration enumeration = this.compobjs.elements();
            while (enumeration.hasMoreElements()) {
                AdminComponent adminComponent = (AdminComponent)enumeration.nextElement();
                String[] stringArray = null;
                try {
                    stringArray = adminComponent.getPluggableSectionNames();
                    if (stringArray == null) continue;
                    int n = 0;
                    while (n < stringArray.length) {
                        block13: {
                            Class<?> clazz = null;
                            PluggableSection pluggableSection = null;
                            try {
                                clazz = Class.forName(stringArray[n]);
                                pluggableSection = (PluggableSection)clazz.newInstance();
                            }
                            catch (Exception exception) {
                                if (this.debug) {
                                    System.out.println(String.valueOf(stringArray[n]) + " class not found");
                                }
                                break block13;
                            }
                            if (pluggableSection.isSupported(string)) {
                                vector.addElement(pluggableSection);
                            }
                        }
                        ++n;
                    }
                }
                catch (RemoteException remoteException) {}
            }
            objectArray = new PluggableSection[vector.size()];
            vector.copyInto(objectArray);
            try {
                this.pluggablesect.put(string, vector);
            }
            catch (NullPointerException nullPointerException) {
                if (!this.debug) break block14;
                System.out.println("Cannot add pluggable sections");
            }
        }
        return objectArray;
    }

    public Locale getSessionLocale() {
        return this.defaultlocale;
    }

    public ConsoleSession getConsoleSession() {
        return this.session;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public boolean keyDown(Event event, int n) {
        if (n == 10 && !this.isStarted()) {
            this.userid = this.namefield.getText();
            this.passwd = this.passwdfield.getText();
            if (this.userid != null && this.passwd != null) {
                if (this.Authenticate() == 0) {
                    if (this.debug) {
                        System.out.println("Authentication Failed");
                    }
                } else {
                    this.loginButton.setEnabled(false);
                    this.logoutButton.setEnabled(true);
                    this.setStartFlag();
                }
                return true;
            }
        }
        return false;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.loginButton) {
            if (!this.isStarted()) {
                this.userid = this.namefield.getText();
                if (this.userid == null && this.debug) {
                    System.out.println("Invalid user ID");
                }
                this.passwd = this.passwdfield.getText();
                if (this.passwd == null && this.debug) {
                    System.out.println("Invalid Passwd");
                }
                if (this.Authenticate() == 0) {
                    if (this.debug) {
                        System.out.println("Authentication Failed");
                    }
                } else {
                    this.loginButton.setEnabled(false);
                    this.logoutButton.setEnabled(true);
                    this.setStartFlag();
                }
            }
            return true;
        }
        if (event.target == this.logoutButton) {
            if (this.isStarted()) {
                this.disconnectConsoleSession();
                this.loginButton.setEnabled(true);
                this.logoutButton.setEnabled(false);
                this.namefield.requestFocus();
                Context.setProperty((Object)"LDAP_LOGIN", (Object)"_no_property");
            }
            return true;
        }
        return false;
    }

    public String getClassVersion() {
        return sccsid;
    }

    public static void main(String[] stringArray) {
        SDSAdmin sDSAdmin = new SDSAdmin(true);
        LDAFrame lDAFrame = new LDAFrame();
        lDAFrame.setResizable(true);
        lDAFrame.setLayout(new BorderLayout());
        lDAFrame.setTitle(sDSAdmin.res.getString("consoletitle"));
        sDSAdmin.setFrame((Frame)lDAFrame);
        LDADirectoryApplet lDADirectoryApplet = new LDADirectoryApplet(true);
        lDAFrame.add((Component)lDADirectoryApplet);
        lDAFrame.pack();
        lDAFrame.resize(600, 600);
        lDAFrame.setVisible(true);
        new LDAAppliLoginSubWin((Frame)lDAFrame, sDSAdmin.res, sDSAdmin, lDADirectoryApplet);
    }

    static {
        portValue = String.valueOf(1099);
    }
}

