/*
 * Decompiled with CFR 0.152.
 */
package COM.Sun.sunsoft.ldaps.sims.server;

import COM.Sun.sunsoft.ldaps.sims.common.Access;
import COM.Sun.sunsoft.ldaps.sims.common.Acl;
import COM.Sun.sunsoft.ldaps.sims.common.AclBy;
import COM.Sun.sunsoft.ldaps.sims.common.AclWhat;
import COM.Sun.sunsoft.ldaps.sims.common.Attr;
import COM.Sun.sunsoft.ldaps.sims.common.AttrItem;
import COM.Sun.sunsoft.ldaps.sims.common.BackEnd;
import COM.Sun.sunsoft.ldaps.sims.common.BackEndHeader;
import COM.Sun.sunsoft.ldaps.sims.common.ClassItem;
import COM.Sun.sunsoft.ldaps.sims.common.InvalidDNException;
import COM.Sun.sunsoft.ldaps.sims.common.LDACatalog;
import COM.Sun.sunsoft.ldaps.sims.common.LDADebug;
import COM.Sun.sunsoft.ldaps.sims.common.LDADnChecker;
import COM.Sun.sunsoft.ldaps.sims.common.LDAExtendedInitialConfig;
import COM.Sun.sunsoft.ldaps.sims.common.LDAFrontend;
import COM.Sun.sunsoft.ldaps.sims.common.LDAIndexItem;
import COM.Sun.sunsoft.ldaps.sims.common.LDAInitialConfig;
import COM.Sun.sunsoft.ldaps.sims.common.LDAOid;
import COM.Sun.sunsoft.ldaps.sims.common.LDAPServiceConf;
import COM.Sun.sunsoft.ldaps.sims.common.LDAReplicaItem;
import COM.Sun.sunsoft.ldaps.sims.common.LDAReplicaList;
import COM.Sun.sunsoft.ldaps.sims.common.LDASchedule;
import COM.Sun.sunsoft.ldaps.sims.common.LDASubtreeItem;
import COM.Sun.sunsoft.ldaps.sims.common.LDASubtreeList;
import COM.Sun.sunsoft.ldaps.sims.common.LdapConf;
import COM.Sun.sunsoft.ldaps.sims.common.LdapConfigException;
import COM.Sun.sunsoft.ldaps.sims.common.LdapConfigInteger;
import COM.Sun.sunsoft.ldaps.sims.common.LdapInteger;
import COM.Sun.sunsoft.ldaps.sims.common.LdapRefreshIndexWarningException;
import COM.Sun.sunsoft.ldaps.sims.common.LdapSaveErrorException;
import COM.Sun.sunsoft.ldaps.sims.common.LdapWarningException;
import COM.Sun.sunsoft.ldaps.sims.common.LdbmBackend;
import COM.Sun.sunsoft.ldaps.sims.common.MainConf;
import COM.Sun.sunsoft.ldaps.sims.common.NisServiceConf;
import COM.Sun.sunsoft.ldaps.sims.common.Objcl;
import COM.Sun.sunsoft.ldaps.sims.common.RadiusServiceConf;
import COM.Sun.sunsoft.ldaps.sims.common.ReplHost;
import COM.Sun.sunsoft.ldaps.sims.common.SecurityServiceConf;
import COM.Sun.sunsoft.ldaps.sims.common.WebServiceConf;
import COM.Sun.sunsoft.ldaps.sims.server.LDACommandManager;
import COM.Sun.sunsoft.ldaps.sims.server.LDAConstants;
import COM.Sun.sunsoft.ldaps.sims.server.LDADirectoryServer;
import COM.Sun.sunsoft.ldaps.sims.server.LDASession;
import COM.Sun.sunsoft.ldaps.sims.server.MapParser;
import COM.Sun.sunsoft.sims.admin.Scheduler;
import COM.Sun.sunsoft.sims.admin.Task;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public class LDAParser {
    private static final String copyrights = "Copyright 03/30/98 Sun Microsystems, Inc. All Rights Reserved";
    private LDACatalog cat;
    private Writer logstream;
    private LdapConf globalConf;
    private Properties server_properties;
    private Task dspushd_task;
    private Task dspulld_task;
    private boolean errorWhileLoadingConf = false;
    private LDADirectoryServer server;
    private StringBuffer currentComments;
    private boolean sslClientVerificationToken = false;

    public LDAParser(LDADirectoryServer lDADirectoryServer, LDACatalog lDACatalog) {
        this.cat = lDACatalog;
        this.globalConf = new LdapConf();
        this.globalConf.security_service = new SecurityServiceConf();
        this.globalConf.ldap_service = new LDAPServiceConf();
        this.globalConf.web_service = new WebServiceConf();
        this.globalConf.nis_service = new NisServiceConf();
        this.server = lDADirectoryServer;
    }

    public void setLogStream(Writer writer) {
        this.logstream = writer;
    }

    public static void updateLdapSyncConf(LDAInitialConfig lDAInitialConfig, String string, String string2, String string3, String string4, String string5) throws IOException {
        if (!(lDAInitialConfig instanceof LDAExtendedInitialConfig)) {
            throw new IOException("Invalid input. Reuse the instance returned by getInitialConfig()");
        }
        File file = new File("/tmp/ldapsync.tmp");
        File file2 = string == null ? new File("/etc/opt/SUNWconn/ldap/current", "ldapsync.conf") : new File(string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        String string6 = "";
        String string7 = (String)lDAInitialConfig.getDataStoreSuffixes().firstElement();
        while ((string6 = bufferedReader.readLine()) != null) {
            String string8;
            if (string6.startsWith("#")) {
                dataOutputStream.writeBytes(String.valueOf(string6) + "\n");
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string6);
            if (!stringTokenizer.hasMoreTokens()) {
                dataOutputStream.writeBytes(String.valueOf(string6) + "\n");
                continue;
            }
            String string9 = stringTokenizer.nextToken();
            if (string9.equalsIgnoreCase("base")) {
                string8 = String.valueOf(string2) + "," + string7;
                string6 = "base = \"" + LDAParser.add_backslash((String)string8) + "\"";
            } else if (string9.equalsIgnoreCase("group-base")) {
                string8 = String.valueOf(string3) + "," + string7;
                string6 = "group-base = \"" + LDAParser.add_backslash((String)string8) + "\"";
            } else if (string9.equalsIgnoreCase("bind-DN")) {
                string6 = "bind-DN = \"" + ((LDAExtendedInitialConfig)lDAInitialConfig).getFullAdminName() + "\"";
            } else if (string9.equalsIgnoreCase("ldap-password") || string9.equalsIgnoreCase("ldap-passwd")) {
                string6 = "ldap-passwd = \"" + lDAInitialConfig.getAdminPassword() + "\"";
            } else if (string9.equalsIgnoreCase("mail-domain")) {
                string6 = "mail-domain = \"" + string4 + "\"";
            } else if (string9.equalsIgnoreCase("super-domain")) {
                string6 = "super-domain = \"" + string5 + "\"";
            }
            if (string6.equals("")) continue;
            dataOutputStream.writeBytes(String.valueOf(string6) + "\n");
        }
        bufferedReader.close();
        dataOutputStream.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
        while ((string6 = bufferedReader.readLine()) != null) {
            dataOutputStream.writeBytes(String.valueOf(string6) + "\n");
        }
        dataOutputStream.close();
        bufferedReader.close();
    }

    public static void setInitialConfig(LDAInitialConfig lDAInitialConfig) throws IOException {
        String string;
        if (!(lDAInitialConfig instanceof LDAExtendedInitialConfig)) {
            throw new IOException("Invalid input. Reuse the instance returned by getInitialConfig()");
        }
        LDAExtendedInitialConfig lDAExtendedInitialConfig = (LDAExtendedInitialConfig)lDAInitialConfig;
        File file = new File("/tmp/ldainit.tmp");
        File file2 = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.conf");
        Vector vector = lDAExtendedInitialConfig.getDataStoreSuffixes();
        Vector vector2 = lDAExtendedInitialConfig.getUpdateLog();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        String string2 = "cn=" + lDAExtendedInitialConfig.getAdminName() + "," + LDAParser.add_backslash((String)((String)vector.firstElement()));
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        while ((string = bufferedReader.readLine()) != null) {
            String string3;
            int n2;
            if (string.startsWith("#")) {
                dataOutputStream.writeBytes(String.valueOf(string) + "\n");
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                dataOutputStream.writeBytes(String.valueOf(string) + "\n");
                continue;
            }
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("suffix")) {
                try {
                    string = "suffix \"" + LDAParser.add_backslash((String)((String)vector.elementAt(n))) + "\"";
                }
                catch (Exception exception) {
                    string = "";
                }
                ++n;
                bl = true;
            } else if (bl) {
                n2 = n;
                while (n2 < vector.size()) {
                    dataOutputStream.writeBytes("suffix      \"" + LDAParser.add_backslash((String)((String)vector.elementAt(n2))) + "\"" + "\n");
                    ++n2;
                }
                bl = false;
            }
            if (string4.equals("master")) {
                string = "";
                if (!bl2) {
                    try {
                        dataOutputStream.writeBytes("master\n");
                        n2 = 0;
                        while (n2 < vector.size()) {
                            dataOutputStream.writeBytes("   subtree=\"" + LDAParser.add_backslash((String)((String)vector.elementAt(n2))) + "\"" + "\n");
                            ++n2;
                        }
                    }
                    catch (Exception exception) {}
                    bl2 = true;
                }
            } else if (string4.equals("object=") || string4.equals("subtree=")) {
                string = "";
            } else if (string4.startsWith("object=") || string4.startsWith("subtree=")) {
                string = "";
            } else if (string4.equals("updatelog")) {
                string = "";
            } else if (string4.equals("timelimit")) {
                n2 = 0;
                while (n2 < vector2.size()) {
                    dataOutputStream.writeBytes("updatelog     " + (String)vector2.elementAt(n2) + "\n");
                    ++n2;
                }
            } else if (string4.equals("rootdn")) {
                string = "rootdn \"" + string2 + "\"";
            } else if (string4.equals("rootpw")) {
                String string5 = lDAExtendedInitialConfig.getStringCryptedMode();
                string3 = lDAExtendedInitialConfig.getAdminPassword();
                string = string3.startsWith(string5) ? String.valueOf(string4) + " " + string3 : String.valueOf(string4) + " " + LDACommandManager.crypt((String)(String.valueOf(string5) + lDAExtendedInitialConfig.getAdminPassword()));
            } else if (string.trim().startsWith("by") && (n2 = string.indexOf(lDAExtendedInitialConfig.getFullAdminName())) >= 0) {
                string3 = new String("");
                string = string3 = String.valueOf(string.substring(0, n2)) + string2 + string.substring(n2 + lDAExtendedInitialConfig.getFullAdminName().length());
            }
            if (string.equals("")) continue;
            dataOutputStream.writeBytes(String.valueOf(string) + "\n");
        }
        bufferedReader.close();
        dataOutputStream.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
        while ((string = bufferedReader.readLine()) != null) {
            dataOutputStream.writeBytes(String.valueOf(string) + "\n");
        }
        dataOutputStream.close();
        bufferedReader.close();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("/etc/opt/SUNWconn/ldap/current/dsserv.ini"));
            ((Hashtable)properties).put("WebGwRoot", "\"" + (String)vector.firstElement() + "\"");
            properties.save(new DataOutputStream(new FileOutputStream("/etc/opt/SUNWconn/ldap/current/dsserv.ini")), "#\n#Copyright 06/24/98 Sun Microsystems, Inc. All Rights Reserved");
            return;
        }
        catch (Exception exception) {
            LDADebug.debug((Object)"Can't load /etc/opt/SUNWconn/ldap/current/dsserv.ini");
            return;
        }
    }

    public static void setUpdateLogs(Vector vector) throws IOException {
        String string;
        File file = new File("/tmp/ldainit.tmp");
        File file2 = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.conf");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#")) {
                dataOutputStream.writeBytes(String.valueOf(string) + "\n");
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                dataOutputStream.writeBytes(String.valueOf(string) + "\n");
                continue;
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("updatelog")) {
                string = "";
            } else if (string2.equals("timelimit")) {
                int n = 0;
                while (n < vector.size()) {
                    dataOutputStream.writeBytes("updatelog     " + (String)vector.elementAt(n) + "\n");
                    ++n;
                }
            }
            if (string.equals("")) continue;
            dataOutputStream.writeBytes(String.valueOf(string) + "\n");
        }
        bufferedReader.close();
        dataOutputStream.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
        while ((string = bufferedReader.readLine()) != null) {
            dataOutputStream.writeBytes(String.valueOf(string) + "\n");
        }
        dataOutputStream.close();
        bufferedReader.close();
    }

    public static String getAdministratorPassword() throws RemoteException, IOException {
        String string;
        File file = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.conf");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        new LDAExtendedInitialConfig();
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            StringTokenizer stringTokenizer;
            if (string.startsWith("#") || !(stringTokenizer = new StringTokenizer(string)).hasMoreTokens() || !(string2 = stringTokenizer.nextToken()).equals("rootpw")) continue;
            bufferedReader.close();
            return stringTokenizer.nextToken();
        }
        bufferedReader.close();
        return null;
    }

    public static String getAdministratorDn() throws RemoteException, IOException {
        String string;
        File file = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.conf");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        new LDAExtendedInitialConfig();
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            StringTokenizer stringTokenizer;
            if (string.startsWith("#") || !(stringTokenizer = new StringTokenizer(string)).hasMoreTokens() || !(string2 = stringTokenizer.nextToken()).equals("rootdn")) continue;
            String string3 = LDAParser.extract_dn((String)string, (LdapConfigInteger)new LdapConfigInteger(0));
            string3 = LDAParser.remove_backslash((String)string3);
            bufferedReader.close();
            return string3;
        }
        bufferedReader.close();
        return null;
    }

    public static LDAExtendedInitialConfig getInitialConfig() throws IOException {
        String string;
        File file = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.conf");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        LDAExtendedInitialConfig lDAExtendedInitialConfig = new LDAExtendedInitialConfig();
        int n = 0;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            StringTokenizer stringTokenizer;
            if (string.startsWith("#") || !(stringTokenizer = new StringTokenizer(string)).hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("rootpw")) {
                lDAExtendedInitialConfig.setAdminPassword(stringTokenizer.nextToken());
                ++n;
            } else if (string2.equals("suffix")) {
                object = LDAParser.extract_dn((String)string, (LdapConfigInteger)new LdapConfigInteger(0));
                if (((String)object).startsWith("\"")) {
                    object = ((String)object).substring(1);
                }
                if (((String)object).endsWith("\"")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                vector.addElement(new String(LDAParser.remove_backslash((String)object)));
                if (!bl) {
                    ++n;
                }
                bl = true;
            } else if (string2.equals("updatelog")) {
                object = lDAExtendedInitialConfig.getUpdateLog();
                ((Vector)object).addElement(stringTokenizer.nextToken());
                lDAExtendedInitialConfig.setUpdateLog((Vector)object);
            } else if (string2.equals("rootdn")) {
                object = LDAParser.extract_dn((String)string, (LdapConfigInteger)new LdapConfigInteger(0));
                object = LDAParser.remove_backslash((String)object);
                lDAExtendedInitialConfig.setFullAdminName((String)object);
                try {
                    object = LDADnChecker.getRDNAt((String)object, (int)0);
                }
                catch (InvalidDNException invalidDNException) {
                    LDADebug.debug((Object)"LDAParser:Invalid administrator DN");
                    object = null;
                }
                catch (NullPointerException nullPointerException) {
                    LDADebug.debug((Object)"LDAParser:Invalid administrator DN");
                    object = null;
                }
                if (object == null) {
                    object = "<unknown>";
                } else {
                    object = ((String)object).substring(((String)object).indexOf("=") + 1);
                    object = ((String)object).trim();
                }
                lDAExtendedInitialConfig.setAdminName((String)object);
                ++n;
            }
            if (n != 3) continue;
            bufferedReader.close();
            try {
                lDAExtendedInitialConfig.setDataStoreSuffixes(vector);
            }
            catch (InvalidDNException invalidDNException) {
                LDADebug.printStackTrace((Exception)((Object)invalidDNException));
            }
            return lDAExtendedInitialConfig;
        }
        try {
            lDAExtendedInitialConfig.setDataStoreSuffixes(vector);
        }
        catch (InvalidDNException invalidDNException) {
            LDADebug.printStackTrace((Exception)((Object)invalidDNException));
        }
        LDADebug.debug((Object)"LDAParser:getDefaultConfig: Missing tokens");
        bufferedReader.close();
        return lDAExtendedInitialConfig;
    }

    public LDASchedule loadSchedule(Scheduler scheduler, String string) {
        try {
            String string2;
            Task[] taskArray = scheduler.listTasks("LDAP_DIRECTORY");
            if (taskArray != null) {
                int n = 0;
                while (n < taskArray.length) {
                    if (taskArray[n].getTaskOwner().equals(string)) {
                        if (string.equals("dspushd")) {
                            this.dspushd_task = taskArray[n];
                        } else {
                            this.dspulld_task = taskArray[n];
                        }
                        return new LDASchedule(0, taskArray[n].getDayOfMonth(), taskArray[n].getDayOfWeek(), taskArray[n].getHour(), taskArray[0].getMinute());
                    }
                    ++n;
                }
            }
            if ((taskArray == null || taskArray.length == 0) && string.equals("dspushd") && (string2 = this.server_properties.getProperty("StartDspushd", "false")).equalsIgnoreCase("true")) {
                return new LDASchedule(2, "", "", "", "");
            }
            return new LDASchedule(1, "*", "", "", "");
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            this.log("loadSchedule(): " + exception.getMessage());
            return new LDASchedule(1, "*", "", "", "");
        }
    }

    public LdapConf load() throws LdapConfigException {
        return this.load(new File("/etc/opt/SUNWconn/ldap/current", "dsserv.conf"));
    }

    public LdapConf load(File file) throws LdapConfigException {
        String string;
        BufferedReader bufferedReader;
        String string2;
        this.errorWhileLoadingConf = false;
        this.globalConf = new LdapConf();
        try {
            LDAOid.removeAll();
            this.load_configuration(file);
        }
        catch (IOException iOException) {
            throw new LdapConfigException(this.io_error_string(iOException));
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        Enumeration enumeration = this.globalConf.ocl.elements();
        while (enumeration.hasMoreElements()) {
            ClassItem classItem = (ClassItem)enumeration.nextElement();
            this.expandAliases(classItem, true);
            this.expandAliases(classItem, false);
        }
        try {
            this.globalConf.radius_timeStamp = Long.parseLong(LDACommandManager.getLastModifTime((String)new File("/etc/opt/SUNWconn/ldap/current", "mapping/radius.mapping").getAbsolutePath()));
            this.globalConf.nis_timeStamp = Long.parseLong(LDACommandManager.getLastModifTime((String)new File("/etc/opt/SUNWconn/ldap/current", "mapping/nis.mapping").getAbsolutePath()));
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        try {
            this.load_server_properties();
        }
        catch (Exception exception) {}
        if (this.errorWhileLoadingConf) {
            this.globalConf.errorInConf = true;
            this.globalConf.mainconf.errorInConf = true;
            try {
                this.logstream.flush();
                string2 = this.server_properties.getProperty("LogDir", "/var/opt/SUNWconn/ldap/log");
                bufferedReader = new BufferedReader(new FileReader(String.valueOf(string2) + "/dsserv_admin.log"));
                string = "";
                this.globalConf.errorString = new StringBuffer("");
                while ((string = bufferedReader.readLine()) != null) {
                    this.globalConf.errorString.append(String.valueOf(string) + "\n");
                }
                this.globalConf.mainconf.errorString = this.globalConf.errorString;
            }
            catch (Exception exception) {}
        }
        try {
            this.updateEditableAttributes();
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        this.globalConf.timeStamp = new Date();
        this.generatePartialReplicationObjects(this.globalConf.backends);
        this.splitReplicasAndSubtrees(this.globalConf.backends, this.globalConf.attributes);
        string2 = null;
        int n = 0;
        while (n < this.globalConf.backends.size()) {
            if (this.globalConf.backends.elementAt(n) instanceof LdbmBackend) {
                string2 = (LdbmBackend)this.globalConf.backends.elementAt(n);
                int n2 = 0;
                while (n2 < ((LdbmBackend)string2).indexes.size()) {
                    bufferedReader = (LDAIndexItem)((LdbmBackend)string2).indexes.elementAt(n2);
                    int n3 = 0;
                    while (n3 < ((LDAIndexItem)bufferedReader).names.size()) {
                        string = this.globalConf.attributes.getAttributeFromName((String)((LDAIndexItem)bufferedReader).names.elementAt(n3));
                        if (string != null && ((AttrItem)string).aliases != null) {
                            ((LDAIndexItem)bufferedReader).names.setElementAt((String)((AttrItem)string).aliases.firstElement(), n3);
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.globalConf.acl.access = this.globalConf.mainconf.access;
        enumeration = this.globalConf.attributes.elements();
        while (enumeration.hasMoreElements()) {
            string = (AttrItem)enumeration.nextElement();
            ((AttrItem)string).alias = ((AttrItem)string).aliases != null ? (String)((AttrItem)string).aliases.firstElement() : "";
        }
        try {
            this.globalConf.radius_service = this.fetchRadiusConf();
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        try {
            this.globalConf.nis_service = this.fetchNisConf();
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        return this.globalConf;
    }

    public void save(LdapConf ldapConf, boolean bl) throws LdapSaveErrorException, LdapWarningException {
        this.globalConf = ldapConf;
        this.save_configuration(bl);
        ldapConf.saved = true;
        this.errorWhileLoadingConf = false;
        this.globalConf.errorInConf = false;
        this.globalConf.mainconf.errorInConf = false;
        this.globalConf.mainconf.errorString = null;
    }

    private String io_error_string(IOException iOException) {
        if (iOException instanceof FileNotFoundException) {
            return this.cat.gets("File not found");
        }
        if (iOException instanceof EOFException) {
            return this.cat.gets("End of file");
        }
        if (iOException instanceof InterruptedIOException) {
            return this.cat.gets("interrupted");
        }
        return "";
    }

    private void save_configuration(boolean bl) throws LdapSaveErrorException, LdapWarningException {
        try {
            try {
                this.save_server_properties();
            }
            catch (LdapConfigException ldapConfigException) {
                throw new LdapSaveErrorException(ldapConfigException.getMessage());
            }
        }
        catch (LdapConfigException ldapConfigException) {
            throw new LdapSaveErrorException(ldapConfigException.getMessage());
        }
        File file = new File((String)this.globalConf.included_files.elementAt(0));
        try {
            LDACommandManager.execUnixCommand((String)("/bin/cp " + file.getAbsolutePath() + " " + "/tmp/dsserv.conf"));
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            if (this.globalConf.comments != null) {
                dataOutputStream.writeBytes(this.globalConf.comments.toString());
            }
            dataOutputStream.writeBytes("\n");
            int n = 1;
            while (n < this.globalConf.included_files.size()) {
                dataOutputStream.writeBytes(LDACatalog.printf((String)"include       %1\n", (String)((String)this.globalConf.included_files.elementAt(n))));
                ++n;
            }
            dataOutputStream.writeBytes("\n");
            this.generate_main_conf(this.globalConf, dataOutputStream);
            dataOutputStream.writeBytes("\n");
            BackEnd[] backEndArray = this.dispatchBackends(this.globalConf.backends);
            int n2 = this.globalConf.included_files.indexOf(file.getAbsolutePath());
            this.generate_backends(backEndArray[n2], dataOutputStream, true);
            backEndArray = null;
            dataOutputStream.close();
            this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath()))), n2);
            this.save_radius_configuration();
            this.save_nis_configuration();
        }
        catch (IOException iOException) {
            throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("Error while saving server configuration to %1 (%2)"), (String)file.getAbsolutePath(), (String)this.io_error_string(iOException)));
        }
        this.globalConf.saved = true;
        if (bl) {
            try {
                this.generate_crontab_file();
            }
            catch (Exception exception) {
                throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("Error while saving configuration (%1)"), (String)exception.getMessage()));
            }
            if (this.globalConf.mainconf.task.type != 2) {
                if (LDACommandManager.isSlurpdRunning((boolean)true)) {
                    try {
                        LDACommandManager.stopSlurpd();
                        return;
                    }
                    catch (LdapConfigException ldapConfigException) {
                        this.log(LDACatalog.printf((String)this.cat.gets("Can't stop dspushd process (%1)"), (String)ldapConfigException.getMessage()));
                        return;
                    }
                }
            } else if (!LDACommandManager.isSlurpdRunning((boolean)true)) {
                if (LDACommandManager.isSlurpdRunning((boolean)false)) {
                    try {
                        LDACommandManager.stopSlurpd();
                    }
                    catch (LdapConfigException ldapConfigException) {
                        this.log(LDACatalog.printf((String)this.cat.gets("Can't stop dspushd process (2) (%1)"), (String)ldapConfigException.getMessage()));
                    }
                }
                try {
                    LDACommandManager.execUnixCommand((String)LDAConstants.startSlurpdAlwaysCommand);
                    return;
                }
                catch (LdapConfigException ldapConfigException) {
                    throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("Messages detected while starting dspushd process ((%1)"), (String)ldapConfigException.getMessage()));
                }
            }
        }
    }

    private void generate_attributes(Attr attr, DataOutputStream dataOutputStream) {
        Enumeration enumeration = attr.elements();
        int n = attr.size();
        int n2 = 3;
        int n3 = 0;
        while (n3 < n) {
            if (((AttrItem)attr.elementAt((int)n3)).name.length() > n2) {
                n2 = ((AttrItem)attr.elementAt((int)n3)).name.length();
            }
            ++n3;
        }
        try {
            if (attr.comments != null) {
                dataOutputStream.writeBytes(attr.comments.toString());
            }
            while (enumeration.hasMoreElements()) {
                AttrItem attrItem = (AttrItem)enumeration.nextElement();
                dataOutputStream.writeBytes("attribute " + attrItem.name);
                int n4 = n2 - attrItem.name.length();
                int n5 = 0;
                while (n5 < n4) {
                    dataOutputStream.writeBytes(" ");
                    ++n5;
                }
                if (attrItem.aliases != null) {
                    int n6 = 0;
                    while (n6 < attrItem.aliases.size()) {
                        dataOutputStream.writeBytes(" " + (String)attrItem.aliases.elementAt(n6));
                        ++n6;
                    }
                }
                if (attrItem.oid != null) {
                    dataOutputStream.writeBytes(" " + attrItem.oid);
                    if (attrItem.size != -1 && attrItem.naming_class != null) {
                        dataOutputStream.writeBytes("{" + Integer.toString(attrItem.size) + "}");
                    }
                }
                dataOutputStream.writeBytes(" " + AttrItem.syntax2string((int)attrItem.syntax));
                if (attrItem.single) {
                    dataOutputStream.writeBytes(" single");
                }
                if (attrItem.naming_class != null) {
                    if (attrItem.single) {
                        dataOutputStream.writeBytes(",");
                    } else {
                        dataOutputStream.writeBytes(" ");
                    }
                    dataOutputStream.writeBytes("naming(" + attrItem.naming_class + ")");
                }
                dataOutputStream.writeBytes("\n");
            }
            return;
        }
        catch (IOException iOException) {
            this.log(LDACatalog.printf((String)this.cat.gets("Attribute generation failed : %1"), (String)this.io_error_string(iOException)));
            return;
        }
    }

    private void generate_classes(Objcl objcl, DataOutputStream dataOutputStream) {
        Enumeration enumeration = objcl.elements();
        try {
            if (objcl.comments != null) {
                dataOutputStream.writeBytes(objcl.comments.toString());
            }
            while (enumeration.hasMoreElements()) {
                AttrItem attrItem;
                String string;
                ClassItem classItem = (ClassItem)enumeration.nextElement();
                String string2 = string = classItem.editable ? "" : "frozen";
                if (classItem.comments != null) {
                    dataOutputStream.writeBytes(classItem.comments.toString());
                }
                dataOutputStream.writeBytes(LDACatalog.printf((String)"objectclass %1 %2\n", (String)classItem.name, (String)string));
                if (classItem.oid != null) {
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"   oid %1\n", (String)classItem.oid));
                }
                if (!classItem.name.equalsIgnoreCase("top")) {
                    if (classItem.superior == null) {
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"   superior %1\n", (String)"top"));
                    } else {
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"   superior %1\n", (String)classItem.superior));
                    }
                }
                if (classItem.required != null) {
                    Enumeration enumeration2 = classItem.required.elements();
                    if (enumeration2.hasMoreElements()) {
                        dataOutputStream.writeBytes("   requires\n");
                    }
                    while (enumeration2.hasMoreElements()) {
                        attrItem = (AttrItem)enumeration2.nextElement();
                        String string3 = string = attrItem.editable ? "" : " frozen";
                        if (enumeration2.hasMoreElements()) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"     %1%2,\n", (String)attrItem.name, (String)string));
                            continue;
                        }
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"     %1%2\n", (String)attrItem.name, (String)string));
                    }
                }
                if (classItem.allowed == null) continue;
                Enumeration enumeration3 = classItem.allowed.elements();
                if (enumeration3.hasMoreElements()) {
                    dataOutputStream.writeBytes("   allows\n");
                }
                while (enumeration3.hasMoreElements()) {
                    attrItem = (AttrItem)enumeration3.nextElement();
                    String string4 = string = attrItem.editable ? "" : " frozen";
                    if (enumeration3.hasMoreElements()) {
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"     %1%2,\n", (String)attrItem.name, (String)string));
                        continue;
                    }
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"     %1%2\n", (String)attrItem.name, (String)string));
                }
            }
            return;
        }
        catch (IOException iOException) {
            this.log(LDACatalog.printf((String)this.cat.gets("Class generation failed : %1"), (String)this.io_error_string(iOException)));
            return;
        }
    }

    private void generate_main_conf(LdapConf ldapConf, DataOutputStream dataOutputStream) {
        MainConf mainConf = ldapConf.mainconf;
        try {
            if (mainConf.comments != null) {
                dataOutputStream.writeBytes(mainConf.comments.toString());
            }
            if (ldapConf.log.custom > 0) {
                dataOutputStream.writeBytes(LDACatalog.printf((String)"loglevel      %1\n", (String)Integer.toString(ldapConf.log.custom)));
            } else {
                dataOutputStream.writeBytes(LDACatalog.printf((String)"loglevel      %1\n", (String)Integer.toString(ldapConf.log.level)));
            }
            dataOutputStream.writeBytes(LDACatalog.printf((String)"logfile       %1 %2\n", (String)(String.valueOf(ldapConf.log.dir) + "/dsserv.log"), (String)Integer.toString(ldapConf.log.size)));
            if (ldapConf.ldap_service.referral != null && !ldapConf.ldap_service.referral.equals("")) {
                dataOutputStream.writeBytes(LDACatalog.printf((String)"referral      %1\n", (String)ldapConf.ldap_service.referral));
            }
            if (ldapConf.ldap_service.bindderef) {
                dataOutputStream.writeBytes("bindderef     yes\n");
            } else {
                dataOutputStream.writeBytes("bindderef     no\n");
            }
            if (ldapConf.ldap_service.lookupclienthostname == 1) {
                dataOutputStream.writeBytes("lookupclienthostname  yes\n");
            } else if (ldapConf.ldap_service.lookupclienthostname == 0) {
                dataOutputStream.writeBytes("lookupclienthostname  no\n");
            }
            dataOutputStream.writeBytes(LDACatalog.printf((String)"sizelimit     %1\n", (String)Integer.toString(ldapConf.ldap_service.size_limit)));
            dataOutputStream.writeBytes(LDACatalog.printf((String)"timelimit     %1\n", (String)Integer.toString(ldapConf.ldap_service.time_limit)));
            dataOutputStream.writeBytes(LDACatalog.printf((String)"protected     %1\n", (String)ldapConf.security_service.pwhash));
            String string = "";
            String string2 = "";
            if ((ldapConf.security_service.mode & 1) != 0) {
                string = "insecure";
            }
            if ((ldapConf.security_service.mode & 2) != 0) {
                string = string.equals("") ? "tls" : String.valueOf(string) + ",tls";
                if (ldapConf.security_service.ssl_package != null) {
                    string2 = ldapConf.security_service.ssl_package;
                }
            }
            if ((ldapConf.security_service.mode & 4) != 0) {
                string = string.equals("") ? "sslport(" + Integer.toString(ldapConf.security_service.ssl_port) + ")" : String.valueOf(string) + ",sslport(" + Integer.toString(ldapConf.security_service.ssl_port) + ")";
                if (ldapConf.security_service.ssl_package != null) {
                    string2 = ldapConf.security_service.ssl_package;
                }
            }
            dataOutputStream.writeBytes(LDACatalog.printf((String)"ldapsecurity  %1 %2\n", (String)string, (String)string2));
            if (ldapConf.security_service.ssl_default_ciphers != null) {
                dataOutputStream.writeBytes(LDACatalog.printf((String)"ssl_cipher_list  %1\n", (String)ldapConf.security_service.ssl_default_ciphers));
            }
            if (ldapConf.security_service.ssl_client_verification) {
                dataOutputStream.writeBytes("ssl_client_verification on\n");
                this.setSslClientVerificationToken(true);
            } else if (this.getSslClientVerificationToken()) {
                dataOutputStream.writeBytes("ssl_client_verification off\n");
            }
            if (ldapConf.ocl.schema_check == 1) {
                dataOutputStream.writeBytes("schemacheck   on\n");
            } else if (ldapConf.ocl.schema_check == 3) {
                dataOutputStream.writeBytes("schemacheck   strong\n");
            } else {
                dataOutputStream.writeBytes("schemacheck   off\n");
            }
            int n = 0;
            while (n < mainConf.updateLog.size()) {
                dataOutputStream.writeBytes("updatelog     " + (String)mainConf.updateLog.elementAt(n) + "\n");
                ++n;
            }
            if (!mainConf.srvtab.equals("")) {
                dataOutputStream.writeBytes(LDACatalog.printf((String)"srvtab %1\n", (String)mainConf.srvtab));
            }
            dataOutputStream.writeBytes(LDACatalog.printf((String)"defaultaccess %1\n", (String)this.access_to_string(ldapConf.acl.access)));
            int n2 = 0;
            while (n2 < ldapConf.frontends.size()) {
                LDAFrontend lDAFrontend = (LDAFrontend)ldapConf.frontends.elementAt(n2);
                if (lDAFrontend.comments != null) {
                    dataOutputStream.writeBytes(lDAFrontend.comments.toString());
                }
                dataOutputStream.writeBytes(LDACatalog.printf((String)"frontend %1 %2\n", (String)lDAFrontend.name, (String)(lDAFrontend.enabled ? "on" : "off")));
                if (lDAFrontend.params != null) {
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"frontend_params %1\n", (String)lDAFrontend.params));
                }
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            this.log(LDACatalog.printf((String)this.cat.gets("Class generation failed : %1"), (String)this.io_error_string(iOException)));
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generate_acl(Acl var1_1, DataOutputStream var2_2) {
        try {
            var3_3 = var1_1.elements();
            if (var1_1.comments != null) {
                var2_2.writeBytes(var1_1.comments.toString());
            }
            if (var3_3.hasMoreElements()) ** GOTO lbl63
            return;
lbl-1000:
            // 1 sources

            {
                var4_5 = (AclWhat)var3_3.nextElement();
                if (!var4_5.editable) continue;
                var6_7 = "";
                if (var4_5.comments != null) {
                    var2_2.writeBytes(var4_5.comments.toString());
                } else {
                    var2_2.writeBytes("\n");
                }
                var2_2.writeBytes("access to");
                var7_8 = false;
                var8_9 = var4_5.by.elements();
                while (var8_9.hasMoreElements()) {
                    var5_6 = (AclBy)var8_9.nextElement();
                    if (var5_6.type != 6 || (var9_10 = var4_5.attr2string()).equalsIgnoreCase("entry") || var9_10.indexOf(",entry") >= 0) continue;
                    var7_8 = true;
                    break;
                }
                if (var4_5.type == 1 && (var4_5.attr == null || var4_5.attr.size() == 0)) {
                    var6_7 = "*";
                } else if (var4_5.type == 2) {
                    var6_7 = String.valueOf(this.generate_dn(var4_5.regex)) + " ";
                } else if (var4_5.type == 3) {
                    if (!var4_5.regex.equals("")) {
                        var6_7 = String.valueOf(this.generate_dn(var4_5.regex)) + " ";
                    }
                    if (var4_5.filter.trim().length() > 0) {
                        var6_7 = String.valueOf(var6_7) + this.generate_filter(var4_5.filter) + " ";
                    }
                }
                if (var4_5.attr.size() > 0) {
                    var6_7 = String.valueOf(var6_7) + this.generate_aclatt(var4_5.attr, var7_8);
                }
                var2_2.writeBytes(" " + var6_7 + "\n");
                var6_7 = "";
                var8_9 = var4_5.by.elements();
                while (var8_9.hasMoreElements()) {
                    var5_6 = (AclBy)var8_9.nextElement();
                    if (var5_6.type == 1) {
                        var6_7 = "*";
                    } else if (var5_6.type == 2) {
                        var6_7 = "self";
                    } else if (var5_6.type == 3) {
                        var6_7 = this.generate_dn(var5_6.regex);
                    } else if (var5_6.type == 4) {
                        var6_7 = "addr=" + var5_6.regex;
                    } else if (var5_6.type == 5) {
                        var6_7 = "domain=" + var5_6.regex;
                    } else if (var5_6.type == 6) {
                        var6_7 = LDACatalog.printf((String)"dnattr=%1", (String)var5_6.regex);
                    }
                    if (var5_6.type == 6) {
                        var2_2.writeBytes("     by " + var6_7 + " " + "self" + this.access_to_string(var5_6.access) + "\n");
                        this.log(this.cat.gets("<self> added ahead of access rights in <dnattr> clause."));
                        continue;
                    }
                    var2_2.writeBytes("     by " + var6_7 + " " + this.access_to_string(var5_6.access) + "\n");
                }
lbl63:
                // 3 sources

                ** while (var3_3.hasMoreElements())
            }
lbl64:
            // 1 sources

            return;
        }
        catch (IOException var3_4) {
            this.log(LDACatalog.printf((String)this.cat.gets("ACL generation failed : %1"), (String)this.io_error_string(var3_4)));
            return;
        }
    }

    public void generate_backend_file(LdbmBackend ldbmBackend, BackEnd backEnd, File file, File file2) {
        String string = ldbmBackend.file_id == -1 ? (String)this.globalConf.included_files.elementAt(0) : (String)this.globalConf.included_files.elementAt(ldbmBackend.file_id);
        boolean bl = false;
        if (ldbmBackend.file_id == 0 || ldbmBackend.file_id == -1) {
            bl = true;
        }
        try {
            String string2;
            StringTokenizer stringTokenizer;
            String string3;
            File file3 = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file3));
            DataOutputStream dataOutputStream = bl ? new DataOutputStream(new FileOutputStream(file)) : new DataOutputStream(new FileOutputStream(file2));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("#")) {
                    dataOutputStream.writeBytes(String.valueOf(string3) + "\n");
                    continue;
                }
                stringTokenizer = new StringTokenizer(string3);
                if (!stringTokenizer.hasMoreTokens()) {
                    dataOutputStream.writeBytes(String.valueOf(string3) + "\n");
                    continue;
                }
                string2 = stringTokenizer.nextToken();
                if (string2.equals("database")) {
                    BackEnd[] backEndArray = this.dispatchBackends(backEnd);
                    int n = this.globalConf.included_files.indexOf(file3.getAbsolutePath());
                    this.generate_backends(backEndArray[n], dataOutputStream, true);
                    break;
                }
                dataOutputStream.writeBytes(String.valueOf(string3) + "\n");
            }
            bufferedReader.close();
            dataOutputStream.close();
            if (!bl) {
                bufferedReader = new BufferedReader(new FileReader((String)this.globalConf.included_files.firstElement()));
                dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.startsWith("#")) {
                        dataOutputStream.writeBytes(String.valueOf(string3) + "\n");
                        continue;
                    }
                    stringTokenizer = new StringTokenizer(string3);
                    if (!stringTokenizer.hasMoreTokens()) {
                        dataOutputStream.writeBytes(String.valueOf(string3) + "\n");
                        continue;
                    }
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("include") && stringTokenizer.nextToken().equals(string)) {
                        dataOutputStream.writeBytes("include " + file2.getAbsolutePath() + "\n");
                        continue;
                    }
                    dataOutputStream.writeBytes(String.valueOf(string3) + "\n");
                }
                bufferedReader.close();
                dataOutputStream.close();
                return;
            }
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
    }

    private void generate_backends(BackEnd backEnd, DataOutputStream dataOutputStream, boolean bl) {
        try {
            Enumeration enumeration = backEnd.elements();
            if (backEnd.comments != null && bl) {
                dataOutputStream.writeBytes(backEnd.comments.toString());
            }
            while (enumeration.hasMoreElements()) {
                AttrItem attrItem;
                Enumeration enumeration2;
                Object object;
                Object object2;
                Enumeration enumeration3;
                BackEndHeader backEndHeader = (BackEndHeader)enumeration.nextElement();
                if (backEndHeader.comments != null) {
                    dataOutputStream.writeBytes(backEndHeader.comments.toString());
                } else {
                    dataOutputStream.writeBytes("\n\n");
                }
                if (backEnd.size() > 1 && ((String)backEndHeader.suffix.firstElement()).equals("o=generated_dummy_datastore")) continue;
                dataOutputStream.writeBytes(LDACatalog.printf((String)"database    %1\n", (String)(backEndHeader instanceof LdbmBackend ? "ldbm" : "shell")));
                int n = backEndHeader.suffix.size();
                int n2 = 0;
                while (n2 < n) {
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"suffix      \"%1\"\n", (String)((String)backEndHeader.suffix.elementAt(n2))));
                    ++n2;
                }
                dataOutputStream.writeBytes("lastmod     " + (backEndHeader.lastmod ? "on" : "off") + "\n");
                dataOutputStream.writeBytes("readonly    " + (backEndHeader.readonly ? "on" : "off") + "\n");
                dataOutputStream.writeBytes(LDACatalog.printf((String)"rootdn      \"cn=%1,%2\"\n", (String)this.globalConf.security_service.rootdn, (String)((String)backEndHeader.suffix.firstElement())));
                if (!this.globalConf.security_service.root_password.startsWith("{sunds}") && !this.globalConf.security_service.root_password.startsWith("{crypt}")) {
                    this.globalConf.security_service.root_password_tag = "{sunds}";
                    this.globalConf.security_service.root_password = LDACommandManager.crypt((String)("{sunds}" + this.globalConf.security_service.root_password));
                }
                dataOutputStream.writeBytes(LDACatalog.printf((String)"rootpw      %1\n", (String)this.globalConf.security_service.root_password));
                if (backEndHeader.new_replica.size() > 0) {
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"replogfile  %1\n", (String)"/var/opt/SUNWconn/ldap/log/dsserv.replog"));
                } else if (!backEndHeader.log.equals("")) {
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"replogfile  %1\n", (String)backEndHeader.log));
                }
                this.generate_acl(backEndHeader.acl, dataOutputStream);
                if (backEndHeader instanceof LdbmBackend) {
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"directory   %1\n", (String)((LdbmBackend)backEndHeader).dbdir));
                    enumeration3 = new File(((LdbmBackend)backEndHeader).dbdir);
                    if (!((File)((Object)enumeration3)).exists()) {
                        ((File)((Object)enumeration3)).mkdirs();
                    }
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"mode        %1\n", (String)((LdbmBackend)backEndHeader).mode));
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"cachesize   %1\n", (String)Integer.toString(((LdbmBackend)backEndHeader).cache)));
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"dbcachesize %1\n", (String)Integer.toString(((LdbmBackend)backEndHeader).dbcache)));
                    dataOutputStream.writeBytes(LDACatalog.printf((String)"diskspace   %1 %2 %3\n", (String)Integer.toString(((LdbmBackend)backEndHeader).critical), (String)Integer.toString(((LdbmBackend)backEndHeader).congested), (String)Integer.toString(((LdbmBackend)backEndHeader).back_to_normal)));
                    object2 = ((LdbmBackend)backEndHeader).indexes.elements();
                    while (object2.hasMoreElements()) {
                        object = (LDAIndexItem)object2.nextElement();
                        enumeration2 = "";
                        if (((LDAIndexItem)object).present) {
                            enumeration2 = "pres";
                        }
                        if (((LDAIndexItem)object).equal) {
                            if (!((String)((Object)enumeration2)).equals("")) {
                                enumeration2 = String.valueOf(enumeration2) + ",";
                            }
                            enumeration2 = String.valueOf(enumeration2) + "eq";
                        }
                        if (((LDAIndexItem)object).substring) {
                            if (!((String)((Object)enumeration2)).equals("")) {
                                enumeration2 = String.valueOf(enumeration2) + ",";
                            }
                            enumeration2 = String.valueOf(enumeration2) + "sub";
                        }
                        if (((LDAIndexItem)object).approx) {
                            if (!((String)((Object)enumeration2)).equals("")) {
                                enumeration2 = String.valueOf(enumeration2) + ",";
                            }
                            enumeration2 = String.valueOf(enumeration2) + "approx";
                        }
                        if (((LDAIndexItem)object).none) {
                            enumeration2 = "none";
                        }
                        int n3 = ((LDAIndexItem)object).names.size();
                        attrItem = null;
                        int n4 = 0;
                        while (n4 < n3) {
                            attrItem = this.globalConf.attributes.getAttributeFromAlias((String)((LDAIndexItem)object).names.elementAt(n4));
                            if (attrItem != null) {
                                ((LDAIndexItem)object).names.setElementAt(attrItem.name.toLowerCase(), n4);
                            }
                            ++n4;
                        }
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"index       %1 %2\n", (String)object.name2String(), enumeration2));
                    }
                }
                try {
                    enumeration3 = this.groupReplicas(backEndHeader.new_replica).elements();
                    while (enumeration3.hasMoreElements()) {
                        object2 = (LDAReplicaItem)enumeration3.nextElement();
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"\n\npush_replica host=%1:%2\n", (String)((LDAReplicaItem)object2).host, (String)Integer.toString(((LDAReplicaItem)object2).port)));
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"  binddn=\"%1\"\n", (String)((LDAReplicaItem)object2).updateDn));
                        dataOutputStream.writeBytes("  bindmethod=" + ((LDAReplicaItem)object2).bindmethod + "\n");
                        dataOutputStream.writeBytes("  ldapsecurity=" + ((LDAReplicaItem)object2).securitymode);
                        if (!((LDAReplicaItem)object2).securitymode.equals("insecure") && !((LDAReplicaItem)object2).sslpkg.equals("")) {
                            dataOutputStream.writeBytes("(" + ((LDAReplicaItem)object2).sslpkg + ")\n");
                        } else {
                            dataOutputStream.writeBytes("\n");
                        }
                        if (!((LDAReplicaItem)object2).password.startsWith("{sunds}")) {
                            ((LDAReplicaItem)object2).password = LDACommandManager.crypt((String)("{sunds}" + ((LDAReplicaItem)object2).password));
                        }
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"  credentials=%1\n", (String)((LDAReplicaItem)object2).password));
                        object = ((LDAReplicaItem)object2).object_suffixes.elements();
                        while (object.hasMoreElements()) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  object=\"%1\"\n", (String)((String)object.nextElement())));
                        }
                        enumeration2 = ((LDAReplicaItem)object2).subtree_suffixes.elements();
                        while (enumeration2.hasMoreElements()) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  subtree=\"%1\"\n", (String)((String)enumeration2.nextElement())));
                        }
                        Attr attr = new Attr();
                        if (((LDAReplicaItem)object2).atttype == 2) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  inclattr=%1\n", (String)Attr.attrVector2AttrName((Vector)((LDAReplicaItem)object2).attributes)));
                            continue;
                        }
                        if (((LDAReplicaItem)object2).atttype != 1) continue;
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"  exclattr=%1\n", (String)Attr.attrVector2AttrName((Vector)((LDAReplicaItem)object2).attributes)));
                    }
                    enumeration3 = this.groupSubtrees(backEndHeader.subtree, false).elements();
                    while (enumeration3.hasMoreElements()) {
                        object = (LDASubtreeItem)enumeration3.nextElement();
                        if (((LDASubtreeItem)object).mode == 1) {
                            dataOutputStream.writeBytes("\n\nmaster\n");
                        } else {
                            dataOutputStream.writeBytes("\n\nslave\n");
                            if (((LDASubtreeItem)object).updateDn.equals("")) {
                                dataOutputStream.writeBytes(LDACatalog.printf((String)"  replicadn=\"%1\"\n", (String)((LDASubtreeItem)object).binddn));
                            } else {
                                dataOutputStream.writeBytes(LDACatalog.printf((String)"  replicadn=\"%1\"\n", (String)((LDASubtreeItem)object).updateDn));
                            }
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  referral=\"ldap://%1:%2\"\n", (String)((LDASubtreeItem)object).host, (String)Integer.toString(((LDASubtreeItem)object).port)));
                        }
                        enumeration2 = ((LDASubtreeItem)object).object_suffixes.elements();
                        while (enumeration2.hasMoreElements()) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  object=\"%1\"\n", (String)((String)enumeration2.nextElement())));
                        }
                        Enumeration enumeration4 = ((LDASubtreeItem)object).subtree_suffixes.elements();
                        while (enumeration4.hasMoreElements()) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  subtree=\"%1\"\n", (String)((String)enumeration4.nextElement())));
                        }
                    }
                    enumeration3 = this.groupSubtrees(backEndHeader.subtree, true).elements();
                    while (enumeration3.hasMoreElements()) {
                        object = (LDASubtreeItem)enumeration3.nextElement();
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"\n\npull_replica host=%1:%2\n", (String)((LDASubtreeItem)object).host, (String)Integer.toString(((LDASubtreeItem)object).port)));
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"  binddn=\"%1\"\n", (String)((LDASubtreeItem)object).binddn));
                        dataOutputStream.writeBytes("  bindmethod=" + ((LDASubtreeItem)object).bindmethod + "\n");
                        dataOutputStream.writeBytes("  ldapsecurity=" + ((LDASubtreeItem)object).securitymode);
                        if (!((LDASubtreeItem)object).securitymode.equals("insecure") && !((LDASubtreeItem)object).sslpkg.equals("")) {
                            dataOutputStream.writeBytes("(" + ((LDASubtreeItem)object).sslpkg + ")\n");
                        } else {
                            dataOutputStream.writeBytes("\n");
                        }
                        if (!((LDASubtreeItem)object).password.startsWith("{sunds}")) {
                            ((LDASubtreeItem)object).password = LDACommandManager.crypt((String)("{sunds}" + ((LDASubtreeItem)object).password));
                        }
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"  credentials=%1\n", (String)((LDASubtreeItem)object).password));
                        enumeration2 = ((LDASubtreeItem)object).object_suffixes.elements();
                        while (enumeration2.hasMoreElements()) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  object=\"%1\"\n", (String)((String)enumeration2.nextElement())));
                        }
                        Enumeration enumeration5 = ((LDASubtreeItem)object).subtree_suffixes.elements();
                        while (enumeration5.hasMoreElements()) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  subtree=\"%1\"\n", (String)((String)enumeration5.nextElement())));
                        }
                        attrItem = new Attr();
                        if (((LDASubtreeItem)object).atttype == 2) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  inclattr=%1\n", (String)Attr.attrVector2AttrName((Vector)((LDASubtreeItem)object).attributes)));
                        } else if (((LDASubtreeItem)object).atttype == 1) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  exclattr=%1\n", (String)Attr.attrVector2AttrName((Vector)((LDASubtreeItem)object).attributes)));
                        }
                        if (!((LDASubtreeItem)object).filter.trim().equals("")) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  filter=\"%1\"\n", (String)((LDASubtreeItem)object).filter));
                        }
                        if (!((LDASubtreeItem)object).local_filter.trim().equals("")) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  local-filter=\"%1\"\n", (String)((LDASubtreeItem)object).local_filter));
                        }
                        if (!((LDASubtreeItem)object).pollevery.trim().equals("")) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  pollevery=%1\n", (String)((LDASubtreeItem)object).pollevery));
                        }
                        if (!((LDASubtreeItem)object).pollat.trim().equals("")) {
                            dataOutputStream.writeBytes(LDACatalog.printf((String)"  pollat=%1\n", (String)((LDASubtreeItem)object).pollat));
                        }
                        dataOutputStream.writeBytes(LDACatalog.printf((String)"  timeout=%1\n", (String)Integer.toString(((LDASubtreeItem)object).timeout)));
                    }
                }
                catch (Exception exception) {
                    LDADebug.printStackTrace((Exception)exception);
                }
            }
            return;
        }
        catch (IOException iOException) {
            this.log(LDACatalog.printf((String)this.cat.gets("Backend generation failed : %1"), (String)this.io_error_string(iOException)));
            return;
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void load_configuration(File file) throws IOException {
        Object object;
        LDADebug.debug((Object)("Loading " + file));
        String string = null;
        AclWhat aclWhat = null;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        String string2 = file.getAbsolutePath();
        this.globalConf.included_files.addElement(string2);
        this.globalConf.included_files_timestamp.addElement(new Long(LDACommandManager.getLastModifTime((String)string2)));
        int n = this.globalConf.included_files.size() - 1;
        block38: while (true) {
            int n2;
            boolean bl;
            Object object2;
            String string3;
            if (string != null) {
                string3 = string;
                string = null;
            } else {
                string3 = this.get_next_line(lineNumberReader);
            }
            if (string3 == null) break;
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("attribute")) {
                String string5;
                String string6;
                boolean bl2;
                String string7;
                String string8;
                Vector<String> vector;
                block269: {
                    if (!this.check_token_count(lineNumberReader, stringTokenizer, 2, 20)) continue;
                    stringTokenizer.countTokens();
                    object = stringTokenizer.nextToken();
                    vector = null;
                    string8 = "";
                    string7 = null;
                    bl2 = false;
                    string6 = null;
                    string5 = "-1";
                    int n3 = stringTokenizer.countTokens();
                    object2 = new String[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        object2[n4] = stringTokenizer.nextToken();
                        ++n4;
                    }
                    if (n3 == 1) {
                        string8 = object2[0];
                    } else {
                        bl = false;
                        int n5 = n3 - 1;
                        try {
                            if (object2[n5].startsWith("single")) {
                                bl2 = true;
                                bl = true;
                            }
                            if ((n2 = object2[n5].indexOf("naming(")) != -1) {
                                string6 = object2[n5].substring(n2 + 7);
                                if (string6.endsWith(")")) {
                                    string6 = string6.substring(0, string6.length() - 1);
                                }
                                bl = true;
                            }
                            string8 = bl ? object2[--n5] : object2[n5];
                            if (--n5 < 0) break block269;
                            if (object2[n5].endsWith("}")) {
                                string5 = object2[n5].substring(object2[n5].indexOf("{") + 1, object2[n5].indexOf("}"));
                                string7 = object2[n5].substring(0, object2[n5].indexOf("{"));
                            } else {
                                string7 = object2[n5];
                            }
                            if (LDAOid.check((String)string7)) {
                                if (!LDAOid.add((String)string7)) {
                                    this.report_error(string2, lineNumberReader, this.cat.gets("duplicated oid value"));
                                    continue;
                                }
                                --n5;
                            } else {
                                string7 = null;
                            }
                            int n6 = 0;
                            while (n6 <= n5) {
                                if (vector == null) {
                                    vector = new Vector<String>();
                                }
                                vector.addElement(object2[n6]);
                                ++n6;
                            }
                            Integer.parseInt(string5);
                        }
                        catch (Exception exception) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid parameter"));
                            continue;
                        }
                    }
                }
                bl = AttrItem.string2syntax((String)string8);
                if (bl) {
                    this.report_error(string2, lineNumberReader, this.cat.gets("Invalid attribute syntax"));
                    continue;
                }
                AttrItem attrItem = this.check_and_add_attribute(string2, lineNumberReader, (String)object, vector, bl ? 1 : 0, string6, Integer.parseInt(string5), string7, bl2);
                if (attrItem == null) continue;
                attrItem.file_id = n;
                continue;
            }
            if (string4.equals("naming_attribute")) {
                AttrItem attrItem;
                Vector<String> vector;
                int n7;
                String string9;
                block270: {
                    if (!this.check_token_count(lineNumberReader, stringTokenizer, 2, 1000)) continue;
                    int n8 = stringTokenizer.countTokens();
                    string9 = stringTokenizer.nextToken();
                    n7 = 64;
                    vector = null;
                    try {
                        n7 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n8 <= 2) break block270;
                        vector = new Vector<String>();
                        vector.addElement(stringTokenizer.nextToken());
                    }
                    catch (Exception exception) {
                        this.report_error(string2, lineNumberReader, this.cat.gets("Invalid naming attribute size"));
                        continue;
                    }
                }
                if ((attrItem = this.check_and_add_attribute(string2, lineNumberReader, string9, vector, 0, "person", n7, null, false)) == null) continue;
                attrItem.file_id = n;
                continue;
            }
            if (string4.equalsIgnoreCase("objectclass")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 2)) continue;
                int n9 = stringTokenizer.countTokens();
                ClassItem classItem = new ClassItem(stringTokenizer.nextToken());
                classItem.comments = this.getObjectComments();
                classItem.file_id = n;
                if (n9 > 1) {
                    classItem.editable = false;
                }
                if (this.globalConf.ocl.getClassItemFromName(classItem.name) != null) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : duplicated object class"), (String)classItem.name));
                } else {
                    this.globalConf.ocl.addElement(classItem);
                    StringBuffer stringBuffer = this.getSectionComments();
                    if (stringBuffer != null) {
                        this.globalConf.ocl.comments = stringBuffer;
                    }
                }
                int n10 = 0;
                while (true) {
                    if (n10 >= 2) continue block38;
                    string3 = this.get_next_line(lineNumberReader);
                    if (string3 != null) {
                        stringTokenizer = new StringTokenizer(string3);
                        int n11 = stringTokenizer.countTokens();
                        String string10 = stringTokenizer.nextToken();
                        if (string10.equals("oid")) {
                            if (n11 != 2) {
                                this.report_error(string2, lineNumberReader, this.cat.gets("Missing oid value"));
                            } else {
                                string10 = stringTokenizer.nextToken();
                                if (!LDAOid.check((String)string10)) {
                                    this.report_error(string2, lineNumberReader, this.cat.gets("Invalid oid value"));
                                    this.globalConf.ocl.removeElement(classItem);
                                } else {
                                    if (!LDAOid.add((String)string10)) {
                                        this.report_error(string2, lineNumberReader, this.cat.gets("duplicated oid value"));
                                        this.globalConf.ocl.removeElement(classItem);
                                    }
                                    classItem.oid = string10;
                                }
                            }
                            if ((string3 = this.get_next_line(lineNumberReader)) == null) continue block38;
                            stringTokenizer = new StringTokenizer(string3);
                            n11 = stringTokenizer.countTokens();
                            string10 = stringTokenizer.nextToken();
                        }
                        if (string10.equals("superior")) {
                            if (n11 != 2) {
                                this.report_error(string2, lineNumberReader, this.cat.gets("Missing superior value"));
                            } else {
                                classItem.superior = stringTokenizer.nextToken();
                                if (classItem.superior.equals("top")) {
                                    classItem.superior = null;
                                }
                            }
                            if ((string3 = this.get_next_line(lineNumberReader)) == null) continue block38;
                            stringTokenizer = new StringTokenizer(string3);
                            n11 = stringTokenizer.countTokens();
                            string10 = stringTokenizer.nextToken();
                        }
                        if (!string10.equals("requires") && !string10.equals("allows")) {
                            if (n10 == 0) {
                                this.report_error(string2, lineNumberReader, this.cat.gets("Missing attribute list"));
                                this.globalConf.ocl.removeElement(classItem);
                                continue block38;
                            }
                            string = string3;
                            continue block38;
                        }
                        boolean bl3 = true;
                        if (string10.equals("allows")) {
                            bl3 = false;
                        }
                        boolean bl4 = false;
                        AttrItem attrItem = null;
                        while ((string3 = this.get_next_line(lineNumberReader)) != null) {
                            stringTokenizer = new StringTokenizer(string3);
                            while (stringTokenizer.hasMoreElements()) {
                                if (attrItem != null) {
                                    classItem.add_attribute(attrItem, bl3);
                                    this.check_and_add_attribute(string2, lineNumberReader, attrItem.name, null, 0, null, 64, null, false);
                                }
                                if (((String)(object2 = stringTokenizer.nextToken())).startsWith("frozen")) {
                                    if (attrItem != null) {
                                        attrItem.editable = false;
                                    }
                                    attrItem = null;
                                    if (((String)object2).endsWith(",")) continue;
                                    bl4 = true;
                                } else {
                                    attrItem = null;
                                    Object object3 = object2;
                                    if (((String)object3).endsWith(",")) {
                                        object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
                                    } else if (!stringTokenizer.hasMoreTokens()) {
                                        bl4 = true;
                                    }
                                    attrItem = new AttrItem((String)object3);
                                    if (classItem.attribute_contained(attrItem, bl3)) {
                                        this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : duplicated attribute in class %2"), (String)object3, (String)classItem.name));
                                        continue;
                                    }
                                }
                                if (!bl4) continue;
                                if (attrItem != null) {
                                    classItem.add_attribute(attrItem, bl3);
                                    this.check_and_add_attribute(string2, lineNumberReader, attrItem.name, null, 0, null, 64, null, false);
                                    attrItem = null;
                                }
                                if (!stringTokenizer.hasMoreElements()) break;
                                this.report_error(string2, lineNumberReader, this.cat.gets("Unexpected end of attribute detected"));
                                break;
                            }
                            if (!bl4) continue;
                        }
                    }
                    ++n10;
                }
            }
            if (string4.equals("protected")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                if (object == null) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("Missing value for token %1"), (String)string4));
                    continue;
                }
                this.globalConf.security_service.pwhash = object;
                continue;
            }
            if (string4.equals("ssl_cipher_list")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 10)) continue;
                object = stringTokenizer.nextToken();
                if (object == null) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("Missing value for token %1"), (String)string4));
                    continue;
                }
                this.globalConf.security_service.ssl_default_ciphers = object;
                continue;
            }
            if (string4.equals("ssl_client_verification")) {
                this.setSslClientVerificationToken(true);
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 10)) continue;
                object = stringTokenizer.nextToken();
                if (object == null) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("Missing value for token %1"), (String)string4));
                    continue;
                }
                if (((String)object).equalsIgnoreCase("on")) {
                    this.globalConf.security_service.ssl_client_verification = true;
                    continue;
                }
                this.globalConf.security_service.ssl_client_verification = false;
                continue;
            }
            if (string4.equals("ldapsecurity")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 2)) continue;
                object = stringTokenizer.nextToken();
                if (object == null) {
                    this.report_error(string2, lineNumberReader, this.cat.gets("Missing security mode"));
                    continue;
                }
                this.globalConf.security_service.mode = 0;
                if (((String)object).indexOf("insecure") >= 0) {
                    this.globalConf.security_service.mode |= 1;
                }
                if (((String)object).indexOf("tls") >= 0) {
                    this.globalConf.security_service.mode |= 2;
                }
                if (((String)object).indexOf("sslport") >= 0) {
                    this.globalConf.security_service.mode |= 4;
                }
                int n12 = ((String)object).indexOf("(");
                int n13 = ((String)object).indexOf(")");
                if (n12 >= 0 && n13 >= 0) {
                    try {
                        this.globalConf.security_service.ssl_port = Integer.parseInt(((String)object).substring(n12 + 1, n13));
                    }
                    catch (Exception exception) {
                        this.report_error(string2, lineNumberReader, this.cat.gets("Invalid sslport value. Ignored"));
                    }
                }
                if (this.globalConf.security_service.mode == 0) {
                    this.report_error(string2, lineNumberReader, this.cat.gets("Missing security mode. Set to insecure."));
                    this.globalConf.security_service.mode = 1;
                    continue;
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                this.globalConf.security_service.ssl_package = stringTokenizer.nextToken();
                continue;
            }
            if (string4.equals("frontend")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 2, 2)) continue;
                this.globalConf.frontends.addElement(new LDAFrontend(stringTokenizer.nextToken(), stringTokenizer.nextToken().equals("on")));
                ((LDAFrontend)this.globalConf.frontends.lastElement()).comments = this.getObjectComments();
                continue;
            }
            if (string4.equals("frontend_params")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 2, 12)) continue;
                object = (LDAFrontend)this.globalConf.frontends.lastElement();
                if (object == null) {
                    this.report_error(string2, lineNumberReader, this.cat.gets("Unexpected frontend_params clause."));
                    continue;
                }
                ((LDAFrontend)object).params = string3.substring(string3.indexOf(stringTokenizer.nextToken()));
                continue;
            }
            if (string4.equals("bindderef")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                if (((String)object).equals("yes")) {
                    this.globalConf.ldap_service.bindderef = true;
                    continue;
                }
                if (((String)object).equals("no")) {
                    this.globalConf.ldap_service.bindderef = false;
                    continue;
                }
                this.report_error(string2, lineNumberReader, this.cat.gets("Invalid bindderef value"));
                continue;
            }
            if (string4.equals("lookupclienthostname")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                if (((String)object).equals("yes")) {
                    this.globalConf.ldap_service.lookupclienthostname = 1;
                    continue;
                }
                this.globalConf.ldap_service.lookupclienthostname = 0;
                continue;
            }
            if (string4.equals("logfile")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 2, 2)) continue;
                object = new File(stringTokenizer.nextToken());
                this.globalConf.log.dir = ((File)object).getParent();
                try {
                    this.globalConf.log.size = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    this.report_error(string2, lineNumberReader, this.cat.gets("Invalid logfile size"));
                }
                continue;
            }
            if (string4.equals("updatelog")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                this.globalConf.mainconf.updateLog.addElement(stringTokenizer.nextToken());
                continue;
            }
            if (string4.equals("defaultaccess")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                if (((String)object).equals("none") || ((String)object).equals("compare") || ((String)object).equals("search") || ((String)object).equals("read") || ((String)object).equals("write")) {
                    this.globalConf.mainconf.access = new Access((String)object);
                    continue;
                }
                this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid default access value"), (String)object));
                continue;
            }
            if (string4.equals("referral")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                if (!((String)object).startsWith("ldap://")) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid ldap url"), (String)object));
                    continue;
                }
                if (((String)object).lastIndexOf(":") == 4) {
                    object = String.valueOf(object) + ":389";
                }
                this.globalConf.ldap_service.referral = object;
                continue;
            }
            if (string4.equals("schemacheck")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                if (((String)object).equals("on")) {
                    this.globalConf.ocl.schema_check = 1;
                    continue;
                }
                if (((String)object).equals("off")) {
                    this.globalConf.ocl.schema_check = 2;
                    continue;
                }
                if (((String)object).equals("strong")) {
                    this.globalConf.ocl.schema_check = 3;
                    continue;
                }
                this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid schemacheck value"), (String)object));
                continue;
            }
            if (string4.equals("sizelimit")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                int n14 = 500;
                try {
                    n14 = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid size limit value"), (String)object));
                    continue;
                }
                this.globalConf.ldap_service.size_limit = n14;
                continue;
            }
            if (string4.equals("timelimit")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                int n15 = 3600;
                try {
                    n15 = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid time limit value"), (String)object));
                    continue;
                }
                this.globalConf.ldap_service.time_limit = n15;
                continue;
            }
            if (string4.equals("srvtab")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                this.globalConf.mainconf.srvtab = object = stringTokenizer.nextToken();
                continue;
            }
            if (string4.equals("loglevel")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                int n16 = 0;
                try {
                    n16 = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid loglevel (integer expected)"), (String)object));
                    continue;
                }
                if (n16 != 0 && n16 != 256 && n16 != 384 && n16 != 15358) {
                    this.globalConf.log.level = 384;
                    this.globalConf.log.custom = n16;
                    continue;
                }
                this.globalConf.log.level = n16;
                this.globalConf.log.custom = -1;
                continue;
            }
            if (string4.equals("include")) {
                object = this.getSectionComments();
                if (this.globalConf.comments == null && object != null) {
                    this.globalConf.comments = object;
                }
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                String string11 = stringTokenizer.nextToken();
                try {
                    this.load_configuration(new File(string11));
                }
                catch (IOException iOException) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : loading include file failed %2"), (String)string11, (String)this.io_error_string(iOException)));
                }
                continue;
            }
            if (string4.equals("access")) {
                object = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.mapacl.conf").getAbsolutePath();
                StringBuffer stringBuffer = this.getSectionComments();
                Vector vector = this.process_access_what(string2, string3, lineNumberReader, stringTokenizer);
                if (vector != null) {
                    string3 = (String)vector.firstElement();
                    string = (String)vector.elementAt(1);
                    aclWhat = (AclWhat)vector.elementAt(2);
                    this.globalConf.acl.addElement(aclWhat);
                    aclWhat.file_id = n;
                    if (string2.equals(object)) {
                        aclWhat.editable = false;
                    }
                }
                if (string2.equals(object) || stringBuffer == null || this.globalConf.acl.comments != null) continue;
                this.globalConf.acl.comments = stringBuffer;
                continue;
            }
            if (string4.equals("by")) {
                this.process_access_by(string2, string3, lineNumberReader, stringTokenizer, aclWhat);
                continue;
            }
            if (string4.equals("database")) {
                if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                object = stringTokenizer.nextToken();
                if (!((String)object).equals("ldbm")) {
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : database type not supported"), (String)object));
                    continue;
                }
                LdbmBackend ldbmBackend = new LdbmBackend();
                ldbmBackend.file_id = n;
                ldbmBackend.comments = this.getObjectComments();
                StringBuffer stringBuffer = this.getSectionComments();
                if (stringBuffer != null && this.globalConf.backends.comments == null) {
                    this.globalConf.backends.comments = stringBuffer;
                }
                this.globalConf.backends.addElement(ldbmBackend);
                ReplHost replHost = null;
                LDAReplicaItem lDAReplicaItem = null;
                LDASubtreeItem lDASubtreeItem = null;
                AclWhat aclWhat2 = null;
                string = null;
                block44: while (true) {
                    boolean bl5;
                    if (string != null) {
                        string3 = string;
                        string = null;
                    } else {
                        string3 = this.get_next_line(lineNumberReader);
                    }
                    if (string3 == null) continue block38;
                    stringTokenizer = new StringTokenizer(string3);
                    string4 = stringTokenizer.nextToken();
                    if (string4.equals("access")) {
                        Vector vector = this.process_access_what(string2, string3, lineNumberReader, stringTokenizer);
                        if (vector != null) {
                            string3 = (String)vector.firstElement();
                            string = (String)vector.elementAt(1);
                            aclWhat2 = (AclWhat)vector.elementAt(2);
                            ldbmBackend.acl.addElement(aclWhat2);
                        }
                        this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("WARNING: Local access control rules not supported.\nLocal access control rules detected for data store %1: They may conflict with global access control rules."), (String)((String)ldbmBackend.suffix.firstElement())));
                        continue;
                    }
                    if (string4.equals("by")) {
                        this.process_access_by(string2, string3, lineNumberReader, stringTokenizer, aclWhat2);
                        continue;
                    }
                    if (string4.equals("defaultaccess")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                        String string12 = stringTokenizer.nextToken();
                        if (string12.equals("none") || string12.equals("compare") || string12.equals("search") || string12.equals("read") || string12.equals("write")) {
                            ldbmBackend.access = new Access(string12);
                            continue;
                        }
                        this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid default access value"), (String)string12));
                        continue;
                    }
                    if (string4.equals("referral")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                        String string13 = stringTokenizer.nextToken();
                        if (!string13.startsWith("ldap://")) {
                            this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid ldap url"), (String)string13));
                            continue;
                        }
                        ldbmBackend.mastername = string3.substring(string3.lastIndexOf("ldap://") + 7);
                        continue;
                    }
                    if (string4.equals("lastmod")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                        String string14 = stringTokenizer.nextToken();
                        if (string14.equalsIgnoreCase("on")) {
                            ldbmBackend.lastmod = true;
                            continue;
                        }
                        if (string14.equalsIgnoreCase("off")) {
                            ldbmBackend.lastmod = false;
                            continue;
                        }
                        this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid lastmod value"), (String)string14));
                        continue;
                    }
                    if (string4.equals("readonly")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                        String string15 = stringTokenizer.nextToken();
                        if (string15.equalsIgnoreCase("on")) {
                            ldbmBackend.readonly = true;
                            continue;
                        }
                        if (string15.equalsIgnoreCase("off")) {
                            ldbmBackend.readonly = false;
                            continue;
                        }
                        this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid readonly value"), (String)string15));
                        continue;
                    }
                    if (string4.equals("replogfile")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                        stringTokenizer.nextToken();
                        ldbmBackend.log = "/var/opt/SUNWconn/ldap/log/dsserv.replog";
                        continue;
                    }
                    if (string4.equals("rootdn")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1000)) continue;
                        String string16 = LDAParser.extract_dn((String)string3, (LdapConfigInteger)new LdapConfigInteger(0));
                        if (string16 == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("rootdn:Invalid DN"));
                            continue;
                        }
                        string16 = LDAParser.remove_backslash((String)string16);
                        try {
                            string16 = LDADnChecker.getRDNAt((String)string16, (int)0);
                            string16 = string16.substring(string16.indexOf("=") + 1);
                            string16 = string16.trim();
                        }
                        catch (LdapConfigException ldapConfigException) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("rootdn:Invalid DN (2)"));
                            continue;
                        }
                        this.globalConf.security_service.rootdn = string16;
                        continue;
                    }
                    if (string4.equals("rootpw")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                        String string17 = stringTokenizer.nextToken();
                        if (string17 == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Missing admin password"));
                            continue;
                        }
                        if (this.globalConf.security_service.root_password.equals("")) {
                            this.globalConf.security_service.root_password = string17;
                            ldbmBackend.rootpw = string17;
                        } else {
                            ldbmBackend.rootpw = this.globalConf.security_service.root_password;
                        }
                        if (this.globalConf.security_service.root_password.startsWith("{crypt}")) {
                            this.globalConf.security_service.root_password_tag = "{crypt}";
                            continue;
                        }
                        if (this.globalConf.security_service.root_password.startsWith("{sunds}")) {
                            this.globalConf.security_service.root_password_tag = "{sunds}";
                            continue;
                        }
                        this.globalConf.security_service.root_password_tag = "";
                        continue;
                    }
                    if (string4.equals("diskspace")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 3, 3)) continue;
                        try {
                            ldbmBackend.critical = Integer.parseInt(stringTokenizer.nextToken());
                            ldbmBackend.congested = Integer.parseInt(stringTokenizer.nextToken());
                            ldbmBackend.back_to_normal = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        catch (Exception exception) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid diskspace values"));
                        }
                        continue;
                    }
                    if (string4.equals("rootkrbname")) continue;
                    if (string4.equals("suffix")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 100)) continue;
                        String string18 = LDAParser.extract_dn((String)string3, (LdapConfigInteger)new LdapConfigInteger(0));
                        if (string18.equals("")) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid DN"));
                            continue;
                        }
                        ldbmBackend.suffix.addElement(string18);
                        continue;
                    }
                    if (string4.equals("updatedn")) {
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1000)) continue;
                        String string19 = LDAParser.extract_dn((String)string3, (LdapConfigInteger)new LdapConfigInteger(0));
                        if (string19.equals("")) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid DN"));
                            continue;
                        }
                        ldbmBackend.upd_dn = string19;
                        ldbmBackend.master = false;
                        if (!ldbmBackend.mastername.equals("")) continue;
                        try {
                            ldbmBackend.mastername = this.globalConf.ldap_service.referral.substring(this.globalConf.ldap_service.referral.lastIndexOf("ldap://") + 7);
                            int n17 = ldbmBackend.mastername.indexOf(":");
                            if (n17 < 0) continue;
                            ldbmBackend.mastername = ldbmBackend.mastername.substring(0, n17);
                        }
                        catch (Exception exception) {
                            LDADebug.printStackTrace((Exception)exception);
                        }
                        continue;
                    }
                    if (string4.equals("pull_replica")) {
                        replHost = null;
                        lDAReplicaItem = null;
                        lDASubtreeItem = null;
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                        String string20 = stringTokenizer.nextToken();
                        if (!string20.startsWith("host=")) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid pull_replica specification"));
                            continue;
                        }
                        lDASubtreeItem = new LDASubtreeItem();
                        string20 = string20.substring(5);
                        stringTokenizer = new StringTokenizer(string20, ":");
                        lDASubtreeItem.host = stringTokenizer.nextToken();
                        lDASubtreeItem.port = 389;
                        if (stringTokenizer.hasMoreTokens()) {
                            try {
                                lDASubtreeItem.port = Integer.parseInt(stringTokenizer.nextToken());
                            }
                            catch (Exception exception) {
                                this.report_error(string2, lineNumberReader, this.cat.gets("Invalid pull_replica port. Use 389"));
                            }
                        }
                        lDASubtreeItem.mode = 2;
                        lDASubtreeItem.client_replication = true;
                        ldbmBackend.subtree.addElement(lDASubtreeItem);
                        continue;
                    }
                    if (string4.equals("replica") || string4.equals("push_replica")) {
                        lDASubtreeItem = null;
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) continue;
                        String string21 = stringTokenizer.nextToken();
                        if (!string21.startsWith("host=")) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid replica specification"));
                            continue;
                        }
                        replHost = new ReplHost();
                        string21 = string21.substring(5);
                        stringTokenizer = new StringTokenizer(string21, ":");
                        replHost.host = stringTokenizer.nextToken();
                        replHost.port = 389;
                        if (stringTokenizer.hasMoreTokens()) {
                            try {
                                replHost.port = Integer.parseInt(stringTokenizer.nextToken());
                            }
                            catch (Exception exception) {
                                this.report_error(string2, lineNumberReader, this.cat.gets("Invalid replica port. Use 389"));
                            }
                        }
                        ldbmBackend.replica.addElement(replHost);
                        lDAReplicaItem = new LDAReplicaItem();
                        lDAReplicaItem.host = replHost.host;
                        lDAReplicaItem.port = replHost.port;
                        ldbmBackend.new_replica.addElement(lDAReplicaItem);
                        continue;
                    }
                    if (string4.startsWith("timeout=")) {
                        if (lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid timeout clause"));
                            continue;
                        }
                        try {
                            lDASubtreeItem.timeout = Integer.parseInt(string4.substring(8));
                        }
                        catch (Exception exception) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid timeout value"));
                            lDASubtreeItem.timeout = 60;
                        }
                        continue;
                    }
                    if (string4.startsWith("pollat=")) {
                        if (lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid pollat clause"));
                            continue;
                        }
                        lDASubtreeItem.pollat = string4.substring(7);
                        continue;
                    }
                    if (string4.startsWith("pollevery=")) {
                        if (lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid pollevery clause"));
                            continue;
                        }
                        lDASubtreeItem.pollevery = string4.substring(10);
                        continue;
                    }
                    if (string4.startsWith("filter=")) {
                        if (lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid filter clause"));
                            continue;
                        }
                        String string22 = string3.substring(string3.indexOf(string4) + 7);
                        lDASubtreeItem.filter = this.extract_filter(string22, new LdapConfigInteger(0));
                        if (lDASubtreeItem.filter != null) continue;
                        this.report_error(string2, lineNumberReader, this.cat.gets("Invalid filter"));
                        lDASubtreeItem.filter = "";
                        continue;
                    }
                    if (string4.startsWith("local-filter=")) {
                        if (lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid local-filter clause"));
                            continue;
                        }
                        String string23 = string3.substring(string3.indexOf(string4) + 13);
                        lDASubtreeItem.local_filter = this.extract_filter(string23, new LdapConfigInteger(0));
                        if (lDASubtreeItem.local_filter != null) continue;
                        this.report_error(string2, lineNumberReader, this.cat.gets("Invalid filter"));
                        lDASubtreeItem.local_filter = "";
                        continue;
                    }
                    if (string4.startsWith("inclattr=")) {
                        if (lDAReplicaItem == null && lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid inclattr clause"));
                            continue;
                        }
                        Attr attr = new Attr();
                        Vector vector = new Vector();
                        try {
                            vector = attr.attrName2Vector(string4.substring(9), false);
                        }
                        catch (Exception exception) {
                            LDADebug.printStackTrace((Exception)exception);
                        }
                        if (lDAReplicaItem != null) {
                            lDAReplicaItem.atttype = 2;
                            if (lDAReplicaItem.attributes.size() == 0) {
                                lDAReplicaItem.attributes = vector;
                                continue;
                            }
                            Enumeration enumeration = vector.elements();
                            while (true) {
                                if (!enumeration.hasMoreElements()) continue block44;
                                lDAReplicaItem.attributes.addElement(enumeration.nextElement());
                            }
                        }
                        lDASubtreeItem.atttype = 2;
                        if (lDASubtreeItem.attributes.size() == 0) {
                            lDASubtreeItem.attributes = vector;
                            continue;
                        }
                        Enumeration enumeration = vector.elements();
                        while (true) {
                            if (!enumeration.hasMoreElements()) continue block44;
                            lDASubtreeItem.attributes.addElement(enumeration.nextElement());
                        }
                    }
                    if (string4.startsWith("exclattr=")) {
                        if (lDAReplicaItem == null && lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid exclattr clause"));
                            continue;
                        }
                        Attr attr = new Attr();
                        Vector vector = new Vector();
                        try {
                            vector = attr.attrName2Vector(string4.substring(9), false);
                        }
                        catch (Exception exception) {}
                        if (lDAReplicaItem != null) {
                            lDAReplicaItem.atttype = 1;
                            if (lDAReplicaItem.attributes.size() == 0) {
                                lDAReplicaItem.attributes = vector;
                                continue;
                            }
                            Enumeration enumeration = vector.elements();
                            while (true) {
                                if (!enumeration.hasMoreElements()) continue block44;
                                lDAReplicaItem.attributes.addElement(enumeration.nextElement());
                            }
                        }
                        lDASubtreeItem.atttype = 1;
                        if (lDASubtreeItem.attributes.size() == 0) {
                            lDASubtreeItem.attributes = vector;
                            continue;
                        }
                        Enumeration enumeration = vector.elements();
                        while (true) {
                            if (!enumeration.hasMoreElements()) continue block44;
                            lDASubtreeItem.attributes.addElement(enumeration.nextElement());
                        }
                    }
                    if (string4.startsWith("subtree=")) {
                        String string24 = LDAParser.extract_dn((String)string3, (LdapConfigInteger)new LdapConfigInteger(0));
                        if (string24.equals("")) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid DN"));
                            continue;
                        }
                        if (lDAReplicaItem != null) {
                            lDAReplicaItem.subtree_suffixes.addElement(string24);
                            continue;
                        }
                        if (lDASubtreeItem != null) {
                            lDASubtreeItem.subtree_suffixes.addElement(string24);
                            continue;
                        }
                        this.report_error(string2, lineNumberReader, this.cat.gets("Invalid subtree clause"));
                        continue;
                    }
                    if (string4.startsWith("object=")) {
                        String string25 = LDAParser.extract_dn((String)string3, (LdapConfigInteger)new LdapConfigInteger(0));
                        if (string25.equals("")) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid DN"));
                            continue;
                        }
                        if (lDAReplicaItem != null) {
                            lDAReplicaItem.object_suffixes.addElement(string25);
                            continue;
                        }
                        if (lDASubtreeItem != null) {
                            lDASubtreeItem.object_suffixes.addElement(string25);
                            continue;
                        }
                        this.report_error(string2, lineNumberReader, this.cat.gets("Invalid subtree clause"));
                        continue;
                    }
                    if (string4.equals("master")) {
                        lDAReplicaItem = null;
                        replHost = null;
                        lDASubtreeItem = new LDASubtreeItem();
                        lDASubtreeItem.mode = 1;
                        ldbmBackend.subtree.addElement(lDASubtreeItem);
                        continue;
                    }
                    if (string4.equals("slave")) {
                        lDAReplicaItem = null;
                        replHost = null;
                        lDASubtreeItem = new LDASubtreeItem();
                        lDASubtreeItem.mode = 2;
                        ldbmBackend.subtree.addElement(lDASubtreeItem);
                        continue;
                    }
                    if (string4.startsWith("replicadn=")) {
                        if (lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid replicadn clause"));
                            continue;
                        }
                        String string26 = LDAParser.extract_dn((String)string3, (LdapConfigInteger)new LdapConfigInteger(0));
                        if (string26.equals("")) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid DN"));
                            continue;
                        }
                        lDASubtreeItem.updateDn = string26;
                        continue;
                    }
                    if (string4.startsWith("referral=")) {
                        int n18;
                        if (lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid referral clause"));
                            continue;
                        }
                        lDASubtreeItem.host = string3.substring(string3.lastIndexOf("ldap://") + 7);
                        lDASubtreeItem.host = lDASubtreeItem.host.trim();
                        if (lDASubtreeItem.host.endsWith("\"")) {
                            lDASubtreeItem.host = lDASubtreeItem.host.substring(0, lDASubtreeItem.host.length() - 1);
                        }
                        if ((n18 = lDASubtreeItem.host.lastIndexOf(":")) < 0) continue;
                        try {
                            lDASubtreeItem.port = Integer.parseInt(lDASubtreeItem.host.substring(n18 + 1));
                        }
                        catch (Exception exception) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid ldap port in url"));
                            lDASubtreeItem.port = 389;
                        }
                        lDASubtreeItem.host = lDASubtreeItem.host.substring(0, n18);
                        continue;
                    }
                    if (string4.startsWith("binddn=")) {
                        if (replHost == null && lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid binddn clause not in a replica clause"));
                            continue;
                        }
                        String string27 = LDAParser.extract_dn((String)string3, (LdapConfigInteger)new LdapConfigInteger(0));
                        if (replHost != null) {
                            replHost.binddn = string27;
                            lDAReplicaItem.updateDn = string27;
                            continue;
                        }
                        string27.equals("");
                        lDASubtreeItem.binddn = string27;
                        continue;
                    }
                    if (string4.startsWith("bindmethod=")) {
                        if (lDAReplicaItem == null && lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid bindmethod clause not in a replica clause"));
                            continue;
                        }
                        String string28 = string4.substring(string4.indexOf("bindmethod=") + 11).trim().toLowerCase();
                        if (string28.equals("simple")) {
                            string28 = "simple";
                        } else if (string28.equals("sasl(cram-md5)")) {
                            string28 = "sasl(cram-md5)";
                        } else if (string28.equals("sasl(external)")) {
                            string28 = "sasl(external)";
                        } else if (string28.startsWith("sasl")) {
                            string28 = "sasl";
                        } else {
                            this.report_error(string2, lineNumberReader, this.cat.gets("bind method not supported"));
                            string28 = "simple";
                        }
                        if (lDAReplicaItem != null) {
                            lDAReplicaItem.bindmethod = string28;
                            continue;
                        }
                        lDASubtreeItem.bindmethod = string28;
                        continue;
                    }
                    if (string4.startsWith("ldapsecurity=")) {
                        if (lDAReplicaItem == null && lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("ldapsecurity clause not in a replica clause"));
                            continue;
                        }
                        String string29 = "insecure";
                        String string30 = "";
                        if ((string4 = string4.substring(13)).startsWith("insecure")) {
                            string29 = "insecure";
                        } else if (string4.startsWith("sslport")) {
                            string29 = "sslport";
                            int n19 = string4.indexOf("(");
                            bl5 = string4.indexOf(")");
                            if (n19 >= 0 && bl5 >= false) {
                                string30 = string4.substring(n19 + 1, bl5 ? 1 : 0);
                            }
                        } else if (string4.startsWith("tls")) {
                            string29 = "tls";
                            int n20 = string4.indexOf("(");
                            bl5 = string4.indexOf(")");
                            if (n20 >= 0 && bl5 >= false) {
                                string30 = string4.substring(n20 + 1, bl5 ? 1 : 0);
                            }
                        } else {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Missing security mode. Set to insecure."));
                        }
                        if (lDAReplicaItem != null) {
                            lDAReplicaItem.securitymode = string29;
                            lDAReplicaItem.sslpkg = string30;
                            continue;
                        }
                        lDASubtreeItem.securitymode = string29;
                        lDASubtreeItem.sslpkg = string30;
                        continue;
                    }
                    if (string4.startsWith("credentials=")) {
                        if (replHost == null && lDASubtreeItem == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid credentials clause not in a replica clause"));
                            continue;
                        }
                        String string31 = string4.substring(12);
                        if (replHost != null) {
                            replHost.cred_data = string31;
                            lDAReplicaItem.password = string31;
                            continue;
                        }
                        lDASubtreeItem.password = string31;
                        continue;
                    }
                    if (string4.startsWith("srvtab=")) {
                        String string32;
                        if (replHost == null) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid srvtab clause out of a replica clause"));
                            continue;
                        }
                        if (!replHost.kerberos) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Inconsistent bind method"));
                        }
                        replHost.cred_data = string32 = string4.substring(7);
                        continue;
                    }
                    if (string4.equals("database")) {
                        string = string3;
                        continue block38;
                    }
                    if (string4.equals("cachesize")) {
                        if (!(ldbmBackend instanceof LdbmBackend)) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid cache size clause ignored."));
                            continue;
                        }
                        ldbmBackend.cache = 1000;
                        try {
                            ldbmBackend.cache = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        catch (Exception exception) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid cache size"));
                        }
                        continue;
                    }
                    if (string4.equals("dbcachesize")) {
                        if (!(ldbmBackend instanceof LdbmBackend)) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid dbcache size clause ignored."));
                            continue;
                        }
                        ldbmBackend.dbcache = 100000;
                        try {
                            ldbmBackend.dbcache = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        catch (Exception exception) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid dbcachesize"));
                        }
                        continue;
                    }
                    if (string4.equals("directory")) {
                        if (!(ldbmBackend instanceof LdbmBackend)) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid directory clause ignored."));
                            continue;
                        }
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 1)) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid directory directory. Use /tmp/dbm"));
                            ldbmBackend.dbdir = "/tmp/dbm";
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            ldbmBackend.dbdir = stringTokenizer.nextToken();
                            continue;
                        }
                        this.report_error(string2, lineNumberReader, this.cat.gets("Missing directory. Use /tmp/dbm"));
                        ldbmBackend.dbdir = "/tmp/dbm";
                        continue;
                    }
                    if (string4.equals("mode")) {
                        if (!(ldbmBackend instanceof LdbmBackend)) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid mode clause ignored."));
                            continue;
                        }
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        ldbmBackend.mode = stringTokenizer.nextToken();
                        continue;
                    }
                    if (string4.equals("index")) {
                        String string33;
                        if (!(ldbmBackend instanceof LdbmBackend)) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid index clause ignored."));
                            continue;
                        }
                        if (!this.check_token_count(lineNumberReader, stringTokenizer, 1, 2)) {
                            this.report_error(string2, lineNumberReader, this.cat.gets("Invalid index clause ignored."));
                        }
                        String string34 = stringTokenizer.nextToken();
                        String string35 = "";
                        boolean bl6 = false;
                        bl5 = false;
                        bl = false;
                        boolean bl7 = false;
                        n2 = 0;
                        if (stringTokenizer.hasMoreTokens()) {
                            string35 = stringTokenizer.nextToken();
                        }
                        if (string35 == "") {
                            bl6 = true;
                            bl5 = true;
                            bl = true;
                            bl7 = true;
                            n2 = 0;
                        } else {
                            stringTokenizer = new StringTokenizer(string35, ",");
                            string33 = "";
                            while (stringTokenizer.hasMoreTokens()) {
                                string33 = stringTokenizer.nextToken();
                                if (string33.equals("eq")) {
                                    bl5 = true;
                                    continue;
                                }
                                if (string33.equals("sub")) {
                                    bl = true;
                                    continue;
                                }
                                if (string33.equals("approx")) {
                                    bl7 = true;
                                    continue;
                                }
                                if (string33.equals("pres")) {
                                    bl6 = true;
                                    continue;
                                }
                                if (string33.equals("none")) {
                                    n2 = 1;
                                    continue;
                                }
                                this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : invalid index. Assume no index"), (String)string33));
                                n2 = 1;
                            }
                        }
                        stringTokenizer = new StringTokenizer(string34, ",");
                        LDAIndexItem lDAIndexItem = null;
                        while (stringTokenizer.hasMoreTokens()) {
                            string33 = stringTokenizer.nextToken();
                            if (lDAIndexItem == null) {
                                lDAIndexItem = new LDAIndexItem(string33, bl6, bl5, bl, bl7, n2 != 0);
                                ldbmBackend.indexes.addElement(lDAIndexItem);
                            } else {
                                lDAIndexItem.names.addElement(string33);
                            }
                            if (string33.equals("default")) continue;
                            this.check_and_add_attribute(string2, lineNumberReader, string33, null, 0, null, 64, null, false);
                        }
                        lDAIndexItem = null;
                        continue;
                    }
                    this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : Invalid token"), (String)string4));
                }
            }
            this.report_error(string2, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : Invalid token"), (String)string4));
        }
        object = this.globalConf.ocl.elements();
        while (object.hasMoreElements()) {
            ClassItem classItem = (ClassItem)object.nextElement();
            if (classItem.superior == null || classItem.superior.equals("top") || this.globalConf.ocl.getClassItemFromName(classItem.superior) != null) continue;
            this.report_error(string2, null, LDACatalog.printf((String)this.cat.gets("invalid superior value for class %1 (superior %2 does not exist). Object class removed."), (String)classItem.name, (String)classItem.superior));
            this.globalConf.ocl.delClassItem(classItem);
        }
    }

    private void process_access_by(String string, String string2, LineNumberReader lineNumberReader, StringTokenizer stringTokenizer, AclWhat aclWhat) {
        String string3;
        if (!this.check_token_count(lineNumberReader, stringTokenizer, 2, 1000)) {
            return;
        }
        if (aclWhat == null) {
            this.report_error(string, lineNumberReader, this.cat.gets("Invalid by clause"));
            return;
        }
        String string4 = stringTokenizer.nextToken();
        AclBy aclBy = new AclBy();
        if (string4.equals("*")) {
            aclBy.type = 1;
            string2 = string2.substring(string2.indexOf("*") + 1);
        } else if (string4.equals("self")) {
            aclBy.type = 2;
            string2 = string2.substring(string2.indexOf("self") + 4);
        } else if (string4.startsWith("addr=")) {
            LdapConfigInteger ldapConfigInteger;
            aclBy.type = 4;
            string3 = this.extract_address(string2 = string2.substring(string2.indexOf("addr=") + 5), ldapConfigInteger = new LdapConfigInteger(0));
            if (string3 == null) {
                this.report_error(string, lineNumberReader, this.cat.gets("Invalid address. Ignore by clause."));
                return;
            }
            aclBy.regex = string3;
            string2 = this.skip(string2, ldapConfigInteger);
        } else if (string4.startsWith("domain=")) {
            LdapConfigInteger ldapConfigInteger;
            aclBy.type = 5;
            string3 = this.extract_domain(string2 = string2.substring(string2.indexOf("domain=") + 7), ldapConfigInteger = new LdapConfigInteger(0));
            if (string3 == null) {
                this.report_error(string, lineNumberReader, this.cat.gets("Invalid domain. Ignore by clause."));
                return;
            }
            aclBy.regex = string3;
            string2 = this.skip(string2, ldapConfigInteger);
        } else if (string4.startsWith("dn=")) {
            aclBy.type = 3;
            String string5 = LDAParser.extract_dn((String)(string2 = string2.substring(string2.indexOf("dn=") + 3)), (LdapConfigInteger)(string3 = new LdapConfigInteger(0)));
            if (string5 == null) {
                String string6 = "";
                String[] stringArray = new String[]{"none", "compare", "read", "search", "write"};
                String string7 = string2.trim();
                int n = 0;
                while (n < 5) {
                    if (string7.endsWith(stringArray[n])) {
                        string5 = string7.substring(0, string7.lastIndexOf(stringArray[n]));
                        string6 = stringArray[n];
                        break;
                    }
                    ++n;
                }
                if (string5 == null) {
                    this.report_error(string, lineNumberReader, this.cat.gets("Invalid dn. Ignore by clause."));
                    return;
                }
                string2 = string6;
                aclBy.regex = string5.trim();
            } else {
                string2 = this.skip(string2, (LdapConfigInteger)string3);
                aclBy.regex = string5;
            }
        } else if (string4.startsWith("dnattr=")) {
            LdapConfigInteger ldapConfigInteger;
            aclBy.type = 6;
            string3 = this.extract_dnattr(string2 = string2.substring(string2.indexOf("dnattr=") + 7), ldapConfigInteger = new LdapConfigInteger(0));
            if (string3 == null) {
                this.report_error(string, lineNumberReader, this.cat.gets("Invalid dnattr. Ignore by clause."));
                return;
            }
            aclBy.regex = string3;
            string2 = this.skip(string2, ldapConfigInteger);
            this.check_and_add_attribute(string, lineNumberReader, string3, null, 0, null, 64, null, false);
        } else {
            this.report_error(string, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : Invalid token in access clause"), (String)string4));
            return;
        }
        stringTokenizer = new StringTokenizer(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            this.report_error(string, lineNumberReader, this.cat.gets("Missing access right"));
            return;
        }
        string3 = stringTokenizer.nextToken();
        if (string3.equals("none")) {
            aclBy.access = new Access("NONE");
        } else if (string3.equals("selfnone")) {
            aclBy.access = new Access("NONE");
        } else if (string3.equals("compare")) {
            aclBy.access = new Access("COMPARE");
        } else if (string3.equals("selfcompare")) {
            aclBy.access = new Access("COMPARE");
        } else if (string3.equals("search")) {
            aclBy.access = new Access("SEARCH");
        } else if (string3.equals("selfsearch")) {
            aclBy.access = new Access("SEARCH");
        } else if (string3.equals("read")) {
            aclBy.access = new Access("READ");
        } else if (string3.equals("selfread")) {
            aclBy.access = new Access("READ");
        } else if (string3.equals("write")) {
            aclBy.access = new Access("WRITE");
        } else if (string3.equals("selfwrite")) {
            aclBy.access = new Access("WRITE");
        } else {
            this.report_error(string, lineNumberReader, LDACatalog.printf((String)this.cat.gets("%1 : Invalid access rights. Ignore by clause."), (String)string3));
            return;
        }
        aclWhat.by.addElement(aclBy);
    }

    private String skip(String string, LdapConfigInteger ldapConfigInteger) {
        return string.substring(ldapConfigInteger.intValue());
    }

    private Vector process_access_what(String string, String string2, LineNumberReader lineNumberReader, StringTokenizer stringTokenizer) {
        Object object;
        if (!this.check_token_count(lineNumberReader, stringTokenizer, 2, 1000)) {
            return null;
        }
        if (!stringTokenizer.nextToken().equals("to")) {
            this.report_error(string, lineNumberReader, this.cat.gets("<to> token missing"));
            return null;
        }
        AclWhat aclWhat = new AclWhat();
        aclWhat.comments = this.getObjectComments();
        String string3 = stringTokenizer.nextToken();
        if (string3.equals("*")) {
            aclWhat.type = 1;
            string2 = string2.substring(string2.indexOf("*") + 1);
        } else {
            int n;
            Object object2;
            LdapConfigInteger ldapConfigInteger;
            if (string3.startsWith("dn=")) {
                ldapConfigInteger = new LdapConfigInteger(0);
                object = string2;
                if (string2.lastIndexOf("dn=") != string2.indexOf("dn=")) {
                    object = string2.substring(0, string2.lastIndexOf("dn=") - 1);
                } else if (string2.indexOf("filter=") > 0) {
                    object = string2.substring(0, string2.indexOf("filter=") - 1);
                    string3 = string2.substring(string2.indexOf("filter="));
                }
                object2 = LDAParser.extract_dn((String)object, (LdapConfigInteger)ldapConfigInteger);
                if (object2 == null) {
                    this.report_error(string, lineNumberReader, this.cat.gets("Invalid DN"));
                    return null;
                }
                string2 = this.skip(string2, ldapConfigInteger);
                aclWhat.regex = object2;
                aclWhat.type = 2;
            }
            if (string3.startsWith("filter=")) {
                ldapConfigInteger = new LdapConfigInteger(0);
                object = string2;
                if (string2.indexOf("dn=") > 0) {
                    object = string2.substring(0, string2.indexOf("dn=") - 1);
                }
                if ((object2 = this.extract_filter((String)object, ldapConfigInteger)) == null) {
                    this.report_error(string, lineNumberReader, this.cat.gets("Invalid filter"));
                    return null;
                }
                aclWhat.filter = object2;
                aclWhat.type = 3;
                string2 = this.skip(string2, ldapConfigInteger);
            }
            if ((n = string2.indexOf("attrs=")) >= 0) {
                object2 = this.extract_attributes(string2 = string2.substring(n + 6), (LdapConfigInteger)(object = new LdapConfigInteger(0)));
                if (object2 == null) {
                    this.report_error(string, lineNumberReader, this.cat.gets("Invalid attribute list"));
                    return null;
                }
                string2 = this.skip(string2, (LdapConfigInteger)object);
                aclWhat.attr = object2;
                if (aclWhat.type != 2 && aclWhat.type != 3) {
                    aclWhat.type = 1;
                }
                int n2 = 0;
                while (n2 < ((Vector)object2).size()) {
                    if (((String)((Vector)object2).elementAt(n2)).equalsIgnoreCase("entry")) {
                        ((Vector)object2).removeElementAt(n2);
                    } else {
                        this.check_and_add_attribute(string, lineNumberReader, (String)((Vector)object2).elementAt(n2), null, 0, null, 64, null, false);
                    }
                    ++n2;
                }
            }
        }
        String string4 = null;
        if (string2.indexOf("by") >= 0) {
            string4 = string2.substring(string2.indexOf("by"));
        }
        object = new Vector();
        ((Vector)object).addElement(string2);
        ((Vector)object).addElement(string4);
        ((Vector)object).addElement(aclWhat);
        return object;
    }

    private void report_error(String string, LineNumberReader lineNumberReader, String string2) {
        this.errorWhileLoadingConf = true;
        String string3 = lineNumberReader != null ? Integer.toString(lineNumberReader.getLineNumber()) : "?";
        this.log(LDACatalog.printf((String)this.cat.gets("Error found in file %1 at line %2 : %3"), (String)string, (String)string3, (String)string2));
    }

    private boolean check_token_count(LineNumberReader lineNumberReader, StringTokenizer stringTokenizer, int n, int n2) {
        int n3 = stringTokenizer.countTokens();
        if (n3 < n) {
            this.log(LDACatalog.printf((String)this.cat.gets("Error found while parsing line %1 : missing token\n"), (String)Integer.toString(lineNumberReader.getLineNumber())));
            this.errorWhileLoadingConf = true;
            return false;
        }
        if (n3 > n2) {
            this.log(LDACatalog.printf((String)this.cat.gets("Error found while parsing line %1 : Extra token ignored\n"), (String)Integer.toString(lineNumberReader.getLineNumber())));
            this.errorWhileLoadingConf = true;
            return false;
        }
        return true;
    }

    private static String extract_dn(String string, LdapConfigInteger ldapConfigInteger) {
        String string2 = null;
        int n = string.indexOf("\"");
        if (n < 0) {
            return null;
        }
        string = string.substring(n + 1);
        if (string.lastIndexOf("\"") < 0) {
            return null;
        }
        string2 = string.substring(0, string.lastIndexOf("\""));
        ldapConfigInteger.setValue(n + 1 + string.lastIndexOf("\"") + 1);
        return string2;
    }

    private String extract_address(String string, LdapConfigInteger ldapConfigInteger) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string2 = stringTokenizer.nextToken();
        ldapConfigInteger.setValue(string.indexOf(string2) + string2.length());
        return string2;
    }

    private String extract_domain(String string, LdapConfigInteger ldapConfigInteger) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string2 = stringTokenizer.nextToken();
        ldapConfigInteger.setValue(string.indexOf(string2) + string2.length());
        return string2;
    }

    private String extract_dnattr(String string, LdapConfigInteger ldapConfigInteger) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string2 = stringTokenizer.nextToken();
        ldapConfigInteger.setValue(string.indexOf(string2) + string2.length());
        return string2;
    }

    private String extract_filter(String string, LdapConfigInteger ldapConfigInteger) {
        String string2 = null;
        int n = string.indexOf("\"");
        if (n < 0) {
            if (string.trim().equals("")) {
                return null;
            }
            return string;
        }
        string = string.substring(n + 1);
        if (string.lastIndexOf("\"") < 0) {
            return null;
        }
        string2 = string.substring(0, string.lastIndexOf("\""));
        ldapConfigInteger.setValue(n + 1 + string.lastIndexOf("\"") + 1);
        return LDAParser.remove_backslash((String)string2);
    }

    private Vector extract_attributes(String string, LdapConfigInteger ldapConfigInteger) {
        StringTokenizer stringTokenizer = new StringTokenizer(new String(string));
        String string2 = "";
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string2 = stringTokenizer.nextToken();
        ldapConfigInteger.setValue(string.indexOf(string2) + string2.length());
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer2.hasMoreTokens()) {
            vector.addElement(stringTokenizer2.nextToken());
        }
        if (vector.size() <= 0) {
            return null;
        }
        return vector;
    }

    private AttrItem check_and_add_attribute(String string, LineNumberReader lineNumberReader, String string2, Vector vector, int n, String string3, int n2, String string4, boolean bl) {
        if (string2.equals("*")) {
            return null;
        }
        AttrItem attrItem = this.globalConf.attributes.getAttributeFromName(string2);
        if (attrItem == null && (attrItem = this.globalConf.attributes.getAttributeFromAlias(string2)) == null) {
            AttrItem attrItem2 = new AttrItem(string2, vector, n, string3, n2);
            this.globalConf.attributes.addElement(attrItem2);
            StringBuffer stringBuffer = this.getSectionComments();
            if (stringBuffer != null) {
                this.globalConf.attributes.comments = stringBuffer;
            }
            attrItem2.comments = this.getObjectComments();
            attrItem2.oid = string4;
            attrItem2.single = bl;
            return attrItem2;
        }
        if (n != 0) {
            attrItem.syntax = n;
        }
        if (string3 != null) {
            attrItem.size = n2;
            attrItem.naming_class = string3;
            attrItem.naming = true;
        }
        if (string4 != null) {
            attrItem.oid = string4;
        }
        if (bl) {
            attrItem.single = true;
        }
        if (vector != null) {
            if (attrItem.aliases == null) {
                attrItem.aliases = vector;
            } else {
                int n3 = 0;
                while (n3 < vector.size()) {
                    attrItem.aliases.addElement(vector.elementAt(n3));
                    ++n3;
                }
            }
        }
        return null;
    }

    private void log(String string) {
        try {
            this.logstream.write(String.valueOf(string) + "\n");
            return;
        }
        catch (Exception exception) {
            System.err.println(string);
            return;
        }
    }

    private String access_to_string(Access access) {
        if (access.equals(new Access(1))) {
            return "none";
        }
        if (access.equals(new Access(0))) {
            return "selfnone";
        }
        if (access.equals(new Access(7))) {
            return "read";
        }
        if (access.equals(new Access(6))) {
            return "selfread";
        }
        if (access.equals(new Access(5))) {
            return "search";
        }
        if (access.equals(new Access(4))) {
            return "selfsearch";
        }
        if (access.equals(new Access(3))) {
            return "compare";
        }
        if (access.equals(new Access(2))) {
            return "selfcompare";
        }
        if (access.equals(new Access(9))) {
            return "write";
        }
        if (access.equals(new Access(8))) {
            return "selfwrite";
        }
        return "none";
    }

    private String generate_aclatt(Vector vector, boolean bl) {
        Enumeration enumeration = vector.elements();
        String string = "attrs=";
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + enumeration.nextElement();
            if (!enumeration.hasMoreElements()) continue;
            string = String.valueOf(string) + ",";
        }
        if (bl) {
            string = String.valueOf(string) + ",entry";
        }
        return string;
    }

    private String generate_dn(String string) {
        return "dn=\"" + string + "\"";
    }

    private String generate_filter(String string) {
        return "filter=\"" + LDAParser.add_backslash((String)string) + "\"";
    }

    private StringBuffer getObjectComments() {
        if (this.currentComments == null) {
            return null;
        }
        StringBuffer stringBuffer = this.getSectionComments();
        StringBuffer stringBuffer2 = this.currentComments;
        this.currentComments = stringBuffer != null ? stringBuffer : null;
        return stringBuffer2;
    }

    private StringBuffer getSectionComments() {
        if (this.currentComments == null) {
            return null;
        }
        int n = this.currentComments.toString().indexOf("Section");
        if (n >= 0) {
            String string = this.currentComments.toString().substring(0, n + "Section".length());
            String string2 = this.currentComments.toString().substring(n + "Section".length());
            int n2 = string2.indexOf("\n\n");
            if (n2 >= 0) {
                string = String.valueOf(string) + string2.substring(0, n2 + 2);
                string2 = string2.substring(n2 + 2);
                this.currentComments = new StringBuffer(string2);
            } else {
                string = this.currentComments.toString();
                this.currentComments = null;
            }
            return new StringBuffer(string);
        }
        return null;
    }

    private StringBuffer getCurrentComments() {
        StringBuffer stringBuffer = this.currentComments;
        this.currentComments = null;
        return stringBuffer;
    }

    private String get_next_line(LineNumberReader lineNumberReader) throws IOException {
        String string;
        this.currentComments = null;
        while ((string = lineNumberReader.readLine()) != null) {
            if (string == null) continue;
            if (string.startsWith("#")) {
                if (this.currentComments == null) {
                    this.currentComments = new StringBuffer(String.valueOf(string) + "\n");
                    continue;
                }
                this.currentComments.append(String.valueOf(string) + "\n");
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreTokens()) {
                return string;
            }
            if (this.currentComments == null) {
                this.currentComments = new StringBuffer(String.valueOf(string) + "\n");
                continue;
            }
            this.currentComments.append(String.valueOf(string) + "\n");
        }
        return null;
    }

    private void expandAliases(ClassItem classItem, boolean bl) {
        Vector vector = bl ? classItem.required : classItem.allowed;
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            AttrItem attrItem;
            AttrItem attrItem2 = (AttrItem)vector.elementAt(n2);
            if (this.globalConf.attributes.getAttributeFromName(attrItem2.name) == null && (attrItem = this.globalConf.attributes.getAttributeFromAlias(attrItem2.name)) != null) {
                vector.removeElementAt(n2);
                attrItem2 = (AttrItem)attrItem.clone();
                attrItem2.name = attrItem.name;
                vector.insertElementAt(attrItem2, n2);
            }
            ++n2;
        }
    }

    public void updateSchedule(MainConf mainConf) throws LdapConfigException {
        Task task;
        LDADebug.debug((Object)"LDAParser:updateSchedule");
        Scheduler scheduler = this.server.getScheduler(null);
        if (scheduler == null) {
            throw new LdapConfigException(this.cat.gets("No scheduler"));
        }
        boolean bl = false;
        boolean bl2 = false;
        if (mainConf.task.type != 0) {
            if (this.dspushd_task != null) {
                try {
                    LDADebug.debug((Object)"LDAParser:updateSchedule:deleteTask (dspushd)");
                    scheduler.deleteTask(this.dspushd_task.getTaskID());
                }
                catch (Exception exception) {
                    LDADebug.printStackTrace((Exception)exception);
                }
                this.dspushd_task = null;
            }
            bl = true;
        }
        if (mainConf.task_cr.type != 0) {
            if (this.dspulld_task != null) {
                try {
                    LDADebug.debug((Object)"LDAParser:updateSchedule:deleteTask (dspulld)");
                    scheduler.deleteTask(this.dspulld_task.getTaskID());
                }
                catch (Exception exception) {
                    LDADebug.printStackTrace((Exception)exception);
                }
                this.dspulld_task = null;
            }
            bl2 = true;
        }
        try {
            if (!bl) {
                if (this.dspushd_task != null) {
                    this.dspushd_task.setMinute(mainConf.task.minutes);
                    this.dspushd_task.setHour(mainConf.task.hours);
                    this.dspushd_task.setDayOfWeek(mainConf.task.dayOfWeek);
                    this.dspushd_task.setCommand(LDAConstants.startSlurpdOneShotCommand);
                    this.dspushd_task.setStatus(true);
                    LDADebug.debug((Object)"LDAParser:updateSchedule:modifyTask (dspushd)");
                    scheduler.modifyTask(this.dspushd_task.getTaskID(), this.dspushd_task);
                } else {
                    task = new Task("LDAP_DIRECTORY", "dspushd");
                    task.setMinute(mainConf.task.minutes);
                    task.setHour(mainConf.task.hours);
                    task.setDayOfWeek(mainConf.task.dayOfWeek);
                    task.setCommand(LDAConstants.startSlurpdOneShotCommand);
                    task.setStatus(true);
                    LDADebug.debug((Object)"LDAParser:updateSchedule:addTask (dspushd)");
                    scheduler.addTask(task);
                    this.dspushd_task = task;
                }
            }
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            throw new LdapConfigException(exception.getMessage());
        }
        try {
            if (!bl2) {
                if (this.dspulld_task != null) {
                    this.dspulld_task.setMinute(mainConf.task_cr.minutes);
                    this.dspulld_task.setHour(mainConf.task_cr.hours);
                    this.dspulld_task.setDayOfWeek(mainConf.task_cr.dayOfWeek);
                    this.dspulld_task.setCommand(LDAConstants.startDspulldCommand);
                    this.dspulld_task.setStatus(true);
                    LDADebug.debug((Object)"LDAParser:updateSchedule:modifyTask (dspulld)");
                    scheduler.modifyTask(this.dspulld_task.getTaskID(), this.dspulld_task);
                    return;
                }
                task = new Task("LDAP_DIRECTORY", "dspulld");
                task.setMinute(mainConf.task_cr.minutes);
                task.setHour(mainConf.task_cr.hours);
                task.setDayOfWeek(mainConf.task_cr.dayOfWeek);
                task.setCommand(LDAConstants.startDspulldCommand);
                task.setStatus(true);
                LDADebug.debug((Object)"LDAParser:updateSchedule:addTask (dspulld)");
                scheduler.addTask(task);
                this.dspulld_task = task;
                return;
            }
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            throw new LdapConfigException(exception.getMessage());
        }
    }

    private void generate_crontab_file() throws LdapConfigException {
        try {
            this.updateSchedule(this.globalConf.mainconf);
            return;
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("crontab file update failed (%1)"), (String)exception.getMessage()));
        }
    }

    public Properties getProperties() {
        return this.server_properties;
    }

    private void load_server_properties() {
        String string = "389";
        String string2 = "256";
        String string3 = "1760";
        this.globalConf.ldap_service.ldap_port = Integer.parseInt(string);
        this.globalConf.web_service.port = Integer.parseInt(string3);
        this.server_properties = new Properties();
        try {
            this.server_properties.load(new FileInputStream("/etc/opt/SUNWconn/ldap/current/dsserv.ini"));
        }
        catch (IOException iOException) {
            this.log(LDACatalog.printf((String)this.cat.gets("Can't load property file %1 (%2)"), (String)"/etc/opt/SUNWconn/ldap/current/dsserv.ini", (String)iOException.getMessage()));
        }
        this.globalConf.ldap_service.ldap_port = Integer.parseInt(this.server_properties.getProperty("LdapPort", string));
        this.globalConf.web_service.port = Integer.parseInt(this.server_properties.getProperty("WebGwPort", string3));
        this.globalConf.mainconf.maxUsers = Integer.parseInt(this.server_properties.getProperty("MaxCnx", string2));
        this.globalConf.mainconf.profile = this.server_properties.getProperty("Profile", "standard");
        String string4 = this.server_properties.getProperty("HierarchicalClassDisplayMode", "true");
        if (string4.equalsIgnoreCase("true")) {
            this.globalConf.ocl.hierarchical = true;
            return;
        }
        this.globalConf.ocl.hierarchical = false;
    }

    private void save_server_properties() throws LdapConfigException {
        ((Hashtable)this.server_properties).put("LdapPort", Integer.toString(this.globalConf.ldap_service.ldap_port));
        ((Hashtable)this.server_properties).put("WebGwPort", Integer.toString(this.globalConf.web_service.port));
        ((Hashtable)this.server_properties).put("MaxCnx", Integer.toString(this.globalConf.mainconf.maxUsers));
        ((Hashtable)this.server_properties).put("Profile", this.globalConf.mainconf.profile);
        ((Hashtable)this.server_properties).put("StartDspushd", this.globalConf.mainconf.task.type == 2 ? "true" : "false");
        ((Hashtable)this.server_properties).put("LogDir", this.globalConf.log.dir);
        ((Hashtable)this.server_properties).put("LogSize", Integer.toString(this.globalConf.log.size));
        ((Hashtable)this.server_properties).put("LdapLogLevel", Integer.toString(this.globalConf.log.level));
        int n = 0;
        if (this.globalConf.log.level == 256) {
            n = 1;
        } else if (this.globalConf.log.level == 384) {
            n = 2;
        } else if (this.globalConf.log.level == 15358) {
            n = 3;
        }
        ((Hashtable)this.server_properties).put("LogLevel", Integer.toString(n));
        ((Hashtable)this.server_properties).put("HierarchicalClassDisplayMode", this.globalConf.ocl.hierarchical ? "true" : "false");
        if (this.globalConf.backends.size() >= 1) {
            ((Hashtable)this.server_properties).put("WebGwRoot", "\"" + (String)((BackEndHeader)this.globalConf.backends.elementAt((int)0)).suffix.firstElement() + "\"");
        } else {
            ((Hashtable)this.server_properties).put("WebGwRoot", "\"\"");
        }
        try {
            this.server_properties.save(new DataOutputStream(new FileOutputStream("/etc/opt/SUNWconn/ldap/current/dsserv.ini")), "#\n#Copyright 06/24/98 Sun Microsystems, Inc. All Rights Reserved");
            return;
        }
        catch (IOException iOException) {
            String string = LDACatalog.printf((String)this.cat.gets("Can't save property file to %1 (%2)"), (String)"/etc/opt/SUNWconn/ldap/current/dsserv.ini", (String)iOException.getMessage());
            this.log(string);
            throw new LdapConfigException(string);
        }
    }

    private static String add_backslash(String string) {
        String string2 = "***" + string + "***";
        String string3 = new String("");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\"");
        int n = stringTokenizer.countTokens();
        string3 = stringTokenizer.nextToken();
        int n2 = 0;
        while (n2 < n - 1) {
            string3 = String.valueOf(string3) + "\\\"" + stringTokenizer.nextToken();
            ++n2;
        }
        string3 = string3.substring(3, string3.length() - 3);
        return string3;
    }

    private static String remove_backslash(String string) {
        String string2 = "***" + string + "***";
        String string3 = new String("");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\\\"");
        int n = stringTokenizer.countTokens();
        string3 = stringTokenizer.nextToken();
        int n2 = 0;
        while (n2 < n - 1) {
            string3 = String.valueOf(string3) + "\"" + stringTokenizer.nextToken();
            ++n2;
        }
        string3 = string3.substring(3, string3.length() - 3);
        return string3;
    }

    private void updateEditableAttributes() {
        int n = this.globalConf.ocl.size();
        this.globalConf.attributes.size();
        int n2 = 0;
        while (n2 < n) {
            AttrItem attrItem;
            ClassItem classItem = (ClassItem)this.globalConf.ocl.elementAt(n2);
            int n3 = 0;
            if (classItem.required != null) {
                n3 = classItem.required.size();
            }
            int n4 = 0;
            while (n4 < n3) {
                attrItem = (AttrItem)classItem.required.elementAt(n4);
                if (!classItem.editable || !attrItem.editable) {
                    try {
                        this.globalConf.attributes.getAttributeFromName((String)attrItem.name).editable = false;
                    }
                    catch (NullPointerException nullPointerException) {
                        this.globalConf.attributes.getAttributeFromAlias((String)attrItem.name).editable = false;
                    }
                }
                ++n4;
            }
            n3 = 0;
            if (classItem.allowed != null) {
                n3 = classItem.allowed.size();
            }
            int n5 = 0;
            while (n5 < n3) {
                attrItem = (AttrItem)classItem.allowed.elementAt(n5);
                if (!classItem.editable || !attrItem.editable) {
                    try {
                        this.globalConf.attributes.getAttributeFromName((String)attrItem.name).editable = false;
                    }
                    catch (NullPointerException nullPointerException) {
                        this.globalConf.attributes.getAttributeFromAlias((String)attrItem.name).editable = false;
                    }
                }
                ++n5;
            }
            ++n2;
        }
    }

    private void generatePartialReplicationObjects(BackEnd backEnd) {
        Enumeration enumeration = backEnd.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            BackEndHeader backEndHeader = (BackEndHeader)enumeration.nextElement();
            if (backEndHeader.master) {
                if (backEndHeader.subtree.size() == 0) {
                    int n2 = backEndHeader.suffix.size();
                    n = 0;
                    while (n < n2) {
                        LDASubtreeItem lDASubtreeItem = new LDASubtreeItem();
                        lDASubtreeItem.subtree_suffixes.addElement((String)backEndHeader.suffix.elementAt(n));
                        lDASubtreeItem.mode = 1;
                        backEndHeader.subtree.addElement(lDASubtreeItem);
                        ++n;
                    }
                }
            } else {
                this.log(LDACatalog.printf((String)this.cat.gets("WARNING: Obsolete update_dn token detected for data store %1. Upgrading..."), (String)((String)backEndHeader.suffix.firstElement())));
                int n3 = backEndHeader.suffix.size();
                n = 0;
                while (n < n3) {
                    LDASubtreeItem lDASubtreeItem = new LDASubtreeItem();
                    lDASubtreeItem.subtree_suffixes.addElement((String)backEndHeader.suffix.elementAt(n));
                    lDASubtreeItem.mode = 2;
                    lDASubtreeItem.updateDn = backEndHeader.upd_dn;
                    lDASubtreeItem.host = backEndHeader.mastername;
                    backEndHeader.subtree.addElement(lDASubtreeItem);
                    ++n;
                }
            }
            Enumeration enumeration2 = backEndHeader.new_replica.elements();
            while (enumeration2.hasMoreElements()) {
                LDAReplicaItem lDAReplicaItem = (LDAReplicaItem)enumeration2.nextElement();
                if (lDAReplicaItem.subtree_suffixes.size() != 0 || lDAReplicaItem.object_suffixes.size() != 0) continue;
                n = backEndHeader.suffix.size();
                int n4 = 0;
                while (n4 < n) {
                    lDAReplicaItem.subtree_suffixes.addElement((String)backEndHeader.suffix.elementAt(n4));
                    ++n4;
                }
            }
        }
    }

    private LDAReplicaList groupReplicas(LDAReplicaList lDAReplicaList) {
        LDAReplicaList lDAReplicaList2 = (LDAReplicaList)lDAReplicaList.clone();
        LDAReplicaList lDAReplicaList3 = new LDAReplicaList();
        LDAReplicaItem lDAReplicaItem = null;
        while (true) {
            try {
                lDAReplicaItem = (LDAReplicaItem)lDAReplicaList2.firstElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            lDAReplicaList2.removeElement(lDAReplicaItem);
            int n = lDAReplicaList2.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                LDAReplicaItem lDAReplicaItem2 = (LDAReplicaItem)lDAReplicaList2.elementAt(n2);
                if (lDAReplicaItem2.equalsForGrouping(lDAReplicaItem, this.globalConf.attributes)) {
                    if (lDAReplicaItem2.subtree_suffixes.size() > 0) {
                        lDAReplicaItem.subtree_suffixes.addElement(lDAReplicaItem2.subtree_suffixes.firstElement());
                    } else {
                        lDAReplicaItem.object_suffixes.addElement(lDAReplicaItem2.object_suffixes.firstElement());
                    }
                    lDAReplicaList2.removeElement(lDAReplicaItem2);
                }
                --n2;
            }
            lDAReplicaList3.addElement(lDAReplicaItem);
        }
        return lDAReplicaList3;
    }

    private LDASubtreeList groupSubtrees(LDASubtreeList lDASubtreeList, boolean bl) {
        LDASubtreeList lDASubtreeList2 = (LDASubtreeList)lDASubtreeList.clone();
        LDASubtreeList lDASubtreeList3 = new LDASubtreeList();
        LDASubtreeItem lDASubtreeItem = null;
        if (bl) {
            int n = lDASubtreeList2.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                lDASubtreeItem = (LDASubtreeItem)lDASubtreeList2.elementAt(n2);
                if (!lDASubtreeItem.client_replication) {
                    lDASubtreeList2.removeElementAt(n2);
                }
                --n2;
            }
            while (true) {
                try {
                    lDASubtreeItem = (LDASubtreeItem)lDASubtreeList2.firstElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                lDASubtreeList2.removeElement(lDASubtreeItem);
                int n3 = lDASubtreeList2.size();
                int n4 = n3 - 1;
                while (n4 >= 0) {
                    LDASubtreeItem lDASubtreeItem2 = (LDASubtreeItem)lDASubtreeList2.elementAt(n4);
                    if (lDASubtreeItem2.equalsForGrouping(lDASubtreeItem, true, this.globalConf.attributes)) {
                        if (lDASubtreeItem2.subtree_suffixes.size() > 0) {
                            lDASubtreeItem.subtree_suffixes.addElement(lDASubtreeItem2.subtree_suffixes.firstElement());
                        } else {
                            lDASubtreeItem.object_suffixes.addElement(lDASubtreeItem2.object_suffixes.firstElement());
                        }
                        lDASubtreeList2.removeElement(lDASubtreeItem2);
                    }
                    --n4;
                }
                lDASubtreeList3.addElement(lDASubtreeItem);
            }
            return lDASubtreeList3;
        }
        while (true) {
            try {
                lDASubtreeItem = (LDASubtreeItem)lDASubtreeList2.firstElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            lDASubtreeList2.removeElement(lDASubtreeItem);
            int n = lDASubtreeList2.size();
            int n5 = n - 1;
            while (n5 >= 0) {
                LDASubtreeItem lDASubtreeItem3 = (LDASubtreeItem)lDASubtreeList2.elementAt(n5);
                if (lDASubtreeItem3.equalsForGrouping(lDASubtreeItem, false, this.globalConf.attributes)) {
                    if (lDASubtreeItem3.subtree_suffixes.size() > 0) {
                        lDASubtreeItem.subtree_suffixes.addElement(lDASubtreeItem3.subtree_suffixes.firstElement());
                    } else {
                        lDASubtreeItem.object_suffixes.addElement(lDASubtreeItem3.object_suffixes.firstElement());
                    }
                    lDASubtreeList2.removeElement(lDASubtreeItem3);
                }
                --n5;
            }
            lDASubtreeList3.addElement(lDASubtreeItem);
        }
        return lDASubtreeList3;
    }

    public void splitReplicasAndSubtrees(BackEnd backEnd, Attr attr) {
        Enumeration enumeration = backEnd.elements();
        while (enumeration.hasMoreElements()) {
            LDASubtreeItem lDASubtreeItem;
            BackEndHeader backEndHeader = (BackEndHeader)enumeration.nextElement();
            LDASubtreeList lDASubtreeList = new LDASubtreeList();
            Enumeration enumeration2 = backEndHeader.subtree.elements();
            while (enumeration2.hasMoreElements()) {
                LDASubtreeItem lDASubtreeItem2;
                lDASubtreeItem = (LDASubtreeItem)enumeration2.nextElement();
                int n = lDASubtreeItem.subtree_suffixes.size();
                int n2 = 0;
                while (n2 < n) {
                    lDASubtreeItem2 = (LDASubtreeItem)lDASubtreeItem.clone();
                    lDASubtreeItem2.object_suffixes = new Vector();
                    lDASubtreeItem2.subtree_suffixes = new Vector();
                    lDASubtreeItem2.subtree_suffixes.addElement(lDASubtreeItem.subtree_suffixes.elementAt(n2));
                    lDASubtreeList.addElement(lDASubtreeItem2);
                    ++n2;
                }
                n = lDASubtreeItem.object_suffixes.size();
                int n3 = 0;
                while (n3 < n) {
                    lDASubtreeItem2 = (LDASubtreeItem)lDASubtreeItem.clone();
                    lDASubtreeItem2.object_suffixes = new Vector();
                    lDASubtreeItem2.subtree_suffixes = new Vector();
                    lDASubtreeItem2.object_suffixes.addElement(lDASubtreeItem.object_suffixes.elementAt(n3));
                    lDASubtreeList.addElement(lDASubtreeItem2);
                    ++n3;
                }
            }
            backEndHeader.subtree = lDASubtreeList;
            LDAReplicaList lDAReplicaList = new LDAReplicaList();
            enumeration2 = backEndHeader.new_replica.elements();
            while (enumeration2.hasMoreElements()) {
                LDAReplicaItem lDAReplicaItem = (LDAReplicaItem)enumeration2.nextElement();
                int n = lDAReplicaItem.subtree_suffixes.size();
                int n4 = 0;
                while (n4 < n) {
                    LDAReplicaItem lDAReplicaItem2 = (LDAReplicaItem)lDAReplicaItem.clone();
                    lDAReplicaItem2.object_suffixes = new Vector();
                    lDAReplicaItem2.subtree_suffixes = new Vector();
                    lDAReplicaItem2.subtree_suffixes.addElement(lDAReplicaItem.subtree_suffixes.elementAt(n4));
                    lDAReplicaList.addElement(lDAReplicaItem2);
                    ++n4;
                }
                n = lDAReplicaItem.object_suffixes.size();
                int n5 = 0;
                while (n5 < n) {
                    LDAReplicaItem lDAReplicaItem3 = (LDAReplicaItem)lDAReplicaItem.clone();
                    lDAReplicaItem3.subtree_suffixes = new Vector();
                    lDAReplicaItem3.object_suffixes = new Vector();
                    lDAReplicaItem3.object_suffixes.addElement(lDAReplicaItem.object_suffixes.elementAt(n5));
                    lDAReplicaList.addElement(lDAReplicaItem3);
                    ++n5;
                }
            }
            backEndHeader.new_replica = lDAReplicaList;
            enumeration2 = backEndHeader.subtree.elements();
            Vector<LDASubtreeItem> vector = new Vector<LDASubtreeItem>();
            Vector<LDASubtreeItem> vector2 = new Vector<LDASubtreeItem>();
            while (enumeration2.hasMoreElements()) {
                lDASubtreeItem = (LDASubtreeItem)enumeration2.nextElement();
                if (lDASubtreeItem.mode != 2) continue;
                if (lDASubtreeItem.client_replication) {
                    vector.addElement(lDASubtreeItem);
                    continue;
                }
                vector2.addElement(lDASubtreeItem);
            }
            int n = 0;
            while (n < vector.size()) {
                lDASubtreeItem = (LDASubtreeItem)vector.elementAt(n);
                int n6 = 0;
                while (n6 < vector2.size()) {
                    LDASubtreeItem lDASubtreeItem3 = (LDASubtreeItem)vector2.elementAt(n6);
                    if (lDASubtreeItem.subtree_suffixes.size() == lDASubtreeItem3.subtree_suffixes.size() && lDASubtreeItem.object_suffixes.size() == lDASubtreeItem3.object_suffixes.size() && lDASubtreeItem3.port == lDASubtreeItem.port && lDASubtreeItem3.host.equals(lDASubtreeItem.host) && (lDASubtreeItem.subtree_suffixes.size() <= 0 || ((String)lDASubtreeItem.subtree_suffixes.firstElement()).equals((String)lDASubtreeItem3.subtree_suffixes.firstElement())) && (lDASubtreeItem.object_suffixes.size() <= 0 || ((String)lDASubtreeItem.object_suffixes.firstElement()).equals((String)lDASubtreeItem3.object_suffixes.firstElement()))) {
                        lDASubtreeItem.updateDn = lDASubtreeItem3.updateDn;
                        backEndHeader.subtree.removeElement(lDASubtreeItem3);
                        break;
                    }
                    ++n6;
                }
                ++n;
            }
        }
    }

    private Attr[] dispatchAttributes() {
        int n = this.globalConf.attributes.size();
        Attr[] attrArray = new Attr[this.globalConf.included_files.size()];
        int n2 = this.globalConf.included_files.indexOf(new File("/etc/opt/SUNWconn/ldap/current", "dsserv.at.conf").getAbsolutePath());
        LDADebug.debug((Object)("default file index for attributes " + Integer.toString(n2)));
        int n3 = 0;
        while (n3 < attrArray.length) {
            attrArray[n3] = new Attr();
            ++n3;
        }
        attrArray[n2].comments = this.globalConf.attributes.comments;
        int n4 = 0;
        while (n4 < n) {
            AttrItem attrItem = (AttrItem)this.globalConf.attributes.elementAt(n4);
            if (attrItem.file_id == -1) {
                attrArray[n2].addElement(attrItem);
            } else {
                attrArray[attrItem.file_id].addElement(attrItem);
            }
            ++n4;
        }
        return attrArray;
    }

    private BackEnd[] dispatchBackends(BackEnd backEnd) {
        int n = backEnd.size();
        BackEnd[] backEndArray = new BackEnd[this.globalConf.included_files.size()];
        int n2 = 0;
        LDADebug.debug((Object)("default file index for backend " + Integer.toString(n2)));
        int n3 = 0;
        while (n3 < backEndArray.length) {
            backEndArray[n3] = new BackEnd();
            ++n3;
        }
        backEndArray[n2].comments = backEnd.comments;
        int n4 = 0;
        while (n4 < n) {
            BackEndHeader backEndHeader = (BackEndHeader)backEnd.elementAt(n4);
            if (backEndHeader.file_id == -1) {
                backEndArray[n2].addElement(backEndHeader);
            } else {
                backEndArray[backEndHeader.file_id].addElement(backEndHeader);
            }
            ++n4;
        }
        return backEndArray;
    }

    private Objcl[] dispatchClasses() {
        int n = this.globalConf.ocl.size();
        Objcl[] objclArray = new Objcl[this.globalConf.included_files.size()];
        int n2 = this.globalConf.included_files.indexOf(new File("/etc/opt/SUNWconn/ldap/current", "dsserv.oc.conf").getAbsolutePath());
        LDADebug.debug((Object)("default file index for classes " + Integer.toString(n2)));
        int n3 = 0;
        while (n3 < objclArray.length) {
            objclArray[n3] = new Objcl();
            ++n3;
        }
        objclArray[n2].comments = this.globalConf.ocl.comments;
        int n4 = 0;
        while (n4 < n) {
            ClassItem classItem = (ClassItem)this.globalConf.ocl.elementAt(n4);
            if (classItem.file_id == -1) {
                objclArray[n2].addElement(classItem);
            } else {
                objclArray[classItem.file_id].addElement(classItem);
            }
            ++n4;
        }
        return objclArray;
    }

    private void refresh_include_file(int n) {
        Attr[] attrArray = this.dispatchAttributes();
        Objcl[] objclArray = this.dispatchClasses();
        BackEnd[] backEndArray = this.dispatchBackends(this.globalConf.backends);
        boolean bl = false;
        String string = (String)this.globalConf.included_files.elementAt(n);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            if (attrArray[n].size() > 0) {
                this.generate_attributes(attrArray[n], dataOutputStream);
                bl = true;
            }
            if (objclArray[n].size() > 0) {
                this.generate_classes(objclArray[n], dataOutputStream);
                bl = true;
            }
            if (backEndArray[n].size() > 0) {
                this.generate_backends(backEndArray[n], dataOutputStream, true);
                bl = true;
            }
            if (!bl) {
                dataOutputStream.writeBytes("\n\n");
            }
            dataOutputStream.close();
            this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)string))), n);
            return;
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            return;
        }
    }

    public void save_attributes() throws LdapConfigException {
        this.save_attributes(-1);
    }

    public void save_attributes(int n) throws LdapConfigException {
        try {
            DataOutputStream dataOutputStream;
            String string;
            Attr[] attrArray = this.dispatchAttributes();
            Objcl[] objclArray = this.dispatchClasses();
            BackEnd[] backEndArray = this.dispatchBackends(this.globalConf.backends);
            boolean bl = false;
            if (n == -1) {
                n = this.globalConf.included_files.indexOf(new File("/etc/opt/SUNWconn/ldap/current", "dsserv.at.conf").getAbsolutePath());
            }
            int n2 = 0;
            while (n2 < attrArray.length) {
                if (attrArray[n2].size() > 0) {
                    string = (String)this.globalConf.included_files.elementAt(n2);
                    if (Long.parseLong(LDACommandManager.getLastModifTime((String)string)) > (Long)this.globalConf.included_files_timestamp.elementAt(n2)) {
                        throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration."), (String)string));
                    }
                    if (n == n2) {
                        bl = true;
                    }
                    LDADebug.debug((Object)(String.valueOf(Integer.toString(attrArray[n2].size())) + " attributes to store in " + string));
                    try {
                        dataOutputStream = new DataOutputStream(new FileOutputStream(string));
                        this.generate_attributes(attrArray[n2], dataOutputStream);
                        if (objclArray[n2].size() > 0) {
                            this.generate_classes(objclArray[n2], dataOutputStream);
                        }
                        if (backEndArray[n2].size() > 0) {
                            this.generate_backends(backEndArray[n2], dataOutputStream, true);
                        }
                        dataOutputStream.close();
                        this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)string))), n2);
                    }
                    catch (IOException iOException) {
                        throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("Error while generating file %1 (%2)"), (String)string, (String)this.io_error_string(iOException)));
                    }
                }
                ++n2;
            }
            if (!bl) {
                string = (String)this.globalConf.included_files.elementAt(n);
                dataOutputStream = new DataOutputStream(new FileOutputStream(string));
                dataOutputStream.writeBytes("\n\n");
                dataOutputStream.close();
                this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)string))), n);
                return;
            }
        }
        catch (LdapConfigException ldapConfigException) {
            throw ldapConfigException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save_classes() throws LdapConfigException {
        this.save_classes(-1);
    }

    public void save_classes(int n) throws LdapConfigException {
        try {
            DataOutputStream dataOutputStream;
            String string;
            Objcl[] objclArray = this.dispatchClasses();
            Attr[] attrArray = this.dispatchAttributes();
            BackEnd[] backEndArray = this.dispatchBackends(this.globalConf.backends);
            boolean bl = false;
            if (n == -1) {
                n = this.globalConf.included_files.indexOf(new File("/etc/opt/SUNWconn/ldap/current", "dsserv.oc.conf").getAbsolutePath());
            }
            int n2 = 0;
            while (n2 < objclArray.length) {
                if (objclArray[n2].size() > 0) {
                    string = (String)this.globalConf.included_files.elementAt(n2);
                    if (Long.parseLong(LDACommandManager.getLastModifTime((String)string)) > (Long)this.globalConf.included_files_timestamp.elementAt(n2)) {
                        throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration."), (String)string));
                    }
                    if (n == n2) {
                        bl = true;
                    }
                    LDADebug.debug((Object)(String.valueOf(Integer.toString(objclArray[n2].size())) + " classes to store in " + string));
                    try {
                        dataOutputStream = new DataOutputStream(new FileOutputStream(string));
                        if (attrArray[n2].size() > 0) {
                            this.generate_attributes(attrArray[n2], dataOutputStream);
                        }
                        this.generate_classes(objclArray[n2], dataOutputStream);
                        if (backEndArray[n2].size() > 0) {
                            this.generate_backends(backEndArray[n2], dataOutputStream, true);
                        }
                        dataOutputStream.close();
                        this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)string))), n2);
                    }
                    catch (IOException iOException) {
                        throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("Error while generating file %1 (%2)"), (String)string, (String)this.io_error_string(iOException)));
                    }
                }
                ++n2;
            }
            if (!bl) {
                string = (String)this.globalConf.included_files.elementAt(n);
                dataOutputStream = new DataOutputStream(new FileOutputStream(string));
                dataOutputStream.writeBytes("\n\n");
                dataOutputStream.close();
                this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)string))), n);
                return;
            }
        }
        catch (LdapConfigException ldapConfigException) {
            throw ldapConfigException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized boolean getFrontendState(String string) throws LdapConfigException {
        File file;
        boolean bl = false;
        try {
            String string2;
            file = new File((String)this.globalConf.included_files.elementAt(0));
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (string2.startsWith("#") || !stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equals("frontend") || !stringTokenizer.nextToken().equals(string) || !stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("on")) continue;
                bl = true;
                break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        int n = 0;
        while (n < this.globalConf.frontends.size()) {
            file = (LDAFrontend)this.globalConf.frontends.elementAt(n);
            if (((LDAFrontend)file).name.equals(string)) {
                ((LDAFrontend)file).enabled = bl;
                break;
            }
            ++n;
        }
        return bl;
    }

    public synchronized void setFrontendState(String string, boolean bl) throws IOException, LdapConfigException {
        String string2;
        File file = new File("/tmp/dsserv.conf.tmp");
        File file2 = new File((String)this.globalConf.included_files.elementAt(0));
        if (Long.parseLong(LDACommandManager.getLastModifTime((String)file2.getAbsolutePath())) > (Long)this.globalConf.included_files_timestamp.elementAt(0)) {
            throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration."), (String)file2.getAbsolutePath()));
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        boolean bl2 = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (bl2 || string2.startsWith("#")) {
                dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
                continue;
            }
            if (stringTokenizer.nextToken().equals("frontend") && stringTokenizer.nextToken().equals(string)) {
                dataOutputStream.writeBytes("frontend " + string + " " + (bl ? "on" : "off") + "\n");
                bl2 = true;
                continue;
            }
            dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
        }
        bufferedReader.close();
        dataOutputStream.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
        while ((string2 = bufferedReader.readLine()) != null) {
            dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
        }
        dataOutputStream.close();
        bufferedReader.close();
        this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)file2.getAbsolutePath()))), 0);
        try {
            file.delete();
        }
        catch (Exception exception) {}
        int n = 0;
        while (n < this.globalConf.frontends.size()) {
            LDAFrontend lDAFrontend = (LDAFrontend)this.globalConf.frontends.elementAt(n);
            if (lDAFrontend.name.equals(string)) {
                lDAFrontend.enabled = bl;
                return;
            }
            ++n;
        }
    }

    public Acl dispatchAcl() {
        Acl acl = new Acl();
        int n = 0;
        while (n < this.globalConf.acl.size()) {
            AclWhat aclWhat = (AclWhat)this.globalConf.acl.elementAt(n);
            if (aclWhat.editable) {
                acl.addElement(aclWhat);
            }
            ++n;
        }
        return acl;
    }

    public void save_acl() throws LdapConfigException {
        File file = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.acl.conf");
        int n = this.globalConf.included_files.indexOf(file.getAbsolutePath());
        if (Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath())) > (Long)this.globalConf.included_files_timestamp.elementAt(n)) {
            throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration."), (String)file.getAbsolutePath()));
        }
        Acl acl = this.dispatchAcl();
        acl.comments = this.globalConf.acl.comments;
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            this.generate_acl(acl, dataOutputStream);
            dataOutputStream.close();
            this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath()))), n);
        }
        catch (IOException iOException) {
            throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("Error while saving acls to %1 (%2)"), (String)file.getAbsolutePath(), (String)this.io_error_string(iOException)));
        }
        try {
            int n2 = 0;
            while (n2 < acl.size()) {
                AclWhat aclWhat = (AclWhat)acl.elementAt(n2);
                if (aclWhat.file_id >= 0 && aclWhat.file_id != n) {
                    LDADebug.debug((Object)("Acl not in " + file.getAbsolutePath()));
                    this.refresh_include_file(aclWhat.file_id);
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            return;
        }
    }

    public void save_backend(LDASession lDASession, LdbmBackend ldbmBackend, LdbmBackend ldbmBackend2) throws LdapConfigException {
        block27: {
            try {
                String string;
                Object object;
                String string2;
                String string3;
                BackEnd[] backEndArray = this.dispatchBackends(this.globalConf.backends);
                int n = ldbmBackend.file_id;
                if (ldbmBackend.file_id == -1) {
                    n = 0;
                    string3 = (String)this.globalConf.included_files.elementAt(0);
                } else {
                    string3 = (String)this.globalConf.included_files.elementAt(ldbmBackend.file_id);
                }
                if (Long.parseLong(LDACommandManager.getLastModifTime((String)string3)) > (Long)this.globalConf.included_files_timestamp.elementAt(n)) {
                    throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration."), (String)string3));
                }
                File file = new File("/tmp/dsserv.conf.tmp");
                File file2 = new File(string3);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                boolean bl = false;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith("#")) {
                        dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
                        continue;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    if (!stringTokenizer.hasMoreTokens()) {
                        dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
                        continue;
                    }
                    if (stringTokenizer.nextToken().equals("database")) {
                        this.generate_backends(backEndArray[n], dataOutputStream, false);
                        bl = true;
                        break;
                    }
                    dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
                }
                if (!bl) {
                    this.generate_backends(backEndArray[n], dataOutputStream, true);
                }
                bufferedReader.close();
                dataOutputStream.close();
                bufferedReader = new BufferedReader(new FileReader(file));
                dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
                while ((string2 = bufferedReader.readLine()) != null) {
                    dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
                }
                dataOutputStream.close();
                bufferedReader.close();
                this.globalConf.included_files_timestamp.setElementAt(new Long(Long.parseLong(LDACommandManager.getLastModifTime((String)string3))), n);
                try {
                    file.delete();
                }
                catch (Exception exception) {}
                if (ldbmBackend2 == null) break block27;
                boolean bl2 = false;
                try {
                    object = new File(ldbmBackend2.dbdir).getCanonicalPath();
                    string = new File(ldbmBackend.dbdir).getCanonicalPath();
                    if (!((String)object).equals(string)) {
                        bl2 = true;
                    }
                }
                catch (Exception exception) {
                    LDADebug.printStackTrace((Exception)exception);
                }
                if (bl2) {
                    object = new File(ldbmBackend.dbdir);
                    if (!((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                    if (!((File)object).isDirectory()) {
                        string = LDACatalog.printf((String)this.cat.gets("Error while moving backend <%1> to %2 (file already exists)"), (String)((String)ldbmBackend.suffix.firstElement()), (String)((File)object).getAbsolutePath());
                        this.log(string);
                        throw new LdapConfigException(string);
                    }
                    try {
                        LDACommandManager.execUnixCommand((String)("cd " + ldbmBackend2.dbdir + " ; cp -r . " + ((File)object).getAbsolutePath()));
                    }
                    catch (LdapConfigException ldapConfigException) {
                        String string4 = LDACatalog.printf((String)this.cat.gets("Error while moving data store <%1> to %2 (%3)"), (String)((String)ldbmBackend.suffix.firstElement()), (String)((File)object).getAbsolutePath(), (String)ldapConfigException.getMessage());
                        this.log(string4);
                        throw new LdapConfigException(string4);
                    }
                }
                int n2 = ldbmBackend2.indexes.size();
                int n3 = 0;
                while (n3 < n2) {
                    string = (LDAIndexItem)ldbmBackend2.indexes.elementAt(n3);
                    int n4 = ((LDAIndexItem)string).names.size();
                    int n5 = 0;
                    while (n5 < n4) {
                        AttrItem attrItem;
                        if (ldbmBackend.indexes.getIndexByName((String)((LDAIndexItem)string).names.elementAt(n5)) == null && ((attrItem = this.globalConf.attributes.getAttributeFromAlias((String)((LDAIndexItem)string).names.elementAt(n5))) == null || ldbmBackend.indexes.getIndexByName(attrItem.name) == null)) {
                            File file3 = new File(String.valueOf(ldbmBackend2.dbdir) + "/" + (String)((LDAIndexItem)string).names.elementAt(n5) + ".dbb");
                            LDADebug.debug((Object)("Deleting file " + file3.getAbsolutePath()));
                            this.log(LDACatalog.printf((String)this.cat.gets("Backend %1: %2 index file deleted."), (String)((String)ldbmBackend.suffix.firstElement()), (String)file3.getAbsolutePath()));
                            try {
                                file3.delete();
                            }
                            catch (Exception exception) {
                                this.log(LDACatalog.printf((String)this.cat.gets("Can't delete index file %1: %2"), (String)file3.getAbsolutePath(), (String)exception.getMessage()));
                            }
                        }
                        ++n5;
                    }
                    ++n3;
                }
                if (ldbmBackend.indexes_to_refresh != null) {
                    throw new LdapRefreshIndexWarningException(LDAConstants.refreshAllIndexes);
                }
            }
            catch (IOException iOException) {
                throw new LdapConfigException(LDACatalog.printf((String)this.cat.gets("Unexpected error while savingbackends (%1)"), (String)iOException.getMessage()));
            }
        }
    }

    public boolean updateTimestamps() {
        long l = 0L;
        long l2 = 0L;
        try {
            int n = 0;
            while (n < this.globalConf.included_files.size()) {
                if (Long.parseLong(LDACommandManager.getLastModifTime((String)((String)this.globalConf.included_files.elementAt(n)))) > (Long)this.globalConf.included_files_timestamp.elementAt(n)) {
                    return true;
                }
                ++n;
            }
            l = Long.parseLong(LDACommandManager.getLastModifTime((String)new File("/etc/opt/SUNWconn/ldap/current", "mapping/radius.mapping").getAbsolutePath()));
            if (l > this.globalConf.radius_timeStamp) {
                return true;
            }
            l2 = Long.parseLong(LDACommandManager.getLastModifTime((String)new File("/etc/opt/SUNWconn/ldap/current", "mapping/nis.mapping").getAbsolutePath()));
            if (l2 > this.globalConf.nis_timeStamp) {
                return true;
            }
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        return false;
    }

    private RadiusServiceConf fetchRadiusConf() throws LdapConfigException, IOException {
        RadiusServiceConf radiusServiceConf;
        block40: {
            LDADebug.debug((Object)"On server: fetching current radius conf");
            radiusServiceConf = new RadiusServiceConf();
            File file = new File("/etc/opt/SUNWconn/ldap/current/mapping/radius.mapping");
            String string = file.getAbsolutePath();
            MapParser mapParser = new MapParser(file, this.errorWhileLoadingConf, this.cat, this.logstream);
            LineNumberReader lineNumberReader = mapParser.FindSectionStart(file, "Front-End:RADIUS.2", "Front-End:RADIUS.2");
            if (lineNumberReader == null) {
                this.report_error(string, lineNumberReader, this.cat.gets("RADIUS.2 Section not found, assuming default values"));
            } else {
                String string2 = mapParser.FindTokenValue(lineNumberReader, "Acounting_dir");
                if (string2 != null) {
                    if (string2.trim().equals("")) {
                        this.report_error(string, lineNumberReader, this.cat.gets("Acounting_dir value invalid, assuming default value"));
                    } else {
                        radiusServiceConf.setAcctDir(string2);
                    }
                } else {
                    this.report_error(string, lineNumberReader, this.cat.gets("Acounting_dir not found, assuming default value"));
                }
                string2 = mapParser.FindTokenValue(lineNumberReader, "Dynamic");
                if (string2 != null) {
                    String string3 = string2;
                    if (string3.equals("on")) {
                        radiusServiceConf.setDDataChoice(0);
                    } else if (string3.equals("off")) {
                        radiusServiceConf.setDDataChoice(1);
                    } else {
                        this.report_error(string, lineNumberReader, this.cat.gets("Dynamic value invalid, assuming default value"));
                    }
                } else {
                    this.report_error(string, lineNumberReader, this.cat.gets("Dynamic not found, assuming default value"));
                }
                string2 = mapParser.FindTokenValue(lineNumberReader, "Authentication_Port");
                if (string2 != null) {
                    try {
                        LdapInteger.check((LDACatalog)this.cat, (String)string2, (int)1, (int)1000000);
                        radiusServiceConf.setAuthPort(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        this.report_error(string, lineNumberReader, this.cat.gets("Authentication_Port value invalid, assuming default value"));
                    }
                } else {
                    this.report_error(string, lineNumberReader, this.cat.gets("Authentication_Port not found, assuming default value"));
                }
                string2 = mapParser.FindTokenValue(lineNumberReader, "Accounting_Port");
                if (string2 != null) {
                    try {
                        LdapInteger.check((LDACatalog)this.cat, (String)string2, (int)1, (int)1000000);
                        radiusServiceConf.setAcctPort(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        this.report_error(string, lineNumberReader, this.cat.gets("Accounting_Port value invalid, assuming default value"));
                    }
                } else {
                    this.report_error(string, lineNumberReader, this.cat.gets("Accounting_Port not found, assuming default value"));
                }
                string2 = mapParser.FindTokenValue(lineNumberReader, "Max_wait_b4_reject");
                if (string2 != null) {
                    try {
                        LdapInteger.check((LDACatalog)this.cat, (String)string2, (int)1, (int)1000000);
                        radiusServiceConf.setTimeout(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        this.report_error(string, lineNumberReader, this.cat.gets("Max_wait_b4_reject value invalid, assuming default value"));
                    }
                } else {
                    this.report_error(string, lineNumberReader, this.cat.gets("Max_wait_b4_reject not found, assuming default value"));
                }
                string2 = mapParser.FindTokenValue(lineNumberReader, "Max_threads");
                if (string2 != null) {
                    try {
                        LdapInteger.check((LDACatalog)this.cat, (String)string2, (int)1, (int)1000000);
                        radiusServiceConf.setMaxThreads(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        this.report_error(string, lineNumberReader, this.cat.gets("Max_threads value invalid, assuming default value"));
                    }
                } else {
                    this.report_error(string, lineNumberReader, this.cat.gets("Max_threads not found, assuming default value"));
                }
                string2 = mapParser.FindTokenValue(lineNumberReader, "Max_allowed_failures");
                if (string2 != null) {
                    try {
                        LdapInteger.check((LDACatalog)this.cat, (String)string2, (int)0, (int)1000000);
                        radiusServiceConf.setBlockingMode(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        this.report_error(string, lineNumberReader, this.cat.gets("Max_allowed_failures value invalid, assuming default value"));
                    }
                } else {
                    this.report_error(string, lineNumberReader, this.cat.gets("Max_allowed_failures not found, assuming default value"));
                }
                LDADebug.debug((Object)"End of Common Radius Parms...looking for RAS BaseDN");
                lineNumberReader = mapParser.FindSectionStart(file, "Front-End:RADIUS.2", "Table:RAS");
                if (lineNumberReader == null) {
                    this.report_error(string, lineNumberReader, this.cat.gets("Table:RAS Section not found, assuming default value"));
                } else {
                    string2 = mapParser.FindTokenValue(lineNumberReader, "BaseDN");
                    if (string2.trim().equals("")) {
                        this.report_error(string, lineNumberReader, this.cat.gets("RAS BaseDN value invalid, assuming default value"));
                    } else {
                        radiusServiceConf.setNASBaseDN(string2);
                    }
                }
                LDADebug.debug((Object)"Looking for User BaseDN");
                try {
                    lineNumberReader = mapParser.FindSectionStart(file, "Front-End:RADIUS.2", "Table:USERS");
                    if (lineNumberReader == null) {
                        this.report_error(string, lineNumberReader, this.cat.gets("Table:USERS Section not found, assuming default values"));
                        break block40;
                    }
                    string2 = mapParser.FindTokenValue(lineNumberReader, "BaseDN");
                    if (string2.trim().equals("")) {
                        this.report_error(string, lineNumberReader, this.cat.gets("User BaseDN value invalid, assuming default value"));
                        break block40;
                    }
                    radiusServiceConf.setUserBaseDN(string2);
                }
                catch (Exception exception) {
                    LDADebug.printStackTrace((Exception)exception);
                }
            }
        }
        return radiusServiceConf;
    }

    private void generate_log_conf(RadiusServiceConf radiusServiceConf, File file, File file2) throws IOException, LdapConfigException {
        Vector<String> vector = null;
        MapParser mapParser = new MapParser(file, this.errorWhileLoadingConf, this.cat, this.logstream);
        vector = mapParser.GetSection(file, "Front-End:RADIUS.2", "Front-End:RADIUS.2");
        if (vector == null) {
            LDADebug.debug((Object)"Making a dummy section");
            vector = new Vector<String>();
            vector.addElement("Front-End:RADIUS.2");
            vector.addElement("Common:");
        }
        if (radiusServiceConf.getDDataChoice() == 0) {
            if (!mapParser.ReplaceOneToken(vector, "Dynamic", "on")) {
                vector.addElement("\tDynamic=on");
            }
        } else if (radiusServiceConf.getDDataChoice() == 1 && !mapParser.ReplaceOneToken(vector, "Dynamic", "off")) {
            vector.addElement("\tDynamic=off");
        }
        if (!mapParser.ReplaceOneToken(vector, "Authentication_Port", Integer.toString(radiusServiceConf.getAuthPort()))) {
            vector.addElement("\tAuthentication_Port=" + Integer.toString(radiusServiceConf.getAuthPort()));
        }
        if (!mapParser.ReplaceOneToken(vector, "Accounting_Port", Integer.toString(radiusServiceConf.getAcctPort()))) {
            vector.addElement("\tAccounting_Port=" + Integer.toString(radiusServiceConf.getAcctPort()));
        }
        if (!mapParser.ReplaceOneToken(vector, "Acounting_dir", radiusServiceConf.getAcctDir())) {
            vector.addElement("\tAcounting_dir=" + radiusServiceConf.getAcctDir());
        }
        if (!mapParser.ReplaceOneToken(vector, "Max_wait_b4_reject", Integer.toString(radiusServiceConf.getTimeout()))) {
            vector.addElement("\tMax_wait_b4_reject=" + Integer.toString(radiusServiceConf.getTimeout()));
        }
        if (!mapParser.ReplaceOneToken(vector, "Max_threads", Integer.toString(radiusServiceConf.getMaxThreads()))) {
            vector.addElement("\tMax_threads=" + Integer.toString(radiusServiceConf.getMaxThreads()));
        }
        if (!mapParser.ReplaceOneToken(vector, "Max_allowed_failures", Integer.toString(radiusServiceConf.getBlockingMode()))) {
            vector.addElement("\tMax_allowed_failures=" + Integer.toString(radiusServiceConf.getBlockingMode()));
        }
        mapParser.ReplaceSection("Front-End:RADIUS.2", "Front-End:RADIUS.2", vector, file, file2);
        vector = mapParser.GetSection(file, "Front-End:RADIUS.2", "Table:RAS");
        if (vector == null) {
            LDADebug.debug((Object)"Making a dummy section:Table:RAS");
            vector = new Vector<String>();
            vector.addElement("\tTable:RAS");
            vector.addElement("\tCommon:");
        }
        if (!mapParser.ReplaceOneToken(vector, "BaseDN", radiusServiceConf.getNASBaseDN())) {
            vector.addElement("\tBaseDN=" + radiusServiceConf.getNASBaseDN());
        }
        mapParser.ReplaceSection("Front-End:RADIUS.2", "Table:RAS", vector, file, file2);
        vector = mapParser.GetSection(file, "Front-End:RADIUS.2", "Table:USERS");
        if (vector == null) {
            LDADebug.debug((Object)"Making a dummy section:Table:USERS");
            vector = new Vector<String>();
            vector.addElement("\tTable:USERS");
            vector.addElement("\tCommon:");
        }
        if (!mapParser.ReplaceOneToken(vector, "BaseDN", radiusServiceConf.getUserBaseDN())) {
            vector.addElement("\tBaseDN=" + radiusServiceConf.getUserBaseDN());
        }
        mapParser.ReplaceSection("Front-End:RADIUS.2", "Table:USERS", vector, file, file2);
    }

    private void save_radius_configuration() throws LdapSaveErrorException, LdapWarningException {
        File file = new File("/etc/opt/SUNWconn/ldap/current", "mapping/radius.mapping");
        File file2 = new File("/tmp/radius2.mapping");
        RadiusServiceConf radiusServiceConf = this.globalConf.radius_service;
        try {
            this.generate_log_conf(radiusServiceConf, file, file2);
            try {
                LDACommandManager.execUnixCommand((String)("/bin/cp " + file2.getAbsolutePath() + " " + file.getAbsolutePath()));
                this.globalConf.radius_timeStamp = Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath()));
            }
            catch (Exception exception) {
                LDADebug.printStackTrace((Exception)exception);
            }
        }
        catch (IOException iOException) {
            throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("Error while saving radius configuration to %1 (%2)"), (String)file.getAbsolutePath(), (String)this.io_error_string(iOException)));
        }
        catch (LdapConfigException ldapConfigException) {
            throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("Error while saving radius configuration to %1 (%2)"), (String)file.getAbsolutePath(), (String)ldapConfigException.getMessage()));
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        try {
            file2.delete();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private NisServiceConf fetchNisConf() throws LdapConfigException, IOException {
        LDADebug.debug((Object)"On server: fetching current nis conf");
        NisServiceConf nisServiceConf = new NisServiceConf();
        File file = new File("/etc/opt/SUNWconn/ldap/current/mapping/nis.mapping");
        String string = file.getAbsolutePath();
        MapParser mapParser = new MapParser(file, this.errorWhileLoadingConf, this.cat, this.logstream);
        LineNumberReader lineNumberReader = mapParser.FindSectionStart(file, "Front-End:NIS", "Front-End:NIS");
        if (lineNumberReader == null) {
            this.report_error(string, lineNumberReader, this.cat.gets("NIS Section not found, assuming default values"));
        } else {
            String string2 = mapParser.FindTokenValue(lineNumberReader, "DOMAIN_NAME");
            if (string2 != null) {
                if (string2.trim().equals("")) {
                    this.report_error(string, lineNumberReader, this.cat.gets("DOMAIN_NAME value invalid, assuming default value"));
                } else {
                    nisServiceConf.domain = string2;
                }
            } else {
                this.report_error(string, lineNumberReader, this.cat.gets("DOMAIN_NAME not found."));
            }
            string2 = mapParser.FindTokenValue(lineNumberReader, "ADMIN_SUFFIX");
            if (string2 != null) {
                if (string2.trim().equals("")) {
                    this.report_error(string, lineNumberReader, this.cat.gets("ADMIN_SUFFIX value invalid, assuming default value"));
                } else {
                    nisServiceConf.adminSuffix = string2;
                }
            } else {
                this.report_error(string, lineNumberReader, this.cat.gets("ADMIN_SUFFIX not found."));
            }
            string2 = mapParser.FindTokenValue(lineNumberReader, "DBM_DIRECTORY");
            if (string2 != null) {
                if (string2.trim().equals("")) {
                    this.report_error(string, lineNumberReader, this.cat.gets("DBM_DIRECTORY value invalid, assuming default value"));
                } else {
                    nisServiceConf.dbmDir = string2;
                }
            } else {
                this.report_error(string, lineNumberReader, this.cat.gets("DBM_DIRECTORY not found."));
            }
            string2 = mapParser.FindTokenValue(lineNumberReader, "DBM_XFR_REPLICATION");
            if (string2 != null) {
                if (string2.trim().equals("")) {
                    this.report_error(string, lineNumberReader, this.cat.gets("DBM_XFR_REPLICATION value invalid, assuming default value"));
                } else if (!string2.equalsIgnoreCase("enabled") && !string2.equalsIgnoreCase("disabled")) {
                    this.report_error(string, lineNumberReader, this.cat.gets("DBM_XFR_REPLICATION value invalid, assuming default value"));
                } else {
                    nisServiceConf.xfrd = string2.equalsIgnoreCase("enabled");
                }
            } else {
                this.report_error(string, lineNumberReader, this.cat.gets("DBM_XFR_REPLICATION not found."));
            }
            string2 = mapParser.FindTokenValue(lineNumberReader, "AUTOMATIC_PUSH");
            if (string2 != null) {
                if (string2.trim().equals("")) {
                    this.report_error(string, lineNumberReader, this.cat.gets("AUTOMATIC_PUSH value invalid, assuming default value"));
                } else if (!string2.equalsIgnoreCase("enabled") && !string2.equalsIgnoreCase("disabled")) {
                    this.report_error(string, lineNumberReader, this.cat.gets("AUTOMATIC_PUSH value invalid, assuming default value"));
                } else {
                    nisServiceConf.automaticPush = 5;
                }
            } else {
                this.report_error(string, lineNumberReader, this.cat.gets("AUTOMATIC_PUSH not found."));
            }
            string2 = mapParser.FindTokenValue(lineNumberReader, "AUTOMATIC_PUSH_DELAY");
            if (string2 != null) {
                if (string2.trim().equals("")) {
                    this.report_error(string, lineNumberReader, this.cat.gets("AUTOMATIC_PUSH_DELAY value invalid, assuming default value"));
                } else {
                    try {
                        nisServiceConf.automaticPush = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        this.report_error(string, lineNumberReader, this.cat.gets("AUTOMATIC_PUSH_DELAY value invalid, assuming default value"));
                    }
                }
            } else {
                this.report_error(string, lineNumberReader, this.cat.gets("AUTOMATIC_PUSH_DELAY not found."));
            }
        }
        try {
            lineNumberReader.close();
        }
        catch (Exception exception) {}
        nisServiceConf.maps = mapParser.getNisList(file, "Front-end:NIS");
        return nisServiceConf;
    }

    private void save_nis_configuration() throws LdapSaveErrorException, LdapWarningException {
        File file = new File("/etc/opt/SUNWconn/ldap/current", "mapping/nis.mapping");
        File file2 = new File("/tmp/nis.mapping");
        NisServiceConf nisServiceConf = this.globalConf.nis_service;
        try {
            this.generate_nis_conf(nisServiceConf, file, file2);
            try {
                LDACommandManager.execUnixCommand((String)("/bin/cp " + file2.getAbsolutePath() + " " + file.getAbsolutePath()));
                this.globalConf.nis_timeStamp = Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath()));
            }
            catch (Exception exception) {
                LDADebug.printStackTrace((Exception)exception);
            }
        }
        catch (IOException iOException) {
            throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("Error while saving NIS configuration to %1 (%2)"), (String)file.getAbsolutePath(), (String)this.io_error_string(iOException)));
        }
        catch (LdapConfigException ldapConfigException) {
            throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("Error while saving NIS configuration to %1 (%2)"), (String)file.getAbsolutePath(), (String)ldapConfigException.getMessage()));
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        try {
            file2.delete();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void generate_nis_conf(NisServiceConf nisServiceConf, File file, File file2) throws IOException, LdapConfigException {
        Vector<String> vector = null;
        MapParser mapParser = new MapParser(file, this.errorWhileLoadingConf, this.cat, this.logstream);
        vector = mapParser.GetSection(file, "Front-End:NIS", "Front-End:NIS");
        if (vector == null) {
            LDADebug.debug((Object)"Making a dummy section");
            vector = new Vector<String>();
            vector.addElement("Front-End:NIS");
            vector.addElement("Common:");
        }
        if (!mapParser.ReplaceOneToken(vector, "DOMAIN_NAME", nisServiceConf.domain)) {
            vector.addElement("\tDOMAIN_NAME=" + nisServiceConf.domain);
        }
        if (!mapParser.ReplaceOneToken(vector, "ADMIN_SUFFIX", nisServiceConf.adminSuffix)) {
            vector.addElement("\tADMIN_SUFFIX=" + nisServiceConf.adminSuffix);
        }
        if (!mapParser.ReplaceOneToken(vector, "DBM_DIRECTORY", nisServiceConf.dbmDir)) {
            vector.addElement("\tDBM_DIRECTORY=" + nisServiceConf.dbmDir);
        }
        if (!mapParser.ReplaceOneToken(vector, "DBM_XFR_REPLICATION", nisServiceConf.xfrd ? "enabled" : "disabled")) {
            vector.addElement("\tDBM_XFR_REPLICATION=" + (nisServiceConf.xfrd ? "enabled" : "disabled"));
        }
        if (!mapParser.ReplaceOneToken(vector, "AUTOMATIC_PUSH", nisServiceConf.automaticPush > 0 ? "enabled" : "disabled")) {
            vector.addElement("\tAUTOMATIC_PUSH=" + (nisServiceConf.automaticPush > 0 ? "enabled" : "disabled"));
        }
        if (!mapParser.ReplaceOneToken(vector, "AUTOMATIC_PUSH_DELAY", nisServiceConf.automaticPush > 0 ? Integer.toString(nisServiceConf.automaticPush) : "5")) {
            vector.addElement("\tAUTOMATIC_PUSH_DELAY=" + (nisServiceConf.automaticPush > 0 ? Integer.toString(nisServiceConf.automaticPush) : "5"));
        }
        mapParser.ReplaceSection("Front-End:NIS", "Front-End:NIS", vector, file, file2);
    }

    private void setSslClientVerificationToken(boolean bl) {
        this.sslClientVerificationToken = bl;
    }

    private boolean getSslClientVerificationToken() {
        return this.sslClientVerificationToken;
    }
}

