/*
 * Decompiled with CFR 0.152.
 */
package COM.Sun.sunsoft.ldaps.sims.server;

import COM.Sun.sunsoft.ldaps.sims.common.Acl;
import COM.Sun.sunsoft.ldaps.sims.common.AclWhat;
import COM.Sun.sunsoft.ldaps.sims.common.Attr;
import COM.Sun.sunsoft.ldaps.sims.common.AttrItem;
import COM.Sun.sunsoft.ldaps.sims.common.BackEnd;
import COM.Sun.sunsoft.ldaps.sims.common.BackEndHeader;
import COM.Sun.sunsoft.ldaps.sims.common.ClassItem;
import COM.Sun.sunsoft.ldaps.sims.common.DSCounters;
import COM.Sun.sunsoft.ldaps.sims.common.LDACatalog;
import COM.Sun.sunsoft.ldaps.sims.common.LDADebug;
import COM.Sun.sunsoft.ldaps.sims.common.LDAFrontend;
import COM.Sun.sunsoft.ldaps.sims.common.LDALogConf;
import COM.Sun.sunsoft.ldaps.sims.common.LDAMapItem;
import COM.Sun.sunsoft.ldaps.sims.common.LDAPServiceConf;
import COM.Sun.sunsoft.ldaps.sims.common.LDAProperties;
import COM.Sun.sunsoft.ldaps.sims.common.LDAReplicaItem;
import COM.Sun.sunsoft.ldaps.sims.common.LDAStatus;
import COM.Sun.sunsoft.ldaps.sims.common.LDAStatusMessage;
import COM.Sun.sunsoft.ldaps.sims.common.LdapConf;
import COM.Sun.sunsoft.ldaps.sims.common.LdapConfigException;
import COM.Sun.sunsoft.ldaps.sims.common.LdapSaveErrorException;
import COM.Sun.sunsoft.ldaps.sims.common.LdapWarningException;
import COM.Sun.sunsoft.ldaps.sims.common.LdbmBackend;
import COM.Sun.sunsoft.ldaps.sims.common.MainConf;
import COM.Sun.sunsoft.ldaps.sims.common.NisServiceConf;
import COM.Sun.sunsoft.ldaps.sims.common.Objcl;
import COM.Sun.sunsoft.ldaps.sims.common.RadiusServiceConf;
import COM.Sun.sunsoft.ldaps.sims.common.SecurityServiceConf;
import COM.Sun.sunsoft.ldaps.sims.common.WebServiceConf;
import COM.Sun.sunsoft.ldaps.sims.server.LDACommandManager;
import COM.Sun.sunsoft.ldaps.sims.server.LDAConstants;
import COM.Sun.sunsoft.ldaps.sims.server.LDAParser;
import COM.Sun.sunsoft.ldaps.sims.server.LDASchemaServer;
import COM.Sun.sunsoft.ldaps.sims.server.LDAServer;
import COM.Sun.sunsoft.ldaps.sims.server.LDASession;
import COM.Sun.sunsoft.ldaps.sims.server.LDASessionImpl;
import COM.Sun.sunsoft.sims.admin.AdminComponent;
import COM.Sun.sunsoft.sims.admin.AdminException;
import COM.Sun.sunsoft.sims.admin.AuditTrail;
import COM.Sun.sunsoft.sims.admin.AuditTrailException;
import COM.Sun.sunsoft.sims.admin.Catalog;
import COM.Sun.sunsoft.sims.admin.ConsoleSession;
import COM.Sun.sunsoft.sims.admin.Scheduler;
import COM.Sun.sunsoft.sims.admin.StatusMessage;
import COM.Sun.sunsoft.sims.avm.base.PropertySection;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.server.UID;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.Vector;

public class LDADirectoryServer
extends UnicastRemoteObject
implements AdminComponent,
LDAServer,
LDASchemaServer {
    private static final String copyrights = "Copyright 02/25/98 Sun Microsystems, Inc. All Rights Reserved";
    private LDAParser parser;
    private Writer logstream;
    private LdapConf config;
    private String name;
    private Vector sessions;
    private LDAStatusMessage currentStatus;
    private int lastReportedStatus = 0;
    private ConsoleSession consoleSession;
    private Scheduler scheduler;
    private Objcl oclnoatt;
    public LDACatalog cat;
    private LDAProperties properties;
    private AuditTrail audit;
    private int logcounter;
    private boolean previous_xfrd_mode;
    private String serverId;

    public LDADirectoryServer() throws RemoteException {
        this.run();
    }

    public String getServerName() throws RemoteException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public LDASession openSession(String string, Locale locale) throws LdapConfigException, RemoteException {
        LDADebug.debug((Object)("Open session from " + string));
        LDASessionImpl lDASessionImpl = new LDASessionImpl(this, string, locale);
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        this.log(LDACatalog.printf((String)this.cat.gets("Sun DS admin session initiated from %1 at %2"), (String)string, (String)dateFormat.format(new Date())));
        this.audit(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Sun DS admin session initiated from %1 at %2"), (String)string, (String)dateFormat.format(new Date())));
        LDASessionImpl lDASessionImpl2 = this.activeSession();
        if (lDASessionImpl2 != null) {
            this.audit(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Read-Write session already established from %1"), (String)lDASessionImpl2.source));
        }
        this.referenceSession((LDASession)lDASessionImpl);
        LDADebug.debug((Object)"Open session done");
        if (this.parser.updateTimestamps()) {
            LDADebug.debug((Object)"Need to reload the conf.");
            try {
                this.loadConfiguration();
            }
            catch (Exception exception) {
                LDADebug.printStackTrace((Exception)exception);
            }
        }
        this.deleteTempHtmlFiles();
        return lDASessionImpl;
    }

    public LDAPServiceConf getLdapServiceConf(LDASession lDASession) {
        LDADebug.debug((Object)"getLdapServiceConf");
        return this.config.ldap_service;
    }

    public void setLdapServiceConf(LDASession lDASession, LDAPServiceConf lDAPServiceConf) {
        LDADebug.debug((Object)"setLdapServiceConf");
        LDASessionImpl lDASessionImpl = (LDASessionImpl)lDASession;
        if (lDAPServiceConf.ldap_port != this.config.ldap_service.ldap_port) {
            this.audit(LDACatalog.printf((String)lDASessionImpl.ccat.gets("LDAP port set to %1."), (String)Integer.toString(lDAPServiceConf.ldap_port)));
        }
        this.config.ldap_service = lDAPServiceConf;
        this.config.modified = true;
        this.config.timeStamp = new Date();
    }

    public NisServiceConf getNisServiceConf(LDASession lDASession) {
        LDADebug.debug((Object)"getNisServiceConf");
        return this.config.nis_service;
    }

    public void setNisServiceConf(LDASession lDASession, NisServiceConf nisServiceConf) {
        LDADebug.debug((Object)"setNisServiceConf");
        this.previous_xfrd_mode = this.config.nis_service.xfrd;
        this.config.nis_service = nisServiceConf;
        this.config.modified = true;
        this.config.timeStamp = new Date();
    }

    public Vector getMapStatus(LDASession lDASession) {
        LDADebug.debug((Object)"getActiveMaps");
        int n = this.config.nis_service.maps.size();
        Vector<LDAMapItem> vector = new Vector<LDAMapItem>();
        boolean bl = LDACommandManager.isNisRunning();
        int n2 = 0;
        while (n2 < n) {
            LDAMapItem lDAMapItem = (LDAMapItem)((LDAMapItem)this.config.nis_service.maps.elementAt(n2)).clone();
            lDAMapItem.state = bl ? (LDACommandManager.isMapEnabled((String)this.config.nis_service.domain, (String)lDAMapItem.name) ? 1 : 2) : 3;
            vector.addElement(lDAMapItem);
            ++n2;
        }
        this.config.nis_service.maps = vector;
        return vector;
    }

    public void execNisCommand(LDASession lDASession, String string, String string2) throws LdapConfigException {
        LDADebug.debug((Object)"execNisCommand");
        String string3 = "";
        if (string.equals("dsypdecl")) {
            string3 = String.valueOf(LDAConstants.dsypdeclCommand) + " " + string2;
        } else if (string.equals("dsyppush")) {
            string3 = String.valueOf(LDAConstants.dsyppushCommand) + " " + string2;
        }
        LDADebug.debug((Object)("exec " + string3));
        LDACommandManager.execUnixCommand((String)string3);
    }

    public SecurityServiceConf getSecurityServiceConf(LDASession lDASession) {
        LDADebug.debug((Object)"getSecurityServiceConf");
        return this.config.security_service;
    }

    public void setSecurityServiceConf(LDASession lDASession, SecurityServiceConf securityServiceConf) {
        LDADebug.debug((Object)"setSecurityServiceConf");
        this.config.security_service = securityServiceConf;
        this.config.modified = true;
        this.config.timeStamp = new Date();
    }

    public WebServiceConf getWebServiceConf(LDASession lDASession) {
        return this.config.web_service;
    }

    public void setWebServiceConf(LDASession lDASession, WebServiceConf webServiceConf) {
        this.config.web_service = webServiceConf;
        this.config.modified = true;
        this.config.timeStamp = new Date();
    }

    public RadiusServiceConf getRadiusServiceConf(LDASession lDASession) {
        return this.config.radius_service;
    }

    public LDALogConf getLogConf(LDASession lDASession) {
        return this.config.log;
    }

    public void setLogConf(LDASession lDASession, LDALogConf lDALogConf) {
        if (!this.config.log.dir.equals(lDALogConf.dir)) {
            try {
                File file = new File(lDALogConf.dir);
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
            catch (Exception exception) {
                LDADebug.printStackTrace((Exception)exception);
            }
        }
        try {
            if (this.config.log.level != lDALogConf.level && this.isRunning()) {
                LDACommandManager.execUnixCommand((String)LDAConstants.refreshTraceCommand);
            }
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        this.config.log = lDALogConf;
        this.config.modified = true;
        this.config.timeStamp = new Date();
    }

    public void setRadiusServiceConf(LDASession lDASession, RadiusServiceConf radiusServiceConf) {
        this.config.radius_service = radiusServiceConf;
        this.config.modified = true;
        this.config.timeStamp = new Date();
    }

    public Vector getActiveSessions() throws RemoteException {
        return this.sessions;
    }

    public void closeSession(LDASession lDASession) throws LdapConfigException, RemoteException {
        this.deleteTempHtmlFiles();
        lDASession.close();
    }

    public LDAProperties getAppletProperties() throws RemoteException {
        LDADebug.debug((Object)"LDADirectoryServer:getAppletProperties");
        return this.properties;
    }

    public boolean packageInstalled(String string) throws RemoteException {
        return LDACommandManager.packageInstalled((String)string);
    }

    public void startService() throws RemoteException, AdminException {
        try {
            this.startDirectory(null);
            return;
        }
        catch (Exception exception) {
            this.reportToConsole(exception, "Start LDAP Directory failed.");
            return;
        }
    }

    public void stopService() throws RemoteException, AdminException {
        try {
            this.stopDirectory(null);
            return;
        }
        catch (Exception exception) {
            this.reportToConsole(exception, "Stop LDAP Directory failed.");
            return;
        }
    }

    public int saveBackup(String string) throws RemoteException, AdminException {
        try {
            this.backupConfig(null, new File(string != null ? string : this.properties.getProperty("DefaultBackupDir", "/var/opt/SUNWconn/ldap/backup")));
            return 0;
        }
        catch (Exception exception) {
            this.reportToConsole(exception, "Backup Sun DS Configuration failed.");
            return 1;
        }
    }

    public int saveDefault(String string) throws RemoteException, AdminException {
        boolean bl = false;
        if (bl) {
            new AdminException("", "");
        }
        return 0;
    }

    public int restoreFromBackup(String string) throws RemoteException, AdminException {
        try {
            this.restoreConfig(null, new File(string != null ? string : this.properties.getProperty("DefaultBackupDir", "/var/opt/SUNWconn/ldap/backup")));
            return 0;
        }
        catch (Exception exception) {
            this.reportToConsole(exception, "Restore Sun DS Configuration failed.");
            return 1;
        }
    }

    public int restoreFromDefault(String string) throws RemoteException, AdminException {
        return this.restoreFromBackup("/etc/opt/SUNWconn/ldap/default");
    }

    public boolean isRunning() throws RemoteException, AdminException {
        try {
            return this.getCurrentSession().isDsRunning();
        }
        catch (NoSuchElementException noSuchElementException) {
            return this.isDsRunning(null);
        }
        catch (LdapConfigException ldapConfigException) {
            this.reportToConsole((Exception)((Object)ldapConfigException), "Ping Sun DS failed.");
            return false;
        }
    }

    public Catalog getCatalog(Locale locale) throws RemoteException {
        LDADebug.debug((Object)"LDADirectoryServer:getCatalog");
        return new Catalog("");
    }

    public URL getURL() throws RemoteException {
        return null;
    }

    public String[] getPluggableSectionNames() throws RemoteException {
        return null;
    }

    public PropertySection[] getPluggableSections(String string) {
        return new PropertySection[1];
    }

    public void addSessionRef(ConsoleSession consoleSession) throws RemoteException, AdminException {
        this.consoleSession = consoleSession;
        this.currentStatus = null;
        try {
            this.scheduler = consoleSession.getScheduler();
            this.scheduler.listTasks("LDAP_DIRECTORY");
            LDADebug.debug((Object)"LDADirectoryServer:Loading schedule...");
            this.config.mainconf.task = this.parser.loadSchedule(this.scheduler, "dspushd");
            this.config.mainconf.task_cr = this.parser.loadSchedule(this.scheduler, "dspulld");
        }
        catch (Exception exception) {
            this.reportToConsole(exception, "add Sun Directory Services Session failed.");
        }
        LDADebug.debug((Object)"add session ref");
    }

    public void deleteSessionRef(ConsoleSession consoleSession) throws RemoteException, AdminException {
        LDADebug.debug((Object)"delete session ref");
        int n = this.sessions.size();
        int n2 = 0;
        while (n2 < n) {
            if (((LDASessionImpl)this.sessions.elementAt((int)n2)).cs == consoleSession) {
                try {
                    ((LDASession)this.sessions.elementAt(n2)).close();
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        this.deleteTempHtmlFiles();
        this.consoleSession = null;
        boolean bl = false;
        if (bl) {
            throw new AdminException("", "");
        }
    }

    public boolean isConfSavedToFile(LDASession lDASession) {
        return !this.config.modified;
    }

    public LdapConf getAll(LDASession lDASession) {
        return this.config;
    }

    public Attr getAttributes(LDASession lDASession) {
        return this.config.attributes;
    }

    public Objcl getClasses(LDASession lDASession, boolean bl) {
        if (bl) {
            LDADebug.debug((Object)"getClasses (w att)");
            return this.config.ocl;
        }
        LDADebug.debug((Object)"getClasses (w/o att)");
        return this.oclnoatt;
    }

    public Acl getAcl(LDASession lDASession) {
        LDADebug.debug((Object)"getAcl");
        return this.config.acl;
    }

    public BackEnd getBackends(LDASession lDASession) {
        int n = 0;
        while (n < this.config.backends.size()) {
            BackEndHeader backEndHeader = (BackEndHeader)this.config.backends.elementAt(n);
            if (((String)backEndHeader.suffix.firstElement()).equals("o=generated_dummy_datastore")) {
                BackEnd backEnd = (BackEnd)this.config.backends.clone();
                backEnd.removeElementAt(n);
                return backEnd;
            }
            ++n;
        }
        return this.config.backends;
    }

    public MainConf getMainConf(LDASession lDASession) {
        return this.config.mainconf;
    }

    public void addAttr(LDASession lDASession, AttrItem attrItem) throws LdapConfigException {
        LDADebug.debug((Object)"addAttr");
        this.config.attributes.addElement(attrItem);
        this.config.timeStamp = new Date();
        this.parser.save_attributes();
    }

    public void modifyAttr(LDASession lDASession, AttrItem attrItem) throws LdapConfigException {
        LDADebug.debug((Object)"modifyAttr");
        AttrItem attrItem2 = this.config.attributes.getAttributeFromName(attrItem.name);
        if (attrItem2 == null) {
            attrItem2 = this.config.attributes.getAttributeFromAlias(attrItem.name);
        }
        if (attrItem2 == null) {
            LDADebug.debug((Object)"INTERNAL ERROR: modifyAttr: null attr");
            return;
        }
        this.config.attributes.removeElement(attrItem2);
        this.config.attributes.addElement(attrItem);
        this.config.timeStamp = new Date();
        this.parser.save_attributes();
    }

    public void deleteAttr(LDASession lDASession, AttrItem attrItem) throws LdapConfigException {
        LDADebug.debug((Object)"deleteAttr");
        AttrItem attrItem2 = this.config.attributes.getAttributeFromName(attrItem.name);
        if (attrItem2 == null) {
            attrItem2 = this.config.attributes.getAttributeFromAlias(attrItem.name);
        }
        if (attrItem2 == null) {
            LDADebug.debug((Object)"INTERNAL ERROR: deleteAttr: null attr");
        }
        this.config.attributes.removeElement(attrItem2);
        this.config.timeStamp = new Date();
        this.parser.save_attributes(attrItem.file_id);
    }

    public void setClassParams(LDASession lDASession, Objcl objcl) {
        this.config.ocl.hierarchical = objcl.hierarchical;
        this.config.ocl.schema_check = objcl.schema_check;
        this.oclnoatt.hierarchical = objcl.hierarchical;
        this.oclnoatt.schema_check = objcl.schema_check;
        this.config.timeStamp = new Date();
        this.config.modified = true;
    }

    public void addClass(LDASession lDASession, ClassItem classItem) throws LdapConfigException {
        this.config.ocl.addElement(classItem);
        this.oclnoatt.addElement(classItem.clone());
        this.config.timeStamp = new Date();
        this.parser.save_classes();
    }

    /*
     * Unable to fully structure code
     */
    public void modifyClass(LDASession var1_1, ClassItem var2_2) throws LdapConfigException {
        var3_3 = this.config.ocl.getClassItemFromName(var2_2.name);
        if (var3_3 == null) {
            LDADebug.debug((Object)"INTERNAL ERROR: modifyClass: null class");
            return;
        }
        var4_4 = this.oclnoatt.getClassItemFromName(var2_2.name);
        if (var4_4 == null) {
            LDADebug.debug((Object)"INTERNAL ERROR: modifyClass: null class (noatt)");
            return;
        }
        if (var2_2.superior != null && var3_3.superior != null) {
            try {
                if (var2_2.superior.equalsIgnoreCase(var3_3.superior)) ** GOTO lbl41
                var5_5 = this.config.ocl.getClassItemPosition(new ClassItem(var2_2.superior));
                var6_6 = -1;
                var7_7 = this.config.ocl.size();
                var9_8 = 0;
                while (var9_8 < var7_7) {
                    var8_9 = (ClassItem)this.config.ocl.elementAt(var9_8);
                    if (var8_9.superior != null && var8_9.superior.equalsIgnoreCase(var2_2.name)) {
                        var6_6 = var9_8;
                        break;
                    }
                    ++var9_8;
                }
                var10_10 = var5_5 + 1;
                if (var6_6 != -1 && var6_6 < var10_10) {
                    throw new LdapConfigException(this.cat.gets("Reparent failed. Can't find insert point."));
                }
                if (var10_10 < var7_7) {
                    this.config.ocl.insertElementAt(var2_2, var10_10);
                    this.oclnoatt.insertElementAt(var2_2.clone(), var10_10);
                } else {
                    this.config.ocl.addElement(var2_2);
                    this.oclnoatt.addElement(var2_2.clone());
                }
                this.config.ocl.removeElement(var3_3);
                this.oclnoatt.removeElement(var4_4);
            }
            catch (Exception v0) {
                throw new LdapConfigException(this.cat.gets("Class reparent failed. Can't find insert point.\nOperation failed. "));
            }
        } else {
            this.config.ocl.setElementAt(var2_2, this.config.ocl.indexOf(var3_3));
            this.oclnoatt.setElementAt(var2_2.clone(), this.oclnoatt.indexOf(var4_4));
        }
lbl41:
        // 3 sources

        this.config.timeStamp = new Date();
        this.parser.save_classes();
    }

    public void deleteClass(LDASession lDASession, ClassItem classItem) throws LdapConfigException {
        try {
            ClassItem classItem2 = this.config.ocl.getClassItemFromName(classItem.name);
            if (classItem2 == null) {
                LDADebug.debug((Object)"INTERNAL ERROR: deleteClass: null Class");
            }
            this.config.ocl.removeElement(classItem2);
            classItem2 = this.oclnoatt.getClassItemFromName(classItem.name);
            if (classItem2 == null) {
                LDADebug.debug((Object)"INTERNAL ERROR: deleteClass: null Class (noatt)");
            }
            this.oclnoatt.removeElement(classItem2);
            this.config.timeStamp = new Date();
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        this.parser.save_classes(classItem.file_id);
    }

    public void addBackend(LDASession lDASession, BackEndHeader backEndHeader) throws LdapConfigException {
        this.config.backends.addElement(backEndHeader);
        this.config.timeStamp = new Date();
        this.parser.save_backend(lDASession, (LdbmBackend)backEndHeader, null);
    }

    public void modifyBackend(LDASession lDASession, BackEndHeader backEndHeader) throws LdapConfigException {
        BackEndHeader backEndHeader2 = this.config.backends.getBackendById(backEndHeader.uid);
        if (backEndHeader2 == null) {
            LDADebug.debug((Object)"INTERNAL ERROR: modifyBackend: null data store");
            return;
        }
        this.config.backends.removeElement(backEndHeader2);
        this.config.backends.addElement(backEndHeader);
        this.config.timeStamp = new Date();
        this.parser.save_backend(lDASession, (LdbmBackend)backEndHeader, (LdbmBackend)backEndHeader2);
    }

    public void deleteBackend(LDASession lDASession, BackEndHeader backEndHeader) throws LdapConfigException {
        BackEndHeader backEndHeader2 = this.config.backends.getBackendById(backEndHeader.uid);
        if (backEndHeader2 == null) {
            LDADebug.debug((Object)"INTERNAL ERROR: deleteBackend: null data store");
            return;
        }
        this.config.backends.removeElement(backEndHeader2);
        this.config.timeStamp = new Date();
        if (this.config.backends.size() == 0) {
            LdbmBackend ldbmBackend = new LdbmBackend();
            ldbmBackend.dbdir = "/tmp/generated_dummy_database";
            ldbmBackend.rootdn = backEndHeader.rootdn;
            ldbmBackend.rootpw = backEndHeader.rootpw;
            ldbmBackend.suffix.addElement(new String("o=generated_dummy_datastore"));
            ldbmBackend.readonly = true;
            this.config.backends.addElement(ldbmBackend);
            this.parser.save_backend(lDASession, ldbmBackend, null);
            return;
        }
        this.parser.save_backend(lDASession, (LdbmBackend)backEndHeader, null);
    }

    public void setAcl(LDASession lDASession, Acl acl) throws LdapConfigException {
        LDADebug.debug((Object)"setAcl");
        this.config.acl = acl;
        LDASessionImpl lDASessionImpl = (LDASessionImpl)lDASession;
        this.audit(lDASessionImpl.ccat.gets("Sun Directory Services access control lists updated."));
        this.config.timeStamp = new Date();
        this.parser.save_acl();
    }

    public void deleteAcl(LDASession lDASession, AclWhat aclWhat) throws LdapConfigException {
        AclWhat aclWhat2 = this.config.acl.getAclByName(aclWhat);
        LDASessionImpl lDASessionImpl = (LDASessionImpl)lDASession;
        if (aclWhat2 == null) {
            LDADebug.debug((Object)"INTERNAL ERROR: deleteAcl: null acl");
            return;
        }
        this.config.acl.removeElement(aclWhat2);
        this.audit(lDASessionImpl.ccat.gets("Sun Directory Services access control list updated."));
        this.config.timeStamp = new Date();
        this.parser.save_acl();
    }

    public void setSchedule(LDASession lDASession, MainConf mainConf) throws LdapConfigException {
        File file = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.conf");
        if (Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath())) > (Long)this.config.included_files_timestamp.elementAt(0)) {
            throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration (Menu 'Server')."), (String)file.getAbsolutePath()));
        }
        this.parser.updateSchedule(mainConf);
        this.config.mainconf.task = mainConf.task;
        this.config.mainconf.task_cr = mainConf.task_cr;
    }

    public void setMainConf(LDASession lDASession, MainConf mainConf) {
        LDASessionImpl cfr_ignored_0 = (LDASessionImpl)lDASession;
        this.config.mainconf = mainConf;
        this.config.modified = true;
        this.config.timeStamp = new Date();
    }

    public void startDirectory(LDASession lDASession) throws LdapConfigException, LdapWarningException {
        LDACatalog lDACatalog;
        boolean bl;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        block12: {
            block11: {
                stringBuffer2 = new StringBuffer("");
                stringBuffer = new StringBuffer("");
                bl = false;
                lDACatalog = this.cat;
                try {
                    lDACatalog = ((LDASessionImpl)lDASession).ccat;
                }
                catch (Exception exception) {}
                try {
                    this.stopDirectory(lDASession);
                }
                catch (Exception exception) {}
                try {
                    stringBuffer2.append(LDACommandManager.execUnixCommand((String)"/etc/init.d/dsserv start"));
                }
                catch (LdapConfigException ldapConfigException) {
                    stringBuffer.append(LDACatalog.printf((String)lDACatalog.gets("Message detected while starting dsservd process:\n%1\n"), (String)ldapConfigException.getMessage()));
                    if (!(ldapConfigException instanceof LdapWarningException)) break block11;
                    bl = true;
                }
            }
            try {
                stringBuffer2.append(LDACommandManager.execUnixCommand((String)"/etc/init.d/dsweb start"));
            }
            catch (LdapConfigException ldapConfigException) {
                stringBuffer.append(LDACatalog.printf((String)lDACatalog.gets("\nMessage detected while starting LDAP/HTTP gateway:\n%1\n"), (String)ldapConfigException.getMessage()));
                if (!(ldapConfigException instanceof LdapWarningException)) break block12;
                bl = true;
            }
        }
        if (!LDACommandManager.isSlapdRunning()) {
            stringBuffer.append(lDACatalog.gets("Can't start dsservd process (no additional information)"));
        }
        if (!stringBuffer.toString().equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(stringBuffer2.toString());
            if (bl) {
                LDADebug.debug((Object)"WARNING");
                throw new LdapWarningException(stringBuffer.toString());
            }
            LDADebug.debug((Object)"ERROR");
            throw new LdapConfigException(stringBuffer.toString());
        }
    }

    public void stopDirectory(LDASession lDASession) throws LdapConfigException {
        LDACommandManager.execUnixCommand((String)"/etc/init.d/dsweb stop");
        LDACommandManager.execUnixCommand((String)"/etc/init.d/dsserv stop");
    }

    public boolean isDsRunning(LDASession lDASession) {
        return LDACommandManager.isSlapdRunning();
    }

    public void backupConfig(LDASession lDASession, File file) throws LdapConfigException {
        LDACatalog lDACatalog = this.cat;
        try {
            lDACatalog = ((LDASessionImpl)lDASession).ccat;
        }
        catch (Exception exception) {}
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.isDirectory()) {
            throw new LdapConfigException(lDACatalog.gets("Directory file expected"));
        }
        LDACommandManager.execUnixCommand((String)("cd /etc/opt/SUNWconn/ldap/current ; /bin/cp -r . " + file.getAbsolutePath()));
        this.properties.put("LastBackup", file.getAbsolutePath());
        this.audit(LDACatalog.printf((String)lDACatalog.gets("Configuration backup to %1"), (String)file.getAbsolutePath()));
    }

    public void restoreConfig(LDASession lDASession, File file) throws LdapConfigException {
        LDACatalog lDACatalog = this.cat;
        try {
            lDACatalog = ((LDASessionImpl)lDASession).ccat;
        }
        catch (Exception exception) {}
        LDASessionImpl cfr_ignored_0 = (LDASessionImpl)lDASession;
        if (!file.exists() || !file.isDirectory()) {
            throw new LdapConfigException(LDACatalog.printf((String)lDACatalog.gets("%1 : invalid directory"), (String)file.getAbsolutePath()));
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf("dsserv.conf") >= 0) {
                LDACommandManager.execUnixCommand((String)("cd " + file.getAbsolutePath() + " ; /bin/cp -r . " + "/etc/opt/SUNWconn/ldap/current"));
                this.audit(LDACatalog.printf((String)lDACatalog.gets("Configuration restored from %1."), (String)file.getAbsolutePath()));
                return;
            }
            ++n;
        }
        throw new LdapConfigException(LDACatalog.printf((String)lDACatalog.gets("Unable to restore configuration.\nMissing %1 configuration file in directory %2"), (String)"dsserv.conf", (String)file.getAbsolutePath()));
    }

    public void backupBackend(LDASession lDASession, BackEndHeader backEndHeader, File file) throws LdapConfigException {
        LDASessionImpl lDASessionImpl = (LDASessionImpl)lDASession;
        if (!(backEndHeader instanceof LdbmBackend)) {
            throw new LdapConfigException(lDASessionImpl.ccat.gets("Backup not supported for this data store type"));
        }
        if (!file.exists() && !file.mkdir()) {
            throw new LdapConfigException(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Can't create directory %1."), (String)file.getAbsolutePath()));
        }
        if (!file.isDirectory()) {
            throw new LdapConfigException(LDACatalog.printf((String)lDASessionImpl.ccat.gets("%1 is not a directory"), (String)file.getAbsolutePath()));
        }
        if (!file.canWrite()) {
            throw new LdapConfigException(LDACatalog.printf((String)lDASessionImpl.ccat.gets("%1 is not writable"), (String)file.getAbsolutePath()));
        }
        File file2 = new File(((LdbmBackend)backEndHeader).dbdir);
        if (file2.getAbsolutePath().equals(file.getAbsolutePath())) {
            throw new LdapConfigException(lDASessionImpl.ccat.gets("Source and target directory are identical. Backup failed."));
        }
        if (!file2.exists() || !file2.isDirectory()) {
            throw new LdapConfigException(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Backend %1 not initialized. Save the configuration first."), (String)file2.getAbsolutePath()));
        }
        this.setSlapdMode(true);
        try {
            LDACommandManager.execUnixCommand((String)("cd " + file2.getAbsolutePath() + " ; cp *.dbb " + file.getAbsolutePath()));
            String[] stringArray = file2.list();
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].endsWith(".dbb") && !new File(String.valueOf(file2.getAbsolutePath()) + "/" + stringArray[n]).isDirectory()) {
                    LDACommandManager.execUnixCommand((String)("cd " + file2.getAbsolutePath() + " ; cp " + stringArray[n] + " " + file.getAbsolutePath()));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.setSlapdMode(false);
            throw new LdapConfigException(exception.getMessage());
        }
        this.setSlapdMode(false);
        this.audit(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Backup Data Store <%1> to %2."), (String)((String)backEndHeader.suffix.firstElement()), (String)file.getAbsolutePath()));
    }

    public void restoreBackend(LDASession lDASession, BackEndHeader backEndHeader, File file) throws LdapConfigException {
        LDASessionImpl lDASessionImpl = (LDASessionImpl)lDASession;
        if (!(backEndHeader instanceof LdbmBackend)) {
            throw new LdapConfigException(lDASessionImpl.ccat.gets("Restore not supported for this data store type."));
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new LdapConfigException(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Can't access directory %1."), (String)file.getAbsolutePath()));
        }
        File file2 = new File(((LdbmBackend)backEndHeader).dbdir);
        if (!file2.exists() || !file2.isDirectory()) {
            throw new LdapConfigException(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Backend %1 not initialized. Save the configuration first."), (String)file2.getAbsolutePath()));
        }
        if (file2.getAbsolutePath().equals(file.getAbsolutePath())) {
            throw new LdapConfigException(lDASessionImpl.ccat.gets("Source and target directory are identical. Restore failed."));
        }
        int n = 0;
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("id2entry.dbb")) {
                ++n;
            }
            if (stringArray[n2].equals("id2children.dbb")) {
                ++n;
            }
            if (n == 2) break;
            ++n2;
        }
        if (n < 2) {
            throw new LdapConfigException(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Can't restore data store from %1: Files id2entry.dbb or id2children.dbb missing."), (String)file.getAbsolutePath()));
        }
        this.setSlapdMode(true);
        try {
            try {
                LDACommandManager.execUnixCommand((String)("rm " + file2.getAbsolutePath() + "/*.dbb"));
            }
            catch (Exception exception) {}
            try {
                new File(String.valueOf(file2.getAbsolutePath()) + "/NEXTID").delete();
            }
            catch (Exception exception) {}
            try {
                new File(String.valueOf(file2.getAbsolutePath()) + "/cacheids").delete();
            }
            catch (Exception exception) {}
            try {
                new File(String.valueOf(file2.getAbsolutePath()) + "/createtimestamp").delete();
            }
            catch (Exception exception) {}
            try {
                new File(String.valueOf(file2.getAbsolutePath()) + "/modifytimestamp").delete();
            }
            catch (Exception exception) {}
            LDACommandManager.execUnixCommand((String)("cd " + file.getAbsolutePath() + " ; cp *.dbb " + file2.getAbsolutePath()));
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!stringArray[n3].endsWith(".dbb") && !new File(String.valueOf(file.getAbsolutePath()) + "/" + stringArray[n3]).isDirectory()) {
                    LDACommandManager.execUnixCommand((String)("cd " + file.getAbsolutePath() + " ; cp " + stringArray[n3] + " " + file2.getAbsolutePath()));
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            this.setSlapdMode(false);
            throw new LdapConfigException(exception.getMessage());
        }
        this.setSlapdMode(false);
        this.audit(LDACatalog.printf((String)lDASessionImpl.ccat.gets("Restore Data Store <%1> from %2."), (String)((String)backEndHeader.suffix.firstElement()), (String)file.getAbsolutePath()));
    }

    public String synchronize(LDASession lDASession, String string) throws LdapConfigException {
        if (string.equals("push")) {
            LDADebug.debug((Object)LDAConstants.startSlurpdOneShotCommand);
            if (LDACommandManager.isSlurpdRunning((boolean)true) || LDACommandManager.isSlurpdRunning((boolean)false)) {
                return "";
            }
            return LDACommandManager.JavaExecUnixCommand((String)LDAConstants.startSlurpdOneShotCommand);
        }
        LDADebug.debug((Object)LDAConstants.startDspulldCommand);
        return LDACommandManager.JavaExecUnixCommand((String)LDAConstants.startDspulldCommand);
    }

    public String regenerateIndexes(LDASession lDASession, LdbmBackend ldbmBackend) throws LdapConfigException {
        String string = LDAConstants.refreshAllIndexes;
        if (ldbmBackend == null || ldbmBackend.indexes_to_refresh == null) {
            string = LDAConstants.refreshAllIndexes;
        } else {
            String string2 = "";
            int n = ldbmBackend.indexes_to_refresh.size();
            if (n > 0) {
                string2 = " -a ";
                int n2 = 0;
                while (n2 < n) {
                    string2 = String.valueOf(string2) + " " + (String)ldbmBackend.indexes_to_refresh.elementAt(n2);
                    ++n2;
                }
            }
            string = String.valueOf(LDAConstants.refreshAllIndexes) + " " + ldbmBackend.dbdir + " " + string2;
        }
        LDADebug.debug((Object)string);
        return LDACommandManager.JavaExecUnixCommand((String)string);
    }

    public void save(LDASession lDASession, boolean bl, boolean bl2) throws LdapSaveErrorException, LdapWarningException {
        LDADebug.debug((Object)"save");
        LDASessionImpl lDASessionImpl = (LDASessionImpl)lDASession;
        if (this.config.modified) {
            File file = new File("/etc/opt/SUNWconn/ldap/current", "dsserv.conf");
            if (Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath())) > (Long)this.config.included_files_timestamp.elementAt(0)) {
                throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration (Menu 'Server')."), (String)file.getAbsolutePath()));
            }
            file = new File("/etc/opt/SUNWconn/ldap/current", "mapping/radius.mapping");
            if (Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath())) > this.config.radius_timeStamp) {
                throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration (Menu 'Server')."), (String)file.getAbsolutePath()));
            }
            file = new File("/etc/opt/SUNWconn/ldap/current", "mapping/nis.mapping");
            if (Long.parseLong(LDACommandManager.getLastModifTime((String)file.getAbsolutePath())) > this.config.nis_timeStamp) {
                throw new LdapSaveErrorException(LDACatalog.printf((String)this.cat.gets("File %1 manually modified since the admin tool read it.\nPlease reload the configuration (Menu 'Server')."), (String)file.getAbsolutePath()));
            }
            if (!bl) {
                try {
                    LDACommandManager.execUnixCommand((String)"cd /etc/opt/SUNWconn/ldap/current ; cp -r . /etc/opt/SUNWconn/ldap/previous");
                }
                catch (Exception exception) {
                    this.log(LDACatalog.printf((String)this.cat.gets("Can't backup current configuration to %1 (%2)"), (String)"/etc/opt/SUNWconn/ldap/previous", (String)exception.getMessage()));
                }
            }
            this.parser.save(this.config, bl2);
            this.config.modified = false;
            this.audit(lDASessionImpl.ccat.gets("Sun Directory Services Configuration saved."));
            if (this.config.nis_service.xfrd != this.previous_xfrd_mode) {
                if (this.config.nis_service.xfrd && LDACommandManager.isNisRunning()) {
                    LDADebug.debug((Object)"Starting dsypxfrd daemon");
                    try {
                        LDACommandManager.execUnixCommand((String)LDAConstants.startDsypxfrdCommand);
                        return;
                    }
                    catch (Exception exception) {
                        LDADebug.printStackTrace((Exception)exception);
                        return;
                    }
                }
                if (!this.config.nis_service.xfrd) {
                    LDADebug.debug((Object)"Stopping dsypxfrd daemon");
                    try {
                        LDACommandManager.stopDsypxfrd();
                        return;
                    }
                    catch (Exception exception) {
                        LDADebug.printStackTrace((Exception)exception);
                        return;
                    }
                }
            }
        } else {
            this.log(this.cat.gets("save(): config not modified."));
        }
    }

    public void reload(LDASession lDASession) throws LdapConfigException {
        this.loadConfiguration();
    }

    private synchronized void init() throws LdapConfigException {
        this.parser = new LDAParser(this, this.cat);
        this.loadConfiguration();
    }

    private synchronized void loadConfiguration() throws LdapConfigException {
        String string = this.properties.getProperty("LogDir", "/var/opt/SUNWconn/ldap/log");
        this.logstream = null;
        try {
            this.logstream = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(String.valueOf(string) + "/dsserv_admin.log")));
        }
        catch (IOException iOException) {
            LDADebug.debug((Object)LDACatalog.printf((String)"Can't open log file %1", (String)(String.valueOf(string) + "/dsserv_admin.log")));
        }
        this.parser.setLogStream(this.logstream);
        try {
            LDACommandManager.execUnixCommand((String)"cd /etc/opt/SUNWconn/ldap/current ; cp -r . /etc/opt/SUNWconn/ldap/previous");
        }
        catch (Exception exception) {
            this.log(LDACatalog.printf((String)this.cat.gets("Can't backup current configuration to %1 (%2)"), (String)"/etc/opt/SUNWconn/ldap/previous", (String)exception.getMessage()));
        }
        this.config = this.parser.load();
        this.config.modified = false;
        this.config.saved = true;
        this.oclnoatt = new Objcl();
        int n = this.config.ocl.size();
        int n2 = 0;
        while (n2 < n) {
            ClassItem classItem = (ClassItem)((ClassItem)this.config.ocl.elementAt(n2)).clone();
            classItem.required = null;
            classItem.allowed = null;
            this.oclnoatt.addElement(classItem);
            ++n2;
        }
        this.oclnoatt.hierarchical = this.config.ocl.hierarchical;
        this.oclnoatt.schema_check = this.config.ocl.schema_check;
    }

    public void log(String string) {
        try {
            this.logstream.write(String.valueOf(string) + "\n");
        }
        catch (Exception exception) {}
        LDADebug.debug((Object)string);
    }

    public void run() {
        this.cat = this.getLDACatalog();
        this.properties = new LDAProperties();
        LDADebug.debug((Object)("LDADirectoryServer: localhost is " + System.getProperty("java.rmi.server.hostname", "localhost")));
        try {
            this.properties.load(new FileInputStream("/etc/opt/SUNWconn/ldap/current/dsserv.ini"));
        }
        catch (IOException iOException) {
            LDADebug.debug((Object)("LDADirectoryServer: Can't load property file /etc/opt/SUNWconn/ldap/current/dsserv.ini " + iOException.getMessage()));
        }
        this.serverId = this.properties.getProperty("ServerId", "null");
        if (this.serverId.equals("null")) {
            this.serverId = new UID().toString();
            this.properties.put("ServerId", this.serverId);
            try {
                this.properties.save(new DataOutputStream(new FileOutputStream("/etc/opt/SUNWconn/ldap/current/dsserv.ini")), "#\n#Copyright 06/24/98 Sun Microsystems, Inc. All Rights Reserved");
            }
            catch (IOException iOException) {}
        }
        this.name = this.properties.getProperty("ServerName", "LDAP_ADMIN_SERVER");
        if (this.properties.getProperty("Debug", "false").equals("true")) {
            LDADebug.setVerbose((boolean)true);
        }
        this.properties.getProperty("LogDir", "/var/opt/SUNWconn/ldap/log");
        this.sessions = new Vector();
        try {
            this.init();
        }
        catch (LdapConfigException ldapConfigException) {
            LDADebug.printStackTrace((Exception)((Object)ldapConfigException));
            this.log(LDACatalog.printf((String)this.cat.gets("Sun Directory Services admin component initialization failed (%1)."), (String)ldapConfigException.getMessage()));
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            this.log(LDACatalog.printf((String)this.cat.gets("Sun Directory Services admin component initialization failed (%1)."), (String)exception.getMessage()));
        }
        this.getLDACatalog();
        LDADebug.debug((Object)"LDADirectoryServer:Init done");
    }

    public void referenceSession(LDASession lDASession) {
        LDADebug.debug((Object)"referenceSession");
        this.sessions.addElement(lDASession);
    }

    public void unreferenceSession(LDASession lDASession) {
        LDADebug.debug((Object)"Session unreferenced.");
        this.sessions.removeElement(lDASession);
    }

    private LDASessionImpl activeSession() {
        int n = 0;
        while (n < this.sessions.size()) {
            if (((LDASessionImpl)this.sessions.elementAt((int)n)).status == 2) {
                return (LDASessionImpl)this.sessions.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    private void reportToConsole(Exception exception, String string) throws AdminException {
        LDADebug.printStackTrace((Exception)exception);
        throw new AdminException("LDAP Directory Server", this.cat.expurge(string));
    }

    private LDASession getCurrentSession() {
        return (LDASession)this.sessions.firstElement();
    }

    public StatusMessage getStatus() throws RemoteException {
        LDADebug.debug((Object)"getStatus()");
        try {
            LDAStatusMessage lDAStatusMessage = this.updateStatus();
            if (this.currentStatus == null) {
                this.currentStatus = new LDAStatusMessage();
                this.currentStatus.type = 0;
            }
            if (lDAStatusMessage.equals(this.currentStatus)) {
                StatusMessage statusMessage = new StatusMessage(this.cat.gets("componentName"), lDAStatusMessage.date, lDAStatusMessage.type == 1 ? 1 : (lDAStatusMessage.type == 3 ? 2 : 3), lDAStatusMessage.diagnostic);
                return statusMessage;
            }
            this.currentStatus = lDAStatusMessage;
            if (this.currentStatus.type != 0) {
                if (this.currentStatus.type == 2 && (this.lastReportedStatus == 3 || this.lastReportedStatus == 0)) {
                    this.currentStatus = new LDAStatusMessage();
                    this.currentStatus.type = 1;
                    this.currentStatus.title = this.cat.gets("Sun Directory Services Available.");
                    this.currentStatus.problem = "";
                    this.currentStatus.diagnostic = "";
                    this.lastReportedStatus = 1;
                }
                StatusMessage statusMessage = new StatusMessage(this.cat.gets("componentName"), this.currentStatus.date, this.currentStatus.type == 1 ? 1 : (this.currentStatus.type == 3 ? 2 : 3), this.currentStatus.diagnostic);
                if (this.currentStatus.type == 1) {
                    this.lastReportedStatus = 1;
                } else if (this.currentStatus.type == 3) {
                    this.lastReportedStatus = 3;
                }
                LDADebug.debug((Object)("getStatus():" + this.currentStatus.toString()));
                return statusMessage;
            }
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
        }
        return null;
    }

    private LDAStatusMessage updateStatus() {
        LDAStatusMessage lDAStatusMessage = new LDAStatusMessage();
        boolean bl = this.isDsRunning(null);
        if (bl) {
            lDAStatusMessage.type = 1;
            lDAStatusMessage.title = this.cat.gets("Sun Directory Services Available.");
            lDAStatusMessage.problem = "";
            lDAStatusMessage.diagnostic = "";
        } else {
            lDAStatusMessage.type = 3;
            lDAStatusMessage.title = this.cat.gets("Sun Directory Services Not Available. Restart it.");
            lDAStatusMessage.problem = "";
            lDAStatusMessage.diagnostic = this.cat.gets("Sun Directory Services Not Available. Restart it.");
        }
        LDADebug.debug((Object)("updateStatus():" + lDAStatusMessage.toString()));
        return lDAStatusMessage;
    }

    public void setUpdateLogs(Vector vector) throws RemoteException, IOException {
        LDAParser.setUpdateLogs((Vector)vector);
    }

    public Vector getClassNames() throws RemoteException {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.config.ocl.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new String(((ClassItem)enumeration.nextElement()).name));
        }
        return vector;
    }

    public Vector getClasses() throws RemoteException {
        return this.config.ocl;
    }

    public Vector getAttributes() throws RemoteException {
        return this.config.attributes;
    }

    public void addAttribute(AttrItem attrItem) throws RemoteException, LdapConfigException {
        this.addAttr(null, attrItem);
    }

    public void modifyAttribute(AttrItem attrItem) throws RemoteException, LdapConfigException {
        this.modifyAttr(null, attrItem);
    }

    public void deleteAttribute(AttrItem attrItem) throws RemoteException, LdapConfigException {
        this.deleteAttr(null, attrItem);
    }

    public void deleteClass(ClassItem classItem) throws RemoteException, LdapConfigException {
        this.deleteClass(null, classItem);
    }

    public void addClass(ClassItem classItem) throws RemoteException, LdapConfigException {
        this.addClass(null, classItem);
    }

    public void modifyClass(ClassItem classItem) throws RemoteException, LdapConfigException {
        this.modifyClass(null, classItem);
    }

    public ClassItem getClassByName(String string) throws RemoteException {
        String string2;
        Enumeration enumeration;
        if (string == null) {
            return null;
        }
        ClassItem classItem = this.config.ocl.getClassItemFromName(string);
        if (classItem == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        if (classItem.allowed != null) {
            enumeration = classItem.allowed.elements();
            while (enumeration.hasMoreElements()) {
                string2 = ((AttrItem)enumeration.nextElement()).name;
                vector.addElement(this.config.attributes.getAttributeFromName(string2).clone());
            }
        }
        if (classItem.required != null) {
            enumeration = classItem.required.elements();
            while (enumeration.hasMoreElements()) {
                string2 = ((AttrItem)enumeration.nextElement()).name;
                vector2.addElement(this.config.attributes.getAttributeFromName(string2).clone());
            }
        }
        classItem = (ClassItem)classItem.clone();
        classItem.required = vector2;
        classItem.allowed = vector;
        return classItem;
    }

    public void audit(String string) {
        this.audit("3000", string);
    }

    public void audit(String string, String string2) {
        try {
            if (string.equals("3000")) {
                if (this.audit == null) {
                    this.audit = new AuditTrail();
                }
                this.audit.auditLog(string2);
                return;
            }
            AuditTrail auditTrail = new AuditTrail(string);
            auditTrail.auditLog(string2);
            return;
        }
        catch (AuditTrailException auditTrailException) {
            this.log(LDACatalog.printf((String)this.cat.gets("Can't instantiate AuditTrail object (%1)"), (String)auditTrailException.getMessage()));
            return;
        }
    }

    private void deleteTempHtmlFiles() {
        String string = this.properties.getProperty("PrintDocRoot", "/tmp/");
        try {
            LDACommandManager.execUnixCommand((String)("cd " + string + " ; rm -f *log*.html"));
        }
        catch (Exception exception) {}
        try {
            LDACommandManager.execUnixCommand((String)("cd " + string + " ; rm -f *log*.html"));
        }
        catch (Exception exception) {}
        try {
            LDACommandManager.execUnixCommand((String)("cd " + string + " ; rm -f ldap_main*.html"));
        }
        catch (Exception exception) {}
        try {
            LDACommandManager.execUnixCommand((String)("cd " + string + " ; rm -f ldap_att*.html"));
        }
        catch (Exception exception) {}
        try {
            LDACommandManager.execUnixCommand((String)("cd " + string + " ; rm -f ldap_ocl*.html"));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public URL generatePrintableLog(Locale locale, URL uRL, int n, int n2) {
        String string;
        LDACatalog lDACatalog = !locale.equals(Locale.getDefault()) ? this.getLDACatalog(locale) : this.cat;
        String string2 = this.properties.getProperty("PrintDocRoot", "/tmp/");
        String string3 = this.properties.getProperty("PrintBaseOffset", "/");
        String string4 = String.valueOf(this.config.log.dir) + "/";
        if (n == 0) {
            string = "ldaplog" + Integer.toString(this.logcounter) + ".html";
            string4 = String.valueOf(string4) + "dsserv.log";
            try {
                LDACommandManager.execUnixCommand((String)("cd " + string2 + " ; rm -f ldaplog*"));
            }
            catch (Exception exception) {}
        } else if (n == 1) {
            string = "nislog" + Integer.toString(this.logcounter) + ".html";
            string4 = String.valueOf(string4) + "dsnis.log";
            try {
                LDACommandManager.execUnixCommand((String)("cd " + string2 + " ; rm -f nislog*"));
            }
            catch (Exception exception) {}
        } else if (n == 2) {
            string = "radiuslog" + Integer.toString(this.logcounter) + ".html";
            string4 = String.valueOf(string4) + "dsradius.log";
            try {
                LDACommandManager.execUnixCommand((String)("cd " + string2 + " ; rm -f radiuslog*"));
            }
            catch (Exception exception) {}
        } else {
            string = "weblog" + Integer.toString(this.logcounter) + ".html";
            string4 = String.valueOf(string4) + "dsweb.log";
            try {
                LDACommandManager.execUnixCommand((String)("cd " + string2 + " ; rm -f weblog*"));
            }
            catch (Exception exception) {}
        }
        ++this.logcounter;
        try {
            Object object;
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(String.valueOf(string2) + string)));
            bufferedWriter.write(lDACatalog.gets("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<TITLE>Sun Directory Services Log</TITLE></HEAD>\n<BODY>\n"));
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            dateFormat.setTimeZone(TimeZone.getDefault());
            bufferedWriter.write(lDACatalog.gets("<H1><U>Sun Directory Services Log</U></H1>\n"));
            bufferedWriter.write(LDACatalog.printf((String)lDACatalog.gets("Server: <EM>%1</EM><BR>\n"), (String)InetAddress.getLocalHost().getHostName()));
            bufferedWriter.write(LDACatalog.printf((String)lDACatalog.gets("Generated: <EM>%1</EM><BR>\n"), (String)dateFormat.format(new Date())));
            bufferedWriter.write(LDACatalog.printf((String)lDACatalog.gets("Last <EM>%1</EM> lines of file <EM>%2</EM><BR>\n"), (String)Integer.toString(n2), (String)string4));
            bufferedWriter.write(LDACatalog.printf((String)lDACatalog.gets("Service: <EM>%1</EM><BR>\n"), (String)MainConf.getStringFromService((int)n, (LDACatalog)lDACatalog)));
            bufferedWriter.write("\n<PRE>\n");
            try {
                String string5;
                object = new String[n2];
                LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string4));
                int n3 = 0;
                while ((string5 = lineNumberReader.readLine()) != null) {
                    if (object[n3] == null) {
                        object[n3] = new String("");
                    }
                    object[n3] = string5;
                    ++n3;
                    n3 %= n2;
                }
                int n4 = n3;
                while (n4 < n2) {
                    if (object[n4] != null) {
                        bufferedWriter.write(String.valueOf(object[n4]) + "\n");
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n3) {
                    if (object[n5] != null) {
                        bufferedWriter.write(String.valueOf(object[n5]) + "\n");
                    }
                    ++n5;
                }
                lineNumberReader.close();
            }
            catch (Exception exception) {
                LDADebug.printStackTrace((Exception)exception);
            }
            bufferedWriter.write("\n</PRE></BODY>\n</HTML>\n");
            ((Writer)bufferedWriter).close();
            object = null;
            object = uRL.getProtocol().startsWith("file") ? new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(string2) + string) : new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(uRL.getFile()) + string3 + string);
            return object;
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            return null;
        }
    }

    public URL generatePrintableConfiguration(Locale locale, URL uRL) {
        LDACatalog lDACatalog = !locale.equals(Locale.getDefault()) ? this.getLDACatalog(locale) : this.cat;
        try {
            String string = "ldap_main" + Integer.toString(this.logcounter) + ".html";
            String string2 = "ldap_ocl" + Integer.toString(this.logcounter) + ".html";
            String string3 = "ldap_att" + Integer.toString(this.logcounter) + ".html";
            ++this.logcounter;
            StringBuffer stringBuffer = this.config.security_service.htmlPrint(lDACatalog);
            StringBuffer stringBuffer2 = this.config.ldap_service.htmlPrint(lDACatalog);
            StringBuffer stringBuffer3 = this.config.nis_service.htmlPrint(lDACatalog);
            StringBuffer stringBuffer4 = this.config.web_service.htmlPrint(lDACatalog);
            StringBuffer stringBuffer5 = this.config.radius_service.htmlPrint(lDACatalog);
            StringBuffer stringBuffer6 = this.config.attributes.htmlPrint(lDACatalog);
            StringBuffer stringBuffer7 = this.config.ocl.htmlPrint(lDACatalog, this.config.attributes, string3);
            StringBuffer stringBuffer8 = this.config.acl.htmlPrint(lDACatalog);
            StringBuffer stringBuffer9 = this.config.log.htmlPrint(lDACatalog);
            StringBuffer stringBuffer10 = this.getBackends(null).htmlPrint(lDACatalog, this.config.mainconf.task, this.config.mainconf.task_cr, this.config.attributes, string3);
            String string4 = this.properties.getProperty("PrintDocRoot", "/tmp/");
            String string5 = this.properties.getProperty("PrintBaseOffset", "/");
            try {
                LDACommandManager.execUnixCommand((String)("cd " + string4 + " ; rm -f ldap_main*.html"));
            }
            catch (Exception exception) {}
            try {
                LDACommandManager.execUnixCommand((String)("cd " + string4 + " ; rm -f ldap_ocl*.html"));
            }
            catch (Exception exception) {}
            try {
                LDACommandManager.execUnixCommand((String)("cd " + string4 + " ; rm -f ldap_att*.html"));
            }
            catch (Exception exception) {}
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(String.valueOf(string4) + string)));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(String.valueOf(string4) + string2)));
            BufferedWriter bufferedWriter3 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(String.valueOf(string4) + string3)));
            bufferedWriter.write(lDACatalog.gets("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<TITLE>Sun Directory Service Configuration</TITLE></HEAD>\n<BODY>\n"));
            bufferedWriter2.write(lDACatalog.gets("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<TITLE>Sun Directory Service Configuration</TITLE></HEAD>\n<BODY>\n"));
            bufferedWriter3.write(lDACatalog.gets("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<TITLE>Sun Directory Service Configuration</TITLE></HEAD>\n<BODY>\n"));
            bufferedWriter.write(lDACatalog.gets("<H1><U>Sun Directory Services Configuration</U></H1>\n"));
            bufferedWriter2.write(lDACatalog.gets("<H1><U>Sun Directory Services Configuration</U></H1>\n"));
            bufferedWriter3.write(lDACatalog.gets("<H1><U>Sun Directory Services Configuration</U></H1>\n"));
            try {
                bufferedWriter.write(LDACatalog.printf((String)lDACatalog.gets("Server: <EM>%1</EM><BR>\n"), (String)InetAddress.getLocalHost().getHostName()));
                bufferedWriter2.write(LDACatalog.printf((String)lDACatalog.gets("Server: <EM>%1</EM><BR>\n"), (String)InetAddress.getLocalHost().getHostName()));
                bufferedWriter3.write(LDACatalog.printf((String)lDACatalog.gets("Server: <EM>%1</EM><BR>\n"), (String)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {}
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            dateFormat.setTimeZone(TimeZone.getDefault());
            bufferedWriter.write(LDACatalog.printf((String)lDACatalog.gets("Generated: <EM>%1</EM><BR>\n"), (String)dateFormat.format(new Date())));
            bufferedWriter2.write(LDACatalog.printf((String)lDACatalog.gets("Generated: <EM>%1</EM><BR>\n"), (String)dateFormat.format(new Date())));
            bufferedWriter3.write(LDACatalog.printf((String)lDACatalog.gets("Generated: <EM>%1</EM><BR>\n"), (String)dateFormat.format(new Date())));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#security\">Security</A>\n"));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#ldap\">LDAP</A>\n"));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#web\">Web gateway</A>\n"));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#nis\">NIS</A>\n"));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#radius\">RADIUS</A>\n"));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#schema\">Schema</A>\n"));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#dstr\">Data Stores</A>\n"));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#acl_anchor\">Access Control Lists</A>\n"));
            bufferedWriter.write(this.cat.gets("<BR><A HREF=\"#log\">Log</A><BR>\n"));
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.write(stringBuffer2.toString());
            bufferedWriter.write(stringBuffer4.toString());
            bufferedWriter.write(stringBuffer3.toString());
            bufferedWriter.write(stringBuffer5.toString());
            StringBuffer stringBuffer11 = new StringBuffer(this.cat.gets("<P><H2><U><A NAME=\"schema\">Schema</A></U></H2>\n<TABLE CELLPADDING=2>\n"));
            stringBuffer11.append(LDACatalog.printf((String)this.cat.gets("<TR><TH ALIGN=LEFT>Schema check</TH><TD>%1</TD></TR></TABLE>\n"), (String)(this.config.ocl.schema_check == 1 ? this.cat.gets("Weak") : (this.config.ocl.schema_check == 2 ? this.cat.gets("Off") : this.cat.gets("Strong")))));
            bufferedWriter.write(stringBuffer11.toString());
            bufferedWriter.write(LDACatalog.printf((String)this.cat.gets("<BR><A HREF=\"%1\">Object classes</A>\n"), (String)string2));
            bufferedWriter.write(LDACatalog.printf((String)this.cat.gets("<BR><A HREF=\"%1\">Attributes</A>\n"), (String)string3));
            bufferedWriter.write(stringBuffer10.toString());
            bufferedWriter.write(stringBuffer8.toString());
            bufferedWriter.write(stringBuffer9.toString());
            bufferedWriter2.write(this.cat.gets("<BR><H3><U>Object Classes</U></H3>\n"));
            bufferedWriter2.write(stringBuffer7.toString());
            bufferedWriter3.write(lDACatalog.gets("<BR><H3><U>Attributes</U></H3>\n"));
            bufferedWriter3.write(stringBuffer6.toString());
            bufferedWriter.write("\n</BODY>\n</HTML>\n");
            bufferedWriter2.write("\n</BODY>\n</HTML>\n");
            bufferedWriter3.write("\n</BODY>\n</HTML>\n");
            ((Writer)bufferedWriter).close();
            ((Writer)bufferedWriter2).close();
            ((Writer)bufferedWriter3).close();
            URL uRL2 = null;
            uRL2 = uRL.getProtocol().startsWith("file") ? new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(string4) + string) : new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(uRL.getFile()) + string5 + string);
            return uRL2;
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            return null;
        }
    }

    private LDACatalog getLDACatalog() {
        return this.getLDACatalog(Locale.getDefault());
    }

    private LDACatalog getLDACatalog(Locale locale) {
        return new LDACatalog(locale);
    }

    public Date getConfigTimeStamp(LDASession lDASession) {
        return this.config.timeStamp;
    }

    public Scheduler getScheduler(LDASession lDASession) {
        return this.scheduler;
    }

    private synchronized void setSlapdMode(boolean bl) {
        try {
            if (bl) {
                LDADebug.debug((Object)"dsservd set to read-only mode.");
                LDADebug.debug((Object)LDAConstants.freezeSlapdCommand);
                LDACommandManager.execUnixCommand((String)LDAConstants.freezeSlapdCommand);
                return;
            }
            LDADebug.debug((Object)"dsservd set to read-write mode.");
            LDADebug.debug((Object)LDAConstants.unfreezeSlapdCommand);
            LDACommandManager.execUnixCommand((String)LDAConstants.unfreezeSlapdCommand);
            return;
        }
        catch (Exception exception) {
            LDADebug.printStackTrace((Exception)exception);
            LDADebug.debug((Object)("setSlapdMode: " + exception.getMessage()));
            return;
        }
    }

    public native DSCounters getStats(int var1);

    public String updateReplicas(LDASession lDASession, BackEndHeader backEndHeader, LDAReplicaItem lDAReplicaItem) throws LdapConfigException {
        String string;
        File file = new File("/tmp/dsserv.conf");
        File file2 = new File("/tmp/dsserv.conf2");
        BackEnd backEnd = (BackEnd)this.config.backends.clone();
        int n = 0;
        while (n < backEnd.size()) {
            LdbmBackend ldbmBackend = (LdbmBackend)backEnd.elementAt(n);
            if (ldbmBackend.dbdir.equals(((LdbmBackend)backEndHeader).dbdir)) {
                int n2 = 0;
                while (n2 < ldbmBackend.new_replica.size()) {
                    string = (LDAReplicaItem)ldbmBackend.new_replica.elementAt(n2);
                    if (string.equals(lDAReplicaItem, this.config.attributes)) {
                        ldbmBackend.new_replica.removeElementAt(n2);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.parser.generate_backend_file((LdbmBackend)backEndHeader, backEnd, file, file2);
        String string2 = String.valueOf(LDAConstants.refreshReplicaCommand) + ((LdbmBackend)backEndHeader).dbdir;
        string = LDACommandManager.JavaExecUnixCommand((String)string2);
        try {
            file.delete();
        }
        catch (Exception exception) {}
        try {
            file2.delete();
        }
        catch (Exception exception) {}
        return string;
    }

    public String getResourceBundleName() throws RemoteException {
        return "COM.Sun.sunsoft.ldaps.sims.tools.LDAResourceBundle";
    }

    public LDAStatus getServiceStatus(LDASession lDASession, int n) throws LdapConfigException {
        if (n == 0) {
            if (this.isDsRunning(null)) {
                return new LDAStatus(n, LDAStatus.UP, true);
            }
            return new LDAStatus(n, LDAStatus.DOWN, true);
        }
        if (n == 1) {
            boolean bl = this.parser.getFrontendState("nis");
            if (this.isDsRunning(null) && LDACommandManager.isNisRunning()) {
                return new LDAStatus(n, LDAStatus.UP, bl);
            }
            return new LDAStatus(n, LDAStatus.DOWN, bl);
        }
        if (n == 2) {
            boolean bl = this.parser.getFrontendState("radius");
            if (LDACommandManager.isRadiusRunning()) {
                return new LDAStatus(n, LDAStatus.UP, bl);
            }
            return new LDAStatus(n, LDAStatus.DOWN, bl);
        }
        if (n == 3) {
            boolean bl = false;
            if (new File("/etc/rc2.d/S86dsweb").exists()) {
                bl = true;
            }
            if (LDACommandManager.isWebRunning()) {
                return new LDAStatus(n, LDAStatus.UP, bl);
            }
            return new LDAStatus(n, LDAStatus.DOWN, bl);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setServiceStatus(LDASession lDASession, int n, int n2) throws LdapConfigException {
        if (n == 0) {
            if (n2 == LDAStatus.STOP) {
                LDACommandManager.execUnixCommand((String)"/etc/init.d/dsserv stop");
                if (new File("/etc/rc2.d/S86dsweb").exists() && LDACommandManager.isWebRunning()) {
                    LDACommandManager.execUnixCommand((String)"/etc/init.d/dsweb stop");
                }
                int n3 = 0;
                while (n3 < this.config.frontends.size()) {
                    if (((LDAFrontend)this.config.frontends.elementAt((int)n3)).name.equals("radius") && ((LDAFrontend)this.config.frontends.elementAt((int)n3)).enabled) {
                        if (!LDACommandManager.isRadiusRunning()) return;
                        LDACommandManager.execUnixCommand((String)LDAConstants.stopRadiusCommand);
                        return;
                    }
                    ++n3;
                }
                return;
            }
            if (n2 == LDAStatus.START) {
                if (!this.isDsRunning(lDASession)) {
                    LDACommandManager.execUnixCommand((String)"/etc/init.d/dsserv start");
                }
                if (!new File("/etc/rc2.d/S86dsweb").exists() || LDACommandManager.isWebRunning()) return;
                LDACommandManager.execUnixCommand((String)"/etc/init.d/dsweb start");
                return;
            }
            if (n2 != LDAStatus.REFRESH) return;
            LDACommandManager.execUnixCommand((String)"/etc/init.d/dsserv restart");
            return;
        }
        if (n == 3) {
            if (n2 == LDAStatus.STOP) {
                LDACommandManager.execUnixCommand((String)"/etc/init.d/dsweb stop");
                return;
            }
            if (n2 == LDAStatus.REFRESH) {
                throw new LdapConfigException(this.cat.gets("Refresh not supported for this service.\nStop, then restart the service for your changes to take effect."));
            }
            if (n2 == LDAStatus.START) {
                if (LDACommandManager.isWebRunning()) return;
                LDACommandManager.execUnixCommand((String)"/etc/init.d/dsweb start");
                return;
            }
            if (n2 == LDAStatus.ENABLE) {
                if (new File("/etc/rc2.d/S86dsweb").exists()) return;
                LDACommandManager.execUnixCommand((String)"ln /etc/init.d/dsweb /etc/rc2.d/S86dsweb");
                return;
            }
            File file = new File("/etc/rc2.d/S86dsweb");
            if (!file.exists()) return;
            file.delete();
            return;
        }
        if (n == 2) {
            if (n2 == LDAStatus.REFRESH) {
                LDACommandManager.execUnixCommand((String)LDAConstants.refreshRadiusCommand);
                return;
            }
            if (n2 == LDAStatus.STOP) {
                LDACommandManager.execUnixCommand((String)LDAConstants.stopRadiusCommand);
                return;
            }
            if (n2 == LDAStatus.START) {
                if (LDACommandManager.isRadiusRunning()) return;
                LDACommandManager.execUnixCommand((String)LDAConstants.startRadiusCommand);
                return;
            }
            try {
                this.parser.setFrontendState("radius", n2 == LDAStatus.ENABLE);
                return;
            }
            catch (IOException iOException) {
                throw new LdapConfigException(iOException.getMessage());
            }
        }
        if (n != 1) return;
        if (n2 == LDAStatus.REFRESH) {
            throw new LdapConfigException(this.cat.gets("Refresh not supported for this service.\nRefresh the LDAP service instead for your changes to take effect."));
        }
        if (n2 == LDAStatus.STOP) {
            try {
                this.parser.setFrontendState("nis", false);
            }
            catch (IOException iOException) {
                throw new LdapConfigException(iOException.getMessage());
            }
            int n4 = 0;
            while (n4 < this.config.frontends.size()) {
                if (((LDAFrontend)this.config.frontends.elementAt((int)n4)).name.equals("nis") && ((LDAFrontend)this.config.frontends.elementAt((int)n4)).enabled) {
                    try {
                        this.parser.setFrontendState("nis", true);
                        return;
                    }
                    catch (IOException iOException) {
                        throw new LdapConfigException(iOException.getMessage());
                    }
                }
                ++n4;
            }
            return;
        }
        if (n2 == LDAStatus.START) {
            if (!this.isDsRunning(lDASession)) return;
            try {
                this.parser.setFrontendState("nis", true);
            }
            catch (IOException iOException) {
                throw new LdapConfigException(iOException.getMessage());
            }
            int n5 = 0;
            while (n5 < this.config.frontends.size()) {
                if (((LDAFrontend)this.config.frontends.elementAt((int)n5)).name.equals("nis") && ((LDAFrontend)this.config.frontends.elementAt((int)n5)).enabled) {
                    try {
                        this.parser.setFrontendState("nis", true);
                        return;
                    }
                    catch (IOException iOException) {
                        throw new LdapConfigException(iOException.getMessage());
                    }
                }
                ++n5;
            }
            return;
        }
        try {
            this.parser.setFrontendState("nis", n2 == LDAStatus.ENABLE);
            return;
        }
        catch (IOException iOException) {
            throw new LdapConfigException(iOException.getMessage());
        }
    }
}

