/*
 * Decompiled with CFR 0.152.
 */
package COM.Sun.sunsoft.ldaps.sims.common;

import COM.Sun.sunsoft.ldaps.sims.common.Attr;
import COM.Sun.sunsoft.ldaps.sims.common.AttrItem;
import COM.Sun.sunsoft.ldaps.sims.common.BackEndHeader;
import COM.Sun.sunsoft.ldaps.sims.common.LDACatalog;
import COM.Sun.sunsoft.ldaps.sims.common.LDAIndexItem;
import COM.Sun.sunsoft.ldaps.sims.common.LDAIndexList;
import COM.Sun.sunsoft.ldaps.sims.common.LDASubtreeItem;
import java.io.Serializable;
import java.util.Vector;

public class LdbmBackend
extends BackEndHeader
implements Cloneable,
Serializable {
    private static final String copyrights = "Copyright 09/01/98 Sun Microsystems, Inc. All Rights Reserved";
    public int cache = 1000;
    public int dbcache = 100000;
    public String mode = "0600";
    public String dbdir = "";
    public LDAIndexList indexes = new LDAIndexList();
    public int congested = 500;
    public int critical = 200;
    public int back_to_normal = 1000;
    public Vector indexes_to_refresh = null;

    public StringBuffer htmlPrint(LDACatalog lDACatalog, Attr attr, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = lDACatalog.gets("On");
        String string3 = lDACatalog.gets("Off");
        int n2 = this.suffix.size();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append("<H3>" + lDACatalog.gets("DataStore") + "<A NAME = \"" + (String)this.suffix.elementAt(n3) + "\">  " + (String)this.suffix.elementAt(n3) + "</A></H3>\n");
            ++n3;
        }
        stringBuffer.append("<TABLE CELLPADDING=2>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Database directory") + "</TH><TD>" + this.dbdir + "</TD></TR>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Read-only Datastore") + "</TH><TD>" + (this.readonly ? string2 : string3) + "</TD></TR>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Last modification attributes") + "</TH><TD>" + (this.lastmod ? string2 : string3) + "</TD></TR>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Cache size (entries)") + "</TH><TD>" + Integer.toString(this.cache) + "</TD></TR>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Cache size (bytes)") + "</TH><TD>" + Integer.toString(this.dbcache) + "</TD></TR>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Congestion limits (Kb)") + "</TH><TD>" + lDACatalog.gets("critical:") + Integer.toString(this.critical) + "<BR>" + lDACatalog.gets("congested:") + Integer.toString(this.congested) + "<BR>" + lDACatalog.gets("normal: ") + Integer.toString(this.back_to_normal) + "</TD></TR>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Indexes") + "</TH><TD>");
        int n4 = this.indexes.size();
        stringBuffer.append("<TABLE BORDER CELLPADDING=2>\n");
        stringBuffer.append("<TR ALIGN=CENTER><TH>" + lDACatalog.gets("Indexed attribute") + "</TH><TH>" + lDACatalog.gets("Optimized search type") + "</TH></TR>");
        int n5 = 0;
        while (n5 < n4) {
            LDAIndexItem lDAIndexItem = (LDAIndexItem)this.indexes.elementAt(n5);
            if (((String)lDAIndexItem.names.firstElement()).equals(LDAIndexItem.getDefaultIndexName())) {
                stringBuffer.append("<TR><TD>" + (String)lDAIndexItem.names.firstElement());
            } else {
                int n6 = lDAIndexItem.names.size();
                stringBuffer.append("<TR><TD>");
                n = 0;
                while (n < n6) {
                    String string4 = (String)lDAIndexItem.names.elementAt(n);
                    AttrItem attrItem = attr.getAttributeFromAlias(string4);
                    if (attrItem != null) {
                        string4 = attrItem.name;
                    }
                    stringBuffer.append("<A HREF = \"" + string + "#" + string4.toLowerCase() + "\">" + (String)lDAIndexItem.names.elementAt(n) + "</A><BR>\n");
                    ++n;
                }
            }
            stringBuffer.append("</TD><TD>");
            if (lDAIndexItem.present) {
                stringBuffer.append(String.valueOf(lDACatalog.gets("Present")) + "<BR>");
            }
            if (lDAIndexItem.equal) {
                stringBuffer.append(String.valueOf(lDACatalog.gets("Equality")) + "<BR>");
            }
            if (lDAIndexItem.substring) {
                stringBuffer.append(String.valueOf(lDACatalog.gets("Substring")) + "<BR>");
            }
            if (lDAIndexItem.approx) {
                stringBuffer.append(String.valueOf(lDACatalog.gets("Approximate")) + "<BR>");
            }
            if (lDAIndexItem.none) {
                stringBuffer.append(String.valueOf(lDACatalog.gets("None")) + "<BR>");
            }
            stringBuffer.append("</TD></TR>\n");
            ++n5;
        }
        stringBuffer.append("</TABLE>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Naming Contexts") + "</TH><TD>");
        n4 = this.subtree.size();
        stringBuffer.append("<TABLE BORDER CELLPADDING=2>\n");
        stringBuffer.append("<TR ALIGN=CENTER><TH>" + lDACatalog.gets("Suffix") + "</TH><TH>" + lDACatalog.gets("Type") + "</TH><TH>" + lDACatalog.gets("Mode") + "</TH><TH>" + lDACatalog.gets("Master hostname") + "</TH><TH>" + lDACatalog.gets("Master update DN") + "</TH></TR>\n");
        n = 0;
        while (n < n4) {
            LDASubtreeItem lDASubtreeItem = (LDASubtreeItem)this.subtree.elementAt(n);
            if (lDASubtreeItem.subtree_suffixes != null && lDASubtreeItem.subtree_suffixes.size() > 0) {
                stringBuffer.append("<TR ALIGN=LEFT><TD>" + (String)lDASubtreeItem.subtree_suffixes.firstElement());
                stringBuffer.append("</TD><TD>" + lDACatalog.gets("Subtree") + "</TD><TD>\n");
            } else {
                stringBuffer.append("<TR ALIGN=LEFT><TD>" + (String)lDASubtreeItem.object_suffixes.firstElement());
                stringBuffer.append("</TD><TD>" + lDACatalog.gets("Object") + "</TD><TD>\n");
            }
            if (lDASubtreeItem.mode == 1) {
                stringBuffer.append(String.valueOf(lDACatalog.gets("Master")) + "</TD><TD>-</TD><TD>-</TD></TR>\n");
            } else {
                stringBuffer.append(LDACatalog.printf((String)lDACatalog.gets("%1 </TD><TD>%2 (Port %3)</TD><TD>%4</TD></TR>\n"), (String)lDACatalog.gets("Slave"), (String)lDASubtreeItem.host, (String)Integer.toString(lDASubtreeItem.port), (String)lDASubtreeItem.updateDn));
            }
            ++n;
        }
        stringBuffer.append("</TABLE>\n");
        stringBuffer.append("<TR><TH ALIGN=LEFT>" + lDACatalog.gets("Replicas") + "</TH><TD>");
        stringBuffer.append((Object)this.new_replica.htmlPrint(lDACatalog));
        stringBuffer.append("</TD></TR>");
        stringBuffer.append("</TABLE><BR>");
        return stringBuffer;
    }

    public Object clone() {
        LdbmBackend ldbmBackend = new LdbmBackend();
        ldbmBackend.copy((BackEndHeader)this);
        ldbmBackend.cache = this.cache;
        ldbmBackend.dbcache = this.dbcache;
        ldbmBackend.mode = new String(this.mode);
        ldbmBackend.dbdir = new String(this.dbdir);
        ldbmBackend.indexes = new LDAIndexList();
        ldbmBackend.critical = this.critical;
        ldbmBackend.congested = this.congested;
        ldbmBackend.back_to_normal = this.back_to_normal;
        int n = this.indexes.size();
        int n2 = 0;
        while (n2 < n) {
            ldbmBackend.indexes.addElement(((LDAIndexItem)this.indexes.elementAt(n2)).clone());
            ++n2;
        }
        if (this.indexes_to_refresh != null) {
            n = this.indexes_to_refresh.size();
            ldbmBackend.indexes_to_refresh = new Vector();
            int n3 = 0;
            while (n3 < n) {
                ldbmBackend.indexes_to_refresh.addElement(new String((String)this.indexes_to_refresh.elementAt(n3)));
                ++n3;
            }
        } else {
            ldbmBackend.indexes_to_refresh = null;
        }
        return ldbmBackend;
    }
}

