/*
 * Decompiled with CFR 0.152.
 */
package COM.Sun.sunsoft.ldaps.sims.client;

import COM.Sun.sunsoft.ldaps.sims.client.LDAServiceNisSection;
import COM.Sun.sunsoft.ldaps.sims.client.LDATable;
import COM.Sun.sunsoft.ldaps.sims.client.LdapConfigCommitInterface;
import COM.Sun.sunsoft.ldaps.sims.client.LdapConfigPropertySection;
import COM.Sun.sunsoft.ldaps.sims.client.Login;
import COM.Sun.sunsoft.ldaps.sims.common.LDACatalog;
import COM.Sun.sunsoft.ldaps.sims.common.LDAStatus;
import COM.Sun.sunsoft.ldaps.sims.common.LdapConfigException;
import COM.Sun.sunsoft.ldaps.sims.common.LdapWarningException;
import COM.Sun.sunsoft.ldaps.sims.common.MainConf;
import COM.Sun.sunsoft.sims.avm.base.ALIGNMENT;
import COM.Sun.sunsoft.sims.avm.base.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.util.Vector;

class LDAStatusSection
extends LdapConfigPropertySection
implements LdapConfigCommitInterface {
    private LDATable table;
    private Button b1;
    private Button refresh;
    private Button startup;
    private Button reread;
    private Panel buttons;
    private LDAServiceNisSection nisSection;

    public LDAStatusSection(Login login) {
        super(login);
        this.sectionName = this.cat.gets("Status");
        this.setLayout(new BorderLayout());
        this.buttons = new Panel();
        this.buttons.setLayout(new FlowLayout(1, 10, 3));
        this.b1 = Util.Button((String)this.cat.gets("Start"));
        this.refresh = Util.Button((String)this.cat.gets("Check status"));
        this.reread = Util.Button((String)this.cat.gets("Refresh"));
        this.startup = Util.Button((String)this.cat.gets("Enable Automatic Startup"));
        this.buttons.add(this.b1);
        this.buttons.add(this.startup);
        this.buttons.add(this.reread);
        this.buttons.add(this.refresh);
        this.table = new LDATable(6);
        this.table.setFont(this.login.listFont);
        this.table.setNumColumns(3);
        this.table.setColumnLabel(0, this.cat.gets("Service"));
        this.table.setColumnWidthInChars(0, 12, ALIGNMENT.LEFT);
        this.table.setColumnLabel(1, this.cat.gets("State"));
        this.table.setColumnLabel(2, this.cat.gets("Automatic Startup"));
        int n = this.cat.gets("Automatic Startup").length();
        if (this.cat.gets("Enabled").length() > n) {
            n = this.cat.gets("Enabled").length();
        }
        if (this.cat.gets("Disabled").length() > n) {
            n = this.cat.gets("Disabled").length();
        }
        this.table.setColumnWidthInChars(2, n + 2, ALIGNMENT.LEFT);
        String string = this.cat.gets("State");
        String string2 = new LDAStatus(0, LDAStatus.UP, true).getStringFromStatus(this.cat);
        String string3 = new LDAStatus(0, LDAStatus.DOWN, true).getStringFromStatus(this.cat);
        String string4 = new LDAStatus(0, LDAStatus.UP_MODIFIED, true).getStringFromStatus(this.cat);
        if (string.length() > string2.length()) {
            string2 = string;
        }
        if (string3.length() > string2.length()) {
            string2 = string3;
        }
        if (string4.length() > string2.length()) {
            string2 = string4;
        }
        this.table.setColumnWidthInChars(1, string2.length() + 1, ALIGNMENT.LEFT);
        this.add("Center", (Component)this.table);
        this.add("South", this.buttons);
        this.reset();
        this.validate();
        this.setVisible(true);
    }

    public void reset() {
        this.reset2(true);
    }

    private void reset2(boolean bl) {
        Object object;
        LDAStatus lDAStatus;
        LDAStatus lDAStatus2 = this.login.getStatus(0);
        if (bl) {
            lDAStatus = this.login.getStatus(1);
        } else {
            object = (LDAStatus)this.table.getItem(1, 3);
            lDAStatus = new LDAStatus(1, LDAStatus.DOWN, true);
            lDAStatus.state = object.state;
            lDAStatus.startup = object.startup;
        }
        object = new LDAStatus(2, LDAStatus.UP_MODIFIED, false).getStringFromStatus(this.cat);
        LDAStatus lDAStatus3 = this.login.getStatus(2);
        LDAStatus lDAStatus4 = this.login.getStatus(3);
        String string = this.cat.gets("Enabled");
        String string2 = this.cat.gets("Disabled");
        if (lDAStatus2.state == LDAStatus.DOWN) {
            this.login.restartLdap = false;
        }
        if (lDAStatus.state == LDAStatus.DOWN) {
            this.login.restartNis = false;
        }
        if (lDAStatus3.state == LDAStatus.DOWN) {
            this.login.restartRadius = false;
        }
        if (lDAStatus4.state == LDAStatus.DOWN) {
            this.login.restartWeb = false;
        }
        this.table.clear();
        Vector<String> vector = new Vector<String>();
        vector.addElement(MainConf.getStringFromService((int)lDAStatus2.service, (LDACatalog)this.cat));
        if (this.login.restartLdap && lDAStatus2.state == LDAStatus.UP) {
            vector.addElement(new String((String)object));
        } else {
            vector.addElement(lDAStatus2.getStringFromStatus(this.cat));
        }
        vector.addElement("");
        vector.addElement((String)lDAStatus2);
        this.table.addRow(vector);
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(MainConf.getStringFromService((int)lDAStatus.service, (LDACatalog)this.cat));
        if (this.login.restartNis && lDAStatus.state == LDAStatus.UP) {
            vector2.addElement(new String((String)object));
        } else {
            vector2.addElement(lDAStatus.getStringFromStatus(this.cat));
        }
        vector2.addElement(lDAStatus.startup ? new String(string) : new String(string2));
        vector2.addElement((String)lDAStatus);
        this.table.addRow(vector2);
        Vector<String> vector3 = new Vector<String>();
        vector3.addElement(MainConf.getStringFromService((int)lDAStatus3.service, (LDACatalog)this.cat));
        if (this.login.restartRadius && lDAStatus3.state == LDAStatus.UP) {
            vector3.addElement(new String((String)object));
        } else {
            vector3.addElement(lDAStatus3.getStringFromStatus(this.cat));
        }
        vector3.addElement(lDAStatus3.startup ? new String(string) : new String(string2));
        vector3.addElement((String)lDAStatus3);
        this.table.addRow(vector3);
        Vector<String> vector4 = new Vector<String>();
        vector4.addElement(MainConf.getStringFromService((int)lDAStatus4.service, (LDACatalog)this.cat));
        if (this.login.restartWeb && lDAStatus4.state == LDAStatus.UP) {
            vector4.addElement(new String((String)object));
        } else {
            vector4.addElement(lDAStatus4.getStringFromStatus(this.cat));
        }
        vector4.addElement(lDAStatus4.startup ? new String(string) : new String(string2));
        vector4.addElement((String)lDAStatus4);
        this.table.addRow(vector4);
        this.b1.setEnabled(false);
        this.reread.setEnabled(false);
        this.validate();
        if (bl) {
            try {
                this.nisSection.resetTable();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void reset3() {
        Vector[] vectorArray = this.table.getRows();
        LDAStatus lDAStatus = (LDAStatus)vectorArray[0].elementAt(3);
        LDAStatus lDAStatus2 = (LDAStatus)vectorArray[1].elementAt(3);
        LDAStatus lDAStatus3 = (LDAStatus)vectorArray[2].elementAt(3);
        LDAStatus lDAStatus4 = (LDAStatus)vectorArray[3].elementAt(3);
        if (lDAStatus.state == LDAStatus.DOWN) {
            this.login.restartLdap = false;
        }
        if (lDAStatus2.state == LDAStatus.DOWN) {
            this.login.restartNis = false;
        }
        if (lDAStatus3.state == LDAStatus.DOWN) {
            this.login.restartRadius = false;
        }
        if (lDAStatus4.state == LDAStatus.DOWN) {
            this.login.restartWeb = false;
        }
        String string = new LDAStatus(2, LDAStatus.UP_MODIFIED, false).getStringFromStatus(this.cat);
        String string2 = this.cat.gets("Enabled");
        String string3 = this.cat.gets("Disabled");
        this.table.clear();
        Vector<String> vector = new Vector<String>();
        vector.addElement(MainConf.getStringFromService((int)lDAStatus.service, (LDACatalog)this.cat));
        if (this.login.restartLdap && lDAStatus.state == LDAStatus.UP) {
            vector.addElement(new String(string));
        } else {
            vector.addElement(lDAStatus.getStringFromStatus(this.cat));
        }
        vector.addElement("");
        vector.addElement((String)lDAStatus);
        this.table.addRow(vector);
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(MainConf.getStringFromService((int)lDAStatus2.service, (LDACatalog)this.cat));
        if (this.login.restartNis && lDAStatus2.state == LDAStatus.UP) {
            vector2.addElement(new String(string));
        } else {
            vector2.addElement(lDAStatus2.getStringFromStatus(this.cat));
        }
        vector2.addElement(lDAStatus2.startup ? new String(string2) : new String(string3));
        vector2.addElement((String)lDAStatus2);
        this.table.addRow(vector2);
        Vector<String> vector3 = new Vector<String>();
        vector3.addElement(MainConf.getStringFromService((int)lDAStatus3.service, (LDACatalog)this.cat));
        if (this.login.restartRadius && lDAStatus3.state == LDAStatus.UP) {
            vector3.addElement(new String(string));
        } else {
            vector3.addElement(lDAStatus3.getStringFromStatus(this.cat));
        }
        vector3.addElement(lDAStatus3.startup ? new String(string2) : new String(string3));
        vector3.addElement((String)lDAStatus3);
        this.table.addRow(vector3);
        Vector<String> vector4 = new Vector<String>();
        vector4.addElement(MainConf.getStringFromService((int)lDAStatus4.service, (LDACatalog)this.cat));
        if (this.login.restartWeb && lDAStatus4.state == LDAStatus.UP) {
            vector4.addElement(new String(string));
        } else {
            vector4.addElement(lDAStatus4.getStringFromStatus(this.cat));
        }
        vector4.addElement(lDAStatus4.startup ? new String(string2) : new String(string3));
        vector4.addElement((String)lDAStatus4);
        this.table.addRow(vector4);
        this.b1.setEnabled(false);
        this.validate();
    }

    public LDAStatus getLocalStatus(int n) {
        Vector[] vectorArray = this.table.getRows();
        if (n == 2) {
            return (LDAStatus)vectorArray[2].elementAt(3);
        }
        if (n == 3) {
            return (LDAStatus)vectorArray[3].elementAt(3);
        }
        if (n == 1) {
            return (LDAStatus)vectorArray[1].elementAt(3);
        }
        if (n == 0) {
            return (LDAStatus)vectorArray[0].elementAt(3);
        }
        return null;
    }

    public void cleanup(boolean bl) {
    }

    public void refresh() {
        this.reset();
    }

    public void reread(LDAStatus lDAStatus) {
        this.wait_cursor();
        try {
            this.login.setStatus(lDAStatus.service, LDAStatus.REFRESH);
            if (lDAStatus.service == 2) {
                this.login.restartRadius = false;
            } else if (lDAStatus.service == 3) {
                this.login.restartWeb = false;
            } else if (lDAStatus.service == 1 || lDAStatus.service == 0) {
                this.login.restartNis = false;
                this.login.restartLdap = false;
            }
            this.reset3();
            if ((lDAStatus.service == 1 || lDAStatus.service == 0) && this.nisSection != null) {
                this.nisSection.resetTable();
            }
            this.nowait_cursor();
            return;
        }
        catch (LdapWarningException ldapWarningException) {
            this.nowait_cursor();
            this.displayWarningMessage(LDACatalog.printf((String)this.cat.gets("Refresh partially failed. (%1)"), (String)ldapWarningException.getMessage()));
            return;
        }
        catch (LdapConfigException ldapConfigException) {
            this.nowait_cursor();
            this.displayWarningMessage(LDACatalog.printf((String)this.cat.gets("Refresh failed. (%1)"), (String)ldapConfigException.getMessage()));
            return;
        }
    }

    public void setModified(boolean bl) {
    }

    public void commit() throws LdapConfigException {
        boolean bl = false;
        if (bl) {
            throw new LdapConfigException();
        }
    }

    public void prepare() throws LdapConfigException {
    }

    public boolean isModified() {
        return false;
    }

    public void setNISSection(LDAServiceNisSection lDAServiceNisSection) {
        this.nisSection = lDAServiceNisSection;
    }

    private void do_it(LDAStatus lDAStatus, int n) {
        if (lDAStatus.service == 0 ? (n == LDAStatus.START ? !this.displayConfirmationMessage(this.cat.gets("About to start the Sun Directory server.\nServices with automatic startup enabled will also be started.\nDo you really want to continue?")) : !this.displayConfirmationMessage(this.cat.gets("About to stop the Sun Directory services.\nServices with automatic startup enabled will also be stopped.\nDo you really want to continue?"))) : (n == LDAStatus.STOP ? !this.displayConfirmationMessage(this.cat.gets("Do you really want to stop the selected service?")) : (n == LDAStatus.START ? !this.displayConfirmationMessage(this.cat.gets("Do you really want to start the selected service?")) : (n == LDAStatus.ENABLE ? !this.displayConfirmationMessage(this.cat.gets("Do you really want to enable the selected service for automatic startup?")) : !this.displayConfirmationMessage(this.cat.gets("Do you really want to disable the automatic startup for the selected service?")))))) {
            return;
        }
        if (n == LDAStatus.START && lDAStatus.service == 1 && this.login.getStatus((int)0).state == LDAStatus.DOWN) {
            this.displayWarningMessage(this.cat.gets("The NIS service can't be started independently of the Sun Directory server.\nPlease enable the NIS automatic startup and restart the LDAP directory."));
            return;
        }
        if (n == LDAStatus.STOP && lDAStatus.service == 1 && this.login.getStatus((int)0).state == LDAStatus.UP) {
            this.displayWarningMessage(this.cat.gets("The NIS service can't be stopped independently of the Sun Directory server.\nPlease disable the NIS automatic startup, then stop and restart the LDAP directory."));
            return;
        }
        this.wait_cursor();
        try {
            boolean bl = true;
            if (lDAStatus.service == 0 && n == LDAStatus.START) {
                Vector[] vectorArray = this.table.getRows();
                LDAStatus lDAStatus2 = (LDAStatus)vectorArray[1].elementAt(3);
                if (lDAStatus2.startup) {
                    bl = false;
                }
            }
            this.login.setStatus(lDAStatus.service, n);
            this.reset2(bl);
            this.nowait_cursor();
            if (n == LDAStatus.STOP) {
                this.displayMessage(LDACatalog.printf((String)this.cat.gets("%1 stopped."), (String)MainConf.getStringFromService((int)lDAStatus.service, (LDACatalog)this.cat)));
            } else if (n == LDAStatus.START) {
                this.displayMessage(LDACatalog.printf((String)this.cat.gets("%1 started."), (String)MainConf.getStringFromService((int)lDAStatus.service, (LDACatalog)this.cat)));
            } else {
                this.displayMessage(LDACatalog.printf((String)this.cat.gets("%1 status changed."), (String)MainConf.getStringFromService((int)lDAStatus.service, (LDACatalog)this.cat)));
            }
        }
        catch (LdapWarningException ldapWarningException) {
            this.nowait_cursor();
            if (n == LDAStatus.STOP) {
                this.displayWarningMessage(LDACatalog.printf((String)this.cat.gets("Stop partially failed. (%1)"), (String)ldapWarningException.getMessage()));
            } else if (n == LDAStatus.START) {
                this.displayWarningMessage(LDACatalog.printf((String)this.cat.gets("Start partially failed. (%1)"), (String)ldapWarningException.getMessage()));
            } else {
                this.displayWarningMessage(LDACatalog.printf((String)this.cat.gets("Set status partially failed. (%1)"), (String)ldapWarningException.getMessage()));
            }
            this.reset2(false);
        }
        catch (LdapConfigException ldapConfigException) {
            this.nowait_cursor();
            if (n == LDAStatus.STOP) {
                this.displayWarningMessage(LDACatalog.printf((String)this.cat.gets("Stop failed. (%1)"), (String)ldapConfigException.getMessage()));
            }
            if (n == LDAStatus.START) {
                this.displayWarningMessage(LDACatalog.printf((String)this.cat.gets("Start failed. (%1)"), (String)ldapConfigException.getMessage()));
            }
            this.displayErrorMessage(LDACatalog.printf((String)this.cat.gets("Set status failed. (%1)"), (String)ldapConfigException.getMessage()));
        }
        if (lDAStatus.service == 1 || lDAStatus.service == 0) {
            this.wait_cursor();
            this.login.getMainFrame().nisWin.reset();
            this.nowait_cursor();
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            if (event.target == this.reread) {
                Vector[] vectorArray = this.table.getSelectedRows();
                LDAStatus lDAStatus = (LDAStatus)vectorArray[0].elementAt(3);
                if (!this.displayConfirmationMessage(this.cat.gets("About to refresh the selected service.\nDo you really want to continue?"))) {
                    return true;
                }
                this.reread(lDAStatus);
            } else if (event.target == this.refresh) {
                try {
                    this.wait_cursor();
                }
                catch (Exception exception) {}
                this.refresh();
                try {
                    this.nowait_cursor();
                }
                catch (Exception exception) {}
            } else if (event.target == this.b1) {
                Vector[] vectorArray = this.table.getSelectedRows();
                LDAStatus lDAStatus = (LDAStatus)vectorArray[0].elementAt(3);
                this.do_it(lDAStatus, LDAStatus.getActionFromString((String)((Button)event.target).getLabel(), (LDACatalog)this.cat));
            } else if (event.target == this.startup) {
                Vector[] vectorArray = this.table.getSelectedRows();
                LDAStatus lDAStatus = (LDAStatus)vectorArray[0].elementAt(3);
                if (lDAStatus.startup) {
                    this.do_it(lDAStatus, LDAStatus.DISABLE);
                } else {
                    this.do_it(lDAStatus, LDAStatus.ENABLE);
                }
            }
        } else if (event.id == 701) {
            if (this.table.getSelectedIndex() < 0) {
                this.b1.setEnabled(false);
                this.startup.setEnabled(false);
                this.reread.setEnabled(false);
            } else {
                Vector[] vectorArray = this.table.getSelectedRows();
                LDAStatus lDAStatus = (LDAStatus)vectorArray[0].elementAt(3);
                int n = lDAStatus.state;
                if (n == LDAStatus.UP) {
                    this.b1.setLabel(LDAStatus.getStringFromAction((int)LDAStatus.STOP, (LDACatalog)this.cat));
                    this.reread.setEnabled(true);
                } else {
                    this.b1.setLabel(LDAStatus.getStringFromAction((int)LDAStatus.START, (LDACatalog)this.cat));
                    this.reread.setEnabled(false);
                }
                this.b1.setEnabled(true);
                if (lDAStatus.service == 0) {
                    this.startup.setVisible(false);
                } else {
                    this.startup.setLabel(LDAStatus.getStringFromAction((int)(lDAStatus.startup ? LDAStatus.DISABLE : LDAStatus.ENABLE), (LDACatalog)this.cat));
                    this.startup.setVisible(true);
                }
                this.buttons.invalidate();
                this.buttons.validate();
            }
        }
        return super.handleEvent(event);
    }
}

