# 
#ident  "@(#)server.tcl	1.2 97/10/14 Copyright SMI"
#
# Copyright (c) 10/14/97 by Sun Microsystems, Inc.
# All Rights Reserved
#

# interface generated by SpecTcl version 1.0 from server.ui
#   root     is the parent window for this user interface

proc server_ui {root args} {
	global MAXX MAXY
	global Gthruput

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1 \
		-borderwidth 0 \
		-cursor {} \
		-visual {}

	frame $base.frame#3 \
		-borderwidth 0 \
		-cursor {} \
		-visual {}

	frame $base.frame#5 \
		-borderwidth 0 \
		-cursor {} \
		-visual {}

	frame $base.frame#4 \
		-borderwidth 0 \
		-cursor {} \
		-visual {}

	label $base.label#1 \
		-text "Alarm/sec:"

	label $base.label#2 \
		-textvariable Gthruput

	label $base.label#3 \
		-text "Time (pixel=sec)"

	canvas $base.canvas#2 \
		-background white \
		-borderwidth 0 \
		-cursor {} \
		-height "$MAXY" \
		-scrollregion {} \
		-takefocus {} \
		-width 0 \
		-xscrollcommand {} \
		-yscrollcommand {}

	canvas $base.canvas#1 \
		-closeenough 1.0 \
		-background white \
		-borderwidth 0 \
		-cursor {} \
		-height $MAXY \
		-scrollregion "0 0 $MAXX $MAXY" \
		-takefocus {} \
		-width $MAXY \
		-xscrollcommand "$base.scrollbar#1 set" \
		-yscrollcommand {}

	button $base.button#1 \
		-bitmap {} \
		-command {draw_map} \
		-cursor {} \
		-image {} \
		-takefocus {} \
		-text {MAP} \
		-textvariable {} \

	button $base.button#3 \
		-bitmap {} \
		-command {new} \
		-cursor {} \
		-image {} \
		-takefocus {} \
		-text {New Agent} \
		-textvariable {} \

	button $base.button#2 \
		-bitmap {} \
		-command {clearGraph} \
		-cursor {} \
		-image {} \
		-takefocus {} \
		-text {Clear Graph} \
		-textvariable {} \

	scrollbar $base.scrollbar#1 \
		-command "$base.canvas#1 xview" \
		-cursor {} \
		-orient horizontal \
		-relief flat \
		-takefocus {} \


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1  \
		-sticky nesw
	grid $base.frame#3 -in $base.frame#1	-row 1 -column 2  \
		-sticky nesw
	grid $base.frame#5 -in $base.frame#1	-row 1 -column 1  \
		-sticky {}
	grid $base.frame#4 -in $base.frame#3	-row 1 -column 1  \
		-sticky nesw
	grid $base.canvas#2 -in $base.frame#4	-row 1 -column 1  \
		-sticky nesw
	grid $base.canvas#1 -in $base.frame#4	-row 1 -column 2  \
		-sticky nesw
	grid $base.button#1 -in $base.frame#5	-row 4 -column 1  \
		-sticky {}
	grid $base.button#3 -in $base.frame#5	-row 2 -column 1  \
		-sticky {}
	grid $base.button#2 -in $base.frame#5	-row 3 -column 1  \
		-sticky {}
	grid $base.label#1 -in $base.frame#5	-row 1 -column 1  \
		-sticky {n}
	grid $base.label#2 -in $base.frame#5	-row 1 -column 2  \
		-sticky {n}
	grid $base.label#3 -in $base.frame#3	-row 2 -column 1  \
		-sticky w
	grid $base.scrollbar#1 -in $base.frame#3	-row 3 -column 1  \
		-sticky ew

	# Resize behavior management

	grid rowconfigure $base.frame#3 1 -weight 1 -minsize 30
	grid rowconfigure $base.frame#3 2 -weight 1 -minsize 8
	grid rowconfigure $base.frame#3 3 -weight 0 -minsize 5
	grid columnconfigure $base.frame#3 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize $MAXY
	grid rowconfigure $base.frame#4 2 -weight 0 -minsize 13
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 1 -minsize 100

	grid rowconfigure $root 1 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#5 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30
# additional interface code
# end additional interface code

}




# Name: new
# Params: - 
# FromFile: server.tcl
# Desc: invoke the newagent_ui procedure
proc new {} {

if [winfo exists .new] {
        return
        }

toplevel .new

newagent_ui .new
}



###
# Name: cleanString
# Params: string
# FromFile: server.tcl 
# Desc: add the char '\' in front of any chars of '{}'
#	and return the modified string
proc cleanString { str } {

set len [string length $str]

if {$len ==0} {
	return $str
	}

set retstr ""

for {set index 0} {$index < $len} {incr index 1} {
	set car [string index $str $index]
	if {$car == "\{" || $car == "\}" } {
		set retstr "$retstr\\$car"
		} else {
		set retstr "$retstr$car"
		}
	}

return $retstr
}



###
# Name: createAgent
# Params: host psel:ssel:tsel:nsap manager psel:ssel:tsel:nsap 
#         assocNb assocInfo alarmNb alarmMoc alarmMoi alarmMode alarmInfo 
#         statNb 
# FromFile: server.tcl 
# Desc: rshs a new tmnscript agent
proc createAgent {\
	host haddr manager maddr \
	assocNb assocInfo alarmNb alarmMoc \
	alarmMoi alarmMode alarmInfo statNb} {

global rootPath
global MAXX MAXY
global lhpsel lhssel lhtsel lhnsap lhnsapMode lmpsel lmssel lmtsel lmnsap lmnsapMode


## JK DEBUG
##puts "Create new agent: $host - $haddr - $manager - $maddr - $assocNb - $assocInfo - $alarmNb - $alarmMoc - $alarmMoi - $alarmMode - $alarmInfo - $statNb"

set cmd "set haddr \"$haddr\"" 
eval $cmd 
set cmd "set maddr \"$maddr\""
eval $cmd

##
# check all fields are not empty
#
if {$host==""} {
## JK ERROR MSG
	puts "all fields must be filled, 'host' is empty." 
	return}
if {$manager==""} {
	puts "all fields must be filled, 'manager' is empty." 
	return}
if {$assocNb==0} {
	puts "all fields must be filled, 'assoc->Nb' is 0." 
	return}
if {$alarmNb==0} {
	puts "all fields must be filled, 'alarm->Nb' is 0." 
	return}
if {$alarmMode==""} {
	puts "all fields must be filled, 'alarm->Mode' is empty." 
	return}
if {$statNb==0} {
	puts "all fields must be filled, 'stat->Nb' is 0." 
	return}

##
# rshs the new agent on the given host with the given parameters
#
set servername [exec /usr/bin/hostname]
if {$host == $servername} {
set cmd "exec /bin/sh $rootPath/agent $servername {$haddr} $manager {$maddr} $assocNb {$assocInfo} $alarmNb {$alarmMoc} {$alarmMoi} {$alarmMode} {$alarmInfo} $statNb &"
	} else {

##
# modify the string to handle properly the {} chars
#
set haddr [cleanString $haddr]
set maddr [cleanString $maddr]
set assocInfo [cleanString $assocInfo]
set alarmMoc [cleanString $alarmMoc]
set alarmMoi [cleanString $alarmMoi]
set alarmInfo [cleanString $alarmInfo]
set cmd "exec /usr/bin/rsh $host $rootPath/agent $servername \\'$haddr\\' $manager \\'$maddr\\' $assocNb \\'$assocInfo\\' $alarmNb \\'$alarmMoc\\' \\'$alarmMoi\\' \\'$alarmMode\\' \\'$alarmInfo\\' $statNb &"
	}

## JK DEBUG
##puts "Gonna do: $cmd"

if [catch $cmd error] {
## JK ERROR MSG
	puts "Cannot exec rsh to $host: $error"
	return
	}

##
# destroy the newagent toplevel 
#
destroy .new
}

