# 
#ident  "@(#)mapAgent.tcl	1.2 97/10/14 Copyright SMI"
#
# Copyright (c) 10/14/97 by Sun Microsystems, Inc.
# All Rights Reserved
#

############
# name: draw_map
# purpose: draw toplevel canvas for manager / agents view
#
proc draw_map {} {
global farY farX rootPath Link agentList

##
# Check toplevel doesn't exist
#
if [winfo exists .map] {
        return
        }

toplevel .map
wm iconname   .map "Wrkld Map"
wm title .map "Alarm Generator: Map"
wm protocol .map  WM_DELETE_WINDOW {set farY 10 ; destroy .map}
wm protocol .map  WM_SAVE_YOURSELF {set farY 10 ; destroy .map}
map_ui .map
set farX 50
set farY 10

##
# Bindings
#
.map.canvas#1 bind omc <Any-Enter> {.map.canvas#1 itemconfigure current -foreground red }
.map.canvas#1 bind omc <Any-Leave> { .map.canvas#1 itemconfigure current -foreground black }
.map.canvas#1 bind omc <Button-1> { set curX %x ; set curY %y }
.map.canvas#1 bind omc <Double-Button-1> {new}
.map.canvas#1 bind omc <B1-Motion> { mvNode [.map.canvas#1 find withtag current] [expr %x-$curX] [expr %y-$curY]
                                set curX %x ; set curY %y }

.map.canvas#1 bind bscmain <Any-Enter> {.map.canvas#1 itemconfigure current -foreground red }
.map.canvas#1 bind bscmain <Any-Leave> { .map.canvas#1 itemconfigure current -foreground black }
.map.canvas#1 bind bscname <Any-Enter> {.map.canvas#1 itemconfigure current -fill red }
.map.canvas#1 bind bscname <Any-Leave> { .map.canvas#1 itemconfigure current -fill black }
.map.canvas#1 bind bsc <Button-1> { set curX %x ; set curY %y }
.map.canvas#1 bind bsc <Double-Button-1> {seeClient [lindex [.map.canvas#1 gettag current] 2] }
.map.canvas#1 bind bsc <B1-Motion> { mvNode [.map.canvas#1 find withtag current] [expr %x-$curX] [expr %y-$curY]
                                set curX %x ; set curY %y }

##
# draw manager + agents if exist
#
set x 10 
set y 70
set new [ .map.canvas#1 create bitmap $x $y -bitmap "@$rootPath/omc.icn" -background white -anchor nw -tag [list omc omc omc]]
set Link($new) ""
foreach agent $agentList {
	addBSC $agent
	}

}


##################
#
# add new node
#
##################
proc addBSC { name } {
global Link farX farY rootPath


##
# Check toplevel exists
#
if { [winfo exists .map] == 0}  {
        return
        }

set from [.map.canvas#1 find withtag omc]

set x $farX
set y $farY
set new [ .map.canvas#1 create bitmap $x $y -bitmap "@$rootPath/bsc.icn" -anchor nw -background white -tag [list bscmain bsc "$name"]]
set newname [ .map.canvas#1 create text [expr $x+34] [expr $y+1] -text "$name" -anchor nw \
                        -font -*-times-Medium-R-Normal--*-120-*-*-*-*-*-* -tag [ list bscname bsc "$name"] ]
set newline [.map.canvas#1 create line [expr $x-2] [expr $y+8] \
                        [expr [lindex [.map.canvas#1 coord $from] 0]+34] [expr [lindex [.map.canvas#1 coord $from] 1]+8] \
                        -width 2 -tag link ]
set Link($new) $newline
set Link($newname) $newline
lappend Link($from) $newline
incr farY 30
if {$farY >=310} {
	incr farX 120
	set farY 10
	}

##
# put links back
.map.canvas#1 lower link

}


##################
#
# delete node
#
##################
proc rmBSC { name } {
global Link farX farY rootPath

##
# Check toplevel exists
#
if { [winfo exists .map] == 0}  {
        return
        }

set from [.map.canvas#1 find withtag omc]
set ids [.map.canvas#1 find withtag $name]
set lineid $Link([lindex $ids 0])

foreach id $ids {
	unset Link($id)
	}
##
# remove the line and the index in Link($from) ...
#
set index [lsearch $Link($from) $lineid ]
if {$index >= 0} {
	set Link($from) [lreplace $Link($from) $index $index ]
	}
##
# delete the objects
#
.map.canvas#1 delete $name
.map.canvas#1 delete $lineid

}


##################
#
# move Node with links
#
##################
proc mvNode { node xDist yDist} {
global Link

        set type [lindex [.map.canvas#1 gettags $node] 1]
        set tags [lindex [.map.canvas#1 gettags $node] 2]
        .map.canvas#1 move $tags $xDist $yDist
        if {$type == "omc"} {
                foreach lk $Link($node) {
                        if {$lk != ""} {
                                set cx [lindex [.map.canvas#1 coords $lk] 0]
                                set cy [lindex [.map.canvas#1 coords $lk] 1]
                                set ex [lindex [.map.canvas#1 coords $lk] 2]
                                set ey [lindex [.map.canvas#1 coords $lk] 3]
                                .map.canvas#1 coords $lk $cx $cy [expr $ex+$xDist] [expr $ey+$yDist]
                                }
                        }
                }
        if {$type == "bsc"} {
                set cx [lindex [.map.canvas#1 coords $Link($node)] 0]
                set cy [lindex [.map.canvas#1 coords $Link($node)] 1]
                set ex [lindex [.map.canvas#1 coords $Link($node)] 2]
                set ey [lindex [.map.canvas#1 coords $Link($node)] 3]
                .map.canvas#1 coords $Link($node) [expr $cx+$xDist] [expr $cy+$yDist] $ex $ey
                }
}



########################
#
# map_ui
#
########################
proc map_ui {root args} {

        # this treats "." as a special case

        if {$root == "."} {
                set base ""
        } else {
                set base $root
        }


        canvas $base.canvas#1 \
                -closeenough 1.0 \
                -height 0 \
                -width 0 \
                -scrollregion {0 0 2048 2048} \
                -xscrollcommand "$base.scrollbar#2 set" \
                -yscrollcommand "$base.scrollbar#1 set"


        scrollbar $base.scrollbar#1 \
                -command "$base.canvas#1 yview" \
                -orient v \
                -relief groove

        scrollbar $base.scrollbar#2 \
                -command "$base.canvas#1 xview" \
                -orient h \
                -relief groove
 
 
        # Geometry management
 
        grid $base.canvas#1 -in $root -row 1 -column 1  \
                -sticky nesw
        grid $base.scrollbar#1 -in $root    -row  1 -column 2  \
                -sticky ns
        grid $base.scrollbar#2 -in $root    -row  2 -column 1  \
                -sticky ew
 
        # Resize behavior management
 
        grid rowconfigure $root 1 -weight 1 -minsize 130
        grid rowconfigure $root 2 -weight 0 -minsize 5

        grid columnconfigure $root 1 -weight 1 -minsize 187
        grid columnconfigure $root 2 -weight 0 -minsize 5
 
}

