# 
#ident  "@(#)main.tcl	1.5 98/04/28 Copyright SMI"
#
# Copyright (c) 04/28/98 by Sun Microsystems, Inc.
# All Rights Reserved
#

##################################
# Define Procedures              #
##################################

# Define a procedure to get the base directory of a package
#
proc pkgbasedir { pkgname } {
   if {[catch {exec pkgparam $pkgname BASEDIR} result]} {
        puts stderr "pkgparam $pkgname failed: $result"
        return "/opt"
   }
   return $result
}


global rootPath
set rootPath ./script


wm title . "Alarm Generator: Global Workload"

global MAXX MAXY
set MAXX 1000
set MAXY 300


##########
# Name: clearGraph
# Params: -  
# FromFile: main.tcl
# Desc: delete all the items on canvas#1
proc clearGraph {} {
global t0 tn lastx lasty MAXX MAXY

.canvas#1 delete line
set t0 $tn
set lastx 0
set lasty [expr $MAXY - 1]
}


################################################################################
# main fileevent handler.
#
# Protocol verbs are:
#
#	REGISTER agent assoc event stats	(from agent)
#	OK/ERROR				(to agent)
#	STAT agent event# assoc event stats	(from agent: give the event thruput)
#	CONFIGURE assoc# event# stats#	(to agent: new configuration parameters)
#	STOP 				(to agent: stop sending events)
#	START 				(to agent: start sending events)
#	KILL				(to agent: kill itself order)
#
proc mainHandle {channel} {

global agentList Aassoc Aindex Aevent Amode Achannel Astat Aname Athruput Gthruput
global t0 tn lastx lasty MAXX MAXY
global defaultSeeUI

##
# Read the protocol event
#
# if something wrong (i.e eof), considere the agent as killed, free resources:
if [eof $channel] {
##JK DEBUG
	##puts stderr "$channel is dead, to be closed"
	close $channel
	catch {destroy .$Aname($channel)}
	set name $Aname($channel)
	unset Aname($channel)
	unset Aassoc($name)
	unset Aevent($name)
	unset Amode($name)
	unset Achannel($name)
	unset Astat($name)
	unset Athruput($name)
	## remove the agent's name from agentList
	#	
	set index [lsearch $agentList $name]
	set agentList [lreplace $agentList $index $index]
	rmBSC $name
	return
	}

set line [gets $channel]
##JK DEBUG
##puts "Channel $channel gets $line."

##
# Actions
#
# REGISTER: initialize new resources: 
# STAT: get the new stats in stat(),
#			display it, 
#			and update the main stats window
set cmd [lindex $line 0]
if {$cmd == "REGISTER"} {

	##
	# get parameters
	set name [lindex $line 1]
	set assoc [lindex $line 2]
	set event [lindex $line 3]
	set stat [lindex $line 4]
	set mode [lindex $line 5]

	##
	# check  it is not already registered
	if { [lsearch $agentList "$name"] != -1} {
		## JK ERROR
		puts "Agent $name already defined"
		puts $channel "ERROR"
		close $channel
		return
		}

	##
	# initialize the globals
	lappend agentList "$name"
	set Aassoc($name) $assoc
	set Aevent($name) $event
	set Amode($name) $mode
	set Achannel($name) $channel
	set Astat($name) $stat
	set Aname($channel) $name
	set Athruput($name) 0
	puts $channel "OK"

	##
	# create a new client
	addBSC $name

	return
	}

##
# cmd: STAT agent throughput
#
if {$cmd == "STAT"} {
	set tn [clock seconds]
	##
	# get parameters
	set name [lindex $line 1]
	set thruput [lindex $line 2]
	##set Aassoc($name) [lindex $line 3]
	##set Aevent($name) [lindex $line 4]
	##set Astat($name) [lindex $line 5]
	
	## JK DEBUG
	##puts "Agent $name: $thruput Events/Sec"

	##
	# setup the Athruput() Gthruput variables
	#
	set Athruput($name) $thruput
	set Gthruput 0
	foreach agent $agentList {
		incr Gthruput $Athruput($agent)
		}
	## JK DEBUG
	##puts "THROUGHPUT: $Gthruput "

	##
	# Draw the next line
	#
	set x [expr $tn - $t0]
	if {$x >= $MAXX} {
		clearGraph
		return
		}
	set y [expr $MAXY - $Gthruput]
	if {$y > $MAXY} {set y $MAXY}
	.canvas#1 create line $lastx $lasty $x $y -fill red -tag line -width 2.0
	
	set lastx $x
	set lasty $y
	return
	}

## JK ERROR
if {$cmd != ""} {
	puts "Unknow command: $cmd from $line"
	}
}




##
# start a new GUI
proc seeClient { name } {
global Aassoc Aevent Astat Amode

## JK DEBUG
##puts "start new ui .$name $Aassoc($name) $Aevent($name) $Astat($name) $Amode($name)"

# check the window already doesn't exist
#
if {[winfo exists .$name] == 0} {
	toplevel .$name
	client_ui .$name $name
	# set agent name
	#
	wm title .$name "Alarm Generator: AGENT $name"	
	return
	}  else {
	wm deiconify .$name
	}
}





#
################################################################################
# Procedure to accept a incoming connection
# from a newly created agent
#
proc serverAccept {sock address port} {
global agentList

# configure the new socket
#
## JK DEBUG
##puts "Server: accepting incoming tcp connection from agent @$address,$port"
fconfigure $sock -translation crlf -buffering line
fileevent $sock readable [list mainHandle $sock]
}





#++++++++++++++++++++++++++++ main script ++++++++++++++++++++++++++++++++++++

# Source default values
#
source "$rootPath/default.tcl"

# declare & initialize all global variables
#
global agentList
set agentList ""
global masterport
set masterport $defaultTcp
global assoc event channel stat
set assoc(dummy) "dummy"
set event(dummy) "dummy"
set channel(dummy) "dummy"
set stat(dummy) "dummy"

global agentList Aassoc Aindex Aevent Achannel Astat Aname Athruput Gthruput

global lhpsel lhssel lhtsel lhnsap lhnsapMode lmpsel lmssel lmtsel lmnsap lmnsapMode
global lhost lmanager lassocnb lassocinfo lalarmnb lalarmmoc lalarmmoi lalarmmode lalarminfo lstatnb

global t0 tn lastx lasty
##
# set default values for above
#
set t0 [clock seconds]
set tn $t0
set lastx 0
set lasty [expr $MAXY-1]
set lhpsel rfc0
set lhssel Prs
set lhtsel CMIP
set lmpsel dflt
set lmssel Prs
set lmtsel CMIP
set lhost [exec /usr/bin/hostname]
set lmanager $lhost
set lhnsap $lhost
set lhnsapMode host
set lmnsap $lhnsap
set lmnsapMode host
set lassocnb $defaultAssoc
set lassocinfo $defaultAssocInfo
set lalarmnb $defaultAlarm
set lalarmmoc $defaultMoc
set lalarmmoi $defaultMoi
set lalarmmode $defaultMode
set lalarminfo $defaultInfo
set lstatnb $defaultStat

# Source all script files
#
source "$rootPath/server.tcl"
source "$rootPath/newagent.tcl"
source "$rootPath/client.tcl"
source "$rootPath/mapAgent.tcl"

# draw the main window
#
server_ui .

## 
# draw the lines & marks
#
set x 12
set y [expr $MAXY / 2]
.canvas#2 create text $x $y -text "$y"
.canvas#2 create line [expr $x + 10] $y [expr $x + 20] $y -fill red 
set x 12
set y 0
.canvas#2 create text $x [expr $y + 10] -text "$MAXY"
.canvas#2 create line [expr $x + 10] $y [expr $x + 20] $y -fill red 

draw_map 

# define bindings
#
wm protocol . WM_DELETE_WINDOW "foreach agt \$agentList {puts \$Achannel(\$agt) \"KILL\"} ; exit"

# set this interpreter as a TCP server. Get the listening port from
# the passed args.
socket -server serverAccept $masterport



