#!/opt/SUNWconn/bin/tmnscript

#
#ident  "@(#)agent.tcl	1.7 98/04/29 Copyright SMI"
#
# Copyright (c) 04/29/98 by Sun Microsystems, Inc. 
# All Rights Reserved
#


##################################
# Define Procedures              #
##################################

# Define a procedure to get the base directory of a package
#
proc pkgbasedir { pkgname } {
   if {[catch {exec pkgparam $pkgname BASEDIR} result]} {
        puts stderr "pkgparam $pkgname failed: $result"
        return "/opt"
   }
   return $result
}


# Source default values
#
global rootPath
set rootPath ./script

source "$rootPath/default.tcl"


# Load metadata
#
set basedir [pkgbasedir SUNWtmns2]
set compiler_dir $basedir/SUNWconn/TMNscript/example/compiler

source $compiler_dir/mapper.tcl
source $compiler_dir/parser.tcl
source $compiler_dir/asn1meta.tcl
source $compiler_dir/gdmometa.tcl

set basedir [pkgbasedir SUNWtmns1]
source $basedir/SUNWconn/TMNscript/script/tmns_type.tcl

set mp_mapperModeOn true
set mp_asn1ModeOn true

mp::negotiate { XMP_DECODING off }


proc bgerror {args} {
puts "+++++++++ BGERROR $args"
}

##
# Name: reportStat
# Params: -  
# FromFile: agent.tcl
# Desc: Send the number of events send per sec to the server,
#         reset the counter, re-register itself with after cmd 
proc reportStat {} {
global timerStat timerEvent totalEvent
global servsock
global currentAssoc
global masterport
global agentRunning
global hostname localAddr manager remoteAddr assocNb assocInfo alarmNb
global alarmMoc alarmMoi alarmMode alarmInfo statNb
global agentName
global mainSession assocs
global lastTime

set deltat [expr [clock seconds] - $lastTime ]
##
# process the current throughput
#
if { $deltat <= 0 } {
	set thruput 0
	} else {
	set thruput [expr $totalEvent / $deltat]
	}

##
# send it to the server
#
puts $servsock "STAT $agentName $thruput $assocNb $alarmNb $statNb"

##
# reset the counter
#
set totalEvent 0
set lastTime [clock seconds]

##
# ready to be called again
#
after $timerStat reportStat
}


##
# Name: sendEvent
# Params: -  
# FromFile:agent.tcl
# Desc: send an event request to the current association (currentAssoc)
#         if agentRunning is set to 1. Then set the current association
#         to the next one.
proc sendEvent {} {
global timerStat timerEvent totalEvent
global currentAssoc
global masterport
global agentRunning
global hostname localAddr manager remoteAddr assocNb assocInfo alarmNb
global alarmMoc alarmMoi alarmMode alarmInfo statNb
global agentName
global mainSession assocs



if {$agentRunning} {
	##
	# send the event
	#
	set cmd "mp::eventReq -ses $currentAssoc -sync sync -mode $alarmMode -moc \{$alarmMoc\} -moi \{$alarmMoi\} -info \{$alarmInfo\}"
	
	## JK DEBUG
	##puts "+++ TBS: $cmd"
	
	if {[catch {eval $cmd} error] == 0} {
	##
	# increment the number of send events
	#
		incr totalEvent 1
		## JK DEBUG
		##puts "\n+++ TBS: OK"
		} else {
		puts "\n+++ Agent $agentName, cannot Send event: $error"
		puts "+++ Agent $agentName: exiting."
		exit
		}

	}

##
# process the next session
#
if {$assocNb != 1} {
	set index [lsearch $assocs $currentAssoc]
	incr index 1
	if {$index >= [llength $assocs]} {
		set index 0
		}
	set currentAssoc [lindex $assocs $index] 
	}

##
# register next call
#
after $timerEvent sendEvent
}




##
# Name: startBulkLoading
# Params: -
# FromFile: agent.tcl
# Desc: Start sending the event Reqs: set afters to send EventReq and
#         to send Stats: set afters to send EventReq and
#         to send Stats. Reset counters
proc startBulkLoading {} {
global timerStat timerEvent totalEvent
global currentAssoc
global masterport
global agentRunning
global hostname localAddr manager remoteAddr assocNb assocInfo alarmNb
global alarmMoc alarmMoi alarmMode alarmInfo statNb
global agentName
global mainSession assocs
global lastTime


##
# stop all the pending after event handlers
#
foreach id [after info] {
	catch {after cancel $id}
	}

##
# process the timers for Stats report and Event Generator
#
set timerStat [expr $statNb * 1000]
if { $alarmNb <= 0 } {
	set alarmNb 1
	}
set timerEvent [expr 1000 / $alarmNb]

## JK DEBUG
##puts "startBulkLoading with timers: $timerStat $timerEvent"

##
# reset the total number of events
#
set totalEvent 0
set lastTime [clock seconds]

##
# Case Agent was not running (agentRunning == 0)
#
if {$agentRunning==0} {

	# reset the current assoc
	set currentAssoc [lindex $assocs 0]
	set agentRunning 1

	# All ok
	#
	after $timerStat reportStat
	after $timerEvent sendEvent

} else {
	##
	# Case Agent was running (agentRunning == 1)
	# Need to re-calculate the number of assoc to Create or Delete
	#
	## JK DEBUG
	#puts "+++ re-conf: $assocs v.s. $assocNb"
	set curNb [llength $assocs]
	if { $curNb > $assocNb } {

		set toBeRel [expr $curNb-$assocNb -1]

		# release associations
		#
		## JK DEBUG
		##puts "+++ CLOSING: $toBeRel"
		foreach ses [lrange $assocs 0 $toBeRel] {
			fileevent [mp::getFd $ses] readable ""
			catch {mp::releaseReq -ses $ses -sync sync -info {}}
			}

		# reset the associations list
		#
		set assocs [lrange $assocs [expr $toBeRel +1] end]

	} elseif { $curNb < $assocNb} {
  
		set toBeOpe [expr $assocNb - $curNb]

		# or open new ones
		#
		## JK DEBUG
		##puts "+++ OPENING: $toBeOpe"
		set req "mp::assocReq -ses $mainSession -sync sync -at \{$remoteAddr\} -info \{$assocInfo\}"
		for {set i 0} {$i < $toBeOpe} {incr i 1} {

			  if [ catch {eval $req} assocId ] {
			        ## JK ERROR
			        puts "+++ $agentName: error Establishing Assoc: $assocId, exit"
			        exit
				}
		
			# Check answer
			#
			set assocId [lindex $assocId 0]
			if { [lindex $assocId 0] == "mp::abortInd" } {
			        ## JK ERROR
			        puts stderr "+++ $agentName: Cannot Create Assoc with $remoteAddr"
			        puts stderr "+++ $agentName: Did you start the manager?"
			        puts stderr "+++ $agentName: Exiting ..."
			        exit
			        }
			
			# Add the new session into assocs
			#
			set ass [lindex [lindex [lindex $assocId 6] 4] 1]
			lappend assocs $ass
			fileevent [mp::getFd $ass] readable [list getCMIS $ass]
			}
		}
	set currentAssoc [lindex $assocs 0]
	## JK DEBUG
	##puts "\n+++ New assocs list: $assocs\n"

	# All ok
	#
	after $timerStat reportStat
	after $timerEvent sendEvent
	}
}





##
# event handler
#
proc getCMIS {ses} {
global agentName assocs

##
# signal has been receive by the main session
# try to get the session to be read
#
set cmd "mp::wait -1 $assocs"
set stbr [eval $cmd]
foreach ses $stbr {
	catch {mp::receive $ses} tmp
	puts "+++ $agentName - $ses get: $tmp"
	if [string match *abortInd* $tmp] {
		puts "+++ $agentName get Abort, exiting..."
		exit
		}
	}

}


##
# event handler
#
proc doWork {channel} {
global timerStat timerEvent totalEvent
global currentAssoc
global masterport
global agentRunning
global hostname localAddr manager remoteAddr assocNb assocInfo alarmNb
global alarmMoc alarmMoi alarmMode alarmInfo statNb
global agentName
global mainSession assocs

if [eof $channel] {
##JK DEBUG
        puts "+++ $agentName: $channel is dead, to be closed"
        close $channel
	exit
        }
set line [gets $channel]
##JK DEBUG
puts "+++ agent $agentName gets $line."

##
# evaluate the ACTION send by the server
#
if {[string compare $line "KILL"] == 0} {
##JK DEBUG
        puts "+++ $agentName to be killed, exiting..."
	foreach ses $assocs {
		catch {mp::releaseReq -ses $ses -sync async -info {}}
		}
        close $channel
	exit
        }

if {[string compare $line "START"] == 0} {
##JK DEBUG
        ##puts "+++ $agentName to be started."
	if {$agentRunning == 0} {
		startBulkLoading
		}
	return 
	}

if {[string compare $line "STOP"] == 0} {
##JK DEBUG
        ##puts "+++ $agentName to be stopped."
	if {$agentRunning == 1} {
		set agentRunning 0
		}
	return 
	}

if {[string compare [lindex $line 0] "CONFIGURE"] == 0} {
##JK DEBUG
        ##puts "+++ $agentName to be re-configured: $assocNb $alarmNb $statNb"
	set assocNb [lindex $line 1]
	set alarmNb [lindex $line 2]
	set statNb [lindex $line 3]
	startBulkLoading
	return 
	}

##JK DEBUG
puts "+++ $agentName, unknown command: $line."
}





#++++++++++++++++++++++++++++ main script ++++++++++++++++++++++++++++++++++++

# declare & initialize all global variables
#
global servsock
global timerStat timerEvent totalEvent
global masterport
global currentAssoc
global agentRunning
global hostname localAddr manager remoteAddr assocNb assocInfo alarmNb
global alarmMoc alarmMoi alarmMode alarmInfo statNb
global agentName
global mainSession assocs
global lastTime

set lastTime [clock seconds]
set timerStat 0
set timerEvent 0
set totalEvent 0
set currentAssoc "dummy"
set masterport $defaultTcp
set agentRunning 0
set hostname [lindex $argv 0]
set localAddr [lindex $argv 1]
set manager [lindex $argv 2]
set remoteAddr [lindex $argv 3]
set assocNb [lindex $argv 4]
set assocInfo [lindex $argv 5]
set alarmNb [lindex $argv 6]
set alarmMoc [lindex $argv 7]
set alarmMoi [lindex $argv 8]
set alarmMode [lindex $argv 9]
set alarmInfo [lindex $argv 10]
set statNb [lindex $argv 11]
set agentName [exec /bin/hostname]
set agentName $agentName-[pid]
set assocs ""
 
##
# Connect with the server, getting the host & port from the passed args
#

set servsock [socket $hostname $masterport]
fconfigure $servsock -translation crlf -buffering line
## JK DEBUG
##puts "++ connexion $servsock with $hostname opened on port $masterport"

##
# register the agent
#
puts $servsock "REGISTER $agentName $assocNb $alarmNb $statNb $alarmMode"

# wait for OK
#
set resp [gets $servsock ]
if {$resp != "OK" } {
	##JK ERROR
	puts "$agentName: There's something wrong, may be already registered...exit"
	exit
	} else {
	puts "agent $agentName registered, continuing..."
	}

##
# register a fileevent
# In case of modification comming from the server
fileevent $servsock readable [list doWork $servsock]


##
# start the real job here: Q3 flow and reguliar stats report

##
# start associations
#
set cmd "mp::bind -acm off \{$localAddr\}"
if [catch {eval $cmd} mainSession ] {
	puts "+++ $agentName: Cannot Bind: $mainSession, agent exiting ..."
	exit
	}

set req "mp::assocReq -ses $mainSession -sync sync -at \{$remoteAddr\} -info \{$assocInfo\}"

for {set i 0} {$i < $assocNb} {incr i 1} {
	## JK DEBUG
	##puts -nonewline "+++ Send ASSOC REQUEST to the agent:\n $req \n"
	if [ catch {eval $req} assocId ] {
		## JK ERROR
		puts "+++ $agentName: error Establishing Assoc: $assocId, exit"
		exit
		}
	## JK DEBUG
	##puts " OK: $assocId"

	# Check answer
	#
	set assocId [lindex $assocId 0]
	if { [lindex $assocId 0] == "mp::abortInd" } {
		## JK ERROR
	        puts stderr "+++ $agentName: Cannot Create Assoc with $remoteAddr"
	        puts stderr "+++ $agentName: Did you start the manager?"
	        puts stderr "+++ $agentName: Exiting ..."
		exit
		}
	
	# Add the new session into assocs
	#
	set ass [lindex [lindex [lindex $assocId 6] 4] 1]
	## JK DEBUG
	## puts "\n+++ New assoc: $ass\n"
	lappend assocs $ass
	fileevent [mp::getFd $ass] readable [list getCMIS $ass]
	}


## Call the START procedure
#
startBulkLoading


##
# Infinite loop
#
## JK DEBUG
fileevent [mp::getFd $mainSession] readable [list getCMIS $mainSession]

vwait xxx
