#
#ident  "@(#)libassoc.tcl 1.5     97/09/16 SMI"
#
# Copyright (c) 09/16/97 by Sun Microsystems, Inc. All Rights Reserved
#

###################
# Define Variable #
###################

# Systems-Management-Application-Context ISO/IEC 10040
set appcontext "2.9.0.0.2"

#####################
# Define Procedures #
#####################

# Define a procedure to bind to a session with automatic connection management
#
proc automaticAssoc { address } {
   global appcontext

   set info "\{acse-Args \{\{application-Context $appcontext\}\}\}" 
   set bind "mp::bind \{$address\} -info \{$info\}"

   puts stdout "Bind with automatic connection management:\n $bind \n"
   if [catch {eval $bind} session] {
	puts stdout "$session \n"
	exit
   }
   return $session

}


# Define a procedure to bind to a session without automatic connection management
#
proc manualAssoc { address } {

   set bind "mp::bind -acm off \{$address\}"

   puts stdout "Bind with no connection management\n $bind \n"
   if [catch {eval $bind} session] {
	puts stdout "$session \n"
	exit
   }
   return $session
}

# Define a procedure to send an association control request asynchronous
#
proc sendAssocReq { session } {
   global agent
   set info "{cmip-Assoc-Args {{access {{direct-reference 1.2.3.4} {encoding {{octet-aligned 0x0a31323334}}}}} {CMIS-Functional-Units 7}}}"
   set req "mp::assocReq -ses $session -sync async -at \{$agent\} -info \{$info\}"

   puts "Send ASSOC REQUEST to the agent:\n $req \n"
   if [catch {eval $req} reqresult] {
	puts stdout "$reqresult \n"
	exit
   }
   return $reqresult
}


# Define a procedure to send an association control response
#
proc sendAssocRsp { session id info } {

   set rsp "mp::assocRsp -ses $session -id $id -info $info"

   puts "Send ASSOC RESPONSE to the manager:\n $rsp \n"
   if [catch {eval $rsp} rspresult] {
	puts stdout "$rsperror \n"
	exit
   }
   return $rspresult 
}

# Define a procedure to send a release request
#
proc sendReleaseReq { session } {

   set req "mp::releaseReq -ses $session -sync async -info {}"

   puts "Send RELEASE REQUEST to the agent:\n $req \n"
   if [catch {eval $req} reqerror] {
	puts stdout "$reqerror \n"
	exit
   }
}

# Define a procedure to send a release response
#
proc sendReleaseRsp { session id } {

   set info "{{reason normal}}"
   set rsp "mp::releaseRsp -ses $session -id $id -info $info"

   puts "Send RELEASE RESPONSE to the manager:\n $rsp \n"
   if [catch {eval $rsp} rsperror] {
	puts stdout "$rsperror \n"
	exit
   }
}

# Define a procedure to send an abort request
#
proc sendAbortReq { session } {

  set info "{{abort-Source acse-service-provider} {cmip-Abort-Source cmise-service-provider}}"
   set req "mp::abortReq -ses $session -info $info"

   puts "Send ABORT REQUEST to the agent:\n $req \n"
   if [catch { eval $req } reqerror] {
	puts stdout "$reqerror \n"
	exit
   }
}


# Define a procedure to print the session information
#
proc sessionInfo { session } {

   if [catch { mp::getSessionInfo -acm $session} acm] {
	puts stdout "$acm \n"
	exit
   }
   if [catch {mp::getSessionInfo -bind $session} bind] {
	puts stdout "$bind \n"
	exit
   }
   if [catch {mp::getSessionInfo -connect $session} connect] {
	puts stdout "$connect \n"
	exit
   }

   puts stdout "Status information on the session	: $session"
   puts stdout "---------------------------------"
   puts stdout "Automatic Connection Management (ACM)	: $acm"
   puts stdout "Bind-state 				: $bind"
   puts stdout "Connect-state 				: $connect \n"
}

# Define a procedure to end the session
#
proc sessionUnbind { session } {
   puts stdout "Unbind the session: $session \n"
   if [catch { mp::unbind $session } result ] {
	puts stdout "$result \n"
	exit
   }
}

# Define a procedure to get the session from the info argument
#
proc getSessionfromInfo { msg } {

   set info [lindex $msg [ expr [lsearch $msg "-info"]+1]]
   set session [tmns_keylget info "session"]
   
   return $session
}

# Define a procedure to get the session from assocReq and assocRsp 
#
proc getSessionfromReq { msg } {

   set info [lindex $msg 1]
   
   return $info
}
