# Copyright (c) 09/29/97 by Sun Microsystems, Inc. All Rights Reserved
# Version 1.1 FCS built on 09/29/97


# ------------------------------
# Module
# Element1
# Encoding procedures
# ------------------------------


proc Element1.Name.encode value0 {
GraphicString.encode $value0
};

proc Element1.TesterActionSyntax.encode value0 {
BOOLEAN.encode $value0
};

# ------------------------------
# Module
# Element1
# Decoding procedures
# ------------------------------


proc Element1.Name.decode {value0 index optional explicit} {
GraphicString.decode $value0 $index $optional $explicit
};

proc Element1.TesterActionSyntax.decode {value0 index optional explicit} {
BOOLEAN.decode $value0 $index $optional $explicit
};

# ------------------------------
# Module
# ManagedObjectClassesDefinitions
# Encoding procedures
# ------------------------------


# ------------------------------
# Module
# ManagedObjectClassesDefinitions
# Decoding procedures
# ------------------------------


# ------------------------------
# Module
# Attribute-ASN1Module
# Encoding procedures
# ------------------------------


proc Attribute-ASN1Module.ActiveDestination.encode value0 {
Attribute-ASN1Module.Destination.encode $value0
};

proc Attribute-ASN1Module.AdditionalText.encode value0 {
GraphicString.encode $value0
};

proc Attribute-ASN1Module.AdditionalInformation.encode value0 {

proc intern0 value0 {
Attribute-ASN1Module.ManagementExtension.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern0 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.Allomorphs.encode value0 {

proc intern1 value0 {
CMIP-1.ObjectClass.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern1 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AdministrativeState.encode value0 {
if {$value0 == "locked"} {set value0 0}; if {$value0 == "unlocked"} {set value0 1}; if {$value0 == "shuttingDown"} {set value0 2}; ENUM.encode $value0
};

proc Attribute-ASN1Module.AttributeIdentifierList.encode value0 {

proc intern2 value0 {
CMIP-1.AttributeId.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern2 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AttributeList.encode value0 {

proc intern3 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern3 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AttributeValueChangeDefinition.encode value0 {

proc intern4 value0 {

proc intern5 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeID value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeID" }]  [if {[tmns_keylget value0 oldAttributeValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeID value1]} {set value1} else { error "Can not find key attributeID" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 newAttributeValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeID value1]} {set value1} else { error "Can not find key attributeID" }] ] } else { error "Can not find key newAttributeValue" }] 
};
intern5 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern4 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AlarmStatus.encode value0 {

proc intern6 value0 {
if {$value0 == "underRepair"} {set value0 0}; if {$value0 == "critical"} {set value0 1}; if {$value0 == "major"} {set value0 2}; if {$value0 == "minor"} {set value0 3}; if {$value0 == "alarmOutstanding"} {set value0 4}; INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern6 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AvailabilityStatus.encode value0 {

proc intern7 value0 {
if {$value0 == "inTest"} {set value0 0}; if {$value0 == "failed"} {set value0 1}; if {$value0 == "powerOff"} {set value0 2}; if {$value0 == "offLine"} {set value0 3}; if {$value0 == "offDuty"} {set value0 4}; if {$value0 == "dependency"} {set value0 5}; if {$value0 == "degraded"} {set value0 6}; if {$value0 == "notInstalled"} {set value0 7}; if {$value0 == "logFull"} {set value0 8}; INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern7 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.BackedUpStatus.encode value0 {
BOOLEAN.encode $value0
};

proc Attribute-ASN1Module.BackUpDestinationList.encode value0 {

proc intern8 value0 {
ACSE-1.AE-title.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value0 {
  append toEval " \[" intern8 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.BackUpRelationshipObject.encode value0 {
if {[tmns_keylget value0 objectName value1]} {CMIP-1.ObjectInstance.encode $value1} else {if {[tmns_keylget value0 noObject value1]} {NULL.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.CapacityAlarmThreshold.encode value0 {

proc intern9 value0 {
INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern9 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.ConfirmedMode.encode value0 {
BOOLEAN.encode $value0
};

proc Attribute-ASN1Module.ControlStatus.encode value0 {

proc intern10 value0 {
if {$value0 == "subjectToTest"} {set value0 0}; if {$value0 == "partOfServicesLocked"} {set value0 1}; if {$value0 == "reservedForTest"} {set value0 2}; if {$value0 == "suspended"} {set value0 3}; INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern10 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.Count.encode value0 {
INTEGER.encode $value0
};

proc Attribute-ASN1Module.CounterThreshold.encode value0 {

proc intern11 value0 {

proc intern12 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 comparisonLevel value1]} {INTEGER.encode $value1} else { error "Can not find key comparisonLevel" }]  [if {[tmns_keylget value0 offsetValue value1]} {INTEGER.encode $value1} else { error "Can not find key offsetValue" }]  [if {[tmns_keylget value0 notificationOnOff value1]} {BOOLEAN.encode $value1} else { error "Can not find key notificationOnOff" }] 
};
intern12 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern11 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.CorrelatedNotifications.encode value0 {

proc intern13 value0 {

proc intern14 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 correlatedNotifications value1]} {
proc intern15 value0 {
Attribute-ASN1Module.NotificationIdentifier.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern15 " [list $i] \]"
}
eval $toEval
} else { error "Can not find key correlatedNotifications" }]  [if {[tmns_keylget value0 sourceObjectInst value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};
intern14 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern13 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.CurrentLogSize.encode value0 {
INTEGER.encode $value0
};

proc Attribute-ASN1Module.Destination.encode value0 {
if {[tmns_keylget value0 single value1]} {ACSE-1.AE-title.encode $value1} else {if {[tmns_keylget value0 multiple value1]} {
proc intern16 value0 {
ACSE-1.AE-title.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern16 " [list $i] \]"
}
eval $toEval
} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.DiscriminatorConstruct.encode value0 {
CMIP-1.CMISFilter.encode $value0
};

proc Attribute-ASN1Module.EventTime.encode value0 {
GeneralizedTime.encode $value0
};

proc Attribute-ASN1Module.GaugeThreshold.encode value0 {

proc intern17 value0 {

proc intern18 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 notifyLow value1]} {Attribute-ASN1Module.NotifyThreshold.encode $value1} else { error "Can not find key notifyLow" }]  [if {[tmns_keylget value0 notifyHigh value1]} {Attribute-ASN1Module.NotifyThreshold.encode $value1} else { error "Can not find key notifyHigh" }] 
};
intern18 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern17 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.GaugeThresholdValue.encode value0 {
Attribute-ASN1Module.ObservedValue.encode $value0
};

proc Attribute-ASN1Module.GroupObjects.encode value0 {

proc intern19 value0 {
CMIP-1.ObjectInstance.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern19 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.IntervalsOfDay.encode value0 {

proc intern20 value0 {

proc intern21 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 intervalStart value1]} {Attribute-ASN1Module.Time24.encode $value1} else { error "Can not find key intervalStart" }]  [if {[tmns_keylget value0 intervalEnd value1]} {Attribute-ASN1Module.Time24.encode $value1} else { error "Can not find key intervalEnd" }] 
};
intern21 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern20 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.LogAvailability.encode value0 {
Attribute-ASN1Module.AvailabilityStatus.encode $value0
};

proc Attribute-ASN1Module.LogFullAction.encode value0 {
if {$value0 == "wrap"} {set value0 0}; if {$value0 == "halt"} {set value0 1}; ENUM.encode $value0
};

proc Attribute-ASN1Module.LoggingTime.encode value0 {
GeneralizedTime.encode $value0
};

proc Attribute-ASN1Module.LogRecordId.encode value0 {
Attribute-ASN1Module.SimpleNameType.encode $value0
};

proc Attribute-ASN1Module.MaxLogSize.encode value0 {
if {$value0 == "unlimited"} {set value0 0}; INTEGER.encode $value0
};

proc Attribute-ASN1Module.ManagementExtension.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 identifier value1]} {OID.encode $value1} else { error "Can not find key identifier" }]  [if {[tmns_keylget value0 significance value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [BOOLEAN.encode $value1] } else { error "Can not find key significance" }]  [if {[tmns_keylget value0 information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 identifier value1]} {set value1} else { error "Can not find key identifier" }] ] } else { error "Can not find key information" }] 
};

proc Attribute-ASN1Module.MonitoredAttributes.encode value0 {

proc intern22 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern22 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.NameBinding.encode value0 {
OID.encode $value0
};

proc Attribute-ASN1Module.NotificationIdentifier.encode value0 {
INTEGER.encode $value0
};

proc Attribute-ASN1Module.NotifyThreshold.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 threshold value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key threshold" }]  [if {[tmns_keylget value0 notifyOnOff value1]} {BOOLEAN.encode $value1} else { error "Can not find key notifyOnOff" }] 
};

proc Attribute-ASN1Module.NumberOfRecords.encode value0 {
INTEGER.encode $value0
};

proc Attribute-ASN1Module.ObservedValue.encode value0 {
if {[tmns_keylget value0 integer value1]} {INTEGER.encode $value1} else {if {[tmns_keylget value0 real value1]} {REAL.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.OperationalState.encode value0 {
if {$value0 == "disabled"} {set value0 0}; if {$value0 == "enabled"} {set value0 1}; ENUM.encode $value0
};

proc Attribute-ASN1Module.Packages.encode value0 {

proc intern23 value0 {
OID.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern23 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.PerceivedSeverity.encode value0 {
if {$value0 == "indeterminate"} {set value0 0}; if {$value0 == "critical"} {set value0 1}; if {$value0 == "major"} {set value0 2}; if {$value0 == "minor"} {set value0 3}; if {$value0 == "warning"} {set value0 4}; if {$value0 == "cleared"} {set value0 5}; ENUM.encode $value0
};

proc Attribute-ASN1Module.PrioritisedObject.encode value0 {

proc intern24 value0 {

proc intern25 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 object value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key object" }]  [if {[tmns_keylget value0 priority value1]} {if {$value1 == "lowest"} {set value1 0}; if {$value1 == "highest"} {set value1 127}; INTEGER.encode $value1} else { error "Can not find key priority" }] 
};
intern25 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern24 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.ProbableCause.encode value0 {
if {[tmns_keylget value0 globalValue value1]} {OID.encode $value1} else {if {[tmns_keylget value0 localValue value1]} {INTEGER.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.ProceduralStatus.encode value0 {

proc intern26 value0 {
if {$value0 == "initializationRequired"} {set value0 0}; if {$value0 == "notInitialized"} {set value0 1}; if {$value0 == "initializing"} {set value0 2}; if {$value0 == "reporting"} {set value0 3}; if {$value0 == "terminating"} {set value0 4}; INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern26 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.ProposedRepairActions.encode value0 {

proc intern27 value0 {
Attribute-ASN1Module.SpecificIdentifier.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern27 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.SchedulingAvailability.encode value0 {
Attribute-ASN1Module.AvailabilityStatus.encode $value0
};

proc Attribute-ASN1Module.SecurityAlarmCause.encode value0 {
OID.encode $value0
};

proc Attribute-ASN1Module.SecurityAlarmSeverity.encode value0 {
Attribute-ASN1Module.PerceivedSeverity.encode $value0
};

proc Attribute-ASN1Module.SecurityAlarmDetector.encode value0 {
if {[tmns_keylget value0 mechanism value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 object value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else {if {[tmns_keylget value0 application value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ACSE-1.AE-title.encode $value1] } else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.ServiceProvider.encode value0 {
Attribute-ASN1Module.ServiceUser.encode $value0
};

proc Attribute-ASN1Module.ServiceUser.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 identifier value1]} {OID.encode $value1} else { error "Can not find key identifier" }]  [if {[tmns_keylget value0 details value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 identifier value1]} {set value1} else { error "Can not find key identifier" }] } else { error "Can not find key details" }] 
};

proc Attribute-ASN1Module.SimpleNameType.encode value0 {
if {[tmns_keylget value0 number value1]} {INTEGER.encode $value1} else {if {[tmns_keylget value0 string value1]} {GraphicString.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.SpecificIdentifier.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {OID.encode $value1} else {if {[tmns_keylget value0 --nofield2 value1]} {INTEGER.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.SourceIndicator.encode value0 {
if {$value0 == "resourceOperation"} {set value0 0}; if {$value0 == "managementOperation"} {set value0 1}; if {$value0 == "unknown"} {set value0 2}; ENUM.encode $value0
};

proc Attribute-ASN1Module.SpecificProblems.encode value0 {

proc intern28 value0 {
Attribute-ASN1Module.SpecificIdentifier.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern28 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.StandbyStatus.encode value0 {
if {$value0 == "hotStandby"} {set value0 0}; if {$value0 == "coldStandby"} {set value0 1}; if {$value0 == "providingService"} {set value0 2}; INTEGER.encode $value0
};

proc Attribute-ASN1Module.StartTime.encode value0 {
GeneralizedTime.encode $value0
};

proc Attribute-ASN1Module.StopTime.encode value0 {
if {[tmns_keylget value0 specific value1]} {GeneralizedTime.encode $value1} else {if {[tmns_keylget value0 continual value1]} {NULL.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.SupportedFeatures.encode value0 {

proc intern29 value0 {

proc intern30 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 featureIdentifier value1]} {OID.encode $value1} else { error "Can not find key featureIdentifier" }]  [if {[tmns_keylget value0 featureInfo value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 featureIdentifier value1]} {set value1} else { error "Can not find key featureIdentifier" }] } else { error "Can not find key featureInfo" }] 
};
intern30 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern29 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.SystemId.encode value0 {
if {[tmns_keylget value0 name value1]} {GraphicString.encode $value1} else {if {[tmns_keylget value0 number value1]} {INTEGER.encode $value1} else {if {[tmns_keylget value0 nothing value1]} {NULL.encode $value1} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.SystemTitle.encode value0 {
if {[tmns_keylget value0 distinguishedName value1]} {InformationFramework.DistinguishedName.encode $value1} else {if {[tmns_keylget value0 oid value1]} {OID.encode $value1} else {if {[tmns_keylget value0 nothing value1]} {NULL.encode $value1} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.TideMarkInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 currentTideMark value1]} {Attribute-ASN1Module.TideMark.encode $value1} else { error "Can not find key currentTideMark" }]  [if {[tmns_keylget value0 previousTideMark value1]} {Attribute-ASN1Module.TideMark.encode $value1} else { error "Can not find key previousTideMark" }]  [if {[tmns_keylget value0 resetTime value1]} {GeneralizedTime.encode $value1} else { error "Can not find key resetTime" }] 
};

proc Attribute-ASN1Module.TideMark.encode value0 {
if {[tmns_keylget value0 maxTideMark value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } [Attribute-ASN1Module.ObservedValue.encode $value1] } else {if {[tmns_keylget value0 minTideMark value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [Attribute-ASN1Module.ObservedValue.encode $value1] } else { error "Missing choice" }}
};

proc Attribute-ASN1Module.Time24.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 hour value1]} {INTEGER.encode $value1} else { error "Can not find key hour" }]  [if {[tmns_keylget value0 minute value1]} {INTEGER.encode $value1} else { error "Can not find key minute" }] 
};

proc Attribute-ASN1Module.ThresholdInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 triggeredThreshold value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key triggeredThreshold" }]  [if {[tmns_keylget value0 observedValue value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key observedValue" }]  [if {[tmns_keylget value0 thresholdLevel value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [Attribute-ASN1Module.ThresholdLevelInd.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 armTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Attribute-ASN1Module.ThresholdLevelInd.encode value0 {
if {[tmns_keylget value0 up value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern31 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 high value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key high" }]  [if {[tmns_keylget value0 low value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};
intern31 $value1] } else {if {[tmns_keylget value0 down value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [
proc intern32 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 high value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key high" }]  [if {[tmns_keylget value0 low value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key low" }] 
};
intern32 $value1] } else { error "Missing choice" }}
};

proc Attribute-ASN1Module.TrendIndication.encode value0 {
if {$value0 == "lessSevere"} {set value0 0}; if {$value0 == "noChange"} {set value0 1}; if {$value0 == "moreSevere"} {set value0 2}; ENUM.encode $value0
};

proc Attribute-ASN1Module.UnknownStatus.encode value0 {
BOOLEAN.encode $value0
};

proc Attribute-ASN1Module.UnscheduledLogAvailability.encode value0 {
Attribute-ASN1Module.AvailabilityStatus.encode $value0
};

proc Attribute-ASN1Module.UsageState.encode value0 {
if {$value0 == "idle"} {set value0 0}; if {$value0 == "active"} {set value0 1}; if {$value0 == "busy"} {set value0 2}; ENUM.encode $value0
};

proc Attribute-ASN1Module.WeekMask.encode value0 {

proc intern33 value0 {

proc intern34 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 daysOfWeek value1]} {BIT.encode $value1} else { error "Can not find key daysOfWeek" }]  [if {[tmns_keylget value0 intervalsOfDay value1]} {Attribute-ASN1Module.IntervalsOfDay.encode $value1} else { error "Can not find key intervalsOfDay" }] 
};
intern34 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern33 " [list $i] \]"
}
eval $toEval

};

# ------------------------------
# Module
# Attribute-ASN1Module
# Decoding procedures
# ------------------------------


proc Attribute-ASN1Module.ActiveDestination.decode {value0 index optional explicit} {
Attribute-ASN1Module.Destination.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.AdditionalText.decode {value0 index optional explicit} {
GraphicString.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.AdditionalInformation.decode {value0 index optional explicit} {

proc intern35.decode {value0 index optional explicit} {
Attribute-ASN1Module.ManagementExtension.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern35.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.Allomorphs.decode {value0 index optional explicit} {

proc intern36.decode {value0 index optional explicit} {
CMIP-1.ObjectClass.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern36.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AdministrativeState.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple locked}; if {$simple == "1"} {set simple unlocked}; if {$simple == "2"} {set simple shuttingDown}; set simple 
};

proc Attribute-ASN1Module.AttributeIdentifierList.decode {value0 index optional explicit} {

proc intern37.decode {value0 index optional explicit} {
CMIP-1.AttributeId.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern37.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AttributeList.decode {value0 index optional explicit} {

proc intern38.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern38.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AttributeValueChangeDefinition.decode {value0 index optional explicit} {

proc intern39.decode {value0 index optional explicit} {

proc intern40.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result attributeID  [CMIP-1.AttributeId.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result oldAttributeValue  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeID value1]} {set value1} else { error "Can not find key attributeID" }] } else {set tmp "__tmns_opt"}; ] ; tmns_keylset result newAttributeValue  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeID value1]} {set value1} else { error "Can not find key attributeID" }] ] ; ; return $result
};
intern40.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern39.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AlarmStatus.decode {value0 index optional explicit} {

proc intern41.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple underRepair}; if {$simple == "1"} {set simple critical}; if {$simple == "2"} {set simple major}; if {$simple == "3"} {set simple minor}; if {$simple == "4"} {set simple alarmOutstanding}; set simple 
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern41.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AvailabilityStatus.decode {value0 index optional explicit} {

proc intern42.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple inTest}; if {$simple == "1"} {set simple failed}; if {$simple == "2"} {set simple powerOff}; if {$simple == "3"} {set simple offLine}; if {$simple == "4"} {set simple offDuty}; if {$simple == "5"} {set simple dependency}; if {$simple == "6"} {set simple degraded}; if {$simple == "7"} {set simple notInstalled}; if {$simple == "8"} {set simple logFull}; set simple 
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern42.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.BackedUpStatus.decode {value0 index optional explicit} {
BOOLEAN.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.BackUpDestinationList.decode {value0 index optional explicit} {

proc intern43.decode {value0 index optional explicit} {
ACSE-1.AE-title.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern43.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.BackUpRelationshipObject.decode {value0 index optional explicit} {
set tmp  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result objectName $tmp; set result } else {set tmp  [NULL.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result noObject $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.CapacityAlarmThreshold.decode {value0 index optional explicit} {

proc intern44.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern44.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.ConfirmedMode.decode {value0 index optional explicit} {
BOOLEAN.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.ControlStatus.decode {value0 index optional explicit} {

proc intern45.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple subjectToTest}; if {$simple == "1"} {set simple partOfServicesLocked}; if {$simple == "2"} {set simple reservedForTest}; if {$simple == "3"} {set simple suspended}; set simple 
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern45.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.Count.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.CounterThreshold.decode {value0 index optional explicit} {

proc intern46.decode {value0 index optional explicit} {

proc intern47.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result comparisonLevel  [INTEGER.decode $value0 $index false true] ; tmns_keylset result offsetValue  [INTEGER.decode $value0 $index false true] ; tmns_keylset result notificationOnOff  [BOOLEAN.decode $value0 $index false true] ; ; return $result
};
intern47.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern46.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.CorrelatedNotifications.decode {value0 index optional explicit} {

proc intern48.decode {value0 index optional explicit} {

proc intern49.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result correlatedNotifications  [
proc intern50.decode {value0 index optional explicit} {
Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index false true
};
if { [SET.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern50.decode $value0 $index false true]; }
; set tmp ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result sourceObjectInst  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; ; return $result
};
intern49.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern48.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.CurrentLogSize.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.Destination.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AE-title.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result single $tmp; set result } else {set tmp  [
proc intern51.decode {value0 index optional explicit} {
ACSE-1.AE-title.decode $value0 $index false true
};
if { [SET.decode $value0 $index true true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern51.decode $value0 $index false true]; }
; set tmp ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result multiple $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.DiscriminatorConstruct.decode {value0 index optional explicit} {
CMIP-1.CMISFilter.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.EventTime.decode {value0 index optional explicit} {
GeneralizedTime.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.GaugeThreshold.decode {value0 index optional explicit} {

proc intern52.decode {value0 index optional explicit} {

proc intern53.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result notifyLow  [Attribute-ASN1Module.NotifyThreshold.decode $value0 $index false true] ; tmns_keylset result notifyHigh  [Attribute-ASN1Module.NotifyThreshold.decode $value0 $index false true] ; ; return $result
};
intern53.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern52.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.GaugeThresholdValue.decode {value0 index optional explicit} {
Attribute-ASN1Module.ObservedValue.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.GroupObjects.decode {value0 index optional explicit} {

proc intern54.decode {value0 index optional explicit} {
CMIP-1.ObjectInstance.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern54.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.IntervalsOfDay.decode {value0 index optional explicit} {

proc intern55.decode {value0 index optional explicit} {

proc intern56.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result intervalStart  [Attribute-ASN1Module.Time24.decode $value0 $index false true] ; tmns_keylset result intervalEnd  [Attribute-ASN1Module.Time24.decode $value0 $index false true] ; ; return $result
};
intern56.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern55.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.LogAvailability.decode {value0 index optional explicit} {
Attribute-ASN1Module.AvailabilityStatus.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.LogFullAction.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple wrap}; if {$simple == "1"} {set simple halt}; set simple 
};

proc Attribute-ASN1Module.LoggingTime.decode {value0 index optional explicit} {
GeneralizedTime.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.LogRecordId.decode {value0 index optional explicit} {
Attribute-ASN1Module.SimpleNameType.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.MaxLogSize.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple unlimited}; set simple 
};

proc Attribute-ASN1Module.ManagementExtension.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result identifier  [OID.decode $value0 $index false true] ; tmns_keylset result significance  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } false true; BOOLEAN.decode $value0 $index false false] ; tmns_keylset result information  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result identifier value1]} {set value1} else { error "Can not find key identifier" }] ] ; ; return $result
};

proc Attribute-ASN1Module.MonitoredAttributes.decode {value0 index optional explicit} {

proc intern57.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern57.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.NameBinding.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.NotificationIdentifier.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.NotifyThreshold.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result threshold  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; tmns_keylset result notifyOnOff  [BOOLEAN.decode $value0 $index false true] ; ; return $result
};

proc Attribute-ASN1Module.NumberOfRecords.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.ObservedValue.decode {value0 index optional explicit} {
set tmp  [INTEGER.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result integer $tmp; set result } else {set tmp  [REAL.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result real $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.OperationalState.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple disabled}; if {$simple == "1"} {set simple enabled}; set simple 
};

proc Attribute-ASN1Module.Packages.decode {value0 index optional explicit} {

proc intern58.decode {value0 index optional explicit} {
OID.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern58.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.PerceivedSeverity.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple indeterminate}; if {$simple == "1"} {set simple critical}; if {$simple == "2"} {set simple major}; if {$simple == "3"} {set simple minor}; if {$simple == "4"} {set simple warning}; if {$simple == "5"} {set simple cleared}; set simple 
};

proc Attribute-ASN1Module.PrioritisedObject.decode {value0 index optional explicit} {

proc intern59.decode {value0 index optional explicit} {

proc intern60.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result object  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; tmns_keylset result priority  [set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple lowest}; if {$simple == "127"} {set simple highest}; set simple ] ; ; return $result
};
intern60.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern59.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.ProbableCause.decode {value0 index optional explicit} {
set tmp  [OID.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result globalValue $tmp; set result } else {set tmp  [INTEGER.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result localValue $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.ProceduralStatus.decode {value0 index optional explicit} {

proc intern61.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple initializationRequired}; if {$simple == "1"} {set simple notInitialized}; if {$simple == "2"} {set simple initializing}; if {$simple == "3"} {set simple reporting}; if {$simple == "4"} {set simple terminating}; set simple 
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern61.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.ProposedRepairActions.decode {value0 index optional explicit} {

proc intern62.decode {value0 index optional explicit} {
Attribute-ASN1Module.SpecificIdentifier.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern62.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.SchedulingAvailability.decode {value0 index optional explicit} {
Attribute-ASN1Module.AvailabilityStatus.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.SecurityAlarmCause.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.SecurityAlarmSeverity.decode {value0 index optional explicit} {
Attribute-ASN1Module.PerceivedSeverity.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.SecurityAlarmDetector.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result mechanism $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result object $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-title.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result application $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc Attribute-ASN1Module.ServiceProvider.decode {value0 index optional explicit} {
Attribute-ASN1Module.ServiceUser.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.ServiceUser.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result identifier  [OID.decode $value0 $index false true] ; tmns_keylset result details  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result identifier value1]} {set value1} else { error "Can not find key identifier" }] ] ; ; return $result
};

proc Attribute-ASN1Module.SimpleNameType.decode {value0 index optional explicit} {
set tmp  [INTEGER.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result number $tmp; set result } else {set tmp  [GraphicString.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result string $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.SpecificIdentifier.decode {value0 index optional explicit} {
set tmp  [OID.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield1 $tmp; set result } else {set tmp  [INTEGER.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield2 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.SourceIndicator.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple resourceOperation}; if {$simple == "1"} {set simple managementOperation}; if {$simple == "2"} {set simple unknown}; set simple 
};

proc Attribute-ASN1Module.SpecificProblems.decode {value0 index optional explicit} {

proc intern63.decode {value0 index optional explicit} {
Attribute-ASN1Module.SpecificIdentifier.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern63.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.StandbyStatus.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple hotStandby}; if {$simple == "1"} {set simple coldStandby}; if {$simple == "2"} {set simple providingService}; set simple 
};

proc Attribute-ASN1Module.StartTime.decode {value0 index optional explicit} {
GeneralizedTime.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.StopTime.decode {value0 index optional explicit} {
set tmp  [GeneralizedTime.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result specific $tmp; set result } else {set tmp  [NULL.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result continual $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.SupportedFeatures.decode {value0 index optional explicit} {

proc intern64.decode {value0 index optional explicit} {

proc intern65.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result featureIdentifier  [OID.decode $value0 $index false true] ; tmns_keylset result featureInfo  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result featureIdentifier value1]} {set value1} else { error "Can not find key featureIdentifier" }] ] ; ; return $result
};
intern65.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern64.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.SystemId.decode {value0 index optional explicit} {
set tmp  [GraphicString.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result name $tmp; set result } else {set tmp  [INTEGER.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result number $tmp; set result } else {set tmp  [NULL.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result nothing $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc Attribute-ASN1Module.SystemTitle.decode {value0 index optional explicit} {
set tmp  [InformationFramework.DistinguishedName.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result distinguishedName $tmp; set result } else {set tmp  [OID.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result oid $tmp; set result } else {set tmp  [NULL.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result nothing $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc Attribute-ASN1Module.TideMarkInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result currentTideMark  [Attribute-ASN1Module.TideMark.decode $value0 $index false true] ; tmns_keylset result previousTideMark  [Attribute-ASN1Module.TideMark.decode $value0 $index false true] ; tmns_keylset result resetTime  [GeneralizedTime.decode $value0 $index false true] ; ; return $result
};

proc Attribute-ASN1Module.TideMark.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; Attribute-ASN1Module.ObservedValue.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result maxTideMark $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; Attribute-ASN1Module.ObservedValue.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result minTideMark $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.Time24.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result hour  [INTEGER.decode $value0 $index false true] ; tmns_keylset result minute  [INTEGER.decode $value0 $index false true] ; ; return $result
};

proc Attribute-ASN1Module.ThresholdInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result triggeredThreshold  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result observedValue  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result thresholdLevel  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; Attribute-ASN1Module.ThresholdLevelInd.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result armTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Attribute-ASN1Module.ThresholdLevelInd.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern66.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result high  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result low  [Attribute-ASN1Module.ObservedValue.decode $value0 $index true true] ; ; return $result
};
intern66.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result up $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern67.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result high  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; tmns_keylset result low  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; ; return $result
};
intern67.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result down $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.TrendIndication.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple lessSevere}; if {$simple == "1"} {set simple noChange}; if {$simple == "2"} {set simple moreSevere}; set simple 
};

proc Attribute-ASN1Module.UnknownStatus.decode {value0 index optional explicit} {
BOOLEAN.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.UnscheduledLogAvailability.decode {value0 index optional explicit} {
Attribute-ASN1Module.AvailabilityStatus.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.UsageState.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple idle}; if {$simple == "1"} {set simple active}; if {$simple == "2"} {set simple busy}; set simple 
};

proc Attribute-ASN1Module.WeekMask.decode {value0 index optional explicit} {

proc intern68.decode {value0 index optional explicit} {

proc intern69.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result daysOfWeek  [BIT.decode $value0 $index false true] ; tmns_keylset result intervalsOfDay  [Attribute-ASN1Module.IntervalsOfDay.decode $value0 $index false true] ; ; return $result
};
intern69.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern68.decode $value0 $index false true]; }
; set tmp 
};

# ------------------------------
# Module
# Notification-ASN1Module
# Encoding procedures
# ------------------------------


proc Notification-ASN1Module.AlarmInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 probableCause value1]} {Attribute-ASN1Module.ProbableCause.encode $value1} else { error "Can not find key probableCause" }]  [if {[tmns_keylget value0 specificProblems value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.SpecificProblems.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 perceivedSeverity value1]} {Attribute-ASN1Module.PerceivedSeverity.encode $value1} else { error "Can not find key perceivedSeverity" }]  [if {[tmns_keylget value0 backedUpStatus value1]} {Attribute-ASN1Module.BackedUpStatus.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 backUpObject value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 trendIndication value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [Attribute-ASN1Module.TrendIndication.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 thresholdInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } [Attribute-ASN1Module.ThresholdInfo.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 notificationIdentifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [Attribute-ASN1Module.NotificationIdentifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 stateChangeDefinition value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [Attribute-ASN1Module.AttributeValueChangeDefinition.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 monitoredAttributes value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } [Attribute-ASN1Module.MonitoredAttributes.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 proposedRepairActions value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } [Attribute-ASN1Module.ProposedRepairActions.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.AttributeValueChangeInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 sourceIndicator value1]} {Attribute-ASN1Module.SourceIndicator.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeIdentifierList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.AttributeIdentifierList.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeValueChangeDefinition value1]} {Attribute-ASN1Module.AttributeValueChangeDefinition.encode $value1} else { error "Can not find key attributeValueChangeDefinition" }]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.ObjectInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 sourceIndicator value1]} {Attribute-ASN1Module.SourceIndicator.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {Attribute-ASN1Module.AttributeList.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.RelationshipChangeInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 sourceIndicator value1]} {Attribute-ASN1Module.SourceIndicator.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeIdentifierList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.AttributeIdentifierList.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 relationshipChangeDefinition value1]} {Attribute-ASN1Module.AttributeValueChangeDefinition.encode $value1} else { error "Can not find key relationshipChangeDefinition" }]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.StateChangeInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 sourceIndicator value1]} {Attribute-ASN1Module.SourceIndicator.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeIdentifierList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.AttributeIdentifierList.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 stateChangeDefinition value1]} {Attribute-ASN1Module.AttributeValueChangeDefinition.encode $value1} else { error "Can not find key stateChangeDefinition" }]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.SecurityAlarmInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 securityAlarmCause value1]} {Attribute-ASN1Module.SecurityAlarmCause.encode $value1} else { error "Can not find key securityAlarmCause" }]  [if {[tmns_keylget value0 securityAlarmSeverity value1]} {Attribute-ASN1Module.SecurityAlarmSeverity.encode $value1} else { error "Can not find key securityAlarmSeverity" }]  [if {[tmns_keylget value0 securityAlarmDetector value1]} {Attribute-ASN1Module.SecurityAlarmDetector.encode $value1} else { error "Can not find key securityAlarmDetector" }]  [if {[tmns_keylget value0 serviceUser value1]} {Attribute-ASN1Module.ServiceUser.encode $value1} else { error "Can not find key serviceUser" }]  [if {[tmns_keylget value0 serviceProvider value1]} {Attribute-ASN1Module.ServiceProvider.encode $value1} else { error "Can not find key serviceProvider" }]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

# ------------------------------
# Module
# Notification-ASN1Module
# Decoding procedures
# ------------------------------


proc Notification-ASN1Module.AlarmInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result probableCause  [Attribute-ASN1Module.ProbableCause.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result specificProblems  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.SpecificProblems.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result perceivedSeverity  [Attribute-ASN1Module.PerceivedSeverity.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result backedUpStatus  [Attribute-ASN1Module.BackedUpStatus.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result backUpObject  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result trendIndication  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.TrendIndication.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result thresholdInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.ThresholdInfo.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result notificationIdentifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result stateChangeDefinition  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AttributeValueChangeDefinition.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result monitoredAttributes  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.MonitoredAttributes.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result proposedRepairActions  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.ProposedRepairActions.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.AttributeValueChangeInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result sourceIndicator  [Attribute-ASN1Module.SourceIndicator.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeIdentifierList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AttributeIdentifierList.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result attributeValueChangeDefinition  [Attribute-ASN1Module.AttributeValueChangeDefinition.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.ObjectInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result sourceIndicator  [Attribute-ASN1Module.SourceIndicator.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeList  [Attribute-ASN1Module.AttributeList.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.RelationshipChangeInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result sourceIndicator  [Attribute-ASN1Module.SourceIndicator.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeIdentifierList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AttributeIdentifierList.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result relationshipChangeDefinition  [Attribute-ASN1Module.AttributeValueChangeDefinition.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.StateChangeInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result sourceIndicator  [Attribute-ASN1Module.SourceIndicator.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeIdentifierList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AttributeIdentifierList.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result stateChangeDefinition  [Attribute-ASN1Module.AttributeValueChangeDefinition.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.SecurityAlarmInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result securityAlarmCause  [Attribute-ASN1Module.SecurityAlarmCause.decode $value0 $index false true] ; tmns_keylset result securityAlarmSeverity  [Attribute-ASN1Module.SecurityAlarmSeverity.decode $value0 $index false true] ; tmns_keylset result securityAlarmDetector  [Attribute-ASN1Module.SecurityAlarmDetector.decode $value0 $index false true] ; tmns_keylset result serviceUser  [Attribute-ASN1Module.ServiceUser.decode $value0 $index false true] ; tmns_keylset result serviceProvider  [Attribute-ASN1Module.ServiceProvider.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

# ------------------------------
# Module
# Parameter-ASN1Module
# Encoding procedures
# ------------------------------


proc Parameter-ASN1Module.MiscellaneousError.encode value0 {
NULL.encode $value0
};

# ------------------------------
# Module
# Parameter-ASN1Module
# Decoding procedures
# ------------------------------


proc Parameter-ASN1Module.MiscellaneousError.decode {value0 index optional explicit} {
NULL.decode $value0 $index $optional $explicit
};

# ------------------------------
# Module
# CMIP-1
# Encoding procedures
# ------------------------------


proc CMIP-1.AccessControl.encode value0 {
EXTERNAL.encode $value0
};

proc CMIP-1.ActionArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 synchronization value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.CMISSync.encode $value1] } else { error "Can not find key synchronization" }]  [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { error "Can not find key scope" }]  [if {[tmns_keylget value0 filter value1]} {CMIP-1.CMISFilter.encode $value1} else { error "Can not find key filter" }]  [if {[tmns_keylget value0 actionInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } [CMIP-1.ActionInfo.encode $value1] } else { error "Can not find key actionInfo" }] 
};

proc CMIP-1.ActionError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 actionErrorInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [CMIP-1.ActionErrorInfo.encode $value1] } else { error "Can not find key actionErrorInfo" }] 
};

proc CMIP-1.ActionErrorInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 errorStatus value1]} {if {$value1 == "accessDenied"} {set value1 2}; if {$value1 == "noSuchAction"} {set value1 9}; if {$value1 == "noSuchArgument"} {set value1 14}; if {$value1 == "invalidArgumentValue"} {set value1 15}; ENUM.encode $value1} else { error "Can not find key errorStatus" }]  [if {[tmns_keylget value0 errorInfo value1]} {
proc intern70 value0 {
if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else {if {[tmns_keylget value0 actionArgument value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } [CMIP-1.NoSuchArgument.encode $value1] } else {if {[tmns_keylget value0 argumentValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [CMIP-1.InvalidArgumentValue.encode $value1] } else { error "Missing choice" }}}
};
intern70 $value1} else { error "Can not find key errorInfo" }] 
};

proc CMIP-1.ActionInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else { error "Can not find key actionType" }]  [if {[tmns_keylget value0 actionInfoArg value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 actionType value1]} {set value1} else { error "Can not find key actionType" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.ActionReply.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else { error "Can not find key actionType" }]  [if {[tmns_keylget value0 actionReplyInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 actionType value1]} {set value1} else { error "Can not find key actionType" }] ] } else { error "Can not find key actionReplyInfo" }] 
};

proc CMIP-1.ActionResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 actionReply value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.ActionReply.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.ActionTypeId.encode value0 {
if {[tmns_keylget value0 globalForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 localForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.Attribute.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 attributeValue value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { error "Can not find key attributeValue" }] 
};

proc CMIP-1.AttributeError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 errorStatus value1]} {if {$value1 == "accessDenied"} {set value1 2}; if {$value1 == "noSuchAttribute"} {set value1 5}; if {$value1 == "invalidAttributeValue"} {set value1 6}; if {$value1 == "invalidOperation"} {set value1 24}; if {$value1 == "invalidOperator"} {set value1 25}; ENUM.encode $value1} else { error "Can not find key errorStatus" }]  [if {[tmns_keylget value0 modifyOperator value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [CMIP-1.ModifyOperator.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 attributeValue value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.AttributeId.encode value0 {
if {[tmns_keylget value0 globalForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 localForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.AttributeIdError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 errorStatus value1]} {if {$value1 == "accessDenied"} {set value1 2}; if {$value1 == "noSuchAttribute"} {set value1 5}; ENUM.encode $value1} else { error "Can not find key errorStatus" }]  [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }] 
};

proc CMIP-1.BaseManagedObjectId.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }] 
};

proc CMIP-1.CMISFilter.encode value0 {
if {[tmns_keylget value0 item value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [CMIP-1.FilterItem.encode $value1] } else {if {[tmns_keylget value0 and value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } [
proc intern71 value0 {
CMIP-1.CMISFilter.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern71 " [list $i] \]"
}
eval $toEval
] } else {if {[tmns_keylget value0 or value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } [
proc intern72 value0 {
CMIP-1.CMISFilter.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern72 " [list $i] \]"
}
eval $toEval
] } else {if {[tmns_keylget value0 not value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT false} } [CMIP-1.CMISFilter.encode $value1] } else { error "Missing choice" }}}}
};

proc CMIP-1.CMISSync.encode value0 {
if {$value0 == "bestEffort"} {set value0 0}; if {$value0 == "atomic"} {set value0 1}; ENUM.encode $value0
};

proc CMIP-1.ComplexityLimitation.encode value0 {
SET.encode [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 filter value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [CMIP-1.CMISFilter.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 sync value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [CMIP-1.CMISSync.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.CreateArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 --nofield1 value1]} {
proc intern73 value0 {
if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else {if {[tmns_keylget value0 superiorObjectInstance value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else { error "Missing choice" }}
};
intern73 $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 referenceObjectInstance value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [
proc intern74 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern74 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.CreateResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern75 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern75 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.DeleteArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 synchronization value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.CMISSync.encode $value1] } else { error "Can not find key synchronization" }]  [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { error "Can not find key scope" }]  [if {[tmns_keylget value0 filter value1]} {CMIP-1.CMISFilter.encode $value1} else { error "Can not find key filter" }] 
};

proc CMIP-1.DeleteError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 deleteErrorInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [if {$value1 == "accessDenied"} {set value1 2}; ENUM.encode $value1] } else { error "Can not find key deleteErrorInfo" }] 
};

proc CMIP-1.DeleteResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.EventReply.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }]  [if {[tmns_keylget value0 eventReplyInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 eventType value1]} {set value1} else { error "Can not find key eventType" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.EventReportArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key managedObjectInstance" }]  [if {[tmns_keylget value0 eventTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }]  [if {[tmns_keylget value0 eventInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 eventType value1]} {set value1} else { error "Can not find key eventType" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.EventReportResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 eventReply value1]} {CMIP-1.EventReply.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.EventTypeId.encode value0 {
if {[tmns_keylget value0 globalForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 localForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.FilterItem.encode value0 {
if {[tmns_keylget value0 equality value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 substrings value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern76 value0 {

proc intern77 value0 {
if {[tmns_keylget value0 initialString value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [
proc intern78 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 string value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { error "Can not find key string" }] 
};
intern78 $value1] } else {if {[tmns_keylget value0 anyString value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern79 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 string value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { error "Can not find key string" }] 
};
intern79 $value1] } else {if {[tmns_keylget value0 finalString value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [
proc intern80 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 string value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { error "Can not find key string" }] 
};
intern80 $value1] } else { error "Missing choice" }}}
};
intern77 $value0
};
set toEval SEQUENCE.encode;
foreach i $value1 {
  append toEval " \[" intern76 " [list $i] \]"
}
eval $toEval
] } else {if {[tmns_keylget value0 greaterOrEqual value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 lessOrEqual value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 present value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [CMIP-1.AttributeId.encode $value1] } else {if {[tmns_keylget value0 subsetOf value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 supersetOf value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 nonNullSetIntersection value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else { error "Missing choice" }}}}}}}}
};

proc CMIP-1.GetArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 synchronization value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.CMISSync.encode $value1] } else { error "Can not find key synchronization" }]  [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { error "Can not find key scope" }]  [if {[tmns_keylget value0 filter value1]} {CMIP-1.CMISFilter.encode $value1} else { error "Can not find key filter" }]  [if {[tmns_keylget value0 attributeIdList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } [
proc intern81 value0 {
CMIP-1.AttributeId.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern81 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.GetInfoStatus.encode value0 {
if {[tmns_keylget value0 attributeIdError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.AttributeIdError.encode $value1] } else {if {[tmns_keylget value0 attribute value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.GetListError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 getInfoList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern82 value0 {
CMIP-1.GetInfoStatus.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern82 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key getInfoList" }] 
};

proc CMIP-1.GetResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern83 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern83 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.InvalidArgumentValue.encode value0 {
if {[tmns_keylget value0 actionValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.ActionInfo.encode $value1] } else {if {[tmns_keylget value0 eventValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern84 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }]  [if {[tmns_keylget value0 eventInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 eventType value1]} {set value1} else { error "Can not find key eventType" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};
intern84 $value1] } else { error "Missing choice" }}
};

proc CMIP-1.LinkedReplyArgument.encode value0 {
if {[tmns_keylget value0 getResult value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.GetResult.encode $value1] } else {if {[tmns_keylget value0 getListError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [CMIP-1.GetListError.encode $value1] } else {if {[tmns_keylget value0 setResult value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [CMIP-1.SetResult.encode $value1] } else {if {[tmns_keylget value0 setListError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [CMIP-1.SetListError.encode $value1] } else {if {[tmns_keylget value0 actionResult value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } [CMIP-1.ActionResult.encode $value1] } else {if {[tmns_keylget value0 processingFailure value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [CMIP-1.ProcessingFailure.encode $value1] } else {if {[tmns_keylget value0 deleteResult value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.DeleteResult.encode $value1] } else {if {[tmns_keylget value0 actionError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [CMIP-1.ActionError.encode $value1] } else {if {[tmns_keylget value0 deleteError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } [CMIP-1.DeleteError.encode $value1] } else { error "Missing choice" }}}}}}}}}
};

proc CMIP-1.ModifyOperator.encode value0 {
if {$value0 == "replace"} {set value0 0}; if {$value0 == "addValues"} {set value0 1}; if {$value0 == "removeValues"} {set value0 2}; if {$value0 == "setToDefault"} {set value0 3}; INTEGER.encode $value0
};

proc CMIP-1.NoSuchAction.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else { error "Can not find key actionType" }] 
};

proc CMIP-1.NoSuchArgument.encode value0 {
if {[tmns_keylget value0 actionId value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [
proc intern85 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else { error "Can not find key actionType" }] 
};
intern85 $value1] } else {if {[tmns_keylget value0 eventId value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern86 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }] 
};
intern86 $value1] } else { error "Missing choice" }}
};

proc CMIP-1.NoSuchEventType.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }] 
};

proc CMIP-1.ObjectClass.encode value0 {
if {[tmns_keylget value0 globalForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 localForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.ObjectInstance.encode value0 {
if {[tmns_keylget value0 distinguishedName value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [InformationFramework.DistinguishedName.encode $value1] } else {if {[tmns_keylget value0 nonSpecificForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [OCTET.encode $value1] } else {if {[tmns_keylget value0 localDistinguishedName value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } [InformationFramework.RDNSequence.encode $value1] } else { error "Missing choice" }}}
};

proc CMIP-1.ProcessingFailure.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 specificErrorInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.SpecificErrorInfo.encode $value1] } else { error "Can not find key specificErrorInfo" }] 
};

proc CMIP-1.Scope.encode value0 {
if {[tmns_keylget value0 scope-int value1]} {if {$value1 == "baseObject"} {set value1 0}; if {$value1 == "firstLevelOnly"} {set value1 1}; if {$value1 == "wholeSubtree"} {set value1 2}; INTEGER.encode $value1} else {if {[tmns_keylget value0 individualLevels value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [INTEGER.encode $value1] } else {if {[tmns_keylget value0 baseToNthLevel value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}}
};

proc CMIP-1.SetArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 synchronization value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.CMISSync.encode $value1] } else { error "Can not find key synchronization" }]  [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { error "Can not find key scope" }]  [if {[tmns_keylget value0 filter value1]} {CMIP-1.CMISFilter.encode $value1} else { error "Can not find key filter" }]  [if {[tmns_keylget value0 modificationList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } [
proc intern87 value0 {

proc intern88 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 modifyOperator value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [CMIP-1.ModifyOperator.encode $value1] } else { error "Can not find key modifyOperator" }]  [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 attributeValue value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};
intern88 $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern87 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key modificationList" }] 
};

proc CMIP-1.SetInfoStatus.encode value0 {
if {[tmns_keylget value0 attributeError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.AttributeError.encode $value1] } else {if {[tmns_keylget value0 attribute value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.SetListError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 setInfoList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern89 value0 {
CMIP-1.SetInfoStatus.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern89 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key setInfoList" }] 
};

proc CMIP-1.SetResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern90 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern90 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.SpecificErrorInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 errorId value1]} {OID.encode $value1} else { error "Can not find key errorId" }]  [if {[tmns_keylget value0 errorInfo value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 errorId value1]} {set value1} else { error "Can not find key errorId" }] } else { error "Can not find key errorInfo" }] 
};

proc CMIP-1.MultipleReply.encode value0 {

proc intern91 value0 {
CMIP-1.LinkedReplyArgument.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern91 " [list $i] \]"
}
eval $toEval

};

proc CMIP-1.ServiceError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 problem value1]} {if {$value1 == "noSuchObjectClass"} {set value1 0}; if {$value1 == "noSuchObjectInstance"} {set value1 1}; if {$value1 == "accessDenied"} {set value1 2}; if {$value1 == "synchronizationNotSupported"} {set value1 3}; if {$value1 == "invalidFilter"} {set value1 4}; if {$value1 == "noSuchAttribute"} {set value1 5}; if {$value1 == "invalidAttributeValue"} {set value1 6}; if {$value1 == "getListError"} {set value1 7}; if {$value1 == "setListError"} {set value1 8}; if {$value1 == "noSuchAction"} {set value1 9}; if {$value1 == "processingFailure"} {set value1 10}; if {$value1 == "duplicateManagedObjectInstance"} {set value1 11}; if {$value1 == "noSuchReferenceObject"} {set value1 12}; if {$value1 == "noSuchEventType"} {set value1 13}; if {$value1 == "noSuchArgument"} {set value1 14}; if {$value1 == "invalidArgumentValue"} {set value1 15}; if {$value1 == "invalidScope"} {set value1 16}; if {$value1 == "invalidObjectInstance"} {set value1 17}; if {$value1 == "missingAttributeValue"} {set value1 18}; if {$value1 == "classInstanceConflict"} {set value1 19}; if {$value1 == "complexityLimitation"} {set value1 20}; if {$value1 == "mistypedOperation"} {set value1 21}; if {$value1 == "noSuchInvokeId"} {set value1 22}; if {$value1 == "operationCancelled"} {set value1 23}; if {$value1 == "invalidOperation"} {set value1 24}; if {$value1 == "invalidOperator"} {set value1 25}; if {$value1 == "badAdress"} {set value1 100}; if {$value1 == "badArgument"} {set value1 101}; if {$value1 == "badClass"} {set value1 102}; if {$value1 == "badContext"} {set value1 103}; if {$value1 == "badError"} {set value1 104}; if {$value1 == "badLinkedReply"} {set value1 105}; if {$value1 == "badProceduralUse"} {set value1 106}; if {$value1 == "badResult"} {set value1 107}; if {$value1 == "badSession"} {set value1 108}; if {$value1 == "badSyntax"} {set value1 109}; if {$value1 == "badTitle"} {set value1 110}; if {$value1 == "badValue"} {set value1 111}; if {$value1 == "badWorkspace"} {set value1 112}; if {$value1 == "brokenSession"} {set value1 113}; if {$value1 == "communicationProblem"} {set value1 114}; if {$value1 == "exclusiveAttribute"} {set value1 115}; if {$value1 == "invalidConnectionIdentifier"} {set value1 116}; if {$value1 == "invalidAttributeIdentifier"} {set value1 117}; if {$value1 == "miscellaneous"} {set value1 118}; if {$value1 == "missingAttribute"} {set value1 119}; if {$value1 == "notAMultiValuedAttribute"} {set value1 120}; if {$value1 == "notSupported"} {set value1 121}; if {$value1 == "noSuchOperation"} {set value1 122}; if {$value1 == "replyLimitExceeded"} {set value1 123}; if {$value1 == "sessionTerminated"} {set value1 124}; if {$value1 == "systemError"} {set value1 125}; if {$value1 == "timeLimitExceeded"} {set value1 126}; if {$value1 == "tooManyOperations"} {set value1 127}; if {$value1 == "tooManySessions"} {set value1 128}; if {$value1 == "duplicateInvocation"} {set value1 200}; if {$value1 == "mistypedArgument"} {set value1 201}; if {$value1 == "resourceLimitation"} {set value1 202}; if {$value1 == "unrecognizedOperation"} {set value1 203}; if {$value1 == "libraryError"} {set value1 2000}; INTEGER.encode $value1} else { error "Can not find key problem" }]  [if {[tmns_keylget value0 parameter value1]} {ANY.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.CancelGetArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 getInvokeId value1]} {INTEGER.encode $value1} else { error "Can not find key getInvokeId" }] 
};

# ------------------------------
# Module
# CMIP-1
# Decoding procedures
# ------------------------------


proc CMIP-1.AccessControl.decode {value0 index optional explicit} {
EXTERNAL.decode $value0 $index $optional $explicit
};

proc CMIP-1.ActionArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result synchronization  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; CMIP-1.CMISSync.decode $value0 $index false false] ; tmns_keylset result scope  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true] ; tmns_keylset result filter  [CMIP-1.CMISFilter.decode $value0 $index false true] ; tmns_keylset result actionInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } false true; CMIP-1.ActionInfo.decode $value0 $index false false] ; ; return $result
};

proc CMIP-1.ActionError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result actionErrorInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.ActionErrorInfo.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.ActionErrorInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result errorStatus  [set simple  [ENUM.decode $value0 $index false true] ; if {$simple == "2"} {set simple accessDenied}; if {$simple == "9"} {set simple noSuchAction}; if {$simple == "14"} {set simple noSuchArgument}; if {$simple == "15"} {set simple invalidArgumentValue}; set simple ] ; tmns_keylset result errorInfo  [
proc intern92.decode {value0 index optional explicit} {
set result {}; set tmp  [CMIP-1.ActionTypeId.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result actionType $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.NoSuchArgument.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result actionArgument $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.InvalidArgumentValue.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result argumentValue $tmp; set result } else { error "Missing choice" }}}; return $result
};
intern92.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.ActionInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result actionType  [CMIP-1.ActionTypeId.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result actionInfoArg  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result actionType value1]} {set value1} else { error "Can not find key actionType" }] } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.ActionReply.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result actionType  [CMIP-1.ActionTypeId.decode $value0 $index false true] ; tmns_keylset result actionReplyInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result actionType value1]} {set value1} else { error "Can not find key actionType" }] ] ; ; return $result
};

proc CMIP-1.ActionResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result actionReply  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ActionReply.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.ActionTypeId.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result globalForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result localForm $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.Attribute.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result attributeValue  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};

proc CMIP-1.AttributeError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result errorStatus  [set simple  [ENUM.decode $value0 $index false true] ; if {$simple == "2"} {set simple accessDenied}; if {$simple == "5"} {set simple noSuchAttribute}; if {$simple == "6"} {set simple invalidAttributeValue}; if {$simple == "24"} {set simple invalidOperation}; if {$simple == "25"} {set simple invalidOperator}; set simple ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result modifyOperator  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ModifyOperator.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeValue  [ANY_DEF_BY.decode $value0 $index true true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};

proc CMIP-1.AttributeId.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result globalForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result localForm $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.AttributeIdError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result errorStatus  [set simple  [ENUM.decode $value0 $index false true] ; if {$simple == "2"} {set simple accessDenied}; if {$simple == "5"} {set simple noSuchAttribute}; set simple ] ; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.BaseManagedObjectId.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.CMISFilter.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.FilterItem.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result item $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern93.decode {value0 index optional explicit} {
CMIP-1.CMISFilter.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern93.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result and $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern94.decode {value0 index optional explicit} {
CMIP-1.CMISFilter.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern94.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result or $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.CMISFilter.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result not $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}
};

proc CMIP-1.CMISSync.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple bestEffort}; if {$simple == "1"} {set simple atomic}; set simple 
};

proc CMIP-1.ComplexityLimitation.decode {value0 index optional explicit} {
set result {}; if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result scope  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result filter  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.CMISFilter.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result sync  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.CMISSync.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.CreateArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result --nofield1  [
proc intern95.decode {value0 index optional explicit} {
set result {}; set tmp  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result managedObjectInstance $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result superiorObjectInstance $tmp; set result } else { error "Missing choice" }}; return $result
};
intern95.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result referenceObjectInstance  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern96.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern96.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.CreateResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern97.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern97.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.DeleteArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result synchronization  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; CMIP-1.CMISSync.decode $value0 $index false false] ; tmns_keylset result scope  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true] ; tmns_keylset result filter  [CMIP-1.CMISFilter.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.DeleteError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result deleteErrorInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; set simple  [ENUM.decode $value0 $index false true] ; if {$simple == "2"} {set simple accessDenied}; set simple ] ; ; return $result
};

proc CMIP-1.DeleteResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.EventReply.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result eventReplyInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result eventType value1]} {set value1} else { error "Can not find key eventType" }] } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.EventReportArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result eventTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result eventInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result eventType value1]} {set value1} else { error "Can not find key eventType" }] } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.EventReportResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result eventReply  [CMIP-1.EventReply.decode $value0 $index true true] ; ; return $result
};

proc CMIP-1.EventTypeId.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result globalForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result localForm $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.FilterItem.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result equality $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern98.decode {value0 index optional explicit} {

proc intern99.decode {value0 index optional explicit} {
set result {}; set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern100.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result string  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};
intern100.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result initialString $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern101.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result string  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};
intern101.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result anyString $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern102.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result string  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};
intern102.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result finalString $tmp; set result } else { error "Missing choice" }}}; return $result
};
intern99.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern98.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result substrings $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result greaterOrEqual $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result lessOrEqual $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AttributeId.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result present $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result subsetOf $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result supersetOf $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result nonNullSetIntersection $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}}}}}
};

proc CMIP-1.GetArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result synchronization  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; CMIP-1.CMISSync.decode $value0 $index false false] ; tmns_keylset result scope  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true] ; tmns_keylset result filter  [CMIP-1.CMISFilter.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeIdList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern103.decode {value0 index optional explicit} {
CMIP-1.AttributeId.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern103.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.GetInfoStatus.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.AttributeIdError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result attributeIdError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result attribute $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.GetListError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result getInfoList  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; 
proc intern104.decode {value0 index optional explicit} {
CMIP-1.GetInfoStatus.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern104.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};

proc CMIP-1.GetResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern105.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern105.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.InvalidArgumentValue.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ActionInfo.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result actionValue $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern106.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result eventInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result eventType value1]} {set value1} else { error "Can not find key eventType" }] } else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern106.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result eventValue $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.LinkedReplyArgument.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.GetResult.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result getResult $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.GetListError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result getListError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.SetResult.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result setResult $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.SetListError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result setListError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ActionResult.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result actionResult $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ProcessingFailure.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result processingFailure $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.DeleteResult.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result deleteResult $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ActionError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result actionError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.DeleteError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result deleteError $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}}}}}}
};

proc CMIP-1.ModifyOperator.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple replace}; if {$simple == "1"} {set simple addValues}; if {$simple == "2"} {set simple removeValues}; if {$simple == "3"} {set simple setToDefault}; set simple 
};

proc CMIP-1.NoSuchAction.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result actionType  [CMIP-1.ActionTypeId.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.NoSuchArgument.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern107.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result actionType  [CMIP-1.ActionTypeId.decode $value0 $index false true] ; ; return $result
};
intern107.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result actionId $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern108.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; ; return $result
};
intern108.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result eventId $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.NoSuchEventType.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.ObjectClass.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result globalForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result localForm $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.ObjectInstance.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {InformationFramework.DistinguishedName.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result distinguishedName $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {OCTET.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result nonSpecificForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } true true]  != "__tmns_opt"} {InformationFramework.RDNSequence.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result localDistinguishedName $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc CMIP-1.ProcessingFailure.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result specificErrorInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.SpecificErrorInfo.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.Scope.decode {value0 index optional explicit} {
set tmp  [set simple  [INTEGER.decode $value0 $index true true] ; if {$simple == "0"} {set simple baseObject}; if {$simple == "1"} {set simple firstLevelOnly}; if {$simple == "2"} {set simple wholeSubtree}; set simple ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result scope-int $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result individualLevels $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result baseToNthLevel $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc CMIP-1.SetArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result synchronization  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; CMIP-1.CMISSync.decode $value0 $index false false] ; tmns_keylset result scope  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true] ; tmns_keylset result filter  [CMIP-1.CMISFilter.decode $value0 $index false true] ; tmns_keylset result modificationList  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } false true; 
proc intern109.decode {value0 index optional explicit} {

proc intern110.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result modifyOperator  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } false true; CMIP-1.ModifyOperator.decode $value0 $index false false] ; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeValue  [ANY_DEF_BY.decode $value0 $index true true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};
intern110.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern109.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};

proc CMIP-1.SetInfoStatus.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.AttributeError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result attributeError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result attribute $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.SetListError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result setInfoList  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; 
proc intern111.decode {value0 index optional explicit} {
CMIP-1.SetInfoStatus.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern111.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};

proc CMIP-1.SetResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result attributeList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern112.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern112.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.SpecificErrorInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result errorId  [OID.decode $value0 $index false true] ; tmns_keylset result errorInfo  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result errorId value1]} {set value1} else { error "Can not find key errorId" }] ] ; ; return $result
};

proc CMIP-1.MultipleReply.decode {value0 index optional explicit} {

proc intern113.decode {value0 index optional explicit} {
CMIP-1.LinkedReplyArgument.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern113.decode $value0 $index false true]; }
; set tmp 
};

proc CMIP-1.ServiceError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result problem  [set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple noSuchObjectClass}; if {$simple == "1"} {set simple noSuchObjectInstance}; if {$simple == "2"} {set simple accessDenied}; if {$simple == "3"} {set simple synchronizationNotSupported}; if {$simple == "4"} {set simple invalidFilter}; if {$simple == "5"} {set simple noSuchAttribute}; if {$simple == "6"} {set simple invalidAttributeValue}; if {$simple == "7"} {set simple getListError}; if {$simple == "8"} {set simple setListError}; if {$simple == "9"} {set simple noSuchAction}; if {$simple == "10"} {set simple processingFailure}; if {$simple == "11"} {set simple duplicateManagedObjectInstance}; if {$simple == "12"} {set simple noSuchReferenceObject}; if {$simple == "13"} {set simple noSuchEventType}; if {$simple == "14"} {set simple noSuchArgument}; if {$simple == "15"} {set simple invalidArgumentValue}; if {$simple == "16"} {set simple invalidScope}; if {$simple == "17"} {set simple invalidObjectInstance}; if {$simple == "18"} {set simple missingAttributeValue}; if {$simple == "19"} {set simple classInstanceConflict}; if {$simple == "20"} {set simple complexityLimitation}; if {$simple == "21"} {set simple mistypedOperation}; if {$simple == "22"} {set simple noSuchInvokeId}; if {$simple == "23"} {set simple operationCancelled}; if {$simple == "24"} {set simple invalidOperation}; if {$simple == "25"} {set simple invalidOperator}; if {$simple == "100"} {set simple badAdress}; if {$simple == "101"} {set simple badArgument}; if {$simple == "102"} {set simple badClass}; if {$simple == "103"} {set simple badContext}; if {$simple == "104"} {set simple badError}; if {$simple == "105"} {set simple badLinkedReply}; if {$simple == "106"} {set simple badProceduralUse}; if {$simple == "107"} {set simple badResult}; if {$simple == "108"} {set simple badSession}; if {$simple == "109"} {set simple badSyntax}; if {$simple == "110"} {set simple badTitle}; if {$simple == "111"} {set simple badValue}; if {$simple == "112"} {set simple badWorkspace}; if {$simple == "113"} {set simple brokenSession}; if {$simple == "114"} {set simple communicationProblem}; if {$simple == "115"} {set simple exclusiveAttribute}; if {$simple == "116"} {set simple invalidConnectionIdentifier}; if {$simple == "117"} {set simple invalidAttributeIdentifier}; if {$simple == "118"} {set simple miscellaneous}; if {$simple == "119"} {set simple missingAttribute}; if {$simple == "120"} {set simple notAMultiValuedAttribute}; if {$simple == "121"} {set simple notSupported}; if {$simple == "122"} {set simple noSuchOperation}; if {$simple == "123"} {set simple replyLimitExceeded}; if {$simple == "124"} {set simple sessionTerminated}; if {$simple == "125"} {set simple systemError}; if {$simple == "126"} {set simple timeLimitExceeded}; if {$simple == "127"} {set simple tooManyOperations}; if {$simple == "128"} {set simple tooManySessions}; if {$simple == "200"} {set simple duplicateInvocation}; if {$simple == "201"} {set simple mistypedArgument}; if {$simple == "202"} {set simple resourceLimitation}; if {$simple == "203"} {set simple unrecognizedOperation}; if {$simple == "2000"} {set simple libraryError}; set simple ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result parameter  [ANY.decode $value0 $index true true] ; ; return $result
};

proc CMIP-1.CancelGetArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result getInvokeId  [INTEGER.decode $value0 $index false true] ; ; return $result
};

# ------------------------------
# Module
# UsefulDefinitions
# Encoding procedures
# ------------------------------


# ------------------------------
# Module
# UsefulDefinitions
# Decoding procedures
# ------------------------------


# ------------------------------
# Module
# InformationFramework
# Encoding procedures
# ------------------------------


proc InformationFramework.Attribute.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 type value1]} {InformationFramework.AttributeType.encode $value1} else { error "Can not find key type" }]  [if {[tmns_keylget value0 values value1]} {
proc intern114 value0 {
InformationFramework.AttributeValue.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern114 " [list $i] \]"
}
eval $toEval
} else { error "Can not find key values" }] 
};

proc InformationFramework.AttributeType.encode value0 {
OID.encode $value0
};

proc InformationFramework.AttributeValue.encode value0 {
ANY.encode $value0
};

proc InformationFramework.AttributeValueAssertion.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 namingAttributeId value1]} {OID.encode $value1} else { error "Can not find key namingAttributeId" }]  [if {[tmns_keylget value0 namingAttributeValue value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 namingAttributeId value1]} {set value1} else { error "Can not find key namingAttributeId" }] } else { error "Can not find key namingAttributeValue" }] 
};

proc InformationFramework.Name.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {InformationFramework.RDNSequence.encode $value1} else { error "Missing choice" }
};

proc InformationFramework.RDNSequence.encode value0 {

proc intern115 value0 {
InformationFramework.RelativeDistinguishedName.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value0 {
  append toEval " \[" intern115 " [list $i] \]"
}
eval $toEval

};

proc InformationFramework.DistinguishedName.encode value0 {
InformationFramework.RDNSequence.encode $value0
};

proc InformationFramework.RelativeDistinguishedName.encode value0 {

proc intern116 value0 {
InformationFramework.AttributeValueAssertion.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern116 " [list $i] \]"
}
eval $toEval

};

# ------------------------------
# Module
# InformationFramework
# Decoding procedures
# ------------------------------


proc InformationFramework.Attribute.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result type  [InformationFramework.AttributeType.decode $value0 $index false true] ; tmns_keylset result values  [
proc intern117.decode {value0 index optional explicit} {
InformationFramework.AttributeValue.decode $value0 $index false true
};
if { [SET.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern117.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};

proc InformationFramework.AttributeType.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc InformationFramework.AttributeValue.decode {value0 index optional explicit} {
ANY.decode $value0 $index $optional $explicit
};

proc InformationFramework.AttributeValueAssertion.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result namingAttributeId  [OID.decode $value0 $index false true] ; tmns_keylset result namingAttributeValue  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result namingAttributeId value1]} {set value1} else { error "Can not find key namingAttributeId" }] ] ; ; return $result
};

proc InformationFramework.Name.decode {value0 index optional explicit} {
set tmp  [InformationFramework.RDNSequence.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield1 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}
};

proc InformationFramework.RDNSequence.decode {value0 index optional explicit} {

proc intern118.decode {value0 index optional explicit} {
InformationFramework.RelativeDistinguishedName.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern118.decode $value0 $index false true]; }
; set tmp 
};

proc InformationFramework.DistinguishedName.decode {value0 index optional explicit} {
InformationFramework.RDNSequence.decode $value0 $index $optional $explicit
};

proc InformationFramework.RelativeDistinguishedName.decode {value0 index optional explicit} {

proc intern119.decode {value0 index optional explicit} {
InformationFramework.AttributeValueAssertion.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern119.decode $value0 $index false true]; }
; set tmp 
};

# ------------------------------
# Module
# ACSE-1
# Encoding procedures
# ------------------------------


proc ACSE-1.ACSE-apdu.encode value0 {
if {[tmns_keylget value0 aarq value1]} {ACSE-1.AARQ-apdu.encode $value1} else {if {[tmns_keylget value0 aare value1]} {ACSE-1.AARE-apdu.encode $value1} else {if {[tmns_keylget value0 rlrq value1]} {ACSE-1.RLRQ-apdu.encode $value1} else {if {[tmns_keylget value0 rlre value1]} {ACSE-1.RLRE-apdu.encode $value1} else {if {[tmns_keylget value0 abrt value1]} {ACSE-1.ABRT-apdu.encode $value1} else { error "Missing choice" }}}}}
};

proc ACSE-1.AARQ-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 0} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 protocol-version value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [BIT.encode $value1] } else { error "Can not find key protocol-version" }]  [if {[tmns_keylget value0 application-context-name value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [ACSE-1.Application-context-name.encode $value1] } else { error "Can not find key application-context-name" }]  [if {[tmns_keylget value0 called-AP-title value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ACSE-1.AP-title.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 called-AE-qualifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT false} } [ACSE-1.AE-qualifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 called-AP-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [ACSE-1.AP-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 called-AE-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [ACSE-1.AE-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-AP-title value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [ACSE-1.AP-title.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-AE-qualifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [ACSE-1.AE-qualifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-AP-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [ACSE-1.AP-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-AE-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT false} } [ACSE-1.AE-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 sender-acse-requirements value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } [ACSE-1.ACSE-requirements.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 mechanism-name value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT true} } [ACSE-1.Mechanism-name.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-authentication-value value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT false} } [ACSE-1.Authentication-value.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 implementation-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 29} {IMPLICIT true} } [ACSE-1.Implementation-data.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.AARE-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 1} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 protocol-version value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [BIT.encode $value1] } else { error "Can not find key protocol-version" }]  [if {[tmns_keylget value0 application-context-name value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [ACSE-1.Application-context-name.encode $value1] } else { error "Can not find key application-context-name" }]  [if {[tmns_keylget value0 result value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ACSE-1.Associate-result.encode $value1] } else { error "Can not find key result" }]  [if {[tmns_keylget value0 result-source-diagnostic value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT false} } [ACSE-1.Associate-source-diagnostic.encode $value1] } else { error "Can not find key result-source-diagnostic" }]  [if {[tmns_keylget value0 responding-AP-title value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [ACSE-1.AP-title.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responding-AE-qualifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [ACSE-1.AE-qualifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responding-AP-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [ACSE-1.AP-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responding-AE-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [ACSE-1.AE-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responder-acse-requirements value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } [ACSE-1.ACSE-requirements.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 mechanism-name value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } [ACSE-1.Mechanism-name.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responding-authentication-value value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT false} } [ACSE-1.Authentication-value.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 implementation-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 29} {IMPLICIT true} } [ACSE-1.Implementation-data.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.RLRQ-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 2} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 reason value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [ACSE-1.Release-request-reason.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.RLRE-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 3} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 reason value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [ACSE-1.Release-response-reason.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.ABRT-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 4} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 abort-source value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [ACSE-1.ABRT-source.encode $value1] } else { error "Can not find key abort-source" }]  [if {[tmns_keylget value0 abort-diagnostic value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [ACSE-1.ABRT-diagnostic.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.ABRT-diagnostic.encode value0 {
if {$value0 == "no-reason-given"} {set value0 1}; if {$value0 == "protocol-error"} {set value0 2}; if {$value0 == "authentication-mechanism-name-not-recognized"} {set value0 3}; if {$value0 == "authentication-mechanism-name-required"} {set value0 4}; if {$value0 == "authentication-failure"} {set value0 5}; if {$value0 == "authentication-required"} {set value0 6}; ENUM.encode $value0
};

proc ACSE-1.ABRT-source.encode value0 {
if {$value0 == "acse-service-user"} {set value0 0}; if {$value0 == "acse-service-provider"} {set value0 1}; INTEGER.encode $value0
};

proc ACSE-1.ACSE-requirements.encode value0 {
BIT.encode $value0
};

proc ACSE-1.Application-context-name.encode value0 {
OID.encode $value0
};

proc ACSE-1.AP-title.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {ACSE-1.AP-title-form1.encode $value1} else {if {[tmns_keylget value0 --nofield2 value1]} {ACSE-1.AP-title-form2.encode $value1} else { error "Missing choice" }}
};

proc ACSE-1.AE-qualifier.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {ACSE-1.AE-qualifier-form1.encode $value1} else {if {[tmns_keylget value0 --nofield2 value1]} {ACSE-1.AE-qualifier-form2.encode $value1} else { error "Missing choice" }}
};

proc ACSE-1.AP-title-form1.encode value0 {
InformationFramework.Name.encode $value0
};

proc ACSE-1.AE-qualifier-form1.encode value0 {
InformationFramework.RelativeDistinguishedName.encode $value0
};

proc ACSE-1.AP-title-form2.encode value0 {
OID.encode $value0
};

proc ACSE-1.AE-qualifier-form2.encode value0 {
INTEGER.encode $value0
};

proc ACSE-1.AE-title.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {ACSE-1.AE-title-form1.encode $value1} else {if {[tmns_keylget value0 --nofield2 value1]} {ACSE-1.AE-title-form2.encode $value1} else { error "Missing choice" }}
};

proc ACSE-1.AE-title-form1.encode value0 {
InformationFramework.Name.encode $value0
};

proc ACSE-1.AE-title-form2.encode value0 {
OID.encode $value0
};

proc ACSE-1.AE-invocation-identifier.encode value0 {
INTEGER.encode $value0
};

proc ACSE-1.AP-invocation-identifier.encode value0 {
INTEGER.encode $value0
};

proc ACSE-1.Associate-result.encode value0 {
if {$value0 == "accepted"} {set value0 0}; if {$value0 == "rejected-permanent"} {set value0 1}; if {$value0 == "rejected-transient"} {set value0 2}; INTEGER.encode $value0
};

proc ACSE-1.Associate-source-diagnostic.encode value0 {
if {[tmns_keylget value0 acse-service-user value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [if {$value1 == "null"} {set value1 0}; if {$value1 == "no-reason-given"} {set value1 1}; if {$value1 == "application-context-name-not-supported"} {set value1 2}; if {$value1 == "calling-AP-title-not-recognized"} {set value1 3}; if {$value1 == "calling-AP-invocation-identifier-not-recognized"} {set value1 4}; if {$value1 == "calling-AE-qualifier-not-recognized"} {set value1 5}; if {$value1 == "calling-AE-invocation-identifier-not-recognized"} {set value1 6}; if {$value1 == "called-AP-title-not-recognized"} {set value1 7}; if {$value1 == "called-AP-invocation-identifier-not-recognized"} {set value1 8}; if {$value1 == "called-AE-qualifier-not-recognized"} {set value1 9}; if {$value1 == "called-AE-invocation-identifier-not-recognized"} {set value1 10}; if {$value1 == "authentication-mechanism-name-not-recognized"} {set value1 11}; if {$value1 == "authentication-mechanism-name-required"} {set value1 12}; if {$value1 == "authentication-failure"} {set value1 13}; if {$value1 == "authentication-required"} {set value1 14}; INTEGER.encode $value1] } else {if {[tmns_keylget value0 acse-service-provider value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [if {$value1 == "null"} {set value1 0}; if {$value1 == "no-reason-given"} {set value1 1}; if {$value1 == "no-common-acse-version"} {set value1 2}; INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc ACSE-1.Association-information.encode value0 {

proc intern120 value0 {
EXTERNAL.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value0 {
  append toEval " \[" intern120 " [list $i] \]"
}
eval $toEval

};

proc ACSE-1.Authentication-value.encode value0 {
if {[tmns_keylget value0 charstring value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [GraphicString.encode $value1] } else {if {[tmns_keylget value0 bitstring value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [BIT.encode $value1] } else {if {[tmns_keylget value0 external value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [EXTERNAL.encode $value1] } else {if {[tmns_keylget value0 other value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [
proc intern121 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 other-mechanism-name value1]} {ACSE-1.Mechanism-name.encode $value1} else { error "Can not find key other-mechanism-name" }]  [if {[tmns_keylget value0 other-mechanism-value value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 other-mechanism-name value1]} {set value1} else { error "Can not find key other-mechanism-name" }] } else { error "Can not find key other-mechanism-value" }]  [if {[tmns_keylget value0 other value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [
proc intern122 value0 {
ANY.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value1 {
  append toEval " \[" intern122 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key other" }] 
};
intern121 $value1] } else { error "Missing choice" }}}}
};

proc ACSE-1.Implementation-data.encode value0 {
GraphicString.encode $value0
};

proc ACSE-1.Mechanism-name.encode value0 {
OID.encode $value0
};

proc ACSE-1.Release-request-reason.encode value0 {
if {$value0 == "normal"} {set value0 0}; if {$value0 == "urgent"} {set value0 1}; if {$value0 == "user-defined"} {set value0 30}; INTEGER.encode $value0
};

proc ACSE-1.Release-response-reason.encode value0 {
if {$value0 == "normal"} {set value0 0}; if {$value0 == "not-finished"} {set value0 1}; if {$value0 == "user-defined"} {set value0 30}; INTEGER.encode $value0
};

# ------------------------------
# Module
# ACSE-1
# Decoding procedures
# ------------------------------


proc ACSE-1.ACSE-apdu.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AARQ-apdu.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result aarq $tmp; set result } else {set tmp  [ACSE-1.AARE-apdu.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result aare $tmp; set result } else {set tmp  [ACSE-1.RLRQ-apdu.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result rlrq $tmp; set result } else {set tmp  [ACSE-1.RLRE-apdu.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result rlre $tmp; set result } else {set tmp  [ACSE-1.ABRT-apdu.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result abrt $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}}
};

proc ACSE-1.AARQ-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 0} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern123.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result protocol-version  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } false true; BIT.decode $value0 $index false false] ; tmns_keylset result application-context-name  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ACSE-1.Application-context-name.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result called-AP-title  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-title.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result called-AE-qualifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-qualifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result called-AP-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result called-AE-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result calling-AP-title  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-title.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result calling-AE-qualifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-qualifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result calling-AP-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result calling-AE-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result sender-acse-requirements  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.ACSE-requirements.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result mechanism-name  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Mechanism-name.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result calling-authentication-value  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.Authentication-value.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result implementation-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 29} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Implementation-data.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern123.decode $value0 $index false false
};

proc ACSE-1.AARE-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 1} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern124.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result protocol-version  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } false true; BIT.decode $value0 $index false false] ; tmns_keylset result application-context-name  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ACSE-1.Application-context-name.decode $value0 $index false true] ; tmns_keylset result result  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ACSE-1.Associate-result.decode $value0 $index false true] ; tmns_keylset result result-source-diagnostic  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ACSE-1.Associate-source-diagnostic.decode $value0 $index false true] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result responding-AP-title  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-title.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result responding-AE-qualifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-qualifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result responding-AP-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result responding-AE-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result responder-acse-requirements  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.ACSE-requirements.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result mechanism-name  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Mechanism-name.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result responding-authentication-value  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.Authentication-value.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result implementation-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 29} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Implementation-data.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern124.decode $value0 $index false false
};

proc ACSE-1.RLRQ-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 2} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern125.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result reason  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Release-request-reason.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern125.decode $value0 $index false false
};

proc ACSE-1.RLRE-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 3} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern126.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];

if { $loop >= $total } { return $result; }
tmns_keylset result reason  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Release-response-reason.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern126.decode $value0 $index false false
};

proc ACSE-1.ABRT-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 4} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern127.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result abort-source  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } false true; ACSE-1.ABRT-source.decode $value0 $index false false] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result abort-diagnostic  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.ABRT-diagnostic.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; 
if { $loop >= $total } { return $result; }
tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern127.decode $value0 $index false false
};

proc ACSE-1.ABRT-diagnostic.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "1"} {set simple no-reason-given}; if {$simple == "2"} {set simple protocol-error}; if {$simple == "3"} {set simple authentication-mechanism-name-not-recognized}; if {$simple == "4"} {set simple authentication-mechanism-name-required}; if {$simple == "5"} {set simple authentication-failure}; if {$simple == "6"} {set simple authentication-required}; set simple 
};

proc ACSE-1.ABRT-source.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple acse-service-user}; if {$simple == "1"} {set simple acse-service-provider}; set simple 
};

proc ACSE-1.ACSE-requirements.decode {value0 index optional explicit} {
BIT.decode $value0 $index $optional $explicit
};

proc ACSE-1.Application-context-name.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc ACSE-1.AP-title.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AP-title-form1.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield1 $tmp; set result } else {set tmp  [ACSE-1.AP-title-form2.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield2 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc ACSE-1.AE-qualifier.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AE-qualifier-form1.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield1 $tmp; set result } else {set tmp  [ACSE-1.AE-qualifier-form2.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield2 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc ACSE-1.AP-title-form1.decode {value0 index optional explicit} {
InformationFramework.Name.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-qualifier-form1.decode {value0 index optional explicit} {
InformationFramework.RelativeDistinguishedName.decode $value0 $index $optional $explicit
};

proc ACSE-1.AP-title-form2.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-qualifier-form2.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-title.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AE-title-form1.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield1 $tmp; set result } else {set tmp  [ACSE-1.AE-title-form2.decode $value0 $index true true] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result --nofield2 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc ACSE-1.AE-title-form1.decode {value0 index optional explicit} {
InformationFramework.Name.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-title-form2.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-invocation-identifier.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc ACSE-1.AP-invocation-identifier.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc ACSE-1.Associate-result.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple accepted}; if {$simple == "1"} {set simple rejected-permanent}; if {$simple == "2"} {set simple rejected-transient}; set simple 
};

proc ACSE-1.Associate-source-diagnostic.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple null}; if {$simple == "1"} {set simple no-reason-given}; if {$simple == "2"} {set simple application-context-name-not-supported}; if {$simple == "3"} {set simple calling-AP-title-not-recognized}; if {$simple == "4"} {set simple calling-AP-invocation-identifier-not-recognized}; if {$simple == "5"} {set simple calling-AE-qualifier-not-recognized}; if {$simple == "6"} {set simple calling-AE-invocation-identifier-not-recognized}; if {$simple == "7"} {set simple called-AP-title-not-recognized}; if {$simple == "8"} {set simple called-AP-invocation-identifier-not-recognized}; if {$simple == "9"} {set simple called-AE-qualifier-not-recognized}; if {$simple == "10"} {set simple called-AE-invocation-identifier-not-recognized}; if {$simple == "11"} {set simple authentication-mechanism-name-not-recognized}; if {$simple == "12"} {set simple authentication-mechanism-name-required}; if {$simple == "13"} {set simple authentication-failure}; if {$simple == "14"} {set simple authentication-required}; set simple } else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result acse-service-user $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple null}; if {$simple == "1"} {set simple no-reason-given}; if {$simple == "2"} {set simple no-common-acse-version}; set simple } else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result acse-service-provider $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc ACSE-1.Association-information.decode {value0 index optional explicit} {

proc intern128.decode {value0 index optional explicit} {
EXTERNAL.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern128.decode $value0 $index false true]; }
; set tmp 
};

proc ACSE-1.Authentication-value.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {GraphicString.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result charstring $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {BIT.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result bitstring $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {EXTERNAL.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result external $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern129.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; 
upvar #0 $index loop;
set total [expr $length + $loop];
tmns_keylset result other-mechanism-name  [ACSE-1.Mechanism-name.decode $value0 $index false true] ; tmns_keylset result other-mechanism-value  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result other-mechanism-name value1]} {set value1} else { error "Can not find key other-mechanism-name" }] ] ; tmns_keylset result other  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } false true; 
proc intern130.decode {value0 index optional explicit} {
ANY.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern130.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};
intern129.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {[string compare $tmp "__tmns_opt"]} {tmns_keylset result other $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}
};

proc ACSE-1.Implementation-data.decode {value0 index optional explicit} {
GraphicString.decode $value0 $index $optional $explicit
};

proc ACSE-1.Mechanism-name.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc ACSE-1.Release-request-reason.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple normal}; if {$simple == "1"} {set simple urgent}; if {$simple == "30"} {set simple user-defined}; set simple 
};

proc ACSE-1.Release-response-reason.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple normal}; if {$simple == "1"} {set simple not-finished}; if {$simple == "30"} {set simple user-defined}; set simple 
};
