#!/opt/SUNWconn/bin/tmnscript

# Testing script for local naming:
# MOI (non-specific syntax)
# MOC EventTypeId ActionTypeId AttributeId ==> modify mapper.tcl
# (or create a new file) to be able to map strings on integers


###########################
# Load Metadata & Scripts #
###########################

puts stdout "\nLoad Metadata & Scripts"
puts stdout "---------------------------------------------------------------------------\n"

source ./mapper.tcl
# New file for local naming
source ./mapper_local.tcl
source ./parser.tcl
source /opt/SUNWconn/TMNscript/script/tmns_type.tcl


#################################
# Define Procedures & Variables #
#################################

# Define a procedure to wait and get a message

proc receiveAll { session } {
   set match "more"
   while { $match == "more" } {
      mp::wait 10 $session
      set tmp [mp::receive $session]
      puts stdout "Message received: $tmp \n"
      set match [lindex $tmp 6]
   }
}

proc moi_std { session } {
    global agent manager mp_mapperModeOn mp_asn1ModeOn

    set mp_mapperModeOn true
    set mp_asn1ModeOn true
    set req {mp::createReq -ses $session -at $agent -moc tester -moi {{familyName "name"} {address "add"}} -info {}}
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn false
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{1.2.3.4.5.6.13.4 0x19046e616d65} {1.2.3.4.5.6.13.5 0x1903616464}} -info {}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn true
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{1.2.3.4.5.6.13.4 "name"} {1.2.3.4.5.6.13.5 "add"}} -info {}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn true
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc tester -moi {{1.2.3.4.5.6.13.4 "name"} {1.2.3.4.5.6.13.5 "add"}} -info {}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session
}

proc moi_non_specific { session } {
    global agent manager mp_mapperModeOn mp_asn1ModeOn

    set mp_mapperModeOn true
    set mp_asn1ModeOn true
    set req {mp::createReq -ses $session -at $agent -moc tester -moi {{syntax non-specific} 0x1903313233} -info {}}
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn false
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn true
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session
}

proc moc_local { session } {
    global agent manager mp_mapperModeOn mp_asn1ModeOn

    set mp_mapperModeOn true
    set mp_asn1ModeOn true
    set req {mp::createReq -ses $session -at $agent -moc testerLocal -moi {{syntax non-specific} 0x1903313233} -info {}}
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn false
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc 15 -moi {{syntax non-specific} 0x1903313233} -info {}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn true
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc 15 -moi {{syntax non-specific} 0x1903313233} -info {}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session
}

proc att_local { session } {
    global agent manager mp_mapperModeOn mp_asn1ModeOn

    set mp_mapperModeOn true
    set mp_mapperModeOn true
    set mp_asn1ModeOn true
    set req {mp::createReq -ses $session -at $agent -moc tester -moi {{syntax non-specific} 0x1903313233} -info {{familyNameLocal "name"} {addressLocal "add"}}}
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn false
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {{15 0x19046e616d65} {16 0x1903616464}}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn false
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::getReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {15 16 }}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn true
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::createReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {{15 "name"} {16 "add"}}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session
}

proc action_local { session } {
    global agent manager mp_mapperModeOn mp_asn1ModeOn

    set mp_mapperModeOn true
    set mp_asn1ModeOn true
    set req {mp::actionReq -ses $session -at $agent -moc tester -moi {{syntax non-specific} 0x1903313233} -info {local.testerAction true}}
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn false
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::actionReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {1234 0x0101ff}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn true
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::actionReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {1234 true}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session
}

proc event_local { session } {
    global agent manager mp_mapperModeOn mp_asn1ModeOn

    set mp_mapperModeOn true
    set mp_asn1ModeOn true
    set req {mp::eventReq -ses $session -at $agent -moc tester -moi {{syntax non-specific} 0x1903313233} -info {local:testerEvent "notif"}}
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn false
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::eventReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {12345 0x19056e6f746966}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session

    set mp_mapperModeOn false
    set mp_asn1ModeOn true
    puts "mp_mapperModeOn=$mp_mapperModeOn\n"
    puts "mp_asn1ModeOn=$mp_asn1ModeOn\n"
    set req {mp::eventReq -ses $session -at $agent -moc 1.1.42.1.1 -moi {{syntax non-specific} 0x1903313233} -info {12345 "notif"}}
    puts stdout "REQ: $req \n"
    eval $req
    receiveAll $session
}

##################################
# Initialization & Configuration #
##################################				 

puts stdout "\nInitialization & Configuration"
puts stdout "---------------------------------------------------------------------------\n"

# Set diagnostic modes: trace mode and error mode disabled

set mp_misTraceOn true
set mp_errorModeOn true

puts stdout "Trace and error modes disabled \n"


set mp_internalStatusOn true

puts stdout "Internal Status enabled \n"


# Disable support for universal types

mp::negotiate { XMP_DECODING off }

puts stdout "Support for universal types disabled \n"

# Set addresses for the manager and the agent to be the
# same, so that messages are looped back
global agent manager
set manager {{psel toto} {ssel Prs} {tsel CMIP} {nsap ""}}
set agent {{psel toto} {ssel Prs} {tsel CMIP} {nsap ""}}
puts stdout "Address for manager application: $manager \n"
puts stdout "Address for agent application: $agent \n"

# Bind the application

set session [mp::bind $manager]


############################
# Exercise CREATE Commands #
############################


puts "\#\#\#\#\#\#\#\#\#\#\#"
puts "\# TESTING GLOBAL MOI SYNTAX"
puts "\#\#\#\#\#\#\#\#\#\#\#\n"
moi_std $session

puts "\#\#\#\#\#\#\#\#\#\#\#"
puts "\# TESTING NON-SPECIFIC MOI SYNTAX"
puts "\#\#\#\#\#\#\#\#\#\#\#\n"
moi_non_specific $session

puts "\#\#\#\#\#\#\#\#\#\#\#"
puts "\# TESTING LOCAL MOC"
puts "\#\#\#\#\#\#\#\#\#\#\#\n"
moc_local $session

puts "\#\#\#\#\#\#\#\#\#\#\#"
puts "\# TESTING LOCAL ATTRIBUTE"
puts "\#\#\#\#\#\#\#\#\#\#\#\n"
att_local $session

puts "\#\#\#\#\#\#\#\#\#\#\#"
puts "\# TESTING LOCAL ACTION"
puts "\#\#\#\#\#\#\#\#\#\#\#\n"
action_local $session

puts "\#\#\#\#\#\#\#\#\#\#\#"
puts "\# TESTING LOCAL EVENT"
puts "\#\#\#\#\#\#\#\#\#\#\#\n"
event_local $session


##############
# That's all #
##############

mp::unbind $session



