#
#ident  "@(#)test_reject_assoc.tcl	1.11 99/07/30 Copyright SMI"
#
# Copyright (c) 07/30/99 by Sun Microsystems, Inc. 
# All Rights Reserved
#
# This script file contains a simple example to demonstrate how to
# reject an association based on the TMNscript ASSOC commands.
#
# The script acts as both manager and agent. The addresses for the manager
# and the agent are set to be the same so that the messages are looped back.
#
# Mapping mode and ASN.1 mode are both enabled. Objects are expressed
# using human-readable names, and data values are expressed using the
# string representation provided by Solstice TMNscript.
#

#####################
# Define Procedures #
#####################				 

# Define a procedure to get the base directory of a package
#
proc pkgbasedir { pkgname } {
   if {[catch {exec pkgparam $pkgname BASEDIR} result]} {
        puts stderr "pkgparam $pkgname failed: $result"
        return "/opt"
   }
   return $result
}


###########################
# Load Metadata & Scripts #
###########################

puts stdout "\nLoad Metadata & Scripts"
puts stdout "---------------------------------------------------------------------------\n"

set basedir [pkgbasedir SUNWtmns2]
set compiler_dir $basedir/SUNWconn/TMNscript/example/compiler
set shared_dir $basedir/SUNWconn/TMNscript/example/tcl/shared
source $compiler_dir/mapper.tcl
source $compiler_dir/parser.tcl

set basedir [pkgbasedir SUNWtmns1]
source $basedir/SUNWconn/TMNscript/script/tmns_type.tcl


# Load the receive procedures

source $shared_dir/libreceive.tcl

# Load the ASSOC procedures

source $shared_dir/libassoc.tcl


##################################
# Initialization & Configuration #
##################################				 

puts stdout "\nInitialization & Configuration"
puts stdout "---------------------------------------------------------------------------\n"

# Set operating mode: mapper mode and ASN.1 mode enabled

set mp_mapperModeOn true
set mp_asn1ModeOn true

puts stdout "Mapping and ASN.1 modes enabled \n "

# Set diagnostic modes: trace mode disabled

set mp_misTraceOn false

puts stdout "Trace mode disabled \n"

# mp_acmString is by default enabled
 
puts stdout "Translation of association related information enabled \n"

# Disable support for universal types

mp::negotiate { XMP_DECODING off }

puts stdout "Support for universal types disabled \n"

# Set addresses for the manager and the agent to be the
# same, so that messages are looped back 

set manager {{psel rfc4} {ssel Prs} {tsel CMIP} {nsap ""}}
set agent {{psel rfc4} {ssel Prs} {tsel CMIP} {nsap ""}}

puts stdout "Address for manager application: $manager \n"
puts stdout "Address for agent application: $agent \n"

# Define a variable that contains the object class name

set moc system

puts stdout "Managed object class (moc): $moc \n"

# Define a variable that contains the object instance name

set moi "\{systemId \{[getHostName]\}\}"

puts stdout "Managed object instance (moi): $moi \n"

# Set the display of messages received (true/false)

set format_display false

###########################
# Exercise ASSOC Commands #
###########################

set nbIter 1
for { set i 0} {$i < $nbIter} {set i [expr $i +1]} {

puts stdout "\nExercise ASSOC Commands - Iteration $i"
puts stdout "---------------------------------------------------------------------------\n"


###################################################################
# PHASE 1 : Bind the application with manual association handling #
# -------							  #
###################################################################

# Bind the manager application with manual association handling enabled
#
set bound_session [manualAssoc $manager]

# Print the status of the bound session
#
sessionInfo $bound_session


#################################
# PHASE 2 : Reject associations #
# -------			#
#################################

# Send ASSOC request to the agent
# NOTE : A transient session is returned
#
set manager_transient_session [getSessionfromReq [sendAssocReq $bound_session]]

# Print the status of the transient session
#
sessionInfo $manager_transient_session

# Wait up to 10 seconds to receive the ASSOC indication
# NOTE : There should be a transient session in the confirmation
#
set ind [receiveOne $bound_session]
puts stdout "ASSOC INDICATION received by the agent:"
displayOne $ind

# Get the session from the indication
#
set agent_transient_session [getSessionfromInfo $ind]

# Print the status of the transient session
#
sessionInfo $agent_transient_session

# Get the invoke identifier contained in the indication
# in order to be able to send a response.
#
set id [getInvokeId $ind]

# Set the operation-specific information
#
set info " \{\{assoc-Result reject-permanent\} \{acse-Args \{\{application-Context $appcontext\}\}\}\}" 

# Send ASSOC response to the manager
# NOTE : Because of the association rejection nothing is returned
#
sendAssocRsp $bound_session $id $info

# Wait up to 10 seconds to receive the ASSOC confirmation
# NOTE : There should be no connected session in the confirmation
#
set cnf [receiveOne $bound_session]
puts stdout "ASSOC CONFIRMATION received by the manager:"
displayOne $cnf

######################################
# PHASE 3 : Unbind the bound session #
# ------- 			     #
######################################

# Unbind the bound session
#
sessionUnbind $bound_session

}

##############
# That's all #
##############


