/*
 * pragma ident "@(#)TmnUtil.java	1.1 97/10/23 Copyright SMI"
 *
 * Copyright (c) 10/23/97 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.commonClass.*;


class TmnUtil {

	//
	// Identify version of the class
	//
	private static String sccs_id = "@(#)TmnUtil.java	1.1 97/10/23 Copyright SMI";

	public static String valueString(Sequence s) {

		String string = new String();

		for (Enumeration e = s.elements(); e.hasMoreElements(); ) {
			string = string.concat(e.nextElement().toString());
			if (e.hasMoreElements()) {
				string = string.concat(" ");
			}
		}
		//TmnMessage.debug("string: " + string);

		return string;
	}

	public static Vector splitString(String string) {

		Vector vector = new Vector();
		Vector sortedVector = new Vector();

		if (string == null) {
			return sortedVector;
		}

		char charArray[] = string.toCharArray();
		String tmp = new String();

		for (int i = 0; i < charArray.length; i++) {

			//TmnMessage.debug("char: " + charArray[i]);

			if (charArray[i] == ' ') {
				if (tmp.length() != 0) {
					//TmnMessage.debug("tmp: " + tmp);
					vector.addElement(tmp);
					tmp = new String();
				}
			} else {
				tmp = tmp.concat(String.valueOf(charArray[i]));
			}
		}

		for (int i = 0; i < vector.size(); i++) {
			String si = (String) vector.elementAt(i);
			int j;
			for (j = 0; j < sortedVector.size(); j++) {
				String sj = (String) sortedVector.elementAt(j);
				if (si.compareTo(sj) < 0) {
					break;
				}
			}
			sortedVector.insertElementAt(si, j);
		}

		return sortedVector;
	}

	public static String oiString(ObjectInstance oi) {

		String string = new String();

		for (Enumeration e = oi.elements(); e.hasMoreElements(); ) {
			string = string.concat(e.nextElement().toString());
			if (e.hasMoreElements()) {
				string = string.concat(" ");
			}
		}
		//TmnMessage.debug("string: " + string);

		return string;
	}

	public static String oiShortString(ObjectInstance oi) {

		String string = new String();

		for (Enumeration e = oi.elements(); e.hasMoreElements(); ) {
			Sequence s = (Sequence) e.nextElement();

			if (!e.hasMoreElements()) {
				for (Enumeration e2 = s.elements(); e2.hasMoreElements(); ) {
					string = string.concat(e2.nextElement().toString());
					if (e2.hasMoreElements()) {
						string = string.concat(" ");
					}
				}
			}
		}
		//TmnMessage.debug("string: " + string);

		return string;
	}

        //
        // Returns the version of this class.
        //
        public String getClassVersion() {
                return (sccs_id);
        }
}

