/*
 * pragma ident "@(#)TmnServer.java	1.5 98/07/01 Copyright SMI"
 *
 * Copyright (c) 07/01/98 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.client.*;
import com.sun.tmnscript.cmis.*;
import com.sun.tmnscript.commonClass.*;
import com.sun.tmnscript.primitive.*;


class TmnServer extends PropertySection implements ActionListener {

	private TmnManager manager = null;

	Client client = null;
	private boolean state = false;
	private TmnGlobalCallback globalCallback = null;


	//
	// Default Values for the TMNscript Server
	//
	public static final String DEFAULT_SERVER_HOST = "localhost";
	public static final int DEFAULT_SERVER_PORT = 6666;
	public static final Address DEFAULT_SERVER_ADDRESS
		= new Address("dflt", "Prs", "CMIP", "");


	//
	// Textfields for storing the different parameters
	// related to the TMNscript Server
	//
	private TextField hostTF;
	private TextField portTF;
	private TextField pselTF;
	private TextField sselTF;
	private TextField tselTF;
	private TextField nsapTF;
	private Button connectBT;
	private TextField msgTF;


	//
	// Labels for connectBT
	//

	private static final String LBL_CONNECT
		= "    CONNECT     ";
	private static final String LBL_BIND
		= "      BIND      ";
	private static final String LBL_DISCONNECT
		= "   DISCONNECT   ";


	//
	// Messages for msgTF
	//

	private static final String MSG_NOT_CONNECTED_NOT_BOUND
		= "TMN Manager is not connected and not bound";
	private static final String MSG_CONNECTED_NOT_BOUND
		= "TMN Manager is connected and not bound";
	private static final String MSG_CONNECTED_BOUND
		= "TMN Manager is connected and bound";


	//
	// Use a GrigBag layout: it is so much fun ...
	//
	private GridBagLayout layout;
	private GridBagConstraints constraints;


	//
        // Identify version of the class
        //
        private static String sccs_id = "@(#)TmnServer.java	1.5 98/07/01 Copyright SMI";


	public TmnServer(TmnManager manager) {

		Label label;

		this.manager = manager;
		globalCallback = new TmnGlobalCallback(manager);
		

		// Define the font to be used
		//
		setFont(new Font("Helvetica", Font.PLAIN, 14));

		// Use GridBagLayout so we can put component 
		// wherever we need
		//
		layout = new GridBagLayout();
		setLayout(layout);
		constraints = new GridBagConstraints();
		constraints.fill = GridBagConstraints.NONE;
		constraints.weightx = 0.0;
		constraints.anchor = GridBagConstraints.CENTER;


		// Host
		add(new Label("     "), 1, 1);
		label = new Label("Host:");
		add(label, 1, 1);
		hostTF = new TextField(DEFAULT_SERVER_HOST, 20);
		add(hostTF, GridBagConstraints.REMAINDER, 1);

		// Port
		add(new Label("     "), 1, 1);
		label = new Label("Port:");
		add(label, 1, 1);
		portTF = new TextField((new Integer(DEFAULT_SERVER_PORT)).toString(), 20);
		add(portTF, GridBagConstraints.REMAINDER, 1);

		// Bind Address
		add(new Label("     "), 1, 1);
		label = new Label("Bind Address:");
		add(label, 1, 1);
		pselTF = new TextField(DEFAULT_SERVER_ADDRESS.getPsel(), 5);
		add(pselTF, 1, 1);
		sselTF = new TextField(DEFAULT_SERVER_ADDRESS.getSsel(), 5);
		add(sselTF, 1, 1);
		tselTF = new TextField(DEFAULT_SERVER_ADDRESS.getTsel(), 5);
		add(tselTF, 1, 1);
		nsapTF = new TextField(DEFAULT_SERVER_ADDRESS.getNsap(), 5);
		add(nsapTF, GridBagConstraints.REMAINDER, 1);

		// Connect
		add(new Label("     "), GridBagConstraints.REMAINDER, 3);
		connectBT = new Button(LBL_CONNECT);
		constraints.anchor = GridBagConstraints.CENTER;
		add(connectBT, GridBagConstraints.REMAINDER, 1);
		connectBT.addActionListener(this);

		// Message
		add(new Label("     "), GridBagConstraints.REMAINDER, 5);
		msgTF = new TextField(MSG_NOT_CONNECTED_NOT_BOUND, 50);
		msgTF.setEditable(false);
		add(msgTF, GridBagConstraints.REMAINDER, 1);
	}

	private void add(Component c, int width, int height) {
		constraints.gridwidth = width;
		constraints.gridheight = height;
		layout.setConstraints(c, constraints);
		add(c);
	}

	public void connect() {

		if (client != null) {
			disconnect();
		}

		try {
			client = new Client(getHost(), getPort());

			msgTF.setText(MSG_CONNECTED_NOT_BOUND);
			connectBT.setLabel(LBL_BIND);

                } catch (Exception e) {
			TmnMessage.error(e.getMessage());
			return;
		}

		try {
			client.bind(getAddress());

			msgTF.setText(MSG_CONNECTED_BOUND);
			connectBT.setLabel(LBL_DISCONNECT);

		} catch (Exception e) {
			TmnMessage.error(e.getMessage());
			return;
		}

		try {
			client.registerGlobalCallback(globalCallback);
		} catch (Exception e) {
			TmnMessage.error(e.getMessage());
			return;
		}

		manager.agent.init();
		manager.mit.init();

		manager.invalidate();
		manager.validate();

		state = true;
	}

	public void disconnect() {

		try {
			client.unbind();
		} catch (Exception e) {
		}

		client.disconnect();

		client = null;

		msgTF.setText(MSG_NOT_CONNECTED_NOT_BOUND);
		connectBT.setLabel(LBL_CONNECT);

		//manager.mit.end();
		//manager.notification.end();

		manager.invalidate();
		manager.validate();

		state = false;
	}

	private boolean isConnectedAndBound() {
		return state;
	}

	private void handleConnection() {

		if (isConnectedAndBound()) {
			disconnect();
		} else {
			connect();
		}
	}

	public void actionPerformed(ActionEvent e) {
		handleConnection();
	}


	public Cnf[] sendSync(Req msg) {

		Cnf[] cnfs = null;

		if (client == null) {
			TmnMessage.warning("Please, connect to the TMNscript Server");
			return null;
		}

		try {
			cnfs = client.sendSync(msg, manager.agent.getAddress());
                } catch (Exception e) {
			TmnMessage.error("TmnServer.sendSync(): " + e.getMessage());
			return null;
		}

		TmnMessage.cnfsDebug(cnfs);

		return cnfs;
	}

	public void sendAsync(Req msg, CallBackReg callback) {

		if (client == null) {
			TmnMessage.warning("Please, connect to the TMNscript Server");
			return;
		}

		try {
			client.send(msg, manager.agent.getAddress(), callback);
                } catch (Exception e) {
			TmnMessage.error("TmnServer.sendAsync(): " + e.getMessage());
			return;
		}

		return;
	}

	public String sendMeta(String cmd) {

		String res = null;

		if (client == null) {
			TmnMessage.warning("Please, connect to the TMNscript Server");
			return null;
		}

		try {
			res = client.getMeta(cmd);
                } catch (Exception e) {
			TmnMessage.error("TmnServer.sendMeta(): " + e.getMessage());
			return null;
		}

		return res;
	}

	public String getHost() {
		return hostTF.getText();
	}

	public int getPort() {
		return (new Integer(portTF.getText())).intValue();
	}

	private String getPsel() {
		return pselTF.getText();
	}

	private String getSsel() {
		return sselTF.getText();
	}

	private String getTsel() {
		return tselTF.getText();
	}

	private String getNsap() {
		return nsapTF.getText();
	}

	public Address getAddress() {
		return new Address(getPsel(), getSsel(), getTsel(), getNsap());
	}

        //
        // Returns the version of this class.
        //
        public String getClassVersion() {
                return (sccs_id);
        }

}
