/*
 * pragma ident "@(#)TmnPopup.java	1.1 97/10/23 Copyright SMI"
 *
 * Copyright (c) 10/23/97 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.commonClass.*;


class TmnPopup extends Frame implements WindowListener, ActionListener, FocusListener {

	private TmnManager manager = null;

	private Vector attributeList = new Vector();
	private Vector textFieldList = new Vector();
	private Vector asn1List = new Vector();

	private String lastAttribute = null;


	private Panel centerPN = null;
	private Panel southPN = null;

	//
	// Close Button
	//
	private Button closeBT = null;
	private static final String LBL_CLOSE = "CLOSE";


	//
	// Use a GrigBag layout for the centerPN
	//
	private GridBagLayout layout;
	private GridBagConstraints constraints;


	//
	// For ASN.1 Syntax
	//
	TextArea textArea = null;


	//
        // Identify version of the class
        //
        private static String sccs_id = "@(#)TmnPopup.java	1.1 97/10/23 Copyright SMI";


	public TmnPopup() {

		super();

		manager = (TmnManager) Context.getProperty("manager");


		// Define the font to be used
		//
		setFont(new Font("Helvetica", Font.PLAIN, 14));

		setSize(400, 700);

		setLayout(new BorderLayout());

		centerPN = new Panel();
		add("Center", centerPN);

		southPN = new Panel();
		add("South", southPN);

		// Use GridBagLayout for the centerPN
		//
		layout = new GridBagLayout();
		centerPN.setLayout(layout);
		constraints = new GridBagConstraints();
		constraints.fill = GridBagConstraints.NONE;
		constraints.weightx = 0.0;
		constraints.anchor = GridBagConstraints.WEST;

		closeBT = new Button(LBL_CLOSE);
		southPN.add(closeBT);
		closeBT.addActionListener(this);

		addWindowListener(this);
	}

	public void addAttributeValue(String a, String v, boolean asn1) {

		// attribute
		Label label = new Label(a);
		add(label, 1, 1);
		attributeList.addElement(a);

		// value
		TextField textField = new TextField(v, 20);
		textField.addFocusListener(this);
		add(textField, GridBagConstraints.REMAINDER, 1);
		textFieldList.addElement(textField);

		// asn1
		asn1List.addElement(new Boolean(asn1));
	}

	private int findIndex(TextField textField) {

		//TmnMessage.debug("textField: " + textField);

		int i = 0;
		for (Enumeration e = textFieldList.elements(); e.hasMoreElements(); ) {
			TextField tf = (TextField) e.nextElement();
			//TmnMessage.debug("tf: " + tf);
			if (tf == textField) {
				return i;
			}
			i++;
		}

		return -1;
	}

	public void addAttributeValueList(Sequence list) {

		TmnMessage.debug("LIST: " + list);

		if (list == null) {
			return;
		}

		int i = 0;
		for (Enumeration e = list.elements(); e.hasMoreElements(); ) {

			Sequence av = (Sequence) e.nextElement();
			String a = null;
			String v = null;

			TmnMessage.debug("\t" + i + ": " + av);
			for (Enumeration e2 = av.elements(); e2.hasMoreElements(); ) {

				Object o = e2.nextElement();
				//TmnMessage.debug("class=" + o.getClass());

				if (a == null) {
					a = (String) o;
				} else if (v == null) {
					if (o instanceof Sequence) {
						v = TmnUtil.valueString((Sequence) o);
					} else {
						v = (String) o;
					}
				} else {
					TmnMessage.bug("TmnPopup.addAttributeValueList():" + e2.nextElement());
				}
			}

			TmnMessage.debug("\t\t" + "a: " + a);
			TmnMessage.debug("\t\t" + "v: " + v);
			addAttributeValue(a, v, true);
			i++;
		}
	}

	public void addSeparator() {
		Panel panel = new Panel();
		add(panel, GridBagConstraints.REMAINDER, 2);
	}

	public void addTextArea() {
		textArea = new TextArea(4, 40);
		add(textArea, GridBagConstraints.REMAINDER, 2);
	}

	private void add(Component c, int width, int height) {
		constraints.gridwidth = width;
		constraints.gridheight = height;
		layout.setConstraints(c, constraints);
		centerPN.add(c);
	}

	public void actionPerformed(ActionEvent e) {
		TmnMessage.debug("Action Performed");
		dispose();
	}

	public void focusGained(FocusEvent e) {
		TmnMessage.debug("Focus Gained");

		//TmnMessage.debug("string=" + e);
		//TmnMessage.debug("source=" + e.getSource());
		//TmnMessage.debug("class=" + e.getSource().getClass());
		//TmnMessage.debug("param=" + e.paramString());

		int index = findIndex((TextField) e.getSource());
		if (index == -1) {
			TmnMessage.bug("TmnPopup.focusGained(): " + index);
			return;
		}
		String a = (String) attributeList.elementAt(index);
		TmnMessage.debug("Attribute: " + a);
		Boolean asn1 = (Boolean) asn1List.elementAt(index);
		TmnMessage.debug("ASN.1: " + asn1);
		if (asn1.booleanValue() == false) {
			textArea.setText("No ASN.1 Description for this Field");
			return;
		}

		if (lastAttribute != null && a.compareTo(lastAttribute) == 0) {
			return;
		}
		lastAttribute = new String(a);

		String cmd = new String(
			"meta::attribute -label "
			+ a 
			+ " -gdmoInfo withAttributeSyntax");
		String s = manager.server.sendMeta(cmd);
		TmnMessage.debug("Syntax: " + s);
		if (s == null) {
			if (textArea != null) {
				textArea.setText("???");
			}
			return;
		}

		cmd = new String(
			"meta::typeRef -label "
			+ s 
			+ " -asInfo definition");
		String t = manager.server.sendMeta(cmd);
		TmnMessage.debug("Text: " + t);
		if (t == null) {
			if (textArea != null) {
				textArea.setText("???");
			}
			return;
		}

		if (textArea != null) {
			textArea.setText(t);
		}
	}

	public void focusLost(FocusEvent e) {
		TmnMessage.debug("Focus Lost");
	}

	public void windowActivated(WindowEvent e) {
		TmnMessage.debug("Window Activated");
	}

	public void windowClosed(WindowEvent e) {
		TmnMessage.debug("Window Closed");
	}

	public void windowClosing(WindowEvent e) {
		TmnMessage.debug("Window Closing");
		dispose();
	}

	public void windowDeactivated(WindowEvent e) {
		TmnMessage.debug("Window Deactivated");
	}

	public void windowDeiconified(WindowEvent e) {
		TmnMessage.debug("Window Deiconified");
	}

	public void windowIconified(WindowEvent e) {
		TmnMessage.debug("Window Iconified");
	}

	public void windowOpened(WindowEvent e) {
		TmnMessage.debug("Window Opened");
	}

        //
        // Returns the version of this class.
        //
        public String getClassVersion() {
                return (sccs_id);
        }
}

