/*
 * pragma ident "@(#)TmnMessage.java	1.3 97/10/23 Copyright SMI"
 *
 * Copyright (c) 10/23/97 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.client.*;
import com.sun.tmnscript.cmis.*;
import com.sun.tmnscript.commonClass.*;
import com.sun.tmnscript.primitive.*;
import com.sun.tmnscript.exception.*;
import com.sun.tmnscript.errorClass.*;

import com.sun.tmnscript.encDec.*;


public class TmnMessage {

	private static WarningDialog warningDL = null;
	private static ErrorDialog errorDL = null;

	public static void init(Frame frame) {
		warningDL = new WarningDialog(frame, "");
		errorDL = new ErrorDialog(frame, "");
	}

	public static void debug(String string) {

		if (true) {
			return;
		}

		if (string == null) {
			System.out.println("");
			return;
		}

		System.out.println("DEBUG: " + string);
	}

	public static void warning(String string) {

		System.out.println("WARNING: " + string);

		warningDL.setMessage(string);
		warningDL.validate();
		warningDL.pack();
		warningDL.show();
	}

	public static void error(String string) {

		System.err.println("ERROR: " + string);

		errorDL.setMessage(string);
		errorDL.show();
	}

	public static void bug(String string) {

		System.err.println("BUG: " + string);
	}


	//
	// more complex methods
	//

	public static void cnfsDebug(Cnf[] cnfs) {
		TmnMessage.debug("CONFIRMATION received:");
		try {
			TmnMessage.debug(Encoding.cnfListEncoding(cnfs));
		} catch (Exception e) {
			TmnMessage.bug(e.getMessage());
			return;
		}
		TmnMessage.debug(null);
	}

	public static void eventIndDebug(EventInd eventInd) {
		TmnMessage.debug("EVENT INDICATION received:");
		try {
			TmnMessage.debug(Encoding.indEncoding((Ind)eventInd));
		} catch (Exception e) {
			TmnMessage.bug(e.getMessage());
			return;
		}
		TmnMessage.debug(null);
	}

	public static void apiError(APIError error) {
		TmnMessage.debug("APIError received: " + error);
		try {
			ValueList valueList = Encode.APIError(error);
			TmnMessage.error("CMIP Error: "
				+ valueList.toList());
		} catch (Exception e) {
			TmnMessage.bug("TmnMessage.apiError(): "
				+ e.getMessage());
		}
	}
}


