/*
 * pragma ident "@(#)TmnGlobalCallback.java	1.1 97/10/23 Copyright SMI"
 *
 * Copyright (c) 10/23/97 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.client.*;
import com.sun.tmnscript.cmis.*;
import com.sun.tmnscript.commonClass.*;
import com.sun.tmnscript.primitive.*;
import com.sun.tmnscript.exception.*;
import com.sun.tmnscript.errorClass.*;


class TmnGlobalCallback extends GlobalCallBackReg {

	TmnManager manager = null;

	//
        // Identify version of the class
        //
        private static String sccs_id = "@(#)TmnGlobalCallback.java	1.1 97/10/23 Copyright SMI";

	public TmnGlobalCallback(TmnManager manager) {

		super();

		this.manager = manager;
	}


	public void callBackCnf(InQueue queue, int invokeId) {
		Cnf[] lisOfConfirmation = null;

		// Retrieve confirmation
		lisOfConfirmation = queue.getConfirmation(invokeId);

		TmnMessage.cnfsDebug(lisOfConfirmation);
	}

	public void callBackInd(InQueue queue, int invokeId) {
		Ind indication = null;

		// Get reference to indication
		indication = queue.examineIndication(invokeId);

		try {
			TmnMessage.debug("INDICATION received");
			TmnMessage.debug(Encoding.indEncoding(indication));
			TmnMessage.debug(null);
		} catch (InvalidServicePrimitiveException e) {
			TmnMessage.bug("callBackInd(): " + e.getMessage());
		}
	}

	public void callBackEventInd(InQueue queue, int invokeId) {
		EventInd eventIndication = null;

		// Retrieve indication
		eventIndication = queue.getEventInd(invokeId);

		TmnMessage.eventIndDebug(eventIndication);

		manager.event.add(eventIndication);
        }

	public void callBackEventCnf(InQueue queue, int invokeId) {
		EventCnf eventConfirmation = null;

		// Retrieve confirmation
		eventConfirmation = queue.getEventCnf(invokeId);

		try {
			TmnMessage.debug("EVENT CONFIRMATION received");
			TmnMessage.debug(Encoding.cnfEncoding((Cnf)eventConfirmation));
			TmnMessage.debug(null);
		} catch (InvalidServicePrimitiveException e) {
			TmnMessage.bug("callBackEventCnf(): " + e.getMessage());
		}
        }

	public String getClassVersion() {
		return (sccs_id);
	}
}


