/*
 * pragma ident "@(#)TmnGetCallback.java	1.1 97/10/23 Copyright SMI"
 *
 * Copyright (c) 10/23/97 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.client.*;
import com.sun.tmnscript.cmis.*;
import com.sun.tmnscript.commonClass.*;
import com.sun.tmnscript.primitive.*;
import com.sun.tmnscript.exception.*;
import com.sun.tmnscript.errorClass.*;


public class TmnGetCallback extends CallBackReg {

	public void callBack(Cnf[] cnfs) {

		TmnMessage.cnfsDebug(cnfs);

		if (cnfs.length != 1) {
			TmnMessage.bug("TmnGetCallback.callBack(): length = "
				+ cnfs.length);
			return;
		}

		Cnf cnf = cnfs[0];

		if (!(cnf instanceof GetCnf)) {
			TmnMessage.bug("TmnGetCallback.callBack(): class = "
				+ cnf.getClass().toString());
			return;
		}

		GetCnf getCnf = (GetCnf) cnf;

		if (getCnf.errorPresent()) {
			APIError error = getCnf.getError();
			TmnMessage.apiError(error);
			return;
		}

		TmnPopup popup = new TmnPopup();

		// moc
		String oc = getCnf.getObjectClass();
		if (oc != null) {
			TmnMessage.debug("MOC: " + oc);
		}
		popup.addAttributeValue("MOC", oc, false);

		// moi
		ObjectInstance oi = getCnf.getObjectInstance();
		if (oi != null) {
			TmnMessage.debug("MOI: " + oi);
		}
		popup.addAttributeValue("MOI", TmnUtil.oiString(oi), false);
		popup.setTitle(TmnUtil.oiString(oi));

		popup.addSeparator();

		// info
		Sequence info = getCnf.getAttributeList();
		popup.addAttributeValueList(info);

		popup.addSeparator();

		// ASN.1 Text Area
		popup.addTextArea();

		TmnMessage.debug(null);
		popup.show();
	}
}

