/*
 * pragma ident "@(#)TmnFolder.java	1.3 97/10/23 Copyright SMI"
 *
 * Copyright (c) 10/23/97 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.commonClass.*;
import com.sun.tmnscript.primitive.*;
import com.sun.tmnscript.errorClass.*;
import com.sun.tmnscript.cmis.*;


class TmnFolder extends BrowserFolder {

	private String moc = null;
	private ObjectInstance moi = null;

	//
        // Identify version of the class
        //
        private static String sccs_id = "@(#)TmnFolder.java	1.3 97/10/23 Copyright SMI";


	public TmnFolder(TmnBrowser browser, Image image, String moc, ObjectInstance moi) {

		super(browser, "", image, image);

		setMoc(moc);
		setMoi(moi);
	}

	public String getMoc() {

		return new String(moc);
	}

	public void setMoc(String moc) {

		if (moc == null) {
			TmnMessage.bug("TmnFolder.setMoc(): moc is null");
			return;
		}

		this.moc = new String(moc);
	}

	public ObjectInstance getMoi() {

		return (ObjectInstance) moi.clone();
	}

	public void setMoi(ObjectInstance moi) {

		if (moi == null) {
			TmnMessage.bug("TmnFolder.setMoi(): moi is null");
			return;
		}

		this.moi = (ObjectInstance) moi.clone();

		setString(TmnUtil.oiShortString(moi));
	}

	public int loadChildren() {

		TmnBrowser browser = (TmnBrowser) getBrowser();
		TmnManager manager = browser.manager;
		GetReq getReq = null;
		Cnf[] cnfs = null;
		int num = 0;


		try {
			getReq = new GetReq(moc, moi, new Sequence());
		} catch (Exception e) {
			TmnMessage.bug("TmnFolder.loadChildren(): " + e.getMessage());
			return -1;
		}

		try {
			getReq.setScope(new Scope(Scope.FIRST_LEVEL));
		} catch (Exception e) {
			TmnMessage.bug("TmnFolder.loadChildren(): " + e.getMessage());
			return -1;
		}

		cnfs = manager.server.sendSync(getReq);
		if (cnfs == null) {
			return -1;
		}

		int length = cnfs.length;

		for (int i = 0; i < length; i++) {

			Cnf cnf = cnfs[i];

			if (!(cnfs[i] instanceof GetCnf)) {
				TmnMessage.error("Unexpected Confirmation Received: "
					+ cnf.getClass().toString());
				return -1;
			}

			GetCnf getCnf = (GetCnf) cnf;

			if (getCnf.errorPresent()) {
				
				APIError error = getCnf.getError();
				TmnMessage.apiError(error);
				return -1;
			}

			String oc = getCnf.getObjectClass();
			if (oc != null) {
				TmnMessage.debug("MOC: " + oc);
				ObjectInstance oi = getCnf.getObjectInstance();
				if (oi != null) {
					TmnMessage.debug("MOI: " + oi.toString());
					TmnFolder f = new TmnFolder(browser, browser.nodeI, oc, oi);
					append(f);
					f.show();
					num++;
				}
			}

		}
		TmnMessage.debug(null);

		return num;
	}

	public void unloadChildren() {

		int num = numChildren();

		for (int i = 0; i < num; i++) {

			TmnFolder f = (TmnFolder) nodeAt(0);
			remove((BrowserFolder) f);
		}
	}

	public TmnFolder setLeaf(TmnFolder folder) {
		TmnBrowser browser = (TmnBrowser) getBrowser();
		int index = indexOf(folder);
		TmnFolder f = new TmnFolder(browser, browser.leafI,
			folder.getMoc(), folder.getMoi());
		insertAt(f, index);
		remove((BrowserFolder) folder);
		f.show();

		return f;
	}

	public void get() {
		TmnBrowser browser = (TmnBrowser) getBrowser();
		TmnManager manager = browser.manager;
		GetReq getReq = null;
		TmnGetCallback getCallback = new TmnGetCallback();


		try {
			getReq = new GetReq(moc, moi, new Sequence());
		} catch (Exception e) {
			TmnMessage.bug("TmnFolder.get(): " + e.getMessage());
			return;
		}

		try {
			getReq.setScope(new Scope(Scope.BASE_ONLY));
		} catch (Exception e) {
			TmnMessage.bug("TmnFolder.get(): " + e.getMessage());
			return;
		}

		manager.server.sendAsync(getReq, getCallback);

		return;
	}

	//
	// Returns the version of this class.
	//
	public String getClassVersion() {
		return (sccs_id);
	}
}

