/*
 * pragma ident "@(#)TmnEvent.java	1.2 97/10/23 Copyright SMI"
 *
 * Copyright (c) 10/23/97 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.commonClass.*;
import com.sun.tmnscript.primitive.*;


class TmnEvent extends PropertySection implements ItemListener, ActionListener {

	private TmnManager manager = null;

	private Table table = null;

	private Vector events = new Vector();
	private int total = 0;

	//MediaTracker tracker = new MediaTracker(this);

	//
	// Image for alarm
	//
	static Image alarmI = null;

	//
        // Identify version of the class
        //
        private static String sccs_id = "@(#)TmnEvent.java	1.2 97/10/23 Copyright SMI";


	public TmnEvent(TmnManager manager) {

		super();

		if (alarmI == null) {
			Component applet = (Component) Context.getProperty("applet");
			try {
				alarmI = Context.getImage("images/alarm.gif", applet);
			} catch (Exception e) {
				TmnMessage.bug("TmnEvent(): " + e.getMessage());
			}
		}
			
		setLayout(new BorderLayout());

		this.manager = manager;
		table = new Table();
		add("Center", table);

		table.setNumColumns(4);
		table.setColumnLabel(0, "");
		table.setColumnWidthInChars(0, 3);
		table.setColumnLabel(1, "Id");
		table.setColumnWidthInChars(1, 6);
		table.setColumnLabel(2, "Moi");
		table.setColumnWidthInChars(2, 22);
		table.setColumnLabel(3, "Type");
		table.setColumnWidthInChars(3, 18);

		table.setVisibleRows(20);
		table.setRowGap(2);
		table.setColumnGap(10);
		table.setColumnsResizable(true);
		table.showColumnDividers(true);

		table.addItemListener(this);
		table.addActionListener(this);
	}

	public void itemStateChanged(ItemEvent e) {

		TmnMessage.debug("itemStateChanged()");
	}

	public void actionPerformed(ActionEvent e) {

		TmnMessage.debug("actionPerformed()");

		//TmnMessage.debug("source=" + e.getSource());
		//TmnMessage.debug("class=" + e.getSource().getClass());
		//TmnMessage.debug("string=" + e);
		//TmnMessage.debug("param=" + e.paramString());
		//TmnMessage.debug("cmd=" + e.getActionCommand());

		String cmd = e.getActionCommand();
		int row = Integer.parseInt(cmd);
		TmnMessage.debug("row: " + row);
		int id = total - row - 1;
		TmnMessage.debug("ID: " + id);

		EventInd event = (EventInd) events.elementAt(id);
		TmnPopup popup = new TmnPopup();

		// id
		popup.addAttributeValue("ID", (new Integer(id)).toString(), false);
		popup.setTitle("Event " + id);

		popup.addSeparator();

		// moc
		String moc = event.getObjectClass();
		TmnMessage.debug("MOC: " + moc);
		popup.addAttributeValue("MOC", moc, false);

		// moi
		ObjectInstance moi = event.getObjectInstance();
		TmnMessage.debug("MOI: " + moi.toString());
		popup.addAttributeValue("MOI", TmnUtil.oiString(moi), false);

		popup.addSeparator();

		// type
		String type = new String("unknown");
		Sequence info = event.getEventIdInfoPair();
		Object first = info.elementAt(0);
		if (first != null) {
			type = (String) first;
		}
		TmnMessage.debug("TYPE: " + type);
		popup.addAttributeValue("TYPE", type, false);

		popup.addSeparator();

		// event info
		Object second = info.elementAt(1);
		popup.addAttributeValueList((Sequence) second);

		popup.addSeparator();

		// ASN.1 Text Area
		popup.addTextArea();

		TmnMessage.debug(null);
		popup.show();
	}

	public void add(EventInd event) {

		TmnMessage.debug("total: " + total);

		//
		// Add in the table
		//

		// moc
		String moc = event.getObjectClass();
		TmnMessage.debug("MOC: " + moc);

		// moi
		ObjectInstance moi = event.getObjectInstance();
		TmnMessage.debug("MOI: " + moi.toString());

		// type
		String type = new String("unknown");
		Sequence info = event.getEventIdInfoPair();
		Object first = info.elementAt(0);
		if (first != null) {
			type = (String) first;
		}
		TmnMessage.debug("TYPE: " + type);
		TmnMessage.debug(null);

		Vector row = new Vector();
		row.addElement(alarmI);
		row.addElement(new Integer(total));
		row.addElement(TmnUtil.oiString(moi));
		row.addElement(type);

		table.addRow(row, 0);


		//
		// Add in internal structures
		//
		events.addElement(event);
		total++;
	}

	public void clear() {
		total = 0;
	}


	//
	// Returns the version of this class
	//
	public String getClassVersion() {
		return (sccs_id);
	}
}


