/*
 * pragma ident "@(#)TmnBrowser.java	1.3 97/10/23 Copyright SMI"
 *
 * Copyright (c) 10/23/97 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.commonClass.*;


class TmnBrowser extends Browser implements ItemListener {

	TmnManager manager = null;
	private TmnFolder root = null;

	//
	// Image for node/leaf
	//
	static Image nodeI = null;
	static Image leafI = null;

	//
        // Identify version of the class
        //
        private static String sccs_id = "@(#)TmnBrowser.java	1.3 97/10/23 Copyright SMI";

	public TmnBrowser(TmnManager manager) {

		super();

		this.manager = manager;

		if (nodeI == null) {
			Component applet = (Component) Context.getProperty("applet");
			try {
				nodeI = Context.getImage("images/node.gif", applet);
				leafI = Context.getImage("images/leaf.gif", applet);
			} catch (Exception e) {
				TmnMessage.bug("TmnFolder(): " + e.getMessage());
			}
		}

		root = new TmnFolder(this, nodeI,
			manager.agent.getRootMoc(), manager.agent.getRootMoi());
		setTopNode(root);
		root.collapse();

		addMouseListener(this);
		addItemListener(this);
	}

	public Dimension preferredSize() {
		return new Dimension(300, 400);
	}

	public void init() {
		root.loadChildren();
		root.expand();
	}

	public void end() {
		erase();

		root = new TmnFolder(this, nodeI,
			manager.agent.getRootMoc(), manager.agent.getRootMoi());
		setTopNode(root);
		root.collapse();
	}

	public TmnFolder getSelectedFolder() {
		Enumeration folders;

		folders = getSelectedNodes();

		if (folders == null) {
			return null;
		}

		if (!folders.hasMoreElements()) {
			return null;
		}

		return (TmnFolder) folders.nextElement();
	}

	public void itemStateChanged(ItemEvent e) {

		int state = e.getStateChange();
		//TmnMessage.debug("getStateChange()=" + state);

		//Object source = e.getSource();
		//TmnMessage.debug("Class(source)=" + source.getClass().toString());
		//TmnMessage.debug("getItemSelectable()=" + e.getItemSelectable());
		//TmnMessage.debug("getItem()=" + e.getItem());
		//TmnMessage.debug("paramString()=" + e.paramString());
		//TmnMessage.debug("toString()=" + e.toString());

		if (state == 101 || state == 102) {
			TmnFolder folder = (TmnFolder) e.getItem();
			if (folder.isExpanded()) {
				TmnMessage.debug("Folder EXPANDED");
				int num = folder.loadChildren();
				if (num == 0) {
					TmnMessage.debug("This Folder is a Leaf");
					TmnFolder parent = (TmnFolder) folder.getParent();
					TmnFolder f = parent.setLeaf(folder);
					f.expand();
					f.repaint();
				} else {
					folder.expand();
				}
			} else {
				TmnMessage.debug("Folder COLLAPSED");
				folder.unloadChildren();
			}
		} else if (state ==  ItemEvent.SELECTED) {
			TmnMessage.debug("Folder SELECTED");
		} else if (state == ItemEvent.DESELECTED) {
			TmnMessage.debug("Folder DESELECTED");
		} else {
			TmnMessage.debug("Unknown Item Event: " + e.toString());
		}
		TmnMessage.debug(null);
	}

	public void mouseClicked(MouseEvent e) {
		TmnMessage.debug("Mouse Clicked");
		if (e.getClickCount() == 2) {
			TmnMessage.debug("Double Click");
			TmnFolder folder = getSelectedFolder();
			if (folder != null) {
				folder.get();
			}
		}
		TmnMessage.debug(null);
	}

	//
	// Returns the version of this class.
	//
	public String getClassVersion() {
		return (sccs_id);
	}
}


