/*
 * pragma ident "@(#)TmnAgent.java	1.5 98/07/01 Copyright SMI"
 *
 * Copyright (c) 07/01/98 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

import sunw.admin.avm.base.*;

import com.sun.tmnscript.client.*;
import com.sun.tmnscript.cmis.*;
import com.sun.tmnscript.commonClass.*;
import com.sun.tmnscript.primitive.*;


class TmnAgent extends PropertySection implements ActionListener {

	TmnManager manager = null;

	// Default Values for the CMIP Agent.
	public static final Address DEFAULT_AGENT_ADDRESS
		= new Address("rfc4", "Prs", "CMIP", "");
        public static final String DEFAULT_ROOT_MOC = "system";
        public static final ObjectInstance DEFAULT_ROOT_MOI = new ObjectInstanceLDN();


	//
	// Textfields for storing the different parameters
	// related to the CMIP Agent
	//
	private TextField pselTF;
	private TextField sselTF;
	private TextField tselTF;
	private TextField nsapTF;
	private TextField mocTF;
	//private Choice mocCH;
	private TextField moiIdTF;
	private TextField moiValueTF;


	//
	// Use a GrigBag layout: it is so much fun ...
	//
	private GridBagLayout layout;
	private GridBagConstraints constraints;


	//
        // Identify version of the class
        //
        private static String sccs_id = "@(#)TmnAgent.java	1.5 98/07/01 Copyright SMI";


	public TmnAgent(TmnManager manager) {

		Label label;

		this.manager = manager;

		// Define the font to be used
		//
		setFont(new Font("Helvetica", Font.PLAIN, 14));

		// Use GridBagLayout so we can put component 
		// wherever we need
		//
		layout = new GridBagLayout();
		setLayout(layout);
		constraints = new GridBagConstraints();
		constraints.fill = GridBagConstraints.NONE;
		constraints.weightx = 0.0;
		constraints.anchor = GridBagConstraints.CENTER;


		// Bind Address
		add(new Label("     "), 1, 1);
		label = new Label("Bind Address:");
		add(label, 1, 1);
		pselTF = new TextField(DEFAULT_AGENT_ADDRESS.getPsel(), 5);
		add(pselTF, 1, 1);
		sselTF = new TextField(DEFAULT_AGENT_ADDRESS.getSsel(), 5);
		add(sselTF, 1, 1);
		tselTF = new TextField(DEFAULT_AGENT_ADDRESS.getTsel(), 5);
		add(tselTF, 1, 1);
		nsapTF = new TextField(DEFAULT_AGENT_ADDRESS.getNsap(), 5);
		add(nsapTF, GridBagConstraints.REMAINDER, 1);

		//
		// Root MOC
		//
		add(new Label("     "), 1, 1);
		label = new Label("Root MOC:");
		add(label, 1, 1);

		mocTF = new TextField(DEFAULT_ROOT_MOC, 20);
		mocTF.addActionListener(this);
		add(mocTF, GridBagConstraints.REMAINDER, 1);

		//mocCH = new Choice();
		//mocCH.add("Select a MOC");
		//add(mocCH, GridBagConstraints.REMAINDER, 1);

		//
		// Root Moi
		//
		add(new Label("     "), 1, 1);
		label = new Label("Root MOI:");
		add(label, 1, 1);

		moiIdTF = new TextField("systemId", 10);
		moiIdTF.addActionListener(this);
		add(moiIdTF, 1, 1);

		try {
			moiValueTF = new TextField(java.net.InetAddress.getLocalHost().getHostName(), 10);
		} catch (Exception e) {
			TmnMessage.bug(e.getMessage());
		}

		moiValueTF.addActionListener(this);
		add(moiValueTF, GridBagConstraints.REMAINDER, 1);
	}

	public void init() {
		//String mocList = manager.server.sendMeta("meta::mocList");
		//TmnMessage.debug("MOC LIST:");
		//TmnMessage.debug(mocList);

		//Vector mocVector = TmnUtil.splitString(mocList);
		//for (int i = 0; i < mocVector.size(); i++) {
		//	String moc = (String) mocVector.elementAt(i);
		//	TmnMessage.debug("\t" + moc);
		//	mocCH.add(moc);
		//}
		//TmnMessage.debug(null);
	}

	public void actionPerformed(ActionEvent e) {
		TmnMessage.debug("Agent Configuration Changed");
		manager.mit.end();
		manager.mit.init();
        }

	private void add(Component c, int width, int height) {
		constraints.gridwidth = width;
		constraints.gridheight = height;
		layout.setConstraints(c, constraints);
		add(c);
	}

	private String getPsel() {
		return pselTF.getText();
	}

	private String getSsel() {
		return sselTF.getText();
	}

	private String getTsel() {
		return tselTF.getText();
	}

	private String getNsap() {
		return nsapTF.getText();
	}

	public Address getAddress() {
		return new Address(getPsel(), getSsel(), getTsel(), getNsap());
	}

	public String getRootMoc() {
		return mocTF.getText();
	}

	public ObjectInstance getRootMoi() {
		ObjectInstance moi = (ObjectInstance) new ObjectInstanceDN(
			new Sequence(moiIdTF.getText(), moiValueTF.getText()));
		return moi;
	}

        //
        // Returns the version of this class.
        //
        public String getClassVersion() {
                return (sccs_id);
        }
}

