#ifdef _SUNOS
#pragma ident "@(#)test_mis.c	1.6 97/10/03 Copyright SMI"
#endif

/******************************************************************************
 * Copyright 10/03/97 Sun Microsystems, Inc. All Rights Reserved		      *
 *			All Rights Reserved				      *
 ******************************************************************************/

/******************************************************************************/
/*  File Name: 		test_mis.c                                            */
/*----------------------------------------------------------------------------*/
/*                                                                            */
/*  Description:                                                              */
/*  -----------                                                               */
/* 	This example file contains a simple example to demonstrate how	      */
/* 	requests and responses are sent, and how indications and confirmations*/
/* 	are received, based on the TMNscript GET commands via the C API.      */
/*									      */
/* 	The program acts as both manager and agent. The addresses for the     */
/*	manager	and the agent are set to be the same so that the messages     */
/*	are looped back.						      */
/*									      */
/* 	Mapping mode and ASN.1 mode are both enabled. Objects are expressed   */
/* 	using human-readable names, and data values are expressed using the   */
/* 	string representation provided by Solstice TMNscript.		      */
/*                                                                            */
/******************************************************************************/


/*----------------------------------------------------------------------------*/
/*                               STANDARD INCLUDE                             */
/*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*----------------------------------------------------------------------------*/
/*                               COMMON INCLUDE                               */
/*----------------------------------------------------------------------------*/
#include "common.h"

/* 
* Set addresses for the manager and the agent to be the same, so that messages 
* are looped back
*/
#define MANAGER "{{psel rfc4} {ssel Prs} {tsel CMIP} {nsap ""}}"
#define AGENT "{{psel rfc4} {ssel Prs} {tsel CMIP} {nsap ""}}"

/* 
* Operation-specific information for the GET response
*/
#define INFO "[list [lindex $moi 0] {systemTitle {{oid 1.2.3.4.5.6}}} {operationalState enabled} {usageState active} {administrativeState unlocked}]"

void main(void) 
{
	/*
	* Declare and initialize variables
	*/
	tmns_return_t *result = NULL;
	tmns_configuration_t configure = {FALSE,TRUE,FALSE,FALSE,FALSE,TRUE};
	tmns_get_req_t getReq = {NULL,NULL,NULL,NULL,NULL,NULL};
	tmns_get_rsp_t getRsp = {NULL,NULL,NULL,NULL,NULL,NULL,NULL};
	char *id = NULL;
	char *session = NULL;

	/*
	* Display MANAGER and AGENT addresses
	*/
	printf("\nAddress for manager application: %s\n", MANAGER);
	printf("\nAddress for agent application: %s\n\n", AGENT);

	/*
	* Change display of messages received
	* Either TRUE => pretty print or FALSE => standard print
	*/
	prettyprint = FALSE;

/* 
* -----------------------------------
* PHASE1 : Initialize the interpreter
* -----------------------------------
*/

	/*
	* Initialize the TMNscript interpreter
	*/
	result = evaluateResult(tmns_init());
	tmns_freeResult(result); /* Cleaning */

/* 
* -----------------------------------------------------------
* PHASE2 : Use interpreter and API functions to do processing
* -----------------------------------------------------------
*/

	/*
	* Load Metadata & Scripts
	*/
	load("/opt/SUNWconn/TMNscript/example/compiler/mapper.tcl");

	load("/opt/SUNWconn/TMNscript/example/compiler/parser.tcl");

	load("/opt/SUNWconn/TMNscript/script/tmns_type.tcl");


	/*
	* Initialization & Configuration
	*/
	configure.mp_asn1ModeOn = TRUE;
	configure.mp_mapperModeOn = TRUE;
	configure.mp_misTraceOn = FALSE;
	configure.mp_internalStatusOn = FALSE;
	configure.xmp_decoding = FALSE;

	configureOperatingModes(configure);


	/*
	* Define a variable in the interpreter that contains the 
	* object instance name
	*/
	result = setMoi(); /* Set variable in the interpreter */
	tmns_freeResult(result); /* Cleaning */


	/*
	* Bind the application with automatic association handling
	*/
	session = bind(MANAGER);


	/*
	* Send GET request to the AGENT
	*/
	getReq.session = session;
	getReq.at = AGENT;
	getReq.scope = "{whole}";
	getReq.moc = "system";
	getReq.moi = NULL; /* Value is retrieved from the interpreter */ 
	getReq.info = "{all}";

	sendGetAll(getReq);

	
	/*
	* Wait up to 10 seconds to receive the GET INDICATION
	*/
	printf("\nGET INDICATION received by the agent:\n");
	result = receiveOne(session);


	/*
	* Get the invoke identifier contained in the indication in order 
	* to be able to send a response
	*/
	id = getInvokeId(result);
	tmns_freeResult(result); /* Cleaning */


	/*
	* Send GET response to the MANAGER
	*/
	getRsp.session = session;
	getRsp.id = id;
	getRsp.link = "last";
	getRsp.moc = "system";
	getRsp.moi = NULL; /* Value is retrieved from the interpreter */
	getRsp.error = "{}";
	getRsp.info = INFO;

	sendGetRsp(getRsp);


	/*
	* Receive all GET CONFIMATIONS
	*/
	printf("\nGET CONFIRMATION(S) received by the manager:\n");
	receiveAll(session);


	/*
	* Unbind the bound session
	*/
	unbind(session);

/* 
* ----------------------------
* PHASE3 : End the interpreter
* ----------------------------
*/
	/*
	* Close the TMNscript interpreter to free allocated resources
	*/
	tmns_end();

	/*
	* Cleaning
	*/
	free(session);
	free(id);
}

