#ifdef _SUNOS
#pragma ident "@(#)common.h	1.3 97/10/03 Copyright SMI"
#endif

/******************************************************************************
* Copyright 10/03/97 Sun Microsystems, Inc. All Rights Reserved		      *
*			All Rights Reserved				      *
******************************************************************************/

/******************************************************************************/
/*  File Name: 		common.h                                              */
/*----------------------------------------------------------------------------*/
/*                                                                            */
/*  Description:                                                              */
/*  -----------                                                               */
/*       The present file contains external declarations of functions         */
/*       and variables common to the example.	              		      */
/*                                                                            */
/******************************************************************************/

#ifndef __COMMON_H__
#define __COMMON_H__

/*----------------------------------------------------------------------------*/
/*                               C API INCLUDE	                	      */
/*----------------------------------------------------------------------------*/
#include <TMNsbind.h>

/*----------------------------------------------------------------------------*/
/*             DEFINITION OF CONFIGURATION STRUCTURE               	      */
/*----------------------------------------------------------------------------*/
typedef struct _tmns_configuration_t {
	int 		mp_asn1ModeOn;
	int 		mp_errorModeOn;
	int 		mp_mapperModeOn;
	int 		mp_misTraceOn;
	int 		mp_internalStatusOn;
	int 		xmp_decoding;
} tmns_configuration_t;

/*----------------------------------------------------------------------------*/
/*             DEFINITION OF GET REQUEST STRUCTURE               	      */
/*----------------------------------------------------------------------------*/
typedef struct _tmns_get_req_t {
	char 		*session;
	char 		*at;
	char 		*scope;
	char 		*moc;
	char 		*moi;
	char 		*info;
} tmns_get_req_t;

/*----------------------------------------------------------------------------*/
/*             DEFINITION OF GET RESPONSE STRUCTURE               	      */
/*----------------------------------------------------------------------------*/
typedef struct _tmns_get_rsp_t {
	char 		*session;
	char 		*id;
	char 		*link;
	char 		*moc;
	char 		*moi;
	char 		*error;
	char		*info;
} tmns_get_rsp_t;

/*----------------------------------------------------------------------------*/
/*             DECLERATION OF PRINTING VARIABLE		                      */
/*----------------------------------------------------------------------------*/
extern int prettyprint;

/*----------------------------------------------------------------------------*/
/*             DECLERATION OF COMMON FUNCTIONS		                      */
/*----------------------------------------------------------------------------*/

extern void load(char *tclFile);

extern void configureOperatingModes(tmns_configuration_t configure);

extern char *bind(char *address);
extern void unbind(char *session);

extern tmns_return_t *setMoi(void);

extern void sendGetAll(tmns_get_req_t getReq);
extern void sendGetRsp(tmns_get_rsp_t getRsp);

extern char *getInvokeId(tmns_return_t *ind);

extern tmns_return_t *receiveOne(char *session);
extern void receiveAll(char *session);

extern tmns_return_t *evaluateResult(tmns_return_t *result);

extern void prettyPrint(tmns_return_t *messageReceived);
extern void printMessage(char *header,tmns_return_t *result);

extern char *getHostName(void);
extern char *buildMsg(char *msg);

#endif /* __COMMON_H__ */
