#
# End of pp pre-processing

proc boksroute_init boks_localhost {

    global BOKSROUTES
    
    array set BOKSROUTES  "
    login_never	{}
    login_local	{LOGIN:*->* XDM:$boks_localhost->*}
    login_trusted	{RLOGIN,TELNET,XDM:TRUSTED->*}
    login_known	{RLOGIN,TELNET,XDM:KNOWN/*->*}
    login_world	{RLOGIN,TELNET,XDM:ANY/*->*}
    login_logonly	{RLOGIN,TELNET,XDM:ANY/*->*}
    su_never	{}
    su_user		{SU:*->*}
    su_root		{SU:*->#0 SU:*->*}
    su_logonly	{SU:*->#0 SU:*->*}
    rexec_never	{}
    rexec_trusted	{REXEC,FTP,PCNFS:TRUSTED->* RSH:TRUSTED->*}
    rexec_known	{REXEC,FTP,PCNFS:KNOWN/*->* RSH:UNIXBOKS/*->*}
    rexec_world	{REXEC,FTP,PCNFS:ANY/*->* RSH:UNIXBOKS/*->*}
    rexec_logonly	{REXEC,RSH,FTP,PCNFS:ANY/*->*}
    telnet_ssodt	{TELNET:SSODT->SSOSRV}
    "

    foreach l {trusted known world logonly} {
	append BOKSROUTES(login_$l) " $BOKSROUTES(login_local)"
    }
}

# These are identical, apart from the extra office-hour bit. (bit 7)
#
array set BOKSTIMES {
    anytime	{127 0 86400}
    workhours	{159 0 86400}
}

# FIXME: Remove the global declaration below.

global BOKSTIMES DAYS_2_TEXT
foreach i [array names BOKSTIMES] {
    set DAYS_2_TEXT([lindex $BOKSTIMES($i) 0]) $i
}

# Fallback in case initialization is not called, or the gen_weekday_list
# message is not defined.
#
set DAYBITS_2_TEXT {1 Mon 2 Tue 4 Wed 8 Thu 16 Fri 32 Sat 64 Sun 128 Workdays}
set DAYSBITS_2_TEXT {1 Mon 2 Tue 4 Wed 8 Thu 16 Fri 32 Sat 64 Sun 128 Workdays}

#----------------------------------------------------------------------
# Conversion between bitmap (in a decimal no) and the "1234.." format.
# Also cnversion into text format ("Mon,Tue,..").
#----------------------------------------------------------------------

# boks_days_2_text <time>
#	<time> is a bitmap representing days of week, as stored in
#	BoKS's database. This proc returns a text describing
#	the selected days.
#
proc boks_days_2_text time {
    global DAYS_2_TEXT
    if [catch {set tmp $DAYS_2_TEXT($time)}] {
	return [boks_daybits2text $time]
    } else {
	return [MSG_GET $tmp]
    }
}

# To be called after messages have been loaded/re-loaded.
#
proc boks_init_daybits2text {} {
    global DAYSBITS_2_TEXT

    set days [MSG_GET gen_weekday_list]
    if ![string compare <gen_weekday_list> $days] {
	return
    }
    set DAYSBITS_2_TEXT {}
    set k 1
    foreach i $days {
	lappend DAYSBITS_2_TEXT $k $i
	set k [expr $k*2]
    }
}

# Convert a day specification bitpattern to a string spelling out
# the included days.
#
proc boks_daybits2text bits {
    global DAYSBITS_2_TEXT
    set ret ""
    foreach {i no} $DAYSBITS_2_TEXT {
	if { $i & $bits } {
	    lappend ret $no
	}
    }
    return [join $ret ,]
}

# Convert a day specification bitpattern to a string accepted
# by bksdef's -w flag (the "12345.." format).
#
proc boks_daybits2string bits {
    set ret ""
    foreach {i no} {1 1 2 2 4 3 8 4 16 5 32 6 64 7 128 8} {
	if { $i & $bits } {
	    append ret $no
	}
    }
    return $ret
}

# Convert a weekdays specification in the "123456.." format, to a
# bit pattern (as stored in the database).
#
proc boks_string2daybits str {
    set sum 0
    array set b {1 1 2 2 3 4 4 8 5 16 6 32 7 64 8 128}
    foreach i [split $str ""] {
	set sum [expr $sum + $b($i)]
    }
    return $sum
}

#----------------------------------------------------------------------
# Access route handling
#----------------------------------------------------------------------

# Map a route (given its modifier list) to a label.
# Unknown routes are ignored (return empty strings)
#
proc routelabel {modlist {timevar {}}} {
    global BOKSROUTES

    if [regexp {adm#=([^/,]*)/([^,]*)} $modlist m label time] {
	if [info exists BOKSROUTES($label)] {
	    if [string length $timevar] {
		upvar $timevar t
		set t $time
	    }
	    return $label
	}
    }
    return {}
}

# list access routes for a user or class
#
# "user" username   -> route modifiers days start end ...
# "class" classname -> route modifiers days start end ...
#
proc boks_getroutes {what name} {
    switch -exact $what {
	user    {set tab USERTIME}
	class   {set tab PROFILEROUTES}
	default {return {}}
    }
    return [boks_read_tab $tab $name "FIELDS=ROUTE MODLIST DAYS START END"]
}

# Set all route definitions for a user or class.
# Uses brute-force replacement of *all* routes ever added using this
# interface.
#
proc boks_setroutes {what name time start stop args} {
    global BOKSTAB BOKSTIMES BOKSROUTES

    switch -exact $what {
	user    {set tab $BOKSTAB(USERTIME)}
	class   {set tab $BOKSTAB(PROFILEROUTES)}
	default {return 0}
    }
    set starthour [expr $start / 3600]
    set stophour [expr $stop / 3600]
    foreach label $args {
	foreach {main mod} [split $label _] {}
	switch -exact $mod {
	    never {
		continue
	    }
	    logonly {
		set mod "logonly,"
	    }
	    default {
		set mod ""
	    }
	}
	foreach {days dummystart dummyend} $BOKSTIMES($time) {}
	foreach route $BOKSROUTES($label) {
	    @ callboks master write o TAB=$tab KEY=$name NEW=1 \
		    "NEWFIELDS=ROUTE MODLIST DAYS START END" \
		    +ROUTE=$route +DAYS=$days +START=$start +END=$stop 
	}
    }
}

#----------------------------------------------------------------------
# Configure a new set of default permissions for one of the
# predefined user classes
#
proc boks_set_predefined_class_routes {class su login rexec {anytime 1}} {
    global BOKS_PREDEFINED_USER_CLASSES


    # Filter routes
    #
    array set routes "su_$su 1 login_$login 1 rexec_$rexec 1"
    set plist $BOKS_PREDEFINED_USER_CLASSES($class)
    foreach {op r} $plist {
	switch -- $op {
	    + {
		set routes($r) 1
	    }
	    - {
		catch {unset routes($r)}
	    }
	    = {
		catch {unset routes}
		foreach r $plist {
		    set routes($r) 1
		}
		unset routes(=)
		break
	    }
	}
    }
    if !$anytime {
	# get routes for this class, to get the times
	set o(0) 0
	boks_helpfuncs_getrouteinfo class $class o
	unset o(0)
    }
    if { $anytime || ([info exists o(NOROUTES)] && $o(NOROUTES)) } {
	set list [list $class anytime 0 86400]
    } else {
	set list [list $class $o(days_val) $o(start_val) $o(stop_val)]
    }
    foreach su {logonly root user} {
	if [info exists routes(su_$su)] {
	    lappend list su_$su
	    break
	}
    }
    foreach login {logonly world trusted known local} {
	if [info exists routes(login_$login)] {
	    lappend list login_$login
	    break
	}
    }
    foreach rexec {logonly world trusted known} {
	if [info exists routes(rexec_$rexec)] {
	    lappend list rexec_$rexec
	    break
	}
    }
    foreach telnet {ssodt} {
	if [info exists routes(telnet_$telnet)] {
	    lappend list telnet_$telnet
	    break
	}
    }
	
    @ eval boks_setroutes class $list
    return ${?}
}

# boks_route_list <what> <name> <show> <value>
#
#	List all access routes for the class/user <name>.
#
#	<what> should be "class" or "user".  The two out-varibles
#	<show> and <value> are arrays with a common index consisting
#	of numbered tags.  The contents of the array <show> are
#	lines suitable to display in a listbox.  The contents of the
#	array <value> are lines with the parameters of the access
#	route separated by space (the params are: route days from to flag,
#	where flag is "locked" for locked routes, and "" for normal routes).
#
#	The return value is a list of the contents of the array
#	<show>.
#
proc boks_route_list { what name _show _value } {
    switch -exact $what {
	user    {set tab USERTIME}
	class   {set tab PROFILEROUTES}
	default {return {}}
    }
    upvar 1 $_show show
    upvar 1 $_value value

    set l {}
    set tagNo 0
    foreach {r m d s e} [boks_read_tab $tab $name \
	    "FIELDS=ROUTE MODLIST DAYS START END"] {
	set tag tag[incr tagNo]
	if [regexp {.*locked.*} $m] {
	    set Neg "- "
	    set flg locked
	} else {
	    set Neg ""
	    set flg ""
	}
	set pretty [format {%s%s, From: %s to: %s, Days: %s} \
		$Neg $r [expr $s/3600] [expr $e/3600] \
		[boks_days_2_text $d]]
	set value($tag) [concat $r $d $s $e $flg]
	set show($tag) $pretty
	lappend l $pretty
    }
    return $l
}

# used in function below
#
set bhf_time_list  {
	3600   hour_1
	7200   hour_2
	10800  hour_3
	14400  hour_4
	18000  hour_5
	21600  hour_6
	25200  hour_7
	28800  hour_8
	32400  hour_9
	36000  hour_10
	39600  hour_11
	43200  hour_12
	46800  hour_13
	50400  hour_14
	54000  hour_15
	57600  hour_16
	61200  hour_17
	64800  hour_18
	68400  hour_19
	72000  hour_20
	75600  hour_21
	79200  hour_22
	82800  hour_23
}

# these could be found from [array names BOKSROUTES]
# but the ordering varies in that case...
#
set bhf_login_list {
    never
    local
    trusted
    known
    world
    logonly
}

set bhf_su_list {
    never
    user
    root
    logonly
}

set bhf_rexec_list {
    never
    trusted
    known
    world
    logonly
}

# Get a list of label time label time ... for a user or class,
# optionally storing the time (should be the same for all routes)
# in one variable, and the number of unknown routes in another.
#
proc boks_getroutelabels {what name {timevar {}} {extravar {}}} {
    if [string length $timevar] {
	upvar $timevar t
    }
    if [string length $extravar] {
	upvar $extravar e
    }
    set e 0
    foreach {r modlist d s e} [boks_getroutes $what $name] {
	set m [routelabel $modlist t]
	if [string length $m] {
	    set a($m) $t
	} else {
	    incr e
	}
    }
    return [array names a]
}

# boks_helpfunc_getrouteinfo what name outarr
#
# Help function to get info needed to set up access info
# in gui
# what i user class or default
# name is username classname or dummy
# outarr is output and contains the following
# outarr(start)   list of time info accepted by GUI
# outarr(start_val) current value
# outarr(stop)    list of time info accepted by GUI
# outarr(sto_val) current value
# outarr(days)    list of days login is possible (GUI)
# outarr(days_val) current value
# outarr(login)   login access routes for GUI
# outarr(login_val) current value
# outarr(su)      su access routes for GUI
# outarr(su_val) current value
# outarr(rexec)   rexec (network NI) access routes for GUI
# outarr(rexec_val) current value
#
# outarr(NOROUTES) is 1 if no previosly defined sunboks routes were found
#    0 if they existed.
#
# return 0 on ok, 1 on error
#
proc boks_helpfuncs_getrouteinfo {what name outarr} {
    global bhf_time_list bhf_login_list bhf_su_list bhf_rexec_list
    upvar $outarr ret

    set list(login) $bhf_login_list
    set list(su)    $bhf_su_list
    set list(rexec) $bhf_rexec_list

    if ![string compare $what default] {
	set ret(days)  {workhours days_workdays anytime days_anyday}
	set ret(days_val) workhours
	set ret(start) [concat 0 hour_0 $bhf_time_list]
	set ret(start_val) 0
	set ret(stop)  [concat $bhf_time_list 86400 hour_24]
	set ret(stop_val) 86400
	foreach n {login su rexec} {
	    set ret($n) {}
	    set ret(${n}_val) ${n}_never
	    foreach l $list($n) {
		lappend ret($n) ${n}_$l
		lappend ret($n) ${n}_${l}_acc
	    }
	}
    } else {
	set labs [boks_getroutelabels $what $name t]
	set d workhours
	set s 0
	set e 24
	set ret(NOROUTES) 0
	if [info exists t] {
	    foreach {d s e} [split $t _] {}
	    set ret(NOROUTES) 1
	}
	set ret(start) [concat 0 hour_0 $bhf_time_list]
	set ret(start_val) [expr $s * 3600]
	set ret(stop) [concat $bhf_time_list 86400 hour_24]
	set ret(stop_val) [expr $e * 3600]
	set ret(days) {workhours days_workdays anytime days_anyday}
	if {[string compare $d workhours] == 0} {
	    set ret(days_val) workhours
	} else {
	    set ret(days_val) anytime
	}
	foreach n {login su rexec} {
	    set ret($n) {}
	    set ret(${n}_val) ${n}_never
	    foreach l $list($n) {
		lappend ret($n) ${n}_$l
		lappend ret($n) ${n}_${l}_acc
	    }
	}
	foreach l $labs {
	    foreach {name sec} [split $l _] {}
	    set ret(${name}_val) $l
	}
    }
    return 0
}

