
# boks_uadm_get_group_list [-names] [-map] [host[:user]] [maparray]
#
# return a list of gids as numbers (or symbolic if -names given)
# from host identified by host or user.
# sorted.
#
# With -map and a maparray, 2-way mappings are stored in the array
# (e.g. map(0) = root, map(root) = 0)
#
proc boks_uadm_get_group_list { args } {
    set optind 0
    set op -gids
    set domap 0
    array set off {-names 0 -gids 2 r-names 2 r-gids 0}

    foreach arg $args {
	switch -glob -- $arg {
	    --		{ break }
	    -names	{ set op -names }
	    -map	{ incr domap }
	    -*		{ return }
	    *		{ break }
	}
	incr optind
    }
    set args [lrange $args $optind end]
    set host [lindex [split [lindex $args 0] :] 0]
    if $domap {
	upvar [lindex $args 1] map
    }

    if { [lsearch [boks_listhosts -nogroups] $host] == -1 } {
	if { [llength [boks_hostadm_list_hostgroup_members $host]] < 1 } {
	    #
	    # OK, no matching host, and host group empty or non existent.
	    # Take groups from the master!
	    #
	    set host [boks_master_name]
	}
    }
    if {[string length $host] && [string compare [boks_master_name] $host]} {
	call_clntd read o $host 0 FILE=group
	set list {}
	if ![info exists o(DATA)] { return }
	foreach line [split $o(DATA) "\n"] {
	    set l [split $line :]
	    set g [lindex $l $off($op)]
	    lappend list $g
	    if $domap {
		set x [lindex $l $off(r$op)]
		set map($g) $x
		set map($x) $g
	    }
	}
    } else {
	set list [groups $op]
	if $domap {
	    if $off($op) {
		set fun getgrgid
	    } else {
		set fun getgrnam
	    }
	    foreach g $list {
		set x [$fun -nocomplain -- $g]
		set map($g) $x
		set map($x) $g
	    }
	}
    }

    set ret {}
    set prev {}
    foreach grp [lsort $list] {
	if [string compare $prev $grp] {
	    lappend ret $grp
	}
	set prev $grp
    }
    return $ret
}


# Try to map a group name to a gid, possibly on another machine
#
proc boks_group2gid {group host} {
    if [regexp {^[0-9]+$} $group] { return $group }
    boks_uadm_get_group_list -map $host map
    if [info exists map($group)] {
	return $map($group)
    }
    return -1
}

