#
# End of pp pre-processing

# Get user data from passwd/whatever.
# Name can be a HOST:name
#
proc boks_getpwnam {name {host {}}} {
    if [string match *:* $name] {
	if ![string length $host ] {
	    set host [lindex [split $name :] 0]
	}
	set name [lindex [split $name :] 1]
    }
    if [string length $host] {
	# Pity there is no remote interface to getpwnam() :-)
	call_clntd read o $host 0 FILE=passwd 
	if [info exists o(DATA)] {
	    foreach line [split $o(DATA) "\n"] {
		set list [split $line :]
		if ![string compare [lindex $list 0] $name] {
		    return $list
		}
	    }
	}
    } else {
	return [getpwnam -nocomplain -data $name]
    }
}

# Proc to create user.
# All arguments to proc should be validated at an higher level.
# Figure out physical homedir. todo

proc boks_uadm_create_user { User Group Comment Uid HomeDir \
	Shell {Class ""} {Psw ""} } {
    
    #Set program to use modbks/mkbks
    if [boks_user_exist $User] {
	set prog modbks
    } else {
	set prog mkbks
    }
    set argv $prog
    lappend argv -l$User
    if [string length $Class] {
	lappend argv -P$Class
    }
    lappend argv "-g[boks_group2gid $Group $User]"
    if [string length $Comment] {
	lappend argv "-r$Comment"
    }
    lappend argv "-u$Uid"
    if [string length $HomeDir] {
	lappend argv "-h$HomeDir"
    }
    if [string length $Shell] {
	lappend argv "-s$Shell"
    }
    if [string length $Psw] {
	lappend argv "-p$Psw"
    }
    eval @ boks_exec $argv
    return ${?}
}

# helpfunction used in forms/user/mod.form to create a user.
#
# Note. last part of code is basically same as boks_uadm_moduser below.
# Maybe they can be put in one function...
#
# FIXME uuid (unique user identifier) is not used now
#
# An empty string in "days" inhibits creation of access routes (used by DSM).
#
proc boks_uadm_adduser {user psw uid group realname homedir shell \
		expires create_homedir class days start stop login su \
		rexec action_timeout timeout is_admin block_user uuid} {
    global BOKSTAB

    set is_in_userclass [expr [string compare $class "-"] != 0]
    if $is_in_userclass {
	if [boks_uadm_create_user $user $group $realname \
		$uid $homedir $shell $class] {
	    return 0
	}
    } else {
	if [boks_uadm_create_user $user $group $realname \
		$uid $homedir $shell] {
	    return 0
	}
	# For DSM, $days is the null string, for SSM it isn't
	#
	if [string length $days] {
	    boks_setroutes user $user $days $start $stop $login $su $rexec
	    set tmp "$days#$start#$stop#$login#$su#$rexec"
	    boks_uadm_log_entry $user USER_ROUTE $tmp
	}
    }
    if $create_homedir {
	@ boks_exec mkhome -l $user -H ""
    }
    if $block_user {
	boks_helpfuncs_set_user_flags $user BLOCKED 1
    }
    if [string compare $action_timeout lock] {
	boks_helpfuncs_set_user_flags $user TLOCK 0
	boks_uadm_log_entry $user NO_TLOCK
    } else {
	boks_helpfuncs_set_user_flags $user TLOCK 1
	boks_uadm_log_entry $user TLOCK
    }
    boks_uadm_get_user_data $user udata

    if ![info exists udata(UID)] {
	return 0
    }
    # set timeout and expire here, but only if != what exists
    if [boks_helpfuncs_user_param_isset $user TIMEOUT] {
	if { $udata(TIMEOUT) == -1 } {
	    set tmout -1
	} elseif { $udata(TIMEOUT) <= 600 } {
	    set tmout 10
	} elseif { $udata(TIMEOUT) <= 1800 } {
	    set tmout 30
	} else {
	    set tmout 60
	}
    } else {
	set tmout def
    }
    if [string compare $timeout $tmout] {
	if ![string compare $timeout def] {
	    boks_helpfuncs_set_user_parammask $user TIMEOUT 0
	} else {
	    set t [expr $timeout * 60]
	    if { $timeout == -1 } {
		set t -1
	    }
	    boks_uadm_set_user_data $user TIMEOUT $t
	}
    }


    # Check if expire date has changed. Only bother if more than 24 h away from
    # old val (implicit rounding happens due to reformatting with %x)
    set etime [expr $udata(USERLASTCHANGE) + $udata(LOGINVALIDTIME)]
    set netime [strptime $expires %x]
    set diff [expr $netime - $etime]
    if {$diff > 86400 || $diff < -86400} {
	set ltime [expr $netime - $udata(USERLASTCHANGE)]
        if {$ltime >= 0} {
	    boks_uadm_set_user_data $user LOGINVALIDTIME $ltime
	}
    }

    if [string length $psw] {
	boks_uadm_change_user_psw -force $user $psw
    } else {
	boks_addusermap $user
    }
    boks_uadm_set_admin_status $user $is_admin
    foreach xuuid $uuid {
	if [string length $xuuid] {
	    @ callboks master write o TAB=$BOKSTAB(CERT2USERMAP) KEY=$xuuid \
		NEWFIELDS=USER +USER=$user
	}
    }


    foreach {h u} [split $user ':'] {}
    set arglist ""
    lappend arglist "-h" "$h" "-n" "$u" "-r" "$realname" "-u" "$uid" \
	    "-g" "[boks_group2gid $group $user]" "-d" "$homedir"
    if $is_admin {
	lappend arglist "-a"
    }
    if $create_homedir {
	lappend arglist "-c"
    }
    if [string length $psw] {
	lappend arglist -p
    }

    if [string length $psw] {
	boks_run_extra_script USERADD $arglist $psw
    } else {
	boks_run_extra_script USERADD $arglist
    }
    return 1
}

# Help function called from forms/user/mod.form for modify user operation
# after all validity checks are done.
#
# Note last part of code is basically same as in boks_uadm_adduser
#
# An empty string in "days" inhibits creation of access routes (used by DSM).
#
proc boks_uadm_moduser {udata_var user psw uid group realname homedir shell \
		expires create_homedir class days start stop login su \
		rexec action_timeout timeout is_admin block_user unblock_user \
		user_uuid} {
    set F "boks_uadm_moduser"

    global BOKSTAB
    upvar $udata_var udata
    set accessroute_mod none
    set addmap 0

    set is_in_userclass [expr [string compare $class "-"] != 0]
    if $unblock_user {
	set user_blocked_reason [boks_helpfuncs_user_blocked udata]
	if { [lsearch -exact $user_blocked_reason blocked] != -1 } {
	    boks_helpfuncs_set_user_flags $user BLOCKED 0
	}
	if { [lsearch -exact $user_blocked_reason login_fail] != -1 } {
	    boks_uadm_set_user_data $user RETRY 0
	}
	# psw stuff is taken care of below since admin has set psw
	set addmap 1
    }
    if $block_user {
	# if he sets both unblock and block, so be it.
	boks_helpfuncs_set_user_flags $user BLOCKED 1
	set addmap 1
    }
	
    # uid, group, shell, userclass, access routes including time
    set change_list {}
    if { $uid != $udata(UID) } {
	lappend change_list UID $uid
	set addmap 1
    }
    if [string compare $realname $udata(REALNAME)] {
	lappend change_list REALNAME $realname
	set addmap 1
    }	    
    if [string compare $shell $udata(SHELL)] {
	lappend change_list SHELL $shell
	set addmap 1
    }	    
    set gid [boks_group2gid $group $user]
    if { $gid != $udata(GID) } {
	lappend change_list GID $gid
	set addmap 1
    }

    set inuclass [expr [string length $udata(PROFILE)] != 0]
    if $inuclass {
	boks_helpfuncs_getrouteinfo class $udata(PROFILE) outinfo
    } else {
	boks_helpfuncs_getrouteinfo user $user outinfo
    }
    set old_days     $outinfo(days_val)
    set old_start    $outinfo(start_val)
    set old_stop     $outinfo(stop_val)
    set old_login    $outinfo(login_val)
    set old_su       $outinfo(su_val)
    set old_rexec    $outinfo(rexec_val)

    if { $is_in_userclass != $inuclass } {
	if $is_in_userclass {
	    # add to userclass
	    lappend change_list PROFILE $class
	    # remember to remove any personal admin acc routes
	    set accessroute_mod remove
	} else {
	    # remove
	    lappend change_list PROFILE {}
	    # remember to add personal admin acc routes
	    set accessroute_mod add
	}
    } elseif { $is_in_userclass && [string compare $class $udata(PROFILE)] } {
	# changed userclass
	lappend change_list PROFILE $class
    } elseif !$is_in_userclass {
	# Check if routes have changed
	if { $login != $old_login || $su != $old_su || $rexec != $old_rexec \
		|| $days != $old_days || $start != $old_start \
		|| $stop != $old_stop } {
	    set accessroute_mod change
	}
    }

    if [string compare $udata(HOMEDIR) $homedir] {
	lappend change_list HOMEDIR $homedir
	set addmap 1
    }

    eval boks_uadm_set_user_data $user $change_list

    # If $days is empty, then do nothing
    #
    if {[string length $days] && [string compare $accessroute_mod none]} {
	if ![string compare $accessroute_mod add] {
	    boks_setroutes user $user $days $start $stop $login $su $rexec
	    set tmp "$days#$start#$stop#$login#$su#$rexec"
	    boks_uadm_log_entry $user USER_ROUTE $tmp
	} elseif ![string compare $accessroute_mod remove] {
	    boks_setroutes user $user $days $start $stop \
		    login_never su_never rexec_never
	    set tmp "$days#$start#$stop#login_never#su_never#rexec_never"
	    boks_uadm_log_entry $user USER_ROUTE $tmp
	} elseif ![string compare $accessroute_mod change] {
	    boks_setroutes user $user $days $start $stop $login $su $rexec
	    set tmp "$days#$start#$stop#$login#$su#$rexec"
	    boks_uadm_log_entry $user USER_ROUTE $tmp
	}
    }
    if $create_homedir {
	@ boks_exec mkhome -l $user -H ""
    }
    # tlock?
    set tlock [boks_helpfuncs_user_flag_isset $user TLOCK]
    if { $tlock && [string compare $action_timeout logout] == 0 } {
	boks_helpfuncs_set_user_flags $user TLOCK 0
	boks_uadm_log_entry $user NO_TLOCK
    } elseif { !$tlock && [string compare $action_timeout logout] != 0 } {
	boks_helpfuncs_set_user_flags $user TLOCK 1
	boks_uadm_log_entry $user TLOCK
    }
	
    # set timeout and expire here, but only if != what exists
    if [boks_helpfuncs_user_param_isset $user TIMEOUT] {
	if { $udata(TIMEOUT) == -1 } {
	    set tmout -1
	} elseif { $udata(TIMEOUT) <= 600 } {
	    set tmout 10
	} elseif { $udata(TIMEOUT) <= 1800 } {
	    set tmout 30
	} else {
	    set tmout 60
	}
    } else {
	set tmout def
    }
    if [string compare $timeout $tmout] {
	if ![string compare $timeout def] {
	    boks_helpfuncs_set_user_parammask $user TIMEOUT 0
	} else {
	    set t [expr $timeout * 60]
	    if { $timeout == -1 } {
		set t -1
	    }
	    boks_uadm_set_user_data $user TIMEOUT $t
	}
    }

    # Check if expire date has changed. Only bother if more than 24 h avay from
    # old val (implicit rounding happens due to reformatting with %x)
    set etime [expr $udata(USERLASTCHANGE) + $udata(LOGINVALIDTIME)]
    set netime [strptime $expires %x]
    set diff [expr $netime - $etime]
    if {$diff > 86400 || $diff < -86400} {
	set ltime [expr $netime - $udata(USERLASTCHANGE)]
        if {$ltime >= 0} {
	    boks_uadm_set_user_data $user LOGINVALIDTIME $ltime
	    set addmap 1
	}
    }

    if [string length $psw] {
	boks_uadm_change_user_psw -force $user $psw
	set addmap 0
    }

    if $addmap {
	boks_addusermap $user
    }

    boks_uadm_set_admin_status $user $is_admin
    debug 5 "$F Doing the read, KEY=$user"
    @ callboks master read o TAB=$BOKSTAB(CERT2USERMAP) KEY=$user \
	    KEYFIELD=USER FIELDS=UUID
    set existing_uuid ""

    if {!${?} && [info exists o(DATA)]} {
	set existing_uuid $o(DATA)
    }
    
    foreach uuid $existing_uuid {
	if [string length $uuid] {
	    if {[lsearch -exact $user_uuid $uuid] == -1} {
		debug  5 "$F Trying to delete, KEY=$uuid"
		@ callboks master delete o TAB=$BOKSTAB(CERT2USERMAP) KEY=$uuid
	    }
	}
    }

    foreach xuuid $user_uuid {
	if [string length $xuuid] {
	    if {[lsearch -exact $existing_uuid $xuuid] == -1} {
		debug 5 "$F Adding new element, KEY=$xuuid"
		@ callboks master write o TAB=$BOKSTAB(CERT2USERMAP) KEY=$xuuid \
		    NEWFIELDS=USER +USER=$user
	    }
	}
    }

    foreach {h u} [split $user ':'] {}
    set arglist ""
    lappend arglist "-h" "$h" "-n" "$u" "-r" "$realname" \
	    "-u" "$uid" "-g" "$gid" "-d" "$homedir"
    if $is_admin {
	lappend arglist "-a"
    }
    if $create_homedir {
	lappend arglist "-c"
    }
    if [string length $psw] {
	lappend arglist -p
    }


    if [string length $psw] {
	boks_run_extra_script USERMOD $arglist $psw
    } else {
	boks_run_extra_script USERMOD $arglist
    }
    return 1
}

# boks_uadm_set_user_data user field data ...
#
# Set fields in TAB_USER.
# If a field is one involving PARAMETERMASK, PARAMETERMASK
# will be set to reflect that the data is now in TAB_USER
#
proc boks_uadm_set_user_data { user args } {
    global BOKS_FLAGS BOKSTAB
    set mask_affected 0
    if [expr [llength $args] % 2] {
	return 1
    }
    set parammask [boks_read_tab USER $user FIELDS=PARAMETERMASK]
    if ![llength $parammask] {
	return 1
    }
    set fields {}
    set list {}
    foreach {field val} $args {
	if [info exists BOKS_FLAGS(PARAMMASK,$field)] {
	    set parammask [expr $parammask | $BOKS_FLAGS(PARAMMASK,$field)]
	    set mask_affected 1
	}
	lappend fields $field
	lappend list "+${field}=$val"
	boks_uadm_log_entry $user $field $val
    }
    if $mask_affected {
	lappend fields PARAMETERMASK
	lappend list +PARAMETERMASK=$parammask
    }
    lappend list TAB=$BOKSTAB(USER) NEWFIELDS=$fields KEY=$user
    eval @ callboks master write o $list
    return ${?}
}

# boks_uadm_get_user_data [-level level] user outarr
#
# get all data for user currently in TAB_USER 
# and put in outarr. outarr is then indexed with field name
# from dbdef.boks. NOTE! Fields that are common to TAB_SYS and
# TAB_PROFILE will be taken from the one it is set in according
# to PARAMETERMASK (so you are not guaranteed to get data from TAB_USER
# only!).
# level is not currently used, but can be a number that gives
# more info for higher numbers (presumably from other user related tables)
# return 0 on success, 1 on user does not exist != 0 on other errors

proc boks_uadm_get_user_data { args } {
    global BOKSTAB BOKS_FLAGS
    set level 1

    set next 0
    set flag 1
    set len [llength $args]
    set i 0
    while { $flag && $i < $len } {
	set arg [lindex $args $i]
	if $next {
	    set $name $arg
	    set next 0
	} else {
	    switch -glob -- $arg {
		-level { incr next; set name level }
		-- { set flag 0 }
		-* { return 1 }
		* { set flag 0 }
	    }
	}
	if $flag {
	    incr i
        }
    }


    set arglist [lrange $args $i end]

    if { [llength $arglist] != 2 } {
	return 1
    }

    set user [lindex $arglist 0]
    set var [lindex $arglist 1]
    upvar $var outarr

    @ callboks master read out TAB=$BOKSTAB(USER) KEY=$user FIELDS=*
    if { ${?} != 0 || ![info exists out(DATA)] || [llength $out(DATA)] == 0 } {
	return 1
    }
    set uclass [lindex $out(DATA) [lsearch -exact $out(FIELDS) PROFILE]]

    # defaults from TAB_SYS
    set fields [boks_helpfunc_matchlist -remove PARAMMASK, \
	    [array names BOKS_FLAGS]]
    @ callboks master read tmp TAB=$BOKSTAB(SYS) KEY=00 FIELDS=$fields
    if { ${?} != 0 || ![info exists tmp(DATA)] || [llength $tmp(DATA)] == 0 } {
	return 1
    }
    foreach field $fields val $tmp(DATA) {
	set outarr($field) $val
    }

    # Some may be from TAB_PROFILE
    if [llength $uclass] {
	@ callboks master read tmp TAB=$BOKSTAB(PROFILE) KEY=$uclass \
		FIELDS=[concat $fields PARAMETERMASK]
	if { ${?} != 0 || ![info exists tmp(DATA)] || \
		[llength $tmp(DATA)] == 0 } {
	    return 1
	}
	set parammask [lindex $tmp(DATA) end]
	foreach field $fields val $tmp(DATA) {
	    if {[info exists BOKS_FLAGS(PARAMMASK,$field)] && \
		    [expr $parammask & $BOKS_FLAGS(PARAMMASK,$field)]} {
		set outarr($field) $val
	    }
	}
    }

    set parammask [lindex $out(DATA) \
	    [lsearch -exact $out(FIELDS) PARAMETERMASK]]

    foreach field $out(FIELDS) val $out(DATA) {
	if [info exists BOKS_FLAGS(PARAMMASK,$field)] {
	    if [expr $parammask & $BOKS_FLAGS(PARAMMASK,$field)] {
		set outarr($field) $val
	    }
	} else {
	    set outarr($field) $val
	}
    }
    # serno
    set outarr(UUID) ""
    @ callboks master read out TAB=$BOKSTAB(CERT2USERMAP) KEY=$user \
		KEYFIELD=USER FIELDS=UUID
    if {!${?} && [info exists out(DATA)]} {
	set outarr(UUID) $out(DATA)
    }
    return 0
}

# Delete all users in $users, check against list of users
# that are not allowed to be removed. currently all root users
# Also delete users homedir if delete_home is set
#
proc boks_helpfuncs_del_users {users {delete_home 0}} {
    set List {}
    foreach user $users {
	if ![string match *:root $user] {
	    lappend List $user
	}
    }
    if [string length $List] {
	if $delete_home {
	    foreach u $List {
		boks_helpfuncs_rm_userhome $u
	    }
	}
	foreach u $List {
	    set arg ""
	    set hu [split $u :]
	    lappend arg -h [lindex $hu 0] -n [lindex $hu 1]
	    if $delete_home {
		lappend arg -d
	    }
	    if [boks_subadm_is_subadm $u] {
		boks_subadm_delete $u
	    }
	    boks_run_extra_script USERDEL $arg
	    boks_uadm_set_admin_status $u 0
	}
	eval @ boks_exec rmbks $List
    }
    return $List
}

# interface routine to get a new uniq uid.
#
proc boks_uadm_newuid {} {
    @ callboks master newuid out
    return $out(DATA)
}

# Get frost shell from /etc/shells if it exists, 
# return /bin/sh otherwise
#
proc boks_uadm_get_default_shell {} {
    set line "/bin/sh"
    if { [catch {set fp [open /etc/shells r]}] == 0 } {
	gets $fp line
	close $fp
    }
    return $line
}

proc boks_uadm_get_default_homeprefix {{host {}}} {
    if ![string length $host] {
	set host [boks_master_name]
    }
    return [boks_read_tab HOST $host FIELDS=HOMEPREFIX]
}

proc boks_home2realhome { home } {
    if ![string match /* $home] {
	set host [boks_master_name]
	set hpref [boks_read_tab HOST $host FIELDS=HOMEPREFIX]
	set fhost [boks_read_tab HOST $host FIELDS=FILEHOST]
	if [string compare $fhost $host] {
	    return ""
	}
	set fhdir [boks_read_tab HOST $host FIELDS=FILEHOSTDIR]
	if [string length $fhdir] {
	   set home [file join $fhdir $home]
	} elseif [string length $hpref] {
	    set home [file join $hpref $home]
	}
    }
    return $home
}

# check if uid exists
#
# return 1 if exists
#        0 if not (and on errors unfortunately)
#
proc boks_helpfuncs_uid_exists { uid } {
    global BOKSTAB

    @ callboks master read out TAB=$BOKSTAB(USER) FIELDS=UID
    if { [info exists out(DATA)] && [lsearch -exact $out(DATA) $uid] != -1 } {
	return 1
    }
    return 0
}

# Similar function to "boks_uadm_get_user_data", but without
# accessing auxillary info (such as access routes).
#
# Return value is a list of "name value name value ...", suitable
# to do an array set with (in which case the names will be indices).

proc boks_user_data_get { user } {
    global BOKSTAB BOKS_FLAGS

    @ callboks master read out TAB=$BOKSTAB(USER) KEY=$user FIELDS=*
    if { ${?} != 0 || ![info exists out(DATA)] || [llength $out(DATA)] == 0 } {
	return 0
    }
    set l {}
    foreach n $out(FIELDS) v $out(DATA) {
	lappend l $n $v
    }
    return $l
}

#----------------------------------------------------------------------
# Check that a username is legal, optionally prefixed with
# a host.
#
# RETURNS: a proper BoKS logname (host:user), or an empty
# string on error.
# If the name does not have a host-prefix, then the host
# parameter is used to add this prefix.  If no "host" parameter
# is specified, or if it is empty, then the global variable
# "boks_localhost" is used.
#
# NOTE: A specified "host" parameter takes precedence over
#	a host-prefix to the username.  This means that any
#	host-prefix will be replaced by any specified "host"
#	parameter.
#
# FIXME: Is this usage of boks_check_hostname OK?  Should we
#	be that restrictive? /PF
#
proc boks_checkusername {user {host {}}} {
    global boks_localhost

    set u $user
    if [regexp {^([^:]+):([^:]+)$} $user m h u] {
	if ![boks_check_hostname $h] {
	    return {}
	}
	if [string match "" $host] {
	    set host $h
	}
    } else {
	if [string match "" $host] {
	    set host $boks_localhost
	}
    }
    # Now "host" and "u" are set.
    # Check that they are reasonable.
    #
    if [string match "" $host] {
	return {}
    }
    if ![regexp {^[a-zA-Z0-9_-]+$} $u] {
	return {}
    }
    return $host:$u
}

