
proc init_keypkg_adm {} {
    global env
    if ![info exists env(SSO_CRED_ROOT)] {
	set env(SSO_CRED_ROOT) [boksdir data]/sso_creds
    }
    set env(DSC_CRED_DIR)    $env(SSO_CRED_ROOT)/user_creds
    set env(DSC_CA_CRED_DIR) $env(SSO_CRED_ROOT)/ca_creds
    set env(DSC_KEYS_DIR)    $env(SSO_CRED_ROOT)/keys
}

# FIXME: What does @message do?  Will it be spoiled by the new proc?
#
proc PROT_ALGID {} {

    
    
    return "3"

}

#
# As [boksdir...] but for keypkgs.
#
proc creddir {type args} {
    global env

    if {$type == "USER"} {
	set dir $env(DSC_CRED_DIR)
    } elseif {$type == "CA"} {
	set dir $env(DSC_CA_CRED_DIR)
    } elseif {$type == "KEYS"} {
	set dir $env(DSC_KEYS_DIR)
    } else {
	error "No such type:$type"
    }

    if ![string match {} $args] {
	return $dir/$args
    } else {
	return $dir
    }
}

# Read from file with line of type SE Sweden
# and return as list with elements of same form.
# Use split to get first part.
# Ignores empty lines and lines starting with #
#
proc boks_keypkg_listcountries {} {
    @ boks_priv {open [boksdir etc]/countrylist r}
    if ${?} {
	return {US "United States" SE Sweden}
    }
    set fp ${@}
    set ret {}
    while {[gets $fp line] != -1} {
	if [string match #* $line] {
	    continue
	}
	set line [string trim $line]
	if ![string length $line] {
	    continue
	}
	lappend ret [lindex $line 0] [lrange $line 1 end]
    }
    close $fp
    return $ret
}

# lifespan list
# Read from file, format #days label, e.g. 365 1year
# Label must be defined in message file for this to work nicely
# So if customer updates file, he must edit message file
# Everything is returned as one list to be used in MENUBUTTON
# Ignores empty lines and lines starting with #
#
proc boks_keypkg_listlifespan {} {
    @ boks_priv {open [boksdir etc]/lifespans r}
    if ${?} {
	# default
	return {30 gen_onemonth 90 gen_threemonths\
		365 gen_oneyear 730 gen_twoyears 1825 gen_fiveyears}
    }
    set fp ${@}
    set ret {}
    while {[gets $fp line] != -1} {
	if [string match #* $line] {
	    continue
	}
	if ![string length [string trim $line]] {
	    continue
	}
	if {[llength $line] != 2} {
	    # error
	    continue
	}
	set ret [concat $ret $line]
    }
    close $fp
    return $ret
}

#----------------------------------------------------------------------
#
# Create a RFC1779 Distinguished Name from it's parts
#
proc boks_keypkg_set_dn {c o ou cn sn title} {
    
    set user_dn ""
    if ![string match "" $c] {
	append user_dn "C=$c;"
    }
    if ![string match "" $o] {
	append user_dn "O=[boks_keypkg_rfc1779_prot $o];"
    }
    if ![string match "" $ou] {
	append user_dn "OU=[boks_keypkg_rfc1779_prot $ou];"
    }
    if ![string match "" $cn] {
	append user_dn "CN=[boks_keypkg_rfc1779_prot $cn]"
    }
    if ![string match "" $sn] {
	append user_dn ";SN=[boks_keypkg_rfc1779_prot $sn]"
    }
    if ![string match "" $title] {
	append user_dn ";T=$title"
    }

    return $user_dn
}

#
# Protect the most important RFC1779 chars
#
proc boks_keypkg_rfc1779_prot { rdn } {
    regsub -all {,} $rdn {\,} prot_rdn
    regsub -all {;} $prot_rdn {\;} prot_rdn
    
    return $prot_rdn
}

proc boks_keypkg_get_dname { entity } {
    set F "boks_keypkg_get_dname"

    set result {}
    debug 5 "$F called $entity"

    @ boks_read_tab CERT $entity FIELDS=CERT
    if ${?} {
	debug 5 "$F failed to read CERT"
	boks_keypkg_error "I/O Error: Could not read CERT from dp ($entity)"
    }
    if ![string length ${@}] {
	debug 5 "$F nothing found in db"
	return {}
    }
    set certhandle [cert_decode certificate ${@}]
    debug 9 "$F certhandle $certhandle"
    @ cert_get subject $certhandle
    if ${?} {
	debug 5 "$F cert_get failed"
	@ cert_free $certhandle
	boks_keypkg_error "Could not get subject name from cert ($entity)"
    }
    set result ${@}
    debug 6 "$F result $result"
    @ cert_free $certhandle
    return $result
}

proc boks_keypkg_generate_pin {} {
    @ boks_exec randgen -s -l 6
    if ${?} {
	debug 5 "Randgen:${@}"
	error psd_no_pin_generated
    }
	
    return ${@}
}

# Read a b64-file and compact it
proc boks_keypkg_read_file {name} {
    set f [open $name]
    set s [read $f]
    close $f
    regsub -all \r*\n $s "" s
    return [string trim $s]
}

###########################################################################
#
# Error checking procs
#
###########################################################################

# FIXME: Document this
# generic error routine
#
proc boks_keypkg_error { errmsg } {
    global MSG

    set MSG(keypkgTempLabel) $errmsg
    error keypkgTempLabel
}

proc boks_keypkg_check_dname { country org org_unit name serial type} {

    set no_error 1
    #
    # Check country
    #
    if {[regexp {^[A-Z]+$} $country] == 0} {
	set no_error 0
	error "Illegal characters in Country Name \"$country\""
    } elseif {[string length $country] != 2} {
	set no_error 0
	error "Not an ISO country abbreviation:$country"
    }
    #
    # Check OrganizationName (No space in CA's org already checked in form)
    #
    if ![string compare $org ""] {
	set no_error 0
	error "You have to enter an Organization Name!"
    } elseif {[string first "/" $org] >= 0} {
	set no_error 0
	error "Illegal character \"/\" in Organization Name \"$org\""
    }

    #
    # Check OrganizationUnitName
    #
    if [string compare $org_unit ""] {
	if {[string first "/" $org_unit] >= 0} {
	    set no_error 0
	    error "Illegal character \"/\" in Organizational Unit Name\
		    \"$org_unit\""
	}
    }
    #
    # CommonName (CA's common name may not contain space, but that s checked
    # already in form)
    #
    if ![string compare $name ""] {
	set no_error 0
	error "You have to enter a Full Name!"
    } elseif {[string first "/" $name] >= 0} {
	set no_error 0
	error "Illegal character \"/\" in Full Name \"$name\""
    }

    # Check for generated dname too long.
    boks_keypkg_env -get v
    if {[info exists v(compat)] && $v(compat) == 1} {
	set dn [boks_keypkg_set_dn $country $org $org_unit $name $serial $type]
    } else {
	set dn [boks_keypkg_set_dn $country $org $org_unit $name {} {}]
    }
    @ unset v

    global DNAMEMAX
    if {[string length $dn] >= $DNAMEMAX} {
	set no_error 0
	set max [expr $DNAMEMAX - 1]
	error "Resulting DNAME is longer than maximum allowed ($max)"
    }

    return 1
}

proc boks_keypkg_CLI_code2label {errmsg} {
    global MSG

    set index [string first "\n" ${errmsg}]
    set code [string range ${errmsg} [expr $index + 1] [expr $index + 3]]

    debug 5 "Errmsg:${errmsg}"
    debug 5 "Code:$code"

    if {[regexp {^[45][0-5][0-9]$} $code] == 0} {
	# We really should never get here...
	set MSG(keypkgTempLabel) "Internal error $code"
	return keypkgTempLabel
    }

    switch -glob $code {

	430 {return psd_cli_enomem}

	502 {return psd_cli_einval}

	50? {return psd_cli_einval_internal}

	510 {return psd_cli_epwd}

	513 {return psd_cli_ecapwd}

	51? {return psd_cli_esign}

	54? {set MSG(keypkgTempLabel) "Internal error $code"
	     return keypkgTempLabel }

        55? {set MSG(keypkgTempLabel) "File System or Database error $code"
	     return keypkgTempLabel}

	*   {set MSG(keypkgTempLabel) "Internal error $code"
	     return keypkgTempLabel }
    }
}


#----------------------------------------------------------------------
# FIXME: Document this
#
# Intended to log to cred_list or passwords
#
proc boks_keypkg_log { op file ix args } {

    @ boks_priv {open $file r}

    switch -exact -- $op {

	-del {
	    @ boks_priv {open $file w}
	    if ${?} {
		boks_keypkg_error "I/O Error: Could not open $file for reading"
	    } else {
		set fd ${@}
	    }
	
	    set list [read $fd]
	    close $fd
    
	    regexp "$ix\t\(\[^\n\]*\)\n" $list match f
	    if ![info exists f] {
		boks_keypkg_error "User $ix does not exist!"
	    }

	    regsub "$ix\t\[^\n\]*\n" $list "" new_list
	    @ boks_priv {open $file w}
	    if ${?} {
		boks_keypkg_error \
			"I/O Error: Could not open $file for writing!"
	    } else {
		set fd ${@}
	    }
	    puts -nonewline $fd $new_list
	    close $fd
	}

	-add {

	    if !${?} {
		set fd ${@}
		set list [read $fd]
		close $fd

		regexp "$ix\t\(\[^\n\]*\)\n" $list match f
		if [info exists f] {
		    boks_keypkg_error "User $ix does already exist in $file!"
		} else {
		    set f {}
		}
	    } else {
		set f {}
	    }

	    @ boks_priv {open $file {CREAT APPEND WRONLY}}
	    if ${?} {
		boks_keypkg_error \
			"I/O Error: Could not open $file for writing!"
	    } else {
		set fd ${@}
	    }
	    puts $fd "$ix\t[lindex $args 0]"
	    close $fd
	}

	-log {

	    if ${?} {
		boks_keypkg_error "I/O Error: Could not open $file for reading"
	    } else {
		set fd ${@}
	    }
	    
	    set list [read $fd]
	    close $fd
	    regexp "$ix\t\(\[^\n\]*\)\n" $list match f
	    if ![info exists f] {
		set f {}
	    }
	}
    }

    return $f
}

proc boks_keypkg_get_dnsname {host} {
    set F "boks_keypkg_get_dnsname"
    debug 5 "$F $host"
    set best $host
    set ndots1 [llength [split $best .]]
    if [regexp {^[0-9]+.[0-9]+.[0-9]+.[0-9]+$} $host] {
	# ip-address, try to avoid returning address unless
	# nothing else found
	set ndots1 0
    }

    foreach h [gethostbyaddr -nocomplain $host] {
	debug 5 "$F 2 $h"
	set n [llength [split $h .]]
	if {$n > $ndots1} {
	    set best $h
	    set ndots1 $n
	}
    }
    foreach h [gethostbyaddr -nocomplain -aliases $host] {
	debug 5 "$F 2 $h"
	set n [llength [split $h .]]
	if {$n > $ndots1} {
	    set best $h
	    set ndots1 $n
	}
    }
    if {$ndots1 == 1} {
	# append domain from resolv.conf (if any)
	@ boks_priv "open /etc/resolv.conf r"
	if !${?} {
	    set fp ${@}
	    while {[gets $fp l] != -1} {
		if [regexp {^domain[ 	]+(.*)[ 	]*$} $l dummy domain] {
		    set best $best.$domain
		    break
		}
	    }
	    close $fp
	}
    }
	
    debug 5 "Best:$best"
    return $best
}

# Dump certificate from BoKS DB to file
# return 0 on OK
#
proc boks_keypkg_dump_cert {ca file} {

    debug 5 "Looking for $ca in CERT"
    @ boks_read_tab CERT $ca FIELDS=CERT
    if ${?} {
	return ${?}
    }
    if ![string length ${@}] {
	return 1
    }
    set data ${@}
    @ boks_priv {open $file w}
    if ${?} {
	return 1
    }
    set fp ${@}
    puts $fp "$data"
    close $fp
    return 0
}
# Given ca and type (pe or pcprot), return name of
# the special psd associated with ca if it exists.
# Return empty string on error or does not exist.
#
proc boks_keypkg_ca2special {ca type} {

    if ![string compare $type pe] {
	set t PIN
    } elseif ![string compare $type pcprot] {
	set t PCPROT
    } else {
	return ""
    }

    if ![regsub {;T=CA} $ca ";T=$t" special] {
	set special "$ca;T=$t"
    }

    if ![catch {boks_priv \
	    {exec /bin/test -f [creddir USER keypkgs]/$special.kpg}}] {
        return $special
    }
    return ""
}
