#
# End of pp pre-processing

array set BOKSHOSTTYPE {
    type,2	NONBOKSHOST
    type,5	UNIXBOKSHOST
    type,9	PCBOKSHOST
    type,34     SSOHOST
    label,NONBOKSHOST	2
    label,UNIXBOKSHOST	5
    label,PCBOKSHOST	9
    label,SSOHOST      34
}

array set BOKSHOSTTYPEMAP {
    NONBOKSHOST  nonbokshost
    UNIXBOKSHOST bokshost
    SSOHOST      ssohost
    nonbokshost  NONBOKSHOST
    bokshost     UNIXBOKSHOST
    ssohost      SSOHOST
}

# ------------------------------------------------------------
# Map UNIXBOKSHOST to bokshost and vice versa for the three
# hosttypes we care about for now.
#
proc boks_host_maphosttype {type default} {
    global BOKSHOSTTYPEMAP
    if [info exists BOKSHOSTTYPEMAP($type)] {
	return $BOKSHOSTTYPEMAP($type)
    }
    return $default
}

# Get type of host (in gui format, e.g. bokshost)
#
proc boks_host_getguitype {host {default nonbokshost}} {
    global BOKSHOSTTYPE

    set type [boks_read_tab HOST $host FIELDS=TYPE]
    if [string length $type] {
	if [info exists BOKSHOSTTYPE(type,$type)] {
	    return [boks_host_maphosttype $BOKSHOSTTYPE(type,$type) $default]
	}
    }
    return $default
}

# ------------------------------------------------------------
# Host administration
#
# Many of these procs use external commands -- there was too much
# magic involved (dependencies between tables) to re-invent here,
# at least right now.
#

# Create/Modify a host
#
proc boks_hostadm_add_host {Host Ip {Trusted 0} {Type NONBOKSHOST}} {
    set args [list -h$Host -t$Type]
    if [string length $Ip] {
	lappend args -i$Ip
    } else {
	set Ip [boks_read_tab HOST $Host FIELDS=ADDRESS]
	if [string length $Ip] {
	    lappend args -i$Ip
	}
	# else, hostadm will give error below...
    }
    # Change the type and add new IP-addresses (if applicable)
    set OrigIp [boks_gethostbyname $Host]
    eval @ boks_exec hostadm -a -h$Host -t$Type -i$OrigIp
    eval @ boks_exec hostadm -a $args
    if ${?} {
	return 1
    }
    if $Trusted {
	@ boks_exec hgrpadm -a -m $Host -g TRUSTED
    } else {
	boks_hostadm_rem_trusted $Host
    }
    return 0
}

# Remove a host
#
proc boks_hostadm_rem_host {Host {Ip {}}} {
    if [string length $Ip] {
	@ boks_exec hostadm -d -i$Ip
    } else {
	@ boks_exec hostadm -d -h$Host
    }
    return ${?}
}

# Remove a host from group trusted
#
proc boks_hostadm_rem_trusted {Host} {
    set TAB HOSTGROUP
    set fieldspec "FIELDS=GROUP MEMBER"
    set hlist [boks_read_tab $TAB TRUSTED $fieldspec]
    if [string compare [lsearch $hlist $Host] "-1"] {
       @ boks_exec hgrpadm -r -m $Host -g TRUSTED
    }

}

# Check if a host is trusted
#
proc boks_host_is_trusted {host} {
    set s [boks_read_tab HOSTGROUP $host KEYFIELD=MEMBER FIELDS=GROUP]
    if {[lsearch $s TRUSTED] > -1} {
	return 1
    }
    return 0
}

# List host names in database
#
proc boks_hostadm_list {{hostwild *}} {
    return [boks_read_tab HOST $hostwild]
}

# Get list of trusted hosts
#
proc boks_hostadm_list_trusted {} {
    return [boks_read_tab HOSTGROUP TRUSTED FIELDS=MEMBER]
}

# return true if "group" is a host group
proc boks_is_hostgroup {group} {
    return [string length [boks_read_tab HOSTGROUP $group]]
}

# return true if host has a home prefix defined. If host is a group,
# all members must have prefixes defined.
#
proc boks_has_homeprefix {host} {
    if [boks_is_hostgroup $host] {
	set list [boks_read_tab HOSTGROUP $host FIELDS=MEMBER]
    } else {
	set list $host
    }
    foreach host $list {
	set h {}
	foreach {h p} [boks_read_tab HOST $host "FIELDS=HOST HOMEPREFIX"] {}
	if [string length $h] {
	    if ![string length $p] {
		return 0
	    }
	}
    }
    return 1
}

# Get Host data into an array. Returns the list of names.
# Array contains: name,addrs -> address list
#		  name,type  -> type (see boks.tcl)
#
# ADD MORE RETURNED DATA AS NECESSARY!!!
#
proc boks_hostadm_list_byname {arrayvar {hostwild *}} {
    global BOKSHOSTTYPE
    upvar $arrayvar hosts
    
    catch {unset hosts}
    set fieldspec "FIELDS=NAME TYPE HOMEPREFIX FILEHOST FILEHOSTDIR"
    set hlist [boks_read_tab HOST $hostwild $fieldspec]
    set addrs [boks_read_tab ADDR * "FIELDS=NAME ADDRESS"]
    set list {}
    foreach {n a} $addrs {
	lappend hosts($n,addrs) $a
    }
    foreach {n t hp fh fhd} $hlist {
	lappend list $n
	set hosts($n,type) $BOKSHOSTTYPE(type,$t)
	set hosts($n,homeprefix) $hp
	set hosts($n,filehost) $fh
	set hosts($n,filehostdir) $fhd
    }
    return $list
}

proc boks_hostadm_list_byaddr {arrayvar {addrwild *}} {
    global BOKSHOSTTYPE
    upvar $arrayvar hosts

    catch {unset hosts}
    set addrs [boks_read_tab ADDR $addrwild "FIELDS=NAME ADDRESS"]
    set list {}
    foreach {n a} $addrs {
	if ![info exists hosts($n,type)] {
	    set t [boks_read_tab HOST $n FIELDS=TYPE]
	    set hosts($n,type) $BOKSHOSTTYPE(type,$t)
	}
	lappend hosts($n,addrs) $a
	lappend list $n
    }
    return $list    
}

proc boks_hostadm_host_exist {Host} {
    set fieldspec "FIELDS=NAME"
    set hlist [boks_read_tab HOST $Host $fieldspec]
    return [llength $hlist]
}

# Wrap 'lh' to list all hosts there is
#
proc boks_list_hosts {{flags -a}} {
    set args -l
    if {[string match $flags -a] == 0} {
	lappend args -h
    }
    eval @ boks_exec lh $args
    if ${?} {
	return {}
    }
    return [lsort -ascii ${@}]
}

# List hosts from "source" that do not already exist in the
# BoKS DB. Source can be "local," "svc" or "all" (anything else is
# intepreted as "all". "svc" is short for whatever naming service
# is used (dns/nis), "local" is /etc/hosts.
#
proc boks_hosts_not_imported {source} {
    set hosts {}
    switch -exact $source {
	svc {
	    set local [gethosts_local]
	    set all [boks_list_hosts]
	    foreach h $all {
		if {[lsearch $local $h] < 0} {
		    lappend hosts $h
		}
	    }
	    set importedhosts [boks_hostadm_list]
	    set hosts [listminus $hosts $importedhosts]
	}
	local {
	    set local [lsort -ascii [gethosts_local]]
	    set bokshosts [boks_read_tab HOST *]
	    foreach h $local {
		if {[lsearch $bokshosts $h] < 0} {
		    lappend hosts $h
		}
	    }
	}
	default {
	    set allhosts [boks_list_hosts]
	    set importedhosts [boks_hostadm_list]
	    set hosts [listminus $allhosts $importedhosts]
	}
    }
    return $hosts
}
