#
# End of pp pre-processing
#======================================================================
# Execute program as root
#======================================================================

# list userwild -> user host prog, user host prog ...
#
proc boks_sux_list { what {userwild *}} {
    global BOKSTAB BOKSTIMES

    if [string match class $what] {
	set TAB PROFILEROUTES
    } else {
	set TAB USERTIME
    }

    set list {}
    set fields {USER ROUTE MODLIST}
    set data [boks_read_tab $TAB $userwild "FIELDS=$fields"]
    foreach {user route mod} $data {
	if ![string match *adm#=sux* $mod] continue
	if [regexp {^SUEXEC:.*->([^%]*)%(.*)$} $route m h prog] {
	    if ![regexp {^([^@]*)@(.*)$} $h m u host] {
		continue	;# Should not happen!
	    }
	    lappend list $user $host $prog
	}
    }
    return $list
}

# boks_sux_add <what> <obj> <host> <prog>
#
#    Add execution privileges.
#	what	- "class" or "user".
#	obj	- The name of the user class or user.
#	host	- Host-part in resulting defs.
#	prog	- Program to allow execution for
#
proc boks_sux_add { what obj host prog } {
    global BOKSTAB BOKSTIMES

    foreach {days start stop} $BOKSTIMES(anytime) break

    if [string match class $what] {
	set tab $BOKSTAB(PROFILEROUTES)
    } elseif {[string match user $what]} {
	set tab $BOKSTAB(USERTIME)
    } else {
	puts stderr "boks_sux_add: Error: invalid type=$what"
	return 0
    }

    set route "SUEXEC:*->root@${host}%$prog"

    @ callboks master write o \
	    TAB=$tab KEY=$obj NEW=1 \
	    "NEWFIELDS=ROUTE MODLIST DAYS START END" \
	    +ROUTE=$route +DAYS=$days +START=$start +END=$stop \
	    +MODLIST=adm#=sux
    boks_log -type S -label suexec_add_program "%s %s now has root rights for program %s on %s" $what $obj $prog $host
    return ${?}
}

proc boks_sux_del {what obj host prog} {
    global BOKSTAB
    
    if [string match class $what] {
	set tab $BOKSTAB(PROFILEROUTES)
    } else {
	set tab $BOKSTAB(USERTIME)
    }

    set route "SUEXEC:*->root@${host}%$prog"
    @ callboks master delete o TAB=$tab \
	    KEY=$obj FIELDS=ROUTE "&ROUTE=$route"
    return ${?}
}

