/************************************************************************/
/* Copyright (C) 1997 Open Systems Solutions, Inc.  All rights reserved.*/
/************************************************************************/
/* Abstract syntax: pkcs */
/* Created: Fri May 16 15:51:15 1997 */
/* ASN.1 compiler version: 4.2 */
/* Target operating system: Solaris 2.4 for x86 or later */
/* Target machine type: Intel x86 */
/* C compiler options required: None */
/* ASN.1 compiler options and file names specified:
 * -nowarningmessages -ber -der -compat v4.1typesharing asn1dflt.solarx86
 * if.asn af.asn keypkg.asn pkcs.asn
 */

#ifndef OSS_pkcs
#define OSS_pkcs

#include "ossship.h"

#define          ski_name_PDU 1
#define          ski_case_ignore_string_PDU 2
#define          ski_printable_string_PDU 3
#define          ski_cert_pair_PDU 4
#define          ski_cert_info_PDU 5
#define          ski_cert_PDU 6
#define          ski_octetstring_PDU 7
#define          ski_bitstring_PDU 8
#define          ski_cert_version_PDU 9
#define          ski_pubkey_info_PDU 10
#define          ski_algid_PDU 11
#define          ski_cert_list_PDU 12
#define          ski_rc2_cbc_param_PDU 13
#define          INT_PDU 14
#define          ski_keypkg_info_PDU 15
#define          ski_keypkg_PDU 16
#define          ski_serv_key_info_PDU 17
#define          ski_digest_info_PDU 18
#define          ski_crl_info_PDU 19
#define          ski_pbe_param_PDU 20
#define          ski_content_info_PDU 21
#define          ski_content_info_fm_PDU 22
#define          ski_enveloped_data_PDU 23
#define          ski_encr_data_PDU 24
#define          ski_signed_data_PDU 25
#define          ski_signed_data_fm_PDU 26
#define          ski_pkcs_data_PDU 27
#define          ski_pkcs_data_fm_PDU 28
#define          ski_privkey_info_PDU 29
#define          ski_encr_privkey_info_PDU 30
#define          ski_certreq_info_PDU 31
#define          ski_certreq_PDU 32
#define          ski_challenge_pwd_PDU 33
#define          ski_email_addr_PDU 34
#define          ski_pubkey_and_challenge_PDU 35
#define          ski_signed_pubkey_and_challenge_PDU 36

typedef struct ski_oid {
    unsigned short  count;
    unsigned long   *value;
} ski_oid;

typedef struct Any {
    unsigned long   length;
    unsigned char   *value;
} Any;

typedef struct ski_rdn_seq *ski_dname;

typedef struct ski_name {
    unsigned short  choice;
#       define      distinguishedName_chosen 1
    union {
        struct ski_rdn_seq *distinguishedName;
    } u;
} ski_name;

typedef struct ski_rdn_seq {
    struct ski_rdn_seq *next;
    struct ski_rdname *value;
} *ski_rdn_seq;

typedef struct ski_rdname {
    struct ski_rdname *next;
    struct ski_ava  *value;
} *ski_rdname;

typedef Any             ski_attr_value;

typedef struct ski_ava {
    struct ski_oid *objid;
    ski_attr_value  *value;
} ski_ava;

typedef struct ski_attr_list {
    struct ski_attr_list *next;
    struct ski_attr *value;
} *ski_attr_list;

typedef struct ski_attr {
    struct ski_oid *type;
    struct ski_attr_value_set *values;
} ski_attr;

typedef struct ski_attr_value_set {
    struct ski_attr_value_set *next;
    ski_attr_value  *value;
} *ski_attr_value_set;

typedef struct CaseIgnoreString {
    unsigned short  choice;
#       define      CaseIgnoreString_t61String_chosen 1
#       define      CaseIgnoreString_printableString_chosen 2
    union {
        char            *CaseIgnoreString_t61String;
        char            *CaseIgnoreString_printableString;
    } u;
} CaseIgnoreString;

typedef CaseIgnoreString ski_case_ignore_string;

typedef char            *ski_printable_string;

typedef struct ski_cert_pair {
    struct ski_cert *forward;  /* NULL for not present */
    struct ski_cert *reverse;  /* NULL for not present */
} ski_cert_pair;

typedef struct ski_cert_serialnum {
    unsigned short  length;
    unsigned char   *value;
} ski_cert_serialnum;

typedef struct ski_cert_info {
    unsigned char   bit_mask;
#       define      version_present 0x80
#       define      extensions_present 0x40
    int             version;  /* default assumed if omitted */
#       define      version_v1 0
#       define      version_v2 1
#       define      version_v3 2
    ski_cert_serialnum serial;
    struct ski_algid *signature;
    struct ski_name *issuer;
    struct ski_validity *validity;
    struct ski_name *subject;
    struct ski_pubkey_info *pubKeyInfo;
    struct ski_uid  *issuerUID;  /* NULL for not present */
    struct ski_uid  *subjectUID;  /* NULL for not present */
    struct ski_cert_extn_list *extensions;  /* optional */
} ski_cert_info;

typedef struct ski_bitstring {
    unsigned int    length;  /* number of significant bits */
    unsigned char   *value;
} ski_bitstring;

typedef struct ski_cert {
    ski_cert_info   info;
    struct ski_algid *algorithm;
    ski_bitstring   signature;
} ski_cert;

typedef struct ski_uid {
    unsigned int    length;  /* number of significant bits */
    unsigned char   *value;
} ski_uid;

typedef struct ski_octetstring {
    unsigned int    length;
    unsigned char   *value;
} ski_octetstring;

typedef int             ski_cert_version;
#define                     CertificateVersion_v1 0
#define                     CertificateVersion_v2 1
#define                     CertificateVersion_v3 2

typedef struct ski_validity {
    UTCTime         *notBefore;
    UTCTime         *notAfter;
} ski_validity;

typedef struct ski_pubkey_info {
    struct ski_algid *algorithm;
    ski_bitstring   pubKey;
} ski_pubkey_info;

typedef Any             ski_alg_params;

typedef struct ski_algid {
    struct ski_oid *algorithm;
    ski_alg_params  *parameters;  /* NULL for not present */
} ski_algid;

typedef struct ski_cert_extn {
    unsigned char   bit_mask;
#       define      critical_present 0x80
    struct ski_oid *extend;
    ossBoolean      critical;  /* default assumed if omitted */
    ski_octetstring extnValue;
} ski_cert_extn;

typedef struct ski_cert_extn_list {
    struct ski_cert_extn_list *next;
    struct ski_cert_extn *value;
} *ski_cert_extn_list;

typedef struct ski_cert_list_contents {
    unsigned char   bit_mask;
#       define      nextUpdate_present 0x80
#       define      CertListContents_revokedCertificates_present 0x40
    ski_algid       signature;
    ski_name        issuer;
    UTCTime         thisUpdate;
    UTCTime         nextUpdate;  /* optional */
    struct _seqof1 {
        struct _seqof1  *next;
        struct {
            ski_cert_serialnum userCertificate;
            UTCTime         revocationDate;
        } value;
    } *CertListContents_revokedCertificates;  /* optional */
} ski_cert_list_contents;

typedef struct ski_cert_list {
    ski_cert_list_contents certListContents;
    ski_algid       algId;
    ski_bitstring   signature;
} ski_cert_list;

typedef struct ski_rc2_cbc_param {
    unsigned short  choice;
#       define      iv_chosen 1
#       define      sequence_chosen 2
    union {
        ski_octetstring iv;
        struct _seq1 {
            int             version;
            ski_octetstring iv;
        } sequence;
    } u;
} ski_rc2_cbc_param;

typedef int             INT;

typedef struct ski_keypkg_info {
    unsigned char   bit_mask;
#       define      keypkgAttrs_present 0x80
#       define      tKeys_present 0x40
    char            *version;
    char            *keypkgId;
    struct ski_name *owner;
    struct ski_pubkey_info *pubKeyInfo;
    struct ski_encr_privkey_info *encrPrivKeyInfo;
    struct ski_attr_list *keypkgAttrs;  /* optional */
    int             usage;
    struct ski_tkey_list *tKeys;  /* optional */
} ski_keypkg_info;

typedef struct ski_keypkg {
    ski_keypkg_info info;
    struct ski_algid *algorithm;
    ski_bitstring   signature;
} ski_keypkg;

typedef struct ski_tkey_list {
    struct ski_tkey_list *next;
    struct ski_tkey *value;
} *ski_tkey_list;

typedef struct ski_tkey {
    unsigned char   bit_mask;
#       define      TrustedKey_extensions_present 0x80
    struct ski_name *owner;
    struct ski_pubkey_info *pubKeyInfo;
    struct ski_name *issuer;  /* NULL for not present */
    struct ski_validity *validity;  /* NULL for not present */
    struct ski_cert_serialnum *serial;  /* NULL for not present */
    struct ski_cert_extn_list *TrustedKey_extensions;  /* optional */
} ski_tkey;

typedef struct ski_serv_key_info {
    Any             keyAlgId;
    int             uid;
    int             flags;
    Any             privKey;
    char            *keypkgId;
    char            *hostIP;
    Any             keypkg;
} ski_serv_key_info;

typedef struct _octet1 {
    unsigned int    length;
    unsigned char   *value;
} _octet1;

typedef struct ski_digest_info {
    struct ski_algid *digestAlgorithm;
    _octet1         digest;
} ski_digest_info;

typedef struct ski_crl_set {
    struct ski_crl_set *next;
    struct ski_crl  *value;
} *ski_crl_set;

typedef struct ski_crl_entry {
    int             userCertificate;
    UTCTime         *revocationDate;
} ski_crl_entry;

typedef struct ski_crl_info {
    unsigned char   bit_mask;
#       define      CertificateRevocationListInfo_revokedCertificates_present 0x80
    struct ski_algid *signature;
    struct ski_name *issuer;
    UTCTime         *lastUpdate;
    UTCTime         *nextUpdate;
    struct _seqof2 {
        struct _seqof2  *next;
        ski_crl_entry   value;
    } *CertificateRevocationListInfo_revokedCertificates;  /* optional */
} ski_crl_info;

typedef struct ski_crl {
    ski_crl_info    info;
    struct ski_algid *algorithm;
    ski_bitstring   signature;
} ski_crl;

typedef struct ski_pbe_param {
    struct {
        unsigned short  length;
        unsigned char   value[8];
    } salt;
    int             iterationCount;
} ski_pbe_param;

typedef struct ski_extcert_info {
    int             version;
    struct ski_cert *certificate;
    struct ski_attr_list *attributes;
} ski_extcert_info;

typedef struct ski_extcert {
    struct ski_extcert_info *extendedCertificateInfo;
    struct ski_algid *signatureAlgorithm;
    ski_bitstring   signature;
} ski_extcert;

typedef struct ski_extcerts_and_certs {
    struct ski_extcerts_and_certs *next;
    struct ski_extcert_or_cert *value;
} *ski_extcerts_and_certs;

typedef struct ski_extcert_or_cert {
    unsigned short  choice;
#       define      cert_chosen 1
#       define      extendedCert_chosen 2
    union {
        struct ski_cert *cert;
        struct ski_extcert *extendedCert;
    } u;
} ski_extcert_or_cert;

typedef Any             Content;

typedef struct ski_content_info {
    struct ski_oid *contentType;
    Content         *content;  /* NULL for not present */
} ski_content_info;

typedef struct ski_content_info_fm {
    struct ski_oid *contentType;
    Content         *content;  /* NULL for not present */
} ski_content_info_fm;

typedef struct ski_enveloped_data {
    int             version;
    struct ski_rcpt_info_list *recipientInfos;
    struct ski_encr_content_info *encryptedContentInfo;
} ski_enveloped_data;

typedef struct ski_encr_data {
    int             version;
    struct ski_encr_content_info *encryptedContentInfo;
} ski_encr_data;

typedef struct ski_signed_data {
    unsigned char   bit_mask;
#       define      SignedData_certs_present 0x80
#       define      SignedData_crls_present 0x40
    int             version;
    struct ski_digest_alg_list *digestAlgorithms;
    struct ski_content_info *contentInfo;
    struct ski_extcerts_and_certs *SignedData_certs;  /* optional */
    struct ski_crl_set *SignedData_crls;  /* optional */
    struct ski_signer_info_list *signerInfos;
} ski_signed_data;

typedef struct ski_signed_data_fm {
    unsigned char   bit_mask;
#       define      SignedDataFm_certs_present 0x80
#       define      SignedDataFm_crls_present 0x40
    int             version;
    struct ski_digest_alg_list *digestAlgorithms;
    struct ski_content_info_fm *contentInfo;
    struct ski_extcerts_and_certs *SignedDataFm_certs;  /* optional */
    struct ski_crl_set *SignedDataFm_crls;  /* optional */
    struct ski_signer_info_list *signerInfos;
} ski_signed_data_fm;

typedef struct ski_rcpt_info_list {
    struct ski_rcpt_info_list *next;
    struct ski_rcpt_info *value;
} *ski_rcpt_info_list;

typedef struct ski_encr_content_info {
    struct ski_oid *contentType;
    struct ski_algid *contentEncryptionAlgorithm;
    struct ski_encr_content *encryptedContent;  /* NULL for not present */
} ski_encr_content_info;

typedef struct ski_pkcs_data {
    unsigned int    length;
    unsigned char   *value;
} ski_pkcs_data;

typedef struct ski_pkcs_data_fm {
    unsigned int    length;
    unsigned char   *value;
} ski_pkcs_data_fm;

typedef struct ski_encr_content {
    unsigned int    length;
    unsigned char   *value;
} ski_encr_content;

typedef struct ski_rcpt_info {
    int             version;
    struct ski_issuer_and_serialnum *issuerAndSerialNumber;
    struct ski_algid *keyEncryptionAlgorithm;
    _octet1         encryptedKey;
} ski_rcpt_info;

typedef struct ski_signer_info {
    unsigned char   bit_mask;
#       define      authenticatedAttributes_present 0x80
#       define      unauthenticatedAttributes_present 0x40
    int             version;
    struct ski_issuer_and_serialnum *issuerAndSerialNumber;
    struct ski_algid *digestAlgorithm;
    struct ski_attr_list *authenticatedAttributes;  /* optional */
    struct ski_algid *digestEncryptionAlgorithm;
    _octet1         encryptedDigest;
    struct ski_attr_list *unauthenticatedAttributes;  /* optional */
} ski_signer_info;

typedef struct ski_signer_info_list {
    struct ski_signer_info_list *next;
    struct ski_signer_info *value;
} *ski_signer_info_list;

typedef struct ski_issuer_and_serialnum {
    struct ski_name *issuer;
    ski_cert_serialnum serial;
} ski_issuer_and_serialnum;

typedef struct ski_digest_alg_list {
    struct ski_digest_alg_list *next;
    struct ski_algid *value;
} *ski_digest_alg_list;

typedef struct ski_privkey_info {
    unsigned char   bit_mask;
#       define      attributes_present 0x80
    int             version;
    struct ski_algid *privateKeyAlgorithm;
    _octet1         privateKey;
    struct ski_attr_list *attributes;  /* optional */
} ski_privkey_info;

typedef struct ski_encr_privkey_info {
    struct ski_algid *encryptionAlgorithm;
    ski_octetstring encryptedData;
} ski_encr_privkey_info;

typedef struct ski_certreq_info {
    int             version;
    struct ski_name *subject;
    struct ski_pubkey_info *pubKeyInfo;
    struct ski_attr_list *attributes;
} ski_certreq_info;

typedef struct ski_certreq {
    ski_certreq_info info;
    struct ski_algid *algorithm;
    ski_bitstring   signature;
} ski_certreq;

typedef struct ski_challenge_pwd {
    unsigned short  choice;
#       define      ChallengePassword_printableString_chosen 1
#       define      ChallengePassword_t61String_chosen 2
    union {
        char            *ChallengePassword_printableString;
        char            *ChallengePassword_t61String;
    } u;
} ski_challenge_pwd;

typedef char            *ski_email_addr;

typedef struct ski_pubkey_and_challenge {
    struct ski_pubkey_info *spki;
    char            *challenge;
} ski_pubkey_and_challenge;

typedef struct ski_signed_pubkey_and_challenge {
    ski_pubkey_and_challenge pubKeyAndChallenge;
    struct ski_algid *sigAlg;
    ski_bitstring   signature;
} ski_signed_pubkey_and_challenge;


#endif /* OSS_pkcs */
