/*
 * Decompiled with CFR 0.152.
 */
package util.modal;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import util.ButtonPanel;
import util.CmdPanelInterface;
import util.Debug;
import util.Message;
import util.TabbedFocusInterface;
import util.Util;
import util.modal.DialogPanel;
import util.modal.ModalDialogInterface;

public class ModalDialog
extends Dialog {
    public boolean noted;
    ModalDialogInterface more;
    public Component body;
    String notOK = "Please make a selection or press Cancel";
    ButtonPanel buttonPanel;

    public ModalDialog(String string, Component component, String[] stringArray, ModalDialogInterface modalDialogInterface, String string2) {
        this(string, component, stringArray, modalDialogInterface, true);
        this.notOK = string2;
    }

    public ModalDialog(String string, Component component, String[] stringArray, ModalDialogInterface modalDialogInterface) {
        this(string, component, stringArray, modalDialogInterface, true);
    }

    public ModalDialog(String string, Component component, String[] stringArray, ModalDialogInterface modalDialogInterface, boolean bl) {
        super(Util.frame, string, bl);
        this.more = modalDialogInterface;
        this.setLayout(new BorderLayout());
        this.body = component;
        this.buttonPanel = new ButtonPanel();
        Button[] buttonArray = new Button[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            buttonArray[n] = new Button(stringArray[n]);
            this.buttonPanel.add(buttonArray[n]);
            this.pack();
            ++n;
        }
        this.add("Center", (Component)new DialogPanel(component));
        this.add("South", (Component)this.buttonPanel);
        this.validate();
        this.pack();
        this.buttonPanel.setButtons(buttonArray);
        if (component instanceof TabbedFocusInterface) {
            ((TabbedFocusInterface)component).setCmdPanel((CmdPanelInterface)this.buttonPanel);
            ((TabbedFocusInterface)component).setPeerFocusPanel((TabbedFocusInterface)this.buttonPanel);
            this.buttonPanel.setPeerFocusPanel((TabbedFocusInterface)component);
            ((TabbedFocusInterface)component).requestTabFocus(false);
            return;
        }
        Debug.println((String)"focus to button..");
        this.buttonPanel.requestTabFocus(false);
    }

    public void closeDialog() {
        Event event = new Event("User", 1001, "Cancel");
        this.postEvent(event);
    }

    public void setNotOKMessage(String string) {
        this.notOK = string;
    }

    public void requestFocusOnButton() {
        if (this.buttonPanel != null) {
            this.buttonPanel.requestTabFocus(false);
        }
    }

    public synchronized boolean waiterPeek() {
        return this.noted;
    }

    public synchronized boolean waiter() {
        block2: {
            if (this.noted) break block2;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.noted;
    }

    public synchronized boolean action(Event event, Object object) {
        if (event.target instanceof Button || event.target instanceof String && ((String)event.target).equals("User")) {
            if (this.more != null && !this.more.moreAction(event, object)) {
                Message.info((String)this.notOK);
                return false;
            }
            this.hide();
            Util.getFrame((Component)this).requestFocus();
            this.noted = true;
            this.notifyAll();
            return true;
        }
        return false;
    }
}

