/*
 * Decompiled with CFR 0.152.
 */
package util.modal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import util.Util;

public class ChildDialog
extends Frame {
    private boolean popup;
    private boolean modal;
    protected Component owner;
    protected Frame frame;
    protected boolean moved;
    private static Component defaultOwner;
    private boolean debugging = false;

    public static void setOwner(Component component) {
        defaultOwner = component;
    }

    public ChildDialog(Frame frame, String string, boolean bl) {
        this(defaultOwner, string, false, true);
    }

    public ChildDialog(Component component, String string, boolean bl, boolean bl2) {
        super(string);
        this.owner = component;
        this.frame = Util.getFrame((Component)component);
        this.modal = bl;
        this.popup = bl2;
        this.setFont(component.getFont());
        this.setBackground(component.getBackground());
        this.setForeground(component.getForeground());
        this.moved = false;
    }

    public ChildDialog(Component component, String string) {
        this(component, string, false, false);
    }

    public boolean isPopup() {
        return this.popup;
    }

    public void setPopup(boolean bl) {
        this.popup = bl;
    }

    public Insets insets() {
        return new Insets(40, 10, 20, 10);
    }

    public void toFront() {
        if (!this.isVisible()) {
            super.show();
        }
        super.toFront();
    }

    public void show() {
        if (this.modal) {
            this.owner.enable(false);
        }
        if (this.moved) {
            super.show();
            return;
        }
        Point point = this.frame.location();
        Dimension dimension = this.frame.size();
        Dimension dimension2 = this.size();
        int n = 0;
        int n2 = 0;
        if (point.x == 0 && point.y == 0) {
            Dimension dimension3 = this.getToolkit().getScreenSize();
            n = (dimension3.width - dimension2.width) / 2;
            n2 = (dimension3.height - dimension2.height) / 2;
        } else {
            n = point.x + (dimension.width - dimension2.width) / 2;
            n2 = point.y + (dimension.height - dimension2.height) / 2;
        }
        this.move(n, n2);
        super.show();
        this.moved = false;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            if (this.modal) {
                this.owner.enable(true);
            }
            this.hide();
        } else if (event.id == 205) {
            this.moved = true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (this.modal) {
            this.owner.enable(true);
        }
        if (this.isPopup()) {
            this.hide();
        }
        Event event2 = new Event(this, 1001, object);
        this.owner.postEvent(event2);
        return true;
    }

    private void debug(String string) {
        if (this.debugging) {
            System.err.println("ChildDialog: " + string);
        }
    }
}

