/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import util.Etching;
import util.Orientation;

public class Separator
extends Canvas {
    private static Etching _defaultEtching = Etching.IN;
    private static int _defaultThickness = 2;
    private Etching etching;
    private int thickness;

    public Separator() {
        this(_defaultThickness, _defaultEtching);
    }

    public Separator(int n) {
        this(n, _defaultEtching);
    }

    public Separator(Etching etching) {
        this(_defaultThickness, etching);
    }

    public Separator(int n, Etching etching) {
        this.etching = etching;
        this.thickness = n;
        this.resize(n, n);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        return new Dimension(this.thickness, this.thickness);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        Color color = this.getBackground().brighter().brighter();
        Color color2 = this.getBackground().darker().darker();
        if (this.etching == Etching.IN) {
            if (dimension.width > dimension.height) {
                this.paintHorizontal(graphics, dimension, color2, color);
                return;
            }
            this.paintVertical(graphics, dimension, color2, color);
            return;
        }
        if (dimension.width > dimension.height) {
            this.paintHorizontal(graphics, dimension, color, color2);
            return;
        }
        this.paintVertical(graphics, dimension, color, color2);
    }

    public String paramString() {
        Dimension dimension = this.size();
        Orientation orientation = dimension.width > dimension.height ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        return String.valueOf(super.paramString()) + "thickness=" + this.thickness + "," + this.etching + "," + orientation;
    }

    private void paintHorizontal(Graphics graphics, Dimension dimension, Color color, Color color2) {
        graphics.setColor(color);
        graphics.fillRect(0, dimension.height / 2 - this.thickness / 2, dimension.width, this.thickness / 2);
        graphics.setColor(color2);
        graphics.fillRect(0, dimension.height / 2, dimension.width, this.thickness / 2);
    }

    private void paintVertical(Graphics graphics, Dimension dimension, Color color, Color color2) {
        graphics.setColor(color);
        graphics.fillRect(dimension.width / 2 - this.thickness / 2, 0, this.thickness / 2, dimension.height);
        graphics.setColor(color2);
        graphics.fillRect(dimension.width / 2, 0, this.thickness / 2, dimension.height);
    }
}

