/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Hashtable;
import util.Debug;
import util.FieldValidationException;

public class Field {
    public String label;
    public boolean enable;
    public int wtype;
    public static final int TEXTFIELD = 0;
    public static final int CHECKBOX = 1;
    public static final int CHOICE = 2;
    public static final int PASSWORD = 3;
    public static final int TEXTAREA = 4;
    int cols;
    public String key;
    public Component w;
    public int vtype;
    public static final int NONE = 0;
    public static final int POSITIVE = 1;
    public static final int POSITIVE_M1 = 2;
    public static final int DIRNAME = 3;
    public static final int DIRSEG = 4;
    public static final int SPACEALLOWED = 5;

    public Field(String string, boolean bl, int n, String string2, int n2, int n3) {
        this.label = string;
        this.enable = bl;
        this.wtype = n;
        this.key = string2;
        this.vtype = n2;
        this.cols = n3;
    }

    public Field(String string, boolean bl, int n, String string2, int n2) {
        this(string, bl, n, string2, n2, -1);
    }

    public void widget() {
        this.w = null;
        switch (this.wtype) {
            case 1: {
                this.w = new Checkbox();
                this.w.enable(this.enable);
                return;
            }
            case 0: 
            case 3: {
                this.w = this.cols > 0 ? new TextField(this.cols) : new TextField();
                ((TextComponent)this.w).setEditable(this.enable);
                if (this.wtype != 3) break;
                ((TextField)this.w).setEchoCharacter('*');
                return;
            }
            case 2: {
                this.w = new Choice();
                return;
            }
            default: {
                Debug.println((String)("UNKNOWN Field widget(): " + this.wtype));
            }
        }
    }

    public void load(Hashtable hashtable, boolean bl, boolean bl2) {
        String string = (String)hashtable.get(this.key);
        boolean bl3 = this.enable && bl;
        switch (this.wtype) {
            case 1: {
                ((Checkbox)this.w).setState(string.equals("yes"));
                this.w.enable(bl3);
                return;
            }
            case 0: 
            case 3: 
            case 4: {
                if (string == null) {
                    ((TextComponent)((TextField)this.w)).setText("");
                } else if (this.key.equals("ip_address") && string.equals("0.0.0.0")) {
                    ((TextComponent)((TextField)this.w)).setText("All");
                } else if (this.key.equals("host_info_name") && string.equals("Host")) {
                    ((TextComponent)((TextField)this.w)).setText("default host");
                } else {
                    ((TextComponent)((TextField)this.w)).setText(string);
                }
                ((TextComponent)this.w).setEditable(bl3);
                return;
            }
            case 2: {
                ((Choice)this.w).select(string);
                return;
            }
        }
        Debug.println((String)("UNKNOWN load: " + this.wtype));
    }

    public void validateInput(Hashtable hashtable) throws FieldValidationException {
        String string;
        if (this.wtype == 0 && this.vtype != 5 && (string = ((TextField)this.w).getText()).length() > 0 && string.indexOf(" ") >= 0) {
            throw new FieldValidationException(String.valueOf(this.label) + " cannot contain spaces.");
        }
        int n = 0;
        boolean bl = true;
        switch (this.vtype) {
            case 1: 
            case 2: {
                try {
                    n = Integer.parseInt(((TextField)this.w).getText());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (n != 0 && n >= -1 && (n != -1 || this.vtype != 1)) break;
                bl = false;
                break;
            }
        }
        if (!bl) {
            throw new FieldValidationException(this);
        }
    }

    void validateAndStore(Hashtable hashtable) throws FieldValidationException {
        if (this.w instanceof TextField && !((TextField)this.w).isEditable()) {
            return;
        }
        if (!this.enable) {
            return;
        }
        if (!this.valueChanged(hashtable)) {
            return;
        }
        this.validateInput(hashtable);
        this.store(hashtable);
    }

    public void store(Hashtable hashtable) {
        String string = null;
        switch (this.wtype) {
            case 0: 
            case 3: 
            case 4: {
                string = ((TextComponent)this.w).getText();
                break;
            }
            case 1: {
                string = ((Checkbox)this.w).getState() ? "yes" : "no";
                break;
            }
            case 2: {
                string = ((Choice)this.w).getSelectedItem();
                break;
            }
        }
        hashtable.put(this.key, string);
    }

    public boolean valueChanged(Hashtable hashtable) {
        return true;
    }
}

